/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ReverseBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    Set<String> initPolicies;

    ReverseBuilder(PKIXBuilderParameters buildParams, X500Principal targetSubjectDN) {
        super(buildParams, targetSubjectDN);
        Set<String> initialPolicies = buildParams.getInitialPolicies();
        this.initPolicies = new HashSet<String>();
        if (initialPolicies.isEmpty()) {
            this.initPolicies.add("2.5.29.32.0");
        } else {
            for (String policy : initialPolicies) {
                this.initPolicies.add(policy);
            }
        }
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State currState, List<CertStore> certStores) throws CertStoreException, CertificateException, IOException {
        ReverseState currentState = (ReverseState)currState;
        if (this.debug != null) {
            this.debug.println("In ReverseBuilder.getMatchingCerts.");
        }
        Collection<X509Certificate> certs = this.getMatchingEECerts(currentState, certStores);
        certs.addAll(this.getMatchingCACerts(currentState, certStores));
        return certs;
    }

    private Collection<X509Certificate> getMatchingEECerts(ReverseState currentState, List<CertStore> certStores) throws CertStoreException, CertificateException, IOException {
        X509CertSelector sel = (X509CertSelector)this.targetCertConstraints.clone();
        sel.setIssuer(currentState.subjectDN);
        sel.setCertificateValid(this.date);
        if (currentState.explicitPolicy == 0) {
            sel.setPolicy(this.getMatchingPolicies());
        }
        sel.setBasicConstraints(-2);
        HashSet<X509Certificate> eeCerts = new HashSet<X509Certificate>();
        this.addMatchingCerts(sel, certStores, eeCerts, true);
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingEECerts got " + eeCerts.size() + " certs.");
        }
        return eeCerts;
    }

    private Collection<X509Certificate> getMatchingCACerts(ReverseState currentState, List<CertStore> certStores) throws CertificateException, CertStoreException, IOException {
        X509CertSelector sel = new X509CertSelector();
        sel.setIssuer(currentState.subjectDN);
        sel.setCertificateValid(this.date);
        sel.addPathToName(4, this.targetCertConstraints.getSubjectAsBytes());
        if (currentState.explicitPolicy == 0) {
            sel.setPolicy(this.getMatchingPolicies());
        }
        sel.setBasicConstraints(0);
        ArrayList<X509Certificate> reverseCerts = new ArrayList<X509Certificate>();
        this.addMatchingCerts(sel, certStores, reverseCerts, true);
        Collections.sort(reverseCerts, new PKIXCertComparator());
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingCACerts got " + reverseCerts.size() + " certs.");
        }
        return reverseCerts;
    }

    @Override
    void verifyCert(X509Certificate cert, State currState, List<X509Certificate> certPathList) throws GeneralSecurityException {
        boolean caCert;
        ReverseState currentState;
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.verifyCert(SN: " + Debug.toHexString(cert.getSerialNumber()) + "\n  Subject: " + cert.getSubjectX500Principal() + ")");
        }
        if ((currentState = (ReverseState)currState).isInitial()) {
            return;
        }
        currentState.untrustedChecker.check(cert, Collections.emptySet());
        if (certPathList != null && !certPathList.isEmpty()) {
            ArrayList<X509Certificate> reverseCertList = new ArrayList<X509Certificate>();
            for (X509Certificate c : certPathList) {
                reverseCertList.add(0, c);
            }
            boolean policyMappingFound = false;
            for (X509Certificate cpListCert : reverseCertList) {
                X509CertImpl cpListCertImpl = X509CertImpl.toImpl(cpListCert);
                PolicyMappingsExtension policyMappingsExt = cpListCertImpl.getPolicyMappingsExtension();
                if (policyMappingsExt != null) {
                    policyMappingFound = true;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + policyMappingFound);
                }
                if (!cert.equals(cpListCert) || !this.buildParams.isPolicyMappingInhibited() && policyMappingFound) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        boolean finalCert = cert.getSubjectX500Principal().equals(this.targetSubjectDN);
        boolean bl = caCert = cert.getBasicConstraints() != -1;
        if (!finalCert) {
            if (!caCert) {
                throw new CertPathValidatorException("cert is NOT a CA cert");
            }
            if (currentState.remainingCACerts <= 0 && !X509CertImpl.isSelfIssued(cert)) {
                throw new CertPathValidatorException("pathLenConstraint violated, path too long", null, null, -1, PKIXReason.PATH_TOO_LONG);
            }
            KeyChecker.verifyCAKeyUsage(cert);
        } else if (!this.targetCertConstraints.match(cert)) {
            throw new CertPathValidatorException("target certificate constraints check failed");
        }
        if (this.buildParams.isRevocationEnabled()) {
            currentState.crlChecker.check(cert, currentState.pubKey, currentState.crlSign);
        }
        if ((finalCert || !X509CertImpl.isSelfIssued(cert)) && currentState.nc != null) {
            try {
                if (!currentState.nc.verify(cert)) {
                    throw new CertPathValidatorException("name constraints check failed", null, null, -1, PKIXReason.INVALID_NAME);
                }
            }
            catch (IOException ioe) {
                throw new CertPathValidatorException(ioe);
            }
        }
        X509CertImpl certImpl = X509CertImpl.toImpl(cert);
        currentState.rootNode = PolicyChecker.processPolicies(currentState.certIndex, this.initPolicies, currentState.explicitPolicy, currentState.policyMapping, currentState.inhibitAnyPolicy, this.buildParams.getPolicyQualifiersRejected(), currentState.rootNode, certImpl, finalCert);
        Set<String> unresolvedCritExts = cert.getCriticalExtensionOIDs();
        if (unresolvedCritExts == null) {
            unresolvedCritExts = Collections.emptySet();
        }
        currentState.algorithmChecker.check(cert, unresolvedCritExts);
        for (PKIXCertPathChecker checker : currentState.userCheckers) {
            checker.check(cert, unresolvedCritExts);
        }
        if (!unresolvedCritExts.isEmpty()) {
            unresolvedCritExts.remove(PKIXExtensions.BasicConstraints_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.NameConstraints_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.PolicyMappings_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.KeyUsage_Id.toString());
            unresolvedCritExts.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            if (!unresolvedCritExts.isEmpty()) {
                throw new CertPathValidatorException("Unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
            }
        }
        if (this.buildParams.getSigProvider() != null) {
            cert.verify(currentState.pubKey, this.buildParams.getSigProvider());
        } else {
            cert.verify(currentState.pubKey);
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate cert) {
        return cert.getSubjectX500Principal().equals(this.targetSubjectDN);
    }

    @Override
    void addCertToPath(X509Certificate cert, LinkedList<X509Certificate> certPathList) {
        certPathList.addLast(cert);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> certPathList) {
        certPathList.removeLast();
    }

    class PKIXCertComparator
    implements Comparator<X509Certificate> {
        private Debug debug = Debug.getInstance("certpath");

        PKIXCertComparator() {
        }

        @Override
        public int compare(X509Certificate cert1, X509Certificate cert2) {
            int targetDist2;
            int targetDist1;
            if (cert1.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return -1;
            }
            if (cert2.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return 1;
            }
            try {
                X500Name targetSubjectName = X500Name.asX500Name(ReverseBuilder.this.targetSubjectDN);
                targetDist1 = Builder.targetDistance(null, cert1, targetSubjectName);
                targetDist2 = Builder.targetDistance(null, cert2, targetSubjectName);
            }
            catch (IOException e) {
                if (this.debug != null) {
                    this.debug.println("IOException in call to Builder.targetDistance");
                    e.printStackTrace();
                }
                throw new ClassCastException("Invalid target subject distinguished name");
            }
            if (targetDist1 == targetDist2) {
                return 0;
            }
            if (targetDist1 == -1) {
                return 1;
            }
            if (targetDist1 < targetDist2) {
                return -1;
            }
            return 1;
        }
    }
}

