/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.provider.X509Factory;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.CRLExtensions;
import sun.security.x509.CRLNumberExtension;
import sun.security.x509.CertificateIssuerExtension;
import sun.security.x509.DeltaCRLIndicatorExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.OIDMap;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;

public class X509CRLImpl
extends X509CRL
implements DerEncoder {
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer = null;
    private X500Principal issuerPrincipal = null;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Map<X509IssuerSerial, X509CRLEntry> revokedMap = new TreeMap<X509IssuerSerial, X509CRLEntry>();
    private List<X509CRLEntry> revokedList = new LinkedList<X509CRLEntry>();
    private CRLExtensions extensions = null;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;

    private X509CRLImpl() {
    }

    public X509CRLImpl(byte[] crlData) throws CRLException {
        try {
            this.parse(new DerValue(crlData));
        }
        catch (IOException e) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(DerValue val) throws CRLException {
        try {
            this.parse(val);
        }
        catch (IOException e) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(InputStream inStrm) throws CRLException {
        try {
            this.parse(new DerValue(inStrm));
        }
        catch (IOException e) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate) {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts) throws CRLException {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
        if (badCerts != null) {
            X500Principal crlIssuer;
            X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < badCerts.length; ++i) {
                X509CRLEntryImpl badCert = (X509CRLEntryImpl)badCerts[i];
                try {
                    badCertIssuer = this.getCertIssuer(badCert, badCertIssuer);
                }
                catch (IOException ioe) {
                    throw new CRLException(ioe);
                }
                badCert.setCertificateIssuer(crlIssuer, badCertIssuer);
                X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, badCert.getSerialNumber());
                this.revokedMap.put(issuerSerial, badCert);
                this.revokedList.add(badCert);
                if (!badCert.hasExtensions()) continue;
                this.version = 1;
            }
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts, CRLExtensions crlExts) throws CRLException {
        this(issuer, thisDate, nextDate, badCerts);
        if (crlExts != null) {
            this.extensions = crlExts;
            this.version = 1;
        }
    }

    public byte[] getEncodedInternal() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        return this.signedCRL;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public void encodeInfo(OutputStream out) throws CRLException {
        try {
            DerOutputStream tmp = new DerOutputStream();
            DerOutputStream rCerts = new DerOutputStream();
            DerOutputStream seq = new DerOutputStream();
            if (this.version != 0) {
                tmp.putInteger(this.version);
            }
            this.infoSigAlgId.encode(tmp);
            if (this.version == 0 && this.issuer.toString() == null) {
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(tmp);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                tmp.putUTCTime(this.thisUpdate);
            } else {
                tmp.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    tmp.putUTCTime(this.nextUpdate);
                } else {
                    tmp.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedList.isEmpty()) {
                for (X509CRLEntry entry : this.revokedList) {
                    ((X509CRLEntryImpl)entry).encode(rCerts);
                }
                tmp.write((byte)48, rCerts);
            }
            if (this.extensions != null) {
                this.extensions.encode(tmp, true);
            }
            seq.write((byte)48, tmp);
            this.tbsCertList = seq.toByteArray();
            out.write(this.tbsCertList);
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.getMessage());
        }
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "");
    }

    @Override
    public synchronized void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            return;
        }
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature sigVerf = null;
        sigVerf = sigProvider.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), sigProvider);
        sigVerf.initVerify(key);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
    }

    public void sign(PrivateKey key, String algorithm) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(key, algorithm, null);
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature sigEngine = null;
            sigEngine = provider == null || provider.length() == 0 ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            sigEngine.initSign(key);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(sigEngine.getAlgorithm());
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            this.encodeInfo(tmp);
            this.sigAlgId.encode(tmp);
            sigEngine.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCRL = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            throw new CRLException("Error while encoding data: " + e.getMessage());
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X.509 CRL v" + (this.version + 1) + "\n");
        if (this.sigAlgId != null) {
            sb.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\n");
        }
        if (this.issuer != null) {
            sb.append("Issuer: " + this.issuer.toString() + "\n");
        }
        if (this.thisUpdate != null) {
            sb.append("\nThis Update: " + this.thisUpdate.toString() + "\n");
        }
        if (this.nextUpdate != null) {
            sb.append("Next Update: " + this.nextUpdate.toString() + "\n");
        }
        if (this.revokedList.isEmpty()) {
            sb.append("\nNO certificates have been revoked\n");
        } else {
            sb.append("\nRevoked Certificates: " + this.revokedList.size());
            int i = 1;
            for (X509CRLEntry entry : this.revokedList) {
                sb.append("\n[" + i++ + "] " + entry.toString());
            }
        }
        if (this.extensions != null) {
            Collection<Extension> allExts = this.extensions.getAllExtensions();
            Object[] objs = allExts.toArray();
            sb.append("\nCRL Extensions: " + objs.length);
            for (int i = 0; i < objs.length; ++i) {
                sb.append("\n[" + (i + 1) + "]: ");
                Extension ext = (Extension)objs[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: DER encoded OCTET string =\n" + enc.encodeBuffer(extValue) + "\n");
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            sb.append("\nSignature:\n" + encoder.encodeBuffer(this.signature) + "\n");
        } else {
            sb.append("NOT signed yet\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (this.revokedMap.isEmpty() || !(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate xcert = (X509Certificate)cert;
        X509IssuerSerial issuerSerial = new X509IssuerSerial(xcert);
        return this.revokedMap.containsKey(issuerSerial);
    }

    @Override
    public int getVersion() {
        return this.version + 1;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuerPrincipal == null) {
            this.issuerPrincipal = this.issuer.asX500Principal();
        }
        return this.issuerPrincipal;
    }

    @Override
    public Date getThisUpdate() {
        return new Date(this.thisUpdate.getTime());
    }

    @Override
    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (this.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(this.getIssuerX500Principal(), serialNumber);
        return this.revokedMap.get(issuerSerial);
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate cert) {
        if (this.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(cert);
        return this.revokedMap.get(issuerSerial);
    }

    public Set<X509CRLEntry> getRevokedCertificates() {
        if (this.revokedList.isEmpty()) {
            return null;
        }
        return new TreeSet<X509CRLEntry>(this.revokedList);
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        byte[] dup = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, dup, 0, dup.length);
        return dup;
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] dup = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, dup, 0, dup.length);
        return dup;
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier oid = this.sigAlgId.getOID();
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgId == null) {
            return null;
        }
        try {
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException e) {
            return null;
        }
    }

    public AlgorithmId getSigAlgId() {
        return this.sigAlgId;
    }

    public KeyIdentifier getAuthKeyId() throws IOException {
        AuthorityKeyIdentifierExtension aki = this.getAuthKeyIdExtension();
        if (aki != null) {
            KeyIdentifier keyId = (KeyIdentifier)aki.get("key_id");
            return keyId;
        }
        return null;
    }

    public AuthorityKeyIdentifierExtension getAuthKeyIdExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.AuthorityKey_Id);
        return (AuthorityKeyIdentifierExtension)obj;
    }

    public CRLNumberExtension getCRLNumberExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.CRLNumber_Id);
        return (CRLNumberExtension)obj;
    }

    public BigInteger getCRLNumber() throws IOException {
        CRLNumberExtension numExt = this.getCRLNumberExtension();
        if (numExt != null) {
            BigInteger num = (BigInteger)numExt.get("value");
            return num;
        }
        return null;
    }

    public DeltaCRLIndicatorExtension getDeltaCRLIndicatorExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.DeltaCRLIndicator_Id);
        return (DeltaCRLIndicatorExtension)obj;
    }

    public BigInteger getBaseCRLNumber() throws IOException {
        DeltaCRLIndicatorExtension dciExt = this.getDeltaCRLIndicatorExtension();
        if (dciExt != null) {
            BigInteger num = (BigInteger)dciExt.get("value");
            return num;
        }
        return null;
    }

    public IssuerAlternativeNameExtension getIssuerAltNameExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
        return (IssuerAlternativeNameExtension)obj;
    }

    public IssuingDistributionPointExtension getIssuingDistributionPointExtension() throws IOException {
        Object obj = this.getExtension(PKIXExtensions.IssuingDistributionPoint_Id);
        return (IssuingDistributionPointExtension)obj;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try {
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getExtension(ObjectIdentifier oid) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(OIDMap.getName(oid));
    }

    private void parse(DerValue val) throws CRLException, IOException {
        DerValue tmp;
        AlgorithmId tmpId;
        if (this.readOnly) {
            throw new CRLException("cannot over-write existing CRL");
        }
        if (val.getData() == null || val.tag != 48) {
            throw new CRLException("Invalid DER-encoded CRL data");
        }
        this.signedCRL = val.toByteArray();
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + val.data.available());
        }
        if (seq[0].tag != 48) {
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = seq[0].toByteArray();
        DerInputStream derStrm = seq[0].data;
        this.version = 0;
        byte nextByte = (byte)derStrm.peekByte();
        if (nextByte == 2) {
            this.version = derStrm.getInteger();
            if (this.version != 1) {
                throw new CRLException("Invalid version");
            }
        }
        if (!(tmpId = AlgorithmId.parse(tmp = derStrm.getDerValue())).equals(this.sigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = tmpId;
        this.issuer = new X500Name(derStrm);
        if (this.issuer.isEmpty()) {
            throw new CRLException("Empty issuer DN not allowed in X509CRLs");
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.thisUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.thisUpdate = derStrm.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + nextByte + ")");
        }
        if (derStrm.available() == 0) {
            return;
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.nextUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.nextUpdate = derStrm.getGeneralizedTime();
        }
        if (derStrm.available() == 0) {
            return;
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 48 && (nextByte & 0xC0) != 128) {
            X500Principal crlIssuer;
            DerValue[] badCerts = derStrm.getSequence(4);
            X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < badCerts.length; ++i) {
                X509CRLEntryImpl entry = new X509CRLEntryImpl(badCerts[i]);
                badCertIssuer = this.getCertIssuer(entry, badCertIssuer);
                entry.setCertificateIssuer(crlIssuer, badCertIssuer);
                X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, entry.getSerialNumber());
                this.revokedMap.put(issuerSerial, entry);
                this.revokedList.add(entry);
            }
        }
        if (derStrm.available() == 0) {
            return;
        }
        tmp = derStrm.getDerValue();
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)0)) {
            this.extensions = new CRLExtensions(tmp.data);
        }
        this.readOnly = true;
    }

    public static X500Principal getIssuerX500Principal(X509CRL crl) {
        try {
            byte[] encoded = crl.getEncoded();
            DerInputStream derIn = new DerInputStream(encoded);
            DerValue tbsCert = derIn.getSequence(3)[0];
            DerInputStream tbsIn = tbsCert.data;
            byte nextByte = (byte)tbsIn.peekByte();
            if (nextByte == 2) {
                DerValue derValue = tbsIn.getDerValue();
            }
            DerValue tmp = tbsIn.getDerValue();
            tmp = tbsIn.getDerValue();
            byte[] principalBytes = tmp.toByteArray();
            return new X500Principal(principalBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse issuer", e);
        }
    }

    public static byte[] getEncodedInternal(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return ((X509CRLImpl)crl).getEncodedInternal();
        }
        return crl.getEncoded();
    }

    public static X509CRLImpl toImpl(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return (X509CRLImpl)crl;
        }
        return X509Factory.intern(crl);
    }

    private X500Principal getCertIssuer(X509CRLEntryImpl entry, X500Principal prevCertIssuer) throws IOException {
        CertificateIssuerExtension ciExt = entry.getCertificateIssuerExtension();
        if (ciExt != null) {
            GeneralNames names = (GeneralNames)ciExt.get("issuer");
            X500Name issuerDN = (X500Name)names.get(0).getName();
            return issuerDN.asX500Principal();
        }
        return prevCertIssuer;
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (this.signedCRL == null) {
            throw new IOException("Null CRL to encode");
        }
        out.write((byte[])this.signedCRL.clone());
    }

    private static final class X509IssuerSerial
    implements Comparable<X509IssuerSerial> {
        final X500Principal issuer;
        final BigInteger serial;
        volatile int hashcode = 0;

        X509IssuerSerial(X500Principal issuer, BigInteger serial) {
            this.issuer = issuer;
            this.serial = serial;
        }

        X509IssuerSerial(X509Certificate cert) {
            this(cert.getIssuerX500Principal(), cert.getSerialNumber());
        }

        X500Principal getIssuer() {
            return this.issuer;
        }

        BigInteger getSerial() {
            return this.serial;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509IssuerSerial)) {
                return false;
            }
            X509IssuerSerial other = (X509IssuerSerial)o;
            return this.serial.equals(other.getSerial()) && this.issuer.equals(other.getIssuer());
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                int result = 17;
                result = 37 * result + this.issuer.hashCode();
                this.hashcode = result = 37 * result + this.serial.hashCode();
            }
            return this.hashcode;
        }

        @Override
        public int compareTo(X509IssuerSerial another) {
            int cissuer = this.issuer.toString().compareTo(another.issuer.toString());
            if (cissuer != 0) {
                return cissuer;
            }
            return this.serial.compareTo(another.serial);
        }
    }
}

