/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.logging.PlatformLogger;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class LocaleServiceProviderPool {
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool>();
    private Set<LocaleServiceProvider> providers = new LinkedHashSet<LocaleServiceProvider>();
    private Map<Locale, LocaleServiceProvider> providersCache = new ConcurrentHashMap<Locale, LocaleServiceProvider>();
    private Set<Locale> availableLocales = null;
    private static volatile List<Locale> availableJRELocales = null;
    private Set<Locale> providerLocales = null;
    private static Locale locale_ja_JP_JP = new Locale("ja", "JP", "JP");
    private static Locale locale_th_TH_TH = new Locale("th", "TH", "TH");

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> providerClass) {
        LocaleServiceProviderPool newPool;
        LocaleServiceProviderPool pool = (LocaleServiceProviderPool)poolOfPools.get(providerClass);
        if (pool == null && (pool = poolOfPools.putIfAbsent(providerClass, newPool = new LocaleServiceProviderPool(providerClass))) == null) {
            pool = newPool;
        }
        return pool;
    }

    private LocaleServiceProviderPool(final Class<? extends LocaleServiceProvider> c) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    for (LocaleServiceProvider provider : ServiceLoader.loadInstalled(c)) {
                        LocaleServiceProviderPool.this.providers.add(provider);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            LocaleServiceProviderPool.config(e.toString());
        }
    }

    private static void config(String message) {
        PlatformLogger logger = PlatformLogger.getLogger("sun.util.LocaleServiceProviderPool");
        logger.config(message);
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public synchronized Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>(this.getJRELocales());
            if (this.hasProviders()) {
                this.availableLocales.addAll(this.getProviderLocales());
            }
        }
        Locale[] tmp = new Locale[this.availableLocales.size()];
        this.availableLocales.toArray(tmp);
        return tmp;
    }

    private synchronized Set<Locale> getProviderLocales() {
        if (this.providerLocales == null) {
            this.providerLocales = new HashSet<Locale>();
            if (this.hasProviders()) {
                for (LocaleServiceProvider lsp : this.providers) {
                    Locale[] locales;
                    for (Locale locale : locales = lsp.getAvailableLocales()) {
                        this.providerLocales.add(LocaleServiceProviderPool.getLookupLocale(locale));
                    }
                }
            }
        }
        return this.providerLocales;
    }

    public boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Locale> getJRELocales() {
        if (availableJRELocales != null) return availableJRELocales;
        Class<LocaleServiceProviderPool> clazz = LocaleServiceProviderPool.class;
        synchronized (LocaleServiceProviderPool.class) {
            if (availableJRELocales != null) return availableJRELocales;
            Locale[] allLocales = LocaleData.getAvailableLocales();
            ArrayList<Locale> tmpList = new ArrayList<Locale>(allLocales.length);
            for (Locale locale : allLocales) {
                tmpList.add(LocaleServiceProviderPool.getLookupLocale(locale));
            }
            availableJRELocales = tmpList;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return availableJRELocales;
        }
    }

    private boolean isJRESupported(Locale locale) {
        List<Locale> locales = this.getJRELocales();
        return locales.contains(LocaleServiceProviderPool.getLookupLocale(locale));
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, true, null, null, null, params);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, OpenListResourceBundle bundle, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, null, bundle, key, params);
    }

    public <P, S> S getLocalizedObject(LocalizedObjectGetter<P, S> getter, Locale locale, String bundleKey, OpenListResourceBundle bundle, String key, Object ... params) {
        return this.getLocalizedObjectImpl(getter, locale, false, bundleKey, bundle, key, params);
    }

    private <P, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> getter, Locale locale, boolean isObjectProvider, String bundleKey, OpenListResourceBundle bundle, String key, Object ... params) {
        if (this.hasProviders()) {
            if (bundleKey == null) {
                bundleKey = key;
            }
            Locale bundleLocale = bundle != null ? bundle.getLocale() : null;
            List<Locale> lookupLocales = LocaleServiceProviderPool.getLookupLocales(locale);
            S providersObj = null;
            Set<Locale> provLoc = this.getProviderLocales();
            for (int i = 0; i < lookupLocales.size(); ++i) {
                LocaleServiceProvider lsp;
                Locale current = lookupLocales.get(i);
                if (bundleLocale == null ? this.isJRESupported(current) : current.equals(bundleLocale)) break;
                if (!provLoc.contains(current) || (lsp = this.findProvider(current)) == null) continue;
                providersObj = getter.getObject(lsp, locale, key, params);
                if (providersObj != null) {
                    return providersObj;
                }
                if (!isObjectProvider) continue;
                LocaleServiceProviderPool.config("A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + lsp + " locale: " + locale);
            }
            while (bundle != null) {
                bundleLocale = bundle.getLocale();
                if (bundle.handleGetKeys().contains(bundleKey)) {
                    return null;
                }
                LocaleServiceProvider lsp = this.findProvider(bundleLocale);
                if (lsp != null && (providersObj = (S)getter.getObject(lsp, locale, key, params)) != null) {
                    return providersObj;
                }
                bundle = bundle.getParent();
            }
        }
        return null;
    }

    private LocaleServiceProvider findProvider(Locale locale) {
        if (!this.hasProviders()) {
            return null;
        }
        if (this.providersCache.containsKey(locale)) {
            LocaleServiceProvider provider = this.providersCache.get(locale);
            if (provider != NullProvider.INSTANCE) {
                return provider;
            }
        } else {
            for (LocaleServiceProvider lsp : this.providers) {
                Locale[] locales;
                for (Locale available : locales = lsp.getAvailableLocales()) {
                    if (!locale.equals(available = LocaleServiceProviderPool.getLookupLocale(available))) continue;
                    LocaleServiceProvider providerInCache = this.providersCache.put(locale, lsp);
                    return providerInCache != null ? providerInCache : lsp;
                }
            }
            this.providersCache.put(locale, NullProvider.INSTANCE);
        }
        return null;
    }

    private static List<Locale> getLookupLocales(Locale locale) {
        List<Locale> lookupLocales = new ResourceBundle.Control(){}.getCandidateLocales("", locale);
        return lookupLocales;
    }

    private static Locale getLookupLocale(Locale locale) {
        Locale lookupLocale = locale;
        Set<Character> extensions = locale.getExtensionKeys();
        if (!(extensions.isEmpty() || locale.equals(locale_ja_JP_JP) || locale.equals(locale_th_TH_TH))) {
            Locale.Builder locbld = new Locale.Builder();
            try {
                locbld.setLocale(locale);
                locbld.clearExtensions();
                lookupLocale = locbld.build();
            }
            catch (IllformedLocaleException e) {
                LocaleServiceProviderPool.config("A locale(" + locale + ") has non-empty extensions, but has illformed fields.");
                lookupLocale = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
        }
        return lookupLocale;
    }

    public static interface LocalizedObjectGetter<P, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }

    private static class NullProvider
    extends LocaleServiceProvider {
        private static final NullProvider INSTANCE = new NullProvider();

        private NullProvider() {
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new RuntimeException("Should not get called.");
        }
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            Class[] providerClasses = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class};
            Locale[] allLocales = LocaleData.getAvailableLocales();
            HashSet<Locale> all = new HashSet<Locale>(allLocales.length);
            for (Locale locale : allLocales) {
                all.add(LocaleServiceProviderPool.getLookupLocale(locale));
            }
            for (Serializable serializable : providerClasses) {
                LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool((Class<? extends LocaleServiceProvider>)serializable);
                all.addAll(pool.getProviderLocales());
            }
            allAvailableLocales = all.toArray(new Locale[0]);
        }
    }
}

