/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        byte[] content;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (ObjectOutputStream a = new ObjectOutputStream(b);){
            a.writeObject(object);
            a.flush();
            content = b.toByteArray();
        }
        try {
            this.encryptedContent = c.doFinal(content);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (c.getParameters() != null) {
            this.encodedParams = c.getParameters().getEncoded();
            this.paramsAlg = c.getParameters().getAlgorithm();
        }
        this.sealAlg = c.getAlgorithm();
    }

    protected SealedObject(SealedObject so) {
        this.encryptedContent = (byte[])so.encryptedContent.clone();
        this.sealAlg = so.sealAlg;
        this.paramsAlg = so.paramsAlg;
        this.encodedParams = (byte[])(so.encodedParams != null ? (byte[])so.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            return this.unseal(key, null);
        }
        catch (NoSuchProviderException nspe) {
            throw new NoSuchAlgorithmException("algorithm not found");
        }
        catch (IllegalBlockSizeException ibse) {
            throw new InvalidKeyException(ibse.getMessage());
        }
        catch (BadPaddingException bpe) {
            throw new InvalidKeyException(bpe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher c) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        byte[] content = c.doFinal(this.encryptedContent);
        ByteArrayInputStream b = new ByteArrayInputStream(content);
        try (extObjectInputStream a = new extObjectInputStream(b);){
            Object obj;
            Object object = obj = a.readObject();
            return object;
        }
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            return this.unseal(key, provider);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new InvalidKeyException(ibse.getMessage());
        }
        catch (BadPaddingException bpe) {
            throw new InvalidKeyException(bpe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unseal(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c;
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            try {
                params = provider != null ? AlgorithmParameters.getInstance(this.paramsAlg, provider) : AlgorithmParameters.getInstance(this.paramsAlg);
            }
            catch (NoSuchProviderException nspe) {
                if (provider == null) {
                    throw new NoSuchAlgorithmException(this.paramsAlg + " not found");
                }
                throw new NoSuchProviderException(nspe.getMessage());
            }
            params.init(this.encodedParams);
        }
        try {
            c = provider != null ? Cipher.getInstance(this.sealAlg, provider) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException nspe) {
            throw new NoSuchAlgorithmException("Padding that was used in sealing operation not available");
        }
        catch (NoSuchProviderException nspe) {
            if (provider == null) {
                throw new NoSuchAlgorithmException(this.sealAlg + " not found");
            }
            throw new NoSuchProviderException(nspe.getMessage());
        }
        try {
            if (params != null) {
                c.init(2, key, params);
            } else {
                c.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException(iape.getMessage());
        }
        byte[] content = c.doFinal(this.encryptedContent);
        ByteArrayInputStream b = new ByteArrayInputStream(content);
        try (extObjectInputStream a = new extObjectInputStream(b);){
            Object obj;
            Object object = obj = a.readObject();
            return object;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }
}

