/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Certificate
extends SignatureElementProxy
implements XMLX509DataContent {
    public static final String JCA_CERT_ID = "X.509";

    public XMLX509Certificate(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public XMLX509Certificate(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509Certificate(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        try {
            this.addBase64Text(x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new XMLSecurityException("empty", certificateEncodingException);
        }
    }

    public byte[] getCertificateBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public X509Certificate getX509Certificate() throws XMLSecurityException {
        try {
            byte[] byArray = this.getCertificateBytes();
            CertificateFactory certificateFactory = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            if (x509Certificate != null) {
                return x509Certificate;
            }
            return null;
        }
        catch (CertificateException certificateException) {
            throw new XMLSecurityException("empty", certificateException);
        }
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        X509Certificate x509Certificate = this.getX509Certificate();
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XMLX509Certificate)) {
            return false;
        }
        XMLX509Certificate xMLX509Certificate = (XMLX509Certificate)object;
        try {
            return Arrays.equals(xMLX509Certificate.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public int hashCode() {
        int n;
        block3: {
            n = 17;
            try {
                byte[] byArray = this.getCertificateBytes();
                for (int i = 0; i < byArray.length; ++i) {
                    n = 31 * n + byArray[i];
                }
            }
            catch (XMLSecurityException xMLSecurityException) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, xMLSecurityException.getMessage(), xMLSecurityException);
            }
        }
        return n;
    }

    @Override
    public String getBaseLocalName() {
        return "X509Certificate";
    }
}

