/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEFactory;

public class JSSEImplementation
extends SSLImplementation {
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    static Log logger = LogFactory.getLog(JSSEImplementation.class);
    private JSSEFactory factory = null;

    public JSSEImplementation() throws ClassNotFoundException {
        Class.forName(SSLSocketClass);
        this.factory = new JSSEFactory();
    }

    public String getImplementationName() {
        return "JSSE";
    }

    public ServerSocketFactory getServerSocketFactory() {
        ServerSocketFactory ssf = this.factory.getSocketFactory();
        return ssf;
    }

    public ServerSocketFactory getServerSocketFactory(String sslProtocol) {
        ServerSocketFactory ssf = this.factory.getSocketFactory(sslProtocol);
        return ssf;
    }

    public SSLSupport getSSLSupport(Socket s) {
        SSLSupport ssls = this.factory.getSSLSupport(s);
        return ssls;
    }

    public SSLSupport getSSLSupport(SSLSession session) {
        SSLSupport ssls = this.factory.getSSLSupport(session);
        return ssls;
    }
}

