/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.naming.StringManager;

public class ClasspathURLStreamHandler
extends URLStreamHandler {
    private static final StringManager sm = StringManager.getManager("org.apache.naming.resources");

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String path = u.getPath();
        URL classpathUrl = Thread.currentThread().getContextClassLoader().getResource(path);
        if (classpathUrl == null) {
            classpathUrl = ClasspathURLStreamHandler.class.getResource(path);
        }
        if (classpathUrl == null) {
            throw new FileNotFoundException(sm.getString("classpathUrlStreamHandler.notFound", u));
        }
        return classpathUrl.openConnection();
    }
}

