/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.actions.CloseModeAction;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CollapseTabGroupAction
extends AbstractAction
implements PropertyChangeListener {
    private ModeImpl mode;

    public CollapseTabGroupAction() {
        this.putValue("Name", NbBundle.getMessage(CloseModeAction.class, (String)"CTL_CollapseTabGroupAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        WindowManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)WindowManager.getDefault()));
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CollapseTabGroupAction.this.updateEnabled();
                }
            });
        }
    }

    public CollapseTabGroupAction(ModeImpl modeImpl) {
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"CTL_CollapseTabGroupAction"));
        this.mode = modeImpl;
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CollapseTabGroupAction.this.updateEnabled();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent;
        ModeImpl modeImpl = this.mode;
        if (modeImpl == null && null != (topComponent = TopComponent.getRegistry().getActivated())) {
            modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        }
        if (modeImpl != null) {
            WindowManagerImpl.getInstance().collapseTabGroup(modeImpl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName()) || "modes".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent topComponent;
        ModeImpl modeImpl = this.mode;
        if (modeImpl == null && null != (topComponent = TopComponent.getRegistry().getActivated())) {
            modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        }
        if (null == modeImpl) {
            this.setEnabled(false);
            return;
        }
        boolean bl = modeImpl.getState() == 0;
        bl &= modeImpl.getKind() == 1;
        boolean bl2 = false;
        for (ModeImpl modeImpl2 : WindowManagerImpl.getInstance().getModes()) {
            if (modeImpl2.getKind() != 1 || modeImpl2.getState() != 0 || modeImpl2 == modeImpl) continue;
            bl2 = true;
            break;
        }
        this.setEnabled(bl &= bl2);
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CollapseTabGroup", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CollapseTabGroup");
        }
        return super.getValue(string);
    }
}

