/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HeapProgress;
import org.netbeans.lib.profiler.heap.HprofFieldObjectValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private static final String[] REF_CLASSES = new String[]{"java.lang.ref.WeakReference", "java.lang.ref.SoftReference", "java.lang.ref.FinalReference", "java.lang.ref.PhantomReference"};
    private static final String JAVA_LANG_REF_REFERENCE = "java.lang.ref.Reference";
    private static final String REFERENT_FILED_NAME = "referent";
    private Field referentFiled;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private LongBuffer leaves;
    private LongBuffer multipleParents;
    private Set referenceClasses;
    private boolean gcRootsComputed;
    private long allInstances;
    private long processedInstances;

    NearestGCRoot(HprofHeap hprofHeap) {
        this.heap = hprofHeap;
    }

    Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.getGCRoot(instance) != null) {
            return instance;
        }
        this.computeGCRoots();
        long l = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        return this.heap.getInstanceByID(l);
    }

    private boolean isSpecialReference(FieldValue fieldValue, Instance instance) {
        Field field = fieldValue.getField();
        return field.equals(this.referentFiled) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private synchronized void computeGCRoots() {
        if (this.gcRootsComputed) {
            return;
        }
        this.referenceClasses = new HashSet();
        for (int i = 0; i < REF_CLASSES.length; ++i) {
            JavaClass javaClass = this.heap.getJavaClassByName(REF_CLASSES[i]);
            if (javaClass == null) continue;
            this.referenceClasses.add(javaClass);
            this.referenceClasses.addAll(javaClass.getSubClasses());
        }
        this.referentFiled = this.computeReferentFiled();
        this.heap.computeReferences();
        this.allInstances = this.heap.getSummary().getTotalLiveInstances();
        HashSet hashSet = new HashSet(this.heap.getAllClasses().size() * 4 / 3);
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel(hashSet);
            } while (this.hasMoreLevels());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.heap.idToOffsetMap.flush();
        HeapProgress.progressFinish();
        this.gcRootsComputed = true;
    }

    private void computeOneLevel(Set set) throws IOException {
        int n = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List list;
            Object object2;
            long l = this.readLong();
            boolean bl = false;
            if (l == 0L) break;
            HeapProgress.progress(this.processedInstances++, this.allInstances);
            Instance instance = this.heap.getInstanceByID(l);
            if (instance instanceof ObjectArrayInstance) {
                object2 = (ObjectArrayDump)instance;
                int n2 = ((ArrayDump)object2).getLength();
                long l2 = ((ObjectArrayDump)object2).getOffset();
                for (int i = 0; i < n2; ++i) {
                    long l3 = this.heap.dumpBuffer.getID(l2 + (long)(i * n));
                    if (!this.writeConnection(l, l3)) continue;
                    bl = true;
                }
                if (bl) continue;
                this.writeLeaf(l, instance.getSize());
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                this.writeLeaf(l, instance.getSize());
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                object2 = ((ClassDumpInstance)instance).classDump;
                list = ((ClassDump)object2).getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                list = instance.getFieldValues();
            } else {
                if (instance == null) {
                    System.err.println("HeapWalker Warning - null instance for " + l);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            for (Object object2 : list) {
                long l4;
                if (!(object2 instanceof ObjectFieldValue) || this.isSpecialReference((FieldValue)object2, instance) || !this.writeConnection(l, l4 = object2 instanceof HprofFieldObjectValue ? ((HprofFieldObjectValue)object2).getInstanceID() : ((HprofInstanceObjectValue)object2).getInstanceId())) continue;
                bl = true;
            }
            if (this.writeClassConnection(set, l, instance.getJavaClass())) {
                bl = true;
            }
            if (bl) continue;
            this.writeLeaf(l, instance.getSize());
        }
    }

    private Field computeReferentFiled() {
        JavaClass javaClass = this.heap.getJavaClassByName(JAVA_LANG_REF_REFERENCE);
        for (Field field : javaClass.getFields()) {
            if (!field.getName().equals(REFERENT_FILED_NAME)) continue;
            return field;
        }
        throw new IllegalArgumentException("reference field not found in " + javaClass.getName());
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
        this.writeBuffer = new LongBuffer(8192);
        this.leaves = new LongBuffer(8192);
        this.multipleParents = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        for (HprofGCRoot hprofGCRoot : this.heap.getGCRoots()) {
            this.writeLong(hprofGCRoot.getInstanceId());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() throws IOException {
        LongBuffer longBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = longBuffer;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private boolean writeClassConnection(Set set, long l, JavaClass javaClass) throws IOException {
        if (!set.contains(javaClass)) {
            long l2 = javaClass.getJavaClassId();
            set.add(javaClass);
            if (this.writeConnection(l, l2, true)) {
                return true;
            }
        }
        return false;
    }

    private boolean writeConnection(long l, long l2) throws IOException {
        return this.writeConnection(l, l2, false);
    }

    private boolean writeConnection(long l, long l2, boolean bl) throws IOException {
        if (l2 != 0L) {
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l2);
            if (entry != null && entry.getNearestGCRootPointer() == 0L && this.heap.getGCRoot(l2) == null) {
                this.writeLong(l2);
                if (bl && !this.checkReferences(l2, l)) {
                    entry.addReference(l);
                }
                entry.setNearestGCRootPointer(l);
                if (!entry.hasOnlyOneReference()) {
                    this.multipleParents.writeLong(l2);
                }
                return true;
            }
            return !bl && entry != null;
        }
        return false;
    }

    private boolean checkReferences(long l, long l2) {
        Instance instance = this.heap.getInstanceByID(l2);
        for (Object e : instance.getFieldValues()) {
            HprofInstanceObjectValue hprofInstanceObjectValue;
            if (!(e instanceof HprofInstanceObjectValue) || (hprofInstanceObjectValue = (HprofInstanceObjectValue)e).getInstanceId() != l) continue;
            return true;
        }
        return false;
    }

    private void writeLong(long l) throws IOException {
        this.writeBuffer.writeLong(l);
    }

    private void writeLeaf(long l, int n) throws IOException {
        LongMap.Entry entry;
        long l2;
        LongMap.Entry entry2 = this.heap.idToOffsetMap.get(l);
        entry2.setTreeObj();
        entry2.setRetainedSize(n);
        if (entry2.hasOnlyOneReference() && (l2 = entry2.getNearestGCRootPointer()) != 0L && (entry = this.heap.idToOffsetMap.get(l2)).getRetainedSize() == 0) {
            entry.setRetainedSize(-1);
            this.leaves.writeLong(l2);
        }
    }

    LongBuffer getLeaves() {
        this.computeGCRoots();
        return this.leaves;
    }

    LongBuffer getMultipleParents() {
        this.computeGCRoots();
        return this.multipleParents;
    }
}

