/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.threads;

import java.util.Hashtable;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.results.DataManager;
import org.netbeans.lib.profiler.results.threads.ThreadData;

public class ThreadsDataManager
extends DataManager {
    private Hashtable idToIndex = new Hashtable(30);
    private ThreadData[] threadData;
    private boolean supportsSleepingState = true;
    private boolean threadsMonitoringEnabled = true;
    private long endTime;
    private long startTime;

    public ThreadsDataManager() {
        this.reset();
    }

    public synchronized long getEndTime() {
        return this.endTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setSupportsSleepingStateMonitoring(boolean bl) {
        this.supportsSleepingState = bl;
    }

    public synchronized String getThreadClassName(int n) {
        return this.threadData[n].getClassName();
    }

    public synchronized ThreadData getThreadData(int n) {
        return this.threadData[n];
    }

    public synchronized String getThreadName(int n) {
        return this.threadData[n].getName();
    }

    public synchronized int getThreadsCount() {
        return this.threadData.length;
    }

    public synchronized void setThreadsMonitoringEnabled(boolean bl) {
        if (this.threadsMonitoringEnabled == bl) {
            return;
        }
        this.threadsMonitoringEnabled = bl;
        if (!this.threadsMonitoringEnabled) {
            for (int i = 0; i < this.threadData.length; ++i) {
                this.threadData[i].clearStates();
            }
        }
    }

    public synchronized boolean hasData() {
        return this.getThreadsCount() != 0;
    }

    public synchronized void processData(MonitoredData monitoredData) {
        int[] nArray;
        int n = this.threadData.length;
        int n2 = monitoredData.getNNewThreads();
        if (n2 > 0) {
            this.addNewThreads(monitoredData.getNewThreadNames(), monitoredData.getNewThreadClassNames());
            nArray = monitoredData.getNewThreadIds();
            for (int i = 0; i < n2; ++i) {
                this.idToIndex.put(nArray[i], i + n);
            }
        }
        if (this.threadsMonitoringEnabled) {
            if (monitoredData.getThreadsDataMode() == 2) {
                nArray = monitoredData.getExplicitThreadIds();
                long[] lArray = monitoredData.getExplicitStateTimestamps();
                byte[] byArray = monitoredData.getExplicitThreadStates();
                if (lArray.length == 0) {
                    return;
                }
                if (this.startTime == 0L) {
                    this.startTime = lArray[0];
                }
                for (int i = 0; i < nArray.length; ++i) {
                    Integer n3 = (Integer)this.idToIndex.get(nArray[i]);
                    int n4 = n3;
                    ThreadData threadData = this.threadData[n4];
                    threadData.add(lArray[i], byArray[i]);
                }
                this.endTime = lArray[lArray.length - 1];
                this.fireDataChanged();
            } else if (monitoredData.getThreadsDataMode() == 1) {
                nArray = monitoredData.getThreadIds();
                long[] lArray = monitoredData.getStateTimestamps();
                byte[][] byArray = monitoredData.getThreadStates();
                int n5 = monitoredData.getNThreads();
                int n6 = monitoredData.getNThreadStates();
                if (n6 == 0 || n5 == 0) {
                    return;
                }
                if (this.startTime == 0L) {
                    this.startTime = monitoredData.getStateTimestamps()[0];
                }
                for (int i = 0; i < n5; ++i) {
                    Integer n7 = (Integer)this.idToIndex.get(nArray[i]);
                    int n8 = n7;
                    byte[] byArray2 = byArray[i];
                    ThreadData threadData = this.threadData[n8];
                    for (int j = 0; j < n6; ++j) {
                        long l = lArray[j];
                        byte by = byArray2[j];
                        byte by2 = threadData.getLastState();
                        if (by2 != 127 && by2 == by) continue;
                        threadData.add(l, by);
                    }
                }
                this.endTime = lArray[n6 - 1];
                this.fireDataChanged();
            }
        }
    }

    public synchronized void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.threadData = new ThreadData[0];
        this.idToIndex.clear();
        this.fireDataReset();
    }

    public synchronized boolean supportsSleepingStateMonitoring() {
        return this.supportsSleepingState;
    }

    private void addNewThreads(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length + this.threadData.length;
        ThreadData[] threadDataArray = new ThreadData[n];
        if (this.threadData.length > 0) {
            System.arraycopy(this.threadData, 0, threadDataArray, 0, this.threadData.length);
        }
        int n2 = this.threadData.length;
        int n3 = 0;
        while (n2 < n) {
            threadDataArray[n2] = new ThreadData(stringArray[n3], stringArray2[n3]);
            ++n2;
            ++n3;
        }
        this.threadData = threadDataArray;
    }
}

