/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.openide.util.Lookup;

public abstract class Profiler {
    public static final int PROFILING_INACTIVE = 1;
    public static final int PROFILING_STARTED = 2;
    public static final int PROFILING_RUNNING = 4;
    public static final int PROFILING_PAUSED = 8;
    public static final int PROFILING_STOPPED = 16;
    public static final int PROFILING_IN_TRANSITION = 128;
    public static final int MODE_ATTACH = 0;
    public static final int MODE_PROFILE = 1;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 2;
    public static final int USER = 4;
    public static final int EXCEPTION = 8;
    public static final int ERROR = 16;
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.common.Profiler") != null;
    private static Profiler defaultProfiler;
    private Vector profilingStateListeners;
    private int currentProfilingState = 1;

    public static synchronized Profiler getDefault() {
        if (defaultProfiler == null) {
            defaultProfiler = (Profiler)Lookup.getDefault().lookup(Profiler.class);
            if (defaultProfiler == null) {
                throw new InternalError("Should never happen");
            }
            if (DEBUG) {
                System.err.println("Default Profiler succesfully installed: " + defaultProfiler);
            }
        }
        return defaultProfiler;
    }

    public abstract int getAgentState(String var1, int var2, int var3);

    public abstract SessionSettings getCurrentSessionSettings();

    public abstract DefinedFilterSets getDefinedFilterSets();

    public abstract GlobalFilters getGlobalFilters();

    public abstract void saveFilters();

    public abstract GlobalProfilingSettings getGlobalProfilingSettings();

    public abstract ProfilingSettings getLastProfilingSettings();

    public abstract int getProfilingMode();

    public abstract int getProfilingState();

    public abstract int getServerState();

    public abstract int getServerProgress();

    public abstract TargetAppRunner getTargetAppRunner();

    public abstract ThreadsDataManager getThreadsManager();

    public abstract void setThreadsMonitoringEnabled(boolean var1);

    public abstract boolean getThreadsMonitoringEnabled();

    public abstract void setLockContentionMonitoringEnabled(boolean var1);

    public abstract boolean getLockContentionMonitoringEnabled();

    public abstract VMTelemetryDataManager getVMTelemetryManager();

    public abstract boolean attachToApp(ProfilingSettings var1, AttachSettings var2);

    public abstract boolean connectToStartedApp(ProfilingSettings var1, SessionSettings var2);

    public abstract void detachFromApp();

    public abstract void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] var1) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated;

    public abstract void log(int var1, String var2);

    public abstract void modifyCurrentProfiling(ProfilingSettings var1);

    public abstract void notifyException(int var1, Exception var2);

    public abstract void openJavaSource(String var1, String var2, String var3);

    public abstract boolean profileClass(ProfilingSettings var1, SessionSettings var2);

    public abstract boolean rerunAvailable();

    public abstract boolean modifyAvailable();

    public abstract void rerunLastProfiling();

    public abstract boolean runCalibration(boolean var1, String var2, String var3, int var4);

    public abstract boolean shutdownBlockedAgent(String var1, int var2, int var3);

    public abstract void stopApp();

    public final void addProfilingStateListener(ProfilingStateListener profilingStateListener) {
        if (this.profilingStateListeners == null) {
            this.profilingStateListeners = new Vector();
        }
        if (!this.profilingStateListeners.contains(profilingStateListener)) {
            this.profilingStateListeners.add(profilingStateListener);
            profilingStateListener.profilingStateChanged(new ProfilingStateEvent(-1, this.currentProfilingState, defaultProfiler));
        }
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException, BadLocationException, ClassNotFoundException, IOException, ClassFormatError {
        ProfilerClient profilerClient = this.getTargetAppRunner().getProfilerClient();
        int n = profilerClient.getStatus().currentInstrType;
        switch (profilingSettings.getProfilingType()) {
            case 1: {
                profilerClient.initiateMonitoring();
                break;
            }
            case 128: {
                profilerClient.initiateMemoryProfInstrumentation(7);
                break;
            }
            case 2: {
                profilerClient.initiateMemoryProfInstrumentation(5);
                break;
            }
            case 4: {
                profilerClient.initiateMemoryProfInstrumentation(6);
                break;
            }
            case 8: 
            case 16: {
                this.instrumentSelectedRoots(profilingSettings.getInstrumentationMethods());
                break;
            }
            case 64: {
                profilerClient.initiateCPUSampling();
                break;
            }
            case 32: {
                ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[]{profilingSettings.getCodeFragmentSelection()};
                profilerClient.initiateCodeRegionInstrumentation(sourceCodeSelectionArray);
            }
        }
        this.fireInstrumentationChanged(n, profilerClient.getStatus().currentInstrType);
        return true;
    }

    public final boolean profilingInProgress() {
        int n = this.getProfilingState();
        return n == 8 || n == 4;
    }

    public final void removeProfilingStateListener(ProfilingStateListener profilingStateListener) {
        if (this.profilingStateListeners != null) {
            this.profilingStateListeners.remove(profilingStateListener);
        }
    }

    public static void debug(String string) {
        if (DEBUG) {
            System.err.println("Profiler.DEBUG: " + string);
        }
    }

    public static void debug(Exception exception) {
        if (DEBUG) {
            System.err.print("Profiler.DEBUG: ");
            exception.printStackTrace(System.err);
        }
    }

    public abstract String getLibsDir();

    public abstract int getPlatformArchitecture(String var1);

    public abstract String getPlatformJDKVersion(String var1);

    public abstract String getPlatformJavaFile(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireInstrumentationChanged(int n, int n2) {
        Vector vector;
        if (this.profilingStateListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.profilingStateListeners.clone();
        }
        object = vector.iterator();
        Runnable runnable = new Runnable((Iterator)object, n, n2){
            private final /* synthetic */ Iterator val$iterator;
            private final /* synthetic */ int val$oldInstrType;
            private final /* synthetic */ int val$currentInstrType;
            {
                this.val$iterator = iterator;
                this.val$oldInstrType = n;
                this.val$currentInstrType = n2;
            }

            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ProfilingStateListener)this.val$iterator.next()).instrumentationChanged(this.val$oldInstrType, this.val$currentInstrType);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireProfilingStateChange(int n, int n2) {
        Vector vector;
        this.currentProfilingState = n2;
        if (this.profilingStateListeners == null) {
            return;
        }
        if (n == n2) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.profilingStateListeners.clone();
        }
        object = vector.iterator();
        ProfilingStateEvent profilingStateEvent = new ProfilingStateEvent(n, n2, this);
        Runnable runnable = new Runnable((Iterator)object, profilingStateEvent){
            private final /* synthetic */ Iterator val$iterator;
            private final /* synthetic */ ProfilingStateEvent val$event;
            {
                this.val$iterator = iterator;
                this.val$event = profilingStateEvent;
            }

            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ProfilingStateListener)this.val$iterator.next()).profilingStateChanged(this.val$event);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireThreadsMonitoringChange() {
        Vector vector;
        if (this.profilingStateListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.profilingStateListeners.clone();
        }
        object = vector.iterator();
        Runnable runnable = new Runnable((Iterator)object){
            private final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ProfilingStateListener)this.val$iterator.next()).threadsMonitoringChanged();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireLockContentionMonitoringChange() {
        Vector vector;
        if (this.profilingStateListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.profilingStateListeners.clone();
        }
        object = vector.iterator();
        Runnable runnable = new Runnable((Iterator)object){
            private final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ProfilingStateListener)this.val$iterator.next()).lockContentionMonitoringChanged();
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServerStateChanged(int n, int n2) {
        Vector vector;
        if (this.profilingStateListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.profilingStateListeners.clone();
        }
        object = vector.iterator();
        Runnable runnable = new Runnable((Iterator)object, n, n2){
            private final /* synthetic */ Iterator val$iterator;
            private final /* synthetic */ int val$serverState;
            private final /* synthetic */ int val$serverProgress;
            {
                this.val$iterator = iterator;
                this.val$serverState = n;
                this.val$serverProgress = n2;
            }

            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ProfilingStateListener)this.val$iterator.next()).serverStateChanged(this.val$serverState, this.val$serverProgress);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }
}

