/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvmstat.application;

import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.properties.PropertiesPanel;
import com.sun.tools.visualvm.core.properties.PropertiesProvider;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jvmstat.application.ConnectionDescriptor;
import com.sun.tools.visualvm.jvmstat.application.ConnectionsCustomizer;
import com.sun.tools.visualvm.jvmstat.application.JvmstatApplicationProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HostPropertiesProvider
extends PropertiesProvider<Host> {
    static final int CATEGORY_JSTATD_CONNECTION = 100;
    private static final String PROP_JSTATD_PORT = "prop_jstatd_port";
    private static final String PROP_JSTATD_REFRESH = "prop_jstatd_refresh";

    public HostPropertiesProvider() {
        super(NbBundle.getMessage(HostPropertiesProvider.class, (String)"CAP_JstatdProperties"), NbBundle.getMessage(HostPropertiesProvider.class, (String)"DESCR_JstatdProperties"), 100, 0);
    }

    public boolean supportsDataSource(Host host) {
        return true;
    }

    public PropertiesPanel createPanel(Host host) {
        return new ConnectionsCustomizer(HostPropertiesProvider.getDescriptorsEx(host));
    }

    public void propertiesDefined(PropertiesPanel panel, Host host) {
        ConnectionsCustomizer customizer = (ConnectionsCustomizer)panel;
        HostPropertiesProvider.setDescriptors(host, customizer.getDescriptors());
    }

    public void propertiesChanged(PropertiesPanel panel, Host host) {
        ConnectionsCustomizer customizer = (ConnectionsCustomizer)panel;
        HostPropertiesProvider.setDescriptorsEx(host, customizer.getDescriptors());
    }

    public void propertiesCancelled(PropertiesPanel panel, Host host) {
    }

    static Set<ConnectionDescriptor> descriptorsForHost(Host host) {
        Set<ConnectionDescriptor> descriptors = HostPropertiesProvider.getDescriptors(host);
        if (Host.LOCALHOST.equals((Object)host)) {
            descriptors.add(ConnectionDescriptor.DEFAULT_LOCAL_DESCRIPTOR);
        }
        return HostPropertiesProvider.cleanup(host, descriptors);
    }

    private static Set<ConnectionDescriptor> cleanup(Host h, Set<ConnectionDescriptor> d) {
        HashSet<ConnectionDescriptor> descriptors = new HashSet<ConnectionDescriptor>(d);
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            if (((ConnectionDescriptor)iterator.next()).createHostIdentifier(h) != null) continue;
            iterator.remove();
        }
        return descriptors;
    }

    private static Set<ConnectionDescriptor> getDescriptors(Host host) {
        Storage storage = host == null ? null : host.getStorage();
        return HostPropertiesProvider.getDescriptors(storage);
    }

    private static Set<ConnectionDescriptor> getDescriptors(Storage storage) {
        HashSet<ConnectionDescriptor> set = new HashSet<ConnectionDescriptor>();
        if (storage != null) {
            int index = 0;
            String port = storage.getCustomProperty("prop_jstatd_port." + index);
            while (port != null) {
                String refresh = storage.getCustomProperty("prop_jstatd_refresh." + index);
                try {
                    set.add(new ConnectionDescriptor(Integer.parseInt(port), Double.parseDouble(refresh)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                port = storage.getCustomProperty("prop_jstatd_port." + ++index);
            }
        }
        return set;
    }

    private static Set<ConnectionDescriptor> getDescriptorsEx(Host host) {
        Set<ConnectionDescriptor> set = HostPropertiesProvider.getDescriptors(host);
        if (host == null) {
            set.add(ConnectionDescriptor.createDefault());
        }
        return set;
    }

    private static void setDescriptors(Host host, Set<ConnectionDescriptor> descriptors) {
        HostPropertiesProvider.setDescriptors(host.getStorage(), descriptors);
    }

    private static void setDescriptors(Storage storage, Set<ConnectionDescriptor> descriptors) {
        HostPropertiesProvider.clearDescriptors(storage);
        int index = 0;
        for (ConnectionDescriptor descriptor : descriptors) {
            storage.setCustomProperty("prop_jstatd_port." + index, Integer.toString(descriptor.getPort()));
            storage.setCustomProperty("prop_jstatd_refresh." + index, Double.toString(descriptor.getRefreshRate()));
            ++index;
        }
    }

    private static void setDescriptorsEx(Host host, Set<ConnectionDescriptor> newDescriptors) {
        ArrayList<ConnectionDescriptor> oldDescriptors = new ArrayList<ConnectionDescriptor>(HostPropertiesProvider.getDescriptorsEx(host));
        HostPropertiesProvider.setDescriptors(host, newDescriptors);
        Set<ConnectionDescriptor> added = new HashSet<ConnectionDescriptor>(newDescriptors);
        added.removeAll(oldDescriptors);
        added = HostPropertiesProvider.cleanup(host, added);
        Set<ConnectionDescriptor> removed = new HashSet<ConnectionDescriptor>(oldDescriptors);
        removed.removeAll(newDescriptors);
        removed = HostPropertiesProvider.cleanup(host, removed);
        Set<ConnectionDescriptor> changed = new HashSet<ConnectionDescriptor>(newDescriptors);
        changed.retainAll(oldDescriptors);
        Iterator iterator = changed.iterator();
        while (iterator.hasNext()) {
            ConnectionDescriptor descriptor1 = (ConnectionDescriptor)iterator.next();
            ConnectionDescriptor descriptor2 = (ConnectionDescriptor)oldDescriptors.get(oldDescriptors.indexOf(descriptor1));
            if (!(Math.abs(descriptor1.getRefreshRate() - descriptor2.getRefreshRate()) < 0.001)) continue;
            iterator.remove();
        }
        changed = HostPropertiesProvider.cleanup(host, changed);
        if (!(added.isEmpty() && removed.isEmpty() && changed.isEmpty())) {
            JvmstatApplicationProvider.sharedInstance().connectionsChanged(host, added, removed, changed);
        }
    }

    private static void clearDescriptors(Storage storage) {
        int index = 0;
        String port = storage.getCustomProperty("prop_jstatd_port." + index);
        while (port != null) {
            storage.clearCustomProperties(new String[]{"prop_jstatd_port." + index, "prop_jstatd_refresh." + index});
            port = storage.getCustomProperty("prop_jstatd_port." + ++index);
        }
    }
}

