/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.core.startup.NbProblemDisplayer;

public class ConsistencyVerifier {
    private ConsistencyVerifier() {
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(set, null);
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set, Set<String> set2) throws IllegalArgumentException {
        return ConsistencyVerifier.findInconsistencies(set, set2, true);
    }

    static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> set, Set<String> set2, boolean bl) throws IllegalArgumentException {
        String string;
        ModuleManager moduleManager = new ModuleManager((ModuleInstaller)new DummyInstaller(), (Events)new DummyEvents());
        moduleManager.mutexPrivileged().enterWriteAccess();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("OpenIDE-Module", "__dummy__");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Provides", "org.openide.modules.ModuleFormat1, org.openide.modules.ModuleFormat2, org.openide.modules.jre.JavaFX, org.openide.modules.os.Unix, org.openide.modules.os.PlainUnix, org.openide.modules.os.Windows, org.openide.modules.os.MacOSX, org.openide.modules.os.Linux, org.openide.modules.os.Solaris, org.openide.modules.os.OS2");
        manifest.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
        try {
            moduleManager.createFixed(manifest, null, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        HashSet<Module> hashSet2 = new HashSet<Module>();
        for (Manifest object2 : set) {
            Attributes attributes = object2.getMainAttributes();
            try {
                attributes.putValue("OpenIDE-Module-Public-Packages", "-");
                attributes.remove(new Attributes.Name("OpenIDE-Module-Friends"));
                attributes.remove(new Attributes.Name("OpenIDE-Module-Localizing-Bundle"));
                String string2 = attributes.getValue("Bundle-SymbolicName");
                string = attributes.getValue("Bundle-Version");
                if (string2 != null && string != null) {
                    String string3 = string2.replaceAll(";.*", "");
                    if (attributes.getValue("OpenIDE-Module") == null) {
                        attributes.putValue("OpenIDE-Module", string3);
                    }
                    if (attributes.getValue("OpenIDE-Module-Specification-Version") == null) {
                        Matcher matcher = Pattern.compile("[0-9]*(\\.[0-9]*)?(\\.[0-9]*)?").matcher(string);
                        if (matcher.find()) {
                            string = matcher.group();
                        }
                        attributes.putValue("OpenIDE-Module-Specification-Version", string.replace("(.*)", ""));
                    }
                }
                boolean bl2 = "true".equals(attributes.getValue("autoload"));
                boolean bl3 = "true".equals(attributes.getValue("eager"));
                Module module = moduleManager.createFixed(object2, null, ClassLoader.getSystemClassLoader(), bl2, bl3);
                hashSet.add(module);
                if (bl2 || bl3) continue;
                hashSet2.add(module);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error parsing " + attributes.entrySet() + ": " + exception, exception);
            }
        }
        TreeMap treeMap = new TreeMap();
        List list = moduleManager.simulateEnable(hashSet2);
        for (Module module : hashSet) {
            string = module.getCodeNameBase();
            Set set3 = module.getProblems();
            if (set3.isEmpty()) {
                if (set2 == null || set2.contains(string) || !module.isAutoload() || list.contains(module) || "true".equals(module.getAttribute("OpenIDE-Module-Deprecated"))) continue;
                treeMap.put(string, new TreeSet<String>(Collections.singleton("module is autoload but would not be enabled")));
                continue;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Object e : set3) {
                String string4 = bl ? NbProblemDisplayer.messageForProblem(module, e, false) : e.toString();
                treeSet.add(string4);
            }
            treeMap.put(string, treeSet);
        }
        return treeMap;
    }

    private static final class DummyEvents
    extends Events {
        private DummyEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }

    private static final class DummyInstaller
    extends ModuleInstaller {
        private DummyInstaller() {
        }

        public void prepare(Module module) throws InvalidException {
            throw new AssertionError();
        }

        public void dispose(Module module) {
            throw new AssertionError();
        }

        public void load(List<Module> list) {
            throw new AssertionError();
        }

        public void unload(List<Module> list) {
            throw new AssertionError();
        }

        public boolean closing(List<Module> list) {
            throw new AssertionError();
        }

        public void close(List<Module> list) {
            throw new AssertionError();
        }
    }
}

