/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.editors.IntegerCustomEditor;
import org.netbeans.beaninfo.editors.RectangleEditor;
import org.netbeans.core.UIExceptions;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class RectangleCustomEditor
extends IntegerCustomEditor {
    static final long serialVersionUID = -9015667991684634296L;
    private JPanel jPanel2;
    private JLabel xLabel;
    private JTextField xField;
    private JLabel yLabel;
    private JTextField yField;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel heightLabel;
    private JTextField heightField;
    private RectangleEditor editor;

    public RectangleCustomEditor(RectangleEditor rectangleEditor, PropertyEnv propertyEnv) {
        super(propertyEnv);
        this.initComponents();
        this.editor = rectangleEditor;
        Rectangle rectangle = (Rectangle)rectangleEditor.getValue();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        this.xField.setText(Integer.toString(rectangle.x));
        this.yField.setText(Integer.toString(rectangle.y));
        this.widthField.setText(Integer.toString(rectangle.width));
        this.heightField.setText(Integer.toString(rectangle.height));
        ResourceBundle resourceBundle = NbBundle.getBundle(RectangleCustomEditor.class);
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jPanel2.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), " " + resourceBundle.getString("CTL_Rectangle") + " "), new EmptyBorder(new Insets(5, 5, 5, 5))));
        Mnemonics.setLocalizedText((JLabel)this.xLabel, (String)resourceBundle.getString("CTL_X"));
        Mnemonics.setLocalizedText((JLabel)this.yLabel, (String)resourceBundle.getString("CTL_Y"));
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)resourceBundle.getString("CTL_Width"));
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)resourceBundle.getString("CTL_Height"));
        this.xLabel.setLabelFor(this.xField);
        this.yLabel.setLabelFor(this.yField);
        this.widthLabel.setLabelFor(this.widthField);
        this.heightLabel.setLabelFor(this.heightField);
        this.xField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_X"));
        this.yField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Y"));
        this.widthField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Width"));
        this.heightField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Height"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CustomRectangleEditor"));
        this.setPanel(this.jPanel2);
        this.getMap().put(this.widthField, this.widthLabel);
        this.getMap().put(this.xField, this.xLabel);
        this.getMap().put(this.yField, this.yLabel);
        this.getMap().put(this.heightField, this.heightLabel);
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    private Object getPropertyValue() throws IllegalStateException {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            int n3 = Integer.parseInt(this.widthField.getText());
            int n4 = Integer.parseInt(this.heightField.getText());
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                IllegalStateException illegalStateException = new IllegalStateException();
                UIExceptions.annotateUser(illegalStateException, null, NbBundle.getMessage(RectangleCustomEditor.class, (String)"CTL_NegativeSize"), null, null);
                throw illegalStateException;
            }
            return new Rectangle(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            UIExceptions.annotateUser(illegalStateException, null, NbBundle.getMessage(RectangleCustomEditor.class, (String)"CTL_InvalidValue"), null, null);
            throw illegalStateException;
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.xLabel = new JLabel();
        this.xLabel.setText(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.xLabel, gridBagConstraints);
        this.xField = new JTextField();
        this.xField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.xField, gridBagConstraints);
        this.yLabel = new JLabel();
        this.yLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.yLabel, gridBagConstraints);
        this.yField = new JTextField();
        this.yField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.yField, gridBagConstraints);
        this.widthLabel = new JLabel();
        this.widthLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.widthLabel, gridBagConstraints);
        this.widthField = new JTextField();
        this.widthField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.widthField, gridBagConstraints);
        this.heightLabel = new JLabel();
        this.heightLabel.setText(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.heightLabel, gridBagConstraints);
        this.heightField = new JTextField();
        this.heightField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.heightField, gridBagConstraints);
        this.add((Component)this.jPanel2, "Center");
    }

    @Override
    protected void updateValues() {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            int n3 = Integer.parseInt(this.widthField.getText());
            int n4 = Integer.parseInt(this.heightField.getText());
            this.editor.setValue(new Rectangle(n, n2, n3, n4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private JLabel findLabelFor(JTextField jTextField) {
        return this.getMap().get(jTextField);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }
}

