/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;
import com.gs.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SelectDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleIterable delegate;
    private final DoublePredicate predicate;

    public SelectDoubleIterable(DoubleIterable delegate, DoublePredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public DoubleIterator doubleIterator() {
        return new SelectDoubleIterator(this.delegate, this.predicate);
    }

    public void forEach(DoubleProcedure procedure) {
        this.delegate.forEach((DoubleProcedure)new IfDoubleProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.doubleIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.doubleIterator().hasNext();
    }

    public int count(DoublePredicate predicate) {
        CountDoubleProcedure countDoubleProcedure = new CountDoubleProcedure(predicate);
        this.forEach(countDoubleProcedure);
        return countDoubleProcedure.getCount();
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.anySatisfy(DoublePredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.noneSatisfy(DoublePredicates.not(predicate));
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public double sum() {
        double sum = 0.0;
        DoubleIterator doubleIterator = this.doubleIterator();
        while (doubleIterator.hasNext()) {
            sum += doubleIterator.next();
        }
        return sum;
    }

    public double max() {
        DoubleIterator doubleIterator = this.doubleIterator();
        double max = doubleIterator.next();
        while (doubleIterator.hasNext()) {
            max = Math.max(max, doubleIterator.next());
        }
        return max;
    }

    public double min() {
        DoubleIterator doubleIterator = this.doubleIterator();
        double min = doubleIterator.next();
        while (doubleIterator.hasNext()) {
            min = Math.min(min, doubleIterator.next());
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double maxIfEmpty(double defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    public double[] toArray() {
        final double[] array = new double[this.size()];
        this.forEach(new DoubleProcedure(){
            private int index = 0;

            public void value(double each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    private static final class SelectDoubleIterator
    implements DoubleIterator {
        private final DoubleIterator iterator;
        private final DoublePredicate predicate;
        private double next;
        private boolean verifiedHasNext = false;

        private SelectDoubleIterator(DoubleIterable iterable, DoublePredicate predicate) {
            this(iterable.doubleIterator(), predicate);
        }

        private SelectDoubleIterator(DoubleIterator iterator, DoublePredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                double temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public double next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoubleProcedure procedure;

        private IfDoubleProcedure(DoubleProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(double each) {
            if (SelectDoubleIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountDoubleProcedure
    implements DoubleProcedure {
        private static final long serialVersionUID = 1L;
        private final DoublePredicate predicate;
        private int counter = 0;

        private CountDoubleProcedure(DoublePredicate predicate) {
            this.predicate = predicate;
        }

        public void value(double each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

