/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.api.list.primitive.LongList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseLongIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.SynchronizedLongList;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableLongList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class LongArrayList
implements MutableLongList,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final long[] DEFAULT_SIZED_EMPTY_ARRAY = new long[0];
    private static final long[] ZERO_SIZED_ARRAY = new long[0];
    private static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    private int size;
    private transient long[] items = DEFAULT_SIZED_EMPTY_ARRAY;

    public LongArrayList() {
    }

    public LongArrayList(int initialCapacity) {
        this.items = initialCapacity == 0 ? ZERO_SIZED_ARRAY : new long[initialCapacity];
    }

    public LongArrayList(long ... array) {
        this.size = array.length;
        this.items = array;
    }

    public static LongArrayList newListWith(long ... elements) {
        return new LongArrayList(elements);
    }

    public static LongArrayList newList(LongIterable source) {
        return LongArrayList.newListWith(source.toArray());
    }

    public static LongArrayList newWithNValues(int size, long value) {
        LongArrayList newList = new LongArrayList(size);
        for (int i = 0; i < size; ++i) {
            newList.add(value);
        }
        return newList;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public void clear() {
        Arrays.fill(this.items, 0L);
        this.size = 0;
    }

    public boolean contains(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public long get(int index) {
        if (index < this.size) {
            return this.items[index];
        }
        throw this.newIndexOutOfBoundsException(index);
    }

    private IndexOutOfBoundsException newIndexOutOfBoundsException(int index) {
        return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size);
    }

    public long getFirst() {
        this.checkEmpty();
        return this.items[0];
    }

    public long getLast() {
        this.checkEmpty();
        return this.items[this.size() - 1];
    }

    private void checkEmpty() {
        if (this.isEmpty()) {
            throw this.newIndexOutOfBoundsException(0);
        }
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.size < this.items.length) {
            this.transferItemsToNewArrayWithCapacity(this.size);
        }
    }

    private void transferItemsToNewArrayWithCapacity(int newCapacity) {
        this.items = this.copyItemsWithNewCapacity(newCapacity);
    }

    private long[] copyItemsWithNewCapacity(int newCapacity) {
        long[] newItems = new long[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(this.size, newCapacity));
        return newItems;
    }

    private int sizePlusFiftyPercent(int oldSize) {
        int result = oldSize + (oldSize >> 1) + 1;
        return result < oldSize ? 0x7FFFFFF7 : result;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.items.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = Math.max(this.sizePlusFiftyPercent(oldCapacity), minCapacity);
            this.transferItemsToNewArrayWithCapacity(newCapacity);
        }
    }

    private void ensureCapacityForAdd() {
        if (this.items == DEFAULT_SIZED_EMPTY_ARRAY) {
            this.items = new long[10];
        } else {
            this.transferItemsToNewArrayWithCapacity(this.sizePlusFiftyPercent(this.size));
        }
    }

    public boolean add(long newItem) {
        if (this.items.length == this.size) {
            this.ensureCapacityForAdd();
        }
        this.items[this.size] = newItem;
        ++this.size;
        return true;
    }

    public boolean addAll(long ... source) {
        if (source.length < 1) {
            return false;
        }
        int sourceSize = source.length;
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        System.arraycopy(source, 0, this.items, this.size, sourceSize);
        this.size = newSize;
        return true;
    }

    public boolean addAll(LongIterable source) {
        return this.addAll(source.toArray());
    }

    private void throwOutOfBounds(int index) {
        throw this.newIndexOutOfBoundsException(index);
    }

    public void addAtIndex(int index, long element) {
        if (index > -1 && index < this.size) {
            this.addAtIndexLessThanSize(index, element);
        } else if (index == this.size) {
            this.add(element);
        } else {
            this.throwOutOfBounds(index);
        }
    }

    private void addAtIndexLessThanSize(int index, long element) {
        int oldSize;
        if (this.items.length == (oldSize = this.size++)) {
            long[] newItems = new long[this.sizePlusFiftyPercent(oldSize)];
            if (index > 0) {
                System.arraycopy(this.items, 0, newItems, 0, index);
            }
            System.arraycopy(this.items, index, newItems, index + 1, oldSize - index);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, index, this.items, index + 1, oldSize - index);
        }
        this.items[index] = element;
    }

    public boolean addAllAtIndex(int index, long ... source) {
        if (index > this.size || index < 0) {
            this.throwOutOfBounds(index);
        }
        if (source.length == 0) {
            return false;
        }
        int sourceSize = source.length;
        int newSize = this.size + sourceSize;
        this.ensureCapacity(newSize);
        this.shiftElementsAtIndex(index, sourceSize);
        System.arraycopy(source, 0, this.items, index, sourceSize);
        this.size = newSize;
        return true;
    }

    public boolean addAllAtIndex(int index, LongIterable source) {
        return this.addAllAtIndex(index, source.toArray());
    }

    private void shiftElementsAtIndex(int index, int sourceSize) {
        int numberToMove = this.size - index;
        if (numberToMove > 0) {
            System.arraycopy(this.items, index, this.items, index + sourceSize, numberToMove);
        }
    }

    public boolean remove(long value) {
        int index = this.indexOf(value);
        if (index >= 0) {
            this.removeAtIndex(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(LongIterable source) {
        boolean modified = false;
        for (int index = 0; index < this.size; ++index) {
            if (!source.contains(this.get(index))) continue;
            this.removeAtIndex(index);
            --index;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(long ... source) {
        LongHashSet set = LongHashSet.newSetWith(source);
        long[] newItems = new long[this.size];
        int count = 0;
        int oldSize = this.size;
        for (int index = 0; index < this.size; ++index) {
            if (set.contains(this.items[index])) continue;
            newItems[count] = this.items[index];
            ++count;
        }
        this.items = newItems;
        this.size = count;
        return oldSize != this.size;
    }

    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        final LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongArrayList retained = this.select(new LongPredicate(){

            public boolean accept(long value) {
                return sourceSet.contains(value);
            }
        });
        this.size = retained.size;
        this.items = retained.items;
        return oldSize != this.size();
    }

    public boolean retainAll(long ... source) {
        return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
    }

    public long removeAtIndex(int index) {
        long previous = this.get(index);
        int totalOffset = this.size - index - 1;
        if (totalOffset > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, totalOffset);
        }
        --this.size;
        this.items[this.size] = 0L;
        return previous;
    }

    public long set(int index, long element) {
        long previous = this.get(index);
        this.items[index] = element;
        return previous;
    }

    public LongArrayList with(long element) {
        this.add(element);
        return this;
    }

    public LongArrayList without(long element) {
        this.remove(element);
        return this;
    }

    public LongArrayList withAll(LongIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public LongArrayList withoutAll(LongIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public LongArrayList with(long element1, long element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public LongArrayList with(long element1, long element2, long element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public LongArrayList with(long element1, long element2, long element3, long ... elements) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this.withArrayCopy(elements, 0, elements.length);
    }

    private LongArrayList withArrayCopy(long[] elements, int begin, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(elements, begin, this.items, this.size, length);
        this.size += length;
        return this;
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public void forEach(LongProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i]);
        }
    }

    public void forEachWithIndex(LongIntProcedure procedure) {
        for (int i = 0; i < this.size; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectLongIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.size; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.accept(this.items[i])) continue;
            return false;
        }
        return true;
    }

    public LongArrayList select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (!predicate.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    public LongArrayList reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (predicate.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> MutableList<V> collect(LongToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size);
        for (int i = 0; i < this.size; ++i) {
            target.add(function.valueOf(this.items[i]));
        }
        return target;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            long value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min = this.items[0];
        for (int i = 1; i < this.size; ++i) {
            long value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.size; ++i) {
            result += this.items[i];
        }
        return result;
    }

    public long dotProduct(LongList list) {
        if (this.size != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size; ++i) {
            sum += this.items[i] * list.get(i);
        }
        return sum;
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toArray() {
        long[] newItems = new long[this.size];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        return newItems;
    }

    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof LongList)) {
            return false;
        }
        LongList list = (LongList)otherList;
        if (this.size != list.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            long item = this.items[i];
            hashCode = 31 * hashCode + (int)(item ^ item >>> 32);
        }
        return hashCode;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                long value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableLongList toList() {
        return LongArrayList.newList((LongIterable)this);
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSet((LongIterable)this);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBag((LongIterable)this);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public MutableLongList asUnmodifiable() {
        return new UnmodifiableLongList(this);
    }

    public MutableLongList asSynchronized() {
        return new SynchronizedLongList(this);
    }

    public ImmutableLongList toImmutable() {
        if (this.items.length == 0) {
            return LongLists.immutable.with();
        }
        if (this.items.length == 1) {
            return LongLists.immutable.with(this.items[0]);
        }
        return LongLists.immutable.with(this.toArray());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeLong(this.items[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.size = in.readInt();
        this.items = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = in.readLong();
        }
    }

    public LazyLongIterable asReversed() {
        return ReverseLongIterable.adapt((LongList)this);
    }

    public LongArrayList reverseThis() {
        int size = this.items.length;
        int endIndex = size - 1;
        for (int i = 0; i < size / 2; ++i) {
            long tempSwapValue = this.items[i];
            this.items[i] = this.items[endIndex - i];
            this.items[endIndex - i] = tempSwapValue;
        }
        return this;
    }

    public LongArrayList sortThis() {
        Arrays.sort(this.items, 0, this.items.length);
        return this;
    }

    public LongArrayList toReversed() {
        return LongArrayList.newList((LongIterable)this.asReversed());
    }

    public MutableLongList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalLongIterator
    implements LongIterator {
        private int currentIndex;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != LongArrayList.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long next = LongArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

