/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.set.PartitionImmutableSet;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.EmptyIterator;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.partition.set.PartitionUnifiedSet;
import com.gs.collections.impl.set.immutable.AbstractImmutableSet;
import com.gs.collections.impl.set.immutable.ImmutableSetSerializationProxy;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableEmptySet<T>
extends AbstractImmutableSet<T>
implements Serializable {
    static final ImmutableSet<?> INSTANCE = new ImmutableEmptySet();
    private static final PartitionImmutableSet<?> EMPTY = new PartitionUnifiedSet().toImmutable();
    private static final long serialVersionUID = 1L;

    ImmutableEmptySet() {
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Set && ((Set)other).isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public ImmutableSet<T> newWith(T element) {
        return Sets.immutable.of(element);
    }

    @Override
    public ImmutableSet<T> newWithAll(Iterable<? extends T> elements) {
        return Sets.immutable.ofAll(elements);
    }

    @Override
    public ImmutableSet<T> newWithout(T element) {
        return this;
    }

    @Override
    public ImmutableSet<T> newWithoutAll(Iterable<? extends T> elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object obj) {
        return false;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
    }

    public T getFirst() {
        return null;
    }

    public T getLast() {
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return EmptyIterator.getInstance();
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T min() {
        throw new NoSuchElementException();
    }

    @Override
    public T max() {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <S> ImmutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return Sets.immutable.of();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return target;
    }

    @Override
    public ImmutableSet<Pair<T, Integer>> zipWithIndex() {
        return Sets.immutable.of();
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return target;
    }

    @Override
    public ImmutableSet<T> select(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public ImmutableSet<T> reject(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public PartitionImmutableSet<T> partition(Predicate<? super T> predicate) {
        return EMPTY;
    }

    @Override
    public <V> ImmutableSet<V> collect(Function<? super T, ? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public <V> ImmutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return Sets.immutable.of();
    }

    @Override
    public <V> ImmutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return Sets.immutable.of();
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        return target;
    }

    @Override
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        return target;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        return target;
    }

    @Override
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        return target;
    }

    @Override
    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        return target;
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        return (T)function.value();
    }

    @Override
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        return target;
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return null;
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        return 0;
    }

    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return 0;
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return true;
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return false;
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return true;
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return true;
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return injectedValue;
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> intObjectToIntFunction) {
        return injectedValue;
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> longObjectToLongFunction) {
        return injectedValue;
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> doubleObjectToDoubleFunction) {
        return injectedValue;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new ImmutableSetSerializationProxy(this);
    }
}

