/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.core.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import reactor.Environment;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.RingBufferDispatcher;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.timer.Timer;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;
import reactor.spring.core.task.AbstractAsyncTaskExecutor;
import reactor.spring.core.task.AsyncTaskExceptionEvent;

public class RingBufferAsyncTaskExecutor
extends AbstractAsyncTaskExecutor
implements ApplicationEventPublisherAware,
BeanNameAware {
    private final Logger log = LoggerFactory.getLogger(RingBufferAsyncTaskExecutor.class);
    private ProducerType producerType;
    private WaitStrategy waitStrategy;
    private ApplicationEventPublisher eventPublisher;
    private RingBufferDispatcher dispatcher;

    public RingBufferAsyncTaskExecutor(Environment env) {
        this(env.getTimer());
    }

    public RingBufferAsyncTaskExecutor(Timer timer) {
        super(timer);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.dispatcher = new RingBufferDispatcher(this.getName(), this.getBacklog(), (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (null != RingBufferAsyncTaskExecutor.this.eventPublisher) {
                    RingBufferAsyncTaskExecutor.this.eventPublisher.publishEvent((ApplicationEvent)new AsyncTaskExceptionEvent(throwable));
                } else {
                    RingBufferAsyncTaskExecutor.this.log.error(throwable.getMessage(), throwable);
                }
            }
        }, null != this.producerType ? this.producerType : ProducerType.MULTI, (WaitStrategy)(null != this.waitStrategy ? this.waitStrategy : new BlockingWaitStrategy()));
    }

    public void setBeanName(String name) {
        this.setName(name);
    }

    @Override
    public int getThreads() {
        return 1;
    }

    @Override
    public void setThreads(int threads) {
        Assert.isTrue((threads == 1 ? 1 : 0) != 0, (String)"A RingBufferAsyncTaskExecutor is always single-threaded");
        this.log.warn("RingBufferAsyncTaskExecutors are always single-threaded. Ignoring request to use " + threads + " threads.");
    }

    public ProducerType getProducerType() {
        return this.producerType;
    }

    public void setProducerType(ProducerType producerType) {
        this.producerType = producerType;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    @Override
    protected AbstractLifecycleDispatcher getDispatcher() {
        return this.dispatcher;
    }
}

