/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.boot;

import grails.util.Environment;
import groovy.lang.Grab;
import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.eclipse.aether.graph.Dependency;
import org.grails.cli.boot.GrailsDependencyVersions;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;
import org.springframework.boot.cli.compiler.autoconfigure.SpringMvcCompilerAutoConfiguration;
import org.springframework.boot.dependency.tools.Dependencies;
import org.springframework.boot.dependency.tools.ManagedDependencies;

public class GrailsApplicationCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public static final String[] DEFAULT_IMPORTS = new String[]{"grails.persistence", "grails.gorm", "grails.rest", "grails.artefact", "grails.web", "grails.boot.config"};
    public static final String ENABLE_AUTO_CONFIGURATION = "org.springframework.boot.autoconfigure.EnableAutoConfiguration";
    public static final ClassNode ENABLE_AUTO_CONFIGURATION_CLASS_NODE = ClassHelper.make((String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration");
    ClassNode lastMatch = null;

    public boolean matches(ClassNode classNode) {
        boolean matches = AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"grails.persistence.Entity", "grails.rest.Resource", "Resource", "grails.artefact.Artefact", "grails.web.Controller"});
        if (matches) {
            this.lastMatch = classNode;
        }
        return matches;
    }

    public void applyDependencies(DependencyCustomizer dependencies) throws CompilationFailedException {
        this.addManagedDependencies(dependencies);
        if (this.lastMatch != null) {
            this.lastMatch.addAnnotation(GrailsApplicationCompilerAutoConfiguration.createGrabAnnotation("org.grails", "grails-dependencies", Environment.class.getPackage().getImplementationVersion(), null, "pom", true));
            this.lastMatch.addAnnotation(GrailsApplicationCompilerAutoConfiguration.createGrabAnnotation("org.grails", "grails-web-boot", Environment.class.getPackage().getImplementationVersion(), null, null, true));
        }
        new SpringMvcCompilerAutoConfiguration().applyDependencies(dependencies);
    }

    private void addManagedDependencies(DependencyCustomizer dependencies) {
        ArrayList<Dependencies> managedDependencies = new ArrayList<Dependencies>();
        managedDependencies.add(new GrailsDependencies(dependencies.getDependencyResolutionContext().getManagedDependencies()));
        managedDependencies.add(this.getAdditionalDependencies());
        dependencies.getDependencyResolutionContext().setManagedDependencies(ManagedDependencies.get(managedDependencies));
    }

    protected Dependencies getAdditionalDependencies() {
        return new GrailsDependencyVersions();
    }

    public static AnnotationNode createGrabAnnotation(String group, String module, String version, String classifier, String type, boolean transitive) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(Grab.class));
        annotationNode.addMember("group", (Expression)new ConstantExpression((Object)group));
        annotationNode.addMember("module", (Expression)new ConstantExpression((Object)module));
        annotationNode.addMember("version", (Expression)new ConstantExpression((Object)version));
        if (classifier != null) {
            annotationNode.addMember("classifier", (Expression)new ConstantExpression((Object)classifier));
        }
        if (type != null) {
            annotationNode.addMember("type", (Expression)new ConstantExpression((Object)type));
        }
        annotationNode.addMember("transitive", (Expression)new ConstantExpression((Object)transitive));
        annotationNode.addMember("initClass", (Expression)new ConstantExpression((Object)false));
        return annotationNode;
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addStarImports(DEFAULT_IMPORTS);
        new SpringMvcCompilerAutoConfiguration().applyImports(imports);
    }

    public void applyToMainClass(GroovyClassLoader loader, GroovyCompilerConfiguration configuration, GeneratorContext generatorContext, SourceUnit source, ClassNode classNode) throws CompilationFailedException {
        ClassNode applicationClassNode = new ClassNode("Application", 1, ClassHelper.make((String)"grails.boot.config.GrailsAutoConfiguration"));
        AnnotationNode enableAutoAnnotation = new AnnotationNode(ENABLE_AUTO_CONFIGURATION_CLASS_NODE);
        try {
            enableAutoAnnotation.addMember("exclude", (Expression)new ClassExpression(ClassHelper.make((String)"org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration")));
        }
        catch (Throwable e) {
            // empty catch block
        }
        applicationClassNode.addAnnotation(enableAutoAnnotation);
        applicationClassNode.setModule(source.getAST());
        applicationClassNode.addMethod("shouldScanDefaultPackage", 1, ClassHelper.Boolean_TYPE, new Parameter[0], null, (Statement)new ReturnStatement((Expression)new ConstantExpression((Object)Boolean.TRUE)));
        source.getAST().getClasses().add(0, applicationClassNode);
        classNode.addAnnotation(new AnnotationNode(ClassHelper.make((String)"org.grails.boot.internal.EnableAutoConfiguration")));
    }

    class GrailsDependencies
    implements Dependencies {
        private Map<String, org.springframework.boot.dependency.tools.Dependency> groupAndArtifactToDependency = new HashMap<String, org.springframework.boot.dependency.tools.Dependency>();
        private Map<String, String> artifactToGroupAndArtifact = new HashMap<String, String>();

        public GrailsDependencies(List<Dependency> dependencies) {
            for (Dependency dependency : dependencies) {
                String groupId = dependency.getArtifact().getGroupId();
                String artifactId = dependency.getArtifact().getArtifactId();
                String version = dependency.getArtifact().getVersion();
                ArrayList exclusions = new ArrayList();
                org.springframework.boot.dependency.tools.Dependency value = new org.springframework.boot.dependency.tools.Dependency(groupId, artifactId, version, exclusions);
                this.groupAndArtifactToDependency.put(groupId + ":" + artifactId, value);
                this.artifactToGroupAndArtifact.put(artifactId, groupId + ":" + artifactId);
            }
        }

        public org.springframework.boot.dependency.tools.Dependency find(String groupId, String artifactId) {
            return this.groupAndArtifactToDependency.get(groupId + ":" + artifactId);
        }

        public org.springframework.boot.dependency.tools.Dependency find(String artifactId) {
            String groupAndArtifact = this.artifactToGroupAndArtifact.get(artifactId);
            if (groupAndArtifact == null) {
                return null;
            }
            return this.groupAndArtifactToDependency.get(groupAndArtifact);
        }

        public Iterator<org.springframework.boot.dependency.tools.Dependency> iterator() {
            return this.groupAndArtifactToDependency.values().iterator();
        }
    }
}

