/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.profile.commands;

import grails.build.logging.GrailsConsole;
import grails.util.Environment;
import grails.util.GrailsNameUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.util.AntBuilder;
import java.io.File;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.build.logging.GrailsConsoleAntBuilder;
import org.grails.build.parsing.CommandLine;
import org.grails.cli.profile.Command;
import org.grails.cli.profile.CommandDescription;
import org.grails.cli.profile.ExecutionContext;
import org.grails.cli.profile.Profile;
import org.grails.cli.profile.ProfileRepository;
import org.grails.cli.profile.ProfileRepositoryAware;

public class CreateAppCommand
implements Command,
ProfileRepositoryAware,
GroovyObject {
    private static final String GRAILS_VERSION_FALLBACK_IN_IDE_ENVIRONMENTS_FOR_RUNNING_TESTS = "3.0.0.BUILD-SNAPSHOT";
    public static final String NAME = "create-app";
    private ProfileRepository profileRepository;
    private Map<String, String> variables;
    private String appname;
    private String groupname;
    private File targetDirectory;
    private List<String> binaryFileExtensions;
    private CommandDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CreateAppCommand() {
        MetaClass metaClass;
        CommandDescription commandDescription;
        List list;
        Map map;
        this.variables = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.binaryFileExtensions = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"png", "gif", "jpg", "jpeg", "ico", "icns", "pdf", "zip", "jar", "class"});
        this.description = commandDescription = new CommandDescription(this.getName(), "Creates an application", "create-app [NAME] --profile=web");
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.populateDescription();
    }

    protected void populateDescription() {
        this.description.argument(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Application Name", "description", "The name of the application to create.", "required", false}));
        this.description.flag(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "inplace", "description", "Used to create an application using the current directory"}));
    }

    public String getName() {
        return NAME;
    }

    @Override
    public boolean handle(ExecutionContext executionContext) {
        if (this.profileRepository == null) {
            throw (Throwable)new IllegalStateException("Property 'profileRepository' must be set");
        }
        CommandLine mainCommandLine = executionContext.getCommandLine();
        String profileName = this.evaluateProfileName(mainCommandLine);
        Profile profileInstance = this.profileRepository.getProfile(profileName);
        if (DefaultTypeTransformation.booleanUnbox((Object)profileInstance)) {
            File file;
            if (!this.initializeVariables(profileInstance, mainCommandLine)) {
                return false;
            }
            this.targetDirectory = file = mainCommandLine.hasOption("inplace") ? new File(".").getCanonicalFile() : new File(this.appname);
            File applicationYmlFile = new File(this.targetDirectory, "grails-app/conf/application.yml");
            List<Profile> profiles = this.profileRepository.getProfileAndDependencies(profileInstance);
            Profile p = null;
            Iterator<Profile> iterator = profiles.iterator();
            while (iterator.hasNext()) {
                p = (Profile)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Profile.class);
                String previousApplicationYml = ShortTypeHandling.castToString((Object)(applicationYmlFile.isFile() ? ResourceGroovyMethods.getText((File)applicationYmlFile) : null));
                this.copySkeleton(profileInstance, this.profileRepository.getProfileDirectory(p.getName()));
                if (!applicationYmlFile.exists()) {
                    File file2;
                    applicationYmlFile = file2 = new File("application.yml");
                }
                if (!applicationYmlFile.exists()) continue;
                this.appendToYmlSubDocument(applicationYmlFile, previousApplicationYml);
            }
            executionContext.getConsole().addStatus(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ScriptBytecodeAdapter.compareEqual((Object)this.getName(), (Object)"create-plugin") ? "Plugin" : "Application", this.targetDirectory.getAbsolutePath()}, new String[]{"", " created at ", ""})));
            return true;
        }
        DefaultGroovyMethods.println((PrintStream)System.err, (Object)new GStringImpl(new Object[]{profileName}, new String[]{"Cannot find profile ", ""}));
        return false;
    }

    protected String evaluateProfileName(CommandLine mainCommandLine) {
        Object object = mainCommandLine.optionValue("profile");
        String string = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.getDefaultProfile();
    }

    protected String getDefaultProfile() {
        return ProfileRepository.DEFAULT_PROFILE_NAME;
    }

    private void appendToYmlSubDocument(File applicationYmlFile, String previousApplicationYml) {
        String newApplicationYml = ResourceGroovyMethods.getText((File)applicationYmlFile);
        if (DefaultTypeTransformation.booleanUnbox((Object)previousApplicationYml) && ScriptBytecodeAdapter.compareNotEqual((Object)newApplicationYml, (Object)previousApplicationYml)) {
            StringBuilder appended = new StringBuilder(previousApplicationYml.length() + newApplicationYml.length() + 30);
            if (!previousApplicationYml.startsWith("---")) {
                appended.append("---\n");
            }
            appended.append(previousApplicationYml).append("\n---\n");
            appended.append(newApplicationYml);
            String string = appended.toString();
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)applicationYmlFile, (String)"text");
        }
    }

    protected boolean initializeVariables(Profile profile, CommandLine commandLine) {
        String defaultPackage = null;
        List args = commandLine.getRemainingArgs();
        boolean inPlace = commandLine.hasOption("inplace");
        if (!DefaultTypeTransformation.booleanUnbox((Object)args) && !inPlace) {
            GrailsConsole.getInstance().error("Specify an application name or use --inplace to create an application in the current directory");
            return false;
        }
        String groupAndAppName = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox((Object)args) ? DefaultGroovyMethods.getAt((List)args, (int)0) : null);
        if (inPlace) {
            String string;
            this.appname = string = new File(".").getCanonicalFile().getName();
            if (DefaultTypeTransformation.booleanUnbox((Object)groupAndAppName)) {
                String string2;
                String string3;
                this.groupname = string3 = groupAndAppName;
                defaultPackage = string2 = this.groupname;
            } else {
                String string4;
                try {
                    String string5;
                    defaultPackage = string5 = this.createValidPackageName();
                }
                catch (IllegalArgumentException e) {
                    GrailsConsole.getInstance().error(e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                this.groupname = string4 = defaultPackage;
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)groupAndAppName)) {
                GrailsConsole.getInstance().error("Specify an application name or use --inplace to create an application in the current directory");
                return false;
            }
            List parts = (List)ScriptBytecodeAdapter.asType((Object)groupAndAppName.split("\\."), List.class);
            if (parts.size() == 1) {
                String string;
                Object object = DefaultGroovyMethods.getAt((List)parts, (int)0);
                this.appname = ShortTypeHandling.castToString((Object)object);
                try {
                    String string6;
                    defaultPackage = string6 = this.createValidPackageName();
                }
                catch (IllegalArgumentException e) {
                    GrailsConsole.getInstance().error(e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                this.groupname = string = defaultPackage;
            } else {
                String string;
                String string7;
                Object object = DefaultGroovyMethods.getAt((List)parts, (int)-1);
                this.appname = ShortTypeHandling.castToString((Object)object);
                this.groupname = string7 = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.getAt((List)parts, (Range)new IntRange(true, 0, Integer.valueOf(-2).intValue())), (String)".");
                defaultPackage = string = this.groupname;
            }
        }
        String string = this.appname;
        ScriptBytecodeAdapter.setProperty((Object)string, null, this.variables, (String)"APPNAME");
        String string8 = defaultPackage;
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.codegen.defaultPackage", (Object)string8);
        String string9 = defaultPackage.replace(".", "/");
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.codegen.defaultPackage.path", (Object)string9);
        String projectClassName = GrailsNameUtils.getNameFromScript((String)this.appname);
        String string10 = projectClassName;
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.codegen.projectClassName", (Object)string10);
        String string11 = GrailsNameUtils.getNaturalName((String)projectClassName);
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.codegen.projectNaturalName", (Object)string11);
        String string12 = GrailsNameUtils.getScriptName((String)projectClassName);
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.codegen.projectName", (Object)string12);
        String string13 = profile.getName();
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.profile", (Object)string13);
        String string14 = Environment.class.getPackage().getImplementationVersion();
        String string15 = DefaultTypeTransformation.booleanUnbox((Object)string14) ? string14 : GRAILS_VERSION_FALLBACK_IN_IDE_ENVIRONMENTS_FOR_RUNNING_TESTS;
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.version", (Object)string15);
        String string16 = this.appname;
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.app.name", (Object)string16);
        String string17 = this.groupname;
        DefaultGroovyMethods.putAt(this.variables, (Object)"grails.app.group", (Object)string17);
        return DefaultTypeTransformation.booleanUnbox((Object)string17);
    }

    private String createValidPackageName() {
        class _createValidPackageName_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createValidPackageName_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String token) {
                class _closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(char ch) {
                        return Character.isJavaIdentifierPart(ch);
                    }

                    public Object call(char ch) {
                        return this.doCall(ch);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return (String)ScriptBytecodeAdapter.asType((Object)((char[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.findAll((Object)token.toLowerCase().toCharArray(), (Closure)new _closure4((Object)this, this.getThisObject())), char[].class)), String.class);
            }

            public Object call(String token) {
                return this.doCall(token);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createValidPackageName_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String defaultPackage = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)this.appname.split("[-]+"), (Closure)new _createValidPackageName_closure1(this, this)), (String)".");
        if (!GrailsNameUtils.isValidJavaPackage((String)defaultPackage)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.appname}, new String[]{"Cannot create a valid package name for [", "]. Please specify a name that is also a valid Java package."})));
        }
        return defaultPackage;
    }

    private void copySkeleton(Profile profile, File profileDirectory) {
        CallSite[] callSiteArray = CreateAppCommand.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)profile), (Object)"skeleton", (Object)"excludes");
        Reference excludes = new Reference(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        AntBuilder ant = (AntBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(GrailsConsoleAntBuilder.class), AntBuilder.class);
        Reference srcDir = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(File.class, (Object)profileDirectory, (Object)"skeleton"), File.class)));
        callSiteArray[4].call((Object)ant, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"file", new GStringImpl(new Object[]{(File)srcDir.get()}, new String[]{"", "/.gitignore"}), "todir", this.targetDirectory, "failonerror", false}));
        class _copySkeleton_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDir;
            private /* synthetic */ Reference excludes;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copySkeleton_closure2(Object _outerInstance, Object _thisObject, Reference srcDir, Reference excludes) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _copySkeleton_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcDir = reference2 = srcDir;
                this.excludes = reference = excludes;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copySkeleton_closure2.$getCallSiteArray();
                class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference excludes;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference excludes) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.excludes = reference = excludes;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "**/.gitkeep"}));
                        Object exc = null;
                        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(this.excludes.get()), Iterator.class);
                        while (iterator.hasNext()) {
                            exc = iterator.next();
                            callSiteArray[2].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", exc}));
                        }
                        class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure8(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object ext) {
                                CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", new GStringImpl(new Object[]{ext}, new String[]{"**/*.", ""})}));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "exclude";
                                return new CallSiteArray(_closure8.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure8.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)new _closure8((Object)this, this.getThisObject()));
                    }

                    public Object getExcludes() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.excludes.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "exclude";
                        stringArray[1] = "iterator";
                        stringArray[2] = "exclude";
                        stringArray[3] = "each";
                        stringArray[4] = "binaryFileExtensions";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure5.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dir", this.srcDir.get(), "casesensitive", false}), (Object)new _closure5((Object)this, this.getThisObject(), this.excludes));
                class _closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure6(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        class _closure9
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure9(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object k, Object v) {
                                CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"token", k, "value", v}));
                            }

                            public Object call(Object k, Object v) {
                                CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                                return callSiteArray[1].callCurrent((GroovyObject)this, k, v);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure9.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "filter";
                                stringArray[1] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure9.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure9.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure9.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new _closure9((Object)this, this.getThisObject()));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "variables";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[1].callCurrent((GroovyObject)this, (Object)new _closure6((Object)this, this.getThisObject()));
                class _closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure7(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        class _closure10
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure10(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                class _closure11
                                extends Closure
                                implements GeneratedClosure {
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure11(Object _outerInstance, Object _thisObject) {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                    }

                                    public Object doCall(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"from", callSiteArray[1].call((Object)new GStringImpl(new Object[]{k}, new String[]{"@", "@"})), "to", v}));
                                    }

                                    public Object call(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "replacestring";
                                        stringArray[1] = "toString";
                                        stringArray[2] = "doCall";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[3];
                                        _closure11.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure11.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure11.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new _closure11((Object)this, this.getThisObject()));
                            }

                            public Object doCall() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure10.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "each";
                                stringArray[1] = "variables";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure10.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure10.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure10.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)new _closure10((Object)this, this.getThisObject()));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "filtermapper";
                        return new CallSiteArray(_closure7.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure7.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)new _closure7((Object)this, this.getThisObject()));
            }

            public File getSrcDir() {
                CallSite[] callSiteArray = _copySkeleton_closure2.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.srcDir.get(), File.class);
            }

            public Object getExcludes() {
                CallSite[] callSiteArray = _copySkeleton_closure2.$getCallSiteArray();
                return this.excludes.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _copySkeleton_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copySkeleton_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fileSet";
                stringArray[1] = "filterset";
                stringArray[2] = "mapper";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _copySkeleton_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copySkeleton_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copySkeleton_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[5].call((Object)ant, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"todir", this.targetDirectory, "overwrite", true, "encoding", "UTF-8"}), (Object)new _copySkeleton_closure2(this, this, srcDir, excludes));
        class _copySkeleton_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference srcDir;
            private /* synthetic */ Reference excludes;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _copySkeleton_closure3(Object _outerInstance, Object _thisObject, Reference srcDir, Reference excludes) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _copySkeleton_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.srcDir = reference2 = srcDir;
                this.excludes = reference = excludes;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _copySkeleton_closure3.$getCallSiteArray();
                class _closure12
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference excludes;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure12(Object _outerInstance, Object _thisObject, Reference excludes) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.excludes = reference = excludes;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        class _closure14
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure14(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object ext) {
                                CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", new GStringImpl(new Object[]{ext}, new String[]{"**/*.", ""})}));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure14.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[1];
                                stringArray[0] = "include";
                                return new CallSiteArray(_closure14.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure14.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new _closure14((Object)this, this.getThisObject()));
                        Object exc = null;
                        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(this.excludes.get()), Iterator.class);
                        while (iterator.hasNext()) {
                            exc = iterator.next();
                            callSiteArray[3].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", exc}));
                        }
                        return null;
                    }

                    public Object getExcludes() {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        return this.excludes.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "binaryFileExtensions";
                        stringArray[2] = "iterator";
                        stringArray[3] = "exclude";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure12.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure12.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure12.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dir", this.srcDir.get(), "casesensitive", false}), (Object)new _closure12((Object)this, this.getThisObject(), this.excludes));
                class _closure13
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure13(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        class _closure15
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure15(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                class _closure16
                                extends Closure
                                implements GeneratedClosure {
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure16(Object _outerInstance, Object _thisObject) {
                                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                    }

                                    public Object doCall(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"from", callSiteArray[1].call((Object)new GStringImpl(new Object[]{k}, new String[]{"@", "@"})), "to", v}));
                                    }

                                    public Object call(Object k, Object v) {
                                        CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                        return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure16.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "replacestring";
                                        stringArray[1] = "toString";
                                        stringArray[2] = "doCall";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[3];
                                        _closure16.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure16.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure16.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new _closure16((Object)this, this.getThisObject()));
                            }

                            public Object doCall() {
                                CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure15.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "each";
                                stringArray[1] = "variables";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure15.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure15.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure15.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)new _closure15((Object)this, this.getThisObject()));
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "filtermapper";
                        return new CallSiteArray(_closure13.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure13.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)new _closure13((Object)this, this.getThisObject()));
            }

            public File getSrcDir() {
                CallSite[] callSiteArray = _copySkeleton_closure3.$getCallSiteArray();
                return (File)ScriptBytecodeAdapter.castToType((Object)this.srcDir.get(), File.class);
            }

            public Object getExcludes() {
                CallSite[] callSiteArray = _copySkeleton_closure3.$getCallSiteArray();
                return this.excludes.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _copySkeleton_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copySkeleton_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "fileSet";
                stringArray[1] = "mapper";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _copySkeleton_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copySkeleton_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copySkeleton_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[6].call((Object)ant, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"todir", this.targetDirectory, "overwrite", true}), (Object)new _copySkeleton_closure3(this, this, srcDir, excludes));
        callSiteArray[7].call((Object)ant, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"file", new GStringImpl(new Object[]{this.targetDirectory}, new String[]{"", "/gradlew"}), "perm", "u+x"}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreateAppCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Override
    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> map) {
        this.variables = map;
    }

    public String getAppname() {
        return this.appname;
    }

    public void setAppname(String string) {
        this.appname = string;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String string) {
        this.groupname = string;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File file) {
        this.targetDirectory = file;
    }

    public List<String> getBinaryFileExtensions() {
        return this.binaryFileExtensions;
    }

    public void setBinaryFileExtensions(List<String> list) {
        this.binaryFileExtensions = list;
    }

    @Override
    public CommandDescription getDescription() {
        return this.description;
    }

    public void setDescription(CommandDescription commandDescription) {
        this.description = commandDescription;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "navigate";
        stringArray[1] = "configuration";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "copy";
        stringArray[5] = "copy";
        stringArray[6] = "copy";
        stringArray[7] = "chmod";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[8];
        CreateAppCommand.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CreateAppCommand.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CreateAppCommand.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

