/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.web.ServletContextApplicationContextInitializer;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.ServerPortInfoApplicationContextInitializer;
import org.springframework.boot.test.WebIntegrationTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringApplicationContextLoader
extends AbstractContextLoader {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public ApplicationContext loadContext(MergedContextConfiguration config) throws Exception {
        this.assertValidAnnotations(config.getTestClass());
        SpringApplication application = this.getSpringApplication();
        application.setMainApplicationClass(config.getTestClass());
        application.setSources(this.getSources(config));
        StandardEnvironment environment = new StandardEnvironment();
        if (!ObjectUtils.isEmpty((Object[])config.getActiveProfiles())) {
            this.setActiveProfiles((ConfigurableEnvironment)environment, config.getActiveProfiles());
        }
        Map<String, Object> properties = this.getEnvironmentProperties(config);
        this.addProperties((ConfigurableEnvironment)environment, properties);
        application.setEnvironment((ConfigurableEnvironment)environment);
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(config, application);
        if (config instanceof WebMergedContextConfiguration) {
            new WebConfigurer().configure(config, application, initializers);
        } else {
            application.setWebEnvironment(false);
        }
        application.setInitializers(initializers);
        ConfigurableApplicationContext applicationContext = application.run(new String[0]);
        return applicationContext;
    }

    private void assertValidAnnotations(Class<?> testClass) {
        boolean hasWebIntegrationTest;
        boolean hasWebAppConfiguration = AnnotationUtils.findAnnotation(testClass, WebAppConfiguration.class) != null;
        boolean bl = hasWebIntegrationTest = AnnotationUtils.findAnnotation(testClass, WebIntegrationTest.class) != null;
        if (hasWebAppConfiguration && hasWebIntegrationTest) {
            throw new IllegalStateException("@WebIntegrationTest and @WebAppConfiguration cannot be used together");
        }
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Object[0]);
    }

    private Set<Object> getSources(MergedContextConfiguration mergedConfig) {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(Arrays.asList(mergedConfig.getClasses()));
        sources.addAll(Arrays.asList(mergedConfig.getLocations()));
        Assert.state((sources.size() > 0 ? 1 : 0) != 0, (String)("No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ")."));
        return sources;
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        EnvironmentTestUtils.addEnvironment(environment, "spring.profiles.active=" + StringUtils.arrayToCommaDelimitedString((Object[])profiles));
    }

    protected Map<String, Object> getEnvironmentProperties(MergedContextConfiguration config) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.disableJmx(properties);
        properties.putAll(this.extractEnvironmentProperties(config.getPropertySourceProperties()));
        if (!SpringApplicationContextLoader.isIntegrationTest(config.getTestClass())) {
            properties.putAll(this.getDefaultEnvironmentProperties());
        }
        return properties;
    }

    private void disableJmx(Map<String, Object> properties) {
        properties.put("spring.jmx.enabled", "false");
    }

    final Map<String, Object> extractEnvironmentProperties(String[] values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        String content = StringUtils.arrayToDelimitedString((Object[])values, (String)LINE_SEPARATOR);
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(content));
            return this.asMap(properties);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected could not load properties from '" + content + "'", ex);
        }
    }

    private Map<String, Object> asMap(Properties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    private Map<String, String> getDefaultEnvironmentProperties() {
        return Collections.singletonMap("server.port", "-1");
    }

    private void addProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource("integrationTest", properties));
    }

    private List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration mergedConfig, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        initializers.add(new PropertySourceLocationsInitializer(mergedConfig.getPropertySourceLocations()));
        initializers.add(new ServerPortInfoApplicationContextInitializer());
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : mergedConfig.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiate((Class)initializerClass));
        }
        return initializers;
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (!configAttributes.hasLocations() && !configAttributes.hasClasses()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    private static boolean isIntegrationTest(Class<?> testClass) {
        return AnnotationUtils.findAnnotation(testClass, IntegrationTest.class) != null || AnnotationUtils.findAnnotation(testClass, WebIntegrationTest.class) != null;
    }

    private static class PropertySourceLocationsInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final String[] propertySourceLocations;

        public PropertySourceLocationsInitializer(String[] propertySourceLocations) {
            this.propertySourceLocations = propertySourceLocations;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableApplicationContext)applicationContext, (String[])this.propertySourceLocations);
        }
    }

    private static class WebConfigurer {
        private static final Class<GenericWebApplicationContext> WEB_CONTEXT_CLASS = GenericWebApplicationContext.class;

        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration configuration, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfiguration = (WebMergedContextConfiguration)configuration;
            if (!SpringApplicationContextLoader.isIntegrationTest(webConfiguration.getTestClass())) {
                this.addMockServletContext(initializers, webConfiguration);
                application.setApplicationContextClass(WEB_CONTEXT_CLASS);
            }
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webConfiguration) {
            MockServletContext servletContext = new MockServletContext(webConfiguration.getResourceBasePath(), (ResourceLoader)new FileSystemResourceLoader());
            initializers.add(0, new ServletContextApplicationContextInitializer((ServletContext)servletContext));
        }
    }
}

