/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dependency.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.boot.dependency.tools.Assert;
import org.springframework.boot.dependency.tools.Dependencies;
import org.springframework.boot.dependency.tools.Dependency;

abstract class AbstractDependencies
implements Dependencies {
    private final Map<ArtifactAndGroupId, Dependency> byArtifactAndGroupId = new LinkedHashMap<ArtifactAndGroupId, Dependency>();
    private final Map<String, Dependency> byArtifactId = new LinkedHashMap<String, Dependency>();

    @Override
    public Dependency find(String groupId, String artifactId) {
        return this.byArtifactAndGroupId.get(new ArtifactAndGroupId(groupId, artifactId));
    }

    @Override
    public Dependency find(String artifactId) {
        return this.byArtifactId.get(artifactId);
    }

    @Override
    public Iterator<Dependency> iterator() {
        return this.byArtifactAndGroupId.values().iterator();
    }

    protected void add(ArtifactAndGroupId artifactAndGroupId, Dependency dependency) {
        Dependency existing = this.byArtifactAndGroupId.get(artifactAndGroupId);
        if (existing != null) {
            dependency = this.mergeDependencies(existing, dependency);
        }
        this.byArtifactAndGroupId.put(artifactAndGroupId, dependency);
        this.byArtifactId.put(dependency.getArtifactId(), dependency);
    }

    private Dependency mergeDependencies(Dependency existingDependency, Dependency newDependency) {
        LinkedHashSet<Dependency.Exclusion> combinedExclusions = new LinkedHashSet<Dependency.Exclusion>();
        combinedExclusions.addAll(existingDependency.getExclusions());
        combinedExclusions.addAll(newDependency.getExclusions());
        return new Dependency(newDependency.getGroupId(), newDependency.getArtifactId(), newDependency.getVersion(), new ArrayList<Dependency.Exclusion>(combinedExclusions));
    }

    protected static class ArtifactAndGroupId {
        private final String groupId;
        private final String artifactId;

        public ArtifactAndGroupId(Dependency dependency) {
            this(dependency.getGroupId(), dependency.getArtifactId());
        }

        public ArtifactAndGroupId(String groupId, String artifactId) {
            Assert.notNull(groupId, "GroupId must not be null");
            Assert.notNull(artifactId, "ArtifactId must not be null");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Dependency newDependency(String version) {
            return new Dependency(this.groupId, this.artifactId, version);
        }

        public int hashCode() {
            return this.groupId.hashCode() * 31 + this.artifactId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ArtifactAndGroupId other = (ArtifactAndGroupId)obj;
                boolean result = true;
                result &= this.groupId.equals(other.groupId);
                return result &= this.artifactId.equals(other.artifactId);
            }
            return false;
        }
    }
}

