/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child")
public abstract class ArrayCastNode
extends RubyNode {
    private final SplatCastNode.NilBehavior nilBehavior;
    @Node.Child
    private CallDispatchHeadNode toArrayNode;

    public ArrayCastNode(RubyContext context, SourceSection sourceSection) {
        this(context, sourceSection, SplatCastNode.NilBehavior.NIL);
    }

    public ArrayCastNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior) {
        super(context, sourceSection);
        this.toArrayNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.nilBehavior = nilBehavior;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public DynamicObject cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(int value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(long value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(double value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject castBignum(DynamicObject value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject castArray(DynamicObject array) {
        return array;
    }

    @Specialization(guards={"isNil(nil)"})
    public Object cast(Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            }
            case ARRAY_WITH_NIL: {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{this.nil()}, 1);
            }
            case NIL: {
                return nil;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubyArray(object)"})
    public Object cast(VirtualFrame frame, DynamicObject object) {
        Object result = this.toArrayNode.call(frame, object, "to_ary", null, new Object[0]);
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!RubyGuards.isRubyArray(result)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertTo(object, "Array", "to_ary", result, this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

