/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyInteger;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.EncodingOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertBytes;
import org.jruby.util.StringSupport;

public abstract class StringPrimitiveNodes {

    @RubiniusPrimitive(name="string_from_bytearray", needsSelf=false, lowerFixnumParameters={1, 2})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromByteArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubiniusByteArray(bytes)"})
        public DynamicObject stringFromByteArray(DynamicObject bytes, int start, int count) {
            ByteList byteList = Layouts.BYTE_ARRAY.getBytes(bytes);
            return this.createString(new ByteList(byteList, start, count));
        }
    }

    @RubiniusPrimitive(name="string_substring", lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object execute(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)", "len >= 0"})
        public Object stringSubstringSingleByteOptimizable(DynamicObject string, int beg, int len, @Cached(value="createBinaryProfile()") ConditionProfile emptyStringProfile, @Cached(value="createBinaryProfile()") ConditionProfile tooLargeBeginProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeBeginProfile, @Cached(value="createBinaryProfile()") ConditionProfile stillNegativeBeginProfile, @Cached(value="createBinaryProfile()") ConditionProfile tooLargeTotalProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile) {
            int length = StringOperations.getByteList(string).getRealSize();
            if (emptyStringProfile.profile(length == 0)) {
                len = 0;
            }
            if (tooLargeBeginProfile.profile(beg > length)) {
                return this.nil();
            }
            if (negativeBeginProfile.profile(beg < 0) && stillNegativeBeginProfile.profile((beg += length) < 0)) {
                return this.nil();
            }
            if (tooLargeTotalProfile.profile(beg + len > length)) {
                len = length - beg;
            }
            if (negativeLengthProfile.profile(len <= 0)) {
                len = 0;
                beg = 0;
            }
            return this.makeSubstring(string, beg, len);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)", "len >= 0"})
        public Object stringSubstring(DynamicObject string, int beg, int len) {
            int p;
            int length = StringOperations.getByteList(string).getRealSize();
            if (length == 0) {
                len = 0;
            }
            if (beg + len > length) {
                len = length - beg;
            }
            ByteList value = StringOperations.getByteList(string);
            Encoding enc = value.getEncoding();
            int s = value.getBegin();
            int end = s + length;
            byte[] bytes = value.getUnsafeBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    return this.makeSubstring(string, p2 - s, e - p2);
                }
                if ((beg += StringSupport.strLengthFromRubyString((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)enc)) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > StringSupport.strLengthFromRubyString((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)enc)) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (StringOperations.isCodeRangeValid(string) && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth((byte[])bytes, (int)s, (int)end, (int)beg);
                len = StringSupport.utf8Offset((byte[])bytes, (int)p, (int)end, (int)len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth((Encoding)enc, (byte[])bytes, (int)s, (int)end, (int)beg);
                len = p == end ? 0 : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)len);
            }
            return this.makeSubstring(string, p - s, len);
        }

        @Specialization(guards={"len < 0"})
        public Object stringSubstringNegativeLength(DynamicObject string, int beg, int len) {
            return this.nil();
        }

        private DynamicObject makeSubstring(DynamicObject string, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new ByteList(StringOperations.getByteList(string), beg, len), 0, null);
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringByteAppend(DynamicObject string, DynamicObject other) {
            StringOperations.getByteList(string).append(StringOperations.getByteList(other));
            return string;
        }
    }

    @RubiniusPrimitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToInumPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToInum(DynamicObject string, int fixBase, boolean strict) {
            try {
                RubyInteger result = ConvertBytes.byteListToInum19((Ruby)this.getContext().getRuntime(), (ByteList)StringOperations.getByteList(string), (int)fixBase, (boolean)strict);
                return this.getContext().toTruffle((IRubyObject)result);
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(e.getException(), this));
            }
        }
    }

    @RubiniusPrimitive(name="string_pattern", lowerFixnumParameters={0, 1})
    public static abstract class StringPatternPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public StringPatternPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"value == 0"})
        public DynamicObject stringPatternZero(DynamicObject stringClass, int size, int value) {
            ByteList bytes = new ByteList(new byte[size]);
            return this.allocateObjectNode.allocate(stringClass, bytes, 0, null);
        }

        @Specialization(guards={"value != 0"})
        public DynamicObject stringPattern(DynamicObject stringClass, int size, int value) {
            byte[] bytes = new byte[size];
            Arrays.fill(bytes, (byte)value);
            return this.allocateObjectNode.allocate(stringClass, new ByteList(bytes), 0, null);
        }

        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject stringPattern(DynamicObject stringClass, int size, DynamicObject string) {
            byte[] bytes = new byte[size];
            ByteList byteList = StringOperations.getByteList(string);
            if (byteList.length() > 0) {
                for (int n = 0; n < size; n += byteList.length()) {
                    System.arraycopy(byteList.unsafeBytes(), byteList.begin(), bytes, n, Math.min(byteList.length(), size - n));
                }
            }
            return this.allocateObjectNode.allocate(stringClass, new ByteList(bytes), 0, null);
        }
    }

    @RubiniusPrimitive(name="string_rindex", lowerFixnumParameters={1})
    public static abstract class StringRindexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringRindexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringRindex(DynamicObject string, DynamicObject pattern, int start) {
            int pos = start;
            if (pos < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            ByteList buf = StringOperations.getByteList(string);
            int total = buf.getRealSize();
            int matchSize = StringOperations.getByteList(pattern).getRealSize();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = StringOperations.getByteList(pattern).get(0);
                    while (pos >= 0) {
                        if (buf.get(pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ByteList.memcmp((byte[])StringOperations.getByteList(string).getUnsafeBytes(), (int)cur, (byte[])StringOperations.getByteList(pattern).getUnsafeBytes(), (int)0, (int)matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_resize_capacity", needsSelf=false, lowerFixnumParameters={1})
    public static abstract class StringResizeCapacityPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringResizeCapacityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject stringResizeCapacity(DynamicObject string, int capacity) {
            StringOperations.getByteList(string).ensure(capacity);
            return string;
        }
    }

    @RubiniusPrimitive(name="string_copy_from", needsSelf=false, lowerFixnumParameters={2, 3, 4})
    public static abstract class StringCopyFromPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCopyFromPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)", "size >= 0", "!offsetTooLarge(start, other)", "!offsetTooLargeRaw(dest, string)"})
        public DynamicObject stringCopyFrom(DynamicObject string, DynamicObject other, int start, int size, int dest, @Cached(value="createBinaryProfile()") ConditionProfile negativeStartOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInReplacementProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeDestinationOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInStringProfile) {
            int src = start;
            int dst = dest;
            int cnt = size;
            ByteList otherBytes = StringOperations.getByteList(other);
            int osz = otherBytes.length();
            if (negativeStartOffsetProfile.profile(src < 0)) {
                src = 0;
            }
            if (sizeTooLargeInReplacementProfile.profile(cnt > osz - src)) {
                cnt = osz - src;
            }
            ByteList stringBytes = StringOperations.getByteList(string);
            int sz = stringBytes.unsafeBytes().length - stringBytes.begin();
            if (negativeDestinationOffsetProfile.profile(dst < 0)) {
                dst = 0;
            }
            if (sizeTooLargeInStringProfile.profile(cnt > sz - dst)) {
                cnt = sz - dst;
            }
            System.arraycopy(otherBytes.unsafeBytes(), otherBytes.begin() + src, stringBytes.getUnsafeBytes(), stringBytes.begin() + dest, cnt);
            return string;
        }

        @Specialization(guards={"isRubyString(other)", "size < 0 || (offsetTooLarge(start, other) || offsetTooLargeRaw(dest, string))"})
        public DynamicObject stringCopyFromWithNegativeSize(DynamicObject string, DynamicObject other, int start, int size, int dest) {
            return string;
        }

        protected boolean offsetTooLarge(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return offset >= StringOperations.getByteList(string).realSize();
        }

        protected boolean offsetTooLargeRaw(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            ByteList byteList = StringOperations.getByteList(string);
            return offset >= byteList.unsafeBytes().length - byteList.begin();
        }
    }

    @RubiniusPrimitive(name="string_previous_byte_index")
    public static abstract class StringPreviousByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringPreviousByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object stringPreviousByteIndex(DynamicObject string, int index) {
            if (index < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative index given", this));
            }
            ByteList bytes = StringOperations.getByteList(string);
            int p = bytes.getBegin();
            int end = p + bytes.getRealSize();
            int b = bytes.getEncoding().prevCharHead(bytes.getUnsafeBytes(), p, p + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - p;
        }
    }

    @RubiniusPrimitive(name="string_byte_index", needsSelf=false, lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object stringByteIndexSingleByte(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile) {
            ByteList byteList = StringOperations.getByteList(string);
            if (indexTooLargeProfile.profile(byteList.realSize() < index)) {
                return this.nil();
            }
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object stringByteIndex(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile, @Cached(value="createBinaryProfile()") ConditionProfile invalidByteProfile) {
            int i;
            ByteList bytes = StringOperations.getByteList(string);
            Encoding enc = bytes.getEncoding();
            int p = bytes.getBegin();
            int e = p + bytes.getRealSize();
            int k = index;
            if (k < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("character index is negative", this));
            }
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)p, (int)e);
                if (invalidByteProfile.profile(!StringSupport.MBCLEN_CHARFOUND_P((int)c))) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            }
            if (indexTooLargeProfile.profile(i < k)) {
                return this.nil();
            }
            return p - bytes.begin();
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringByteIndex(DynamicObject string, DynamicObject pattern, int offset) {
            int match_size = StringOperations.getByteList(pattern).length();
            if (offset < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            if (match_size == 0) {
                return offset;
            }
            if (StringOperations.scanForCodeRange(string) == 48) {
                return this.nil();
            }
            ByteList stringByteList = StringOperations.getByteList(string);
            ByteList patternByteList = StringOperations.getByteList(pattern);
            Encoding encoding = StringOperations.checkEncoding(this.getContext(), string, StringOperations.getCodeRangeable(pattern), this);
            int p = stringByteList.getBegin();
            int e = p + stringByteList.getRealSize();
            int pp = patternByteList.getBegin();
            int pe = pp + patternByteList.getRealSize();
            byte[] stringBytes = stringByteList.getUnsafeBytes();
            byte[] patternBytes = patternByteList.getUnsafeBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength((Encoding)encoding, (byte[])stringBytes, (int)s, (int)e);
                        if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                            return s - stringByteList.begin();
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_character_index", needsSelf=false, lowerFixnumParameters={2})
    public static abstract class StringCharacterIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCharacterIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringCharacterIndex(DynamicObject string, DynamicObject pattern, int offset) {
            int index;
            int c;
            if (offset < 0) {
                return this.nil();
            }
            int total = StringOperations.getByteList(string).length();
            int p = StringOperations.getByteList(string).getBegin();
            int e = p + total;
            int pp = StringOperations.getByteList(pattern).getBegin();
            int pe = pp + StringOperations.getByteList(pattern).length();
            byte[] stringBytes = StringOperations.getByteList(string).getUnsafeBytes();
            byte[] patternBytes = StringOperations.getByteList(pattern).getUnsafeBytes();
            if (StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)StringOperations.getByteList(string).getEncoding())) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = StringOperations.getByteList(string).getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P((int)(c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e)))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_byte_character_index", needsSelf=false)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexNode
    extends RubiniusPrimitiveNode {
        public StringByteCharacterIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract int executeStringBytCharacterIndex(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizableOrAsciiOnly(string)"})
        public int stringByteCharacterIndexSingleByte(DynamicObject string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndexFixedWidth(DynamicObject string, int index, int start) {
            return index / StringOperations.getByteList(string).getEncoding().minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "!isFixedWidthEncoding(string)", "isValidUtf8(string)"})
        public int stringByteCharacterIndexValidUtf8(DynamicObject string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "!isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndex(DynamicObject string, int index, int start) {
            ByteList bytes = StringOperations.getByteList(string);
            Encoding encoding = bytes.getEncoding();
            int p = bytes.begin() + start;
            int end = bytes.begin() + bytes.realSize();
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length((Encoding)encoding, (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @RubiniusPrimitive(name="string_character_byte_index", needsSelf=false, lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends RubiniusPrimitiveNode {
        public CharacterByteIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndex(DynamicObject string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndexMultiByteEncoding(DynamicObject string, int index, int start) {
            ByteList bytes = StringOperations.getByteList(string);
            return StringSupport.nth((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)(bytes.getBegin() + start), (int)(bytes.getBegin() + bytes.getRealSize()), (int)index) - bytes.begin();
        }
    }

    @RubiniusPrimitive(name="string_index", lowerFixnumParameters={1})
    public static abstract class StringIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        StringByteCharacterIndexNode byteIndexToCharIndexNode;

        public StringIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringIndex(VirtualFrame frame, DynamicObject string, DynamicObject pattern, int start) {
            if (this.byteIndexToCharIndexNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.byteIndexToCharIndexNode = this.insert(StringPrimitiveNodesFactory.StringByteCharacterIndexNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            int charIndex = this.byteIndexToCharIndexNode.executeStringBytCharacterIndex(frame, string, start, 0);
            int index = StringSupport.index((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)StringOperations.getCodeRangeable(pattern), (int)charIndex, (Encoding)StringOperations.getByteList(string).getEncoding());
            if (index == -1) {
                return this.nil();
            }
            return index;
        }
    }

    @RubiniusPrimitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToFPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToF(DynamicObject string) {
            try {
                return Double.parseDouble(string.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @RubiniusPrimitive(name="string_from_codepoint", needsSelf=false)
    public static abstract class StringFromCodepointPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromCodepointPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyEncoding(encoding)", "isSimple(code, encoding)"})
        public DynamicObject stringFromCodepointSimple(int code, DynamicObject encoding) {
            return this.createString(new ByteList(new byte[]{(byte)code}, EncodingOperations.getEncoding(encoding)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)", "!isSimple(code, encoding)"})
        public DynamicObject stringFromCodepoint(int code, DynamicObject encoding) {
            int length;
            try {
                length = EncodingOperations.getEncoding(encoding).codeToMbcLength(code);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            if (length <= 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            byte[] bytes = new byte[length];
            try {
                EncodingOperations.getEncoding(encoding).codeToMbc(code, bytes, 0);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            return this.createString(new ByteList(bytes, EncodingOperations.getEncoding(encoding)));
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject stringFromCodepointSimple(long code, DynamicObject encoding) {
            if (code < Integer.MIN_VALUE || code > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            return this.stringFromCodepointSimple((int)code, encoding);
        }

        protected boolean isSimple(int code, DynamicObject encoding) {
            return EncodingOperations.getEncoding(encoding) == ASCIIEncoding.INSTANCE && code >= 0 && code <= 255;
        }
    }

    @RubiniusPrimitive(name="string_find_character")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public StringFindCharacterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isSingleByte(string)"})
        public Object stringFindCharacterSingleByte(DynamicObject string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            ByteList byteList = StringOperations.getByteList(string);
            if (offset >= byteList.getRealSize()) {
                return this.nil();
            }
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new ByteList(byteList, offset, 1), 0, null);
            return this.propagate(string, ret);
        }

        @Specialization(guards={"!isSingleByte(string)"})
        public Object stringFindCharacter(DynamicObject string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            ByteList byteList = StringOperations.getByteList(string);
            if (offset >= byteList.getRealSize()) {
                return this.nil();
            }
            ByteList bytes = byteList;
            Encoding enc = bytes.getEncoding();
            int clen = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)bytes.begin(), (int)(bytes.begin() + bytes.realSize()));
            DynamicObject ret = StringSupport.MBCLEN_CHARFOUND_P((int)clen) ? this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new ByteList(byteList, offset, clen), 0, null) : this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new ByteList(byteList, offset, 1), 0, null);
            return this.propagate(string, ret);
        }

        private Object propagate(DynamicObject string, DynamicObject ret) {
            StringOperations.getByteList(ret).setEncoding(StringOperations.getByteList(string).getEncoding());
            Layouts.STRING.setCodeRange(ret, Layouts.STRING.getCodeRange(string));
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(DynamicObject source, DynamicObject value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            return this.taintResultNode.maybeTaint(source, value);
        }
    }

    @RubiniusPrimitive(name="string_equal", needsSelf=true)
    public static abstract class StringEqualPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeStringEqual(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"string == other"})
        public boolean stringEqualsSameObject(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"string != other", "isRubyString(other)", "!areComparable(string, other, sameEncodingProfile, firstStringEmptyProfile, secondStringEmptyProfile, firstStringCR7BitProfile, secondStringCR7BitProfile, firstStringAsciiCompatible, secondStringAsciiCompatible)"})
        public boolean stringEqualNotComparable(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile sameEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile secondStringAsciiCompatible) {
            return false;
        }

        @Specialization(guards={"string != other", "isRubyString(other)", "areComparable(string, other, sameEncodingProfile, firstStringEmptyProfile, secondStringEmptyProfile, firstStringCR7BitProfile, secondStringCR7BitProfile, firstStringAsciiCompatible, secondStringAsciiCompatible)"})
        public boolean stringEqual(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile sameEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile secondStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile sameByteListProfile, @Cached(value="createBinaryProfile()") ConditionProfile differentHashCodeProfile, @Cached(value="createBinaryProfile()") ConditionProfile differentSizeProfile) {
            ByteList b;
            ByteList a = StringOperations.getByteList(string);
            if (sameByteListProfile.profile(a == (b = StringOperations.getByteList(other)))) {
                return true;
            }
            if (differentHashCodeProfile.profile(a.hashCode() != 0 && b.hashCode() != 0 && a.hashCode() != b.hashCode())) {
                return false;
            }
            if (differentSizeProfile.profile(a.realSize() != b.realSize())) {
                return false;
            }
            byte[] stringBytes = a.unsafeBytes();
            byte[] otherBytes = b.unsafeBytes();
            int stringBegin = a.begin();
            int otherBegin = b.begin();
            for (int i = 0; i < a.realSize(); ++i) {
                if (stringBytes[i + stringBegin] == otherBytes[i + otherBegin]) continue;
                return false;
            }
            return true;
        }

        protected boolean areComparable(DynamicObject first, DynamicObject second, ConditionProfile sameEncodingProfile, ConditionProfile firstStringEmptyProfile, ConditionProfile secondStringEmptyProfile, ConditionProfile firstStringCR7BitProfile, ConditionProfile secondStringCR7BitProfile, ConditionProfile firstStringAsciiCompatible, ConditionProfile secondStringAsciiCompatible) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            ByteList firstByteList = StringOperations.getByteList(first);
            ByteList secondByteList = StringOperations.getByteList(second);
            if (sameEncodingProfile.profile(firstByteList.getEncoding() == secondByteList.getEncoding())) {
                return true;
            }
            if (firstStringEmptyProfile.profile(firstByteList.realSize() == 0)) {
                return true;
            }
            if (secondStringEmptyProfile.profile(secondByteList.realSize() == 0)) {
                return true;
            }
            int firstCodeRange = StringOperations.scanForCodeRange(first);
            int secondCodeRange = StringOperations.scanForCodeRange(second);
            if (firstStringCR7BitProfile.profile(firstCodeRange == 16)) {
                if (secondStringCR7BitProfile.profile(secondCodeRange == 16)) {
                    return true;
                }
                if (secondStringAsciiCompatible.profile(secondByteList.getEncoding().isAsciiCompatible())) {
                    return true;
                }
            }
            return secondStringCR7BitProfile.profile(secondCodeRange == 16) && firstStringAsciiCompatible.profile(firstByteList.getEncoding().isAsciiCompatible());
        }
    }

    @RubiniusPrimitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private StringNodes.SizeNode sizeNode;

        public StringCompareSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        @Specialization(guards={"isRubyString(other)"})
        public int stringCompareSubstring(VirtualFrame frame, DynamicObject string, DynamicObject other, int start, int size) {
            int stringLength = this.sizeNode.executeInteger(frame, string);
            int otherLength = this.sizeNode.executeInteger(frame, other);
            if (start < 0) {
                start += otherLength;
            }
            if (start > otherLength) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (start < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            ByteList bytes = StringOperations.getByteList(string);
            ByteList otherBytes = StringOperations.getByteList(other);
            return ByteList.memcmp((byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)size, (byte[])otherBytes.getUnsafeBytes(), (int)(otherBytes.getBegin() + start), (int)size);
        }
    }

    @RubiniusPrimitive(name="string_chr_at", lowerFixnumParameters={0})
    public static abstract class StringChrAtPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private StringByteSubstringPrimitiveNode stringByteSubstringNode = StringPrimitiveNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]);

        public StringChrAtPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object stringChrAt(VirtualFrame frame, DynamicObject string, int byteIndex) {
            int end;
            ByteList bytes = StringOperations.getByteList(string);
            if (byteIndex < 0 || byteIndex >= bytes.getRealSize()) {
                return this.nil();
            }
            int p = bytes.getBegin() + byteIndex;
            int c = this.preciseLength(bytes, p, end = bytes.getBegin() + bytes.getRealSize());
            if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            return this.stringByteSubstringNode.stringByteSubstring(frame, string, byteIndex, n);
        }

        @CompilerDirectives.TruffleBoundary
        private int preciseLength(ByteList bytes, int p, int end) {
            return StringSupport.preciseLength((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
        }
    }

    @RubiniusPrimitive(name="string_check_null_safe", needsSelf=false)
    public static abstract class StringCheckNullSafePrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCheckNullSafePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject stringCheckNullSafe(DynamicObject string) {
            ByteList byteList = StringOperations.getByteList(string);
            for (int i = 0; i < byteList.length(); ++i) {
                if (byteList.get(i) != 0) continue;
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("string contains NULL byte", this));
            }
            return string;
        }
    }

    @RubiniusPrimitive(name="string_byte_substring")
    public static abstract class StringByteSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private StringNodes.SizeNode sizeNode;

        public StringByteSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, int index, NotProvided length) {
            Object subString = this.stringByteSubstring(frame, string, index, 1);
            if (subString == this.nil()) {
                return subString;
            }
            if (StringOperations.getByteList((DynamicObject)subString).length() == 0) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, int index, int length) {
            ByteList bytes = StringOperations.getByteList(string);
            if (length < 0) {
                return this.nil();
            }
            int stringLength = this.getSizeNode().executeInteger(frame, string);
            int normalizedIndex = StringOperations.normalizeIndex(stringLength, index);
            if (normalizedIndex < 0 || normalizedIndex > bytes.length()) {
                return this.nil();
            }
            if (normalizedIndex + length > bytes.length()) {
                length = bytes.length() - normalizedIndex;
            }
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new ByteList(bytes, normalizedIndex, length), 0, null);
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, int index, long length) {
            return this.stringByteSubstring(frame, string, (long)index, length);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, int index, double length) {
            return this.stringByteSubstring(frame, string, index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, DynamicObject length) {
            return null;
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, long index, NotProvided length) {
            return this.stringByteSubstring(frame, string, index, 1);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, long index, int length) {
            return this.stringByteSubstring(frame, string, index, (long)length);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, long index, long length) {
            if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("index out of int range", this));
            }
            if (length > Integer.MAX_VALUE || length < Integer.MIN_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("length out of int range", this));
            }
            return this.stringByteSubstring(frame, string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, long index, double length) {
            return this.stringByteSubstring(frame, string, index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, long index, DynamicObject length) {
            return null;
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, double index, NotProvided length) {
            return this.stringByteSubstring(frame, string, (int)index, 1);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, double index, int length) {
            return this.stringByteSubstring(frame, string, (int)index, length);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, double index, long length) {
            return this.stringByteSubstring(frame, string, (int)index, length);
        }

        @Specialization
        public Object stringByteSubstring(VirtualFrame frame, DynamicObject string, double index, double length) {
            return this.stringByteSubstring(frame, string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, double index, DynamicObject length) {
            return null;
        }

        @Specialization(guards={"isRubyRange(range)"})
        public Object stringByteSubstring(DynamicObject string, DynamicObject range, NotProvided length) {
            return null;
        }

        @Specialization(guards={"!isRubyRange(index)"})
        public Object stringByteSubstring(DynamicObject string, DynamicObject index, Object length) {
            return null;
        }

        private StringNodes.SizeNode getSizeNode() {
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.sizeNode = this.insert(StringNodesFactory.SizeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.sizeNode;
        }
    }

    @RubiniusPrimitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringAwkSplitPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject stringAwkSplit(DynamicObject string, int lim) {
            int p;
            ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
            ByteList value = StringOperations.getByteList(string);
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = value.getUnsafeBytes();
            int ptr = p = value.getBegin();
            int len = value.getRealSize();
            int end = p + len;
            Encoding enc = value.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)enc);
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    try {
                        c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end);
                    }
                    catch (RaiseException ex) {
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(ex.getException(), this));
                    }
                    p += StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            Object[] objects = ret.toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }

        private DynamicObject makeString(DynamicObject source, int index, int length) {
            assert (RubyGuards.isRubyString(source));
            ByteList bytes = new ByteList(StringOperations.getByteList(source), index, length);
            bytes.setEncoding(StringOperations.getByteList(source).getEncoding());
            DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), bytes, 0, null);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="character_printable_p")
    public static abstract class CharacterPrintablePrimitiveNode
    extends RubiniusPrimitiveNode {
        public CharacterPrintablePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isCharacterPrintable(DynamicObject character) {
            ByteList bytes = StringOperations.getByteList(character);
            Encoding encoding = bytes.getEncoding();
            int codepoint = encoding.mbcToCode(bytes.unsafeBytes(), bytes.begin(), bytes.begin() + bytes.realSize());
            return encoding.isPrint(codepoint);
        }
    }

    @RubiniusPrimitive(name="character_ascii_p")
    public static abstract class CharacterAsciiPrimitiveNode
    extends RubiniusPrimitiveNode {
        public CharacterAsciiPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isCharacterAscii(DynamicObject character) {
            ByteList bytes = StringOperations.getByteList(character);
            int codepoint = StringSupport.preciseCodePoint((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)(bytes.getBegin() + bytes.getRealSize()));
            boolean found = codepoint != -1;
            return found && Encoding.isAscii((int)codepoint);
        }
    }
}

