/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.frames.JDocumentPropertiesFrame;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class DocumentPropertiesSelectionTableAction
extends AbstractAction {
    private static final long serialVersionUID = -6587748182701807404L;
    private JPdfSelectionTable mainTable;

    public DocumentPropertiesSelectionTableAction(JPdfSelectionTable mainTable) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Document properties"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Show document properties"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/info.png")));
        this.mainTable = mainTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mainTable.getSelectedRowCount() == 1) {
            PdfSelectionTableItem row = ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).getRow(this.mainTable.getSelectedRow());
            JDocumentPropertiesFrame.getInstance().showProperties(row);
            JDocumentPropertiesFrame.getInstance().requestFocus();
        }
    }
}

