/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.dnd;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public final class DnDSupportUtility {
    private static final Logger log = Logger.getLogger(DnDSupportUtility.class.getPackage().getName());
    public static DataFlavor VISUAL_LIST_FLAVOR = null;
    public static DataFlavor URI_LIST_FLAVOR = null;
    private static final String URI_DELIMITER = "\r\n";

    private DnDSupportUtility() {
    }

    public static List<File> textURIListToFileList(String data) {
        ArrayList<File> retVal = new ArrayList<File>(1);
        Scanner scanner = new Scanner(data);
        scanner.useDelimiter(URI_DELIMITER);
        while (scanner.hasNext()) {
            String token = scanner.next();
            if (token == null || token.startsWith("#")) continue;
            try {
                File currentFile = new File(new URI(token));
                if (!currentFile.exists()) continue;
                retVal.add(currentFile);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return retVal;
    }

    static {
        try {
            if (VISUAL_LIST_FLAVOR == null) {
                VISUAL_LIST_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref");
            }
        }
        catch (ClassNotFoundException e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to initializate drag and drop support."), e);
        }
        try {
            if (URI_LIST_FLAVOR == null) {
                URI_LIST_FLAVOR = new DataFlavor("text/uri-list;class=java.lang.String");
            }
        }
        catch (ClassNotFoundException e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to initializate drag and drop support."), e);
        }
    }
}

