/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.freetype;

import de.intarsys.cwt.freetype.CharMap;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.FreetypeException;
import de.intarsys.cwt.freetype.GlyphSlot;
import de.intarsys.cwt.freetype.nativec.FTEnum;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.freetype.FreetypeGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class FreetypeFont
implements IPlatformFont {
    private static final Attribute ATTR_PLATFORMGLYPHS = new Attribute("platformGlyphs");
    protected static final Attribute ATTR_SCALE = new Attribute("platformFontScale");
    protected static final Attribute ATTR_TRANSFORM = new Attribute("platformFontTransform");
    private final PDFont font;
    private final Face face;
    private int highByte = -1;
    private double textSpaceFactor = 1.0;
    private PDGlyphs currentGlyphs = null;
    private boolean symbolic = false;

    protected FreetypeFont(PDFont pDFont, Face face) {
        this.font = pDFont;
        this.face = face;
        this.textSpaceFactor = 1000.0 / (double)this.getFace().getUnitsPerEM();
        PDFontDescriptor pDFontDescriptor = null;
        try {
            pDFontDescriptor = pDFont.getFontDescriptor();
            this.symbolic = pDFontDescriptor.isSymbolic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPlatformGlyphs basicCreate(PDGlyphs pDGlyphs) throws PlatformFontException {
        int n = pDGlyphs.getCodepoint();
        if (n < 0) {
            return null;
        }
        return new FreetypeGlyphs(this, pDGlyphs);
    }

    @Override
    public synchronized IPlatformGlyphs createPlatformGlyphs(PDGlyphs pDGlyphs) throws PlatformFontException {
        IPlatformGlyphs iPlatformGlyphs = (IPlatformGlyphs)pDGlyphs.getAttribute((Object)ATTR_PLATFORMGLYPHS);
        if (iPlatformGlyphs == null) {
            iPlatformGlyphs = this.basicCreate(pDGlyphs);
            pDGlyphs.setAttribute((Object)ATTR_PLATFORMGLYPHS, (Object)iPlatformGlyphs);
        }
        return iPlatformGlyphs;
    }

    @Override
    public int getAscent() {
        int n = this.getFace().getAscender();
        return (int)((double)n * this.getTextSpaceFactor());
    }

    @Override
    public Rectangle2D getBBox() {
        Rectangle2D rectangle2D = this.getFace().getBBox();
        int n = (int)(rectangle2D.getMinX() * this.getTextSpaceFactor());
        int n2 = (int)(rectangle2D.getMinY() * this.getTextSpaceFactor());
        int n3 = (int)(rectangle2D.getWidth() * this.getTextSpaceFactor());
        int n4 = (int)(rectangle2D.getHeight() * this.getTextSpaceFactor());
        return new Rectangle2D.Float(n, n2, n3, n4);
    }

    @Override
    public int getCharIndex(char c) {
        CharMap charMap = null;
        try {
            charMap = this.face.getCharMap();
            this.face.selectCharMap(FTEnum.ENCODING_UNICODE);
            return this.face.getCharIndex((int)c);
        }
        catch (FreetypeException freetypeException) {
            this.face.setCharMap(charMap);
            return c;
        }
    }

    @Override
    public int getDescent() {
        int n = this.getFace().getDescender();
        return (int)((double)n * this.getTextSpaceFactor());
    }

    public Face getFace() {
        return this.face;
    }

    @Override
    public int getHeight() {
        int n = this.getFace().getHeight();
        return (int)((double)n * this.getTextSpaceFactor());
    }

    public Object getImpl() {
        return this.getFace();
    }

    @Override
    public PDFont getPDFont() {
        return this.font;
    }

    public double getTextSpaceFactor() {
        return this.textSpaceFactor;
    }

    @Override
    public int getUnderlinePosition() {
        return this.face.getUnderlinePosition();
    }

    @Override
    public int getUnderlineThickness() {
        return this.face.getUnderlineThickness();
    }

    @Override
    public boolean isBoldStyle() {
        return false;
    }

    @Override
    public boolean isItalicStyle() {
        return false;
    }

    @Override
    public boolean isMonospaced() {
        return false;
    }

    @Override
    public boolean isSymbolFont() {
        return false;
    }

    public boolean isSymbolic() {
        return this.symbolic;
    }

    protected GlyphSlot loadGlyphSlot(PDGlyphs pDGlyphs) throws PlatformFontException {
        if (this.currentGlyphs == pDGlyphs) {
            return this.face.getGlyphSlot();
        }
        this.currentGlyphs = pDGlyphs;
        if (this.isSymbolic()) {
            if (this.font instanceof PDFontType1) {
                Encoding encoding = this.font.getEncoding();
                if (encoding.isFontSpecificEncoding()) {
                    String string = encoding.getDifferenceGlyphName(pDGlyphs.getCodepoint());
                    if (string != null) {
                        this.loadShapeFromName(this.face, string);
                    } else {
                        this.loadShapeFromCode(this.face, pDGlyphs.getCodepoint());
                    }
                } else {
                    String string = encoding.getGlyphName(pDGlyphs.getCodepoint());
                    this.loadShapeFromName(this.face, string);
                }
            } else if (this.font instanceof PDFontTrueType) {
                CharMap charMap = this.face.getCharMap();
                if (charMap == null || charMap.getPlatformID() == 1) {
                    this.loadShapeFromCode(this.face, pDGlyphs.getCodepoint());
                } else {
                    if (this.highByte == -1) {
                        this.highByte = this.face.getFirstChar() & 0xFF00;
                    }
                    int n = this.highByte | pDGlyphs.getCodepoint();
                    this.loadShapeFromCode(this.face, n);
                }
            } else if (this.font instanceof PDFontType0) {
                int n = this.font.getEncoding().getDecoded(pDGlyphs.getCodepoint());
                int n2 = ((PDFontType0)this.font).getGlyphIndex(n);
                this.loadShapeFromIndex(this.face, n2);
            } else {
                this.loadShapeFromIndex(this.face, pDGlyphs.getCodepoint());
            }
        } else if (this.font instanceof PDFontType1) {
            String string = this.font.getEncoding().getGlyphName(pDGlyphs.getCodepoint());
            if (string == ".notdef") {
                int n = this.font.getEncoding().getDecoded(pDGlyphs.getCodepoint());
                this.loadShapeFromCode(this.face, n);
            } else {
                this.loadShapeFromName(this.face, string);
            }
        } else if (this.font instanceof PDFontTrueType) {
            CharMap charMap = this.face.getCharMap();
            if (charMap != null && charMap.isMicrosoftUnicode()) {
                int n = this.font.getEncoding().getDecoded(pDGlyphs.getCodepoint());
                this.loadShapeFromCode(this.face, n);
            } else {
                int n = this.font.getMacintoshRomanCode(pDGlyphs.getCodepoint());
                this.loadShapeFromCode(this.face, n);
            }
        } else if (this.font instanceof PDFontType0) {
            int n = this.font.getEncoding().getDecoded(pDGlyphs.getCodepoint());
            int n3 = ((PDFontType0)this.font).getGlyphIndex(n);
            this.loadShapeFromIndex(this.face, n3);
        } else {
            this.loadShapeFromIndex(this.face, pDGlyphs.getCodepoint());
        }
        return this.face.getGlyphSlot();
    }

    protected void loadShapeFromCode(Face face, int n) throws PlatformFontException {
        try {
            face.loadChar(n, 10241);
        }
        catch (FreetypeException freetypeException) {
            throw new PlatformFontException(freetypeException);
        }
    }

    protected void loadShapeFromIndex(Face face, int n) throws PlatformFontException {
        try {
            face.loadGlyph(n, 10241);
        }
        catch (FreetypeException freetypeException) {
            throw new PlatformFontException(freetypeException);
        }
    }

    protected void loadShapeFromName(Face face, String string) {
        int n = face.getNameIndex(string);
        try {
            face.loadGlyph(n, 10241);
        }
        catch (FreetypeException freetypeException) {
            // empty catch block
        }
    }

    @Override
    public void saveState(ICSPlatformDevice iCSPlatformDevice, GraphicsState graphicsState, GraphicsState graphicsState2) {
    }

    @Override
    public void textStateChanged(ICSPlatformDevice iCSPlatformDevice) {
        GraphicsState graphicsState = iCSPlatformDevice.getGraphicsState();
        float f = 1.0f / (float)this.getFace().getUnitsPerEM() * graphicsState.textState.fontSize;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f * graphicsState.textState.derivedHorizontalScalingFactor, f);
        graphicsState.setAttribute((Object)ATTR_TRANSFORM, (Object)affineTransform);
    }
}

