/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider.formatters.formatters;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.ReplacingTextFormatter;

public class HtmlFormatter
extends ReplacingTextFormatter {
    private final Map<String, String> content = new TreeMap<String, String>();
    private final boolean allowContext;
    private final boolean allowLogo;
    private final boolean includeXmlHeader;
    public static final String SUFFIX = "html";

    @Override
    public String process(String s) {
        return s;
    }

    public HtmlFormatter(boolean allowContext, boolean allowLogo, boolean includeXmlHeader) {
        this.allowContext = allowContext;
        this.allowLogo = allowLogo;
        this.includeXmlHeader = includeXmlHeader;
    }

    public HtmlFormatter() {
        this(true, true, false);
    }

    @Override
    public String getNewLine() {
        return "<BR/>" + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getBoldOpening() {
        return "<B>";
    }

    @Override
    public String getBoldClosing() {
        return "</B>";
    }

    @Override
    public String getTitle(String s) {
        return " <a name=\"" + s + "\"/><H3>" + this.knownIdToString(s) + "</H3>\n";
    }

    @Override
    public String getHeaders(String id, String encoding) {
        String xml = "";
        if (this.includeXmlHeader) {
            xml = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
        }
        return xml + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n" + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\n" + "  <head>\n" + "    <title>" + id + ": " + this.getVersion() + "</title>" + "    <meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=" + encoding + "\" />\n" + "  </head>\n" + "  <body>\n" + "    <H5  align=\"right\">" + id + ": " + this.getVersion() + ", " + JNLPRuntime.getLocalisedTimeStamp(new Date()) + "</H5>";
    }

    @Override
    public String getTail() {
        return "  </body>\n</html>";
    }

    @Override
    public String getUrl(String url, String visible) {
        return "<a href=\"" + url + "\">" + visible + "</a>";
    }

    private String knownIdToString(String s) {
        String value = this.localizeTitle(s);
        String key = s;
        this.content.put(key, value);
        return value;
    }

    @Override
    public String getSeeAlso(String s) {
        return "<li>" + this.getUrl(s + this.getFileSuffix(), s) + "</li>\n";
    }

    public StringBuilder generateIndex() {
        if (!this.allowContext) {
            return new StringBuilder();
        }
        Set<Map.Entry<String, String>> set = this.content.entrySet();
        if (set.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder("<H4>Context</H4>");
        for (Map.Entry<String, String> entry : set) {
            sb.append("<li><a href=\"#" + entry.getKey() + "\">").append(entry.getValue()).append("</a></li>");
        }
        return sb;
    }

    @Override
    public String getFileSuffix() {
        return ".html";
    }

    @Override
    public String wrapParagraph(String s) {
        return "<p><blockquote>" + s + "</blockquote></p>";
    }

    @Override
    public String getBreakAndBold() {
        return this.getNewLine() + this.getBoldOpening();
    }

    @Override
    public String getCloseBoldAndBreak() {
        return this.getBoldClosing() + this.getNewLine();
    }

    @Override
    public String getBoldCloseNwlineBoldOpen() {
        return this.getBoldClosing() + this.getNewLine() + this.getBoldOpening();
    }

    public String generateLogo() {
        if (this.allowLogo) {
            return "<center><img src=\"itw_logo.png\" alt=\"IcedTea-Web Logo\" width=\"413\" height=\"240\"/></center>" + this.getNewLine();
        }
        return "";
    }

    @Override
    public String getOption(String key, String value) {
        return "<li><b>" + key + " </b> - " + this.process(value) + "</li>";
    }
}

