/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBBoxFactory;
import org.apache.lucene.geo3d.GeoBaseBBox;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;

public class GeoDegenerateLatitudeZone
extends GeoBaseBBox {
    protected final double latitude;
    protected final double sinLatitude;
    protected final Plane plane;
    protected final GeoPoint interiorPoint;
    protected final GeoPoint[] edgePoints;
    protected static final GeoPoint[] planePoints = new GeoPoint[0];

    public GeoDegenerateLatitudeZone(PlanetModel planetModel, double latitude) {
        super(planetModel);
        this.latitude = latitude;
        this.sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        this.plane = new Plane(planetModel, this.sinLatitude);
        this.interiorPoint = new GeoPoint(planetModel, this.sinLatitude, 0.0, cosLatitude, 1.0);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return Math.abs(z - this.sinLatitude) < 1.0E-10;
    }

    @Override
    public double getRadius() {
        return Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noLongitudeBound().addLatitudeZone(this.latitude);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (path.intersects(this.plane, planePoints, new Membership[0])) {
            return 2;
        }
        if (path.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, new Membership[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLatitudeZone)) {
            return false;
        }
        GeoDegenerateLatitudeZone other = (GeoDegenerateLatitudeZone)o;
        return super.equals(other) && other.latitude == this.latitude;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoDegenerateLatitudeZone: {planetmodel=" + this.planetModel + ", lat=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + ")}";
    }
}

