/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors.dfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class DfsOnlyRequest
extends BroadcastRequest<DfsOnlyRequest> {
    private SearchRequest searchRequest = new SearchRequest();
    long nowInMillis;

    DfsOnlyRequest() {
    }

    public DfsOnlyRequest(Fields termVectorsFields, String[] indices, String[] types, Set<String> selectedFields) throws IOException {
        super(indices);
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        for (String fieldName : termVectorsFields) {
            if (selectedFields != null && !selectedFields.contains(fieldName)) continue;
            Terms terms = termVectorsFields.terms(fieldName);
            TermsEnum iterator = terms.iterator();
            while (iterator.next() != null) {
                String text = iterator.term().utf8ToString();
                boolBuilder.should(QueryBuilders.termQuery(fieldName, text));
            }
        }
        this.searchRequest = new SearchRequest(indices).types(types).source(new SearchSourceBuilder().query(boolBuilder));
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    @Override
    public ActionRequestValidationException validate() {
        return this.searchRequest.validate();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.searchRequest.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.searchRequest.writeTo(out);
    }

    public String[] types() {
        return this.searchRequest.types();
    }

    public String routing() {
        return this.searchRequest.routing();
    }

    public String preference() {
        return this.searchRequest.preference();
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.searchRequest.source(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types()) + ", source[" + sSource + "]";
    }
}

