/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.similarity.SimilarityLookupService;

public abstract class Mapper
implements ToXContent,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract void merge(Mapper var1, MergeResult var2) throws MergeMappingException;

    public static interface TypeParser {
        public Builder<?, ?> parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final String type;
            private final AnalysisService analysisService;
            private final SimilarityLookupService similarityLookupService;
            private final MapperService mapperService;
            private final Map<String, TypeParser> typeParsers;
            private final Version indexVersionCreated;
            private final ParseFieldMatcher parseFieldMatcher;

            public ParserContext(String type, AnalysisService analysisService, SimilarityLookupService similarityLookupService, MapperService mapperService, Map<String, TypeParser> typeParsers, Version indexVersionCreated, ParseFieldMatcher parseFieldMatcher) {
                this.type = type;
                this.analysisService = analysisService;
                this.similarityLookupService = similarityLookupService;
                this.mapperService = mapperService;
                this.typeParsers = typeParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.parseFieldMatcher = parseFieldMatcher;
            }

            public String type() {
                return this.type;
            }

            public AnalysisService analysisService() {
                return this.analysisService;
            }

            public SimilarityLookupService similarityLookupService() {
                return this.similarityLookupService;
            }

            public MapperService mapperService() {
                return this.mapperService;
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.get(Strings.toUnderscoreCase(type));
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public ParseFieldMatcher parseFieldMatcher() {
                return this.parseFieldMatcher;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            protected Map<String, TypeParser> typeParsers() {
                return this.typeParsers;
            }

            public ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in){

                    @Override
                    public boolean isWithinMultiField() {
                        return true;
                    }
                };
            }

            class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.type(), in.analysisService, in.similarityLookupService(), in.mapperService(), (Map<String, TypeParser>)ImmutableMap.builder().putAll(in.typeParsers()).build(), in.indexVersionCreated(), in.parseFieldMatcher());
                }
            }
        }
    }

    public static abstract class Builder<T extends Builder, Y extends Mapper> {
        public String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Y build(BuilderContext var1);
    }

    public static class BuilderContext {
        private final Settings indexSettings;
        private final ContentPath contentPath;

        public BuilderContext(Settings indexSettings, ContentPath contentPath) {
            this.contentPath = contentPath;
            this.indexSettings = indexSettings;
        }

        public ContentPath path() {
            return this.contentPath;
        }

        @Nullable
        public Settings indexSettings() {
            return this.indexSettings;
        }

        @Nullable
        public Version indexCreatedVersion() {
            if (this.indexSettings == null) {
                return null;
            }
            return Version.indexCreated(this.indexSettings);
        }
    }
}

