/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanNotQueryParser
implements QueryParser {
    public static final String NAME = "span_not";

    @Inject
    public SpanNotQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery include = null;
        SpanQuery exclude = null;
        Integer dist = null;
        Integer pre = null;
        Integer post = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext, "spanNot [include] must be of type span query", new Object[0]);
                    }
                    include = (SpanQuery)query;
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext, "spanNot [exclude] must be of type span query", new Object[0]);
                    }
                    exclude = (SpanQuery)query;
                    continue;
                }
                throw new QueryParsingException(parseContext, "[span_not] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if ("dist".equals(currentFieldName)) {
                dist = parser.intValue();
                continue;
            }
            if ("pre".equals(currentFieldName)) {
                pre = parser.intValue();
                continue;
            }
            if ("post".equals(currentFieldName)) {
                post = parser.intValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[span_not] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (include == null) {
            throw new QueryParsingException(parseContext, "spanNot must have [include] span query clause", new Object[0]);
        }
        if (exclude == null) {
            throw new QueryParsingException(parseContext, "spanNot must have [exclude] span query clause", new Object[0]);
        }
        if (dist != null && (pre != null || post != null)) {
            throw new QueryParsingException(parseContext, "spanNot can either use [dist] or [pre] & [post] (or none)", new Object[0]);
        }
        if (pre != null && post == null) {
            post = 0;
        } else if (pre == null && post != null) {
            pre = 0;
        }
        query = pre != null && post != null ? new SpanNotQuery(include, exclude, pre.intValue(), post.intValue()) : (dist != null ? new SpanNotQuery(include, exclude, dist.intValue()) : new SpanNotQuery(include, exclude));
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

