/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.CustomQueryScorer;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightUtils;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class PlainHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-plain";

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        int i;
        String[] fragments;
        List<Object> textsToHighlight;
        Map cache;
        org.apache.lucene.search.highlight.Highlighter entry;
        Encoder encoder;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        FieldMapper mapper = highlighterContext.mapper;
        Encoder encoder2 = encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            HashMap mappers = Maps.newHashMap();
            hitContext.cache().put(CACHE_KEY, mappers);
        }
        if ((entry = (org.apache.lucene.search.highlight.Highlighter)(cache = (Map)hitContext.cache().get(CACHE_KEY)).get(mapper)) == null) {
            NullFragmenter fragmenter;
            CustomQueryScorer queryScorer = new CustomQueryScorer(highlighterContext.query, field.fieldOptions().requireFieldMatch() != false ? mapper.fieldType().names().indexName() : null);
            queryScorer.setExpandMultiTermQuery(true);
            if (field.fieldOptions().numberOfFragments() == 0) {
                fragmenter = new NullFragmenter();
            } else if (field.fieldOptions().fragmenter() == null) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else if ("simple".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleFragmenter(field.fieldOptions().fragmentCharSize());
            } else if ("span".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else {
                throw new IllegalArgumentException("unknown fragmenter option [" + field.fieldOptions().fragmenter() + "] for the field [" + highlighterContext.fieldName + "]");
            }
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0]);
            entry = new org.apache.lucene.search.highlight.Highlighter((Formatter)formatter, encoder, (Scorer)queryScorer);
            entry.setTextFragmenter((Fragmenter)fragmenter);
            entry.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
            cache.put(mapper, entry);
        }
        int numberOfFragments = field.fieldOptions().numberOfFragments() == 0 ? 1 : field.fieldOptions().numberOfFragments();
        ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
        Analyzer analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
        try {
            textsToHighlight = HighlightUtils.loadFieldValues(field, mapper, context, hitContext);
            for (Object textToHighlight : textsToHighlight) {
                String text = textToHighlight.toString();
                TokenStream tokenStream = analyzer.tokenStream(mapper.fieldType().names().indexName(), text);
                Throwable throwable = null;
                try {
                    TextFragment[] bestTextFragments;
                    if (!tokenStream.hasAttribute(CharTermAttribute.class) || !tokenStream.hasAttribute(OffsetAttribute.class)) continue;
                    for (TextFragment bestTextFragment : bestTextFragments = entry.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                        if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                        fragsList.add(bestTextFragment);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tokenStream == null) continue;
                    if (throwable != null) {
                        try {
                            tokenStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tokenStream.close();
                }
            }
        }
        catch (Exception e) {
            if (ExceptionsHelper.unwrap(e, BytesRefHash.MaxBytesLengthExceededException.class) != null) {
                return null;
            }
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(fragsList, (Comparator)new Comparator<TextFragment>(){

                @Override
                public int compare(TextFragment o1, TextFragment o2) {
                    return Math.round(o2.getScore() - o1.getScore());
                }
            });
        }
        if (field.fieldOptions().numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
            fragments = new String[fragsList.size()];
            for (i = 0; i < fragsList.size(); ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        } else {
            numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
            fragments = new String[numberOfFragments];
            for (i = 0; i < fragments.length; ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, StringText.convertFromStringArray(fragments));
        }
        int noMatchSize = highlighterContext.field.fieldOptions().noMatchSize();
        if (noMatchSize > 0 && textsToHighlight.size() > 0) {
            int end;
            String fieldContents = textsToHighlight.get(0).toString();
            try {
                end = PlainHighlighter.findGoodEndForNoHighlightExcerpt(noMatchSize, analyzer, mapper.fieldType().names().indexName(), fieldContents);
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
            }
            if (end > 0) {
                return new HighlightField(highlighterContext.fieldName, new Text[]{new StringText(fieldContents.substring(0, end))});
            }
        }
        return null;
    }

    @Override
    public boolean canHighlight(FieldMapper fieldMapper) {
        return true;
    }

    private static int findGoodEndForNoHighlightExcerpt(int noMatchSize, Analyzer analyzer, String fieldName, String contents) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, contents);){
            if (!tokenStream.hasAttribute(OffsetAttribute.class)) {
                int n = -1;
                return n;
            }
            int end = -1;
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                OffsetAttribute attr = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
                if (attr.endOffset() >= noMatchSize) {
                    if (attr.endOffset() == noMatchSize) {
                        end = noMatchSize;
                    }
                    int n = end;
                    return n;
                }
                end = attr.endOffset();
            }
            tokenStream.end();
            int n = end;
            return n;
        }
    }
}

