/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.rangetree.OfflineSliceReader;
import org.apache.lucene.rangetree.SliceReader;
import org.apache.lucene.rangetree.SliceWriter;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.IOUtils;

final class OfflineSliceWriter
implements SliceWriter {
    final Path tempFile;
    final byte[] scratchBytes = new byte[20];
    final ByteArrayDataOutput scratchBytesOutput = new ByteArrayDataOutput(this.scratchBytes);
    final OutputStreamDataOutput out;
    final long count;
    private long countWritten;

    public OfflineSliceWriter(Path tempDir, long count) throws IOException {
        this.tempFile = Files.createTempFile(tempDir, "size" + count + ".", "", new FileAttribute[0]);
        this.out = new OutputStreamDataOutput((OutputStream)new BufferedOutputStream(Files.newOutputStream(this.tempFile, new OpenOption[0])));
        this.count = count;
    }

    @Override
    public void append(long value, long ord, int docID) throws IOException {
        this.out.writeLong(value);
        this.out.writeLong(ord);
        this.out.writeInt(docID);
        ++this.countWritten;
    }

    @Override
    public SliceReader getReader(long start) throws IOException {
        return new OfflineSliceReader(this.tempFile, start, this.count - start);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.count != this.countWritten) {
            throw new IllegalStateException("wrote " + this.countWritten + " values, but expected " + this.count);
        }
    }

    @Override
    public void destroy() throws IOException {
        IOUtils.rm((Path[])new Path[]{this.tempFile});
    }

    public String toString() {
        return "OfflineSliceWriter(count=" + this.count + " tempFile=" + this.tempFile + ")";
    }
}

