/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.Language;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;

public class MatchStateTest {
    @Test
    public void testConvertCase() {
        MatchState startUpper = this.getMatchState(Match.CaseConversion.STARTUPPER);
        junit.framework.Assert.assertNull((Object)startUpper.convertCase(null, "Y", (Language)new FakeLanguage("en")));
        Assert.assertThat((Object)startUpper.convertCase("", "Y", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)startUpper.convertCase("x", "Y", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"X"));
        Assert.assertThat((Object)startUpper.convertCase("xxx", "Yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"Xxx"));
        Assert.assertThat((Object)startUpper.convertCase("ijsselmeer", "Uppercase", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"IJsselmeer"));
        Assert.assertThat((Object)startUpper.convertCase("ijsselmeer", "lowercase", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"IJsselmeer"));
        Assert.assertThat((Object)startUpper.convertCase("ij", "Uppercase", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"IJ"));
        MatchState preserve = this.getMatchState(Match.CaseConversion.PRESERVE);
        Assert.assertThat((Object)preserve.convertCase("xxx", "Yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"Xxx"));
        Assert.assertThat((Object)preserve.convertCase("xxx", "yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xxx"));
        Assert.assertThat((Object)preserve.convertCase("xxx", "YYY", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"XXX"));
        Assert.assertThat((Object)preserve.convertCase("ijsselmeer", "Uppercase", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"IJsselmeer"));
        Assert.assertThat((Object)preserve.convertCase("ijsselmeer", "lowercase", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"ijsselmeer"));
        Assert.assertThat((Object)preserve.convertCase("ijsselmeer", "ALLUPPER", (Language)new FakeLanguage("nl")), (Matcher)CoreMatchers.is((Object)"IJSSELMEER"));
        MatchState startLower = this.getMatchState(Match.CaseConversion.STARTLOWER);
        Assert.assertThat((Object)startLower.convertCase("xxx", "YYY", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xxx"));
        Assert.assertThat((Object)startLower.convertCase("xxx", "yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xxx"));
        Assert.assertThat((Object)startLower.convertCase("xxx", "Yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xxx"));
        Assert.assertThat((Object)startLower.convertCase("XXX", "Yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xXX"));
        Assert.assertThat((Object)startLower.convertCase("Xxx", "Yyy", (Language)new FakeLanguage("en")), (Matcher)CoreMatchers.is((Object)"xxx"));
    }

    private MatchState getMatchState(Match.CaseConversion conversion) {
        return new MatchState(new Match("", "", false, "", "", conversion, false, false, Match.IncludeRange.NONE), null);
    }
}

