/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractPatternRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private final Set<String> simpleRuleTokens;
    private final Set<String> inflectedRuleTokens;
    private final List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    private final List<Match> suggestionMatches = new ArrayList<Match>();
    private final List<Match> suggestionMatchesOutMsg = new ArrayList<Match>();
    private final boolean useList;
    private final String suggestionsOutMsg;
    private RuleFilter filter;
    private String filterArgs;
    private String message;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg) {
        super(id, description, language, patternTokens, false);
        this.message = message;
        this.shortMessage = shortMessage;
        this.elementNo = new ArrayList<Integer>();
        this.suggestionsOutMsg = Objects.requireNonNull(suggestionsOutMsg);
        String prevName = "";
        int cnt = 0;
        int loopCnt = 0;
        boolean tempUseList = false;
        for (PatternToken pToken : this.patternTokens) {
            if (pToken.isPartOfPhrase()) {
                String curName = pToken.getPhraseName();
                if (StringTools.isEmpty(prevName) || prevName.equals(curName)) {
                    ++cnt;
                    tempUseList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternTokens.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
        this.useList = tempUseList;
        this.simpleRuleTokens = this.getSet(false);
        this.inflectedRuleTokens = this.getSet(true);
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage) {
        this(id, language, patternTokens, description, message, shortMessage, "");
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    @NotNull
    public final String getSuggestionsOutMsg() {
        return this.suggestionsOutMsg;
    }

    final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (PatternToken patternPatternToken : this.patternTokens) {
            strList.add(patternPatternToken.toString());
        }
        return StringTools.listToString(strList, ", ");
    }

    public final String toXML() {
        return new PatternRuleXmlCreator().toXML(new PatternRuleId(this.getId(), this.getSubId()), this.getLanguage());
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        try {
            PatternRuleMatcher matcher = new PatternRuleMatcher(this, this.useList);
            return matcher.match(this.getSentenceWithImmunization(sentence));
        }
        catch (IOException e) {
            throw new IOException("Error analyzing sentence: '" + sentence + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error analyzing sentence: '" + sentence + "'", e);
        }
    }

    public final void addSuggestionMatch(Match m) {
        this.suggestionMatches.add(m);
    }

    public final void addSuggestionMatchOutMsg(Match m) {
        this.suggestionMatchesOutMsg.add(m);
    }

    public boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        return !this.simpleRuleTokens.isEmpty() && !sentence.getTokenSet().containsAll(this.simpleRuleTokens) || !this.inflectedRuleTokens.isEmpty() && !sentence.getLemmaSet().containsAll(this.inflectedRuleTokens);
    }

    private Set<String> getSet(boolean isInflected) {
        HashSet<String> set = new HashSet<String>();
        for (PatternToken patternToken : this.patternTokens) {
            String str;
            boolean acceptInflectionValue = isInflected ? patternToken.isInflected() : !patternToken.isInflected();
            if (!acceptInflectionValue || patternToken.getNegation() || patternToken.isRegularExpression() || patternToken.isReferenceElement() || patternToken.getMinOccurrence() <= 0 || StringTools.isEmpty(str = patternToken.getString())) continue;
            set.add(str.toLowerCase());
        }
        return Collections.unmodifiableSet(set);
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    String getShortMessage() {
        return this.shortMessage;
    }

    List<Match> getSuggestionMatches() {
        return this.suggestionMatches;
    }

    List<Match> getSuggestionMatchesOutMsg() {
        return this.suggestionMatchesOutMsg;
    }

    void setFilter(RuleFilter filter) {
        this.filter = filter;
    }

    RuleFilter getFilter() {
        return this.filter;
    }

    void setFilterArguments(String filterArgs) {
        this.filterArgs = filterArgs;
    }

    String getFilterArguments() {
        return this.filterArgs;
    }

    public void setAntiPatterns(List<DisambiguationPatternRule> antiPatterns) {
        this.antiPatterns.addAll(antiPatterns);
    }

    @Override
    public final List<DisambiguationPatternRule> getAntiPatterns() {
        return Collections.unmodifiableList(this.antiPatterns);
    }
}

