/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLongAssociativeContainer;
import com.carrotsearch.hppc.CharLongMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharLongCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.CharLongProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharLongOpenHashMap
implements CharLongMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public char[] keys;
    public long[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public CharLongOpenHashMap() {
        this(16);
    }

    public CharLongOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CharLongOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public CharLongOpenHashMap(CharLongAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public long put(char key, long value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                long oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0L;
    }

    @Override
    public int putAll(CharLongAssociativeContainer container) {
        int count = this.assigned;
        for (CharLongCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends CharLongCursor> iterable) {
        int count = this.assigned;
        for (CharLongCursor charLongCursor : iterable) {
            this.put(charLongCursor.key, charLongCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(char key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(char key, long putValue, long additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.values[slot] = this.values[slot] + additionValue;
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    @Override
    public long addTo(char key, long additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(char pendingKey, long pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        char[] oldKeys = this.keys;
        long[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        char[] keys = this.keys;
        long[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            char k = oldKeys[i];
            long v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        char[] keys = new char[capacity];
        long[] values = new long[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public long remove(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                long v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(CharContainer container) {
        int before = this.assigned;
        for (CharCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.assigned;
        char[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public long get(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(char key, long defaultValue) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public long lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public long lset(long key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        long previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(char key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (CharLongCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            CharLongMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof CharLongMap && (other = (CharLongMap)obj).size() == this.size()) {
                for (CharLongCursor c : this) {
                    long v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<CharLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharLongProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        long[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        return new ValuesContainer();
    }

    public CharLongOpenHashMap clone() {
        try {
            CharLongOpenHashMap cloned = (CharLongOpenHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (long[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static CharLongOpenHashMap from(char[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharLongOpenHashMap map = new CharLongOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static CharLongOpenHashMap from(CharLongAssociativeContainer container) {
        return new CharLongOpenHashMap(container);
    }

    public static CharLongOpenHashMap newInstance() {
        return new CharLongOpenHashMap();
    }

    public static CharLongOpenHashMap newInstanceWithoutPerturbations() {
        return new CharLongOpenHashMap(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static CharLongOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new CharLongOpenHashMap(initialCapacity, loadFactor);
    }

    public static CharLongOpenHashMap newInstanceWithExpectedSize(int expectedSize) {
        return CharLongOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static CharLongOpenHashMap newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return CharLongOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            int max = CharLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharLongOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return CharLongOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CharLongOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            boolean[] allocated = CharLongOpenHashMap.this.allocated;
            long[] values = CharLongOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            boolean[] allocated = CharLongOpenHashMap.this.allocated;
            long[] values = CharLongOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            boolean[] allocated = CharLongOpenHashMap.this.allocated;
            long[] values = CharLongOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            int max = CharLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharLongOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharLongOpenHashMap owner;

        public KeysContainer() {
            this.owner = CharLongOpenHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return CharLongOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            char[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(char e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<CharLongCursor> {
        private final CharLongCursor cursor = new CharLongCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected CharLongCursor fetch() {
            int i;
            int max = CharLongOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !CharLongOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (CharLongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = CharLongOpenHashMap.this.keys[i];
            this.cursor.value = CharLongOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

