/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx.legacy;

import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.segment.AbstractTextIterator;
import net.sourceforge.segment.srx.LanguageRule;
import net.sourceforge.segment.srx.SrxDocument;
import net.sourceforge.segment.srx.legacy.MergedPattern;
import net.sourceforge.segment.srx.legacy.ReaderCharSequence;
import net.sourceforge.segment.srx.legacy.ReaderMatcher;
import net.sourceforge.segment.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTextIterator
extends AbstractTextIterator {
    private CharSequence text;
    private String segment;
    private MergedPattern mergedPattern;
    private ReaderMatcher breakingMatcher;
    private int startPosition;
    private int endPosition;

    public FastTextIterator(SrxDocument document, String languageCode, CharSequence text, Map<String, Object> parameterMap) {
        this.text = text;
        this.segment = null;
        this.startPosition = 0;
        this.endPosition = 0;
        int maxLookbehindConstructLength = Util.getParameter(parameterMap.get("maxLookbehindConstructLength"), 100);
        List<LanguageRule> languageRuleList = document.getLanguageRuleList(languageCode);
        String key = "MERGED_PATTERN_" + this.toString(languageRuleList) + "_" + maxLookbehindConstructLength;
        this.mergedPattern = (MergedPattern)document.getCache().get(key);
        if (this.mergedPattern == null) {
            this.mergedPattern = new MergedPattern(languageRuleList, maxLookbehindConstructLength);
            document.getCache().put(key, this.mergedPattern);
        }
        if (this.mergedPattern.getBreakingPattern() != null) {
            this.breakingMatcher = new ReaderMatcher(this.mergedPattern.getBreakingPattern(), text);
        }
    }

    public FastTextIterator(SrxDocument document, String languageCode, CharSequence text) {
        this(document, languageCode, text, new HashMap<String, Object>());
    }

    public FastTextIterator(SrxDocument document, String languageCode, Reader reader, Map<String, Object> parameterMap) {
        this(document, languageCode, new ReaderCharSequence(reader, Util.getParameter(parameterMap.get("bufferLength"), 65536)), parameterMap);
    }

    public FastTextIterator(SrxDocument document, String languageCode, Reader reader) {
        this(document, languageCode, reader, new HashMap<String, Object>());
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            boolean found = false;
            if (this.breakingMatcher != null) {
                block0: while (!found && this.breakingMatcher.find()) {
                    int breakingRuleIndex = 1;
                    while (this.breakingMatcher.group(breakingRuleIndex) == null) {
                        ++breakingRuleIndex;
                    }
                    this.endPosition = this.breakingMatcher.end(breakingRuleIndex);
                    if (this.endPosition <= this.startPosition) continue;
                    found = true;
                    List<Pattern> activeNonBreakingPatternList = this.mergedPattern.getNonBreakingPatternList(breakingRuleIndex);
                    for (Pattern nonBreakingPattern : activeNonBreakingPatternList) {
                        if (nonBreakingPattern != null) {
                            ReaderMatcher nonBreakingMatcher = new ReaderMatcher(nonBreakingPattern, this.text);
                            nonBreakingMatcher.useTransparentBounds(true);
                            nonBreakingMatcher.region(this.endPosition, this.endPosition);
                            boolean bl = found = !nonBreakingMatcher.lookingAt();
                        }
                        if (found) continue;
                        continue block0;
                    }
                }
                if (found && this.endPosition < this.text.length()) {
                    this.breakingMatcher.region(this.endPosition, this.text.length());
                }
            }
            if (!found) {
                this.endPosition = this.text.length();
            }
            this.segment = this.text.subSequence(this.startPosition, this.endPosition).toString();
            this.startPosition = this.endPosition;
            return this.segment;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.startPosition < this.text.length();
    }
}

