/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.DictionaryBuilder;
import org.languagetool.tokenizers.Tokenizer;

final class SpellDictionaryBuilder
extends DictionaryBuilder {
    SpellDictionaryBuilder(File infoFile) throws IOException {
        super(infoFile);
    }

    private static CommandLine parseArguments(String[] args) throws ParseException {
        Options options = new Options();
        Option option = new Option("o", true, "output file");
        option.setRequired(true);
        options.addOption(option);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        return cmd;
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmdLine = null;
        try {
            cmdLine = SpellDictionaryBuilder.parseArguments(args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            SpellDictionaryBuilder.printUsage();
            System.exit(1);
        }
        SpellDictionaryBuilder.checkUsageOrExit(cmdLine);
        String languageCode = args[0];
        String plainTextFile = args[1];
        String infoFile = args[2];
        SpellDictionaryBuilder builder = new SpellDictionaryBuilder(new File(infoFile));
        builder.setOutputFilename(cmdLine.getOptionValue("o"));
        String freqListFile = args[3];
        if (!freqListFile.equals("-")) {
            builder.readFreqList(new File(freqListFile));
            builder.build(languageCode, builder.addFreqData(new File(plainTextFile)));
        } else {
            builder.build(languageCode, new File(plainTextFile));
        }
    }

    private static void checkUsageOrExit(CommandLine cmdLine) throws IOException {
        File dictFile;
        String[] args = cmdLine.getArgs();
        if (args.length < 4 || !cmdLine.hasOption("o")) {
            SpellDictionaryBuilder.printUsage();
        }
        if (!(dictFile = new File(args[2])).exists()) {
            throw new IOException("File does not exist: " + dictFile);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: " + SpellDictionaryBuilder.class.getSimpleName() + " <languageCode> <dictionary> <infoFile> <frequencyList> -o <outputFile>");
        System.out.println("   <languageCode> like 'en-US' or 'de-DE'");
        System.out.println("   <dictionary> is a plain text dictionary file, e.g. created from a Hunspell dictionary by 'unmunch'");
        System.out.println("   <infoFile> is the *.info properties file, see http://wiki.languagetool.org/developing-a-tagger-dictionary");
        System.out.println("   <frequencyList> is the *.xml file with a frequency wordlist or '-' for no frequency list, see http://wiki.languagetool.org/developing-a-tagger-dictionary");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File build(String languageCode, File plainTextDictFile) throws Exception {
        Language language = Languages.getLanguageForShortName(languageCode);
        File tempFile = null;
        try {
            tempFile = this.tokenizeInput(plainTextDictFile, language);
            File file = this.buildDict(tempFile, language);
            return file;
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private File tokenizeInput(File plainTextDictFile, Language language) throws IOException {
        Tokenizer wordTokenizer = language.getWordTokenizer();
        String encoding = this.getOption("fsa.dict.encoding");
        String separatorChar = this.hasOption("fsa.dict.separator") ? this.getOption("fsa.dict.separator") : "";
        File tempFile = File.createTempFile(SpellDictionaryBuilder.class.getSimpleName(), ".txt");
        try (Scanner scanner = new Scanner(plainTextDictFile, encoding);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                int sepPos = separatorChar.isEmpty() ? -1 : line.indexOf(separatorChar);
                String occurrences = sepPos != -1 ? line.substring(sepPos + separatorChar.length()) : "";
                String lineWithoutOcc = sepPos != -1 ? line.substring(0, sepPos) : line;
                List<String> tokens = wordTokenizer.tokenize(lineWithoutOcc);
                for (String token : tokens) {
                    if (token.length() <= 0) continue;
                    out.write(token);
                    if (sepPos != -1) {
                        out.write(separatorChar);
                        if (tokens.size() == 1) {
                            out.write(occurrences);
                        } else {
                            out.write("A");
                        }
                    }
                    out.write("\n");
                }
            }
        }
        return tempFile;
    }
}

