(provide 'snd-peak-phases.scm)
(load "primes.scm")

;;; multiply these phases by pi before use as initial-phases (and use sin, not cos -- see tstall below)
;;; to translate these peaks into the more standard crest-factor, (/ (* peak (sqrt 2)) (sqrt N))
;;;   in the all harmonics case, these go from 1.356 (20) to 1.413 (109) leaving aside N<8
;;;   the square root => sqrt(2), so 1.414 is not good. 

(define fv float-vector)


;;; ---------------------------------------- all harmonics ----------------------------------------

(define noid-min-peak-phases (vector

(vector 1  1.0    (fv 0))
(vector 2  1.76   (fv 0 0))

;; the 1.76 can be calculated (given here that 0 is the min)
;;   take derivative of sin(x) + sin(2x) = cos(x) + 2cos(2x)
;;   use cos(2x) = 2cos^2(x) - 1 to turn this into a quadratic polynomial in cos(x)
;;       4cos^2(x) + cos(x) - 2
;;   let x be cos(x), quadratic formula gives (-1 + sqrt(33))/8, [poly-roots (float-vector -2 1 4) -> (0.59307033081725 -0.84307033081725)]
;;   take acos of that to get cos(x): 
;;      (acos (+ -1/8 (/ (sqrt (+ 1 32)) 8))) -> 0.93592945566133
;;   plug that into the original: 
;;      (+ (sin 0.93592945566133) (sin (* 2 0.93592945566133))) -> 1.7601725930461
;;   see smax in clm.c -- this works for small n
;;
;; for 1+3, diff is 12cos^3x-8cosx so (acos 0) = pi/2 is a red-herring, but 3cos^2x-2 -> x = (sqrt 2/3), (acos (sqrt 2/3)) -> 0.61547970867039
;;    and (+ (sin 0.61547970867039) (sin (* 3 0.61547970867039))) is 1.539600717839 and
;;    1.5396 + 0.4604 * sin(initial-phase) is very close.
;;
;; we can show that phase=0 is the global min by using simultaneous non-linear equations:
;;
;;   let peak-loc = (acos (/ (- (sqrt 33) 1) 8))
;;       peak (+ (sin peak-loc) (sin (* 2 peak-loc)))
;;       and assume we're focusing on the 1st min (not pi)
;;
;;   sin(peak-loc) + sin(2*peak-loc + phase) <= peak
;;   so sin(2*peak-loc (i.e. 1.8718) + phase) < (peak - sin(peak-loc)) = 0.9551, but that means phase >= 0 (sin is going down at this point)
;;   sin(-peak-loc) + sin(2*(-peak-loc) + phase) >= -peak
;;   so sin(2*(-peak-loc) + phase) >= -(peak - sin(peak-loc)) = -0.9551, so phase <= 0 (sin is going up)
;;   so phase must be 0 [this argument assumes the peak loc is not jumping around randomly]
;;
;;   I think we can play the same game in n=3 case, but now there are 6 (12?) peaks to fiddle with and 4 global mins
;;   so it's messier.


;; there's always an equivalent point found by flipping the even harmonics, and another pair at 2-val (symmetry around 0)
;; so there are 4 equivalent points.  A function that returns the other 3 given 1 is at the end of this file.


;;; 3 all --------------------------------------------------------------------------------
(vector 3  2.1949383250709 (fv 0 0 1)

     1.9798054823226 (fv 0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 
     1.9798054823222 (fv 0.0 4.102748875720859667026729766803327947855E-1 1.683332430673265878162681019603041931987E0)  
     1.9798054823226 (fv 0.0 1.58972511242745917492413809668505564332E0 3.166675693251493894919690319511573761702E-1)
     1.9798054823222 (fv 0.0 1.410274887572085966702672976680332794785E0 1.683332430673265878162681019603041931987E0)

     ;; :(tstall (fv 0 62/39 19/60))
     ;; (1.979860844111887127172689015942912379187E0 5.5534000000004)
     ;; same for (fv 0 23/39 19/60), always the case (it's symmetric in the 2nd), sin(x) +/- sin(2x + a) + sin(3x + b)
     ;; :(tstall (fv 0.0 5.897251124274717204443163609539624303579E-1 3.166675693251937984129540382127743214369E-1) 0.0000001)
     ;; (1.979806197137575924716806491964687429097E0 0.1714663000039)

     1.9797181063317 (fv 0.0 0.41022177723939 1.6832780274654)
     1.979716725384 (fv 0.0 1.5897793760084 0.31672588155614)
     1.9797162690553 (fv 0.0 1.4102202429311 1.6832728267862)

     ;; polynomial is surprisingly good:
     ;;  :all 3 (fv 1.9797767193773 0.066455282926612 1.7863254855475)
     )


;;; 4 all --------------------------------------------------------------------------------
(vector 4  2.2962718935302 (fv 0 1 1 1)

     2.040  (fv 0 33/35 67/50 10/9)               ;(vector 0 1/9 17/24 71/36) -- 2.04242
     2.04012799263 (fv 0.000 0.072 0.674 1.912)
     2.04012799263 (fv 0.000 0.928 1.326 1.088)
     2.04012799263 (fv 0.000 1.072 0.674 0.912)
     2.04012799263 (fv 0.000 1.928 1.326 0.088)

     2.0392323180235 (fv 0.0 9.429973765023149656627765580196864902973E-1 1.340090256365081833322960846999194473028E0 1.112605206055434337031329050660133361816E0)

     2.038956 (fv 0.000000 0.944585 1.341508 1.115059)
     2.038954 (fv 0.000000 1.055406 0.658486 0.884929)
     2.038954 (fv 0.000000 0.055405 0.658485 1.884926)
     2.038954 (fv 0.000000 1.944593 1.341515 0.115071)

     ;; :all 4 (fv 2.060278672942 -0.70579973196553 0.90455920034382)
     )

;;; 5 all -------------------------------------------------------------------------------- ; 2.23
(vector 5  2.5405211753511 (fv 0 1 0 0 0)

     2.3434929847717 (fv 0.0 0.84531772136688 1.6645057201385 1.4203575849533 1.5933285951614)
     2.3434844481891 (fv 0.0 1.8453152570243 1.6649825491504 0.42142125263938 1.5942588576594)

     2.343549 (fv 0.000000 1.845237 1.664402 0.420189 1.593154)
     2.343533 (fv 0.000000 1.154716 0.335535 0.579695 0.406714)
     2.343497 (fv 0.000000 0.845320 1.664496 1.420334 1.593308)
     
     2.343527 (fv 0.000000 0.154667 0.335503 1.579672 0.406698)
     2.343513 (fv 0.000000 0.154687 0.335490 1.579647 0.406677)
     2.343508 (fv 0.000000 1.845332 1.664532 0.420369 1.593338)

     ;; pp:
     2.343485 (fv 0.000000 1.154683 0.335509 0.579687 0.406716)
     )

;;; 6 all -------------------------------------------------------------------------------- ; 2.4494
(vector 6  2.8200183503167 (fv 0 0 0 0 1 0) 

     2.5598928928375 (fv 0.0 0.91140931844711 0.34124284982681 1.3568490743637 1.4451304674149 1.2563138008118)
     2.5509102344513 (fv 0.0 0.88722838124921 0.26020415169852 1.2966409163042 1.3233535939997 1.15281977798)
     2.5493413065822 (fv 0.0 0.88655948906463 0.26426014425456 1.3003055923199 1.3306838066896 1.1573162129407)

     2.549466 (fv 0.000000 1.113453 1.735461 0.699472 0.668803 0.842320)
     2.549414 (fv 0.000000 0.886661 0.264519 1.300599 1.331194 1.157723)
     2.549386 (fv 0.000000 0.113427 1.735535 1.699526 0.668940 1.842412)
     2.549385 (fv 0.000000 1.886568 0.264458 0.300485 1.331039 0.157570)
     2.549360 (fv 0.000000 0.886491 0.264319 1.300337 1.330828 1.157371)
     )

;;; 7 all -------------------------------------------------------------------------------- ; 2.64575
(vector 7  3.072141248417 (fv 0 0 0 1 1 0 1)

     2.639426 (fv 0.000000 0.904980 0.986109 1.721148 1.291116 1.621443 0.966099)
     2.639402 (fv 0.000000 0.095202 1.014213 1.278914 0.709149 1.378847 1.034223)
     2.639371 (fv 0.000000 1.095652 1.014884 0.279318 0.709755 0.379605 1.035166)
     2.639364 (fv 0.000000 1.904695 0.985719 0.720925 1.290796 0.621014 0.965536)
     )

;;; 8 all -------------------------------------------------------------------------------- ; 2.8284
(vector 8  3.4905790371793 (fv 0 1 0 0 1 1 1 0)

     2.795099 (fv 0.000000 1.333103 1.192134 0.394213 1.162609 1.955320 1.855302 0.126169)
     2.794748 (fv 0.000000 0.333225 1.192073 1.394414 1.162519 0.954914 1.855082 1.126189)
     2.794737 (fv 0.000000 1.666686 0.807757 0.605305 0.837099 1.044558 0.144428 0.873255)
     2.794719 (fv 0.000000 0.666709 0.807769 1.605408 0.837217 0.044625 0.144433 1.873342)
     2.794585 (fv 0.000000 0.666699 0.807707 1.605285 0.837106 0.044540 0.144374 1.873180)

     ;; pp:
     2.880745 (fv 0.000000 0.873927 1.696839 1.009332 0.354675 0.227015 0.156852 0.523641)
     )

;;; 9 all --------------------------------------------------------------------------------
(vector 9  3.5954569026984 (fv 0 1 1 0 1 0 1 1 1)

     2.962087 (fv 0.000000 0.872517 1.501013 0.464057 -0.056897 1.063020 1.251698 1.436014 1.254131)
     2.962094 (fv 0.000000 1.127564 0.498862 1.535743 0.056794 0.936657 0.748023 0.563510 0.745376)
     2.962065 (fv 0.000000 -0.127444 1.501316 1.464492 -0.056263 0.063823 1.252240 0.437075 1.255320)
     2.961916 (fv 0.000000 0.127632 0.498978 0.536080 0.057253 -0.062716 0.748729 1.564172 0.746161)
     2.961829 (fv 0.000000 1.872309 1.500693 1.463585 1.942384 0.062267 1.250564 0.435026 1.252813)
     2.961652 (fv 0.000000 1.872337 1.500914 1.463820 1.942618 0.062504 1.251193 0.435609 1.253539)

     ;; pp:
     2.961653 (fv 0.000000 0.872337 1.500915 0.463821 1.942617 1.062504 1.251196 1.435614 1.253542)
     )

;;; 10 all -------------------------------------------------------------------------------- ; 3.162
(vector 10 3.7587492407668 (fv 0 1 1 0 1 1 1 0 0 0)

     3.102964 (fv 0.000000 0.071632 0.396251 0.504925 0.052683 0.212597 1.057168 -0.172275 1.102043 0.501144)
     3.102823 (fv 0.000000 1.070629 0.394872 1.503703 0.050925 1.211208 1.054650 0.825637 1.099957 1.498128)
     3.102782 (fv 0.000000 0.927743 1.602314 0.494139 -0.054832 0.785103 0.940332 1.169212 0.894844 0.494709)
     3.102734 (fv 0.000000 1.928606 1.603786 1.495372 -0.052790 1.786999 0.942669 0.172108 0.897837 1.498611)
     3.102303 (fv 0.000000 -0.071891 1.603086 1.494633 -0.053985 1.786024 0.941426 0.170569 0.896122 1.496522)

     ;; pp:
     3.270687 (fv 0.000000 1.665169 -0.138115 1.364203 0.226693 -0.150959 1.661874 0.514042 1.098209 1.445028)
     )

;;; 11 all -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.8018732822274 (fv 0 1 0 0 1 0 0 0 1 1 1)

     3.218745  (fv 0.000000 1.518100 1.908924 1.617043 1.540909 0.660141 -0.056826 0.670660 1.165195 1.212229 0.198401)
     3.218587 (fv 0.000000 0.518100 1.908924 0.617043 1.540909 1.660141 -0.056826 1.670660 1.165195 0.212229 0.198401)
     3.218514 (fv 0.000000 0.481786 0.091759 0.383540 0.459429 1.340439 0.058075 1.330988 0.836240 0.789345 -0.196819)
     3.218444 (fv 0.000000 0.482127 0.090769 0.383093 0.459045 1.339823 0.056682 1.328792 0.834826 0.787716 -0.199032)
     3.217965 (fv 0.000000 0.482287 0.091029 0.383292 0.459507 1.340271 0.057231 1.329368 0.835616 0.788459 -0.198129)
     
     ;; pp:
     3.468683 (fv 0.000000 0.627804 1.366835 0.412917 1.258123 0.658181 0.350130 1.736695 1.823585 1.864191 0.254629)
     )

;;; 12 all -------------------------------------------------------------------------------- ; 3.464
(vector 12 3.7616552322386 (fv 0 1 1 0 0 1 0 1 0 0 0 0)

     3.389586 (fv 0.000000 0.076743 0.348321 0.615321 0.763893 0.188090 0.117764 1.147735 1.461927 0.591300 1.497863 0.867456)
     3.389547 (fv 0.000000 -0.079085 1.648740 1.380212 1.228354 1.804105 1.875295 0.844196 0.527781 1.396624 0.490362 1.119947)
     3.389430 (fv 0.000000 1.081078 0.354514 1.624157 0.776410 1.200581 0.129241 0.162495 1.480822 1.614178 1.518801 1.892528)
     3.389128 (fv 0.000000 1.076659 0.348730 1.615059 0.764020 1.188577 0.117561 0.148053 1.462454 1.591386 1.497945 1.868055)
     3.388654 (fv 0.000000 1.076620 0.347797 1.614462 0.764164 1.188107 0.116910 0.147164 1.461571 1.590619 1.496557 1.866148)

     ;; pp:
     3.546003 (fv 0.000000 0.813150 -1.878303 1.450426 -0.112095 -1.110299 -0.487466 -0.181683 0.060170 -0.004101 -0.103775 -0.960524)
     )

;;; 13 all -------------------------------------------------------------------------------- ; 3.6055
(vector 13 4.1211657406183 (fv 0 0 0 0 0 0 1 1 0 0 1 0 1) 

     3.525309 (fv 0.000000 1.051846 0.170520 1.635159 0.455907 1.511384 -0.147127 1.055447 1.000548 0.097871 0.005880 0.160672 0.616896)
     3.525164 (fv 0.000000 0.947554 1.827637 0.362791 1.540717 0.485315 0.143016 0.940517 0.994364 1.896615 -0.012058 1.833412 1.375539)
     3.525069 (fv 0.000000 0.947187 1.827546 0.362752 1.541123 0.485247 0.142279 0.941021 0.994821 1.896143 -0.012766 1.832600 1.375866)

     ;; tstall (flip odds):
     3.5254909 (fv 0.000000 0.051846 0.170520 0.635159 0.455907 0.511384 -0.147127 0.055447 1.000548 1.097871 0.005880 1.160672 0.616896)

     3.525038 (fv 0.000000 0.946517 1.827042 0.361916 1.539603 0.484426 0.141403 0.938505 0.992273 1.893878 -0.015423 1.830018 1.372777)
     3.524879 (fv 0.000000 0.948502 1.829668 0.364984 1.544240 0.488687 0.147763 0.945396 1.000061 1.903153 -0.004551 1.840699 1.384079)
     3.524127 (fv 0.000000 0.948325 1.829839 0.364837 1.544231 0.489035 0.147691 0.944940 1.000036 1.902764 -0.004752 1.840449 1.384160)

     ;; pp:
     3.850623 (fv 0.000000 0.969515 0.236902 1.700081 1.532485 1.012414 0.716276 0.879825 0.831162 1.111747 1.357361 -0.014630 0.962342)
     )

;;; 14 all -------------------------------------------------------------------------------- ; 3.7416
(vector 14 4.1603193984251 (fv 0 1 0 1 1 0 1 0 0 0 1 0 0 0) 

     3.613280 (fv 0.000000 0.028982 0.530538 0.496734 -0.474935 -0.580078 0.104750 1.488617 -0.565757 -0.157842 -1.258035 -0.057079 0.253472 -0.294346)
     3.613121 (fv 0.000000 0.028974 0.530453 0.496128 -0.475742 -0.580534 0.104588 -0.512201 1.433649 1.841085 0.741103 -0.058374 0.252301 -0.295482)
     3.612244 (fv 0.000000 0.028654 0.530107 0.495786 -0.476137 -0.581023 0.103729 -0.513152 1.433095 1.840437 0.739729 -0.059420 0.251093 -0.296875)

     ;; pp:
     3.738333 (fv 0.000000 0.876144 1.749283 0.255257 1.233908 0.925717 1.713300 0.790918 0.423428 0.079568 -0.060539 0.064404 0.601933 0.291808)
     )

;;; 15 all -------------------------------------------------------------------------------- ; 3.8729
(vector 15 4.4060654286219 (fv 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0) ; 3.87298 (3.8729833462074)

     3.768991 (fv 0.000000 0.863434 1.069349 1.651266 0.272078 0.287377 1.735528 1.050008 0.997192 -0.020076 1.092043 1.658049 1.188297 1.641481 1.391589)
     3.768033 (fv 0.000000 0.863152 1.069135 1.651353 0.271851 0.287255 1.735115 1.049678 0.996877 -0.020587 1.091869 1.657562 1.187769 1.641176 1.391193)

     ;; pp:
     3.859726 (fv 0.000000 0.426404 1.082257 -0.378600 0.672681 0.084435 0.794375 -0.135830 -0.492292 -0.747360 0.439828 0.395595 0.865535 0.672400 -1.271921)
     )

;;; 16 all --------------------------------------------------------------------------------
(vector 16 4.5445760745314 (fv 0 1 1 0 1 0 1 0 0 0 1 1 0 0 0 0)

     3.875080 (fv 0.000000 0.730612 0.678979 1.195144 1.632126 1.276744 -0.008560 1.467028 0.525375 0.204869 -0.166129 -0.115302 1.317856 1.622654 0.244306 1.412402)
     3.873760 (fv 0.000000 0.727564 0.672436 1.188603 1.622426 1.266314 -0.018679 1.451325 0.507181 0.185750 -0.189066 -0.140317 1.293402 1.595942 0.216437 1.382779)

     ;; pp:
     3.898248 (fv 0.000000 0.999637 1.627971 0.563839 1.354119 0.602036 1.818873 1.125095 0.889883 0.658070 0.547416 0.178002 0.696357 0.711221 1.277932 1.486763)
     )

;;; 17 all -------------------------------------------------------------------------------- ; 4.1231
(vector 17 4.7654988506492 (fv 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 1 1)

     3.981459 (fv 0.000000 0.520484 1.429480 0.505816 -0.891395 0.114390 0.146335 0.416197 0.938893 0.898753 0.507264 0.650687 -0.081499 -0.607990 0.213218 -0.096782 -0.652476)
     3.980210 (fv 0.000000 0.519908 1.429364 0.506455 -0.889349 0.115888 0.147799 0.418944 0.941982 0.901488 0.510707 0.653289 -0.078010 -0.603698 0.217190 -0.091931 -0.646982)

     ;; pp:
     4.025451 (fv 0.000000 0.806442 1.640772 0.524823 1.518315 0.179778 1.375417 0.889535 -0.006539 1.626695 1.126057 1.328368 0.940320 1.091090 1.265244 1.868967 -0.027469)
     )

;;; 18 all -------------------------------------------------------------------------------- ; 4.24264
(vector 18 4.795  (fv 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0) 

     4.145376 (fv 0.000000 0.815970 1.442468 0.022437 0.838057 0.561089 1.647234 0.678944 1.711039 1.021597 1.327383 0.016884 -0.030470 1.937927 0.480054 1.947188 1.779952 1.482341)
     4.143797 (fv 0.000000 0.818014 1.444164 0.024749 0.841333 0.563942 1.651378 0.683332 1.716474 1.028213 1.333307 0.023380 -0.024413 1.945329 0.488400 1.955424 1.789772 1.492736)
     )

;;; 19 all -------------------------------------------------------------------------------- ; 4.35889
(vector 19 4.957  (fv 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1) 

     4.220950 (fv 0.000000 0.963878 0.724427 1.142775 1.347933 0.681634 0.858134 1.165699 1.071759 -0.202310 0.544201 1.698473 0.575529 0.392352 1.327300 -0.513540 0.980505 1.004716 0.307249)

     ;; pp:
     4.321309 (fv 0.000000 0.745098 1.155175 -0.037958 0.532342 1.473567 0.665377 -0.049708 1.767937 0.914818 -0.119772 -0.388406 1.775638 1.206519 1.079401 1.118695 1.930701 1.737887 -0.008406)
     )

;;; 20 all -------------------------------------------------------------------------------- ; 4.4721
(vector 20 5.202707605727 (fv 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0)

     4.288981 (fv 0.000000 1.288096 1.467454 -0.169090 1.858403 0.280935 0.217741 -0.031571 0.876318 1.220549 0.027164 0.381448 1.736192 1.508757 1.292734 0.007137 1.225400 0.645757 1.237414 0.420948)

     ;; pp:
     4.467948 (fv 0.000000 0.926509 1.348679 0.244038 1.242002 0.019828 1.173056 0.068338 1.504010 1.041584 0.276603 1.806452 1.767012 1.665479 1.374797 1.361818 1.827476 0.132481 0.796064 0.727142)
     )

;;; 21 all -------------------------------------------------------------------------------- ; 4.5825
(vector 21 5.3164971341632 (fv 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0)

     4.482399 (fv 0.000000 1.397497 1.231727 1.288294 -0.006341 1.417563 -0.224775 1.544084 0.158820 1.058039 0.318600 1.788531 1.041209 0.988222 1.527762 0.536397 0.600751 0.298693 0.721205 1.590350 -0.083320)

     ;; pp:
     4.574194 (fv 0.000000 0.830108 1.212818 -0.114835 0.663864 1.570276 0.585550 1.478198 0.603181 0.202958 1.649503 0.901982 0.255866 0.012434 0.019243 -0.386770 -0.332788 -0.375429 0.023280 0.553342 0.478240)

     ;;20+1
     4.618619 (fv 0.000000 1.345785 1.495882 -0.120438 1.731459 0.090404 0.074776 -0.291176 0.645789 0.803615 -0.332805 -0.208611 1.614493 1.024259 1.115371 -0.353606 0.898091 0.121786 0.722736 -0.018188 -0.844048)
     )

;;; 22 all -------------------------------------------------------------------------------- ; 4.6904
(vector 22 5.292244006282 (fv 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0)

     4.586632 (fv 0.000000 -0.097347 1.080504 0.590888 -0.253961 1.023423 0.714156 1.899465 -0.021982 0.277218 1.158938 0.994197 1.053415 1.055197 1.429563 0.904330 0.879709 1.421582 0.356096 1.550705 0.340822 1.056446)

     ;; pp:
     4.652382 (fv 0.000000 0.770633 1.384088 0.317715 1.400813 0.382294 1.252492 0.280512 1.930558 1.151783 0.690579 0.045402 0.011035 1.255532 1.463333 1.386585 0.797105 0.928163 1.091040 1.178341 1.461782 1.888245)
     )

;;; 23 all -------------------------------------------------------------------------------- ; 4.7958
(vector 23 5.3592889520338 (fv 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1)

     4.605166 (fv 0.000000 0.690307 -0.223703 0.265767 1.214689 0.913389 0.192629 1.489393 1.370656 0.848931 0.362934 0.592228 0.586290 0.001276 1.085398 1.699229 1.577973 0.044583 0.292577 1.343812 0.079208 -0.074880 0.197817)

     ;; pp:
     4.710615 (fv 0.000000 0.902511 1.536988 0.243249 1.001545 1.634662 0.695827 1.858861 0.975507 -0.294658 1.045533 0.585569 -0.187029 1.386517 1.153500 1.032794 1.102165 0.705294 0.968823 1.234672 1.719694 1.916952 0.231307)
     )

;;; 24 all -------------------------------------------------------------------------------- ; 4.89897
(vector 24 5.6358969066981 (fv 0 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 0 1 1 0)

     4.728042 (fv 0.000000 1.858980 1.366314 1.303093 0.303565 0.363906 -0.013052 0.288365 1.150614 1.733252 0.305478 1.054343 0.956930 0.688496 0.150610 0.766590 0.723928 0.358579 1.444965 0.475911 1.678841 0.331630 0.146133 0.753447)

     ;; pp:
     4.889570 (fv 0.000000 0.652535 1.042108 0.029625 0.992596 0.108788 0.963358 1.727152 1.075228 0.458712 1.655013 0.983185 0.212822 0.044079 1.553136 1.514188 1.228593 0.684074 0.951192 1.149281 1.171121 1.382495 1.676492 0.457795)
     )

;;; 25 all -------------------------------------------------------------------------------- ; 5
(vector 25 5.6488965032573 (fv 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0)

     4.852860 (fv 0.000000 0.230967 1.727317 0.450764 0.017370 0.018890 0.465256 0.875082 0.612377 0.658132 0.067557 0.830777 0.581695 -0.075473 -0.106051 1.748399 0.582315 0.898509 1.395989 0.676438 1.853985 1.350704 1.785330 0.662329 1.015229)

     ;; pp:
     4.921362 (fv 0.000000 0.851508 1.100092 -0.096894 0.569229 1.392351 1.000621 -0.034780 0.968948 0.124084 0.790431 -0.082333 0.100565 1.032584 0.439519 0.313536 0.111622 0.176204 1.585564 1.488261 0.160713 -0.042818 0.611461 0.760689 0.720307)

     ;; 24+1
     4.922285 (fv 0.000000 1.852403 1.330052 1.192652 0.231948 0.213251 -0.016545 0.323663 1.244798 1.721990 0.406243 1.054443 0.887461 0.428878 0.171251 0.904198 0.382500 0.426580 1.168661 0.658927 1.560813 0.302705 -0.048972 0.694633 0.063331)
     )

;;; 26 all -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.7865648269653 (fv 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0)

     5.004963 (fv 0.000000 0.356503 0.613044 0.799459 0.607543 -0.552567 0.275717 0.954617 0.539225 0.390115 0.747516 -0.287816 0.661916 1.821078 -0.045167 -0.217306 1.531723 0.896950 0.283527 0.968137 0.942126 0.004913 -0.474898 0.935500 1.374671 0.106691)

     ;; pp:
     5.069005 (fv 0.000000 0.693839 1.223177 0.171124 0.655819 1.659284 0.862412 0.167152 1.036280 0.233275 1.065043 0.332100 0.088514 1.217811 0.718617 0.463929 -0.022907 0.301609 1.664942 1.593693 1.159306 1.575199 1.658356 1.791865 0.367495 0.523068)

     ;; 25+1
     5.143899 (fv 0.000000 0.339898 1.703660 0.334703 -0.033066 0.152772 0.352050 0.937913 0.431489 0.569881 0.083296 0.920798 0.392044 -0.279901 -0.309500 1.803373 0.465037 0.973772 1.156286 0.616150 1.812432 1.192020 1.791336 0.747339 0.851095 0.182401)
     )

;;; 27 all -------------------------------------------------------------------------------- ; 5.1961
(vector 27 5.8753981590271 (fv 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0)

     5.063979 (fv 0.000000 1.181312 1.011523 -0.037795 0.952214 0.743188 0.046346 -0.011550 1.593930 1.829003 1.926981 0.836368 0.497093 0.820784 0.581154 1.308971 0.813642 0.203348 0.448693 0.869589 1.163120 0.319576 0.498929 -0.074366 0.820574 1.666665 0.421783)

     ;; pp:
     5.178190 (fv 0.000000 0.576339 1.415874 0.213916 0.629425 1.693659 0.296051 1.239867 0.501966 1.807544 0.478176 -0.072336 1.103954 0.283214 0.269354 -0.586084 0.967552 0.762560 0.644862 0.769649 0.453206 0.327359 1.119459 1.407959 1.575398 0.090804 0.240986)
     )

;;; 28 all -------------------------------------------------------------------------------- ; 5.2915
(vector 28 6.0962085723877 (fv 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 1)

     5.157284 (fv 0.000000 0.613262 -0.034248 0.167107 1.753362 0.009121 1.168065 1.319935 0.754215 1.452315 0.403030 1.384036 -0.445049 1.700477 0.448730 1.102474 0.302577 0.114957 0.813938 -1.221580 0.733588 -0.228287 1.379195 0.775101 0.357079 0.863661 0.744441 -0.542730)

     ;; pp:
     5.257514 (fv 0.000000 0.637044 1.032618 -0.063334 0.493709 1.172496 0.265676 1.071428 0.186660 1.119263 0.450916 1.523906 0.926797 0.655305 -0.125687 1.119620 1.002091 0.595772 0.366822 0.141548 0.074245 -0.326675 0.086270 0.158575 0.648670 0.735199 1.036773 -0.335597)
     )

;;; 29 all -------------------------------------------------------------------------------- ; 5.38516
(vector 29 6.168496131897 (fv 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 0 1 0 1)

     5.241325 (fv 0.000000 1.424549 1.434579 0.952506 0.877300 1.948583 1.592791 0.964559 0.950012 1.429458 0.788068 0.556113 0.404906 0.813692 1.604109 0.138120 0.925420 1.345282 1.048370 1.281239 1.347177 1.752489 1.781053 0.782127 0.063659 1.163981 0.330203 1.128951 1.871926)

     ;; pp:
     5.354004 (fv 0.000000 0.686564 1.165583 1.805539 0.645303 1.392789 0.389959 1.584227 0.184212 1.132208 0.594808 1.885153 0.760508 0.108139 1.597930 1.248057 0.449409 0.388311 -0.040221 -0.137762 0.035489 0.097197 1.554759 1.643774 1.707832 0.439164 0.286463 0.690398 1.001814)
     )

;;; 30 all -------------------------------------------------------------------------------- ; 5.4772
(vector 30 6.257221698761 (fv 0 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 1 0 1)

     5.361273 (fv 0.000000 1.372797 0.670580 1.057136 -0.495516 0.360919 0.095174 0.542106 0.748047 0.327246 -0.458569 -0.196062 0.499790 0.195141 -0.041091 1.640040 0.876134 1.017379 1.243023 0.157336 0.532420 -0.270945 0.222972 -0.454366 0.519190 0.206280 0.985739 0.329627 0.782987 0.753526)

     ;; pp:
     5.457123 (fv 0.000000 0.579295 1.086489 0.271361 0.351869 1.393293 0.343724 1.326421 0.262824 0.711061 0.185497 1.430027 0.435525 0.024911 1.289605 1.541120 0.534068 0.426466 1.770822 1.448308 1.691046 1.363221 0.940381 1.411829 1.232407 1.698674 -0.061281 0.480912 0.397265 0.093509)

     ;; 29+1
     5.412650 (fv 0.000000 1.372514 1.361202 0.973134 0.991593 -0.159462 1.586776 0.911509 0.884370 1.311078 0.692338 0.370585 0.073603 0.951100 1.615704 -0.086641 0.937697 1.084099 0.789094 1.102012 1.411370 1.347150 0.135836 1.287121 0.247155 1.411165 0.414284 1.457325 1.638518 0.243579)
     )

;;; 31 all -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.3243918418884 (fv 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1)

	5.479252 (fv 0.000000 1.715332 0.740879 1.282120 0.005121 1.133820 1.648029 0.843835 0.870127 0.362478 -0.012264 1.508703 0.898921 1.010311 1.653601 0.519170 0.543334 0.643526 1.650052 0.937580 0.006302 1.745072 0.413200 1.629321 0.671152 0.807947 1.140772 1.157434 0.674253 1.101147 1.176272)

     ;; pp:
     5.506117 (fv 0.000000 0.677676 1.291605 1.787569 0.657442 1.382372 0.087522 0.893379 -0.050356 0.800441 -0.050934 1.224977 0.724031 1.793437 1.031051 0.628566 0.200527 1.931215 1.228105 1.043046 0.856098 0.884359 0.667113 1.148772 0.506576 0.784927 0.816254 1.304861 1.786988 1.852001 0.224722)

     ;; 30+1
     5.547952 (fv 0.000000 1.408621 0.523310 1.045939 -0.627130 0.269616 0.117668 0.541463 0.727658 0.085842 -0.605997 -0.377836 0.306146 0.174626 -0.190149 1.517106 0.799782 0.937996 1.132227 -0.105373 0.321280 -0.393317 0.084035 -0.469695 0.243404 -0.009244 0.808121 0.001462 0.464569 0.543074 -0.183440)
     )

;;; 32 all -------------------------------------------------------------------------------- ; 5.65685
(vector 32 6.4451498985291 (fv 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0)  

     5.525650 (fv 0.000000 -0.351133 1.293972 -0.243467 0.375774 0.341597 0.388720 0.121948 0.157486 1.353778 0.236182 0.278745 0.140738 1.315014 1.717753 1.193420 1.734782 1.635830 0.448546 0.657631 0.934238 0.325644 1.910640 1.330301 0.498135 1.394503 1.747576 0.388629 0.706077 0.075100 0.832948 -0.013902)

     ;; pp:
     5.604748 (fv 0.000000 0.799811 1.174111 -0.060224 0.824446 1.499635 0.054636 1.116026 0.103247 0.980855 0.143722 1.410098 0.567912 -0.275862 1.109567 0.582020 0.052513 1.796805 1.346558 0.470148 0.633702 0.311062 0.341355 0.120966 0.347342 -0.087220 -0.235617 0.166536 0.617003 0.982789 1.015963 1.699479)
     )

;;; 33 all -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.5579299926758 (fv 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 0 0 0 0)

     5.631190 (fv 0.000000 0.097616 0.529848 0.847242 0.662939 0.833596 1.914696 0.035703 0.153599 0.327398 1.407575 -0.021932 0.932495 1.243452 0.370234 0.653095 -0.062589 1.855791 0.441043 0.248847 0.782346 0.465080 -0.161731 0.929949 0.594824 1.321736 1.693332 1.192619 0.260596 1.271517 1.690356 1.109725 0.567421)

     ;; pp:
     5.744046 (fv 0.000000 0.648617 1.091146 -0.080415 0.482263 1.100917 0.071191 1.062577 0.109918 0.836095 -0.052549 1.287445 0.382948 1.391104 0.926942 0.308725 1.631613 0.947331 0.900375 0.124874 0.064712 1.506574 1.488794 1.444593 1.476988 1.247778 1.089616 1.639634 -0.152998 -0.001330 0.434944 0.915078 0.903432)

     ;; 32+1
     5.661968 (fv 0.000000 -0.352238 1.421554 -0.062497 0.287660 0.210756 0.410931 0.134572 0.285343 1.484578 0.353937 0.356204 0.097780 1.509309 1.823077 1.336946 1.794210 1.915189 0.597192 0.803204 1.197066 0.523451 0.168550 1.601444 0.858978 1.682815 0.027376 0.555153 1.077928 0.275560 1.108578 0.224908 -0.307634)
     )

;;; 34 all -------------------------------------------------------------------------------- ; 5.8309518
(vector 34 6.6782836914062 (fv 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 0)

     5.716435 (fv 0.000000 1.537850 0.239691 0.279680 1.093753 0.273847 0.872235 1.496985 1.522928 0.760723 1.655491 0.025814 1.234543 0.204722 1.320964 0.722548 0.795411 1.810303 1.109323 1.456118 1.072015 0.656715 1.724740 1.409441 -0.521616 1.350972 1.541354 1.489386 0.627886 0.677049 0.878489 -0.127150 -0.020441 0.557443)

     ;; pp:
     5.801677 (fv 0.000000 0.960590 1.230620 -0.161839 0.543814 1.323075 0.313096 0.853533 -0.212153 1.135960 -0.100861 0.915755 0.332189 1.257774 0.850007 0.263168 1.528284 0.501744 0.475602 -0.081405 1.503307 1.166122 1.260528 0.746339 0.481380 0.722221 0.959406 1.108477 0.637618 0.962601 1.236659 1.273002 -0.011533 0.165609)
     )

;;; 35 all -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7637429237366 (fv 0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0)

     5.764294 (fv 0.000000 0.100183 1.398707 0.822554 1.459800 0.154045 1.619372 1.535907 1.542373 0.876004 1.322076 1.293113 1.412723 0.146555 1.058946 0.645359 1.390817 1.072269 0.132103 0.365169 1.845456 1.487696 0.791518 1.753949 0.991873 1.205376 0.200418 -0.166259 0.161894 -0.021712 0.362318 0.686081 1.632970 0.565468 0.901578)
     
     ;; pp:
     5.895826 (fv 0.000000 0.643741 1.250469 1.867865 0.530176 1.122535 0.024737 1.205120 0.194580 0.988315 1.702722 0.964190 0.348453 1.456006 0.520276 -0.302930 1.556990 0.638548 -0.211365 1.748454 1.424618 0.940371 0.466444 0.212559 0.146415 0.251126 0.228984 -0.138555 0.352126 0.459061 0.664909 1.353503 1.665947 1.723726 0.002732)
     )

;;; 36 all -------------------------------------------------------------------------------- ; 6
(vector 36 6.8008880615234 (fv 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1)

     5.926043 (fv 0.000000 1.020111 0.677817 0.140140 0.932921 0.775557 0.190635 1.853238 0.762697 0.237889 0.277245 0.161572 1.553054 0.008070 0.283378 1.674361 -0.347149 0.590912 0.944213 0.823255 0.043034 -0.091562 0.229555 1.352871 0.981843 0.171776 0.581947 0.691871 1.000348 0.829120 1.162722 1.690975 0.634924 1.730234 0.452876 1.429867)

     ;; pp:
     5.876240 (fv 0.000000 0.880722 1.509714 0.204909 0.817303 1.618536 0.560409 1.279749 0.308262 -0.524358 0.395653 -0.826907 0.386964 -0.034537 1.535549 1.090154 0.375322 1.512598 1.132860 1.558960 0.892393 0.587406 0.099621 0.325394 -0.086852 -0.097620 -0.036583 0.411674 0.423371 -0.013442 0.469946 0.536299 1.271922 -0.393606 -0.170370 0.277903)

     ;; 35+1
     5.968866 #(0.000000 0.133611 1.230434 0.841852 1.312856 0.529755 1.370310 1.332590 1.580324 0.930341 1.428865 1.755052 1.561249 -0.230712 1.582178 0.486609 1.188339 0.984457 0.043840 -0.015979 -0.155552 1.235391 0.874947 1.643065 1.184316 0.952918 0.543242 -0.381983 0.458292 0.068269 0.575524 0.723748 -0.044728 0.683083 1.573491 0.035965)
     )

;;; 37 all -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0251078605652 (fv 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 0)

     5.927989 (fv 0.000000 1.362671 1.825924 0.295316 1.739841 1.835463 1.048945 1.351967 0.301179 0.388225 1.780488 1.534131 0.435239 0.318363 -0.101295 0.220840 0.998360 1.646237 1.362259 0.730890 0.388056 1.327874 0.110340 1.924981 0.324484 0.429209 1.542714 0.665030 0.018148 0.321441 1.812097 0.446891 1.633693 1.056009 1.344989 1.426723 1.818561)

     ;; pp:
     5.974361 (fv 0.000000 0.722538 1.156373 1.818176 0.424359 1.001884 -0.224545 0.967675 0.089627 0.943734 -0.013572 0.947114 1.914887 1.102823 0.609766 -0.045075 0.989242 0.549752 1.615428 1.344389 0.949028 0.684491 0.483044 1.586745 1.704247 1.024089 1.360720 1.162825 1.209506 1.208578 0.870877 1.201701 1.782696 0.290706 0.253842 0.466340 0.855161)
     )

;;; 38 all -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.0688242912292 (fv 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.106333 (fv 0.000000 0.434523 1.232452 1.590516 0.836713 0.138216 -0.095509 1.537371 0.469612 0.772082 0.748819 1.723571 1.820323 0.854103 0.903800 0.048646 1.316356 0.369282 0.213334 0.798970 0.966914 1.376827 0.274641 1.618764 1.873131 -0.092091 -0.470518 1.150403 0.773945 1.198395 0.586433 1.306012 0.434228 0.963298 1.320012 1.145313 0.975992 1.528312)

     ;; pp:
     6.069129 (fv 0.000000 0.353204 1.147865 -0.165608 0.617213 1.415461 0.231168 1.083939 0.117365 0.131316 1.707213 1.274701 0.816253 0.960543 -0.063212 0.270965 1.418066 0.902830 1.619238 0.591718 0.977208 0.940720 1.787513 0.746703 0.165197 1.177699 0.830675 1.652814 1.371740 1.118022 1.133381 1.232097 1.370669 1.218425 0.194971 -0.026100 0.615354 0.750336)

     ;; 37+1
     6.055823 (fv 0.000000 1.140317 1.804958 0.269386 1.581973 1.647143 0.908514 1.357676 0.255360 0.413319 1.759464 1.403831 0.462290 0.275768 -0.260643 0.081477 0.945988 1.674168 1.558839 0.619719 0.448569 1.181188 0.261467 0.173066 0.317765 0.523175 1.483135 0.623965 0.065573 0.279749 1.647027 0.558187 1.546480 1.177439 1.567967 1.574734 1.849511 0.049835)
     )

;;; 39 all -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.1506487936623 (fv 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.123916 (fv 0.000000 0.040215 0.172894 1.637830 1.177239 0.763654 -0.119272 0.532576 0.565933 -0.105342 -0.131500 0.223610 0.603849 1.034619 1.719874 1.942807 1.262885 -0.012239 1.521972 1.205939 0.909582 1.593149 1.660841 1.495691 0.901808 0.173365 0.594080 1.535985 0.099680 1.416781 0.772460 -0.143795 1.283054 1.611294 1.560252 0.291114 1.497861 0.152708 0.428638)

     ;; pp:
     6.206556 (fv 0.000000 0.714125 0.999676 1.714571 0.529099 1.103279 1.739177 0.796762 1.681925 0.899057 1.703669 0.970830 1.925662 0.861561 -0.048288 1.636413 0.684994 0.118298 1.376444 0.590000 0.292657 1.963808 1.418598 1.344996 0.647105 0.610362 0.012866 0.209613 -0.013687 0.186819 0.011104 -0.022072 0.158390 0.584179 1.099029 1.037543 1.650004 1.749468 0.443068)
     )

;;; 40 all -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.3913831710815 (fv 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 0 0 0)

     6.288342 (fv 0.000000 1.454424 1.336242 0.229719 0.982419 1.371484 1.659070 1.721074 -0.039860 0.456961 0.523564 1.259764 0.318922 0.087125 -0.000634 1.738216 -0.345360 -0.093074 0.023146 0.160891 -0.147874 1.232278 0.789559 0.888228 0.482450 1.447335 0.166012 1.058063 1.516605 1.834071 1.250289 0.562291 1.417730 1.678824 0.619402 -0.109426 1.547164 0.339656 1.224949 0.726676)

     ;; pp.scm using (+ pi (/ pi 40)) and (- (/ pi 2)) 
     6.236401 (fv 0.000000 0.772219 1.201231 0.091963 0.183059 1.041989 1.811758 0.387321 1.330915 0.336134 1.429758 0.457811 -0.040075 1.279315 -0.162113 0.993833 0.310259 1.390530 1.133639 0.515117 -0.283405 1.239507 1.056859 0.563309 0.888313 0.077823 -0.241421 1.625166 1.389376 1.528163 1.539643 1.801710 1.314626 1.482031 0.189224 0.088532 0.546429 0.832570 1.329921 1.394636)

     ;; 39+1
     6.225428 (fv 0.000000 0.018424 0.358482 1.638018 1.240634 0.736085 -0.066112 0.498078 0.313140 -0.349116 -0.078254 0.339244 0.614562 1.053604 1.642263 0.035262 1.198732 -0.016808 1.520491 0.977972 0.998108 1.314770 1.516145 1.384690 0.768816 0.035714 0.457048 1.603223 0.028603 1.251326 0.527774 -0.316948 1.112826 1.392544 1.426300 -0.060082 1.277540 -0.027939 0.287964 -0.469347)
     )

;;; 41 all -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.4106826782227 (fv 0 0 1 1 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1)

	6.328763 (fv 0.000000 1.142395 1.764533 -0.297234 1.214342 1.074168 0.499096 0.455971 1.425043 1.900660 0.405160 0.299024 -1.901144 1.886599 1.644748 1.176229 0.661037 1.678309 0.464540 0.540147 1.345672 0.396385 -0.079815 0.750463 0.469580 0.512532 0.818295 0.900948 1.176821 -0.024695 0.941067 1.661160 0.722192 0.141569 0.127463 0.210921 0.877068 0.077777 1.493046 0.191845 0.414613)

	;; 40+1
	6.358717 #(0.000000 -0.020758 0.246672 1.544589 1.131300 0.661547 -0.056489 0.619384 0.371630 -0.110331 0.000818 0.177321 0.559217 0.923104 1.662896 -0.125476 1.296787 -0.073144 1.547529 1.002485 0.962635 1.391369 1.641653 1.338531 0.930816 -0.148823 0.497147 1.805932 -0.096347 1.262657 0.572927 -0.034728 1.074704 1.415337 1.261540 0.094297 1.330231 -0.082753 0.266134 -0.425878 0.145663)
     )

;;; 42 all -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.6252284049988 (fv 0 0 1 1 0 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0)

     6.458009 (fv 0.000000 1.779914 1.358689 1.879744 1.431714 1.455314 0.050417 0.106324 1.650278 0.287736 1.685176 1.015814 0.661574 0.193645 0.754970 0.912901 1.865274 -0.192264 1.123351 1.730828 0.304030 1.844656 1.379904 1.178786 0.508869 0.433728 0.920606 1.193377 1.562403 0.705424 1.521220 0.671316 1.715032 0.818246 0.696173 0.646766 1.054986 -0.067193 0.041834 0.484025 0.025667 0.817193)

     ;; pp:
     6.432404 (fv 0.000000 0.970539 1.075055 0.363395 0.562687 1.503003 0.305818 1.159109 -0.331893 0.844703 -0.625323 0.633095 -0.150641 1.248856 0.138597 1.484859 0.287309 -0.516557 0.004989 0.635673 0.412760 0.072104 -0.034630 0.781885 1.052252 0.670637 0.477407 0.370916 -0.497791 0.214269 0.268953 -0.018432 0.090095 0.191222 0.329896 1.234637 1.181873 1.460275 -0.201010 0.565027 0.336488 1.227322)

     ;; 41+1
     6.394203 #(0.000000 1.246846 -0.158681 -0.341467 1.261409 1.245848 0.347126 0.398406 1.634097 0.343227 0.479438 0.294031 -0.033819 1.737282 1.583385 1.354268 0.742224 -0.009544 0.554315 0.678866 1.328159 0.855307 0.141712 0.955363 0.553267 0.483527 0.794171 1.158258 1.508218 0.015867 0.755660 -0.076886 0.740716 0.190212 0.163473 0.274740 1.034995 0.476168 1.497724 0.141883 0.788672 -0.251141)
     )

;;; 43 all -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.6619415283203 (fv 0 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1)

	6.474636 (fv 0.000000 1.150199 1.694193 1.156056 0.712558 0.642330 1.062359 0.333465 0.208319 1.376434 0.672147 0.421707 0.175691 0.110131 0.012554 0.457050 1.790874 1.449901 0.302494 0.007271 0.824529 0.122259 0.582806 0.097251 0.623774 0.359297 1.299289 0.938333 1.768060 0.180654 1.104716 1.340371 1.395970 0.480619 1.800871 0.228016 0.933560 0.262964 0.673103 1.298731 1.471774 -0.223423 0.770589)
	)


;;; 44 all -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9767818450928 (fv 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

	6.544063 (fv 0.000000 0.521564 0.221232 0.526957 -0.268317 1.919404 -0.035203 -0.157289 0.069290 1.705251 1.788014 0.459816 0.274398 0.505529 1.163758 0.357930 -1.720040 0.469129 0.146265 1.215606 1.405712 0.742844 1.668145 1.402279 0.067840 0.255308 0.567789 0.756058 -0.027555 1.587315 0.915687 1.314433 0.227656 0.688969 1.566702 0.434208 -0.041884 1.283408 0.878206 0.471503 1.018383 0.062893 1.376612 0.157588)
     )

;;; 45 all -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1777801513672 (fv 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1)

	6.629206 (fv 0.000000 0.961180 -0.043617 -0.239190 1.278111 0.166389 0.542833 0.768578 1.444629 -0.095831 1.211952 -0.026602 1.739185 0.951577 1.809231 0.253449 0.320575 0.356270 1.309005 0.639731 1.394153 0.026971 -0.051944 0.744827 0.030297 -0.420287 0.144422 1.021322 1.302658 0.297709 -0.048481 -0.152658 1.144902 1.677136 1.170155 1.132592 1.153458 -0.076024 1.369092 1.009916 0.503324 -0.247395 0.103592 1.569752 0.081999)

	;; 44+1
	6.723870 #(0.000000 0.530336 0.112056 0.656544 -0.274280 1.750447 -0.088422 -0.074969 0.151270 1.523816 1.755473 0.461088 0.237652 0.464806 1.160456 0.506611 -1.748867 0.430966 0.189099 1.114743 1.319239 0.625102 1.825559 1.372306 -0.094983 0.162815 0.690451 0.900206 -0.073887 1.641189 0.759828 1.360087 0.152591 0.587153 1.626431 0.363623 -0.110618 1.294106 0.876328 0.610845 1.096815 0.100729 1.158090 -0.007378 -0.203560)
     )

;;; 46 all -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.22203540802 (fv 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 0)

     6.691037 (fv 0.000000 1.445996 1.082935 1.926602 0.599270 0.110590 0.061353 0.197460 1.126524 0.801213 0.136799 1.544533 0.424316 0.988423 1.042912 0.904549 0.394264 1.877367 1.781398 0.106378 0.814176 1.462479 1.299353 0.505357 0.691608 0.079788 0.741755 1.296349 0.923407 1.954315 1.519832 1.193777 1.868646 1.501978 -0.016089 0.928107 1.377054 1.114171 1.348483 1.466927 0.885968 1.244812 -0.112245 0.649026 0.159882 0.999017)
     )

;;; 47 all -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.3221893310547 (fv 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 1 0 1 0 0)

     6.827640 (fv 0.000000 1.713417 0.880595 0.228916 0.656232 0.000986 0.228917 -0.027955 1.208960 0.359921 0.457263 0.229897 0.942770 1.345553 -0.054940 0.652154 0.967593 1.474188 0.749564 1.214391 0.623653 1.483712 1.914097 -0.195445 1.486123 0.775521 1.114155 1.267810 1.798008 0.660315 0.102413 1.302210 1.004781 1.037205 1.145399 0.299807 1.478644 1.078433 0.364686 1.769537 0.263449 0.339932 0.328599 1.167886 1.782492 1.089675 1.333666)

     ;; pp.scm
     6.756605 (fv 0.000000 0.765562 1.030062 1.788209 0.493707 1.020553 1.799942 0.685170 1.481088 0.566613 1.302518 0.066670 1.157386 0.282906 1.328526 0.161298 1.388649 0.879050 1.843229 1.039366 0.409576 -0.055025 1.222366 0.535280 0.169247 1.679128 1.342099 0.894436 0.643082 0.345708 0.301808 -0.401334 0.022950 1.550170 1.565812 1.633017 1.764984 1.880338 1.607034 1.569498 0.111731 0.416082 0.781558 0.894597 1.438223 1.659212 0.166997)
     )

;;; 48 all -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.4671268463135 (fv 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1)

	6.861797 (fv 0.000000 0.598880 1.244788 1.029903 1.049082 0.596958 1.659653 1.333585 0.658254 1.786003 1.335584 0.009329 0.382880 1.914281 0.167535 0.198984 1.572176 1.516863 0.640701 0.516067 0.942009 -0.405338 1.601326 0.836539 0.796978 0.739838 0.171913 0.969497 0.363583 0.469203 1.258504 0.656687 1.162915 0.889585 1.702682 0.725369 0.456133 0.349105 0.208023 0.802519 1.129136 1.479603 0.312580 1.579555 0.353334 0.757965 1.599847 0.626811)
     )

;;; 49 all -------------------------------------------------------------------------------- ; 7
(vector 49 8.5157623291016 (fv 0 1 1 0 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0)

	6.911687 (fv 0.000000 1.423917 -0.117078 -0.215912 1.065526 1.018507 0.645263 1.632151 0.540556 0.415851 1.870183 1.161732 0.983376 1.723916 0.372700 0.063452 0.534166 1.512588 1.454603 0.719318 0.962295 1.537720 1.562020 1.433858 0.930756 1.181983 1.504188 -0.167777 1.662278 0.680834 0.246207 0.675469 0.268474 1.089455 0.369548 -0.146942 -0.055836 1.091821 1.976652 0.486415 1.202030 0.175707 0.854435 0.506884 1.646470 0.139127 0.235704 1.857608 0.297006)
     )

;;; 50 all -------------------------------------------------------------------------------- ; 7.071
(vector 50 8.7809114456177 (fv 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1)

	7.001572 (fv 0.000000 1.510483 0.569660 1.177547 -0.063746 1.651491 0.398933 1.945813 1.189455 0.886784 0.877834 1.209513 -0.281791 0.817195 0.562593 1.509576 -0.448618 -0.075249 1.004074 1.022851 1.197099 0.475529 0.725043 0.148549 0.625214 0.676229 0.641014 0.276388 1.297552 1.512294 0.880442 -0.093329 0.470630 1.205879 -0.595773 0.927383 1.198964 0.435022 1.291534 0.884451 -0.190056 1.483748 1.136079 1.665203 0.167401 0.524695 0.182147 -0.336866 0.803181 1.503900)

	;; 49+1
	7.068277 #(0.000000 1.555553 -0.098452 -0.248671 0.943070 1.222038 0.540534 1.583025 0.571958 0.450583 0.098336 1.374686 0.895664 1.876883 0.578170 0.132039 0.507017 1.692206 1.427289 0.706680 1.027079 1.384399 1.675994 1.615489 0.904725 1.043176 1.352556 -0.253040 1.737561 0.858162 0.237527 0.540509 0.318714 1.222211 0.400023 0.014829 -0.054306 0.879381 1.918170 0.419380 1.200979 0.129359 0.816375 0.652601 1.702348 -0.039319 0.324673 1.850446 0.349670 0.311005)
     )

;;; 51 all -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.8213935921978 (fv 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1)

     7.062061 (fv 0.000000 1.277482 1.272374 1.604932 -0.114681 1.091849 -0.113655 0.581995 0.517152 0.112646 1.392203 0.473053 0.525951 1.781540 1.014930 1.311666 0.597941 1.173291 0.649975 0.688396 0.657382 0.570575 1.699334 1.669408 1.662666 -0.233111 0.196711 0.718758 -0.174442 0.105462 -0.039308 0.924279 1.329687 1.401301 1.538357 0.347724 -0.110320 1.449195 1.223831 0.349599 1.470761 0.191238 1.885833 0.819453 0.145490 0.967802 0.015777 -0.014902 1.276127 1.513254 0.227467)
     )

;;; 52 all -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.9920463562012 (fv 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0)

	7.134954 (fv 0.000000 0.621560 1.464578 1.482376 0.135707 1.345519 0.584967 0.540885 1.784345 0.393329 1.745283 0.530433 1.414971 1.247472 1.329889 0.999552 0.933504 1.580199 0.519254 0.315472 0.473007 1.123477 -0.056053 0.241576 0.391709 1.244898 1.883529 1.120931 1.698334 -0.149261 0.218191 1.134898 0.533381 1.222211 0.249553 -0.114715 1.262472 0.846800 0.877356 0.688478 0.673983 1.103698 1.385836 1.036560 1.331275 0.414915 1.604362 0.874160 0.543444 1.406115 1.239524 0.816202)
     )

;;; 53 all -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.0914754867554 (fv 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 1 1 0 0)

	7.198047 (fv 0.000000 0.609644 0.849387 1.600527 1.158365 1.715833 0.524245 -0.059778 0.291176 0.319451 0.985683 1.372433 1.089427 1.749317 1.594481 0.166060 0.927925 -0.362027 0.850015 1.635397 0.732972 1.007069 0.880865 0.290674 0.176669 0.886718 1.772633 0.908528 -0.020813 0.082874 0.257671 1.590012 0.330359 1.893554 1.401328 1.102801 0.720925 0.360594 1.357080 1.833049 0.574052 1.403405 1.851942 1.638866 1.670052 -0.125543 1.654904 0.840665 0.189500 1.798641 0.330271 0.101100 1.702877)
     )

;;; 54 all -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.1825122833252 (fv 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1)

	7.253898 (fv 0.000000 1.663275 -0.127344 1.382101 -0.144643 1.243444 0.071415 0.455351 1.200018 -0.228088 0.114774 0.009236 0.130605 1.041538 -0.220166 0.676007 1.432141 0.450339 0.554653 1.087402 1.040513 0.270076 0.433523 0.188787 1.457394 -0.061608 1.604147 1.071620 1.033490 -0.059301 1.622008 1.136168 0.012303 1.419176 0.768515 0.526817 1.171505 0.678139 1.461086 0.399056 0.554571 0.834287 1.199853 0.770698 1.010430 1.778823 1.630548 0.874770 0.206125 0.453526 0.079377 1.237714 0.535149 0.779971)
     )

;;; 55 all -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.0889595835043 (fv 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

	7.328036 (fv 0.000000 0.947722 0.378414 1.734925 1.134763 1.116950 -0.197611 1.060282 0.984801 1.744033 0.450580 0.852453 1.635373 0.966832 1.084419 1.003901 1.404608 1.476265 -0.291566 1.533682 1.691990 0.972863 0.920394 1.410967 0.405768 0.418479 1.362359 0.024022 1.434953 0.091943 0.952661 1.025574 1.292952 0.834214 1.423909 0.663594 1.666584 0.346034 0.453528 -0.158265 1.069551 0.339500 0.250235 -0.001369 1.635787 0.775741 0.405595 1.391152 1.825120 -0.221132 -0.233774 0.866177 1.169485 0.610484 1.501517)
     )

;;; 56 all -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.1394176483154 (fv 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0)

	7.349437 (fv 0.000000 1.546087 1.523699 -0.222814 1.563242 0.073887 1.226569 1.346857 0.292837 1.634387 -0.251778 0.060895 -0.022143 1.595396 1.558207 0.543894 0.524391 1.131307 0.107395 0.049540 1.190567 0.105407 1.309188 1.049686 1.847136 1.739252 0.730834 0.631473 0.965848 1.428286 1.258515 1.585209 1.811352 1.268900 -0.020138 0.642231 1.575017 1.141819 0.549674 0.685664 0.941820 0.311404 0.683359 0.230880 0.725054 -0.246162 1.525527 0.596605 1.235099 0.021275 1.782957 1.875900 1.027532 0.553643 1.151157 -1.905652)
     )

;;; 57 all -------------------------------------------------------------------------------- ; 7.5498
(vector 57 9.370246887207 (fv 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0)

	7.442633 (fv 0.000000 0.628456 1.084630 0.786609 1.548782 0.496773 0.435493 0.422694 1.803774 0.918361 0.997194 1.049098 0.185525 0.660957 1.525706 1.561906 1.871425 -0.071743 1.628047 1.493214 -0.116955 0.206404 -0.134909 1.268493 0.758821 0.611040 1.564268 1.138473 1.072129 1.438518 1.711282 0.723211 0.929199 1.378242 0.744685 0.403345 1.655964 0.451399 1.464052 1.394001 0.957137 1.897197 1.337811 0.214489 1.090057 0.644474 1.099729 1.418576 0.330091 1.432560 0.258645 0.901692 0.058744 1.707516 1.251524 1.445949 1.245045)
     )

;;; 58 all -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.4419231414795 (fv 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1)

     7.593225 (fv 0.000000 0.986536 1.505069 0.859324 0.384061 0.501999 -0.052945 0.091682 1.243523 1.160936 0.166126 1.095539 1.756174 -0.122227 0.552109 1.557396 0.685859 1.585162 1.476945 1.055076 1.281043 0.783847 1.368420 0.615588 0.179246 0.641014 1.029588 -0.186574 0.302199 -0.049566 0.358796 -0.163645 1.827318 0.906618 1.173192 -0.306816 0.026558 0.176625 -0.050521 -0.001713 0.047940 0.417922 -0.025755 0.782149 0.436145 0.202813 1.499347 0.776547 1.362707 0.702487 -0.159222 1.853688 0.812543 0.355313 1.668872 1.299867 1.606542 0.186584)

     ;; pp: 
     7.586012 (fv 0.000000 0.718317 1.202315 0.028202 0.604627 1.135917 1.727021 0.381274 1.040230 1.739246 0.978472 1.777017 0.523285 1.243580 0.029135 1.381437 0.426286 1.404192 0.617991 1.834215 0.844002 0.191054 1.403866 0.517083 0.013036 1.338892 0.991152 0.141969 1.593581 0.974013 0.805540 -0.094361 1.826176 1.316543 1.040287 0.818373 0.169416 0.148481 -0.005247 1.691109 1.757644 1.290544 1.656395 1.204579 1.394324 1.303854 1.338185 1.515030 1.707660 1.781840 0.030717 0.283137 0.603418 0.969911 1.476088 1.200110 0.180175 0.633552)

     ;; pp1:
     7.594343 (fv 0.000000 0.749835 1.196036 0.047415 0.621780 1.104858 1.683423 0.410089 0.997331 1.769746 1.019444 1.735512 0.510619 1.182024 0.010849 1.425649 0.362140 1.372448 0.624015 1.767029 0.754918 0.170009 1.406108 0.542718 -0.053715 1.339230 0.959996 0.102424 1.529396 0.978636 0.817177 -0.083573 1.854806 1.266587 1.089732 0.774700 0.147541 0.176983 -0.055229 1.674926 1.784675 1.300584 1.684703 1.169175 1.432021 1.273282 1.317555 1.468408 1.655397 1.821619 -0.009845 0.244752 0.605771 0.971746 1.410204 1.112895 0.141141 0.622757)

     7.604882 (fv 0.000000 1.003143 -0.865267 0.010219 -0.099642 -0.478021 -0.093216 0.744325 -0.039294 -0.002416 0.551785 0.316654 -0.123222 0.301399 -0.383480 -0.165893 -0.726009 0.524402 0.651077 -0.962303 0.315215 -0.603015 0.258064 -0.340148 -0.256538 -0.041913 -0.379049 -0.712938 -0.349442 0.451149 -0.446083 0.896871 -0.490206 -0.472734 0.420264 0.151583 0.131069 0.834014 0.859212 0.483964 -0.544840 -0.090156 0.432176 -0.243993 -0.843563 -0.050600 -0.631713 0.342919 0.025289 0.027400 1.444366 -0.042492 -1.145968 0.638141 -0.833781 -0.384767 -0.149344 0.896836)

     ;; 57+1
     7.533675 (fv 0.000000 0.632093 1.031320 0.996208 1.748376 0.527957 0.477473 0.368850 1.802959 1.003500 1.026751 0.861184 0.354704 0.677095 1.519803 1.568464 1.887057 -0.078151 1.682068 1.558254 -0.163110 -0.032581 -0.011976 1.336028 0.753207 0.560484 1.591069 1.249604 1.018113 1.569691 1.806306 0.820195 1.039096 1.390356 0.762349 0.481360 1.661435 0.465773 1.500956 1.500415 0.971368 1.891280 1.276898 0.073493 1.250778 0.582581 1.224274 1.436810 0.382220 1.412450 0.136039 0.767719 0.142694 1.828511 1.151320 1.547918 1.205287 -0.195522)
     )

;;; 59 all -------------------------------------------------------------------------------- ; 7.6811
(vector 59 9.4819116592407 (fv 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0)

	7.633759 (fv 0.000000 -0.102106 0.411390 1.377383 1.497595 0.124070 0.977823 0.515946 1.620540 0.196166 1.145526 -0.281630 -0.195296 1.404391 0.189637 1.328165 -0.070129 0.678415 0.164240 0.284857 -0.029704 0.602274 0.993542 1.271589 0.492176 0.728322 0.791637 0.338071 1.390375 1.125972 0.444347 0.171840 0.693527 1.264131 0.439002 1.477092 0.989010 0.611429 0.828210 0.480652 -1.722373 1.692898 0.138317 0.412855 0.367615 1.849818 1.092865 1.381771 0.372051 1.523953 1.713816 0.119731 0.675902 0.655871 0.560189 0.993051 1.958772 1.303462 0.504587)

	;; 60-1
	7.668205 (fv 0.000000 0.260999 0.306319 0.829788 0.601433 -0.678190 0.032714 -0.031883 1.182121 0.436499 0.860411 1.529871 0.029506 -0.270659 1.490132 0.906453 0.632531 -0.000842 1.433413 0.099705 1.394290 1.492347 1.704612 0.859780 -0.064335 0.888916 0.823173 -0.092258 1.655169 1.087888 0.521033 0.694079 0.255286 0.100258 0.664742 0.255239 -0.004409 -0.020809 -0.246563 0.401722 0.426493 1.163559 0.741366 0.718411 0.770050 0.987515 -0.377733 -0.050194 0.650015 -0.412935 -0.094285 0.634376 0.230847 1.070214 0.078695 0.757129 0.097582 0.734853 -0.028246)
     )

;;; 60 all -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.575254043103 (fv 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

	7.588747 (fv 0.000000 0.303100 0.261228 0.917131 0.691793 -0.677124 0.027342 -0.014801 1.166154 0.416979 0.851167 1.410955 0.139409 -0.306122 1.416862 1.054300 0.792442 0.062922 1.507148 0.118287 1.375215 1.459904 1.620963 0.828106 -0.237368 0.987982 0.753194 0.096604 1.712227 1.239483 0.673351 0.871862 0.125962 0.260000 0.626286 0.147473 0.131774 0.201212 -0.194457 0.538798 0.418147 1.292448 0.871870 0.794549 0.988888 1.131816 -0.166311 0.052304 0.543793 -0.229410 0.113585 0.733683 0.271039 1.008427 1.788452 0.654055 0.106430 0.828086 0.097436 0.376461)
     )

;;; 61 all -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.9175914844707 (fv 0 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1)

     7.764539 (fv 0.000000 0.501749 1.326260 -0.002830 0.440140 1.954758 -0.008202 0.999918 0.013473 0.542424 0.025115 0.566063 0.591900 -0.196853 0.709527 1.494974 0.701049 1.000710 1.261876 0.543883 0.605458 1.371875 -0.020772 0.931648 0.804346 0.926420 0.633175 0.027958 1.257581 0.427959 1.076239 -0.091270 1.537981 0.146252 0.640848 0.257921 1.798714 0.191485 0.663913 1.946117 1.528077 1.065296 -0.320137 1.459211 1.030583 1.751744 1.068882 0.287431 0.162869 0.095930 0.749409 1.433537 1.416981 -0.082974 0.219907 0.200900 1.575224 1.106230 0.733650 1.327996 1.447241)

     ;; pp:
     7.753858 (fv 0.000000 0.319725 1.167003 1.840366 0.153760 1.056380 1.530371 0.068799 1.142107 1.630458 0.891055 1.372619 0.446834 1.091219 0.302492 1.393205 0.356103 1.143793 0.345744 1.558858 0.517245 1.731373 1.219460 0.122291 1.292388 0.849768 0.068299 1.373758 1.017991 0.385053 1.507703 1.138013 0.742591 0.285609 -0.125056 1.492440 1.058816 0.934160 0.593744 0.533680 -0.158800 0.426341 1.446080 1.766771 1.695866 1.560056 1.478090 1.737231 1.729597 0.116298 0.076540 -0.001350 0.001958 0.473570 1.021992 1.263777 1.530152 1.876463 0.039103 0.812610 1.066132)

     ;; 60+1
     7.762613 #(0.000000 0.276386 0.414317 0.869069 0.716523 -0.643178 -0.098286 -0.026336 1.202366 0.401786 0.816823 1.358453 0.201475 -0.344747 1.569986 1.177849 0.830770 0.345954 1.397309 0.054411 1.350500 1.550431 1.710676 1.070124 -0.174301 1.227000 0.855830 0.420412 1.754959 1.402971 0.680298 0.501722 0.194431 0.413359 0.721337 -0.080500 0.317712 0.420316 -0.212050 0.504263 0.383071 1.533009 0.809698 0.805660 1.175933 1.195131 -0.160071 0.201353 0.519659 -0.221219 0.057333 0.393288 0.467942 0.981914 1.853549 0.897567 0.250931 0.868727 0.047025 0.577227 0.035515)
     )

;;; 62 all -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.9292116165161 (fv 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0)

	7.792971 (fv 0.000000 0.798156 1.779815 0.185967 1.670273 1.438952 1.815697 1.053871 0.087440 0.689337 0.052342 1.443903 1.423782 0.060887 1.727890 0.158639 0.952692 0.005318 0.914138 1.225205 0.683016 0.673829 0.109419 1.593849 0.225994 1.125995 0.418481 0.240605 0.743642 0.622844 0.353010 1.543180 1.534972 1.657806 0.217386 1.492286 1.132686 0.760213 1.147881 1.490201 0.001889 1.030507 1.289026 1.160822 0.387338 1.616191 1.464636 1.793960 1.874455 0.680274 1.683218 1.490668 0.689023 0.705366 0.946252 1.171040 0.109657 1.208442 0.793211 0.697986 1.263366 1.490757)
     )

;;; 63 all -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.9555234909058 (fv 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 1 0)

     7.900930 (fv 0.000000 0.112702 0.086876 0.634314 1.554089 0.214604 -0.203567 1.256800 0.100458 0.246503 1.488987 0.107459 1.914177 1.161772 1.897454 0.320257 1.283205 0.869894 1.466310 1.256681 0.167147 1.720679 0.949230 1.041227 1.129363 1.077459 1.317157 1.129579 0.390441 1.000383 0.208075 1.779398 1.501532 1.375523 -0.023235 1.338796 1.635364 1.234484 1.323162 0.435451 0.903475 1.821268 1.474898 0.271740 1.558504 0.547732 0.837920 0.522756 0.001164 1.566827 1.197274 1.065607 0.155490 1.019206 1.516032 -0.064964 -0.144993 0.026714 1.048953 1.812875 0.299023 0.685547 0.728053)

     7.876881 (fv 0.000000 0.730162 1.053547 1.853555 0.252740 0.906538 1.566071 0.152709 1.015626 1.877411 0.660255 1.513063 -0.004442 1.023537 0.043516 0.973208 -0.080949 0.883081 -0.126245 1.080582 0.224101 1.423101 0.674610 1.604094 0.756913 0.381286 1.606872 1.293154 0.397443 1.644011 1.075770 0.644269 0.164589 -0.255888 1.331182 0.886941 0.357762 0.438290 1.706681 1.847928 1.153249 1.311949 1.226087 1.303371 0.783267 0.589091 0.697039 0.351577 0.554862 0.724022 0.729451 0.902218 0.841292 1.194121 1.061823 1.429706 0.001167 -0.011629 0.776088 1.037188 1.244629 1.522995 0.260285)
     )

;;; 64 all -------------------------------------------------------------------------------- ; 8
(vector 64 9.957244923706 (fv 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 1 1 1)

	7.941887 (fv 0.000000 0.078350 0.185008 1.926703 0.321363 1.181646 1.402668 0.610982 0.623089 1.216601 1.332592 -0.291595 1.818855 1.612142 0.352450 -0.172928 1.880133 1.280898 1.910145 0.775896 0.915424 1.581714 0.463086 0.548034 1.045305 1.495776 -1.677351 1.247040 0.522690 1.227534 1.269499 0.212698 -0.052232 1.635256 1.888480 1.734142 1.150438 1.012285 0.389543 -0.097094 -0.358616 1.129328 0.215283 0.611096 0.487394 1.263156 0.637871 1.355777 0.092029 0.148467 1.060411 0.413204 1.241091 0.569303 1.457881 0.998119 0.874341 0.432403 1.077636 0.523921 0.747328 1.722616 0.867015 0.916274)
     
     ;; pp.scm:
     7.992914 (fv 0.000000 0.651329 1.088511 1.713470 0.442276 0.963521 1.501931 0.310181 1.212960 -0.011104 0.778232 1.515305 0.316833 1.237177 0.296916 1.189311 0.026642 1.098222 -0.017818 1.134719 0.273596 1.474260 0.550810 1.706455 0.919546 0.198719 1.526951 0.883788 0.268629 1.826193 1.021575 0.329612 -0.041590 1.516394 1.042877 0.648305 0.185654 -0.069051 1.607952 1.190320 1.094592 0.588439 0.829542 0.393611 0.610572 0.171199 0.117077 0.152394 -0.147682 0.017404 0.185404 0.037181 0.373288 0.371013 0.642715 0.482850 0.968331 1.382474 1.590294 -0.024057 0.298876 0.749699 1.152958 1.682631)
     )

;;; 65 all -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.157649040222 (fv 0 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0)

     8.034868 (fv 0.000000 -0.445401 1.151245 1.279345 1.476130 1.870307 1.647070 -0.199190 0.996479 1.841605 1.029874 1.628641 0.687865 0.948026 1.437242 1.472256 1.713531 0.116128 0.684445 1.801135 -0.030628 1.120947 0.852540 1.164480 1.740537 0.856297 1.486946 0.172686 0.895511 0.630282 1.378315 0.169569 1.750827 0.453225 1.137053 0.474570 0.449455 1.468205 1.690172 0.505222 -0.186497 0.479672 0.299749 1.440549 1.876899 0.243582 0.699167 0.152947 0.932331 0.165767 1.486581 1.086937 1.179952 1.305509 1.186761 0.971873 0.910187 0.131821 0.021623 1.435803 1.077493 0.071755 1.363290 0.536054 0.282812)
     
     ;; pp:
     7.973113 (fv 0.000000 0.586863 1.108547 1.809568 0.236474 0.932200 1.490976 0.236358 1.190604 -0.011282 0.981987 1.626061 0.541325 1.333541 0.166220 1.028548 0.073540 1.235912 0.201403 1.061871 0.289618 1.557561 0.463038 1.533243 0.718960 -0.031407 1.248624 0.634414 -0.029632 1.295765 0.653432 0.144947 1.300831 1.398877 0.579343 0.760977 0.024336 1.714192 1.357070 0.952728 0.458396 0.300957 -0.033236 0.181552 1.850554 1.728158 1.394294 1.294304 1.438841 1.230165 1.383584 1.610036 1.601644 1.798980 0.041945 -0.165907 -0.108364 0.492371 0.832142 1.280146 1.457449 -0.051803 0.040231 0.532391 1.056982)
     )

;;; 66 all -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.208241079264 (fv 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0)

	8.056638 (fv 0.000000 1.161331 1.936583 0.473825 1.730430 1.710083 1.722704 0.938539 0.650961 -0.301116 0.711382 0.874289 0.712393 1.263523 0.315048 0.391659 1.059022 0.363325 1.881127 0.161704 0.986800 1.590034 -0.289492 0.615410 -0.014906 1.387045 1.412270 1.265945 0.128543 0.445787 0.121476 1.705959 1.084173 1.066949 0.774156 0.933891 1.279265 0.297308 0.298325 1.512363 0.271282 1.243162 1.580605 1.521644 0.312598 0.465014 1.006013 0.269153 1.083812 0.157700 1.646414 0.707835 0.598039 1.973506 0.954025 0.104991 0.944717 0.038847 0.538283 0.734911 0.143649 0.104089 0.567333 0.271330 0.665962 0.751070)
     )

;;; 67 all -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.422191619873 (fv 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 1)

     8.144904 (fv 0.000000 0.836848 1.681555 1.191647 0.070261 0.942251 1.797644 1.070294 0.265921 1.462866 0.142770 0.004389 0.118755 0.795004 0.861059 0.364013 1.094070 0.938540 1.352932 1.681133 0.801557 -0.166830 1.660232 1.811404 -0.089491 1.793031 0.410641 1.462829 0.992048 -0.005221 0.624981 -0.049054 -0.100216 0.046599 -0.054149 1.061978 0.471687 -0.484886 1.299787 0.103592 0.873660 1.581185 1.539111 1.747106 0.867454 1.194479 0.984380 1.039016 -0.137566 1.440640 0.758746 0.623227 0.623868 1.161467 1.535042 0.328555 1.691644 -0.115223 0.929805 1.714954 0.103897 1.241682 1.520953 1.062392 0.666399 0.064868 1.788882)

     ;; pp:
     8.072785 (fv 0.000000 0.714480 1.141487 -0.059495 0.626617 1.143106 1.724186 0.562381 1.166774 1.775820 0.595712 1.588031 0.453186 1.514340 0.088154 0.928491 -0.033585 0.878492 -0.006785 0.660928 1.635393 0.709844 0.143551 1.201690 0.276956 1.367207 0.639357 0.086720 1.577267 1.234748 0.475681 -0.133351 1.448411 0.486601 -0.203691 1.708040 1.315311 0.962381 0.408017 0.396955 1.868803 -0.051618 1.159243 0.738595 0.693611 0.852762 0.510509 0.806906 0.489441 0.162663 0.197789 0.090682 0.076822 0.594675 0.394390 0.961428 0.800767 1.169831 1.000600 1.531863 1.954261 0.431033 0.762550 1.024871 1.795795 1.769037 0.290496)
     )

;;; 68 all -------------------------------------------------------------------------------- ; 8.2462
(vector 68 10.460547747753 (fv 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1)

	8.168157 (fv 0.000000 0.354978 1.878673 1.059221 0.759731 0.956747 0.711479 0.720163 0.372733 0.204844 0.455442 0.097446 1.506513 0.919884 0.814781 0.935488 0.786490 1.074073 1.203975 1.052443 0.726494 1.730845 0.062987 1.716136 1.412039 0.233751 0.090641 -0.003605 0.550389 0.691280 1.313887 0.137194 1.521036 1.556316 0.070039 0.198694 1.780701 0.986693 1.284403 1.408455 0.102332 1.273719 0.728671 0.008237 1.436719 1.092816 0.742660 1.480879 0.410157 1.288179 0.559234 1.425899 1.219179 0.189574 0.471285 1.159537 -0.028955 1.469388 0.210392 1.141156 -0.135055 0.687474 1.468060 -0.235268 0.553950 0.681055 0.986756 1.515599)
     )

;;; 69 all -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.495518383865 (fv 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0)

	8.197146 (fv 0.000000 0.551719 0.168788 -0.171535 0.603472 1.646430 0.831219 -0.112901 1.600971 0.776706 -0.257580 1.457106 0.729936 0.539913 1.421843 0.548661 0.072361 0.728562 0.364648 -0.109430 1.359599 1.471812 0.472868 -0.088533 0.623026 0.167759 1.605110 0.053141 0.996253 1.258861 1.710199 1.079237 0.316774 0.568130 0.226861 -0.084943 1.702544 1.075688 0.298153 0.507109 1.291563 1.177929 1.707324 -0.001439 0.386332 0.512557 0.380487 0.243873 1.516865 0.101344 -0.768813 1.646072 0.275192 0.139649 1.389985 1.576705 0.346880 0.446918 1.441036 0.376743 1.075298 0.134005 0.942798 0.778785 1.014815 1.144279 1.213481 1.047075 1.249788)

	;; 70-1
	8.143974 #(0.000000 0.563151 1.347234 0.372166 1.011160 1.230491 0.749402 1.243692 1.327484 0.188943 0.690097 1.705036 0.306148 0.675830 0.924357 1.699354 0.831298 0.036827 0.920452 -0.161127 0.378618 1.012001 1.732453 1.018416 0.093399 -0.223999 0.415971 -0.093239 0.157176 -0.107480 -0.077653 1.591872 -0.197575 1.675265 0.529602 1.688724 1.228937 -0.066917 1.910851 0.147616 0.958159 0.065098 0.692177 0.777376 0.643403 -0.410706 0.296222 0.415687 -0.096263 1.411122 1.263478 0.068706 -0.286121 0.572877 1.080715 0.960873 -0.048076 1.732249 1.330711 0.695044 0.195422 -0.180667 0.159809 -0.240900 0.873699 0.964556 0.811214 0.629243 -0.017179)
     )

;;; 70 all -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.532930374146 (fv 0 1 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0)

	8.176963 (fv 0.000000 0.587989 1.431825 0.221285 0.960638 1.245837 0.795275 1.178692 1.324313 0.151685 0.789663 1.805305 0.407280 0.848410 1.089893 1.582619 0.871354 1.940142 1.022672 -0.098747 0.444755 1.081717 1.884930 1.020069 0.094475 0.162127 0.516048 0.043396 0.218952 -0.075886 0.177709 1.517609 -0.008561 1.566136 0.502844 1.768539 1.199988 0.053518 1.941460 0.082194 1.231659 0.182374 0.578473 0.843872 0.777996 -0.220205 0.467426 0.426401 0.154145 1.445497 1.004198 0.090981 -0.148632 0.673583 1.270739 1.002492 -0.085118 1.727335 1.374618 0.568333 0.205667 -0.017872 0.120962 -0.075966 0.957264 1.025234 0.841047 0.662525 -0.011036 1.297608)
     )

;;; 71 all -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.610488331633 (fv 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

	8.319609 (fv 0.000000 0.140438 -0.156343 1.390907 0.216508 0.199081 1.047301 1.430567 0.016863 1.549577 0.363516 1.057536 -0.217538 0.646697 0.414461 0.993065 1.127770 0.877766 0.873392 0.440804 0.760841 0.449527 0.494946 1.105821 0.463488 1.200046 1.158237 0.977607 1.309426 0.772719 -0.483517 0.568526 0.817490 0.531524 0.272201 1.656272 -0.164981 0.659567 1.062868 -0.123485 1.015493 0.120132 0.671070 0.461022 1.766703 1.319785 0.775590 0.108288 0.757022 1.176333 1.486331 1.779348 -0.137633 1.540074 -0.041450 0.361903 1.057755 1.116867 0.573932 0.250328 1.480465 0.262890 0.893036 1.148682 1.046983 0.264942 1.618761 0.311598 1.395691 0.570219 0.159607)

	;; 70+1
	8.361412 (fv 0.000000 0.740317 1.242889 0.039232 0.814335 1.166091 0.886569 1.070194 1.407373 0.191217 0.634972 1.759540 0.424176 0.804734 1.088530 1.459937 0.898750 1.966462 0.841588 -0.193384 0.602364 1.255008 1.812990 1.112783 0.081831 0.313117 0.460293 0.063534 0.180365 -0.157780 0.171890 1.473837 0.011809 1.452548 0.297849 1.819072 1.366391 -0.158097 -0.091315 0.199555 1.168562 0.004295 0.373805 0.712167 0.674492 -0.433642 0.680831 0.274766 0.104186 1.481659 0.829848 -0.259698 -0.182310 0.668457 1.102735 0.721359 -0.157410 1.679438 1.486805 0.409651 0.130189 0.043503 -0.099512 -0.150146 1.039963 0.847149 0.795577 0.715897 -0.213477 1.130701 0.366997)
     )

;;; 72 all -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.800657366855 (fv 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0)

     8.472893 (fv 0.000000 -0.093428 0.860520 0.651650 0.036400 1.174208 -0.214755 0.653075 0.661176 1.355137 1.759893 1.116459 1.283776 0.222435 0.388195 1.541066 0.171819 0.911538 0.292609 1.508023 0.997352 1.385529 0.022962 0.061408 -0.061153 0.241196 0.345845 0.923448 0.626801 0.283115 0.129077 0.499608 0.703807 0.614285 0.908458 0.403245 1.817077 1.458947 0.221667 1.213107 1.163972 1.117128 0.465749 0.627880 0.010093 0.512887 0.278332 0.535697 1.736410 -0.297420 0.467311 1.419905 1.531806 0.300181 0.244309 1.719696 1.200428 1.778805 1.081039 0.613164 1.654092 1.161237 1.675808 0.051072 0.709895 1.432879 0.690303 1.567340 0.453011 1.156931 0.253055 -0.113821)

     ;; pp.scm:
     8.398072 (fv 0.000000 0.721030 0.948975 1.651519 0.233429 1.256419 1.215593 0.048780 1.144871 0.213229 0.880829 1.692382 0.366636 0.960208 1.629523 0.574770 1.546769 0.517973 1.617121 0.416046 1.542708 0.301404 1.290249 0.820158 0.258866 0.894435 0.090675 1.532038 0.985523 -0.034703 1.528561 0.881196 0.099225 -0.003432 1.044040 0.536864 -0.131692 1.029980 1.151362 0.675489 -0.005731 -0.378928 1.525987 1.057922 0.658986 0.443501 0.074450 0.429490 -0.435612 0.068631 -0.209332 1.531485 1.585628 1.667775 1.257877 1.589580 1.146646 -0.378411 1.726866 -0.167738 -0.290459 -0.269650 0.365115 0.370457 0.748015 1.193861 1.678605 0.010066 0.170551 0.863723 0.838123 1.538906)
     )

;;; 73 all -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.773231506348 (fv 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1)

	8.432898 (fv 0.000000 -1.848123 0.239060 1.464251 0.628713 1.091837 0.714118 0.011434 1.168318 0.062880 1.015397 -0.328225 1.126530 0.965816 1.106076 -0.063170 1.197633 -1.809778 0.091864 0.972492 1.580451 1.036972 -0.065401 1.876586 0.421742 1.575936 0.943040 0.998651 1.251175 1.731410 0.520979 0.344525 -0.022728 1.604302 0.415026 0.363810 0.330426 1.053516 0.529548 0.585862 1.282692 0.064995 0.245738 0.033146 -0.021970 -0.243322 -0.102869 1.628985 0.462863 1.533635 0.132871 0.079809 0.450013 1.062550 1.900737 0.507033 1.228155 0.664499 0.381483 1.660810 1.361854 0.409741 0.569163 0.877009 1.830036 -0.331099 1.110302 0.325340 1.299368 0.004038 0.123887 1.612282 0.588683)
     8.433132 (fv 0.000000 -1.847444 0.237344 1.464638 0.628887 1.093285 0.714406 0.013323 1.168036 0.063810 1.016680 -0.328601 1.126593 0.966206 1.107076 -0.063367 1.197228 -1.807287 0.093599 0.972529 1.580674 1.036337 -0.065390 1.875846 0.422275 1.575682 0.944151 0.999284 1.251360 1.730976 0.519804 0.344632 -0.023064 1.604915 0.415187 0.364741 0.329769 1.054442 0.530131 0.585700 1.283021 0.065351 0.245840 0.033137 -0.021137 -0.245019 -0.102624 1.631439 0.462301 1.532901 0.133014 0.079045 0.450558 1.061941 1.898554 0.507196 1.226904 0.663782 0.379349 1.659890 1.360030 0.408513 0.568905 0.876030 1.829471 -0.331743 1.109442 0.325360 1.299379 0.003611 0.124368 1.612931 0.587209)
     )

;;; 74 all -------------------------------------------------------------------------------- ; 8.6023
(vector 74 10.684138298035 (fv 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

	8.497103 (fv 0.000000 1.325782 0.182538 1.505234 0.945874 -0.041671 1.080868 0.605444 0.042184 0.866151 0.092779 0.735532 1.859565 0.020319 1.317206 0.107906 1.193633 1.487996 0.330731 0.601261 1.523499 -0.092194 -0.139866 0.997309 1.096776 -0.197191 1.061243 0.954641 0.070885 1.639404 0.509022 -0.561148 1.719565 1.632249 0.046116 -0.076359 1.376098 -0.015465 1.245129 0.220256 -0.000849 1.641349 1.603215 1.034336 0.812483 1.278349 1.510965 -0.515530 0.337854 1.060139 1.372801 0.633196 -0.113165 0.038608 0.288776 0.637200 0.027245 0.289307 1.083582 1.060936 0.972742 0.986362 -0.049682 0.384401 -0.025034 0.779020 0.227500 0.842052 1.419898 1.088862 -0.034683 -0.286302 1.416569 1.188508)
     )

;;; 75 all -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.935811368418 (fv 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1)

	8.611733 (fv 0.000000 1.755991 1.257704 1.380660 0.149810 0.888775 1.327127 0.155263 0.151577 1.307367 0.881185 1.244394 1.574597 0.297434 0.440838 1.532006 1.732873 0.955224 1.870085 1.039379 1.279345 1.370265 1.314175 1.228630 1.384735 1.656856 0.776266 0.604534 0.261984 1.021399 1.199829 0.578676 0.077339 1.180219 1.340992 0.303192 0.817942 1.840717 0.738716 0.586273 0.790045 1.068192 1.408743 0.034139 1.236420 0.200452 1.339574 1.564413 1.584603 1.696238 1.745531 0.073419 1.093015 0.201959 1.123150 0.434940 -0.158552 1.357895 0.030228 1.300705 0.831156 0.431680 0.205560 1.314167 1.822576 0.046350 0.064332 0.206633 1.539706 0.841946 1.061607 0.243862 0.776250 0.362661 1.442056)

	;; pp:
	8.821449 (fv 0.000000 0.643920 1.130972 1.690238 0.292464 0.869774 1.528895 0.096431 0.833368 1.732367 0.427956 1.133243 1.895101 0.800425 1.503313 0.355825 1.366323 0.344133 1.388010 0.331489 1.394341 0.485612 1.420333 0.688914 1.775329 0.789323 0.036609 1.415234 0.580136 1.640322 0.948602 0.310562 1.639770 0.988134 0.358709 1.824434 1.269806 0.767195 0.219365 1.612634 1.203169 0.799392 0.490094 0.057192 1.813674 1.532055 1.111172 0.983185 0.529777 0.494315 0.164905 0.200436 0.060224 0.054336 1.844838 1.742836 -0.015897 1.650654 1.808368 1.772294 1.907511 0.205329 0.331823 0.493249 0.521115 0.584376 0.981386 1.313449 1.561550 1.968782 0.480174 0.693653 1.229745 1.573452 0.052739)

	;; 74+1
	9.469 (fv 0.000000 1.325782 0.182538 1.505234 0.945874 -0.041671 1.080868 0.605444 0.042184 0.866151 0.092779 0.735532 1.859565 0.020319 1.317206 0.107906 1.193633 1.487996 0.330731 0.601261 1.523499 -0.092194 -0.139866 0.997309 1.096776 -0.197191 1.061243 0.954641 0.070885 1.639404 0.509022 -0.561148 1.719565 1.632249 0.046116 -0.076359 1.376098 -0.015465 1.245129 0.220256 -0.000849 1.641349 1.603215 1.034336 0.812483 1.278349 1.510965 -0.515530 0.337854 1.060139 1.372801 0.633196 -0.113165 0.038608 0.288776 0.637200 0.027245 0.289307 1.083582 1.060936 0.972742 0.986362 -0.049682 0.384401 -0.025034 0.779020 0.227500 0.842052 1.419898 1.088862 -0.034683 -0.286302 1.416569 1.188508 0.0)
	
	;; 76-1
	9.623 (fv 0.000000 0.389242 -0.170662 1.421644 1.248164 0.164000 0.718605 1.792721 0.677210 1.518595 0.963267 -0.186472 1.263794 1.595425 0.383743 0.443182 1.535243 0.669172 1.194047 0.802827 1.746269 0.569800 1.408025 1.796723 1.258639 0.620093 0.886554 0.863256 0.711462 1.456391 -0.186271 0.639923 1.414383 -0.059653 0.858601 0.618312 0.847274 0.301714 0.319909 0.359052 0.817062 -0.212571 0.558016 0.169995 1.152558 0.886044 1.332154 0.013242 0.369659 -0.032997 1.710630 1.029547 0.363359 -0.095703 0.197840 0.264645 1.078918 0.774045 1.172991 1.082380 0.650868 1.140749 0.194089 0.747056 0.734148 0.248352 1.094670 0.793873 -0.197763 1.665030 0.915389 0.675623 1.504323 1.585265 1.586133)
     )

;;; 76 all -------------------------------------------------------------------------------- ; 8.7178
(vector 76 10.689208030701 (fv 0 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0)

	8.622898 (fv 0.000000 0.389242 -0.170662 1.421644 1.248164 0.164000 0.718605 1.792721 0.677210 1.518595 0.963267 -0.186472 1.263794 1.595425 0.383743 0.443182 1.535243 0.669172 1.194047 0.802827 1.746269 0.569800 1.408025 1.796723 1.258639 0.620093 0.886554 0.863256 0.711462 1.456391 -0.186271 0.639923 1.414383 -0.059653 0.858601 0.618312 0.847274 0.301714 0.319909 0.359052 0.817062 -0.212571 0.558016 0.169995 1.152558 0.886044 1.332154 0.013242 0.369659 -0.032997 1.710630 1.029547 0.363359 -0.095703 0.197840 0.264645 1.078918 0.774045 1.172991 1.082380 0.650868 1.140749 0.194089 0.747056 0.734148 0.248352 1.094670 0.793873 -0.197763 1.665030 0.915389 0.675623 1.504323 1.585265 1.586133 1.087431)
     )

;;; 77 all -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.114716461811 (fv 0 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0)

	8.693626 (fv 0.000000 0.342470 0.518102 0.602103 1.407511 1.793531 0.096346 0.250378 0.943784 0.388159 0.656038 0.296223 1.141950 0.214103 0.212479 0.828756 1.402312 1.692057 0.511954 0.158583 -0.254149 0.373835 0.095344 -0.147316 0.784069 0.081610 -0.056393 0.798330 0.705534 1.696239 0.742515 1.236436 -0.107133 1.590407 0.658892 -0.033009 -0.161883 1.612218 1.476439 0.692575 -0.060023 1.224517 0.875204 0.501273 0.494798 0.327706 1.600469 0.607079 0.567961 0.917115 0.716199 1.138396 0.731691 -0.084350 0.371809 0.181536 0.739186 1.478965 0.762792 0.759384 1.499056 1.662862 1.474568 1.752637 0.981158 1.382311 0.543578 -0.609814 1.825975 0.848970 1.045950 0.310451 0.519502 0.003348 1.354017 -0.105098 1.298274)
     )

;;; 78 all -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.471938943963 (fv 0 1 1 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1)

	8.722411 (fv 0.000000 1.255512 1.230399 0.081980 0.091889 1.621099 0.342591 1.837930 1.553347 0.020611 1.397162 1.790981 1.252453 0.690562 0.318059 1.053703 0.774563 1.716197 0.556425 0.552259 0.785064 1.839927 0.777897 1.437066 0.895405 0.585543 1.604873 0.287802 1.218230 1.490317 0.738166 1.716918 1.559725 1.441156 1.459900 0.634618 1.118581 1.560941 1.459563 0.686391 0.612299 1.393780 -0.080258 0.668424 0.483242 1.297761 1.805261 0.997133 1.633324 0.413677 0.790560 1.306313 0.980643 1.877269 0.988455 0.158400 0.345980 0.044253 -0.181533 1.453766 -0.079535 1.631519 0.486812 0.259728 0.034933 -0.142793 0.162924 0.999804 0.854260 0.983588 1.417702 1.583925 0.160842 -0.232352 1.810021 0.235258 1.847667 1.008413)
     )

;;; 79 all -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.334476470947 (fv 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 0 0 1 0)

     8.845367 (fv 0.000000 1.238318 1.165090 1.291700 0.803595 0.614248 1.388497 1.905092 0.146964 0.775475 0.093294 -0.057178 0.069260 0.967289 0.726888 1.927694 0.404014 -0.050125 1.170622 0.795731 0.415661 0.113117 0.949983 0.547877 0.937155 0.147536 1.182414 0.680260 0.043365 0.406697 0.191985 0.520170 0.649818 0.646884 0.567272 1.384599 1.089945 0.420022 1.776381 1.388186 1.481564 0.061642 1.806781 0.638535 0.038366 1.606509 1.826388 1.366478 1.328019 0.480776 1.683074 0.476259 0.537766 1.179629 1.609320 1.234604 0.090600 0.429089 1.028733 0.835166 0.689618 1.227466 0.068475 0.130750 1.461448 1.601183 1.627224 0.857096 1.862391 0.455364 1.260302 0.135047 1.550455 0.219288 0.922341 0.004761 0.651583 1.409352 1.642849)

     ;; pp:
     8.789422 (fv 0.000000 0.841271 1.349529 1.890897 0.486913 1.229207 1.764686 0.291323 1.071234 1.657114 0.392223 1.196564 -0.051237 1.012534 1.818519 0.557943 1.398685 0.101423 1.163908 0.287712 1.222706 0.108952 1.110220 0.148905 1.491258 0.557702 1.639140 0.711113 1.834003 1.123857 0.414123 1.736420 1.249713 0.566166 1.633495 0.696955 0.342141 1.602019 1.390394 0.718811 0.378092 1.687751 1.289262 0.793430 0.544409 0.190417 1.780346 1.824595 1.124520 1.532834 0.805430 0.739198 0.373300 -0.106662 1.921342 -0.093028 1.851981 1.677334 0.037484 1.564822 1.520739 1.501603 1.425816 1.592847 1.805684 0.130893 0.254917 0.439595 0.443645 0.715009 0.911405 1.240948 -0.028352 0.369153 0.881458 1.168966 1.410521 1.748339 0.400660)
     )

;;; 80 all -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.30185508728 (fv 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0)

	8.831605 (fv 0.000000 0.718457 0.752874 0.707265 1.105140 1.556866 1.675971 1.743288 1.737050 1.402684 0.726424 0.001544 0.787560 0.610707 0.221912 0.548490 1.255462 0.532840 1.735795 1.159475 0.139393 0.566082 0.477708 1.186070 0.213588 1.697938 1.877210 -0.027617 0.446036 -0.097653 1.420626 0.288659 1.413894 1.358919 0.713009 -0.285435 0.875204 0.375292 0.708148 0.907015 0.596415 1.676708 -0.002236 0.617188 -0.254880 0.679354 1.396570 0.024604 0.491384 1.191175 0.583286 0.255907 0.583959 0.646881 1.743044 0.166682 0.513542 1.079013 0.694687 0.379588 0.528146 0.707196 1.408903 1.510794 1.151055 0.672700 0.297721 -0.154036 1.059849 1.480109 0.687072 0.133333 1.264870 -0.326181 0.342810 1.875130 1.918140 1.634313 0.782341 -0.170226)
     )

;;; 81 all -------------------------------------------------------------------------------- ; 9
(vector 81 11.22668050284 (fv 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1)

     8.961491 (fv 0.000000 0.634711 0.914288 0.369120 0.489315 1.342522 0.647705 1.766421 1.148272 1.455934 0.450010 0.224566 1.110702 0.040996 1.346853 1.773154 1.255402 0.752437 1.110884 0.031625 1.597766 0.103816 1.912905 -0.011027 0.863686 0.820253 1.302167 1.352505 1.039370 0.116915 0.947518 1.168519 0.272351 1.514646 1.808891 0.551022 1.359986 0.703545 0.651408 1.697573 1.001093 1.819478 -0.153070 -0.020542 0.748602 1.669047 0.373021 0.491577 0.705265 0.740848 -0.189697 0.502215 0.348836 0.005306 -0.207198 0.930183 -0.631614 1.639932 1.773044 1.357496 1.130593 0.312825 1.896666 0.201668 1.169961 0.899991 0.382267 -0.065252 0.308097 0.095309 1.059630 -0.075945 1.147344 0.303812 -0.113244 -0.220507 0.240152 1.567520 0.130729 0.128142 -0.134246)

     ;; pp:
     8.909320 (fv 0.000000 0.637783 1.093840 1.736075 0.229438 0.855956 1.363854 0.030260 0.521624 1.242121 0.051165 0.675419 1.614595 0.476873 1.278688 0.012785 0.817110 -0.304934 0.720383 -0.202920 0.733695 0.107439 1.315558 0.129614 1.122993 0.193244 1.234642 0.403581 1.725244 0.895732 0.205820 1.636536 0.593082 1.809528 1.260391 0.470119 -0.070091 1.399098 0.818162 0.271203 1.928340 1.562814 0.865292 0.051460 1.916623 1.232135 1.265689 0.734799 0.654116 0.188660 0.092307 1.641866 1.468875 0.817027 0.972897 0.621305 0.637924 0.617240 0.962249 0.473819 0.518139 0.286173 0.438785 0.267011 0.412016 0.426579 0.834941 1.189978 1.256888 1.096694 1.389245 1.442391 -0.226908 0.347927 0.458943 0.982038 1.505430 1.850054 0.061414 0.437908 0.768823)
     )

;;; 82 all -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.601468306037 (fv 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0)

     9.074372 (fv 0.000000 1.648602 0.113059 0.965847 0.614379 1.876939 0.598065 0.033495 1.128904 0.535962 0.404933 0.340847 -0.287176 1.664997 0.944124 0.484563 1.365390 -0.175780 1.135023 1.030858 0.610885 1.630994 0.348969 1.892603 0.337558 0.278067 1.048537 1.676406 0.392409 0.207975 0.887089 1.313518 1.800663 1.007393 0.181812 -0.074478 0.144619 1.511865 1.173214 0.664191 1.387698 1.632837 0.132108 0.353188 0.227412 1.024174 1.607289 0.662392 -0.023377 -0.428601 1.063517 1.407784 1.563623 0.788150 1.561202 0.023129 0.361493 1.608137 1.816713 0.962416 0.274252 0.900687 0.860331 0.458473 0.118859 0.572111 0.805640 1.846370 0.649018 0.713232 0.291663 -1.866918 0.486252 0.300849 0.355338 1.356604 0.996671 0.882787 1.511703 1.110696 1.774461 0.441695)

     ;; pp: 
     8.942054 (fv 0.000000 0.741190 1.211121 1.767480 0.098390 0.839201 1.102556 -0.209453 0.453250 1.122839 0.064920 0.959867 1.388767 0.263801 1.292900 0.219769 1.265994 0.422114 1.103821 -0.093210 0.755477 0.000245 0.969187 1.607339 1.053959 0.313625 1.046034 0.279348 1.465040 0.751688 0.022843 1.470315 0.592990 1.853486 1.118710 0.593243 1.855200 0.862858 0.945784 0.185739 1.601158 1.076300 0.669622 0.291600 1.841348 1.175765 0.663836 0.601642 0.369909 1.837262 -0.023948 1.335189 1.343186 0.755277 0.855544 0.293163 0.518573 0.368668 0.285100 0.386831 1.688397 0.163703 0.172910 0.313842 -0.159903 -0.137818 0.212922 0.539645 0.627827 0.897666 0.865830 1.159886 1.047275 1.360198 1.762925 0.204264 1.078567 0.797293 1.200018 1.357729 0.204458 0.441846)
     )

;;; 83 all -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.429935034332 (fv 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

	8.938600 (fv 0.000000 0.414028 0.125789 1.159865 0.086238 0.817482 0.340516 1.199339 -0.170286 1.744945 1.587696 1.158800 1.281058 0.190384 1.473320 0.235428 1.621261 0.225261 1.644931 -0.137023 1.525995 0.691219 0.557902 1.528647 -0.234276 -0.009740 0.044217 0.592778 0.909815 0.773874 0.836299 0.726340 0.981312 0.618405 0.408288 0.150201 0.908250 0.109103 0.413166 0.847395 0.541585 1.672450 1.474939 0.635397 0.153870 -0.014899 1.455728 0.983819 0.181154 0.726107 0.638924 1.106663 0.611788 0.238433 0.670956 1.522770 1.842401 0.939513 -0.051810 1.267322 0.323759 1.831419 1.004026 -0.159128 0.287041 0.349723 0.402841 0.045990 0.570998 1.374651 1.603295 0.760887 1.460939 -0.002747 0.693326 1.517648 0.987805 0.554027 0.029827 0.036863 0.188640 0.849464 1.347102)
     )

;;; 84 all -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.774056434631 (fv 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1)

	9.023210 (fv 0.000000 0.159304 -0.208530 0.193874 1.193993 0.513874 0.193906 1.420202 1.601162 0.069662 0.596870 0.499106 1.879705 1.298791 1.380896 1.011752 1.567079 1.088823 0.586749 1.189212 0.187019 0.623891 0.443258 1.756821 0.221910 -0.166048 1.505325 1.956699 0.145006 0.858253 1.259810 1.292214 -0.292005 0.449812 -0.218977 -0.354252 1.219999 0.997645 1.646540 1.482430 0.239288 -0.155628 0.755326 1.705293 0.967714 0.360450 0.143064 1.152089 0.481087 0.972815 0.614833 1.330922 0.788019 0.726428 0.572863 1.454284 1.031818 0.764416 0.692179 1.019395 0.005944 0.083543 1.745841 0.713648 0.857380 1.260681 1.338561 0.608841 1.025699 1.518383 0.107569 1.492751 -0.040716 0.923284 0.288212 0.772164 -0.210851 0.728511 0.794985 1.593926 1.082153 1.208449 1.606070 0.581831)
     )

;;; 85 all -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.927130699158 (fv 0 0 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 1 1 0 1)

	9.127702 (fv 0.000000 0.377539 0.047529 1.429700 0.417181 1.140688 0.738197 -0.138709 -0.448043 0.627123 1.392127 1.819604 0.611302 1.321770 0.758910 1.628764 1.577483 0.372253 0.761090 0.479480 0.236979 1.110344 0.805106 1.644437 0.008357 0.656171 0.991297 -0.054354 1.739257 1.797129 1.125137 0.066677 1.422676 0.455091 0.389601 0.812550 0.569451 1.358336 1.535806 0.395945 0.917012 1.261389 0.975555 0.676523 1.340562 0.262979 0.348691 0.300647 1.560755 0.036844 0.912709 1.718241 0.914499 1.035722 0.712055 1.556119 1.328161 1.240892 0.216373 0.897089 0.626805 0.862584 0.585791 1.306757 0.828290 1.426360 0.918009 1.215542 0.443071 1.531104 1.274055 0.636447 0.998872 0.647434 1.352131 -0.267987 0.709420 0.317461 -0.001614 0.037126 -0.160098 1.679742 0.637515 0.582751 0.080874)
     )

;;; 86 all -------------------------------------------------------------------------------- ; 9.27362
(vector 86 11.780031204224 (fv 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

	9.206953 (fv 0.000000 -0.339088 0.933342 -0.128298 1.099279 0.084536 0.851599 -0.014992 1.465425 1.307317 0.418122 0.289943 1.668778 0.506500 1.696171 1.171193 0.792416 0.989400 0.972892 1.055909 1.790099 1.474165 1.862965 1.486120 1.916599 0.452792 1.686062 0.595804 0.951171 -0.158372 0.842834 1.045604 0.896962 0.721188 0.145646 1.627929 1.192540 1.524829 0.808536 1.173303 0.835497 0.870602 1.525244 1.506688 0.379810 0.397104 0.800652 0.803279 1.193873 1.751911 0.273257 0.582749 0.328287 1.542626 0.758388 0.690207 1.020504 0.688526 -0.031652 0.949811 0.197494 0.391786 1.605605 0.223632 0.906957 1.312801 1.428402 0.597149 1.497710 -0.659689 1.704635 0.962819 1.427359 1.450510 1.282944 1.167035 0.635413 0.328489 1.735204 0.771081 1.542497 0.207128 0.104268 1.136822 -0.363620 0.034704)
     )

;;; 87 all -------------------------------------------------------------------------------- ; 9.3274
(vector 87 11.76194265333 (fv 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     9.336088 (fv 0.000000 0.935303 -0.305855 0.639666 -0.205066 0.575166 1.878633 -0.031633 0.332111 0.265245 0.447761 1.471005 0.466239 1.074654 0.243517 0.903095 0.071080 0.582837 0.986978 1.432105 0.143848 1.529993 0.888064 0.154620 1.746534 1.298224 1.092204 0.252914 1.241973 -0.114644 0.118634 1.005127 -0.195946 0.639640 0.754289 -0.065632 0.714364 1.300342 0.839106 1.256746 0.582262 1.885531 1.298010 0.384388 0.185574 1.168220 1.586291 1.242180 1.296083 0.391273 0.262871 0.811036 0.806565 0.431451 1.015342 1.630813 1.685662 -0.062763 0.311437 -0.322103 1.934808 -0.217239 0.478902 -0.218460 1.046362 0.603169 1.523851 1.302931 0.360083 0.678610 0.838126 1.626723 0.408089 0.150785 0.439104 0.575446 0.524826 1.662738 0.111387 1.179455 0.712858 0.531389 0.286195 0.456407 0.251572 1.398780 1.753711)

     ;; pp:start point was (pp.scm, make-pp.scm): pi+pi/87 and -pi/2
     9.201148 (fv 0.000000 0.606264 1.286641 1.633640 0.300135 0.826873 1.570361 0.039518 0.674212 1.390759 0.031099 0.782113 1.606099 0.456663 1.310938 -0.012755 1.011947 1.962275 1.031324 1.924212 0.700369 1.463259 0.449090 1.418882 0.516579 1.837916 1.056960 -0.026846 1.090144 0.187208 1.379580 0.694876 0.055771 0.972409 0.040906 1.575865 1.149936 0.410530 1.850809 1.237404 0.345035 1.553764 1.235369 0.825540 0.101389 1.583999 1.336472 0.955112 0.350910 -0.239863 1.473194 1.184033 1.132454 0.656789 0.797039 0.036147 0.315231 -0.255734 1.842540 1.250679 1.177721 1.108481 0.895012 1.358540 0.880609 0.969577 0.756153 1.004262 0.902032 1.003387 1.132762 1.561102 1.534103 1.804297 0.070209 -0.024117 0.069086 0.402650 0.873594 1.402800 1.716632 1.930312 0.453843 0.755753 1.442497 1.742394 -0.135628)
     )

;;; 88 all -------------------------------------------------------------------------------- ; 9.3808
(vector 88 11.638312339783 (fv 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

	9.316523 (fv 0.000000 0.878486 0.456733 1.616494 0.833842 1.630288 0.213084 0.318066 0.387075 1.258199 0.888074 1.626323 1.385324 1.449641 1.788877 1.459694 0.074476 0.796586 0.333918 0.652336 0.086019 1.093159 0.327760 0.026729 0.468210 0.200167 0.537074 1.539924 -0.274885 1.353211 0.267108 0.236471 1.407050 0.990605 0.724714 0.464124 0.495860 1.314621 -0.030616 0.350065 0.839694 0.794947 -0.082046 0.540462 1.600245 0.715450 0.591095 1.608103 0.808561 1.476715 1.175725 0.089220 0.447550 -0.172825 1.173712 -0.287102 0.416439 1.195370 1.285929 1.007325 0.957271 -0.013128 1.194681 1.765216 1.741310 1.202198 1.235154 1.112410 1.116838 1.017962 0.227564 0.013993 0.930616 0.757675 -0.297628 0.560900 0.173387 0.493968 1.241443 0.533916 1.114281 1.119507 0.538020 0.529723 1.672789 1.594826 0.538626 1.278733)
     )

;;; 89 all -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.148494905477 (fv 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1)

	9.351480 (fv 0.000000 0.115345 0.952969 1.130622 0.084058 0.254252 0.443202 0.470071 0.932794 0.466331 0.591979 0.457396 1.528107 0.715257 1.847307 0.403253 0.673874 1.456603 0.267262 0.304798 0.064020 -0.007350 0.259234 -0.287472 0.913317 0.595047 1.491194 0.951199 1.469407 0.524123 -0.304693 -0.076445 1.827209 1.059199 1.449793 1.495662 0.754984 0.852314 0.216817 0.724819 0.597427 1.273980 0.926620 0.643916 0.066061 0.625597 1.284699 0.657854 0.605911 1.653365 1.442076 1.033587 -0.542590 1.262635 1.257414 1.117301 0.126208 0.112501 1.272548 0.912632 0.005045 0.757226 0.049364 -0.033316 1.800311 -0.300949 0.310947 1.267820 0.529700 0.817110 -0.265053 1.152779 -0.048439 0.296709 1.270792 1.398568 -1.703554 0.050635 0.940556 0.440806 1.384526 0.885947 -0.609539 0.281434 0.391260 0.168064 1.027217 1.891400 0.923378)
     )

;;; 90 all -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.059710502625 (fv 0 0 1 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0)

	9.398614 (fv 0.000000 0.892706 1.062256 0.213835 0.203111 1.398668 1.054220 0.038528 1.142619 0.118583 0.457258 1.631677 1.573493 1.353053 0.245939 0.098142 1.245835 1.513894 0.025359 0.747716 0.843192 1.216875 0.015492 0.415459 0.312421 1.153905 1.780617 0.437612 -0.400304 -0.029367 1.378815 -0.215560 0.280582 1.233159 0.249478 0.201675 0.961263 0.048927 0.571980 0.265611 0.963409 1.336060 0.891681 1.142504 1.421083 1.162603 1.027272 0.851118 0.849549 0.034892 1.199036 0.308700 1.882141 0.734414 0.473371 1.758626 0.761172 0.952217 -0.108344 1.230664 0.088942 0.737287 0.280477 0.684695 1.865274 1.638095 0.534719 0.573717 0.414603 0.759210 0.580912 -0.293171 0.034364 1.872658 1.705405 0.725925 -0.286371 0.704217 0.268789 0.757724 0.268458 1.430890 1.325737 1.264595 0.335646 0.223092 0.572527 0.875084 0.723299 0.490792)
     )

;;; 91 all -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.130150794983 (fv 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0)

	9.460641 (fv 0.000000 0.436117 1.518395 1.686873 0.685584 1.390220 1.721023 1.218901 0.617875 0.942031 0.798753 1.787198 0.914695 1.067725 0.500698 1.164934 1.198775 0.318349 0.110243 1.683123 1.771564 0.104141 0.404057 1.512291 -0.053002 0.635555 0.485286 0.639133 1.522433 0.362468 1.841483 -0.018649 1.636664 1.891231 -0.092223 0.000560 1.591693 0.345850 0.362361 0.150153 0.525106 1.675920 1.376159 0.544954 1.155066 0.115196 0.924275 -0.119311 1.123186 0.422131 1.628623 0.610317 0.891460 1.679635 0.315850 0.345138 -0.095637 1.712298 -0.241584 0.926203 1.708802 0.312769 0.179387 0.288518 0.999840 0.990421 1.415220 1.453610 0.512219 1.890115 0.694941 1.068928 1.023842 0.497685 1.095073 1.132736 1.716879 -0.012368 0.180422 1.245447 0.380145 -0.172552 1.441547 0.152524 1.430740 1.014319 0.944154 0.113921 1.674916 -0.025585 0.846123)
     )

;;; 92 all -------------------------------------------------------------------------------- ; 9.5917
(vector 92 12.009957507951 (fv 0 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1)

	9.517966 (fv 0.000000 0.086823 0.747623 -0.085371 0.122456 -0.230268 0.119188 1.361402 1.167782 0.037384 1.047768 0.553092 0.649815 1.008382 0.794506 0.305054 1.023759 0.770450 1.886190 0.685208 0.379196 0.684576 0.589903 0.070635 1.842447 1.673609 -0.393612 0.098157 1.794112 0.846616 0.025307 0.910127 0.590170 1.608490 0.410052 1.692507 -0.369713 0.406231 1.469315 1.471065 0.951373 1.130104 0.531009 1.015991 1.488443 0.280351 0.460606 1.244663 1.053735 0.254819 0.300775 0.994290 1.059430 1.061070 1.049296 1.008564 -0.162768 1.637847 1.291833 1.037154 0.364051 0.144913 0.533100 1.075664 1.325409 -0.343880 0.931404 1.449787 0.745214 0.874779 -0.406152 1.757226 1.474675 0.453343 1.845066 0.544094 1.158828 0.100488 1.840683 0.221106 0.924537 1.893930 0.736114 1.402591 0.613840 0.057492 0.409601 -0.093628 1.271558 0.626825 0.949050 -0.217069)

	;; 93-1
	9.419885 (fv 0.000000 0.069529 0.633901 0.633608 0.570434 0.157518 1.715794 1.321616 1.084449 0.794466 0.425008 0.283514 -0.131990 1.646881 1.533838 1.442714 1.177599 1.239726 1.207883 1.015321 0.976921 1.262383 1.278818 1.276322 1.338824 1.226865 1.318320 1.361295 1.375488 -0.072989 0.149612 0.367026 0.181636 0.504697 0.851522 1.286853 1.425655 1.395838 0.306909 0.627046 0.973004 1.385102 1.455309 0.477354 0.684776 1.138509 1.548279 -0.072451 0.798558 1.262715 0.056514 0.791921 1.056616 1.695546 0.434938 1.116470 0.025573 0.789168 -0.006184 0.138467 1.335319 0.002519 1.259750 -0.081984 0.549375 1.443475 0.683161 1.338585 0.966058 1.876977 0.624731 1.787187 0.503447 1.917935 0.840074 -0.187662 1.042424 0.183738 1.737882 1.038721 -0.194530 1.214452 0.488651 0.014114 1.273532 1.004556 0.303820 1.746128 1.409399 0.765865 0.191028 1.596552)
     )

;;; 93 all -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.125471062226 (fv 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     9.668780 (fv 0.000000 1.502492 1.735960 1.811396 -0.104957 0.482636 0.500559 -0.183071 -0.047836 1.299077 0.116243 0.998697 1.692766 0.951722 0.883989 1.357273 1.702880 0.882694 1.095034 1.397512 0.329332 0.527364 0.298917 0.655212 0.187816 0.424294 1.150209 0.114579 0.252718 -0.217705 0.508106 -0.043801 0.270810 1.167969 0.982839 0.517943 0.010809 1.845815 1.098777 0.567160 0.419087 1.030585 1.503183 1.837046 1.638737 1.381290 1.657079 1.137100 1.564675 -0.040237 0.809480 0.832346 1.587671 -0.164235 1.557353 -0.318789 1.412269 1.419735 0.213834 0.923183 0.158106 0.606199 0.283874 -0.361272 1.495430 1.475886 0.334771 1.534489 0.873427 -0.175602 1.422400 0.168157 0.667278 1.332909 0.520912 0.514379 1.506377 1.240021 1.795506 1.354822 0.149370 0.097693 1.231885 1.499794 1.191816 0.402471 1.807112 1.364329 0.383172 1.438070 0.658534 1.737005 0.518886)

     ;; pp:
     9.412639 (fv 0.000000 0.102641 0.679230 0.798388 0.598526 0.445036 1.682481 1.416478 1.010866 0.838753 0.518866 0.185140 -0.260801 1.643327 1.645133 1.587871 1.510095 1.367190 1.252764 1.075109 0.997402 1.226792 1.097666 1.109286 1.266675 1.142806 1.396415 1.366757 1.323435 -0.151657 0.110933 0.254314 0.125232 0.426419 0.874355 1.227943 1.386454 1.437438 0.183960 0.673205 0.896736 1.317085 1.421345 0.557215 0.650544 0.979705 1.599286 -0.027664 0.967924 1.389243 -0.027060 0.800953 1.098758 1.686133 0.493843 1.257456 0.105617 0.800125 0.006765 0.139250 1.353019 -0.059007 1.198209 0.066444 0.431719 1.470864 0.547882 1.294688 0.757592 1.690943 0.714913 1.735237 0.542409 1.804533 0.779629 -0.296056 1.090213 0.178123 1.832019 1.000948 -0.131923 1.161644 0.360890 0.065736 1.232224 0.792139 0.176636 1.688866 1.432871 0.734257 0.042563 1.592538 0.764029)
     )

;;; 94 all -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.510846178591 (fv 0 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0)

	9.614457 (fv 0.000000 0.354827 0.986082 0.678218 0.074619 1.069713 1.084979 -0.010872 1.376391 1.050934 0.019873 0.645649 0.930266 1.023286 -0.324271 0.129791 1.399266 0.790347 1.024795 0.364675 1.268057 0.467841 0.596106 0.634764 0.920301 0.577212 1.246648 0.805833 -0.021659 -0.091918 0.865047 0.408442 1.292571 1.382486 -0.396633 1.688655 0.645075 1.689205 0.543001 -0.020503 1.556121 1.527556 1.671083 1.274725 1.683665 1.385648 1.434218 0.579921 1.533529 0.946387 1.280342 1.067943 -0.140266 0.061709 0.145137 0.716787 0.346453 1.817745 0.110851 1.072741 1.054881 1.191219 0.552352 1.218769 1.077324 -0.052815 -0.201076 1.253349 1.375788 0.845621 0.366991 0.916267 0.628985 1.420824 1.381120 0.247768 0.913794 -0.038130 1.360273 -0.162096 1.251116 1.166185 0.322598 1.024569 1.763375 0.466730 1.066807 0.067495 0.545386 1.308131 1.358919 0.937638 0.693078 0.195493)

	;; 93+1
	9.543681 #(0.000000 0.070784 0.635867 0.742637 0.475019 0.302813 1.825409 1.378229 1.077426 0.877718 0.610301 0.202771 -0.182277 1.673466 1.553357 1.494058 1.368050 1.336285 1.249015 1.094284 1.026782 1.245912 1.085605 1.018283 1.167850 1.013374 1.392524 1.418879 1.281568 -0.274841 -0.022454 0.129657 0.125509 0.504384 0.935744 1.276977 1.483975 1.477426 0.196761 0.675603 0.862408 1.192185 1.459380 0.549610 0.569998 1.001464 1.695499 0.066362 0.898853 1.281654 0.050116 0.806388 1.047653 1.730201 0.520253 1.351614 0.000078 1.010541 -0.167505 0.168460 1.307105 0.008313 1.198293 0.190292 0.394166 1.604739 0.575546 1.381303 0.832277 1.821709 0.813449 1.752392 0.618919 0.026374 0.880532 -0.283635 1.155422 0.216026 1.884068 1.144874 -0.171918 1.125849 0.302834 -0.082892 1.104687 0.762677 0.111766 1.593198 1.158618 0.738387 -0.017688 1.548369 0.670450 -0.209765)
     )

;;; 95 all -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.431831359863 (fv 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

	9.594917 (fv 0.000000 1.389542 1.176101 1.128189 0.857825 0.606938 0.053944 1.193702 0.869053 0.060247 1.681618 -0.018030 0.093189 1.777775 1.314304 1.617940 0.848617 -0.108633 0.918764 1.157666 0.455570 1.631612 1.168101 0.785976 0.402697 1.470789 1.252874 0.702336 1.782377 1.673658 1.631189 1.349352 1.050241 0.712255 1.786745 0.232201 0.625268 1.043139 1.455512 1.195110 0.998337 0.283110 0.709026 0.841439 0.900171 1.560899 0.398341 0.605576 1.226269 0.101415 0.662630 -0.080073 0.123777 0.243381 0.746050 1.688701 0.805710 -0.417799 1.076341 1.138430 0.020724 1.738280 0.026371 0.359523 1.207908 0.092412 0.589896 1.141872 0.833369 1.211938 0.834700 0.366724 0.985159 0.093930 1.781990 0.844009 1.324575 1.222996 -0.119995 1.044915 0.191275 1.202233 0.891410 1.663012 1.114750 1.562345 -0.205599 1.605273 0.019367 1.356810 0.858474 1.006151 -0.416772 0.195895 1.774084)
     )

;;; 96 all -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.586637130548 (fv 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 1 1)

	9.698754 (fv 0.000000 1.686945 0.467972 0.353719 0.039839 1.529803 1.113587 1.518769 0.069518 0.641616 0.744046 1.828910 0.013471 -0.229934 0.181085 -0.011815 0.130449 1.033538 1.435542 1.445735 1.524439 1.088117 0.632800 0.518998 -0.093855 1.447748 -0.258898 0.540666 0.708408 1.141240 0.388952 0.533151 0.107615 0.843908 1.797589 1.037747 1.105446 0.651000 0.775586 -0.512743 0.563193 0.707947 1.740714 1.753866 0.373300 1.459832 0.879332 1.133261 0.035182 1.481640 1.284446 0.744828 1.229402 -0.449568 1.081113 -0.235470 0.939023 1.698241 1.413068 -0.279150 0.681300 1.084041 -0.075079 0.087600 0.709157 -0.062761 0.870661 0.903931 0.019006 1.008038 -0.009901 1.442216 1.097881 0.558710 1.835109 1.151033 1.232982 1.137424 0.991349 -0.312466 0.156001 0.908045 0.922926 1.582365 1.057816 0.119723 1.368068 0.167350 -0.363438 0.279779 0.391520 0.751632 -0.048111 1.271729 1.046123 1.547668)
     )

;;; 97 all -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.585 (fv 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)
     
	9.811290 (fv 0.000000 1.599348 0.923331 0.142353 1.275817 1.382624 1.510378 0.732924 0.806532 1.015499 0.620826 1.882699 1.212790 0.807183 -0.023255 1.516389 1.732605 -0.201884 -0.277404 -0.055883 0.240940 0.731931 1.673522 0.086425 1.587574 0.602365 1.160815 1.229056 1.456929 0.833735 0.852700 0.201630 1.357627 0.458255 0.370269 1.445354 0.215612 1.445930 1.140683 1.395090 0.893305 1.761792 0.069580 1.477150 1.261329 0.799176 -0.171506 -0.046281 0.037534 0.945505 0.457403 -0.446133 -0.016772 1.686139 0.929506 1.761163 1.283945 0.714187 0.030687 1.699690 1.935312 -0.149630 1.586492 0.783961 1.445990 1.058255 1.383027 0.027818 1.949317 0.450708 0.615659 0.863171 1.311974 0.506328 0.888408 1.633309 0.234089 1.362300 1.207491 0.660429 0.454914 0.801172 1.438508 0.392994 1.045451 0.178268 0.808166 0.169353 0.379391 0.545139 1.796419 0.579129 1.221213 0.829753 -0.091400 0.706540 1.245414)

     ;; pp:
	9.860243 (fv 0.000000 0.680977 0.966253 1.634215 0.365093 0.771173 1.259550 0.007495 0.693755 1.428280 0.352398 1.032784 1.549276 0.384182 1.088250 1.711305 0.715748 1.441436 0.402491 1.285065 0.056701 0.943326 1.812606 1.043581 -0.072780 0.808810 1.940683 1.225707 -0.029466 1.139541 0.383446 1.652614 0.799608 1.845091 0.834727 0.161218 1.415263 0.601512 1.879909 1.404443 0.587018 1.806810 1.169986 0.643827 -0.082912 1.345651 0.782502 0.239840 1.583476 1.376880 0.682406 0.262024 1.847899 1.521309 1.138292 0.467250 0.281908 -0.070976 1.718683 1.523340 1.285749 0.765922 0.681731 0.268165 0.290564 0.046020 0.082000 1.791305 1.766394 1.373062 1.769852 1.419717 1.707739 1.313906 1.401690 1.527792 1.718640 1.280023 1.582817 1.850590 0.103668 0.041251 0.363022 0.586729 0.741602 0.886403 0.989519 1.522393 1.709847 0.193187 0.406948 0.736802 1.329603 1.619101 -0.034816 0.612167 1.088037)

     ;; 96+1
     10.697 (fv 0.000000 1.686945 0.467972 0.353719 0.039839 1.529803 1.113587 1.518769 0.069518 0.641616 0.744046 1.828910 0.013471 -0.229934 0.181085 -0.011815 0.130449 1.033538 1.435542 1.445735 1.524439 1.088117 0.632800 0.518998 -0.093855 1.447748 -0.258898 0.540666 0.708408 1.141240 0.388952 0.533151 0.107615 0.843908 1.797589 1.037747 1.105446 0.651000 0.775586 -0.512743 0.563193 0.707947 1.740714 1.753866 0.373300 1.459832 0.879332 1.133261 0.035182 1.481640 1.284446 0.744828 1.229402 -0.449568 1.081113 -0.235470 0.939023 1.698241 1.413068 -0.279150 0.681300 1.084041 -0.075079 0.087600 0.709157 -0.062761 0.870661 0.903931 0.019006 1.008038 -0.009901 1.442216 1.097881 0.558710 1.835109 1.151033 1.232982 1.137424 0.991349 -0.312466 0.156001 0.908045 0.922926 1.582365 1.057816 0.119723 1.368068 0.167350 -0.363438 0.279779 0.391520 0.751632 -0.048111 1.271729 1.046123 1.547668 0.0)

     ;; 98-1
     9.733625 #(0.000000 -0.316389 0.763514 1.085136 -0.007054 1.613164 0.368355 0.497362 0.266819 0.792626 1.605095 0.379462 0.795808 0.617439 0.340832 1.408797 0.884588 0.777692 -0.061819 1.329857 1.611199 0.024913 1.778069 1.061965 1.317076 1.286538 -0.063928 0.439816 1.190286 1.720423 -0.281159 0.284236 1.261293 1.715607 1.258044 1.027201 0.992940 1.404704 0.918469 0.571955 0.670954 -0.578424 1.681045 1.759567 -0.365702 0.685884 0.480691 0.685380 0.103522 0.029224 1.512644 0.122325 0.600548 0.070986 0.493468 0.652824 -0.059890 1.290005 1.370566 0.135509 0.143591 -0.197126 0.478025 0.315521 0.839450 0.083388 0.553358 1.161959 0.770340 1.132488 0.641596 1.702281 0.277494 1.930557 0.772636 0.175945 1.352904 0.123527 1.448091 0.194310 0.330488 1.631688 1.302741 0.566332 1.521760 0.740046 0.257004 1.532435 0.681554 0.238673 0.612205 0.128510 1.851063 0.280067 1.237302 -0.034034 0.240185)
     )

;;; 98 all -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.724907890996 (fv 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1)

	9.767029 (fv 0.000000 -0.188323 0.675144 1.162326 -0.152620 1.669640 0.370125 0.494628 0.190555 0.715197 1.719005 0.377693 1.013961 0.545798 0.345914 1.535759 0.968261 0.937780 -0.119329 1.630311 1.635898 0.029531 1.850111 1.208612 1.298337 1.226547 0.020306 0.388794 1.210462 1.649716 -0.158605 0.268380 1.285081 1.672163 1.145021 0.908520 1.140268 1.468740 0.844848 0.440912 0.760836 -0.415872 1.889804 1.724959 -0.229249 0.766901 0.564605 0.613211 0.221081 -0.012880 1.521722 -0.044019 0.593078 0.034669 0.491432 0.559669 -0.045684 1.255880 1.344088 0.070215 0.282883 -0.229690 0.625053 0.504422 0.811212 -0.012186 0.589513 1.241057 0.831526 1.215774 0.684110 1.651422 0.305036 1.891476 0.747710 0.040696 1.539490 0.154881 1.456564 0.357589 0.123799 1.523900 1.179657 0.504889 1.418226 0.850462 0.009923 1.481216 0.600938 0.216302 0.543002 0.255145 1.787452 0.279328 1.172852 -0.085076 0.199219 1.196556)
     )

;;; 99 all -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.002375571256 (fv 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0)

	9.856524 (fv 0.000000 0.532142 1.131528 0.051928 1.654946 0.271228 1.101349 1.560647 1.619023 1.108572 0.726033 0.727251 -0.132854 0.360041 0.670224 1.663602 -0.493942 -0.197685 1.604359 1.799803 1.040897 0.122580 0.382051 1.681979 0.430500 1.558581 0.044836 1.543992 1.439831 0.906809 1.334494 1.667502 1.130520 0.467062 1.310080 0.675817 0.797910 0.443927 1.274100 0.336343 0.146059 -0.192316 0.742563 0.471697 1.596436 -0.009686 1.651640 1.837904 0.406037 0.558091 -0.016989 1.479179 0.903735 1.116299 -0.060825 0.179513 -0.026846 1.811414 0.072416 -0.014783 0.060148 0.361427 1.207468 0.945662 0.068194 1.516887 0.004488 0.212016 0.737847 -0.343051 0.746533 0.527238 1.812564 0.462282 1.376985 0.882738 1.070840 1.718397 0.663551 0.922534 1.724192 -0.576637 1.416748 1.206588 0.385428 0.383601 1.504489 1.636715 0.253055 1.809058 0.862228 1.855156 1.029803 0.604391 1.515278 0.827373 1.237016 1.652558 1.330582)
     )

;;; 100 all -------------------------------------------------------------------------------- ; 10
(vector 100 12.998435541498 (fv 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 0 0)

	9.934540 (fv 0.000000 -0.003002 1.124858 1.923310 1.313585 0.903273 0.269057 1.550768 -0.053877 1.309350 0.259003 0.111356 1.649851 -0.475532 0.829676 0.358899 1.751244 0.579333 0.816025 0.729724 0.670859 0.992375 1.547721 -0.006147 1.191599 -0.084864 -0.001041 0.113001 0.580223 -0.405864 1.746923 1.268810 1.705215 1.056469 -0.197189 1.293674 0.934396 0.701720 0.582761 1.455750 1.232104 0.066182 1.464245 1.672004 0.239530 1.711330 -0.092878 0.399845 1.787310 0.046607 0.724822 1.735381 1.288901 0.460956 0.591963 0.996187 1.917259 0.311027 0.319804 1.898631 1.336795 0.632408 0.203462 1.031863 1.346167 0.931351 0.938341 -0.021240 0.003608 0.259606 1.507194 1.470684 0.324860 1.386425 0.298636 1.353945 1.922770 1.226486 0.467967 1.127400 0.946778 1.636808 0.285401 1.555027 1.572734 1.271086 1.042408 1.022431 1.651957 1.039348 0.338431 0.852870 0.945331 1.308135 1.631151 1.286426 0.091020 0.620928 0.894381 1.712980)
      )

;;; 101 all -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.219774246216 (fv 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0)

      ;; pp.scm: 
	9.969423 (fv 0.000000 0.594013 1.021081 1.737097 -0.040619 0.752674 1.481517 0.041655 0.616216 1.273976 -0.239494 0.706555 1.350693 0.121717 0.873486 1.615554 0.502899 0.859104 0.100209 1.240389 0.001564 0.940100 -0.110501 0.399212 1.639677 0.823186 1.849867 0.970964 1.815596 0.977295 1.876945 1.029064 0.250663 1.106062 0.440754 1.692440 0.937531 0.143047 1.343876 0.363444 1.897361 0.954251 0.489534 1.687124 1.352147 0.540407 -0.261830 1.349441 0.704373 0.447495 1.734922 1.090380 0.653989 0.307022 1.449780 1.794904 0.808626 0.497093 0.423383 -0.280469 1.640122 1.217125 1.143712 0.677390 0.472908 0.243924 0.123084 -0.178887 1.588534 1.317289 1.403860 1.454850 1.459048 1.165832 1.237401 1.000847 1.421104 1.051039 1.364625 1.447050 1.541757 1.176845 1.530906 1.723380 1.795645 0.095341 0.481918 0.307978 0.454615 1.009308 0.963604 1.200422 1.757436 -0.015019 0.420112 1.020994 1.127410 1.866034 -0.291409 0.497289 1.096855)
      )

;;; 102 all -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.194128990173 (fv 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 0)

      10.088316 (fv 0.000000 0.095626 0.514266 0.420449 0.749499 0.992394 -0.193393 0.039052 0.057117 1.575374 1.352773 1.322452 0.794003 0.750383 0.756593 0.273089 1.675537 0.407815 0.550801 -0.538502 0.957909 1.336960 1.614983 0.508708 1.910222 1.874209 0.940387 0.222605 0.538045 1.356000 1.741919 0.598382 1.550605 1.131133 0.773140 -0.232481 0.055269 1.822145 0.659426 -0.100655 1.261624 0.557410 0.214081 0.588453 0.458097 0.577319 1.055339 1.792023 0.525700 0.097434 0.222735 0.356704 1.885210 0.037676 0.938171 0.984298 1.949046 1.455206 0.941409 1.068679 0.637889 0.330852 0.138031 1.619860 0.674126 -0.251106 1.183963 1.959835 0.213213 0.066073 0.132459 0.329261 0.847485 0.503486 0.122913 0.684764 1.979054 0.659531 0.231782 1.341252 0.124898 0.707447 -0.419234 0.913042 1.413830 0.741236 1.664719 1.833486 -0.410776 0.347702 1.045974 -0.368342 0.123701 1.012180 1.052039 1.226053 0.364036 1.015550 1.423284 1.022491 0.770674 1.877516)

      ;; pp:
      10.025038 (fv 0.000000 0.605553 0.983049 1.667341 0.280594 0.813730 1.347579 0.067151 0.773566 1.170135 -0.000437 0.776577 1.339736 0.097477 0.851330 1.565309 0.392180 1.136191 -0.027326 0.943192 1.737718 0.813011 1.699444 0.599876 1.617440 0.776150 1.855177 0.961431 1.915827 0.882986 1.666203 0.596064 -0.104064 1.326950 0.560052 1.687567 0.667080 1.807593 1.118197 0.382149 1.651756 0.780071 0.152645 1.439416 0.767927 0.282152 1.693680 1.210781 0.759553 0.009785 1.134002 0.817236 0.333315 0.071267 1.596603 1.242164 0.957402 0.421360 -0.130961 1.394848 1.288611 0.865712 0.865151 0.398958 0.298422 -0.229411 1.889300 1.384404 1.672436 1.144983 1.294122 0.887806 0.874167 0.414036 1.058747 0.759420 0.922388 0.730377 0.900207 0.658168 0.691340 0.678324 0.551776 0.884009 1.344859 1.136367 1.415423 1.606731 1.827838 -0.020510 0.115669 0.332208 0.674134 1.028023 1.276947 1.696675 0.283199 0.564387 1.040113 1.365277 -0.292333 0.240887)
      )

;;; 103 all -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.435972213745 (fv 0 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 0 1)

	10.072606 (fv 0.000000 0.775992 0.789071 0.551328 0.298530 -0.168268 0.810417 1.541024 0.478641 0.826848 0.407673 0.769783 0.052469 0.071330 0.252339 -0.003477 1.565238 1.042251 1.681717 0.063581 0.058867 1.442741 0.917343 1.448313 1.294486 -0.061724 0.478951 1.132882 1.128620 1.082449 0.123678 0.578486 1.003285 0.918654 0.241363 0.278868 -0.414912 1.418211 0.927244 1.134797 0.489863 -0.664481 0.529310 0.940119 1.393533 0.416277 0.044802 1.197865 0.283028 1.514978 1.590639 1.159829 1.236485 1.237279 0.109313 1.090962 1.341243 0.602478 1.179629 0.285726 1.482652 0.648833 1.308230 1.743441 1.346535 0.727031 0.061582 0.907076 -0.185896 1.479865 0.775766 1.389852 -0.161651 1.518832 0.594834 0.022777 -0.099476 0.851631 0.289254 1.413652 0.958286 -0.309988 0.125895 0.222920 0.633318 0.584266 0.503924 0.660246 1.182087 1.319466 1.213616 1.220516 0.662413 1.589230 0.875855 1.466144 0.036061 0.139801 0.986962 0.226038 0.202950 0.978447 0.999923)
      )

;;; 104 all -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.330215043333 (fv 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0)

	10.124244 (fv 0.000000 1.622675 1.706946 0.969141 1.395974 1.097698 0.150298 1.207570 1.449278 0.836769 1.526696 -0.147627 1.089028 1.314193 0.833408 0.265551 0.958522 0.397626 0.447242 0.837858 1.676927 0.883730 1.604731 0.779720 0.388122 0.713835 1.704244 0.052983 0.837107 0.054588 0.549459 0.093126 1.768139 0.144405 0.937970 0.532416 -0.149569 1.622840 1.586484 0.686471 0.830291 0.095651 0.908595 0.259853 -0.301519 0.855324 -0.014912 0.748872 1.538644 -0.030037 0.020462 0.792578 0.531283 0.625746 0.346250 0.434570 0.703831 1.586850 1.489275 1.435865 0.300417 1.125540 0.355002 0.123270 0.728375 0.039493 1.718698 1.307117 0.118823 0.358408 0.405752 1.413026 1.454448 0.630369 0.900592 1.792896 1.090807 1.061221 1.814531 1.630768 0.510555 0.618481 1.214968 0.122072 0.455822 1.727623 0.073245 -0.177442 0.329678 1.542732 1.673278 -0.469931 -0.007785 0.142142 0.231493 0.623628 0.711468 0.673585 0.185009 1.333716 0.659875 0.472080 1.635059 0.745116)
      )

;;; 105 all -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.595993876506 (fv 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 1 0)

	10.169606 (fv 0.000000 0.591462 0.235800 1.321672 1.356594 -0.405542 0.538022 0.615762 0.326243 1.062550 -0.153260 -0.031444 1.233243 1.770308 1.085997 1.514420 0.095655 1.000755 -0.065552 -0.053493 1.481942 0.777394 0.483679 1.419470 0.159850 -0.259703 0.126983 0.478035 1.178492 1.111834 1.075738 1.268063 0.962249 1.943997 1.083333 1.538989 0.307093 1.387414 1.941208 1.284189 -0.012780 1.356158 1.317824 1.095171 0.472030 0.459214 1.096373 0.477967 0.565821 1.566421 0.590639 1.381435 1.150189 0.197776 0.315906 0.587160 0.629501 0.853485 0.797405 -0.187739 1.489470 1.296970 0.273664 0.102171 1.749652 1.601370 1.902817 1.658081 0.403983 0.138955 1.356476 1.693746 1.125750 0.916183 1.246086 0.386904 -0.248158 0.148664 0.070783 0.819794 -0.019914 0.547099 0.323707 -0.046514 1.635194 0.435105 0.156523 0.390396 -0.277746 0.665321 0.200546 1.082837 1.059380 -0.041536 0.592565 0.634526 1.116414 0.039718 0.575393 -0.178156 1.655927 0.370318 0.615340 1.693958 1.282592)
      )

;;; 106 all -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.200031373463 (fv 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

	10.233770 (fv 0.000000 0.055119 -0.050942 1.221658 1.069634 0.969833 -0.120088 0.537260 0.774846 1.097793 1.607343 1.125046 1.248849 0.110938 0.000911 -0.176700 1.224234 0.974172 0.258380 0.044520 0.328839 0.706861 1.491508 0.262253 0.850888 0.129635 0.528138 0.085967 1.206179 1.203105 -0.212392 0.552998 1.277370 0.069273 1.300991 0.395491 0.052184 1.017350 -0.139116 0.060719 1.223876 0.765705 1.643712 0.809882 1.480192 -0.160266 1.133315 0.396498 1.706614 0.389700 1.530945 1.033706 0.669577 0.953867 0.549025 0.735362 1.230749 1.732990 0.576594 1.599366 0.250495 1.206074 1.016404 1.623424 1.318513 0.223760 1.354914 1.140942 0.138240 0.414002 0.134404 1.756706 -0.015032 -0.196090 0.317193 0.119056 -0.492220 1.081019 0.025882 -0.092539 1.764132 1.357709 0.458311 1.060374 1.019483 -0.126097 0.259596 0.137076 0.020444 0.418031 0.040745 0.523959 1.133024 0.593829 1.429205 1.802013 0.365195 0.248492 1.498863 -0.344913 0.359725 1.657142 1.374238 1.289802 -0.217105 1.333949)
      )

;;; 107 all -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.224366750161 (fv 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      10.273899 (fv 0.000000 1.285870 0.722685 1.695642 1.789973 0.495199 0.001511 0.648393 1.565696 0.756830 0.421656 -0.184836 0.187469 1.381401 1.501800 0.551266 1.079110 0.129360 0.283265 1.059394 -0.217105 1.758613 1.156467 0.305791 0.018881 1.709795 1.386465 1.716357 0.543922 -0.077767 0.376814 1.917356 1.703183 0.375846 1.314995 1.049255 -0.015490 1.182770 0.105614 1.125738 1.580574 0.196175 0.043631 0.176951 1.523484 1.504279 0.024743 0.233174 0.051990 0.885176 0.485127 0.978870 1.366279 1.841166 1.225239 0.599047 0.937430 1.422432 0.950869 1.195765 0.360876 1.187450 1.491233 0.274262 0.123358 1.276789 1.498182 1.151090 1.495794 1.385360 0.511524 1.320969 1.040843 1.323508 0.526850 1.486006 0.358172 -0.084804 0.784722 0.263761 0.033435 1.669885 0.179635 1.097636 0.771172 0.674320 0.095788 1.426496 1.763465 0.078301 1.972016 1.520526 1.431005 0.272982 0.550020 1.118797 -0.453975 1.686563 1.286924 1.481496 1.458102 0.550556 0.115818 1.002355 0.493193 0.718245 1.621218)
      )

;;; 108 all -------------------------------------------------------------------------------- ; 10.3923
(vector 108  13.534 (fv 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1)

	10.312988 (fv 0.000000 1.293654 0.754043 1.806542 1.109001 0.766775 1.436021 1.627340 0.528605 1.806494 1.181378 0.013554 0.353388 0.092480 0.431618 0.200495 0.904126 0.741464 0.675051 -0.110957 1.146773 1.810641 0.552983 0.275055 0.835876 1.123930 -0.182193 -0.339155 0.645146 0.163632 0.868047 1.269556 0.830686 1.219557 1.665806 1.060039 1.944315 -0.011848 0.365415 0.718256 0.624511 1.571990 0.113371 0.572031 1.797961 0.876379 0.068642 0.072119 0.553161 0.329387 0.545574 0.337595 1.647194 1.034042 0.468339 1.774314 0.240404 1.846502 1.142528 1.223731 0.832499 0.428931 0.643890 1.257704 1.085969 0.643637 0.429070 0.971966 0.109095 0.689833 0.417898 1.804672 1.346983 0.150026 0.404292 0.575881 1.441149 0.533070 -0.177095 0.298641 0.921545 1.086883 0.410704 0.849120 1.518187 1.874571 0.517824 1.242109 -0.053714 0.834159 0.276990 1.956354 1.765190 1.537622 1.530954 -0.106766 1.325278 -0.071959 1.045056 0.533410 0.699958 0.068418 0.070057 1.204618 1.620552 1.072110 1.372120 0.848823)
      )

;;; 109 all -------------------------------------------------------------------------------- ; 10.440306508911
(vector 109 13.496821304096 (fv 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

	10.432370 (fv 0.000000 0.222737 0.395964 0.267704 0.984627 0.196896 1.257313 -0.049947 0.063508 1.503629 1.207170 0.259470 1.634989 1.732463 0.102120 1.779072 -0.448069 1.030982 -0.170238 0.241134 1.050790 1.545206 1.217799 1.632326 -0.260618 1.981321 1.563052 0.646224 0.963725 1.195450 1.382468 0.912278 -0.055446 -0.043084 1.544497 1.444807 0.819657 0.741044 0.122396 1.518758 -0.047192 1.432176 0.150062 1.445372 1.689041 1.538858 1.607305 0.672865 0.037321 1.002894 0.706157 0.845104 0.402627 1.438914 1.038104 1.050343 0.380185 1.252881 -0.144926 -0.130041 -0.022885 1.740880 1.268140 -0.038596 0.221618 0.937959 1.603605 0.465293 -0.010315 0.708519 1.255289 0.623840 0.892628 0.632806 0.245713 1.831669 -0.020202 0.561348 0.735902 1.121505 0.850852 0.147905 1.162108 1.085140 0.352699 1.043580 0.226572 1.785966 0.379633 0.873437 1.384309 1.785370 1.080206 1.256403 1.169325 0.672865 1.444061 0.325194 0.278183 1.165719 -0.193709 1.182201 0.138301 0.079081 1.231522 0.798589 -0.014107 0.372822 1.050722)
      ;; [checked]

      ;; pp:
      10.450104 (fv 0.000000 0.623079 1.000690 1.676565 0.329793 0.812365 1.369654 0.033036 0.636775 1.205357 1.818620 0.518482 1.271099 -0.006177 0.798686 1.518819 0.365150 1.120280 1.863547 0.825398 1.655423 0.561458 1.434421 0.357234 1.260951 0.112744 1.108421 0.195312 1.204468 0.187317 1.151003 0.344529 1.318670 0.493356 1.634474 0.713838 1.719668 0.894392 0.187447 1.393869 0.631586 1.857642 1.152308 0.558736 1.895158 0.937863 0.284606 1.593849 1.131320 0.496395 1.862604 1.450055 1.017002 0.269052 1.590119 1.223313 0.766679 0.191870 1.793336 1.442714 0.950223 0.613488 0.158729 1.978172 1.504759 1.404948 0.934115 0.506811 0.307861 0.053560 0.056210 1.784308 1.658677 1.460879 1.312182 1.175464 0.793270 0.871641 0.543638 0.736870 0.773799 0.716297 0.645633 0.912396 0.319672 0.772867 0.727345 0.920587 0.879052 1.066787 1.359741 1.428609 1.742928 0.019718 0.299864 0.439508 0.461036 0.748673 0.838321 1.439140 1.960382 0.367463 0.781933 1.129021 1.394803 1.904930 0.281191 0.715525 1.133222)

      ;; ppe:
      10.470162 (fv 0.000000 0.451543 0.456061 0.147873 0.922547 -0.015839 1.326621 0.024116 -0.214919 1.809411 1.260411 -0.041222 1.497661 1.558073 1.813230 1.792964 -0.178738 0.909655 0.169254 0.063699 1.161084 1.372145 1.379335 1.141902 -0.228933 1.774907 1.529928 0.313058 1.032527 0.848013 1.268723 1.218902 1.606823 -0.185860 1.765043 1.039756 0.745126 0.269721 0.154169 1.685147 -0.249171 1.208381 0.488385 1.400686 1.729831 1.462720 1.767018 0.760244 0.226518 1.299640 0.590535 1.231728 0.337540 1.363389 1.096692 0.848743 0.528317 1.290759 1.823255 0.006608 0.050582 1.737871 1.377769 0.292561 0.372415 1.032383 1.772564 0.594274 1.989312 0.990074 1.229632 0.208396 0.695371 0.886409 0.070239 1.725783 -0.164935 0.277786 0.838920 1.005114 0.874184 0.343822 0.665942 0.650106 0.585298 0.979509 -0.150741 1.631833 0.286195 1.077553 1.249512 1.979846 1.138840 1.144065 1.361495 0.626673 1.081435 -0.100313 0.333711 1.298242 -0.025467 1.240351 0.507433 -0.065459 1.581161 0.747520 -0.025829 0.466153 1.514665)

      ;; 108+1
      10.465794 (fv 0.000000 1.261306 0.756049 1.734970 1.113101 0.805084 1.457596 1.637772 0.628008 1.784965 1.333315 0.036717 0.439219 0.033125 0.381710 0.269020 0.985810 0.678378 0.680639 -0.069482 1.115894 1.817011 0.519918 0.285224 0.835122 1.113406 -0.261265 -0.330615 0.618667 0.163360 0.903941 1.236351 0.757259 1.163348 1.621167 0.968436 0.026565 -0.066554 0.378589 0.687577 0.660616 1.711770 0.119195 0.615047 1.770806 0.845402 0.120718 0.054234 0.617881 0.325825 0.593967 0.187896 1.693425 0.956676 0.477627 1.731647 0.243338 1.808776 1.129711 1.197676 0.882419 0.440875 0.675531 1.292191 1.036684 0.711702 0.335908 0.955565 0.021456 0.617399 0.422697 1.713551 1.321273 0.184516 0.367908 0.680377 1.411086 0.613080 -0.220212 0.303290 0.946718 1.032493 0.379598 0.964256 1.450291 1.925352 0.458370 1.308007 0.052883 0.804371 0.142157 1.962522 1.725428 1.534486 1.590912 -0.162909 1.368778 0.018483 1.040371 0.500375 0.666432 0.075487 0.004040 1.244623 1.616034 1.047362 1.367582 0.880576 0.183628)
      10.457243 #(0.000000 1.269530 0.760051 1.729694 1.122945 0.814880 1.466156 1.631086 0.616903 1.786832 1.344985 0.030797 0.418832 0.037877 0.373313 0.275814 0.977767 0.677872 0.673791 -0.065296 1.118192 1.826436 0.508528 0.285632 0.821565 1.103219 -0.267070 -0.330900 0.618539 0.170243 0.892990 1.223460 0.764058 1.162302 1.620423 0.957344 0.023461 -0.059770 0.381474 0.692706 0.660066 1.703495 0.098695 0.624314 1.751336 0.844891 0.120502 0.057294 0.621996 0.319901 0.586587 0.186646 1.685806 0.974557 0.474304 1.735548 0.234787 1.810600 1.138824 1.194376 0.872559 0.435412 0.677166 1.290849 1.011702 0.701077 0.322755 0.950082 0.024752 0.607227 0.415633 1.702576 1.323090 0.195261 0.365091 0.675664 1.408251 0.606997 -0.208324 0.308915 0.941088 1.034722 0.364193 0.967725 1.444390 1.941283 0.456248 1.293589 0.032476 0.805832 0.141117 1.965347 1.709815 1.528055 1.586120 -0.152788 1.361484 0.019126 1.044770 0.500796 0.670659 0.067435 -0.009310 1.226198 1.603811 1.046583 1.365223 0.883194 0.193296)

      ;; 110-1
      10.492353 #(0.000000 0.649552 1.258961 1.798629 0.295231 1.075711 1.347920 0.121939 0.696224 1.281983 0.032578 0.645849 1.470760 0.132728 0.955394 1.648364 0.383034 1.123713 -0.064684 0.680548 1.508113 0.522861 1.543240 0.469943 1.284137 0.126108 1.118789 0.070241 1.171737 0.220713 1.266632 0.237433 1.369206 0.567892 1.805775 0.867265 -0.062627 0.893879 -0.087752 1.076524 0.559461 1.862957 0.962056 0.188688 1.451315 0.983828 0.133042 1.313939 0.730889 0.050895 1.529895 0.938894 0.423548 0.095610 1.537293 1.023433 0.444439 -0.186915 1.341179 0.897889 0.710453 0.205134 1.764281 1.664728 1.194191 1.219211 0.487735 0.001583 -0.174056 1.514286 1.446037 1.405131 0.911342 1.053534 0.611360 0.869991 0.316542 0.552502 0.074120 -0.135311 -0.066680 -0.002337 0.020716 0.190932 0.118203 -0.035296 0.053844 0.171497 0.280257 0.364496 0.317771 0.545933 0.941741 1.154776 1.374846 1.696829 0.032376 -0.123909 0.208717 0.498527 0.977224 1.512919 1.615840 0.075043 0.681676 1.197206 1.497188 -0.041928 0.148595)
      )

;;; 110 all -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.592092514038 (fv 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 1)

      10.443826 (fv 0.000000 0.966857 -0.310939 0.754018 -0.215289 0.050408 1.345912 1.407669 0.917300 1.537339 0.464664 1.377382 -0.129707 1.562018 0.873176 0.378480 1.188634 1.002593 1.467403 -0.157591 0.611052 1.240086 1.200021 0.642960 0.011727 1.278266 0.757206 1.221576 1.173971 1.148607 0.352945 0.591698 0.569729 0.204560 1.805523 0.091751 0.494475 0.741755 1.173490 0.125853 1.836232 0.189233 1.047389 0.359034 0.299905 1.335669 1.331935 0.866342 1.429328 0.175988 0.321575 0.808716 0.418347 0.305766 0.587213 0.859103 1.233827 1.612185 0.649515 1.232962 0.438531 1.088539 1.160206 1.276056 0.991705 0.605889 1.920272 1.294151 0.591700 0.477186 -0.114311 0.103729 0.053546 1.057780 1.113226 0.935069 0.869987 0.585069 1.193799 0.314064 1.564843 1.009796 1.434593 -0.061294 0.394207 1.540076 0.463315 1.070060 1.005570 -0.247697 1.209164 0.032912 1.882456 0.617912 -0.419949 0.119714 0.033254 -0.149035 1.146172 0.301556 1.043038 0.611637 1.119274 -0.185496 1.474180 0.910726 0.869288 0.008729 1.113223 0.605574)

      ;; pp:
      10.416677 (fv 0.000000 0.636826 1.168776 1.802237 0.316567 0.986572 1.395425 0.009381 0.711647 1.264223 1.932392 0.627165 1.472185 0.196446 0.915303 1.747756 0.298057 1.087093 -0.098251 0.679800 1.474105 0.503701 1.516136 0.488851 1.222583 0.157308 1.093122 0.014882 1.111898 0.174280 1.267353 0.186944 1.319383 0.570938 1.741756 0.793533 -0.092041 0.821354 -0.104426 1.044239 0.485714 1.864668 0.984585 0.108795 1.386239 0.942801 0.150487 1.312495 0.693148 -0.057522 1.440466 0.911264 0.464590 -0.106316 1.425558 0.757031 0.414982 -0.197207 1.393462 0.845365 0.655558 0.173740 1.724477 1.622714 1.133952 1.113326 0.491749 0.027662 -0.081584 1.624363 1.523158 1.483424 1.009127 1.065663 0.489911 0.865535 0.429699 0.506066 0.168610 0.091635 -0.004728 0.101995 0.057231 0.244394 0.215629 0.140294 0.025423 0.249165 0.312773 0.491767 0.509301 0.585407 1.082514 1.193775 1.427418 1.634094 0.038165 -0.066305 0.261200 0.531951 1.008338 1.495805 1.630762 0.003123 0.564786 1.124822 1.373512 0.020469 0.093862 0.692170)
      )

;;; 111 all -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.80813938144 (fv 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1)

	10.489680 (fv 0.000000 1.276377 0.968620 -0.218445 1.901880 0.088071 1.832261 1.338375 0.312772 1.516596 -0.040044 1.173079 0.061551 1.259985 1.326413 -0.075796 1.430603 0.457729 0.555673 0.169939 0.778858 0.499517 1.015059 1.507495 0.252622 0.024778 0.982934 -0.060048 0.808349 1.306234 -0.213685 0.893109 1.680180 0.816232 1.412440 1.447865 1.309405 0.967681 0.468074 1.167299 -0.294730 0.516281 1.115680 1.346378 1.503302 1.329509 0.069846 0.507313 -0.050602 1.169163 1.172511 1.329654 1.283831 1.273536 0.082962 0.472668 1.944396 -0.083515 1.629124 1.133239 1.648857 0.792610 0.954204 1.052081 0.877455 0.393129 1.388896 0.794997 1.052606 1.611060 1.743638 -0.167971 0.888631 0.570983 1.576402 0.843125 0.114093 0.127173 -0.133155 0.386550 0.090826 -0.017777 0.548430 0.313331 0.380367 1.607846 1.086331 0.772909 1.643444 0.182619 1.863239 1.234660 1.568659 0.555853 0.450573 1.731233 0.287714 1.462361 1.635622 0.921500 0.450553 1.230974 -0.314374 1.516211 0.633822 0.309849 1.238687 0.080817 0.340326 0.819921 0.108053)

      ;; pp:
	10.643017 (fv 0.000000 0.596037 0.998452 1.643602 0.188094 0.782119 1.390123 1.810388 0.670975 1.236188 1.928555 0.736392 1.354483 0.006575 0.718278 1.554028 0.172799 1.022616 1.853097 0.691617 1.671397 0.482108 1.396206 0.302319 1.140585 0.111154 0.983122 0.056085 1.055691 0.244450 1.330135 0.199631 1.342393 0.616747 1.511753 0.573545 1.630931 0.744657 -0.127581 1.276167 0.582439 1.726242 0.856228 0.208204 1.620801 0.767397 -0.120308 1.331917 0.688933 0.171660 1.532348 0.908708 0.322624 0.027670 1.377420 0.714808 0.162920 1.602731 1.164131 0.775892 0.384718 0.044281 1.527000 1.328705 0.880737 0.584683 0.141627 1.752084 1.448907 1.433198 0.874054 1.138685 0.574512 0.605078 0.161111 0.252563 -0.040319 -0.061275 1.677664 1.534157 1.653785 1.516730 1.618593 1.597830 1.517008 1.764779 1.586607 1.708185 1.767619 1.608773 1.820236 0.130593 0.415076 0.510025 0.490569 0.957514 1.270290 1.288854 1.456687 1.689789 0.173097 0.338870 0.690795 1.081327 1.548637 1.886234 0.458387 0.722046 1.068087 1.577951 0.177921)

	;; 112-1
	10.476162 #(0.000000 -0.030211 1.526924 0.939689 0.852737 0.706404 0.652348 1.102851 1.066824 0.308853 -0.304344 1.005239 0.443123 1.653195 1.097989 0.697644 1.249328 0.992912 0.579418 1.787281 1.625912 0.497994 0.474040 0.522837 0.804300 1.057861 1.210758 0.288878 0.299921 0.437679 1.774864 1.830441 0.760189 0.679331 0.197131 0.251403 0.915019 -0.060881 1.865299 1.462703 1.354536 0.216719 0.284673 1.465621 1.472708 0.026521 0.491055 0.450342 0.543256 0.203094 0.568143 -0.000696 -0.105662 0.063646 0.609769 0.653224 1.270229 -0.161468 0.245350 0.928704 0.732482 -0.395972 0.430943 0.849833 0.408924 0.608119 0.974970 0.452631 0.194319 1.504277 1.381942 1.113958 -0.061867 1.765267 0.179117 0.837014 -0.516746 0.223710 1.148221 -0.072162 0.814707 0.994994 0.024243 1.147240 1.244278 1.494364 1.165538 0.276262 0.606838 -0.055665 1.043194 0.125607 1.134856 0.092212 1.235741 -0.087818 0.379885 0.780391 0.416077 0.615281 1.560490 0.380759 -0.307353 0.796625 1.619408 1.189816 1.305682 1.446319 1.078800 -0.049827 1.350187)
      )

;;; 112 all -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.719 (fv 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

	10.459590 (fv 0.000000 -0.062913 1.592216 0.942127 0.779122 0.819196 0.718354 1.051311 1.122277 0.289276 -0.312849 0.932738 0.364926 1.651917 1.193754 0.735359 1.259741 0.983056 0.504666 1.898067 1.619072 0.449638 0.460210 0.529471 0.685535 0.885439 1.297728 0.246636 0.353836 0.474674 1.786116 1.844574 0.794031 0.522576 0.168364 0.225941 0.884728 0.029172 1.770209 1.576812 1.352123 0.112130 0.389134 1.458224 1.532633 -0.027079 0.404717 0.274263 0.478667 0.228414 0.618491 0.032636 -0.068031 -0.092335 0.583363 0.722295 1.283590 -0.207344 0.372473 0.858879 0.815320 -0.324439 0.478159 0.803167 0.466456 0.633813 0.914568 0.438946 0.113725 1.518872 1.409010 1.227714 -0.134104 1.718626 0.277412 0.813327 -0.439158 0.260660 1.183284 -0.118611 0.754421 1.157336 0.232930 1.195932 1.264381 1.427453 1.112389 0.316426 0.581550 -0.107354 0.998672 0.153435 1.101697 1.916684 1.183525 -0.016743 0.301725 0.815282 0.398182 0.676231 1.536900 0.451259 -0.254624 0.791021 1.692791 1.255094 1.233704 1.361151 1.046040 0.024905 1.319507 0.390306)
      )

;;; 113 all -------------------------------------------------------------------------------- ; 10.6301
(vector 113 14.027848738379 (fv 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1)

      10.600374 (fv 0.000000 0.803646 1.150583 -0.063719 0.153874 1.101937 1.517661 1.839236 0.205434 0.503789 1.408027 1.282481 0.272193 0.581489 0.335632 0.191891 1.772311 1.188767 0.099798 1.108690 0.011443 -0.134966 0.851026 0.685097 0.180285 -0.598894 0.447561 0.453948 1.859577 0.373971 -0.017010 1.368747 0.811506 1.286383 1.607236 0.428535 0.456478 0.425986 0.560105 1.702212 1.615194 -0.029581 1.141022 0.404596 0.679875 1.483164 0.383858 0.334137 1.078889 1.358586 1.100321 0.206891 -0.260760 1.245372 1.320253 -0.104904 0.095400 0.153720 1.818561 0.632022 0.857521 -0.124243 1.123425 -0.152970 0.639127 0.101388 0.775543 0.547622 0.403455 1.168990 1.099889 1.089210 1.061140 1.095647 -0.008863 1.297497 0.125060 1.432503 0.841141 0.967915 1.177416 0.211122 0.724975 0.094432 1.035737 1.190949 0.605535 -0.311727 1.252767 0.699524 1.428815 0.329899 0.934047 0.582587 0.113129 0.668360 0.786133 0.103091 0.745732 1.809761 0.414589 0.231740 -0.023699 1.470163 1.649059 1.087085 1.691589 1.869557 0.611645 1.538351 0.985815 1.244743 0.786305)
      
      ;; pp:
      10.533209 (fv 0.000000 0.701701 1.023037 1.805117 0.325103 0.864669 1.301988 0.041817 0.605545 1.212149 1.794798 0.682259 1.361354 0.200642 1.040014 1.570001 0.413916 1.135956 1.836914 0.609510 1.482300 0.433561 1.396354 0.242061 1.189941 0.064290 0.924650 1.865499 0.844070 1.972890 1.045011 0.019512 1.010788 0.256118 1.454283 0.372006 1.414933 0.757156 1.833026 0.854510 0.058898 1.301933 0.794807 0.059810 1.092848 0.343912 1.857250 1.216439 0.367607 1.585969 1.093436 0.524265 1.847968 1.349059 0.839561 0.495981 1.801236 1.298227 0.638863 0.266374 1.658935 1.480658 0.907119 0.639357 0.037985 1.986216 1.525743 1.288722 0.717261 0.704091 0.182223 0.044649 1.629714 1.819647 1.366848 1.330078 1.172022 1.015716 0.897536 0.806098 0.193895 0.422839 0.374579 0.235069 0.423986 0.463374 0.446056 0.493571 0.177728 0.437229 0.621846 0.665477 0.619012 0.807147 1.289974 1.297164 1.517281 1.924928 0.144210 0.370826 0.244142 0.591610 0.749322 1.350513 1.818547 -0.017393 0.517731 1.113988 1.244052 1.823099 0.067707 0.517248 0.930474)
      )

;;; 114 all -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.847382931726 (fv 0 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1)

      10.628224 (fv 0.000000 0.615672 0.948130 0.747004 0.833637 0.289537 1.854717 0.930205 1.803295 1.161499 -0.674663 0.075654 -0.069447 1.150337 -0.219431 0.096417 1.741068 -0.016217 1.826914 -0.308775 0.152833 0.789042 0.803929 0.462314 0.626523 1.267262 0.400780 0.962101 1.687986 0.905206 0.268457 0.651715 0.114771 1.475643 0.044755 0.228029 0.514674 0.188213 -0.185396 1.589097 0.877857 -0.230405 1.243228 1.194822 1.559225 1.498045 0.808593 -0.017518 1.442649 1.211002 1.811223 0.625459 1.384771 0.613911 0.308197 1.431371 1.357215 1.098185 0.214395 1.664025 1.740860 1.399478 0.567842 0.816563 1.298643 1.214440 0.204096 1.160510 1.171795 0.002888 0.712001 0.408799 0.129596 0.526919 1.018226 1.540087 1.326981 1.269312 0.284234 1.408491 0.614427 1.282597 0.201606 0.407636 1.049940 -0.424432 1.688488 0.609780 -0.014895 -0.443393 1.774217 1.192149 -0.353060 1.542744 1.597711 0.829765 0.335469 0.940418 1.687078 -0.157090 1.505994 0.110351 1.069331 0.286269 -0.198482 1.240708 -0.041616 1.268700 0.079424 0.525193 1.036769 0.352036 1.456021 -0.218427)

      ;; pp: 
      10.517948 (fv 0.000000 0.513150 0.874296 0.883964 0.730138 0.492200 1.910349 0.914831 -0.079055 1.078332 -0.626669 0.137543 -0.184379 1.218055 -0.394114 -0.038192 1.661163 0.020764 -0.078690 -0.096176 0.170832 0.906574 0.889519 0.505117 0.670269 1.228477 0.365822 0.917034 1.728829 0.934323 0.199610 0.715554 0.056223 1.583731 0.085811 0.136885 0.354627 0.123817 -0.315376 1.492556 0.991663 -0.233639 1.201411 1.218512 1.753756 1.719460 0.679044 -0.197393 1.570682 1.193787 1.873756 0.557014 1.432466 0.588568 0.309382 1.651394 1.357542 1.190693 0.264093 1.733513 1.676510 1.179474 0.616239 0.734925 1.107757 1.048586 0.066290 1.132123 1.205852 -0.090603 0.754355 0.838256 -0.013038 0.421890 0.968163 1.389079 1.284090 1.323690 0.432981 1.323326 0.730210 1.395732 0.109710 0.246664 1.169930 -0.449126 1.545991 0.365384 0.076032 -0.458822 1.876049 1.124853 -0.255218 1.423147 1.451143 0.955505 0.281503 0.928421 1.983790 -0.130994 1.684131 0.142847 1.010533 0.452692 -0.386536 1.218551 -0.132981 1.371320 0.120371 0.410528 1.083879 0.496636 1.350228 -0.127680)
      )

;;; 115 all -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.359978160099 (fv 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0)

	10.651124 (fv 0.000000 0.205632 0.521043 1.123267 0.039976 1.837568 0.645276 0.444856 1.235953 1.614101 0.576705 -0.032817 0.913102 0.971540 0.123207 0.744147 0.392163 1.071292 -0.098894 1.183735 0.447902 1.029195 1.008083 1.241655 1.280374 0.851598 0.236819 1.816127 -0.109787 0.735910 1.359965 1.270732 -0.070459 0.794811 1.337404 0.069925 0.240715 0.381811 0.943512 0.073841 0.371201 0.917351 1.527618 1.440973 1.203354 1.349081 1.416186 1.496910 0.596478 1.312074 0.317957 1.177389 1.248077 0.233191 1.529687 -0.003737 0.662497 0.466830 0.261424 0.663736 1.797196 0.273538 -0.239584 0.345229 -0.159975 1.144743 1.462922 0.849868 0.439184 0.064973 -0.068494 1.400482 0.060773 0.986838 0.519130 0.531890 1.046288 1.063229 -0.449183 0.987082 0.473670 0.722114 1.227775 0.954889 0.100062 1.512033 0.697126 0.308149 0.914574 -0.044099 1.083776 1.037385 0.163494 1.178786 0.886753 1.659086 0.598578 0.720776 -0.009109 0.443556 -0.035564 0.124043 0.119757 0.888837 0.603645 0.075938 0.648026 1.218123 0.325603 0.011855 -0.390969 1.523387 0.517639 0.461045 0.382395)

      ;; pp:
      10.692099 (fv 0.000000 0.682108 1.004779 1.652402 0.376256 0.931307 1.336301 -0.042653 0.588667 1.131321 1.748894 0.607835 1.177352 0.067431 0.978893 1.474587 0.304669 1.111594 1.772579 0.564007 1.383113 0.290881 1.312527 0.215649 0.998467 1.886147 0.914831 1.987244 0.837886 1.778286 0.954819 0.007952 0.956821 0.049735 1.234469 0.317950 1.546668 0.474841 1.665959 0.756708 1.898394 0.922825 0.371276 1.716491 0.889079 0.061723 1.582232 0.834088 0.114964 1.594440 0.728947 -0.028372 1.273062 0.885177 0.297790 1.790777 1.254681 1.031275 0.275613 1.607695 1.196021 0.692250 0.421770 -0.204945 1.512060 0.983139 0.944306 0.546267 0.135875 1.788546 1.584465 1.138761 1.024708 0.473784 0.573120 0.243555 0.106429 0.088753 1.821567 1.941212 1.609147 1.360828 1.169556 1.150415 1.008492 1.219522 1.057528 1.215083 1.411123 0.944912 1.124604 1.295606 1.527918 1.383902 1.570266 -0.108659 -0.107049 0.292041 0.547918 0.923643 1.165187 1.026903 1.427566 1.557678 -0.113193 0.455092 0.823626 1.321739 1.608732 1.934769 0.561130 0.698218 1.143434 1.648015 0.348542)

      ;; 114+1
      10.631060 #(0.000000 0.552173 0.793379 0.936620 0.669317 0.451920 1.944095 0.907949 -0.031640 1.183561 -0.610328 0.092630 -0.018286 1.180247 -0.333309 0.013147 1.645878 0.074515 -0.084624 -0.079454 0.058151 0.967323 0.967800 0.453242 0.695319 1.231048 0.341111 0.934770 1.683712 0.964098 0.238371 0.682806 -0.033317 1.574012 0.088095 0.137957 0.367836 0.209794 -0.271893 1.429483 0.926818 -0.219986 1.219277 1.163830 1.762576 1.732042 0.728369 -0.206422 1.584222 1.209279 1.990386 0.490260 1.414241 0.639703 0.241725 1.644974 1.450811 1.147921 0.189877 1.865999 1.749835 1.301097 0.537640 0.704136 1.084600 1.200521 0.189481 1.163110 1.095649 -0.098952 0.629461 0.719174 -0.175255 0.442438 1.022529 1.412978 1.217780 1.329205 0.475650 1.334873 0.712369 1.399938 0.054330 0.257665 1.151583 -0.372447 1.415390 0.317233 0.189645 -0.385584 1.821938 1.181610 -0.175763 1.307222 1.496257 1.037723 0.249347 0.942001 -0.004067 -0.133181 1.669252 0.107568 0.954376 0.480486 -0.338247 1.325951 -0.157899 1.389378 0.178129 0.393589 1.093410 0.560722 1.406129 -0.163697 0.047563)
      )

;;; 116 all -------------------------------------------------------------------------------- ; 10.7703
(vector 116 14.175787507646 (fv 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 1 1 0)

	10.666895 (fv 0.000000 0.794041 0.130396 1.155449 0.575356 1.670182 1.438030 0.802411 -0.073881 0.612189 1.011030 0.243247 1.424701 1.360754 0.519915 1.303274 0.114440 0.486440 1.248641 -0.062831 1.818237 1.003329 1.774020 0.995383 0.217514 0.236196 0.918414 0.251978 0.240543 1.203872 1.193015 1.546847 0.668684 0.276657 0.720261 0.041331 0.124685 1.052830 -0.470877 1.036338 0.454033 1.208580 1.059685 0.252464 0.910634 -0.469687 1.282886 1.260566 1.714177 0.148852 1.558794 0.117249 1.208112 1.206944 1.379709 1.280227 -0.397300 1.912745 1.609055 0.469506 1.102260 0.207876 1.456855 1.808614 1.436770 0.080959 1.197513 1.183739 1.574767 0.068412 1.162064 0.609158 0.566278 1.029997 1.123257 -0.210554 1.006729 1.012851 0.184672 1.531574 1.788773 1.233395 0.609493 0.767948 1.753741 1.423961 0.953617 0.300031 0.940377 0.324215 0.472402 0.042965 0.104811 0.217444 1.091263 1.136923 1.660947 0.519559 1.199475 -0.360436 1.523678 1.224456 -0.014998 1.278905 -0.475457 -0.462757 0.028990 0.974163 1.009397 0.422500 0.343570 0.466660 0.909671 0.746952 -0.297506 0.078048)
      )

;;; 117 all -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.136 (fv 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1)

	10.740323 (fv 0.000000 1.376267 1.204802 1.617264 0.013985 1.562933 1.297010 -0.381289 0.175690 0.812406 0.271907 -0.572032 0.505210 1.569967 0.483045 1.266493 1.587294 0.516881 0.600232 0.990644 0.302416 1.037870 1.417076 1.853643 -0.147420 0.890223 1.567662 0.981809 0.815941 1.608390 -0.281550 0.201337 1.556451 1.125175 -0.236163 1.445336 0.258466 0.600771 0.570165 0.048623 0.131732 0.130088 0.167451 1.924952 -0.030799 0.148010 1.615329 0.361965 0.025922 1.817684 1.449080 1.328054 1.692177 0.082231 0.922069 0.868297 0.602630 -0.302067 1.498947 0.796296 -0.211597 1.912831 0.263824 1.087462 0.264795 1.339326 0.746964 1.555264 0.991573 0.792728 0.572734 0.831900 1.561482 0.487864 1.625032 1.584684 1.155708 1.141107 1.673417 0.421621 -0.187613 1.264593 1.627549 0.823098 0.254093 0.097500 0.358549 1.789940 1.103526 1.081236 0.794597 1.136333 1.473853 1.388624 -0.112319 0.798455 -0.090384 -0.176678 0.782426 -0.241572 0.802635 1.296656 0.310053 1.464029 0.628323 1.034158 1.019782 -0.078897 0.005414 1.234988 0.557243 0.357637 -0.491315 0.727622 1.220297 0.073271 0.925087)
      )

;;; 118 all -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.207115029287 (fv 0 1 1 1 1 1 1 0 1 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0)

	10.789998 (fv 0.000000 -0.175913 -0.143823 0.018273 0.027771 0.767311 -0.171214 1.636246 0.351281 1.388337 0.882351 1.707573 0.469183 0.078893 1.085758 0.618150 0.277129 0.703491 1.759709 -0.452169 1.251866 0.357896 0.724274 0.269975 1.838904 1.530293 1.426834 1.312699 0.647676 1.426356 1.595332 0.060341 0.690735 0.318521 0.226388 0.557313 0.682546 0.405400 0.629229 1.956450 1.295086 1.263226 1.531833 -0.446064 1.088083 -0.430622 1.100111 0.930366 1.309892 0.353356 1.791502 1.255481 1.229378 1.253262 1.406532 0.024314 1.063085 1.088221 0.123383 1.238746 1.005923 0.642418 1.110925 0.453476 -0.290616 1.496832 1.287503 0.244996 1.530267 0.834163 0.976178 0.556214 0.154839 1.049337 1.096181 0.549254 -0.047077 0.951697 1.030491 0.147772 0.888048 0.978379 -0.017946 1.704759 1.894288 0.751630 1.629711 1.581497 1.015790 1.546094 0.769995 1.519488 -0.226811 0.116498 -0.232287 0.274508 1.259352 1.098443 1.128583 0.216589 1.343006 0.117206 0.662844 -0.110291 1.010752 0.251673 1.029907 -0.274450 1.835049 0.199877 0.646328 1.080725 0.210236 1.055491 1.898124 0.072310 0.796446 1.191135)
      )

;;; 119 all -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.502624011553 (fv 0 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 1 0 1 0 0)

      10.894037 (fv 0.000000 0.630386 0.843125 1.285949 0.340650 -0.017357 0.327019 1.384996 1.081793 1.397782 0.680727 0.599720 0.760758 1.651799 1.943215 0.601150 0.438753 0.220032 0.283706 0.321338 1.848806 -0.818805 1.279239 0.233383 -0.265065 0.149488 0.866113 1.211455 -0.153192 1.086507 -0.117739 0.108345 0.296077 0.924788 0.407609 0.257469 1.108157 0.337516 1.501434 -0.160734 0.937661 1.194914 0.677862 1.064411 -0.083066 0.280209 0.164734 0.604351 1.488726 0.546557 -0.173942 0.258452 -0.144704 1.931749 1.121694 0.070973 1.246077 0.433607 -0.015989 1.447158 1.307009 0.290513 1.032586 0.483509 0.866614 0.896091 0.118763 0.703456 1.160811 -0.272718 1.618947 0.922379 0.186934 0.444686 0.391527 -0.170445 0.686201 0.072390 -0.083273 0.261424 1.315326 1.343146 -0.078550 0.581799 0.100158 0.342044 0.531455 0.823995 0.311378 0.398507 -0.067564 1.021721 0.099971 0.375472 1.694822 -0.129069 0.760774 0.760279 0.907128 1.373425 1.265414 0.699858 -0.214864 -0.228584 1.101084 1.533737 1.209100 1.477560 0.508584 0.989498 0.862450 0.271802 1.549833 0.881136 1.017209 0.041014 1.240632 1.019564 1.718786)

      ;; pp:
      10.835933 (fv 0.000000 0.654099 1.035661 1.681354 0.271205 0.793039 1.296335 0.060400 0.653112 1.232942 1.881379 0.620355 1.199841 0.014260 0.823834 1.413032 0.189484 0.947478 1.588848 0.403300 1.280378 0.215388 1.137801 1.956237 0.732861 1.657436 0.792204 1.789188 0.703767 1.598762 0.539735 1.541253 0.421443 1.469357 0.779053 -0.021286 1.026341 0.083226 1.233425 0.357509 1.441485 0.752264 1.858411 1.012419 0.073105 1.341491 0.748507 0.322726 1.533912 0.715880 0.027861 1.454725 0.694006 -0.082536 1.358750 0.823835 0.158492 1.802363 1.289166 0.871603 0.288280 1.653699 1.258131 0.754564 0.197129 -0.135159 1.406727 1.305489 0.902560 0.505625 0.165621 1.980298 1.711088 1.181402 1.035732 0.515951 0.573196 0.077979 0.369360 -0.029664 0.027976 1.710591 1.639472 1.419449 1.489927 1.072898 1.080212 0.909135 0.903629 1.096948 0.947039 1.126463 1.358955 0.953854 1.137457 1.170488 1.431020 1.393091 1.493097 1.708464 0.028863 0.359918 0.447603 0.693507 1.013920 0.980939 1.193095 1.522944 -0.124582 0.421795 0.849849 1.081289 1.559178 0.036966 0.454552 0.747770 1.437228 1.496079 0.068555)
      )

;;; 120 all -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.534638752286 (fv 0 0 0 0 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0)

	10.877907 (fv 0.000000 1.760966 1.432317 0.661698 0.093764 0.677833 1.324379 0.560678 0.084000 1.893101 0.982568 0.231983 0.030976 1.869849 0.114160 0.803943 1.697252 0.187259 0.348967 1.325837 0.129934 0.628168 -0.292961 -0.172670 0.424548 1.491809 -0.230282 0.327899 -0.371234 1.709483 0.949653 0.922124 1.730156 1.323261 1.332457 0.313981 1.342414 0.100580 0.697678 0.026744 -0.054235 1.341652 -0.009876 1.698348 0.248931 -0.183551 1.470018 1.710913 1.251473 0.727247 1.872729 0.011341 0.025061 0.694946 1.531659 0.478715 1.097259 0.657341 1.219034 0.633776 0.382770 0.377028 0.092620 0.800796 0.434789 0.301288 0.942251 -0.118601 -0.116547 1.180657 1.270834 0.986907 0.237837 0.780073 1.628870 -0.280374 -0.194405 0.622013 0.090032 1.411166 0.490814 -0.298299 1.291149 1.730249 1.587675 1.193266 0.285035 0.236562 1.437795 0.582458 1.521211 0.605547 0.877830 1.441130 1.061898 0.936396 1.257893 0.016398 -0.126771 0.102714 1.392810 1.183106 1.832099 1.740994 0.232560 0.367779 0.656921 -0.130561 0.093991 0.079826 0.694300 1.076720 1.076648 -0.154506 1.074489 -0.219932 0.141670 -0.212932 0.458505 1.362796)
      )

;;; 121 all -------------------------------------------------------------------------------- ; 11
(vector 121 14.184466362 (fv 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

	10.924906 (fv 0.000000 1.021993 1.334449 0.689448 0.491891 0.317117 0.185100 1.316740 0.942417 -0.055518 1.467945 1.216575 0.460144 1.613483 1.346938 0.351666 1.534737 1.166463 0.663385 1.751743 0.887304 0.686057 0.353407 0.640903 0.247744 0.051185 1.683771 0.607042 -0.642997 1.586265 1.428130 1.293714 0.376348 1.687396 1.342115 1.114987 0.421788 0.173805 0.664896 0.744172 1.338635 0.611663 0.948619 1.727026 0.108093 1.757613 1.759583 0.684030 0.701845 0.897975 1.291554 1.678993 -0.010218 1.672340 1.419180 0.531998 1.055064 0.071044 -0.158722 1.660752 -0.273616 1.601063 0.212433 0.488138 0.674057 0.101023 0.258204 0.323292 0.370652 0.521650 1.206457 1.206236 0.768851 0.204856 0.771378 0.971274 -0.207666 0.711434 0.295654 1.831769 0.464965 1.896472 0.968538 0.024673 1.250922 1.351355 0.486851 0.833273 1.147617 1.669210 0.770997 -0.072413 0.463363 1.323688 1.050580 1.732192 0.819244 0.777660 1.040697 0.078135 0.787038 1.358361 0.700196 0.074501 0.587042 0.515371 1.216302 0.852496 0.581485 0.849691 1.814480 1.077357 0.162962 0.766524 -0.151640 0.240975 0.296067 0.314628 1.286198 0.210485 0.583580)
      )

;;; 122 all -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.536 (fv 0 1 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0)

	10.949841 (fv 0.000000 1.704153 0.121290 0.688837 1.244030 1.262068 -0.197896 0.413249 1.197451 1.272156 0.642587 1.292432 1.783982 0.043702 1.158291 1.164647 1.692639 1.493672 1.007369 1.436042 1.725774 0.880017 0.375925 1.616969 0.128447 1.149978 1.084930 0.463608 1.105848 1.530070 1.424718 0.719589 0.763768 0.288678 1.156946 0.691396 0.064365 0.469636 1.091974 0.426323 1.090313 0.491849 0.938048 1.656418 0.459182 0.976494 0.376276 1.451323 1.601769 -0.407170 0.538990 1.732338 0.050678 1.192103 0.536699 0.739148 1.592439 -0.026377 0.032581 0.995911 0.348311 -0.030558 1.293098 0.192261 0.610689 1.016189 0.912642 1.102218 1.291663 0.930392 1.417016 1.312774 1.826696 0.250091 0.993926 0.681381 0.628174 0.441959 1.489842 0.532045 1.179384 0.517873 0.125155 1.064841 1.980073 0.744857 1.235778 1.280286 1.634199 -0.058763 1.206383 1.265460 1.054717 0.853628 1.196638 0.872935 -0.314369 0.468836 0.081998 0.420778 1.325508 1.934649 1.587718 1.251054 -0.176641 -0.893762 0.381112 0.198904 0.283702 1.674181 1.521739 0.754893 1.659031 0.756575 0.235790 -0.129516 1.697508 -0.350053 0.868125 -0.095111 1.099831 0.951722)
      )

;;; 123 all -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.67458183944 (fv 0 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 1 0 1)

      11.089811 (fv 0.000000 -0.095705 0.502046 0.843201 1.262416 0.051297 -0.136069 1.229943 0.769550 -0.394544 1.202311 0.030935 0.212789 0.180234 1.202646 1.847334 1.298798 1.298567 0.826116 1.899995 0.130966 0.229988 0.849236 1.354957 0.175337 -0.090289 1.376955 0.986456 0.858952 -0.348674 -0.073167 -0.218495 1.696358 1.036669 1.130688 0.308330 0.510630 1.786938 -0.105214 0.654929 1.564764 1.314058 0.677163 -0.213165 1.538085 0.616182 0.862650 0.165337 -0.034200 1.035704 0.813627 1.106006 1.740931 0.014126 1.052235 0.657556 1.858826 0.165758 0.630519 0.409633 -0.040211 1.543795 1.391268 -0.071463 1.608090 0.360070 -0.066709 0.298864 0.437480 -0.144723 -0.061475 0.229100 1.150525 0.049068 -0.178297 1.796933 1.253507 1.460767 1.254789 1.053122 -0.014640 1.158719 1.833281 -0.100606 1.043660 0.125118 1.383020 0.234098 0.814218 -0.263454 1.710640 0.541462 0.096383 0.540963 -0.022417 0.505975 1.860187 1.286017 0.269581 0.338845 0.988364 0.065927 0.952682 1.381585 1.156408 1.384314 0.622434 1.536785 0.876899 0.457680 0.787662 1.764741 0.741434 -0.166817 0.104157 0.779344 1.374068 1.055092 1.250202 1.254085 1.185506 -0.050283 -0.314919)

      ;; pp:
      11.016135 (fv 0.000000 0.647630 1.074276 1.756268 0.251422 0.804135 1.421127 0.040524 0.665959 1.111755 1.848209 0.635476 1.226811 0.078653 0.744267 1.473903 0.238865 0.830996 1.602610 0.483888 1.291535 0.032720 0.918740 1.769630 0.682055 1.658606 0.644590 1.383351 0.360438 1.331009 0.396705 1.499558 0.394585 1.332297 0.284286 1.367163 0.697156 1.873754 1.072911 0.259822 1.429562 0.401628 1.434105 0.713387 0.052744 1.073687 0.172805 1.418890 0.502359 0.008598 1.451186 0.715950 -0.032063 1.332938 0.645483 -0.170523 1.375389 0.799087 0.277881 1.623936 1.051516 0.728226 0.326139 1.759949 1.287776 0.814001 0.247394 -0.079677 1.277221 1.247278 0.815434 0.548501 0.120625 1.806890 1.668828 1.491775 0.975860 0.670802 0.343501 0.107101 -0.116370 1.739084 1.782173 1.584916 1.517015 1.084964 1.270093 0.937194 1.142225 0.603049 0.902612 0.582213 0.697513 0.723238 0.854795 0.946568 1.173389 0.894182 1.104017 0.982296 1.332899 1.077929 1.505566 1.771677 1.766832 0.125556 0.284805 0.740017 0.785432 0.946551 1.254134 1.343675 1.825955 0.281285 0.688963 0.928919 1.510642 0.002528 0.243797 0.692027 1.356775 1.422418 -0.003671)

      11.026867 (fv 0.000000 0.653666 1.072564 1.740976 0.247742 0.790012 1.411951 0.041271 0.655141 1.093720 1.825949 0.627661 1.226455 0.066128 0.727718 1.457297 0.232847 0.809894 1.588226 0.483830 1.281902 0.041404 0.923472 1.775595 0.688428 1.664557 0.642084 1.367837 0.346454 1.325097 0.399464 1.507654 0.405227 1.335158 0.295969 1.370355 0.695048 1.858091 1.070660 0.281628 1.434197 0.386568 1.430103 0.723861 0.039604 1.056919 0.185318 1.429536 0.512737 -0.008058 1.468840 0.693342 -0.064875 1.337336 0.661742 -0.182834 1.372700 0.786915 0.297423 1.611420 1.071154 0.729715 0.310746 1.764947 1.273273 0.823395 0.233154 -0.066520 1.292883 1.254747 0.816735 0.569625 0.115575 1.811294 1.663943 1.513795 0.979951 0.695291 0.343066 0.105436 -0.095756 1.742763 1.772836 1.591223 1.517777 1.104344 1.264828 0.936476 1.149545 0.608283 0.910692 0.573081 0.679655 0.751294 0.860614 0.938017 1.160276 0.903422 1.132848 0.990078 1.347278 1.077430 1.524164 1.766622 1.752773 0.148618 0.273073 0.730264 0.787847 0.969904 1.260951 1.360924 1.824936 0.297772 0.686467 0.925933 1.514831 0.006288 0.244328 0.684624 1.376668 1.432494 -0.015455)
      )

;;; 124 all -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.607 (fv 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1)

	11.060270 (fv 0.000000 0.155441 1.710148 0.675606 0.991885 0.930398 0.521431 0.244313 1.630742 0.168790 0.137270 0.000305 -0.043062 0.897696 0.964832 0.045064 0.425268 0.964217 1.290413 0.929170 0.235812 1.335949 0.057667 0.001006 1.068524 0.446791 1.393120 0.549817 1.466180 -0.642251 1.637204 0.595543 0.457077 0.355722 0.196249 1.437718 -0.302241 1.024336 1.392207 1.340742 0.398137 0.737820 0.315317 0.261053 0.730496 0.895111 0.489074 0.360451 1.441085 0.496392 1.486058 1.322042 1.007323 -0.126599 0.931744 1.784266 0.161232 0.306266 0.415406 0.681040 1.790701 0.980642 -0.005904 1.343074 0.136975 0.027551 -0.124807 1.525812 0.151673 1.852354 0.924568 1.280951 0.029602 0.736180 1.201925 0.667470 1.226105 0.326690 0.609507 -0.393588 1.467285 1.671123 1.358186 0.541731 1.122604 1.867616 -0.473631 -0.417534 0.660754 1.837680 1.546497 0.596764 1.110785 0.215660 0.434300 0.180279 1.110604 0.505631 1.274765 1.668673 0.193680 0.673308 0.543007 1.365849 -0.310522 0.237117 0.174423 1.731063 0.766964 0.281277 -0.402143 0.989963 0.637238 0.526844 0.787012 1.257855 0.717061 0.758671 0.882050 1.342356 0.626910 1.083549 0.608055 0.472324)
      )

;;; 125 all -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.985 (fv 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0)

      ;; 11.16794 
      11.160786 (fv 0.000000 1.015332 1.208067 1.409127 0.622612 0.043137 0.789070 0.545823 0.370412 0.925346 1.157620 0.165772 1.424901 0.898702 1.656211 0.988303 1.801194 1.470568 1.745983 0.609307 -0.597689 0.731241 -0.142723 0.984230 0.073162 1.875752 0.335696 1.602183 0.142368 0.017160 0.448032 0.120103 0.041279 0.523055 0.073650 1.053879 -0.306921 1.513911 1.101021 1.602539 -0.121119 0.641316 -0.004631 1.595461 1.743817 0.418939 0.589672 1.179156 0.811957 1.197450 1.342788 1.287174 1.574681 1.241671 0.609625 0.929510 0.079585 0.612922 1.100363 0.431650 -0.459913 0.120058 0.264463 0.028955 1.140993 0.787792 1.007154 0.514281 1.114045 1.286846 1.241625 0.916235 0.449091 1.255016 0.869776 0.016192 1.421914 1.225032 1.302610 0.650162 0.956126 0.761196 -0.213826 0.222275 -0.426223 1.123082 0.506980 1.405113 0.081703 0.828457 1.262806 1.843366 0.399948 0.473729 -0.529905 1.215838 1.003418 1.687511 0.432881 1.055890 1.071502 1.087648 0.147867 -0.002533 0.317269 1.612891 -0.180768 1.003458 1.820527 0.761821 1.137143 0.352919 -0.090034 1.456553 0.819912 0.115658 0.246973 0.936701 1.319554 0.851128 1.479387 0.046130 1.488656 0.854373 0.867709)

      ;; pp.scm:
      11.105486 (fv 0.000000 0.668250 1.004851 1.665604 0.270207 0.823031 1.317389 1.895775 0.442735 1.092420 1.706335 0.316469 1.053513 1.851731 0.426377 1.214568 0.111950 0.768130 1.567897 0.318224 1.096474 0.028789 0.851033 1.730934 0.518266 1.394840 0.485490 1.534760 0.346603 1.302654 0.195595 1.075240 0.149474 1.131730 0.186045 1.296000 0.352391 1.439364 0.663850 1.837274 0.958873 0.121068 1.316333 0.242865 1.517748 0.747235 1.882566 1.040766 0.534079 1.729417 0.993163 0.496721 1.811700 1.002981 0.317419 1.678987 0.959753 0.256596 1.817235 1.299690 0.756280 0.292629 1.822282 1.254136 0.905795 0.232927 1.675869 1.252625 0.924210 0.377830 0.081344 1.650592 1.565111 1.210398 0.823930 0.495597 0.170992 -0.097351 1.629713 1.238397 1.141529 0.804262 0.860680 0.603481 0.666502 0.428034 0.395443 0.132689 1.849680 0.035737 1.395931 1.824957 1.358060 1.651982 1.606952 1.718179 1.670215 1.887548 1.688422 1.844666 -0.292284 0.050366 -0.101906 0.075572 0.305815 0.606639 0.913420 1.030088 1.512470 1.549064 1.827384 0.007726 0.106419 0.461039 0.753337 1.221334 1.792974 0.097112 0.617097 1.170484 1.176316 1.664541 0.165974 0.635539 1.022624)

      ;; pp1:
      11.114689 (fv 0.000000 0.681978 1.028261 1.706912 0.292133 0.848775 1.343922 1.911777 0.451105 1.069054 1.693074 0.301918 1.035579 1.825832 0.435611 1.230581 0.111624 0.750696 1.574421 0.321180 1.071098 -0.013053 0.852483 1.783026 0.524168 1.371392 0.475241 1.562570 0.337915 1.270461 0.221125 1.100498 0.123076 1.107894 0.160645 1.270692 0.306224 1.479440 0.658107 1.838424 0.945824 0.091726 1.332313 0.238983 1.552958 0.749521 1.839061 1.045392 0.486297 1.712081 0.982243 0.539957 1.767541 0.934362 0.293124 1.675620 0.993763 0.206674 1.792070 1.270778 0.729123 0.284390 1.801314 1.282266 0.918468 0.252050 1.650401 1.232066 0.903570 0.313672 0.087588 1.657912 1.543341 1.232872 0.839991 0.464849 0.196039 -0.147366 1.653544 1.258396 1.123045 0.770121 0.900031 0.618800 0.692026 0.397188 0.475351 0.152075 1.894219 0.030184 1.418582 1.854056 1.299662 1.631587 1.652019 1.730754 1.687797 1.916199 1.730490 1.823361 -0.277080 0.063403 -0.121338 0.021902 0.284828 0.586626 0.860176 0.999715 1.490642 1.510249 1.792225 0.008814 0.113621 0.391836 0.733891 1.237143 1.809005 0.128227 0.638952 1.175937 1.156619 1.663599 0.187027 0.654280 1.021025)
      )

;;; 126 all -------------------------------------------------------------------------------- ; 11.224972
(vector 126 14.67419786533 (fv 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      11.145483 (fv 0.000000 0.899293 0.378495 1.289186 0.777288 0.858338 1.619831 1.737202 1.951674 0.835017 -0.087625 1.707725 0.328507 0.828194 -0.110415 0.084984 1.000160 0.933659 1.329981 0.403112 1.465299 0.867776 0.736209 0.286670 0.614444 0.936369 0.873213 0.123325 0.103437 0.033532 0.337773 1.704277 1.195946 1.204920 1.015411 0.867778 0.772767 0.521662 1.281071 0.987342 0.207100 0.684428 0.579999 1.230109 0.833339 0.874869 1.325709 1.214223 -0.039340 1.273384 0.554903 0.324879 0.897065 0.122734 0.357179 1.405113 1.382262 1.052698 1.093027 0.696151 1.256101 1.113094 1.329670 0.549960 1.774690 1.419208 1.188823 1.415491 0.266597 0.476692 0.360990 0.613975 1.834829 -0.016278 0.893804 0.177235 -0.162182 0.465943 0.846924 0.105182 0.478317 0.762411 0.169998 0.509253 1.306498 1.829812 0.517679 0.137251 1.279904 1.030500 -0.049960 1.650399 1.720514 0.164442 0.994973 1.525343 0.937775 1.609285 1.534911 -0.677300 0.133781 0.129445 0.518965 -0.144758 1.037002 1.052666 0.841376 0.157786 1.034141 0.219735 1.379782 0.222272 1.298276 0.072801 0.604052 1.220954 0.022881 1.817683 0.809301 0.789103 1.114921 0.656136 -0.111384 0.132814 1.271527 0.712891)
      )

;;; 127 all -------------------------------------------------------------------------------- ; 11.269427
(vector 127 14.851 (fv 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

	11.176112 (fv 0.000000 1.071888 1.248428 0.289874 1.246619 0.289572 1.760445 0.245569 1.154033 1.309416 0.081159 1.849794 1.710269 1.368867 1.052576 -0.398246 -0.001522 1.370275 0.292491 1.626710 1.166078 1.755696 1.227481 0.377631 0.354241 0.127104 0.305667 -0.167076 0.018149 1.234977 0.220914 0.373111 0.199191 1.136953 0.209502 1.631334 0.736118 -0.280026 0.637855 0.997502 0.069226 0.738973 1.836372 1.422035 0.641751 0.717645 0.227787 1.627490 0.896625 1.164185 1.181473 0.283052 0.793654 1.893617 0.958053 1.877395 0.211241 0.448741 0.465207 1.415492 1.261864 1.182640 0.217781 0.211053 1.936678 0.848219 1.690040 -0.183682 -0.275325 0.916325 0.426519 1.353568 0.171309 0.590049 0.503441 0.438773 0.014163 -0.062159 0.869887 -0.128424 0.144319 1.756020 1.717018 -0.046012 0.125572 0.279523 0.175456 1.083651 1.091291 1.212635 1.168385 1.392580 -0.189037 0.240170 0.866374 1.580620 1.749254 1.502399 1.243019 0.251600 -0.018231 1.414780 0.773115 0.067214 1.323483 0.617886 1.663914 0.351482 0.571589 1.123483 1.679985 0.501109 1.035832 1.346170 1.289512 1.663306 0.584848 0.500505 -0.031006 0.055228 0.131713 1.510949 0.309811 1.293736 1.414224 0.248635 1.517857)
      )

;;; 128 all -------------------------------------------------------------------------------- ; 11.313708498985
(vector 128 15.138 (fv 0 1 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1)

      11.309209 (fv 0.000000 1.243323 0.073338 1.687189 1.124666 1.389841 0.847573 1.018728 0.290645 0.447958 0.152825 0.408946 1.554733 1.027824 0.742595 1.417320 1.174719 0.230635 0.137711 0.205770 -0.223930 -0.484352 0.868175 0.460794 0.073208 1.470166 -0.048840 -0.141098 1.057707 1.534980 0.337573 1.200647 1.372018 -0.041548 0.602859 1.849030 -0.103678 0.815675 0.107720 0.796671 0.027496 0.761821 1.113332 0.855622 0.650295 0.713381 0.490023 1.179238 -0.088446 0.282357 -0.437849 1.210715 1.321994 0.443637 1.300839 1.352381 -0.001933 0.442309 -0.088426 0.287664 0.126405 -0.108646 0.637631 0.580452 1.256195 1.182134 1.382836 1.180662 1.171900 0.353945 1.569554 0.076717 1.316852 1.092094 0.641656 0.578236 1.268290 1.296116 0.291194 1.287832 1.351802 0.877933 0.046043 0.135350 0.952936 1.137202 0.623256 -0.396801 0.327118 0.077316 0.800999 0.673083 1.387941 0.952139 1.436716 0.326423 0.697455 0.564179 1.047968 0.663414 0.327317 0.386236 0.415974 0.266450 1.112215 0.646830 0.208505 1.019398 -0.208967 0.964650 0.120229 1.347295 1.011374 1.053660 1.549663 0.688863 1.745386 0.772703 1.031951 0.182902 0.350269 0.873751 1.129081 1.610214 -0.035633 1.365829 0.190640 1.177284)

      ;; pp:
      11.210356 (fv 0.000000 0.529477 1.092204 1.655320 0.240176 0.840083 1.290316 0.036113 0.414482 1.184815 1.733487 0.475904 1.226699 -0.054687 0.544000 1.373024 0.096261 0.605273 1.510542 0.229851 0.972933 -0.008717 0.768966 1.800241 0.536684 1.336088 0.309226 1.164728 0.254148 1.069819 0.021808 0.945032 -0.039508 0.972460 -0.067607 1.002895 0.197048 1.366967 0.351763 1.540663 0.648980 1.698360 0.730857 0.118485 1.274417 0.283223 1.327398 0.691807 0.012365 1.128647 0.533746 1.871605 1.252479 0.321809 1.476722 1.286815 0.557929 1.863054 1.365020 0.715719 -0.012609 1.699347 1.092581 0.354365 -0.098429 1.602411 1.106114 0.622866 0.186170 1.647857 1.109362 0.904818 0.566992 0.283406 1.734276 1.302248 1.135583 0.996099 0.637141 0.319233 -0.334659 -0.051454 1.363705 1.553533 1.027907 1.065457 0.795998 0.486251 0.704843 0.431262 0.496789 0.160271 0.268391 -0.277422 -0.064873 -0.149375 -0.202682 0.078495 -0.086833 -0.064332 0.234996 -0.109719 0.180200 0.196396 0.559877 0.436602 0.563596 0.942230 1.157161 1.450532 1.353287 1.969232 0.307428 0.330752 0.455679 0.656549 1.076389 1.439415 1.817226 0.185723 0.623808 1.021760 1.554273 1.872894 0.258818 0.595831 0.908779 1.816125)
      )

;;; 256 all -------------------------------------------------------------------------------- (16)
(vector 256 23.353 (fv 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1)

	16.061041 (fv 0.000000 0.925796 0.374630 -0.108513 -0.821698 -0.025087 -0.506195 0.298783 0.035173 0.012160 0.459017 0.128871 0.955347 -0.719489 0.827601 0.829509 -0.132131 0.534593 0.213472 -0.471818 -0.764121 0.240055 -0.480081 0.847706 -0.032870 -0.481128 0.761455 -0.211601 0.010004 0.568923 -0.059172 -0.017957 0.170478 -0.613989 -0.042068 -0.938552 -1.012251 0.796792 -0.038645 -0.426760 -0.192132 -0.528083 -0.017037 -0.489368 0.355556 0.515110 0.821955 -0.244212 -0.238511 -0.789603 0.734511 0.783320 0.368778 -0.600810 0.581954 0.316603 0.874508 -1.013265 0.262565 0.824972 0.323390 -0.162260 -0.116223 -0.866816 -0.634726 0.764949 -0.318122 0.145813 0.067938 0.841588 -0.127386 -0.237218 -0.267186 -0.539198 0.835759 -0.143418 0.496218 0.887615 0.191628 0.011726 -0.612239 0.722732 -0.991602 0.938142 -0.612137 -0.577649 0.191369 -0.198359 0.337475 0.755205 0.683654 -0.318641 -0.814741 -0.354751 0.276257 0.469693 0.801805 -0.420187 0.880092 -0.544351 -0.948063 -0.889987 0.198598 -0.517903 -0.352606 -0.663604 -0.191808 -0.767415 -0.712906 0.924699 -0.850674 -0.237297 -0.047403 0.885741 -0.631553 0.768862 -0.094846 0.448006 -0.666459 -0.850386 0.514580 0.225037 0.511035 0.964534 -0.769372 0.838413 0.741093 0.377443 0.167837 0.877026 -0.054752 0.586836 -0.861511 1.030824 -0.288593 -0.124961 0.009157 -0.927185 0.163383 0.645894 -0.013717 -0.492535 -0.082090 0.437620 0.389280 -0.586666 0.905444 -0.102217 0.591427 -0.168941 0.306715 0.219495 -0.472513 -0.146685 0.752590 0.629396 0.714907 -0.507356 -0.442117 0.799056 0.422576 0.662410 -0.341174 -0.732367 0.014039 -0.183894 0.905125 -0.870456 -0.053268 -0.141515 -0.799646 0.336566 -0.304144 0.389935 0.399830 0.307027 -0.871155 0.107846 0.738408 -0.473227 0.903561 -0.708458 0.732745 -0.039953 -0.750947 0.595806 0.272676 0.007716 0.005802 0.007590 0.079344 0.221588 -0.936127 -0.035027 0.033764 -0.726372 -0.868892 0.770707 -0.383408 -0.651714 0.527250 -0.719737 0.519993 0.226575 0.223677 -0.873550 0.461070 0.964642 -0.617656 -0.035337 -0.800003 -0.139782 0.456176 0.867699 -0.523192 0.078855 0.641942 -0.831683 0.649701 -0.186292 0.569982 -0.772489 -0.286347 -0.113877 -0.219001 0.574600 0.095286 0.790223 0.375659 0.208137 0.644267 -0.013565 0.348413 -0.089854 0.753366 0.482545 0.088959 0.879933 -0.175976 0.137202 0.015772 0.222959 -0.016971 -0.184196 0.277924 0.739236 -0.669637 -0.868483 0.795679 0.675602 0.826275 0.073079 0.690996 0.894373 0.004910 0.425706)

      ;; pp: 
	16.350377 (fv 0.000000 0.552796 0.999754 1.596338 0.126332 0.673759 1.143594 1.786231 0.239358 0.837076 1.376094 -0.027483 0.557207 1.197707 1.840730 0.374019 1.046415 1.758004 0.340195 0.989599 1.620624 0.260723 0.941286 1.573013 0.271552 0.902927 1.633570 0.349820 1.063867 1.825055 0.557595 1.306577 0.088807 0.790267 1.529892 0.294932 1.020408 1.744984 0.604757 1.412603 0.281886 1.100728 1.889905 0.686280 1.553865 0.453907 1.302529 0.100750 0.984465 -0.035558 0.826606 1.720865 0.586422 1.445731 0.436162 1.366180 0.314278 1.261198 0.174270 1.139476 0.076878 0.981955 0.014752 1.001254 0.023464 1.025553 0.021016 1.003733 0.047800 1.070120 0.227544 1.225662 0.275497 1.290238 0.339903 1.445648 0.643098 1.696622 0.736906 1.856892 0.946479 0.080466 1.251303 0.348155 1.578331 0.792557 1.845915 0.951067 0.268564 1.510384 0.657787 1.813775 1.031959 0.320499 1.463662 0.701523 0.024031 1.255492 0.480762 1.684919 1.051974 0.424109 1.601000 0.892871 0.243024 1.614521 1.010751 0.221241 1.491807 0.862210 0.215650 1.557126 0.968758 0.385009 1.808699 1.162553 0.511515 1.916283 1.311004 0.789593 0.295563 1.706075 1.087230 0.543068 0.069395 1.561470 0.989040 0.453388 -0.108044 1.480909 1.040634 0.572985 0.051211 1.625308 1.183041 0.686760 0.302383 1.860622 1.529645 0.987474 0.557505 0.084969 1.853756 1.336365 0.952019 0.595441 0.210294 1.971086 1.605010 1.282084 1.025620 0.569157 0.327228 1.866582 1.606594 1.434632 1.017654 0.911350 0.391676 0.232063 0.001884 1.730059 1.574735 1.286832 1.121780 0.801569 0.646973 0.508234 0.242177 0.255472 1.901657 1.795256 1.544468 1.353518 1.252299 1.049061 0.957214 0.842369 0.785364 0.631556 0.708280 0.450967 0.377024 0.408728 0.166649 0.302099 0.202780 0.096226 0.047151 -0.060241 -0.054511 -0.141528 0.011242 -0.035439 -0.105943 -0.008495 0.261657 -0.027784 0.212454 0.144202 0.244055 0.276291 0.439789 0.497793 0.528548 0.655999 0.693233 0.786857 0.888896 1.103132 1.128106 1.412355 1.557348 1.790407 1.883313 0.127747 0.354527 0.531053 0.664039 0.693143 1.026705 1.248860 1.533013 1.656903 -0.153410 0.211226 0.477106 0.861202 1.107385 1.382365 1.702920 1.856715 0.292313 0.666914 1.015054 1.228045 1.584336 1.886548 0.103276 0.465850 0.933761 1.404258 1.699106 0.163965 0.511514 0.978218 1.466876 1.813824 0.330510 0.850353 1.126689 1.666255 0.008649 0.560148 1.018515 1.617664)
      )

;;; 512 all -------------------------------------------------------------------------------- (22.627)
(vector 512 34.212551772691 (fv 0 0 1 1 0 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1)

      ;; from (try-all :all 512 513 1.0491155462743 0.38189660798029) = 28.3830
	23.664022 (fv 0.000000 0.427568 1.639326 1.360155 1.811218 1.092160 0.747868 1.186461 0.447302 0.141557 0.619324 1.833463 1.544347 0.007451 1.194940 0.942391 1.467079 0.598818 0.341862 0.856599 -0.009623 1.790305 0.303605 1.433809 1.210097 1.744422 0.850431 0.701542 1.184133 0.353157 0.158700 0.631775 1.816582 1.649038 0.151955 1.319099 1.140756 1.686037 0.836885 0.603284 1.210040 0.328240 0.128897 0.747775 1.857031 1.647146 0.229954 1.360640 1.181891 1.738203 0.916825 0.772560 1.263892 0.487557 0.357369 0.837989 0.072479 1.952904 0.462538 1.655604 1.530780 0.044826 1.188380 1.093422 1.643465 0.760457 0.671146 1.165553 0.382517 0.270309 0.819071 0.053545 1.937012 0.495125 1.742677 1.542501 0.125650 1.325748 1.210027 1.732088 0.935701 0.824564 1.323484 0.585708 0.506420 1.029721 0.338323 0.187075 0.760806 0.050676 1.850037 0.464992 1.677973 1.565113 0.144103 1.317521 1.321113 1.874238 1.016306 1.069091 1.608386 0.796518 0.769622 1.333499 0.614032 0.483343 1.064146 0.380172 0.255809 0.868411 0.110092 0.019745 0.602426 1.831203 1.791424 0.362161 1.643680 1.595486 0.149263 1.495555 1.407870 1.984422 1.287342 1.186467 1.794990 1.091502 0.997302 1.627715 0.925839 0.869778 1.436400 0.757469 0.721612 1.297170 0.565566 0.560684 1.139226 0.428000 0.421240 0.966706 0.319226 0.330813 0.889093 0.219241 0.195335 0.812296 0.094799 0.052902 0.683712 0.010896 1.971130 0.608327 1.935753 1.931121 0.569627 1.867175 1.867249 0.441783 1.801138 1.790921 0.371408 1.777986 1.738617 0.401066 1.733047 1.661490 0.354101 1.627871 1.606589 0.288724 1.577834 1.666020 0.321728 1.651393 1.656482 0.323319 1.730257 1.617220 0.293458 1.714829 1.659553 0.344931 1.670147 1.687943 0.352602 1.662557 1.707106 0.369928 1.772978 1.748463 0.482487 1.829720 1.820057 0.586300 1.834899 1.928514 0.630781 1.937126 0.006886 0.678213 0.089703 0.093158 0.772429 0.211946 0.205897 0.907314 0.295511 0.339317 1.025320 0.390289 0.436223 1.172670 0.563140 0.575421 1.326146 0.743539 0.740636 1.478962 0.859750 0.923341 1.622809 0.996123 1.103566 1.788348 1.176067 1.280213 -0.047092 1.383754 1.395483 0.152500 1.517048 1.632989 0.388897 1.741484 1.847120 0.652366 0.024054 0.131465 0.878250 0.336434 0.307596 1.072008 0.542503 0.578597 1.334996 0.751250 0.821777 1.656098 1.025574 1.190055 1.955170 1.316203 1.418474 0.154347 1.615247 1.696950 0.413353 1.897018 -0.040080 0.750302 0.194941 0.311683 1.127700 0.508014 0.639251 1.420913 0.883930 0.954476 1.736379 1.219406 1.363982 0.067216 1.594026 1.696195 0.520754 1.968937 0.073197 0.846293 0.295874 0.412637 1.264631 0.683696 0.770777 1.578119 1.049706 1.256677 0.075650 1.516235 1.661663 0.486701 1.923042 0.102476 0.897895 0.421239 0.520799 1.398872 0.764863 0.918394 1.741709 1.285842 1.432958 0.285406 1.740186 1.875561 0.693279 0.189999 0.363512 1.130608 0.742662 0.877597 1.690466 1.167157 1.260179 0.095687 1.647656 1.862836 0.750171 0.242633 0.398738 1.269810 0.693295 0.943617 1.819562 1.329456 1.523078 0.289946 1.903623 0.046720 0.919252 0.382106 0.589683 1.382685 1.026289 1.195161 0.073095 1.610391 1.738812 0.696675 0.192997 0.388398 1.259408 0.742094 1.024183 1.864212 1.458122 1.534179 0.402744 -0.061224 0.271156 1.098904 0.634032 0.812991 1.726192 1.349800 1.524054 0.405111 1.914339 0.225666 1.134052 0.737598 0.871970 1.836536 1.374934 1.616164 0.466416 0.050312 0.256071 1.130926 0.806016 0.967517 1.857501 1.430024 1.677286 0.624674 0.171527 0.493105 1.331230 0.893429 1.180472 0.103949 1.752760 1.965087 0.889376 0.401019 0.670116 1.685650 1.210490 1.475318 0.371575 0.023405 0.308232 1.175094 0.785590 1.015636 -0.029618 1.589597 1.841867 0.744953 0.423044 0.654663 1.649721 1.235327 1.552140 0.505770 0.153285 0.430626 1.295928 0.916060 1.261458 0.277022 1.879571 0.086016 1.069989 0.709985 0.993888 -0.020550 1.578106 1.903961 0.873960 0.405819 0.766821 1.720050 1.395240 1.689328 0.591580 0.237019 0.518171 1.489451 1.175876 1.436552 0.419316 0.110972 0.456395 1.431851 1.135703 1.433153 0.412157 0.047498 0.368496 1.359894 0.994487 1.371051 0.374236 -0.007165 0.356413 1.341081 0.997966 1.348371 0.388959 0.042648 0.317800 1.336452 1.006864 1.349497 0.415416 0.057830 0.422080 1.335388 1.091374 1.397964 0.381417 0.219147 0.454116 1.473546 1.128064 1.458934 0.561157 0.201897 0.582036 1.638190 1.188476 1.678318 0.658219 0.380328 0.735596 1.749438 1.526079 1.911184 0.877724 0.628235 0.991698 0.058067 1.723282 0.138422 1.198701 0.866452 1.210404 0.321220 0.058540 0.420700 1.466851 1.211297 1.555352 0.603793 0.342675 0.773740 1.815254 1.579109 1.942762 1.000717 0.737614 1.114407 0.230063 0.006013 0.382590 1.515868 1.246214 1.651494 0.773676 0.514207 0.940214 0.045277)
      )

;;; 1024 all -------------------------------------------------------------------------------- (32)
(vector 1024 54.490282136658 (fv 0 0 0 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 0)

       ;; from (try-all :all 1024 1025 0.0030465754082342 1.0966230312279) = 39.6408 -- starting point for next
	33.410875 (fv 0.000000 0.258148 0.589168 0.994411 1.357701 1.683025 0.069074 0.453421 0.797628 1.185816 1.582436 1.938092 0.307108 0.753155 1.054506 1.465084 1.815186 0.241264 0.539120 0.935358 1.344730 1.757342 0.087826 0.560243 0.909870 1.313450 1.644065 0.104593 0.476633 0.874522 1.288326 1.742330 0.203193 0.590704 1.014919 1.387211 1.858546 0.251755 0.613119 1.088831 1.500246 1.956678 0.355205 0.836294 1.268025 1.705878 0.108690 0.586645 1.046489 1.430729 1.904826 0.322624 0.787698 1.277011 1.718145 0.125412 0.585092 1.047194 1.448174 1.936035 0.420374 0.902587 1.333104 1.856924 0.327896 0.858579 1.268399 1.749900 0.253263 0.677442 1.219161 1.714857 0.177166 0.633557 1.169787 1.640415 0.140512 0.621582 1.091651 1.607728 0.104564 0.583756 1.118053 1.652294 0.153513 0.714859 1.194251 1.697620 0.276971 0.782347 1.313258 1.816056 0.294830 0.852045 1.367731 1.912889 0.443181 0.976528 1.489519 0.048647 0.602555 1.171111 1.696946 0.267367 0.808494 1.328988 1.847036 0.429147 0.989539 1.554476 0.119989 0.631320 1.259112 1.823414 0.393440 0.968836 1.504033 0.126560 0.727472 1.269985 1.846490 0.405486 1.041942 1.582030 0.184859 0.803907 1.384064 0.001185 0.565238 1.185485 1.799966 0.388364 0.991281 1.615016 0.210322 0.777733 1.381829 -0.001858 0.601802 1.237656 1.865352 0.533475 1.133402 1.742192 0.420236 1.017900 1.625681 0.265207 0.907047 1.531875 0.165179 0.869961 1.486073 0.135412 0.775460 1.391805 0.032701 0.662061 1.355447 -0.029896 0.673845 1.349264 0.011611 0.729065 1.361114 0.013249 0.666596 1.353522 -0.007100 0.647754 1.363243 0.014621 0.674314 1.412588 0.079158 0.792604 1.491853 0.154571 0.839031 1.536947 0.216086 0.941461 1.657001 0.337150 1.060668 1.746479 0.482706 1.226119 1.946733 0.643851 1.336905 0.013042 0.754294 1.496162 0.232890 0.988475 1.681309 0.448137 1.146402 1.881464 0.552981 1.297819 0.098645 0.832913 1.606715 0.332666 1.035466 1.818940 0.554955 1.343968 0.085509 0.792214 1.558162 0.368596 1.106235 1.895172 0.644633 1.405521 0.165480 0.925201 1.747451 0.473692 1.324609 0.053177 0.850917 1.628773 0.424746 1.258663 0.036370 0.797966 1.564071 0.352485 1.148447 -0.002783 0.797088 1.561969 0.392501 1.189092 -0.019088 0.843646 1.634513 0.453206 1.275296 0.054828 0.916548 1.733451 0.558960 1.389762 0.203638 1.054862 1.897500 0.708809 1.574733 0.423071 1.215266 0.027342 0.899322 1.791858 0.620622 1.492274 0.320845 1.174701 0.051833 0.913009 1.796449 0.665146 1.471491 0.328743 1.193965 0.076732 0.978576 1.811604 0.666355 1.562427 0.437112 1.309285 0.223487 1.113773 0.007247 0.849622 1.753745 0.664875 1.576770 0.455394 1.360922 0.282060 1.150668 0.049047 0.927118 1.816088 0.739465 1.705374 0.642039 1.518132 0.405444 1.340122 0.312878 1.226245 0.139772 1.077510 -0.018816 0.936435 1.857875 0.823248 1.722658 0.669787 1.630579 0.550282 1.483551 0.473002 1.439850 0.374042 1.322563 0.264157 1.241756 0.176119 1.137549 0.127690 1.073354 0.045113 0.987362 -0.009728 0.938618 1.894769 0.930534 1.889094 0.819648 1.834591 0.887814 1.825305 0.751612 1.788639 0.781856 1.799187 0.761171 1.765995 0.797679 1.787953 0.747401 1.771597 0.793400 1.786941 0.805798 1.801885 0.838640 1.863755 0.878598 1.883687 0.921909 -0.012600 0.953576 0.028661 1.053164 0.071002 1.090274 0.114661 1.146587 0.180317 1.267377 0.271949 1.348847 0.373158 1.422115 0.472335 1.601819 0.584885 1.638612 0.781047 1.776789 0.821569 1.888293 0.973656 0.059587 1.102322 0.189225 1.264548 0.323677 1.429081 0.526711 1.594088 0.678108 1.711258 0.856227 1.948913 1.030332 0.171134 1.248971 0.337083 1.456252 0.496413 1.599787 0.743435 1.845411 0.979199 0.069456 1.191262 0.312034 1.362623 0.533174 1.673105 0.803847 1.903793 1.042569 0.150816 1.299359 0.434192 1.602414 0.715947 1.838326 1.018218 0.157768 1.253948 0.407857 1.573899 0.779851 1.904361 1.060636 0.223176 1.356991 0.495392 1.680203 0.833630 0.009780 1.167530 0.315957 1.492554 0.654024 1.856891 1.023069 0.220534 1.440206 0.582264 1.748500 0.970294 0.123193 1.307613 0.556564 1.730012 0.926711 0.113171 1.343735 0.556253 1.746273 0.934223 0.123997 1.384091 0.614003 1.782610 1.015379 0.224947 1.465548 0.684093 1.908440 1.124583 0.358057 1.642940 0.875505 0.064339 1.292308 0.557537 1.782713 1.008802 0.272821 1.511713 0.764842 0.030194 1.274549 0.483182 1.727237 1.016792 0.261776 1.522862 0.796446 0.042895 1.304520 0.619998 1.876690 1.148478 0.428322 1.679455 1.004325 0.300377 1.550416 0.835254 0.173352 1.448704 0.698650 -0.033801 1.272024 0.597214 1.859218 1.200705 0.517289 1.763401 1.106977 0.387334 1.700638 1.066989 0.326662 1.604820 0.962763 0.281408 1.585892 0.935892 0.271981 1.571275 0.916662 0.291788 1.570649 0.930716 0.269192 1.579444 0.969565 0.290012 1.615565 0.990795 0.311402 1.657094 0.994116 0.432873 1.757318 1.056873 0.417532 1.795268 1.185595 0.580763 1.918349 1.267276 0.656331 0.049168 1.401813 0.749992 0.176783 1.556953 0.966950 0.314017 1.682209 1.095751 0.473881 1.821750 1.291249 0.673330 0.057423 1.460592 0.890407 0.273536 1.708953 1.094797 0.541733 1.932285 1.354523 0.747235 0.170227 1.592085 1.015544 0.439882 1.847343 1.288875 0.701630 0.111506 1.621007 1.032815 0.491968 1.882621 1.348432 0.738302 0.277658 1.682524 1.144243 0.582029 0.024994 1.499949 0.920010 0.401061 1.889106 1.372403 0.804920 0.264480 1.729722 1.190624 0.695948 0.173617 1.607894 1.119209 0.625052 0.097713 1.558780 1.044363 0.564907 0.006836 1.535288 0.979484 0.498306 0.016897 1.518916 1.048287 0.505482 0.034846 1.537224 1.038826 0.583381 0.066441 1.582671 1.095360 0.652592 0.165653 1.666405 1.195978 0.749638 0.244931 1.794728 1.302261 0.855517 0.402763 1.919243 1.506054 0.990141 0.529140 0.090161 1.628924 1.232711 0.756188 0.320069 1.866574 1.434290 1.010093 0.586649 0.125842 1.632778 1.248832 0.786217 0.395146 1.983594 1.522744 1.184214 0.725738 0.283806 1.853291 1.411973 1.029503 0.623510 0.190003 1.817951 1.405723 0.998692 0.625566 0.196526 1.824631 1.367636 1.002432 0.638505 0.270362 1.867749 1.456887 1.107903 0.666557 0.365450 1.943932 1.534564 1.164468 0.812181 0.417778 0.109315 1.746468 1.348757 1.018766 0.607455 0.251719 1.902085 1.522432 1.168361 0.826689 0.501772 0.186624 1.829613 1.504989 1.149945 0.826038 0.430311 0.156773 1.805915 1.442117 1.129384 0.789359 0.448838 0.128070 1.860262 1.509251 1.221965 0.897472 0.558148 0.251257 1.927642 1.640546 1.338781 1.036792 0.710068 0.403207 0.109563 1.811625 1.572455 1.213598 0.939472 0.623448 0.409350 0.066783 1.811153 1.483733 1.240294 0.962497 0.677702 0.428980 0.151873 1.860959 1.600097 1.372939 1.073698 0.858833 0.549541 0.358709 0.048040 1.780703 1.499339 1.321408 1.026078 0.811519 0.563815 0.272950 0.101217 1.778901 1.584563 1.357171 1.096114 0.901285 0.691896 0.423414 0.187540 0.012408 1.741503 1.538220 1.375071 1.132353 0.924933 0.712966 0.501385 0.301492 0.064052 1.847152 1.740905 1.454340 1.287762 1.094301 0.900958 0.693746 0.504913 0.275695 0.137705 -0.008305 1.750189 1.585524 1.414196 1.262553 1.013251 0.925388 0.715978 0.553457 0.407454 0.213702 0.088434 1.972600 1.762556 1.622037 1.422263 1.305690 1.086572 0.965745 0.818250 0.679809 0.548833 0.434281 0.274574 0.162711 -0.016721 1.874108 1.711171 1.634760 1.470116 1.433824 1.198309 1.122645 0.994884 0.863715 0.716974 0.651737 0.505774 0.376030 0.305317 0.172395 0.043840 1.956668 1.879928 1.790226 1.657792 1.628858 1.503591 1.453387 1.399691 1.283663 1.175444 1.093586 1.015878 0.867180 0.833771 0.733456 0.751208 0.644973 0.524402 0.519350 0.448915 0.402270 0.223991 0.272710 0.178576 0.121816 0.014901 -0.008456 0.000722 1.948116 1.864026 1.799285 1.772492 1.761973 1.729645 1.648114 1.613644 1.601091 1.593669 1.506616 1.533589 1.464454 1.452519 1.424863 1.443072 1.448035 1.385776 1.402879 1.416069 1.400653 1.366739 1.389222 1.353373 1.316055 1.338545 1.366489 1.376447 1.387658 1.386874 1.383521 1.414816 1.478876 1.431144 1.443821 1.476250 1.453501 1.470783 1.513891 1.537062 1.574083 1.565440 1.667183 1.688265 1.726029 1.812251 1.818225 1.909534 1.893859 1.960853 -1.792261 0.049720 0.115471 0.168584 0.227816 0.312337 0.320765 0.432479 0.460834 0.497553 0.618812 0.667533 0.714551 0.786901 0.873018 0.948666 1.026741 1.049685 1.177075 1.308478 1.411491 1.456896 1.608694 1.673563 1.762266 1.858920 1.974208 0.033942 0.165671 0.243992 0.350794 0.473925 0.585735 0.737599 0.804002 0.963652 1.066959 1.216838 1.312134 1.446813 1.594176 1.676806 1.816313 1.965577 0.113977 0.201793 0.324796 0.449133 0.633633 0.769013 0.895692 1.061461 1.163832 1.372251 1.483231 1.640906 1.802011 -0.030958 0.155600 0.377255 0.507459 0.640650 0.847956 1.016719 1.214303 1.427027 1.567855 1.764212 1.940432 0.043642 0.292095 0.470854 0.648508 0.820657 1.060906 1.222563 1.354202 1.598601 1.737516 -0.028100 0.202713 0.374375 0.584831 0.817057 1.020703 1.253416 1.457146 1.644498 1.875195 0.140343 0.371551 0.579412 0.847798 1.090746 1.313318 1.565314 1.779179 -1.706782 0.198770 0.511497 0.711566 0.950424 1.152889 1.372135 1.700365 1.869801 0.181432 0.440942 0.691235 0.983921 1.186243 1.477055 1.750551 0.035866 0.314930 0.558441 0.801324 1.080423 1.361289 1.616783 1.906440 0.211190 0.450778 0.806041 1.119162 1.408538 1.703492 0.007343 0.317836 0.612325 0.935395 1.211907 1.545362 1.855618 0.133582 0.501303 0.746887 1.072480 1.396132 1.651845 -0.008716 0.328392 0.710493 1.027135 1.346260 1.695106 0.085660)
       )

;;; 2048 all -------------------------------------------------------------------------------- (45.254)
(vector 2048 89.570060996356 (fv 0 1 1 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 1 0)

       ;; from (try-all :all 2048 2049 1.0476749041086 0.34832901677121) = 55.7655 start for next
	50.205430 (fv 0.000000 0.435841 1.590025 1.333909 1.800782 0.936896 0.640772 1.054371 0.276465 0.022204 0.420173 1.637156 1.317845 1.822696 0.936038 0.684182 1.165979 0.256451 0.034146 0.530882 1.581638 1.361041 1.855482 0.981545 0.775560 1.219427 0.308786 0.074234 0.592840 1.697019 1.456943 1.894603 1.053571 0.870395 1.260578 0.415941 0.216750 0.664998 1.768556 1.530284 0.017758 1.155044 0.880167 1.399032 0.522236 0.296590 0.788933 1.883168 1.702734 0.130840 1.241124 1.015672 1.506862 0.618786 0.413989 0.882191 0.040812 1.770208 0.266965 1.415350 1.179212 1.617452 0.837073 0.560382 1.039153 0.189709 0.008982 0.428192 1.582302 1.375969 1.775847 1.001684 0.722251 1.221935 0.371046 0.124429 0.658497 1.801753 1.557144 0.055429 1.167445 0.965998 1.463160 0.590632 0.421360 0.870506 1.979716 1.785918 0.217687 1.423155 1.229053 1.677639 0.820116 0.622279 1.118801 0.227079 0.047207 0.530002 1.646116 1.495215 1.938348 1.092314 0.858748 1.368355 0.507435 0.300967 0.831830 1.945902 1.701826 0.241789 1.346179 1.176339 1.698123 0.782522 0.593683 1.099893 0.220752 0.071121 0.492713 1.698729 1.537108 0.003593 1.112312 0.923924 1.420945 0.591862 0.368816 0.876237 0.024325 1.841665 0.349974 1.496560 1.313963 1.781383 0.909134 0.778966 1.228602 0.360482 0.169252 0.720535 1.827819 1.642014 0.151850 1.298858 1.132119 1.583582 0.775812 0.613883 1.034899 0.197663 0.038469 0.550873 1.681101 1.473296 0.002756 1.168244 0.976999 1.468806 0.641511 0.472463 0.917530 0.115543 1.932746 0.461045 1.615860 1.421110 1.916591 1.100326 0.915266 1.450442 0.570898 0.409829 0.895347 0.064350 1.886870 0.368337 1.508665 1.402167 1.875808 1.089074 0.915502 1.348721 0.569668 0.334905 0.845366 0.062665 1.931036 0.423161 1.570481 1.376249 1.892683 1.058012 0.892579 1.382946 0.530863 0.389584 0.911546 0.066065 1.944943 0.431750 1.524837 1.397825 1.916894 1.103011 0.925384 1.421598 0.609580 0.450668 0.957299 0.103861 0.017005 0.489835 1.632099 1.491083 0.040341 1.187478 1.048136 1.580660 0.750188 0.526672 1.095701 0.287178 0.103106 0.633176 1.805673 1.635672 0.181746 1.340109 1.155467 1.751104 0.863186 0.725371 1.256183 0.417821 0.247907 0.731305 1.971687 1.812887 0.362885 1.544484 1.346445 1.843347 1.064098 0.903511 1.425141 0.615217 0.470411 0.992301 0.186866 0.055090 0.515270 1.737073 1.613907 0.129315 1.316755 1.145516 1.689159 0.887610 0.688556 1.250192 0.483418 0.277491 0.831631 -0.015312 1.878418 0.427015 1.584482 1.443552 1.963597 1.131045 1.053018 1.569404 0.748022 0.602632 1.105250 0.310334 0.191836 0.693611 1.868001 1.741296 0.244951 1.472171 1.322184 1.879876 1.046328 0.929137 1.487162 0.690252 0.536393 1.028834 0.241099 0.137310 0.681359 1.872418 1.703102 0.276974 1.417116 1.322284 1.892467 1.055982 0.931972 1.453120 0.680784 0.569223 1.072473 0.292525 0.179779 0.702639 1.907779 1.763892 0.296945 1.502504 1.403596 1.895642 1.078898 1.020313 1.582828 0.728374 0.631181 1.177822 0.386973 0.229679 0.763366 -0.020603 1.884762 0.449056 1.615978 1.445670 0.076665 1.319406 1.139316 1.687368 0.868342 0.754364 1.316715 0.562902 0.373746 0.962616 0.143265 0.060537 0.597136 1.794156 1.674512 0.244828 1.423610 1.307469 1.861513 1.128650 1.011922 1.509496 0.793005 0.646450 1.183857 0.401441 0.274501 0.848007 0.152648 1.938838 0.515464 1.751327 1.585203 0.128719 1.344067 1.257980 1.813937 1.034672 0.961830 1.482792 0.710147 0.627952 1.158173 0.396545 0.308224 0.839308 0.084640 1.949979 0.467374 1.766014 1.652675 0.156038 1.404099 1.323696 1.916673 1.129204 1.007203 1.565692 0.792625 0.676519 1.246538 0.476588 0.355046 0.897504 0.154095 0.032713 0.616322 1.822050 1.713319 0.339487 1.549436 1.415806 -0.029700 1.251496 1.105739 1.706293 0.927616 0.827632 1.429701 0.652859 0.511881 1.153658 0.364245 0.227734 0.828965 0.039610 1.955264 0.489121 1.779904 1.680272 0.264792 1.492297 1.379563 1.958496 1.182126 1.073866 1.647475 0.887025 0.759908 1.352711 0.598690 0.504193 1.064292 0.364855 0.256068 0.821048 0.072182 1.978457 0.553596 1.801077 1.686861 0.245374 1.501095 1.463244 0.048757 1.270724 1.195638 1.795159 0.991907 0.929823 1.498115 0.775504 0.635637 1.221022 0.502033 0.392861 1.015769 0.238715 0.139376 0.772010 -0.001203 1.966386 0.502478 1.754699 1.653913 0.238134 1.455433 1.421962 0.005716 1.237219 1.195953 1.785244 1.034444 0.946973 1.522226 0.772000 0.724085 1.279219 0.566698 0.471639 1.081117 0.318698 0.216243 0.869842 0.093780 0.035928 0.580682 1.866189 1.774688 0.335441 1.640447 1.567092 0.150911 1.385331 1.332318 1.956070 1.197687 1.107245 1.722318 0.935373 0.939612 1.481560 0.775194 0.705562 1.294862 0.556921 0.470799 1.085453 0.374791 0.241371 0.872640 0.127624 0.032808 0.648015 1.958410 1.857207 0.450764 1.687826 1.673077 0.276455 1.524057 1.465118 0.092578 1.331259 1.262485 1.865029 1.129716 1.070468 1.691226 0.954621 0.907368 1.547298 0.800536 0.754442 1.318798 0.655491 0.523948 1.167921 0.458202 0.394916 0.974268 0.209530 0.172260 0.769859 0.045732 -0.027787 0.639418 1.895968 1.831369 0.455565 1.755348 1.702164 0.323430 1.549605 1.507505 0.099809 1.366067 1.343189 1.936579 1.213931 1.207459 1.780054 1.037769 1.005956 1.688129 0.918293 0.876995 1.491983 0.755576 0.731170 1.306379 0.613008 0.560202 1.151819 0.453386 0.401075 1.052899 0.336562 0.307092 0.918155 0.200321 0.133534 0.755336 0.041372 -0.036174 0.643495 1.904976 1.892087 0.486352 1.795593 1.721679 0.369291 1.607795 1.576284 0.213583 1.494045 1.463382 0.080370 1.381980 1.326067 1.977786 1.247994 1.213791 1.878128 1.145632 1.125599 1.744040 1.003768 0.975298 1.655044 0.946812 0.902005 1.481429 0.838355 0.806420 1.384034 0.676425 0.687951 1.289459 0.584933 0.544028 1.143652 0.530696 0.446531 1.060469 0.381371 0.383221 0.985636 0.284345 0.259040 0.894751 0.181035 0.155719 0.802236 0.121624 0.058494 0.696055 -0.033257 -0.009001 0.631717 1.933686 1.907503 0.526027 1.815256 1.827541 0.422361 1.751874 1.770954 0.332622 1.681580 1.649270 0.311710 1.607800 1.583524 0.245744 1.540534 1.499654 0.148625 1.457370 1.373290 0.075021 1.394843 1.347459 -0.005752 1.303682 1.317955 1.926281 1.233373 1.253750 1.868046 1.183593 1.200479 1.828734 1.154318 1.138091 1.739705 1.063036 1.026015 1.760005 1.052209 0.997647 1.670582 1.013683 0.946378 1.618597 0.957911 0.901792 1.567409 0.889999 0.912144 1.559979 0.891151 0.880294 1.500532 0.874896 0.781828 1.470208 0.813331 0.808539 1.418100 0.746813 0.751008 1.419231 0.717221 0.726739 1.410727 0.731944 0.676864 1.409264 0.642315 0.664365 1.364908 0.686123 0.651596 1.257741 0.652814 0.617542 1.306260 0.604389 0.592953 1.273395 0.605575 0.615524 1.252456 0.600454 0.596734 1.273260 0.596265 0.607909 1.252575 0.565927 0.570637 1.242139 0.541616 0.579959 1.248588 0.553529 0.579117 1.248565 0.574621 0.589047 1.309100 0.589822 0.602557 1.287938 0.578939 0.630286 1.280033 0.567074 0.622654 1.240139 0.594827 0.651875 1.291451 0.614140 0.689991 1.288405 0.659401 0.658369 1.319440 0.687094 0.674513 1.346708 0.688976 0.753907 1.375336 0.762674 0.739012 1.414601 0.787609 0.775338 1.420075 0.806180 0.800733 1.486208 0.845147 0.821967 1.516891 0.910404 0.867286 1.542889 0.887043 0.903213 1.634817 0.952223 0.964661 1.682581 0.979874 1.017143 1.672617 0.994877 1.107400 1.788990 1.110961 1.073654 1.789664 1.138909 1.162757 1.815050 1.225817 1.210897 1.926791 1.302244 1.265372 -0.026931 1.330408 1.387907 0.023026 1.451566 1.422994 0.130173 1.484590 1.521586 0.183712 1.551561 1.583662 0.282642 1.591114 1.655077 0.304500 1.684251 1.694195 0.429792 1.769650 1.808357 0.487540 1.818396 1.853851 0.530630 1.955039 -0.119812 0.676604 0.023437 0.063422 0.780580 0.147218 0.198738 0.872448 0.220227 0.252425 0.986952 0.295255 0.393016 1.036257 0.448018 0.427099 1.156162 0.552881 0.530707 1.267911 0.635862 0.680452 1.365591 0.735775 0.797614 1.468054 0.829271 0.858249 1.597356 0.963427 0.979328 1.664777 1.072381 1.131497 1.848461 1.213953 1.199832 1.960555 1.304633 1.318228 0.076788 1.452570 1.479484 0.164500 1.572776 1.636533 0.356533 1.684649 1.726841 0.451773 1.812513 1.874046 0.543934 1.930798 1.972699 0.744026 0.063643 0.159361 0.823095 0.219497 0.299864 0.954777 0.358746 0.414413 1.115727 0.519760 0.542990 1.311137 0.651203 0.710761 1.454950 0.772652 0.872236 1.543810 0.968311 1.006341 1.723434 1.088664 1.231621 1.884135 1.281249 1.347331 0.036078 1.419412 1.446527 0.204240 1.613579 1.679100 0.340114 1.736107 1.840278 0.571743 1.943781 0.023224 0.697394 0.138951 0.151958 0.882054 0.266019 0.342269 1.098555 0.488882 0.520277 1.270261 0.682615 0.682051 1.423350 0.809398 0.923761 1.649263 1.068684 1.091760 1.803833 1.223733 1.263221 0.017517 1.421547 1.466248 0.224731 1.593966 1.649396 0.409457 1.781845 1.845835 0.622136 -0.009609 0.077538 0.792485 0.188358 0.288489 1.013605 0.431185 0.495730 1.211960 0.604816 0.676648 1.456905 0.844139 0.905285 1.630909 1.032426 1.128266 1.853145 1.262038 1.300211 0.056675 1.467598 1.530064 0.291293 1.687552 1.755257 0.468236 1.938565 -0.011915 0.736090 0.173114 0.213450 0.994156 0.364997 0.457458 1.187825 0.639595 0.686838 1.462796 0.854330 0.903639 1.704943 1.071752 1.179798 1.898999 1.338040 1.405342 0.147449 1.639838 1.676028 0.379818 1.815921 1.886234 0.634529 0.079207 0.176862 0.921077 0.270512 0.406031 1.127890 0.593242 0.648029 1.403498 0.841450 0.919674 1.687653 1.135150 1.209027 1.975682 1.393578 1.449497 0.153208 1.639075 1.709636 0.452445 1.874711 0.022432 0.714196 0.206678 0.205405 0.997873 0.413099 0.533511 1.297878 0.703835 0.801048 1.536439 0.962427 1.059551 1.860285 1.319040 1.383017 0.135002 1.534723 1.648532 0.422108 1.844915 1.956976 0.704238 0.117947 0.249102 1.002403 0.473197 0.500625 1.262507 0.728698 0.830758 1.550450 1.042097 1.137051 1.913071 1.319323 1.401617 0.205540 1.634001 1.717675 0.487628 1.929708 0.032724 0.779967 0.225924 0.383724 1.109069 0.562827 0.649848 1.460986 0.840877 0.966680 1.747337 1.203625 1.315331 0.088823 1.496248 1.629011 0.431806 1.822514 1.942005 0.728686 0.158211 0.297041 1.029719 0.522309 0.626677 1.357536 0.800226 0.986575 1.730215 1.163174 1.231016 0.034610 1.521930 1.589379 0.414306 1.841215 1.927232 0.696438 0.186996 0.290301 1.088563 0.519977 0.648216 1.417722 0.845987 1.012127 1.780754 1.219818 1.368384 0.133468 1.552692 1.697685 0.489975 1.948146 0.025352 0.835325 0.308902 0.425789 1.189446 0.647629 0.780553 1.534982 0.953650 1.144994 1.982784 1.383491 1.490496 0.239036 1.733469 1.907366 0.658487 0.109199 0.230682 1.052834 0.517391 0.608626 1.405419 0.866368 0.974067 1.812201 1.250521 1.390848 0.148194 1.623658 1.769017 0.559808 0.019981 0.093630 0.962157 0.385643 0.557254 1.332258 0.775494 0.936936 1.712764 1.224080 1.333572 0.130012 1.553976 1.733749 0.509265 0.048320 0.120671 0.899273 0.371543 0.562577 1.333084 0.820342 0.953357 1.769820 1.220433 1.358228 0.127107 1.579894 1.763318 0.586085 0.056061 0.168973 0.987419 0.437016 0.613035 1.379444 0.892129 1.014623 1.821313 1.267297 1.418105 0.246254 1.755013 1.842641 0.624100 0.156213 0.268757 1.103436 0.559665 0.758240 1.532549 1.036259 1.153852 1.946220 1.432069 1.593807 0.418226 1.855454 0.035725 0.832622 0.314591 0.476792 1.257265 0.773297 0.905003 1.712302 1.200651 1.350735 0.149477 1.642212 1.802991 0.603766 0.109674 0.272495 1.104655 0.552848 0.662208 1.508113 0.969884 1.222187 1.957345 1.483565 1.659081 0.418223 1.951257 0.147291 0.901050 0.444550 0.555960 1.394491 0.833321 1.009746 1.850858 1.330172 1.483655 0.313675 1.811415 -0.000236 0.794841 0.301262 0.490013 1.322742 0.745660 0.925074 1.784514 1.271636 1.375387 0.219194 1.716991 1.919514 0.731082 0.283071 0.394652 1.209183 0.703971 0.883949 1.723347 1.226581 1.417977 0.169502 1.728678 1.897967 0.751809 0.206641 0.351287 1.193966 0.679687 0.833001 1.679398 1.202836 1.369136 0.221180 1.698828 1.890944 0.736466 0.259414 0.428156 1.246968 0.715069 0.887462 1.766067 1.234005 1.366933 0.267319 1.785542 1.921115 0.782951 0.288312 0.432145 1.324227 0.812529 0.987537 1.849387 1.334204 1.550652 0.384742 1.887557 0.032221 0.888154 0.427508 0.583364 1.373198 0.935366 1.078859 1.962687 1.425781 1.648177 0.492137 0.010583 0.174236 1.065860 0.556317 0.711714 1.613293 1.102246 1.261519 0.161159 1.621868 1.845116 0.621649 0.151344 0.408750 1.266111 0.733611 0.981402 1.781143 1.313677 1.478251 0.389746 1.864238 0.058118 0.877935 0.412750 0.590919 1.454967 0.995341 1.160158 0.052979 1.551988 1.735067 0.575701 0.113408 0.309369 1.203349 0.691004 0.901203 1.755113 1.285355 1.469400 0.316179 1.835734 0.063761 0.937353 0.419020 0.615917 1.461648 1.030447 1.209615 0.096211 1.589011 1.815774 0.626322 0.175182 0.402805 1.254295 0.809294 0.981937 1.881195 1.349170 1.565323 0.444505 1.905301 0.141863 1.013394 0.599160 0.768860 1.639481 1.173121 1.378015 0.207298 1.781004 -0.005481 0.841053 0.359648 0.584036 1.466213 1.014043 1.198019 0.047150 1.611088 1.803839 0.693503 0.251733 0.378659 1.292988 0.846097 1.025550 1.895967 1.457063 1.643561 0.544671 0.078331 0.286831 1.144981 0.701288 0.911563 1.800290 1.360060 1.533921 0.464563 1.970167 0.187072 1.028247 0.574824 0.822213 1.719286 1.250441 1.465682 0.304625 1.883042 0.150589 0.966248 0.508969 0.740351 1.592154 1.164985 1.396695 0.251798 1.797977 0.055983 0.893992 0.460716 0.676688 1.575389 1.096148 1.354511 0.224581 1.739098 0.014063 0.882137 0.432033 0.697360 1.575477 1.060614 1.342466 0.184638 1.767539 1.986710 0.880248 0.447116 0.686853 1.534981 1.149302 1.322036 0.217110 1.750455 -0.028293 0.927727 0.463276 0.699948 1.574079 1.122276 1.344937 0.239499 1.798792 0.041111 0.901108 0.502016 0.734564 1.619516 1.235793 1.392027 0.313428 1.875178 0.114986 0.986008 0.554567 0.774672 1.670995 1.277666 1.490688 0.422851 1.938664 0.192686 1.081363 0.636062 0.878896 1.801674 1.320125 1.610705 0.510337 0.119965 0.288198 1.229365 0.736391 0.974652 1.921844 1.522756 1.760341 0.627784 0.195364 0.424026 1.350173 0.914137 1.149417 0.055182 1.641041 1.885754 0.774177 0.341638 0.609082 1.476268 1.075234 1.336728 0.232957 1.816024 0.059891 0.977615 0.583895 0.818725 1.691585 1.233407 1.522719 0.426347 -0.011898 0.222340 1.211913 0.738174 1.037566 1.889523 1.491590 1.769255 0.654387 0.200388 0.477881 1.388587 0.995612 1.263033 0.151400 1.737244 1.994853 0.888393 0.448480 0.715631 1.639779 1.266990 1.475739 0.402022 0.001228 0.277508 1.193996 0.717293 1.022382 1.945731 1.528880 1.769925 0.676796 0.308016 0.544866 1.452245 1.056044 1.374139 0.251435 1.839100 0.082677 1.030130 0.593594 0.869317 1.751919 1.380599 1.660743 0.544875 0.134766 0.419262 1.359116 0.926374 1.200425 0.154745 1.776244 0.028854 0.907934 0.517864 0.744877 1.733023 1.291145 1.589046 0.524515 0.143068 0.380331 1.270800 0.877957 1.158416 0.095496 1.721531 1.962074 0.894065 0.487382 0.748783 1.673707 1.270037 1.572661 0.487139 0.118310 0.353424 1.330880 0.967912 1.217091 0.192030 1.746726 -0.008521 0.972139 0.569214 0.836629 1.792874 1.387645 1.624565 0.632818 0.169837 0.496488 1.391429 1.038248 1.276246 0.204951 1.839860 0.124740 1.060001 0.657481 0.979959 1.891365 1.498561 1.801028 0.717400 0.315222 0.620564 1.593479 1.178952 1.451115 0.404598 -0.005528 0.313885 1.242306 0.875831 1.127959 0.103028 1.705375 0.012699 0.926034 0.577294 0.846113 1.771401 1.375194 1.686187 0.652973 0.275173 0.528957 1.475197 1.099695 1.450803 0.394864 0.006041 0.319714 1.201074 0.888068 1.130526 0.060555 1.730127 0.003973 0.970567 0.557199 0.876983 1.840537 1.453875 1.730436 0.638584 0.293627 0.612145 1.531639 1.167803 1.518469 0.454591 0.106958 0.368985 1.332865 0.982631 1.260304 0.220211 1.799722 0.130226 1.090090 0.701451 1.045234 1.992618 1.626535 1.912666 0.832021 0.542880 0.767909 1.778263 1.387748 1.677161 0.622205 0.269109 0.574635 1.558243 1.182994 1.450696 0.491452 0.103672 0.400119 1.344518 0.981223 1.258072 0.251476 1.912489 0.232691 1.206418 0.805953 1.119358 0.155055 1.751168 0.097851 1.025890 0.706010 0.960410 1.942316 1.626433 1.884328 0.851879 0.504554 0.821261 1.761778 1.407905 1.711340 0.647584 0.347790 0.647152 1.648746 1.244924 1.563845 0.588763 0.158974 0.503437 1.536265 1.121954 1.454121 0.423763 0.114434 0.400278 1.338609 0.993706 1.358821 0.328396 1.956735 0.261393 1.267373 0.955613 1.253328 0.224608 1.856628 0.199058 1.200999 0.819656 1.137486 0.135404 1.793163 0.131100 1.078350 0.741351 1.039393 0.045261 1.699515 0.034737 0.942610 0.684756 0.956308 1.947394 1.633657 1.953278 0.904052 0.580961 0.913879 1.941411 1.519052 1.840622 0.910119 0.527420 0.861293 1.849422 1.475381 1.830601 0.799091 0.501857 0.787766 1.823294 1.467731 1.806424 0.805269 0.474582 0.781946 1.776540 1.418537 1.762883 0.746070 0.408613 0.726389 1.745127 1.428283 1.754540 0.728069 0.441878 0.746600 1.796204 1.449997 1.776429 0.722670 0.436401 0.744719 1.778994 1.480572 1.763916 0.815336 0.489032 0.764749 1.811814 1.487438 1.838366 0.811299 0.501320 0.823771 1.854833 1.502868 1.856794 0.827719 0.514633 0.852477 1.882215 1.488580 1.848649 0.877645 0.587786 0.926814 1.877153 1.575992 1.906019 0.886676 0.595984 0.881146 1.940054 1.606287 1.971408 0.988642 0.638192 0.966941 -0.034374 1.681077 0.038373 1.056408 0.657252 1.076689 0.087476 1.760605 0.121715 1.145163 0.789531 1.173448 0.151127 1.823534 0.220276 1.230586 0.960040 1.285670 0.295263 1.934113 0.314088 1.332202 1.053238 1.375323 0.392866 0.077220 0.422213 1.491168 1.127803 1.497376 0.554172 0.257811 0.586449 1.609325 1.351152 1.703027 0.627074 0.353088 0.709213 1.720064 1.442884 1.782680 0.814896 0.553387 0.852715 1.895941 1.554321 1.962098 1.013833 0.655921 0.994618 0.054934 1.764435 0.062870 1.163046 0.871528 1.257156 0.223435 1.905372 0.338569 1.306277 0.999931 1.337253 0.417104 0.138892 0.412245 1.511698 1.256056 1.543124 0.590173 0.339601 0.650455 1.683826 1.408811 1.811474 0.828456 0.526423 0.859787 1.896452 1.608591 1.948197 0.987654 0.706760 1.085696 0.133347 1.825976 0.258446 1.274079 0.944752 1.296320 0.326958 0.024339 0.456524 1.468787 1.203458 1.509480 0.615416 0.269963 0.688191 1.723537 1.390152 1.854907 0.886894 0.581734 0.936911 -0.009509 1.698888 0.060556 1.142012 0.859242 1.247280 0.274968 1.947669 0.305504 1.435482 1.121364 1.480498 0.522708 0.241328 0.603319 1.705040 1.426237 1.816412 0.844853 0.559458 0.950007 -0.864208 1.718587 0.075844 1.114880 0.838172 1.221123 0.266618 0.058618 0.363782 1.417961 1.157081 1.554190 0.607338 0.348635 0.729484 1.765027 1.524808 1.887413 0.942863 0.666378 1.035608 0.084672 1.857745 0.236807 1.282523 1.041036 1.443839 0.463754 0.200441 0.623163 1.679375 1.373487 1.771844 0.850867 0.606126 0.995693 0.033893 1.821449 0.146087 1.202112 0.961147 1.370514 0.434572 0.169771 0.556607 1.637108 1.396269 1.729452 0.842038 0.609721 0.932603 0.015326)
       )


))

;; :all 65536 (320.768635104 1.6604741485419 0.83776099628482) 0.52033682944489
;; :all 65536 (309.91637906494 0.64007539845073 4.5547029008803e-05) 0.5172334495671 (0)
;; :all 65536 (303.64661814299 1.3570805366568 -4.6971909684279e-05) 0.5153905931919 (200)

;; :all 131072 (438.77509431894 1.4462367399126 2.0944027696821) 0.51631398987158  (sqrt: 362)



;;; ---------------------------------------- odd numbered harmonics ----------------------------------------

(define nodd-min-peak-phases (vector

(vector 1  1.0   (fv 0)
     )

(vector 2  1.539 (fv 0 0)
     )

;;; 3 odd --------------------------------------------------------------------------------
(vector 3  1.7548747062683 (fv 0 1 1)

     1.7393749801561 (fv 0.0 1.205686890924528215096600547440175432712E0 1.297035953235478072942399307976302225143E0)
     1.7387926578522 (fv 0.0 1.2094986438751 1.3025436401367)
     1.7387455701828 (fv 0.0 0.79018270969391 0.69699490070343)

     1.738745 (fv 0.000000 1.209826 1.303017)
     1.738744 (fv 0.000000 0.790172 0.696980)
     )

;;; 4 odd --------------------------------------------------------------------------------
(vector 4  2.19460272789 (fv 0 1 0 0)

     2.050 (fv 0 39/25 26/29 27/22)
     2.048743724823 (fv 0 111/256 281/256 195/256)
     2.0466175079346 (fv 0 223/512 563/512 49/64)

     2.045218 (fv 0.000000 1.563819 0.899661 1.233860)
     2.045217 (fv 0.000000 0.436172 1.100327 0.766122)
     )

;;; 5 odd -------------------------------------------------------------------------------- ; 2.2360679
(vector 5  2.7317879199982 (fv 0 1 1 0 0)

     2.3731805734023 (fv 0 7/16 7/4 5/8 7/16)

     2.307252 (fv 0.000000 0.393369 1.754476 0.596108 0.424804)
     2.307253 (fv 0.000000 1.606636 0.245540 1.403918 1.575230)
     )

;;; 6 odd -------------------------------------------------------------------------------- ; 2.44948
(vector 6  2.8638670444489 (fv 0 0 0 0 1 0)

     2.522759 (fv 0.000000 1.360421 1.129847 1.035439 1.320248 0.102465)
     2.522749 (fv 0.000000 0.639403 0.869779 0.964074 0.679243 -0.103102)
     )

;;; 7 odd -------------------------------------------------------------------------------- ; 2.64575
(vector 7  2.9204399585724 (fv 0 0 0 1 1 0 1)

     2.618497 (fv 0.000000 1.527527 0.524623 0.177241 0.453108 1.577456 1.970355)
     2.618376 (fv 0.000000 0.474123 1.477585 1.824644 1.552691 0.429533 0.035303)
     2.618302 (fv 0.000000 0.474154 1.477730 1.824846 1.552894 0.429720 0.035636)
     )

;;; 8 odd -------------------------------------------------------------------------------- ; 2.828427
(vector 8  3.2507002353668 (fv 0 1 1 0 1 1 1 0)

     2.8071956634521 (fv 0 109/128 7/4 1 13/16 123/64 21/128 43/128)

     2.790858 (fv 0.000000 0.802399 1.672681 0.887888 0.680265 1.767889 0.004580 0.126233)
     2.790799 (fv 0.000000 1.197514 0.327251 1.112061 1.319778 0.232086 -0.004810 -0.126263)
     2.790663 (fv 0.000000 1.196617 0.325818 1.109894 1.316877 0.229200 -0.008217 -0.130363)
     )

;;; 9 odd -------------------------------------------------------------------------------- ; 3
(vector 9  3.4140722751617 (fv 0 0 1 1 1 1 0 1 0)

     2.886575 (fv 0.000000 0.394663 0.625974 1.648922 0.070810 1.803585 1.908749 0.903752 0.378081)
     2.886464 (fv 0.000000 1.605518 1.374012 0.351118 1.929257 0.196622 0.091381 1.096286 1.622082)
     2.886241 (fv 0.000000 1.605727 1.374318 0.351747 1.930232 0.197770 0.092557 1.097753 1.623786)
     )

;;; 10 odd -------------------------------------------------------------------------------- ; 3.162277
(vector 10 3.5391488075256 (fv 0 0 1 1 0 1 0 0 0 0)

     3.054055 (fv 0.000000 0.508058 0.119325 0.663858 1.627094 1.847660 0.043999 1.283121 0.512586 0.295891)
     3.054035 (fv 0.000000 0.528914 0.163543 0.741593 1.737455 -0.019531 0.179460 1.441592 0.691200 0.513749)
     3.054019 (fv 0.000000 1.467927 1.828996 1.243932 0.242207 -0.005741 1.795358 0.528965 1.275954 1.445527)

     3.053923 (fv 0.000000 0.530606 0.167556 0.749983 1.748996 -0.005015 0.193787 1.458258 0.709754 0.536958)
     3.053807 (fv 0.000000 0.524885 0.155185 0.727764 -0.282439 -0.043214 0.155190 1.412864 0.658810 0.474600)
     3.053435 (fv 0.000000 0.525383 0.155614 0.727601 -0.282536 -0.043650 0.155330 1.412909 0.659050 0.474369)
     )

;;; 11 odd -------------------------------------------------------------------------------- ; 3.31662
(vector 11 3.6182308197021 (fv 0 0 0 1 1 1 0 1 1 0 1) ; 3.31662

     3.177383 (fv 0.000000 1.758655 0.386236 -0.008172 1.159122 0.785208 0.739625 0.606297 1.367332 0.311355 0.827147)
     3.177220 (fv 0.000000 0.232935 1.599549 -0.005436 0.822576 1.185453 1.230375 1.357659 0.594255 1.644007 1.122113)
     3.177201 (fv 0.000000 1.748294 0.370273 -0.021500 1.141958 0.751903 0.709536 0.566072 1.323348 0.262962 0.769859)

     3.177182 (fv 0.000000 1.764972 0.396592 0.001274 1.171590 0.806702 0.760785 0.632485 1.395663 0.343598 0.864498)
     3.177098 (fv 0.000000 1.745038 0.362715 -0.030740 1.128748 0.736155 0.690326 0.545405 1.303285 0.236832 0.743503)
     3.176608 (fv 0.000000 1.744464 0.362417 -0.030039 1.129933 0.735652 0.691339 0.545454 1.302582 0.237082 0.742494)
     )

;;; 12 odd -------------------------------------------------------------------------------- ; 3.464101
(vector 12 4.0 (fv 0 0 1 1 0 0 0 0 0 1 0 1)

     3.363698 (fv 0.000000 0.073271 0.585961 0.960666 0.978302 0.113696 1.500041 1.186734 1.772452 0.944338 1.321484 0.602060)
     3.362737 (fv 0.000000 -0.077029 1.405769 1.027930 1.006574 1.870564 0.481680 0.791450 0.202834 1.026360 0.648485 1.363973)
     3.361884 (fv 0.000000 -0.077168 1.405944 1.028559 1.007566 1.871331 0.482574 0.792122 0.203932 1.027727 0.649507 1.365630)
     )

;;; 13 odd -------------------------------------------------------------------------------- ; 3.60555
(vector 13 3.8778836727142 (fv 0 0 1 1 0 0 1 0 1 0 0 0 0) 

     3.476053 (fv 0.000000 0.380793 0.961293 0.353157 0.446308 0.965358 0.539394 0.172183 -0.067910 0.976833 -0.486927 1.072643 -0.036066)
     3.475486 (fv 0.000000 1.620375 1.040657 1.650169 1.557159 1.039441 1.466014 -0.165746 0.075570 1.032228 0.496820 0.937529 0.047188)
     3.475452 (fv 0.000000 1.620672 1.042066 1.652912 1.561748 1.044454 1.472771 -0.159565 0.082334 1.041828 0.507070 0.948164 0.058404)
     3.474532 (fv 0.000000 1.621213 1.042646 1.653413 1.561849 1.044891 1.473168 -0.158623 0.083544 1.042513 0.507800 0.949479 0.059341)
     )

;;; 14 odd -------------------------------------------------------------------------------- ; 3.741657
(vector 14 4.2842662512094 (fv 0 1 1 0 0 1 1 1 0 1 0 0 0 0)

     3.606512 (fv 0.000000 0.785150 1.482463 -0.077041 0.773052 0.357080 1.202237 -0.069790 1.584889 0.769902 0.652503 0.409520 0.740393 0.675317)
     3.600425 (fv 0.000000 1.139545 0.351170 -0.114733 0.966482 1.234831 0.292454 1.539190 0.009726 0.589539 0.769919 0.798632 0.417679 0.467195)
     3.599409 (fv 0.000000 0.851134 1.636505 0.091221 1.006010 0.744090 1.678264 0.418648 -0.048848 1.351639 1.174737 1.143087 1.519418 1.448182)
     3.598494 (fv 0.000000 0.850577 1.637081 0.089423 1.006545 0.749551 1.681409 0.420517 -0.044040 1.351533 1.177890 1.148728 1.524043 1.447267)
     )

;;; 15 odd -------------------------------------------------------------------------------- ; 3.872983
(vector 15 4.4701427567987 (fv 0 1 0 0 1 0 1 1 1 1 1 0 0 1 1)

     3.739752 (fv 0.000000 1.191367 0.176518 1.591145 1.710423 1.309889 1.422724 0.785426 1.754948 1.707551 1.122738 1.744847 0.127913 0.663567 0.776627)
     3.738430 (fv 0.000000 1.190239 0.174514 1.589466 1.706591 1.305812 1.416225 0.779885 1.746839 1.699566 1.113488 1.734421 0.117674 0.652032 0.763074)
     )

;;; 16 odd -------------------------------------------------------------------------------- ; 4
(vector 16 4.5778832343715 (fv 0 1 1 0 0 0 0 1 0 0 1 1 1 0 1 0)

     3.858242 (fv 0.000000 0.144652 0.676444 0.017002 0.269119 1.012194 1.772841 1.585260 1.809100 0.289620 1.399960 0.670537 0.175237 0.296937 -0.017357 1.108803)
     3.857020 (fv 0.000000 0.144607 0.675956 0.016527 0.269112 1.012147 1.772535 1.584482 1.808783 0.289484 1.400085 0.669674 0.174650 0.295492 -0.017769 1.108482)
     )

;;; 17 odd -------------------------------------------------------------------------------- ; 4.12310
(vector 17 4.5790815353394 (fv 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0)

     3.927805 (fv 0.000000 0.618908 0.864629 1.180783 1.677629 1.929621 0.580975 1.820904 0.468136 1.289907 0.485211 0.029658 1.160895 0.856998 0.644358 0.814931 0.296558)
     3.926355 (fv 0.000000 0.619515 0.864447 1.181990 1.677700 1.930862 0.582927 1.823955 0.470265 1.290931 0.488790 0.031736 1.163146 0.861017 0.648828 0.818286 0.301049)
     )

;;; 18 odd -------------------------------------------------------------------------------- ; 4.2426406
(vector 18 4.801501750946 (fv 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0)

     4.071185 (fv 0.000000 0.956640 1.083713 0.493342 0.797185 0.138960 0.613585 0.388904 -0.007616 0.968034 0.616152 1.753096 0.351362 1.174080 1.220111 1.511627 0.186455 1.775153)
     4.069528 (fv 0.000000 0.956814 1.082990 0.493213 0.796608 0.137780 0.611831 0.387091 -0.011186 0.965014 0.614046 1.752338 0.348807 1.169857 1.216059 1.508238 0.182073 1.770765)
     )

;;; 19 odd -------------------------------------------------------------------------------- ; 4.358898
(vector 19 4.8924918279945 (fv 0 1 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1)
     
     4.173923 (fv 0.000000 0.329738 1.407540 1.252167 0.448297 0.551162 1.341659 1.859617 1.357020 0.222879 0.553639 1.254187 0.641694 -0.208417 1.489583 1.646436 1.391179 1.758274 1.299312)
     4.171858 (fv 0.000000 0.330499 1.406874 1.250304 0.450026 0.551790 1.342413 1.858827 1.359366 0.223792 0.553485 1.256415 0.641759 -0.208630 1.490602 1.646088 1.388713 1.758053 1.297635)
     )

;;; 20 odd -------------------------------------------------------------------------------- ; 4.472135
(vector 20 5.043 (fv 0 1 0 1 0 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0)

     4.357980 (fv 0.000000 0.074668 -0.007236 0.182274 -0.090904 0.683075 1.087950 1.620610 1.402047 0.349796 1.096502 -0.498958 0.949574 -0.321894 1.411823 0.831379 -0.654670 0.294879 -0.284984 1.407225)
     )

;;; 21 odd -------------------------------------------------------------------------------- ; 4.5825756
(vector 21 5.1372244578347 (fv 0 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1)

     4.448460 (fv 0.000000 1.232455 0.090847 0.908719 0.292484 1.788804 -0.065161 1.337389 1.076226 0.741452 1.053336 1.212537 1.463874 0.812811 1.503269 1.665124 0.651549 0.032446 1.058206 1.235365 -0.036822)
     )

;;; 22 odd -------------------------------------------------------------------------------- ; 4.6904157
(vector 22 5.1805551751198 (fv 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0)

     4.581017 (fv 0.000000 0.180996 0.414015 1.937535 0.354831 0.584078 1.521008 1.778595 1.533807 1.338106 -0.034930 1.700610 0.808153 0.348626 1.850606 -0.102689 0.038967 0.664253 1.395687 0.513457 1.627689 0.472162)
     )

;;; 23 odd -------------------------------------------------------------------------------- ; 4.7958315
(vector 23 5.4125407453101 (fv 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1)

     4.661614 (fv 0.000000 0.402662 0.143299 -0.307618 -0.213995 0.796949 1.006633 1.285380 1.569840 0.564104 0.342477 0.293161 1.200899 0.723618 0.539973 0.518746 0.907665 0.184015 1.163786 0.995418 -1.860771 1.039418 -0.124574)
     )

;;; 24 odd -------------------------------------------------------------------------------- ; 4.89897948
(vector 24 5.6193280144865 (fv 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1)

     4.786434 (fv 0.000000 0.498846 1.191572 1.399155 0.479838 1.497230 -0.058887 0.823598 0.010384 0.864577 0.051220 1.057330 0.998513 1.799328 -0.041050 0.199658 0.646825 0.272218 0.034139 0.159133 0.043804 -0.115906 1.177655 0.690674)
     )

;;; 25 odd -------------------------------------------------------------------------------- ; 5
(vector 25 5.7220960914079 (fv 0 1 0 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1)

     4.886819 (fv 0.000000 -0.128793 0.647898 0.792536 -0.285146 0.144218 1.160103 1.183437 -0.004858 -0.239530 1.215352 0.277973 0.699697 1.110172 0.616181 1.458993 0.406636 0.121039 0.182656 -0.085662 1.058149 0.147121 0.546131 0.378165 0.309175)
     )

;;; 26 odd -------------------------------------------------------------------------------- ; 5.0990
(vector 26 5.8537594936002 (fv 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1)

     5.006443 (fv 0.000000 1.694135 1.368613 1.372881 0.625230 0.749494 1.218456 1.691757 1.088538 0.652397 -0.134215 1.088115 0.314540 0.197061 0.715518 1.230349 1.542812 -0.159343 1.427261 1.767442 0.867761 1.850745 0.671024 -0.112496 0.172562 0.147817)
     )

;;; 27 odd -------------------------------------------------------------------------------- ; 5.196152
(vector 27 5.8637111082051 (fv 0 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1)

     5.088823 (fv 0.000000 0.108028 1.216984 1.164689 0.975005 -0.022884 0.035464 -0.148996 0.575654 1.005987 1.378471 0.117457 0.956928 1.741009 0.131397 -0.243584 0.873140 0.514628 1.810242 0.918281 0.161062 1.222969 1.595595 1.233298 1.211975 1.332117 1.297417)
     )

;;; 28 odd -------------------------------------------------------------------------------- ; 5.291502
(vector 28 6.0276107788086 (fv 0 0 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 0 1)

     5.088899 (fv 0.000000 1.695594 -0.042323 0.221585 0.121059 0.906440 0.747864 0.144725 -0.170880 0.198031 0.623261 -0.016920 1.187997 1.805776 0.526952 0.257290 0.181436 1.671568 1.634262 0.482276 1.385748 1.687591 0.368532 1.304502 0.925524 0.205838 0.775793 0.352193)
     )

;;; 29 odd -------------------------------------------------------------------------------- ; 5.385164
(vector 29 6.0348020511367 (fv 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 1 1 1 1)

     5.263365 (fv 0.000000 0.151064 0.558177 0.735081 1.367806 -0.011277 1.649265 0.435302 1.718318 1.203162 0.977127 1.010028 0.703023 1.591655 0.710208 0.371369 0.285721 1.400549 0.654738 0.961707 0.849244 0.833954 0.047113 1.107680 1.103136 1.834278 0.611441 1.521356 0.107658)
     )

;;; 30 odd -------------------------------------------------------------------------------- ; 5.4772255
(vector 30 6.2357559204102 (fv 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     5.353062 (fv 0.000000 -0.273797 0.780589 0.428126 1.742006 0.813705 1.826779 0.243133 0.799231 0.444552 0.600071 1.280010 -0.037027 0.801371 0.587721 1.132556 0.784854 1.819749 1.361833 1.646165 1.057885 0.274456 0.188906 0.072120 0.645190 1.511097 1.900389 1.698668 1.288971 1.535352)
     )

;;; 31 odd -------------------------------------------------------------------------------- ; 5.56776
(vector 31 6.1342258453369 (fv 0 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1)

     5.418933 (fv 0.000000 1.386056 -0.055103 1.470738 1.133338 0.301486 1.278842 0.118113 0.785586 0.164711 0.277129 1.264947 0.805303 0.592921 0.251470 0.348783 0.666372 0.600263 0.392807 1.237206 -0.185182 1.790868 1.684032 0.764715 0.385641 1.091814 0.146242 0.339596 0.884327 1.106807 0.158763)
     )

;;; 32 odd --------------------------------------------------------------------------------  ; 5.65685
(vector 32 6.3532226957365 (fv 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1)

     5.563263 (fv 0.000000 0.861343 1.208721 0.520795 1.054113 1.500902 0.176395 1.932292 0.475897 1.249746 1.078677 0.960255 1.432432 1.363500 0.301492 1.951062 1.402695 1.767079 1.762968 0.052405 1.191435 0.031852 1.950934 1.508841 1.124488 1.063642 0.897258 1.672866 0.358501 1.273522 0.844792 1.935288)
     )

;;; 33 odd -------------------------------------------------------------------------------- ; 5.74456
(vector 33 6.4944429397583 (fv 0 1 0 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 1 1 0)
     
     5.602961 (fv 0.000000 1.602314 1.153414 1.251950 1.483737 0.842898 0.331110 1.775787 1.322292 1.204304 1.308143 0.894156 0.779513 0.992393 1.543652 0.196767 0.377438 0.791269 1.809959 1.067569 0.948715 1.605054 1.761811 1.528262 1.622887 0.603858 1.560497 -0.275070 0.725193 1.894504 0.570411 -0.063928 0.717166)
     )

;;; 34 odd --------------------------------------------------------------------------------  ; 5.8309518
(vector 34 6.5771403312683 (fv 0 0 1 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0)

     5.740544 (fv 0.000000 1.128136 0.272558 -0.038354 0.299624 0.550945 0.313230 0.243494 0.297552 -0.035270 1.018110 0.345979 1.524929 0.448210 1.252682 0.941202 0.533185 0.349491 1.187324 0.383773 0.599245 -0.155984 1.372487 0.578854 1.244062 1.476419 0.215593 0.058496 0.148247 1.077304 1.406503 0.859804 1.327046 0.146527)
     )

;;; 35 odd -------------------------------------------------------------------------------- ; 5.9160
(vector 35 6.7392678260803 (fv 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0)
     
     5.833275 (fv 0.000000 0.446552 1.591598 1.665970 0.393066 0.930519 1.356028 1.466278 0.225797 1.216894 0.009583 0.233020 1.866671 1.148796 1.079614 1.602870 0.201424 1.366765 -0.045388 1.214248 0.402056 0.196949 1.726073 1.538289 -0.146596 -0.105825 1.452686 0.350527 1.133547 0.212285 1.683225 0.967867 0.587559 1.049939 0.968758)
     )

;;; 36 odd -------------------------------------------------------------------------------- ; 6
(vector 36 6.8277182579041 (fv 0 1 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 0 0)

     5.977640 (fv 0.000000 -0.070466 1.538192 0.984355 0.488221 1.019554 1.547512 1.704002 1.584416 0.668394 -0.001385 0.884114 1.504028 -0.187464 0.437132 1.457048 0.752720 0.480053 1.746828 0.789836 0.816665 1.133277 1.144098 1.330854 0.114924 1.293712 1.538716 1.521496 0.841528 0.693020 1.172435 0.408530 0.666143 -0.084621 1.417045 -0.037001)
     )

;;; 37 odd -------------------------------------------------------------------------------- ; 6.0827
(vector 37 7.0 (fv 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0)

     6.019116 (fv 0.000000 1.198867 1.849092 0.935330 1.781957 0.496846 0.026335 0.303736 1.089299 1.074310 1.006658 1.377317 0.271438 1.654659 0.071833 0.494433 1.198697 -0.081156 0.936704 0.883271 1.529398 0.425484 0.218240 1.480439 1.569267 1.446099 0.465358 0.265303 1.385278 0.810099 0.212275 0.106695 0.522036 0.380536 0.175723 0.325421 -0.016008)
     )

;;; 38 odd -------------------------------------------------------------------------------- ; 6.1644
(vector 38 7.027690410614 (fv 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 0 0 0)

     6.144266 (fv 0.000000 0.459111 0.978423 1.181967 1.503059 1.306778 0.862780 1.146756 1.405445 1.059554 0.793798 1.421482 1.624819 0.940808 1.764974 -0.199270 0.756440 1.330911 0.861332 0.933256 0.734269 -0.017456 1.393657 0.220679 1.806219 0.259427 -0.110057 1.180170 1.136238 0.286941 1.541821 0.220515 1.089015 1.358525 1.068195 1.590398 0.413700 0.247552)
     )

;;; 39 odd -------------------------------------------------------------------------------- ; 6.2449
(vector 39 7.2362656593323 (fv 0 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0)

     6.181539 (fv 0.000000 0.390214 1.432668 1.784856 0.372658 0.651343 0.590730 1.420862 1.232876 1.274776 1.031604 0.648830 1.314325 1.550338 0.798266 0.829350 0.920173 0.286182 1.175424 0.776791 1.481341 -0.170207 1.810272 0.591377 1.604472 0.287027 1.660006 1.308050 0.895442 0.027306 0.915319 0.337380 0.586293 1.687170 1.285611 1.205943 1.760871 1.039296 0.923977)
     )

;;; 40 odd -------------------------------------------------------------------------------- ; 6.3245
(vector 40 7.5038495063782 (fv 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 1)

     6.272478 (fv 0.000000 1.284197 1.055354 1.062168 0.387815 0.825054 0.121504 1.716073 1.070732 1.544312 0.376494 1.037163 0.380448 0.304545 1.428265 0.150454 0.740589 -1.906896 0.496136 -0.130727 1.453974 1.546206 0.424585 1.220704 1.332527 1.409234 0.400583 1.072058 1.397035 -0.550500 0.327899 1.771283 0.928925 0.550551 1.392166 1.184654 1.462753 1.291611 1.910777 1.578007)
     )

;;; 41 odd -------------------------------------------------------------------------------- ; 6.4031
(vector 41 7.7093445316966 (fv 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1)

     6.321636 (fv 0.000000 0.581881 1.284007 1.435590 0.968036 0.414485 0.203921 -0.085398 1.011694 1.215509 0.697775 0.907045 0.006237 0.289299 0.751565 0.182523 1.917428 0.830815 0.908047 0.267572 -0.061197 0.319855 0.591342 1.699511 1.912692 1.683447 0.192711 0.461781 0.828435 1.122559 0.524721 1.057548 0.753199 0.901168 -0.077807 0.957092 -0.092721 1.453709 0.349112 1.539336 1.035529)
     )

;;; 42 odd -------------------------------------------------------------------------------- ; 6.4807
(vector 42 7.77445936203 (fv 0 1 1 0 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1)

     6.403222 (fv 0.000000 0.615457 1.471291 0.696790 0.198813 1.064683 0.257669 1.499443 1.009189 1.331704 -0.126692 0.668087 -0.151536 1.235993 1.351147 1.834812 1.622001 1.575606 0.387431 1.123625 1.738720 0.186291 -0.093048 -0.362694 1.268339 0.808624 0.147243 0.174237 0.939940 0.098301 1.557405 1.899768 1.063327 1.398074 1.503515 -0.309876 1.592871 1.047295 0.347548 0.500256 0.502585 1.050388)
     )

;;; 43 odd -------------------------------------------------------------------------------- ; 6.5574
(vector 43 7.7573688953539 (fv 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1)

     6.474181 (fv 0.000000 0.163031 0.868018 0.644438 0.499955 0.314476 0.501651 0.136276 0.115801 1.311189 1.257885 1.003167 1.668510 0.653556 0.900535 0.185303 1.792109 1.097281 0.880040 0.351492 0.533331 1.402396 1.722630 -0.341451 0.699659 1.677594 1.684893 1.301554 -0.032447 0.458521 1.242927 0.587312 1.726991 0.987710 0.168427 1.112409 0.233710 0.476465 1.063291 1.023410 1.387257 1.104431 1.814614)
     )

;;; 44 odd -------------------------------------------------------------------------------- ; 6.6332
(vector 44 7.9338580613871 (fv 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0)

     6.599250 (fv 0.000000 0.351178 1.306835 1.466283 1.319851 0.565360 0.401323 -0.237018 1.055625 0.418518 0.685726 1.681541 1.845435 1.019294 1.472175 1.617323 0.599443 0.202024 1.548869 0.896807 1.498980 -0.449736 0.958935 0.672395 0.465421 0.363298 0.745996 0.800573 1.320237 0.704768 1.103042 1.233693 0.653096 1.449790 0.411870 1.110453 0.556583 1.736823 0.345497 0.024788 0.937504 1.224464 1.559019 1.346766)
     )

;;; 45 odd -------------------------------------------------------------------------------- ; 6.7082
(vector 45 8.1351366043091 (fv 0 0 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0)

     6.624897 (fv 0.000000 1.004365 0.475962 1.144412 0.404466 0.708852 0.590380 0.024072 1.172296 1.113281 1.630362 1.256665 1.314082 0.342438 0.579726 1.460036 0.838934 0.298273 1.354989 1.643563 1.558056 1.967600 0.749164 1.349815 0.523705 0.276619 1.145711 1.733713 1.155806 1.020242 0.468578 1.677226 1.799379 1.623813 1.799356 0.670303 1.547676 1.429802 1.095547 0.114545 0.743241 1.141259 0.963105 1.247487 0.978965)
     )

;;; 46 odd -------------------------------------------------------------------------------- ; 6.7823
(vector 46 8.1455316543579 (fv 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1)

     6.709237 (fv 0.000000 0.588728 0.764172 0.948247 0.778447 1.268756 0.080491 -0.381973 0.448541 1.688302 0.583900 0.609230 0.913000 1.244782 0.098190 0.458033 0.787717 0.012905 0.854674 1.035325 1.255759 0.507374 1.208176 0.514489 0.741105 1.441899 0.585374 1.583344 0.643511 1.525932 1.201616 0.846916 0.319659 0.030560 0.895113 0.341984 -0.007305 1.588064 0.007988 0.334683 0.349739 -0.215667 -0.068989 1.488454 0.988215 0.867211)
     )

;;; 47 odd -------------------------------------------------------------------------------- ; 6.8556
(vector 47 8.336971282959  (fv 0 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 0)

     6.785244 (fv 0.000000 0.898263 0.698671 0.821497 0.370262 0.536725 0.016930 1.555315 1.553643 1.249848 -0.203480 1.765177 0.026588 0.111231 -0.039332 0.662791 0.096267 1.286138 1.353013 0.226230 0.057438 1.648120 -0.088502 0.524016 1.306955 -0.084552 0.350695 1.753518 1.303444 0.678968 0.693452 0.498589 1.005882 1.660165 0.430707 0.068634 0.587061 1.130543 1.939600 0.152146 1.459634 0.723147 1.428638 0.763075 1.800028 1.481715 0.488673)
     )

;;; 48 odd -------------------------------------------------------------------------------- ; 6.9282
(vector 48 8.35563071219336 (fv 0 1 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 0 1)

     6.828028 (fv 0.000000 0.998004 1.077433 0.148071 1.527370 -0.144913 1.645316 1.723923 0.412024 1.174877 0.494923 1.411660 0.605628 1.628272 1.064698 1.228914 0.098971 0.692407 0.395792 1.297327 -0.001580 1.140646 1.342219 1.577941 0.241000 1.510351 1.184692 1.697190 1.378912 1.591005 -0.082196 0.468455 0.883072 0.625939 0.755107 0.095773 0.293743 0.637279 1.770381 1.345208 0.924216 0.393583 0.137327 1.278382 0.157871 0.442417 0.371701 -0.029442)
     )

;;; 49 odd -------------------------------------------------------------------------------- ; 7
(vector 49 8.57458718352971 (fv 0 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0)

	6.988750 (fv 0.000000 -0.166791 0.066489 1.162315 1.337152 0.223301 0.045811 -0.093825 1.332601 1.728915 0.870363 0.493056 0.773831 1.546388 0.179602 0.790122 1.699394 1.317163 1.725149 1.408847 1.015662 0.639057 1.163324 0.986617 1.318547 -0.170292 0.080070 1.239083 1.484292 1.779081 0.940479 0.037560 -0.006305 1.151063 0.903661 1.767180 1.162011 1.427957 0.814000 1.843040 0.477534 1.459006 0.756363 0.414970 1.321498 0.061120 0.265825 0.092137 0.202930)
     )

;;; 50 odd -------------------------------------------------------------------------------- ; 7.07
(vector 50 8.711 (fv 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1)

     6.947137 (fv 0.000000 1.361221 1.058873 0.255818 1.371652 1.848584 -0.002271 1.052656 0.139885 0.680884 0.885258 1.006144 1.663943 1.665052 1.470510 1.693036 0.091983 0.825894 1.755289 1.033123 0.055566 1.508725 0.691199 1.233170 0.641006 1.442066 1.557992 1.909688 0.175284 1.577225 1.678517 1.358807 1.558359 1.883371 1.133931 1.053187 0.137949 1.901321 0.058023 0.971798 1.378739 0.843519 0.357409 0.498187 1.235125 0.734586 0.653589 0.242791 1.085625 -0.043484)
     )

;;; 51 odd -------------------------------------------------------------------------------- ; 7.141
(vector 51 8.5829010009766 (fv 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 1 0)

     7.087726 (fv 0.000000 0.875029 0.865937 0.367918 1.900818 0.762934 0.081270 0.353365 0.070375 -0.037477 1.275772 -0.100171 1.088567 1.481918 0.798713 1.260047 0.731048 1.035501 1.384103 0.728234 0.608922 1.769831 1.228331 0.727930 1.038826 -0.062865 0.731133 1.490525 1.564219 0.530975 0.845759 -0.127106 1.209031 0.537607 1.042200 0.906452 -0.105250 0.353212 0.368083 1.395843 1.206034 1.694293 0.348968 0.222228 0.523051 0.375570 0.283017 1.406111 0.934909 0.587260 0.940073)
     )

;;; 52 odd -------------------------------------------------------------------------------- ; 7.211
(vector 52 8.8599758148193 (fv 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 1 0 0 0 1)

     7.080087 (fv 0.000000 0.216994 0.815073 0.651401 0.471967 0.035007 -0.067747 0.660856 0.580235 0.052345 1.785696 0.529423 0.205578 -0.247148 1.238971 0.096672 0.952857 0.166426 0.759284 1.719458 0.161518 1.592928 0.883009 0.245604 1.208605 0.995562 0.029395 0.487673 1.152615 0.362903 0.721410 0.862934 0.090743 0.014994 0.082182 0.993529 1.056537 1.708353 0.746025 -0.333233 1.155949 0.740213 0.619117 1.020646 1.502770 1.347142 1.371490 1.480724 0.363059 1.828476 0.147552 0.424061)
     )

;;; 53 odd -------------------------------------------------------------------------------- ; 7.280
(vector 53 9.037 (fv 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0)

     7.252601 (fv 0.000000 1.316368 0.101159 0.287376 -0.120486 -0.146148 -0.293575 0.279566 1.566833 0.692861 -0.116203 1.111486 1.592177 1.082742 0.010661 0.754630 0.400780 0.795713 1.670109 1.185717 1.226796 -0.120012 0.262637 0.206364 0.738299 0.157263 0.604374 0.683095 1.946305 -0.043066 0.580881 1.320138 -0.043078 1.307240 1.171743 0.356072 0.398418 -0.096678 0.059824 1.235855 0.057573 -0.031810 1.322088 0.600804 1.405030 -0.237620 -0.007423 -0.083489 1.021491 1.628805 -0.222749 0.516076 0.301362)
     )

;;; 54 odd -------------------------------------------------------------------------------- ; 7.348
(vector 54 9.025 (fv 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0)

     7.328138 (fv 0.000000 0.352535 1.363504 0.096670 1.597330 -0.030072 1.222144 1.243528 0.696875 0.968663 0.162138 1.056566 0.539804 0.008667 0.316670 -0.098837 1.225380 -0.112322 0.244903 0.436331 1.746403 0.122260 0.091220 1.558109 1.217585 1.412994 0.339182 0.690620 1.846588 1.658518 0.529876 1.420789 0.398352 0.612668 1.926173 0.676632 0.529358 1.076039 0.628593 -0.021834 1.281928 0.607717 0.819453 1.795488 1.260788 0.439390 0.834961 1.345636 1.190831 1.783406 -0.135996 0.097131 0.579836 0.358027)
     )

;;; 55 odd -------------------------------------------------------------------------------- ; 7.416
(vector 55 9.2039985656738 (fv 0 0 1 1 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

     7.364233 (fv 0.000000 0.395190 -0.153867 1.307052 0.778840 1.201427 1.584425 -0.091689 1.563398 0.221226 1.485388 0.595790 -0.041635 0.380534 0.103234 0.445988 1.706774 1.178799 1.315522 1.096083 0.260274 -0.072891 0.228062 0.239593 1.575799 0.203611 0.427975 1.251992 1.620128 0.666682 0.636489 0.025180 0.388251 0.546392 1.107252 0.996609 1.708598 0.607806 -0.354744 1.114522 1.187212 0.060556 1.020751 1.136440 0.719385 1.579705 0.166783 0.736570 0.421572 0.534881 0.141987 1.649951 0.500500 0.386302 -0.074892)
     )

;;; 56 odd -------------------------------------------------------------------------------- ; 7.483
(vector 56 9.3816785812378 (fv 0 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 0)

     7.419120 (fv 0.000000 0.417128 1.082491 1.276854 0.765982 1.295111 1.835030 1.786443 0.675192 1.020185 0.394420 0.359608 0.697463 1.166247 0.564899 1.087103 0.889865 0.844186 1.419287 1.562675 0.248998 1.869468 1.111986 1.294693 1.863255 0.052934 0.338636 1.626312 1.601681 -0.021561 1.462490 1.791020 0.409025 1.675990 1.011444 1.359048 1.605820 1.247285 1.024241 0.457113 0.153603 0.242127 1.175155 0.206257 1.412766 1.496703 -0.140135 1.270904 0.393803 1.315634 0.897708 1.585792 0.563930 1.722379 1.612675 1.047507)
     )

;;; 57 odd -------------------------------------------------------------------------------- ; 7.549
(vector 57 9.3903837203979 (fv 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 1 1 1 1 0 1 0 0 0 0 1 1 0)

     7.488896 (fv 0.000000 -0.127939 1.380652 0.701541 0.779535 0.090662 1.662797 0.879717 1.570316 1.307786 1.211090 0.971455 0.738042 1.474139 1.501173 1.322773 -0.333947 0.651999 1.407414 0.559437 0.970911 0.613447 1.441437 0.387240 1.769723 0.695953 -0.175580 0.102181 0.180022 1.529463 0.468743 0.084931 0.062956 0.298511 0.524008 0.924744 1.286647 1.428978 0.334028 1.302926 0.807711 0.283976 0.097723 1.284073 0.038191 0.329167 1.275797 0.351298 1.518403 1.571791 0.227818 0.842734 0.707030 0.435243 0.618490 0.867851 1.852691)
     )

;;; 58 odd -------------------------------------------------------------------------------- ; 7.6157
(vector 58 9.5893135070801 (fv 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0)

     7.585947 (fv 0.000000 0.517595 -0.138781 1.328351 0.394157 0.908218 0.526218 1.063012 1.239066 1.277916 1.783309 1.590363 0.539572 1.425376 1.601385 0.376842 0.888852 1.358950 1.916790 1.468314 0.490842 0.036065 1.359391 1.047397 0.699655 1.225098 0.065253 0.350008 0.483077 1.188989 1.002860 0.893562 0.202836 0.208109 1.801392 1.050084 -0.102454 1.813439 1.482474 -0.166271 1.426695 0.563055 -0.225427 0.436837 1.102639 0.467507 0.283291 1.511898 0.400494 1.606371 -0.049354 1.495330 -0.267319 0.336083 0.925094 0.220186 1.902233 -0.035784)
     )

;;; 59 odd -------------------------------------------------------------------------------- ; 7.681
(vector 59 9.5173864364624 (fv 0 1 1 1 0 0 0 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0)

     7.617785 (fv 0.000000 1.762340 0.513621 1.350480 0.395272 0.369068 0.305583 0.831518 1.232517 0.676844 0.014044 1.888953 1.633364 1.298874 0.424500 1.402106 0.715815 1.275937 1.488547 1.873193 1.738228 0.570388 0.057875 1.975863 0.297300 1.563912 0.772704 0.090655 0.241787 1.145030 0.785784 1.432008 1.006607 1.408581 0.812224 0.224382 0.926131 0.944185 -0.064326 0.205583 1.060366 0.673429 1.237483 1.421583 0.464247 1.651757 1.984268 1.030220 1.489122 1.350599 0.646010 1.371095 0.262034 0.720620 1.557135 1.181053 0.745491 0.926931 1.443337)
     )

;;; 60 odd -------------------------------------------------------------------------------- ; 7.7459
(vector 60 9.6560277938843 (fv 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0)

     7.699628 (fv 0.000000 -0.021305 0.599580 1.675097 0.724803 0.358532 0.890770 0.765518 0.237166 0.821603 0.185949 0.996346 -0.076908 1.733595 1.718331 -0.080896 1.631867 0.229557 1.219113 -0.444442 1.509828 0.286787 0.741904 1.151478 1.816287 -0.008152 -0.169986 1.514652 0.248473 1.296089 1.211441 0.399013 0.342384 1.801962 0.377537 0.181714 1.809056 1.599925 0.494049 0.298590 0.110648 0.855221 1.804868 0.666943 1.224265 1.636192 1.425598 0.559152 0.087897 0.972335 -0.105600 1.103327 1.345409 0.428767 -0.084957 1.609410 0.060258 0.846549 0.678506 0.580784)
     )

;;; 61 odd -------------------------------------------------------------------------------- ; 7.8102
(vector 61 9.6689287776524 (fv 0 0 0 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 1)

     7.775467 (fv 0.000000 -0.343145 0.781525 1.809127 0.251480 0.512435 0.079273 1.157280 0.819596 0.391398 -0.518556 1.678636 0.560600 0.125318 0.035700 1.744672 1.824327 1.087291 1.692006 0.706036 0.269610 1.403225 1.233897 0.487088 1.476172 -0.284871 0.794501 1.368364 0.656660 0.974817 1.000338 0.175726 1.024682 0.865508 0.404847 0.718158 0.071740 1.457732 -0.480756 0.735357 1.217441 0.811494 1.022056 0.829877 1.509011 1.174960 1.639594 0.781475 -0.011943 1.221853 -0.208689 0.133149 0.650142 1.217107 -0.446658 0.092120 -0.062880 0.676055 0.910707 0.946198 0.780527)
     )

;;; 62 odd -------------------------------------------------------------------------------- ; 7.8740
(vector 62 9.7982149124146 (fv 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0)

     7.816985 (fv 0.000000 0.185485 -0.254761 0.263400 0.632430 0.127767 1.483161 1.282005 1.556675 0.709224 0.293439 0.049467 -0.087443 1.425471 0.595679 0.678957 0.447779 0.382124 0.717681 0.082649 -1.563917 -0.140691 0.229960 0.339346 0.083428 0.640485 0.923623 -0.076532 1.385224 0.166806 1.518517 1.222370 1.575074 0.899045 0.324075 1.508603 -0.064272 0.115115 0.407781 0.298344 1.252368 1.084082 0.264721 0.922346 1.331199 0.689780 0.795795 1.526817 0.163429 0.888100 0.510259 1.478381 0.318687 1.341508 1.785614 0.798865 0.525568 1.053899 1.308203 0.410567 -0.026960 1.103176)
     )

;;; 63 odd -------------------------------------------------------------------------------- ; 7.9372
(vector 63 9.8550319671631 (fv 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 0 0 0 1 1 0)

     7.904133 (fv 0.000000 1.545501 0.155683 0.898914 0.625696 0.564119 0.345790 0.703891 0.981672 1.014462 1.740323 0.008567 -0.039871 0.470077 1.202746 0.366398 0.367999 1.293490 0.310624 1.016687 1.843528 0.474437 1.864085 0.859066 0.880435 1.525047 0.949229 0.065485 0.658928 0.625456 0.890422 0.157110 0.668174 1.537633 -0.133525 1.887056 1.094821 1.580831 1.506736 1.621226 1.791740 1.492769 0.830911 0.166732 1.797834 0.044991 1.834240 1.000450 1.479368 0.610232 0.816463 1.240492 0.107919 -0.111385 1.348751 1.167090 0.907202 0.154866 1.422414 0.720983 0.430601 -0.041659 0.656229)
     )

;;; 64 odd -------------------------------------------------------------------------------- ; 8
(vector 64 10.0 (fv 0 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0)

     7.957414 (fv 0.000000 0.941670 0.218463 1.054436 0.821282 0.779097 1.084317 0.220811 0.530574 -0.001214 1.277468 1.056444 1.434429 0.244804 0.635637 0.374642 1.294283 0.051882 1.563945 0.856817 0.659797 0.848723 0.789207 0.004337 0.642492 -0.752744 0.794434 0.546992 1.340010 0.716341 1.722360 1.081100 1.009399 0.345867 1.393328 1.377443 1.264631 0.487017 1.142544 0.031648 0.469271 -0.098334 -0.019627 0.567023 1.791954 0.511740 0.421519 0.992945 1.133377 1.668348 -0.054246 0.158608 -0.042808 1.772093 0.331126 0.762153 1.499580 1.813299 1.079657 1.088576 0.368377 1.519001 0.864479 0.914946)
     )

;;; 65 odd -------------------------------------------------------------------------------- ; 8.0622
(vector 65 10.169842720032 (fv 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1)

     8.041843 (fv 0.000000 1.510279 1.423698 1.698060 1.501053 1.180996 -0.085543 1.272940 0.246128 1.452754 1.116882 0.406181 0.071379 0.504041 0.790673 1.684489 -0.028841 0.150831 0.258232 0.575724 1.903805 0.049803 1.632670 1.087031 1.406375 1.614155 0.540793 1.593111 0.703911 1.182639 1.722176 0.257146 -0.290703 0.360167 1.805766 1.244616 1.636667 1.267448 1.403263 0.048920 1.072378 0.033352 0.081404 0.128813 0.847252 1.224433 1.268463 0.838170 0.941587 1.720222 0.172123 0.951570 1.520723 1.306591 0.465991 -0.022358 1.791525 1.039956 0.489959 1.798920 0.197346 1.247948 0.566292 0.910361 0.850668)
     )

;;; 66 odd -------------------------------------------------------------------------------- ; 8.1240
(vector 66 10.212840820553 (fv 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0)

     8.137089 (fv 0.000000 0.867002 -0.091284 0.941017 0.985813 1.124822 -0.061065 0.794288 1.395872 1.715915 0.180754 1.493753 0.091406 -0.059796 0.775109 -0.175925 1.503403 0.926368 0.549523 0.719653 -0.225722 0.805496 0.016786 1.138759 0.185499 1.460462 1.586490 0.459741 1.668207 1.371214 0.709682 0.824263 0.306383 0.060221 1.519433 1.454263 1.678352 0.268698 0.281303 0.104475 0.990641 -0.061422 1.164978 0.345674 0.648924 1.140977 0.632657 0.963358 1.933250 0.002500 1.501010 0.074909 0.787595 1.107851 1.157288 1.691148 1.812947 1.291647 1.327838 1.731755 1.607111 1.129367 0.868934 1.256116 1.509418 0.963219)

     8.095195 (fv 0.000000 0.946051 -0.069946 0.931149 1.114323 1.098389 -0.039332 0.877524 1.318916 1.775911 0.245290 1.539842 0.131201 -0.108794 0.748602 -0.153383 1.475925 0.851225 0.482687 0.831474 -0.195116 0.598903 -0.150418 1.241002 0.075671 1.415619 1.425349 0.401276 1.645496 1.378829 0.717955 0.820749 0.280776 0.102463 1.505118 1.466659 1.804612 0.370381 0.198640 0.039917 0.927835 0.130993 1.362388 0.264055 0.657827 1.168088 0.670275 0.998910 -0.080695 -0.000494 1.446059 0.092607 0.764024 1.120077 1.135001 1.626300 -0.038234 1.325677 1.373468 1.689492 1.591066 1.008988 0.840459 1.246657 1.459948 0.945345)
     )

;;; 67 odd -------------------------------------------------------------------------------- ; 8.1853
(vector 67 10.209677696228 (fv 0 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 1 0 1)

     8.127999 (fv 0.000000 0.156189 0.759312 0.316632 1.612933 0.605013 0.952530 0.423099 -0.112233 1.447269 0.863131 0.200670 1.538179 0.172873 0.737196 0.916694 1.524894 1.423218 1.337268 0.799228 0.023760 0.359774 1.033535 1.252717 0.399347 1.736421 0.199827 0.358145 1.847858 -0.157369 -0.118965 -0.296280 1.764663 0.918422 0.547247 0.781682 -0.101912 1.939111 1.078792 1.928250 0.777073 0.358591 1.566766 0.658960 0.895914 1.285541 1.636763 -0.098157 1.684110 0.891684 1.386081 0.068089 0.497477 0.528377 0.140207 0.953073 0.655659 0.018618 0.774991 0.503967 1.384065 0.100041 0.959741 0.153740 0.654728 0.200720 0.384936)
     )

;;; 68 odd -------------------------------------------------------------------------------- ; 8.24621
(vector 68 10.359804316765 (fv 0 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0)

     8.204414 (fv 0.000000 0.279095 1.647677 0.913913 0.663406 0.323080 0.240930 0.148599 0.780719 0.015227 1.335435 0.919514 1.070941 0.877126 0.293550 1.686752 0.481693 0.755701 0.785320 0.815615 1.595420 1.293383 0.426688 0.494705 1.026142 0.549725 1.259770 -0.007824 0.278489 0.224750 0.082547 0.719555 0.355973 0.908801 0.541094 0.432336 1.241602 1.708744 0.772870 1.505613 -0.137480 0.654507 1.657469 0.849573 0.009380 1.611286 1.676352 1.046709 1.432096 0.979028 1.747525 0.522938 0.318568 1.148496 -0.245690 0.703484 0.171945 1.485079 1.659272 -0.006233 0.283657 1.852744 1.398727 0.371514 0.974831 1.325922 0.719933 0.483798)
     )

;;; 69 odd -------------------------------------------------------------------------------- ; 8.3066
(vector 69 10.452348709106 (fv 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1)

     8.274908 (fv 0.000000 1.788801 1.283513 -0.242756 0.145250 0.146755 0.584479 1.353542 0.821070 0.189803 1.413669 0.749926 1.058442 1.185407 1.095039 1.015258 0.161858 0.034929 0.498704 0.198138 1.711445 0.157768 0.616185 1.421248 1.168404 0.254474 1.519482 -0.175837 0.581687 0.194579 0.931780 -0.336100 0.287461 1.495068 0.039168 1.507647 0.993152 1.382317 1.231363 0.721890 1.622206 1.080570 0.186638 0.155662 0.909604 1.203958 1.050254 1.890059 0.428940 0.701250 -0.160137 0.279994 1.502298 0.567568 0.585424 0.686015 -0.246566 0.662061 0.986133 1.103373 0.572438 0.607162 -0.159332 0.926622 1.112278 0.937694 0.624990 1.345312 0.670451)
     )

;;; 70 odd -------------------------------------------------------------------------------- ; 8.3666
(vector 70 10.431521047498 (fv 0 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 1)

     8.328488 (fv 0.000000 1.209391 0.655351 -0.224668 0.270551 0.912782 1.006468 0.115362 1.639506 1.394128 1.775544 -0.158964 -0.191285 0.916307 -0.148807 -0.343643 0.171981 0.447415 0.684977 -0.187759 0.122627 0.642332 0.846737 0.920787 0.824105 -0.455822 1.004331 0.650453 0.327784 -0.378239 0.335174 0.883411 0.475111 1.924029 1.429019 1.351303 -0.183533 1.395982 0.599233 0.896200 1.135652 0.575692 1.213789 1.853140 0.377792 1.790714 0.835251 1.493542 0.305236 1.538414 0.647163 0.263422 1.348466 1.037276 0.893701 1.108073 -0.492190 -0.249170 1.081128 0.973414 0.593299 0.786885 0.003725 0.855855 1.605169 1.050037 0.831705 1.193285 0.128148 0.709803)
     )

;;; 71 odd -------------------------------------------------------------------------------- ; 8.4261
(vector 71 10.642364501953 (fv 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0)

     8.475519 (fv 0.000000 1.238076 0.753931 1.905336 0.009769 0.107430 -0.130621 1.591198 0.182824 0.768320 1.146473 0.823523 0.829676 0.742699 -0.276539 0.324236 1.092544 0.415195 1.670265 1.207403 0.977157 1.540240 1.842707 1.816863 1.497289 1.724381 0.528087 1.371720 0.846254 0.443580 1.148328 1.771135 -0.168351 0.710309 -0.056239 1.109626 1.555511 -0.110149 0.103207 0.997197 1.006113 0.446860 1.034785 1.366376 1.616338 -0.046807 1.211677 1.130244 1.187406 1.353421 0.750549 1.080694 1.186040 0.268525 1.418417 0.401769 1.093799 -0.192487 0.855080 0.124908 -0.060822 1.069669 1.270728 0.527632 1.877202 0.240913 -0.052204 1.530974 1.498303 0.436500 1.851527)

     ;; from this, but :odd 71 0.53864770353023 (fv 9.9351872829636 -0.2379167494546 3.1853837584999)??
     ;; 9.9437 (fv 0.0000 1.0614 0.0950 1.1008 0.0787 1.0289 1.9512 0.8458 1.7125 0.5514 1.3626 0.1459 0.9014 1.6290 0.3289 1.0010 1.6452 0.2617 0.8503 1.4112 1.9442 0.4494 0.9268 1.3764 1.7982 0.1921 0.5583 0.8967 1.2072 1.4899 1.7449 1.9720 0.1713 0.3428 0.4865 0.6024 0.6904 0.7507 0.7831 0.7878 0.7646 0.7136 0.6349 0.5283 0.3939 0.2316 0.0416 1.8238 1.5781 1.3047 1.0034 0.6744 0.3175 1.9328 1.5203 1.0800 0.6119 0.1159 1.5922 1.0407 0.4613 1.8541 1.2192 0.5564 1.8658 1.1474 0.4012 1.6272 0.8253 1.9957 1.1382 )

     8.471193 (fv 0.000000 1.251993 0.120909 1.147167 0.101021 0.991005 0.102768 0.840256 1.667018 0.493083 1.454975 0.236751 0.930972 1.613715 0.282901 1.264934 1.852683 0.309294 0.763244 1.396502 0.016107 0.421575 0.832061 0.905495 1.670197 0.206770 0.024145 0.415927 1.292038 1.512037 1.549693 1.890115 0.264325 -0.038970 0.344515 0.662351 0.896654 0.664956 0.697808 0.735895 0.787344 0.830776 0.256004 0.590650 0.201668 0.204354 0.381917 1.530833 1.289723 1.098254 0.882568 0.234043 0.016492 0.014075 1.543842 0.771174 0.029614 -0.188598 1.614192 0.901328 0.316437 -0.299368 1.157490 0.464174 -0.326258 1.156953 0.332845 1.674680 0.336028 -0.185110 1.185822)

     8.406561 (fv 0.000000 1.136768 0.110422 1.080469 0.111645 0.980565 0.087135 0.892409 1.705799 0.484945 1.412134 0.209542 0.909173 1.678801 0.332063 1.134599 1.765595 0.287552 0.824497 1.474171 0.122562 0.547316 0.786695 0.921126 1.628959 0.181855 0.048990 0.491779 1.249164 1.531973 1.630614 -0.083456 0.308877 -0.134450 0.334308 0.596938 0.779083 0.610588 0.769576 0.748353 0.930715 0.765564 0.342767 0.573683 0.144254 0.219685 0.317964 1.469956 1.186980 1.051035 0.789756 0.253764 0.026652 -0.023543 1.467574 0.724088 0.114734 -0.223070 1.555542 0.968486 0.132084 -0.314737 1.118620 0.462013 -0.390063 1.067074 0.324923 1.582422 0.354510 -0.234876 1.172540)
     )

;;; 72 odd -------------------------------------------------------------------------------- ; 8.4853
(vector 72 10.880306243896 (fv 0 0 1 0 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1)

     8.366430 (fv 0.000000 1.529157 0.709835 0.191619 0.777505 1.673931 1.052039 1.157229 0.197845 1.188203 0.205209 0.808312 1.907251 0.734102 1.471024 1.752009 0.976735 0.215092 1.669497 0.039070 0.308185 0.805661 0.414650 0.685942 0.933087 1.104471 0.869537 0.010581 1.431457 1.039490 0.654718 0.051163 1.637896 0.041328 0.434461 1.596916 0.630066 0.513683 1.126090 1.472280 0.029687 0.729904 0.900726 0.364456 0.829387 0.775767 0.087943 1.122617 0.054278 0.980310 0.814649 1.331669 0.404897 1.438813 0.751132 1.069103 1.033498 0.950755 0.588560 0.206118 0.697556 1.364322 0.007771 0.225318 -0.029948 1.266843 1.008881 -0.515131 0.251545 0.235634 0.009431 1.881826)
     )

;;; 73 odd -------------------------------------------------------------------------------- ; 8.5440
(vector 73 10.907942771912 (fv 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1)

     8.514653 (fv 0.000000 1.403201 0.376583 -0.053235 1.209136 1.524715 0.146380 -0.261365 0.834173 1.272975 1.772227 0.023615 0.314599 1.515420 0.115615 0.532763 0.813612 1.148749 0.624829 1.610666 0.428301 0.533410 1.364035 0.688805 -0.345103 -0.033075 0.031988 1.294508 1.610808 0.200563 1.512417 1.458407 0.018985 0.336604 -0.051222 0.346655 1.033154 0.703796 1.103730 1.139661 0.592095 0.478459 0.370549 0.620498 -0.386452 0.468708 0.040902 1.488975 0.539537 0.999795 0.347372 0.354446 0.387241 1.176009 1.306213 0.778993 0.280166 0.010910 0.034863 0.320352 1.620759 0.391262 0.863014 -0.075789 1.338588 1.092040 0.260638 1.463660 0.169121 0.826134 0.241084 1.728130 -0.116721)
     )

;;; 74 odd -------------------------------------------------------------------------------- ; 8.6023
(vector 74 11.262331896     (fv 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0)

     8.487915 (fv 0.000000 0.229202 0.328610 0.886519 0.913243 -0.092303 1.469261 1.392280 0.102684 0.875868 1.119399 -0.375546 1.138609 1.792722 0.270873 0.158504 1.300583 0.337402 0.457798 0.994721 0.720190 1.266403 1.157785 0.204200 0.832717 1.368187 -0.207911 0.551921 0.143469 0.767289 -0.041673 0.248888 0.686134 1.808117 1.719833 1.634354 -0.372228 1.923379 1.132948 1.667043 0.857041 1.387145 0.637791 -0.326159 0.280564 1.478231 0.572776 0.063470 1.115045 1.234238 1.093760 0.166042 1.189669 0.933614 0.159392 1.594960 1.079073 1.251388 1.747471 1.137640 1.343339 1.096317 0.655141 0.037576 1.286106 -0.396608 1.310863 1.072774 0.013655 0.220749 -0.215382 0.087335 1.489739 0.952386)
     )

;;; 75 odd -------------------------------------------------------------------------------- ; 8.6603
(vector 75 10.942812919617 (fv 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 0 1 0 1 1)

     8.649507 (fv 0.000000 1.109688 1.876179 -0.024908 0.874394 0.094974 0.967726 0.182001 1.798004 0.764080 1.705983 0.246581 0.919892 -0.031641 0.074543 1.466120 -0.542452 1.308866 1.354893 0.937217 0.141091 0.972731 1.649929 0.076730 0.306081 1.082330 -0.056612 -0.033267 0.417204 0.002975 0.510299 0.334065 0.921554 0.578842 0.861949 0.516829 0.507298 0.089901 1.846522 0.266232 1.636125 0.773196 1.708397 0.143239 0.982116 1.755516 1.504659 0.043743 0.095624 0.325057 0.879744 1.064185 1.252657 0.311473 1.870059 0.309527 1.581011 1.908962 0.734045 1.785988 0.038323 0.023116 0.922283 0.858183 0.320752 1.741469 1.289108 0.871189 -0.238214 1.531119 1.355752 0.609175 0.669122 0.984951 0.033177)
     )

;;; 76 odd -------------------------------------------------------------------------------- ; 8.7178
(vector 76 11.21743106842 (fv 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 0)

     8.651279 (fv 0.000000 0.173353 0.839453 0.789458 1.213196 0.485342 1.020793 1.079117 1.510944 0.872759 1.658963 0.469539 1.282086 0.224500 1.187595 1.001928 0.601189 0.457802 1.523606 0.013310 0.486526 1.038767 0.887428 0.818932 0.429987 0.518887 0.949464 1.376735 0.275451 0.805159 0.132159 1.431344 0.575428 0.009721 1.711880 1.360202 0.416637 0.859810 0.491831 0.882963 0.253397 0.012929 1.530000 0.177927 1.883242 1.959160 0.357646 1.604277 0.939839 1.031583 0.502599 0.924357 -0.060587 1.148550 0.762073 0.585290 1.515308 1.022656 0.505967 0.958132 1.937796 0.289650 0.388753 1.349929 0.430727 1.688517 1.350532 0.156971 0.890960 0.708951 1.606885 1.582622 1.628222 1.565608 0.127771 0.825769)
     )

;;; 77 odd -------------------------------------------------------------------------------- ; 8.7750
(vector 77 11.192246437073 (fv 0 1 0 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0)

     8.707019 (fv 0.000000 1.733898 1.602888 1.700625 0.951967 1.205480 0.494785 0.079322 1.861432 1.411332 0.615577 0.456043 0.176616 0.522662 0.530871 0.948923 1.312747 1.035434 -0.217439 1.260792 0.366350 -0.233439 0.849314 1.174459 -0.193276 1.451248 0.290403 1.453670 0.668542 0.644436 1.306523 1.198202 0.657361 0.888118 1.964614 0.824349 -1.765380 0.784141 0.143386 -0.053030 0.033585 0.726269 -0.055055 0.121221 1.064245 1.578078 0.715470 -0.211778 1.194974 -0.095151 0.313319 0.914111 -0.007802 0.154723 0.086177 1.895682 1.191957 -0.344176 -0.285803 0.072705 0.944928 0.649978 0.107843 0.251480 -0.267013 1.016287 0.107966 1.055797 1.067984 1.857635 0.230948 0.492625 0.104053 0.572353 1.732176 0.353482 0.821975)
     )

;;; 78 odd -------------------------------------------------------------------------------- ; 8.8318
(vector 78 11.455265310659 (fv 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 0 0)

     8.715270 (fv 0.000000 1.669247 0.757594 0.165819 0.288294 0.684770 0.557521 0.680526 1.097350 0.470057 1.849497 1.090608 0.922922 1.129049 0.104794 -0.129005 0.326960 -0.051784 1.142568 0.483331 0.896117 0.813482 0.302867 0.073158 -0.168821 0.656167 0.700004 1.004810 -0.007423 -0.189996 0.560929 0.412734 0.830296 1.110767 -0.043008 0.613326 0.576197 0.610404 1.233787 0.583712 0.887457 1.853983 1.162911 1.497407 0.204463 1.117898 1.731543 1.711291 0.816677 1.207698 1.691953 0.214296 -0.046452 0.692536 0.108168 0.208702 0.459557 1.630550 -0.229002 1.446147 1.208030 -0.028606 1.708585 1.336818 1.004606 0.393864 1.182948 -0.208442 1.255124 0.056920 1.572769 0.643674 1.170025 0.291140 1.025254 0.562266 0.633856 0.124004)
     )

;;; 79 odd -------------------------------------------------------------------------------- ; 8.8882
(vector 79 11.54291004024 (fv 0 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0)

     8.864559 (fv 0.000000 0.357256 0.036759 1.292339 -1.618603 1.176406 0.544736 0.398074 0.109043 0.617241 0.697903 1.118083 1.422870 1.215951 0.004362 1.621202 0.264308 0.010496 1.213090 1.597753 -0.054911 1.223572 0.202448 0.615339 0.757193 0.130847 1.245098 1.256256 1.117774 0.701640 1.170787 1.057213 -0.087146 1.024522 1.105914 1.493238 0.672326 0.950638 -0.158430 0.266150 1.329043 0.773121 1.527296 -0.078973 1.669452 1.490229 0.141063 1.057903 0.727028 1.146281 0.010335 0.602841 1.428986 1.325796 1.320411 -0.094534 0.491229 0.443206 1.223761 0.317919 0.333487 -0.004296 1.074159 1.511918 1.245758 0.213171 1.140531 1.245789 0.552067 1.083032 0.600490 0.777304 0.106919 1.336123 1.060329 1.059212 0.289692 1.668881 1.086200)
     )

;;; 80 odd -------------------------------------------------------------------------------- ; 8.9443
(vector 80 11.122416496277 (fv 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1)

     8.870144 (fv 0.000000 0.655710 0.591720 1.625031 0.418269 1.346736 0.349691 1.735905 1.181438 1.185938 0.537355 1.048431 0.310338 0.725392 0.138830 -0.162626 -0.012235 1.033480 1.181949 0.616925 1.912794 0.918753 0.626238 0.223870 0.664522 -0.078088 0.256973 1.394811 0.721353 1.350998 0.870615 0.111718 1.175636 1.041732 -0.087582 0.658928 1.024480 -0.106481 0.957206 0.153547 0.343423 1.369668 0.634606 0.765343 -0.148776 0.328436 0.827668 1.133483 1.461950 0.929478 0.348570 1.212214 0.446866 0.848436 0.219387 1.773456 1.168998 0.793903 0.614230 1.089360 1.446367 1.640320 0.120507 0.926616 0.816912 0.468029 0.525200 0.868913 1.510302 1.541893 -0.030330 0.055242 0.070867 0.042035 1.687456 0.144651 -0.241563 0.096801 -0.095086 0.917714)
     )

;;; 81 odd -------------------------------------------------------------------------------- ; 9
(vector 81 11.372210502625 (fv 0 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1)

     8.926326 (fv 0.000000 0.164735 -0.380225 0.081555 1.097918 1.524480 0.077656 0.977304 0.407700 0.831319 0.533822 0.615403 1.642513 -0.058036 0.444751 1.446330 0.995710 0.841112 0.528746 0.832226 0.248085 0.502898 1.190162 0.745146 -0.208212 0.492995 1.110378 0.980131 0.817203 1.338834 1.000001 1.336192 1.804389 0.900670 0.555661 1.748659 0.603816 0.728857 -0.167279 1.058563 1.176033 1.277029 1.122180 1.127499 -0.224172 0.316000 1.080199 0.508511 0.252234 0.338999 0.400496 1.857653 0.607017 0.245631 0.807136 -0.037588 -0.063570 1.552479 1.126540 0.180335 0.976685 0.410774 1.244176 1.541645 1.450598 0.050542 0.208414 1.102430 0.959489 0.189328 0.354550 1.724776 1.384943 0.545643 1.965929 0.479461 0.756949 1.038515 -0.004640 1.477899 0.906680)
     )

;;; 82 odd -------------------------------------------------------------------------------- ; 9.0554
(vector 82 11.662058134504 (fv 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 0)

     8.895498 (fv 0.000000 1.650756 0.929235 0.669074 0.458613 1.575883 1.406092 1.106790 0.596730 0.021347 1.134970 0.616933 1.701827 0.504785 1.614982 1.519418 0.470952 1.289129 0.059550 0.427695 0.231422 1.559220 0.383709 0.161407 0.068209 -0.031038 1.865998 -0.109083 1.124535 0.249567 0.520329 0.463755 1.759816 0.122747 -0.063135 1.879507 0.089457 0.845717 1.061947 -0.248630 -0.240924 0.207853 1.548893 0.621489 0.599673 1.031885 -0.104736 1.726398 0.898686 0.128558 0.928155 1.723232 0.730130 1.329452 0.779285 1.207734 0.370523 1.269134 1.812531 0.562255 0.696469 1.440871 0.214062 1.838981 0.082605 1.605017 1.504365 0.122097 0.273097 0.895327 0.555120 -0.358045 0.959494 0.864915 1.049696 1.458692 1.063317 -0.105762 0.240946 0.516137 0.295184 -0.035654)
     )

;;; 83 odd -------------------------------------------------------------------------------- ; 9.1104
(vector 83 11.732900669843 (fv 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1)

     9.060733 (fv 0.000000 0.847614 1.074595 0.345210 0.202371 1.511917 1.112425 0.572830 1.582187 0.218687 0.979697 0.829284 0.504832 0.409321 1.581223 1.031036 0.666780 1.347208 1.680503 1.486577 0.618089 -0.256946 0.905019 0.230952 0.059969 -0.145434 0.545921 0.384376 1.384380 0.665205 1.583895 0.055621 1.669433 1.386960 1.917214 0.552314 1.477586 0.229404 -0.049820 0.210015 -0.192839 1.819422 0.656731 1.258726 0.062676 0.649682 -0.033937 1.076469 0.763030 0.654748 1.032680 0.850557 0.101236 1.303860 1.683735 0.917766 1.133625 0.788918 0.091033 0.752267 0.650807 0.661591 0.956487 -0.151184 1.699725 0.067039 0.562858 0.669739 1.945082 0.507537 0.168655 1.291963 1.367257 0.073343 1.018407 0.584241 1.284655 0.733315 0.794277 0.838058 0.819351 1.776021 0.236189)
     )

;;; 84 odd -------------------------------------------------------------------------------- ; 9.1652
(vector 84 11.626023292542 (fv 0 0 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 1 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1)

     9.185550 (fv 0.000000 -0.021653 -0.040601 1.163796 1.903509 0.943755 0.646624 1.866284 1.925515 0.123826 0.553199 0.965947 -0.075756 1.082744 1.817561 1.285536 1.050220 0.807240 0.605743 0.429498 0.508235 1.302559 1.611197 -0.514061 0.753992 1.700832 1.582166 0.521137 0.493019 0.834823 1.698189 0.272829 1.846496 1.874128 0.834101 0.281869 1.080560 1.438521 0.953941 1.280344 1.022208 1.661905 1.607595 1.126422 0.777808 0.689451 0.023149 0.691721 0.542242 0.838865 0.011483 1.098563 0.333470 0.611697 0.199907 -0.091248 0.912993 0.515958 1.079940 1.005613 0.731323 0.930947 0.301128 0.363360 0.978049 -0.000124 -0.516420 0.523117 0.574889 0.270432 1.275532 0.818251 1.531964 1.322842 0.207974 1.087144 1.315578 0.094014 1.345898 1.884730 0.414183 1.230212 1.440972 0.367718)

     ;; (fv 10.778808034738 -0.227659005925 3.1786048937356)
     ;; 10.7788 (fv 0.0000 0.9393 1.9022 0.8886 1.8986 0.9322 1.9893 1.0700 0.1743 1.3021 0.4535 1.6284 0.8269 0.0490 1.2946 0.5638 1.8566 1.1729 0.5128 1.8762 1.2632 0.6738 0.1079 1.5656 1.0469 0.5517 0.0801 1.6320 1.2075 0.8066 0.4292 0.0754 1.7452 1.4385 1.1554 0.8959 0.6599 0.4474 0.2586 0.0933 1.9515 1.8334 1.7387 1.6677 1.6202 1.5963 1.5959 1.6191 1.6659 1.7362 1.8301 1.9476 0.0886 0.2531 0.4413 0.6530 0.8882 1.1471 1.4295 1.7354 0.0649 0.4180 0.7947 1.1949 1.6186 0.0660 0.5368 1.0313 1.5493 0.0909 0.6560 1.2448 1.8570 0.4929 1.1522 1.8352 0.5417 1.2718 0.0254 0.8027 1.6034 0.4278 1.2757 0.1471 )

     9.165706 (fv 0.000000 0.934656 0.009740 0.892912 1.914788 0.817407 -0.047164 1.003969 0.164884 1.249319 0.380071 1.616476 0.954376 0.202231 1.312292 0.604557 -0.077459 1.312472 0.754364 -0.003767 1.276135 0.650523 0.170854 1.618591 1.053160 0.577476 -0.205916 1.453889 1.286143 0.889924 0.243897 -0.239706 1.833300 1.444468 1.151374 0.857183 0.586020 0.323924 0.036983 0.119493 -0.037558 1.940953 1.593882 -0.092635 1.798428 1.555339 1.399215 1.467642 1.835150 1.833867 -0.004678 -0.067916 0.264183 0.072836 0.826599 0.656778 1.089237 1.011513 1.337524 1.652586 0.118011 0.621082 0.947811 1.150679 1.538842 -0.108726 0.395215 0.886557 1.570811 -0.049501 0.809380 1.348209 1.743527 0.295071 1.055258 1.946886 0.463731 1.299054 0.188329 0.827519 0.037317 0.845744 1.341936 0.257273)

     9.138477 (fv 0.000000 1.077136 0.063003 0.974335 0.001930 0.872203 0.017246 1.080670 0.235219 1.252888 0.378851 1.612382 0.956324 0.200975 1.336006 0.666511 -0.109401 1.250621 0.645704 -0.034379 1.373066 0.621844 0.153419 1.662637 1.014313 0.564772 -0.158790 1.458303 1.312400 0.935605 0.228083 -0.303405 1.933909 1.508310 1.203183 0.851210 0.700949 0.260045 0.137593 0.186330 -0.029149 0.093187 1.669321 -0.022893 1.804433 1.569916 1.547568 1.535838 1.866608 1.883016 0.163191 -0.079249 0.336381 0.043460 0.741963 0.718443 1.177177 1.028118 1.387506 1.729902 0.144100 0.716901 1.003307 1.132902 1.504355 -0.063217 0.409728 0.962060 1.632348 0.020339 0.842809 1.386919 1.688164 0.250155 0.883600 1.992873 0.466027 1.340844 0.278519 0.955099 -0.020386 0.926876 1.398431 0.248264)

     9.133456 (fv 0.000000 1.059401 0.031287 0.939386 -0.017860 0.901644 0.001799 1.027990 0.230681 1.311963 0.341928 1.644077 0.966811 0.236475 1.300649 0.692497 -0.027953 1.347389 0.723063 -0.003313 1.322772 0.582050 0.159545 1.703814 1.026586 0.555590 -0.158337 1.444034 1.321735 1.003900 0.274358 -0.325622 1.927342 1.457207 1.230507 0.919830 0.720469 0.244803 0.085297 0.173845 -0.048361 0.080359 1.671325 0.039907 1.736091 1.631912 1.486133 1.471880 1.784848 1.922823 0.107240 -0.103436 0.280519 -0.025774 0.700275 0.720167 1.157653 1.036798 1.295565 1.717341 0.156191 0.724169 1.042098 1.172208 1.529978 -0.089227 0.426393 0.952547 1.692201 0.117254 0.809203 1.354853 1.694705 0.278490 0.926144 0.035100 0.434956 1.402186 0.356337 0.912787 0.017302 1.021860 1.401595 0.333844)
     
     )

;;; 85 odd -------------------------------------------------------------------------------- ; 9.2195
(vector 85 11.829360154975 (fv 0 0 0 1 0 0 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 1)

     9.172932 (fv 0.000000 1.198268 -0.046093 0.496651 0.155499 0.438914 1.717129 -0.153996 0.255959 0.942459 -0.112043 1.664994 1.597976 1.071752 0.293731 1.489898 -0.088206 1.402767 1.814932 1.099748 -0.400724 1.351064 1.265640 1.075629 0.060651 -0.371046 0.814537 0.326687 0.633977 1.654428 1.582553 0.618025 1.054016 1.391986 1.098803 0.284271 1.476963 1.042434 1.922088 0.305413 -0.626240 1.791879 1.777727 0.678099 1.505684 1.182071 0.629820 1.357783 0.665420 0.341784 0.926591 0.193623 1.006880 1.192651 -0.116178 0.080172 1.591790 1.522361 0.438822 1.766471 0.395503 1.446548 -0.046614 0.961931 0.316539 0.616763 1.087859 0.290761 0.142685 0.155135 0.508154 0.686168 1.471184 1.165229 0.372220 0.294409 0.404832 -1.767095 1.243980 0.993281 1.007462 0.784244 1.104711 1.671816 0.086342)
     )

;;; 86 odd -------------------------------------------------------------------------------- ; 9.2736
(vector 86 12.140432277993 (fv 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1)

     9.213343 (fv 0.000000 0.676268 0.369198 1.486263 -0.026625 0.678855 0.928889 1.200870 0.763422 0.131815 -0.064018 0.334478 0.754549 0.549209 0.781916 -0.164085 1.831169 -0.359871 0.452632 0.395640 1.217523 1.666783 1.263104 0.462675 0.487261 1.713262 0.419400 0.982422 0.818648 0.009279 0.749148 0.986045 1.410580 0.251205 1.543152 0.685375 0.249458 0.699138 0.175620 0.312944 1.884362 1.099441 1.640835 1.728596 -0.397229 1.509431 0.364317 1.073248 1.571193 0.690550 1.201949 -0.104903 0.984182 0.850373 -0.106842 1.582861 -0.052279 0.837387 1.423896 1.118738 -0.077783 0.539913 1.394923 -0.009295 1.541216 0.438460 0.217352 0.527395 0.855264 0.357004 0.424674 0.870332 0.435096 0.770273 0.096843 1.702425 0.991351 1.315154 1.133850 0.440564 0.044541 0.788769 0.138246 -0.080948 1.096067 0.575869)
     )

;;; 87 odd -------------------------------------------------------------------------------- ; 9.32737905
(vector 87 11.937030388359 (fv 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 1 0 0 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1)

	9.317037 (fv 0.000000 1.269780 0.764198 1.382169 0.560101 1.397366 0.619615 1.110127 1.074742 0.786154 0.097129 0.187903 1.280480 1.001234 0.625991 -0.253578 0.524611 0.642531 0.754319 1.395067 1.865340 0.173765 1.213561 0.413784 0.704706 0.640451 1.483492 1.299442 0.783307 0.912207 0.977809 1.588075 -0.173310 1.063721 0.534821 0.450809 0.251070 0.792950 1.489833 1.745329 1.098607 0.960633 0.682333 0.343541 0.677820 0.343804 -0.007548 0.114569 1.083276 0.044826 0.931689 1.109596 -0.582840 1.287598 0.295851 -0.261696 1.183896 0.581304 -0.088958 1.623439 0.434479 0.025514 0.230711 1.672013 0.717129 1.395826 0.682208 -0.299168 -0.096350 -0.604219 1.679467 0.411395 0.711815 1.234251 0.324421 0.995113 0.167630 0.383406 0.968742 0.310771 0.425004 0.820195 0.922682 1.343873 0.606017 -0.248788 1.112139)
     )

;;; 88 odd -------------------------------------------------------------------------------- ; 9.3808
(vector 88 12.128922775356 (fv 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1)

     9.324023 (fv 0.000000 0.720070 1.146170 1.623229 0.919914 1.475051 1.669418 0.417706 1.222880 1.077800 0.636671 0.109954 0.709268 0.401961 1.342317 0.470950 1.038199 -0.014165 -0.223115 1.401527 0.255061 -0.053613 1.038430 1.524899 0.900064 0.540757 0.958685 1.268571 0.665381 1.798791 1.658869 0.625852 0.519615 0.589311 -0.003435 1.345809 -0.056260 0.616788 0.290786 1.478184 0.854964 0.750706 1.853143 1.837616 0.068009 0.196260 1.496079 0.820255 1.744388 0.146057 0.230788 1.434358 -0.205448 1.616936 0.981163 0.921532 1.591565 1.188825 -0.476209 1.518808 0.443241 0.115647 0.334751 1.367563 0.160132 1.179927 1.012776 0.498582 1.276116 0.704338 1.396987 -0.001804 0.959954 1.167324 1.287070 1.914346 1.400505 1.413492 1.484414 -0.463663 0.122173 0.488918 -0.038072 1.041389 -0.101511 -0.067115 1.661217 1.643428)
     )

;;; 89 odd -------------------------------------------------------------------------------- ; 9.4340
(vector 89 12.362 (fv 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0)

     9.331615 (fv 0.000000 0.049094 0.763150 0.136548 0.483778 0.759076 0.333224 1.220929 0.134557 0.764345 0.615745 -0.054859 0.470862 1.549452 1.042755 0.304443 0.281140 1.178803 1.496311 1.304814 1.254180 1.214938 -0.188361 1.642263 1.456263 1.200682 1.159330 0.518402 1.259168 1.450349 0.156876 1.423052 0.526144 0.557187 0.211944 1.876505 0.927439 -0.029530 0.421763 1.206664 0.690297 1.789526 1.067082 0.003086 0.897179 1.065326 1.434687 0.576391 -0.150316 1.287422 1.126966 1.259277 1.431443 0.305104 0.343134 0.824875 1.068860 1.722713 1.668311 0.909968 1.314221 0.346498 0.614998 0.306500 1.059400 1.495807 -0.733779 1.277563 0.627585 1.184462 -0.276841 0.360604 0.535684 -0.101891 0.124422 1.197248 0.778353 1.945787 1.307086 0.922575 0.921600 0.870062 1.105219 1.606237 0.868032 -0.120196 0.316193 -0.191814 0.432808)
     )

;;; 90 odd -------------------------------------------------------------------------------- ; 9.4868
(vector 90 12.309 (fv 0 0 0 0 1 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 0 1 0 0 0 1)

     9.421684 (fv 0.000000 0.773463 -0.034237 0.815187 0.818292 -0.048506 -0.025177 1.145716 1.124687 -0.087471 0.982715 1.911529 0.885016 -0.169554 0.478422 0.410159 1.012688 0.169228 0.764485 0.758910 1.289872 0.618276 -0.229660 1.549110 0.758331 0.279930 1.553579 0.672439 0.162166 0.690601 0.847281 1.562839 1.023152 1.146052 1.063766 0.943600 -0.316637 0.816595 1.430319 0.223152 0.862408 0.935019 0.764642 0.942440 1.888157 1.614273 1.641359 1.139335 1.700104 1.516977 1.001915 0.698936 0.890613 1.412580 1.482707 0.374132 0.486389 0.409585 0.664613 0.728056 0.135717 1.017586 1.427256 0.114262 0.459920 0.985474 0.828118 0.029864 1.115880 0.182529 0.074455 0.121011 1.384155 1.498024 1.812648 0.488592 0.254186 1.880026 1.059948 0.152702 0.760476 0.236696 1.396118 1.492214 0.743805 1.035917 1.060796 0.484826 0.509085 -0.305704)
     )

;;; 91 odd -------------------------------------------------------------------------------- ; 9.5394
(vector 91 12.351367950439 (fv 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0)

     9.456608 (fv 0.000000 0.103422 0.965610 0.946880 1.775735 -0.122619 1.034051 0.168472 0.730448 0.272671 0.778481 0.021689 0.033093 0.984786 1.059637 0.145824 1.327186 1.317989 0.064861 1.738590 0.743092 0.115729 -0.009073 0.235258 1.253963 0.597261 1.473274 1.451939 1.654969 1.556762 -0.031925 0.584248 1.188923 1.752060 0.699420 0.272619 1.021928 1.546707 1.001394 0.687724 1.015815 0.834084 -0.085438 1.600278 0.991105 1.336531 1.547902 0.640465 0.462581 1.062100 1.213310 0.321259 0.291622 0.063730 0.566090 0.852786 0.847201 -0.174185 1.395263 1.222072 0.870150 0.708746 0.513822 0.978903 0.739358 1.760219 0.991895 1.423353 0.493188 0.952658 -0.084183 1.857020 1.060335 -0.192588 0.702407 1.144217 1.162221 1.656319 1.357097 0.810997 -0.196628 1.185541 1.692605 1.048778 1.191279 0.597890 1.575870 0.403387 0.283378 0.378021 0.172627)
     )

;;; 92 odd -------------------------------------------------------------------------------- ; 9.5916630
(vector 92 12.280749613899 (fv 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 0 1)

     9.552661 (fv 0.000000 1.217977 1.385618 0.939614 0.500483 1.851006 0.319542 1.708679 0.556310 0.891376 0.674923 0.365733 -0.175465 0.892985 1.540146 0.973262 0.317469 1.925159 0.685389 1.371188 0.200154 1.709968 0.177693 -0.300538 0.695154 0.829261 0.826887 0.518213 1.033752 1.220316 0.472703 1.153927 1.069740 0.054639 0.285291 1.692400 0.723359 -0.010143 1.422901 0.759732 0.421539 1.178988 0.292771 1.282542 0.969261 0.723210 1.587532 1.451565 0.985309 0.576854 0.032105 1.279589 0.637040 0.836814 1.053214 1.607968 0.083343 0.618958 1.664826 -0.072056 0.366474 1.110340 1.463534 0.789016 1.455017 1.061490 0.999534 0.659448 0.541265 1.191626 1.594463 0.899514 1.279707 0.844186 0.855539 -0.116804 0.909316 1.750334 1.598414 1.853269 0.368452 0.535158 0.818452 1.438032 0.503813 0.301666 0.154109 0.506999 0.079492 -0.057406 1.894913 0.600742)
     )

;;; 93 odd -------------------------------------------------------------------------------- ; 9.6437
(vector 93 12.403578299298 (fv 0 1 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1)

     9.628761 (fv 0.000000 1.192712 1.317592 0.793671 0.099933 -0.070495 0.916675 1.443504 0.876536 1.333886 0.502339 0.879490 0.963974 1.813405 1.616449 1.406560 0.249623 1.099165 1.684130 0.971324 1.504790 0.210004 -0.334645 1.442259 0.574758 1.021850 0.284510 0.399479 0.184247 1.487488 1.612401 -0.235561 -0.129797 0.178650 -0.371978 0.920412 -0.107159 0.561074 0.178586 0.184745 -0.019738 0.790773 0.250122 1.738768 1.375989 -0.216295 -0.331946 0.885688 1.988915 0.048056 0.095104 0.757409 -0.209034 0.574534 0.777126 1.337323 -0.015675 1.471677 1.723082 0.373584 0.844517 1.228790 1.358490 1.817661 1.097143 1.261125 0.949204 1.719884 0.720744 1.257519 0.078221 -0.091904 0.999562 0.486340 0.282135 0.639284 -0.163690 1.618168 0.349231 0.088441 0.985965 0.932832 1.613134 0.712978 1.300533 1.211114 1.605834 1.719815 0.768198 -0.076989 1.468170 1.231822 0.852206)
     )

;;; 94 odd -------------------------------------------------------------------------------- ; 9.6954
(vector 94 12.789479876738 (fv 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1)

     9.653914 (fv 0.000000 1.588712 0.970594 0.765681 0.768893 0.708013 1.088997 0.348116 1.304828 0.302466 0.484457 0.598101 1.195823 1.750495 0.723696 -0.394564 1.399290 0.440079 0.957225 0.110914 1.178680 -1.746723 0.306178 1.424281 0.083938 -0.026412 0.531864 1.282735 0.186630 0.411663 1.537740 0.224065 -0.422374 0.338118 1.366092 0.348038 0.469097 0.358167 1.178154 1.072296 0.953715 0.778556 0.718707 0.831159 0.966980 0.639988 0.294231 -0.156503 1.325326 0.192979 0.424804 0.332961 0.198719 0.405180 1.172779 0.251315 0.565156 0.903572 0.754645 0.195819 1.584153 1.274227 0.370217 1.346701 0.041617 1.218979 0.515044 1.085194 0.964032 1.907141 0.492814 1.684100 -0.290159 1.467461 0.104316 0.280575 0.761449 1.432721 1.137691 0.132533 1.823280 1.230711 -0.052109 1.493267 1.265211 0.071008 1.206644 0.630379 0.639830 0.932228 -0.085525 1.738146 1.623323 0.751204)
     )

;;; 95 odd -------------------------------------------------------------------------------- ; 9.7468
(vector 95 12.575266058635 (fv 0 1 1 0 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 0 0)

     9.716924 (fv 0.000000 1.295576 0.051583 -0.370221 1.659103 1.560139 0.883258 1.136184 1.446082 0.336165 0.984827 1.426922 1.840974 1.223315 0.635432 0.990680 0.332450 0.247993 0.361771 1.193162 0.200656 1.699397 1.071493 0.299430 0.743325 0.167398 0.140913 0.844624 1.382714 1.375685 0.647006 0.229451 0.386840 1.780080 0.889230 1.061105 0.116922 0.567648 1.435830 1.255231 0.833620 1.820993 1.158323 0.868650 0.833531 0.419654 1.734245 1.273400 1.062531 1.460253 0.175543 0.639252 0.712611 1.085237 0.872288 1.639660 -0.093743 0.087045 -0.323684 1.687923 1.002234 -0.168363 1.044853 -0.114093 1.195353 -0.026012 0.883764 1.512322 0.102179 0.114077 1.256119 1.084835 0.251990 0.992344 0.663746 0.903707 0.809231 1.141845 1.353235 1.559958 0.119755 1.444404 1.912417 1.220976 -0.164602 -0.295612 1.393445 0.425402 1.426929 1.201811 0.614353 -0.027563 1.025805 1.054465 0.134046)
     )

;;; 96 odd -------------------------------------------------------------------------------- ; 9.7980
(vector 96 12.803173065186 (fv 0 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 1 1 0)

     9.759447 (fv 0.000000 0.435576 1.538976 0.230825 0.102821 0.263319 0.997316 0.091618 0.472323 -0.103132 0.585027 1.906149 0.670612 1.002137 1.281685 0.083578 0.271396 0.433634 0.733402 0.099534 0.807149 -0.070119 0.575530 -0.103613 0.335070 1.262648 1.473382 0.330894 0.589593 0.216256 0.350636 1.350446 1.836442 1.560161 1.205882 0.649393 0.812682 0.141066 1.111869 -0.141497 1.693969 1.777393 0.080165 0.375196 0.449681 -0.067423 0.754077 0.868345 1.797143 0.793576 0.568117 0.646818 1.350309 1.187659 1.791215 0.862642 1.742949 1.213798 0.583814 0.650546 0.965237 1.015772 0.605956 0.144297 0.285298 -0.351085 1.282066 0.474001 0.642725 0.511289 1.457452 0.929763 1.241810 0.227521 0.228779 1.199150 1.811444 -0.006366 0.744946 0.179491 1.361847 -0.378016 1.423650 1.452225 1.393417 1.335482 0.037183 1.548694 0.890495 0.461455 1.744132 0.896894 0.307836 1.812808 0.221251 0.928513)
     )

;;; 97 odd -------------------------------------------------------------------------------- ; 9.8489
(vector 97 12.837450993031 (fv 0 0 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1)

     9.832277 (fv 0.000000 0.379259 1.470054 0.135241 -0.137798 1.476571 0.223942 1.269139 1.617761 0.578479 1.659896 0.192321 0.628723 1.030748 0.068332 0.935772 0.702035 -0.308246 0.093619 0.687832 0.312122 0.952725 0.646784 0.815901 0.600402 0.700649 0.257079 0.728929 1.512814 0.133748 -0.161439 1.667289 1.756964 0.419090 1.460039 1.221568 0.216587 0.357346 0.560096 0.621329 1.423958 -0.140419 -0.285305 1.752977 0.296245 1.796763 0.502171 1.837539 -0.068388 -0.176521 1.655407 0.652714 1.571976 1.231728 0.781936 1.899698 1.696905 1.070324 0.093931 0.071079 0.376824 0.772939 1.099059 0.004831 0.221806 1.727680 0.800189 0.011067 0.690398 0.512420 0.475317 0.941280 1.720146 1.587206 0.923080 0.792083 0.180477 -0.133205 1.214230 1.814657 0.679279 0.282075 1.334889 1.751170 1.536951 0.882536 0.418450 0.834681 -0.026902 0.654794 0.680161 1.077779 1.525535 0.824205 1.102618 0.673911 -0.106249)
     )

;;; 98 odd -------------------------------------------------------------------------------- ; 9.8995
(vector 98 12.972 (fv 0 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0)

     9.918320 (fv 0.000000 1.126272 0.810135 -0.157043 -0.284411 1.014546 1.656515 0.886620 0.589412 -0.165849 0.041656 1.689870 -0.133502 1.386309 0.753684 1.607028 0.455527 0.729530 1.603812 -0.176801 0.980471 1.557823 1.120428 0.608500 -0.040856 1.654422 1.694414 1.546900 1.545046 0.721205 0.133219 1.189224 1.204719 1.195353 1.299299 -0.156627 0.826681 -0.088693 0.692437 1.036020 0.358333 1.488711 1.027717 0.069063 1.141577 0.328360 0.719016 0.851669 0.356065 0.712122 1.039551 1.236061 1.577925 0.317909 -0.158255 0.050224 -0.509790 1.519264 0.203085 -0.063235 0.037529 0.962155 1.059331 0.698574 0.810336 0.743673 1.683751 0.457113 0.419520 0.759860 1.462788 1.502247 0.636526 0.416346 0.963144 1.154048 0.694553 0.104918 -0.349860 1.108892 1.631062 0.589884 1.392769 1.258082 0.568391 0.753256 1.211016 0.009043 0.817095 0.265385 1.455548 1.585953 1.547698 1.855964 1.737942 0.229735 1.055700 1.696455)

     ;; pp:
     9.852643 (fv 0.000000 0.515219 1.262972 1.697020 0.335436 0.889905 1.519089 0.044736 0.650497 1.270750 -0.178917 0.674989 1.450432 0.254900 1.097572 -0.107043 0.651195 1.335130 0.272796 1.297874 0.224159 0.962708 0.053062 1.193382 0.101327 0.836439 -0.105754 1.215012 0.128574 1.109391 0.442046 1.523411 0.553345 1.725474 0.541762 -0.127793 1.417975 0.631717 1.576620 0.767281 0.059112 1.609436 1.033347 0.556109 1.727081 1.010442 0.702568 -0.141336 1.349027 0.669399 0.583528 0.147350 1.497924 0.934945 0.610721 0.101044 -0.019997 1.772284 1.165297 0.883648 0.540756 0.695909 0.051843 0.036770 1.823953 1.940217 1.253231 1.381574 1.135330 0.962885 1.084109 1.188033 1.135270 0.827723 0.748628 1.126276 1.272339 0.770370 1.246808 1.223016 1.570254 1.399310 1.628085 1.829166 -0.154940 0.353005 0.721669 0.726808 0.892330 1.197955 1.533013 0.212675 0.669097 1.140181 1.156217 1.790457 0.422623 0.510791)
     )

;;; 99 odd -------------------------------------------------------------------------------- ; 9.9499
(vector 99 13.000000000002 (fv 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0)

     9.927757 (fv 0.000000 0.612324 0.079141 1.434202 1.000660 0.891242 1.012263 -0.017562 0.996629 0.611063 1.321217 1.621637 1.504948 1.624898 0.001412 0.412734 0.326019 1.366721 1.072960 0.116515 0.715979 -0.740444 1.161301 1.297736 1.041757 0.027020 1.458453 1.107119 0.363908 1.415543 1.763457 0.255777 0.686434 -0.085735 0.651473 1.217063 -0.047283 1.151992 0.790695 -0.152103 1.647917 0.508714 0.628648 1.408143 1.292464 0.474000 1.003650 0.520847 0.629804 0.218082 0.785490 -0.232867 0.391411 1.172299 0.273141 1.313231 0.427739 0.013232 0.516032 0.610598 1.282766 1.029342 0.967918 1.073490 0.454858 0.915907 0.522595 0.274119 0.827376 0.861574 -0.158909 -0.432703 1.871750 1.122982 0.647824 -0.195710 0.262542 1.053968 0.565099 0.024117 0.401586 0.264805 1.587960 -0.370184 1.152346 1.774247 0.242656 0.316777 1.195086 1.067518 1.112347 0.688842 1.446613 0.608318 1.321142 -0.167020 0.907334 1.022140 1.062351)
     )

;;; 100 odd -------------------------------------------------------------------------------- ; 10
(vector 100 13.117680368039 (fv 0 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 0 0 0)

      9.967820 (fv 0.000000 1.016486 1.075466 0.675161 0.574401 1.527303 0.369311 1.093743 1.758162 0.649535 1.329616 0.683289 -0.464743 0.488528 0.846167 1.093202 0.188464 -0.009742 1.328398 -0.092736 0.866724 1.306141 0.236206 -0.048398 0.065984 1.250377 0.880265 0.529903 1.908284 0.909975 0.870318 1.170730 0.401807 0.051428 1.546047 -0.084383 1.553645 1.723234 -0.192262 -0.005451 0.846559 1.396413 0.793410 1.734419 0.268618 0.782362 0.300041 0.085963 0.406528 -0.058412 0.759019 0.311738 0.688186 1.163736 0.207596 0.957152 0.518038 -0.238894 1.966069 0.254028 0.497859 0.406362 0.948142 0.108565 0.809242 0.618274 0.008503 1.224166 0.619792 -0.063172 1.170177 1.631095 0.360399 0.496092 1.173684 1.571576 1.461266 0.250954 0.485376 0.293914 0.241987 0.266855 1.299097 1.747740 -0.157940 1.025403 0.055859 0.443647 -0.030039 1.366811 0.369467 1.523632 1.262832 1.148761 0.265795 -0.397124 0.678718 0.978216 1.111928 1.121642)
      )

;;; 101 odd -------------------------------------------------------------------------------- ; 10.0499
(vector 101 13.28250751675 (fv 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 1)

      9.964634 (fv 0.000000 -0.073111 1.535769 -0.102555 0.949824 0.661791 1.376397 0.389320 1.429271 1.382915 0.702074 0.190023 0.165010 0.880936 1.053717 0.381858 1.515003 1.204543 0.504035 0.920455 0.391206 0.949414 1.113429 0.554900 1.897469 1.768789 1.766679 1.550589 0.402518 0.254763 0.394916 1.625563 0.833640 0.744524 0.452145 -0.082936 0.892795 1.873582 1.781184 -0.418454 1.636196 -0.022737 0.903335 -0.412208 1.924024 0.194797 -0.087158 0.651748 1.188278 0.341571 0.583987 1.814760 1.207941 1.789448 0.551284 0.991618 0.259118 0.282624 1.011184 1.611901 1.372798 1.012968 0.839711 1.331909 1.264042 0.325794 0.343316 -0.075857 -0.460634 0.488689 1.512646 1.806638 1.012723 -0.303497 1.575625 0.027198 0.002241 1.290806 1.657896 1.438044 0.654010 1.150362 0.652919 1.476118 -0.053999 -0.024155 0.726437 0.454484 1.497660 0.765182 0.287065 1.425963 0.079052 0.750136 1.836142 1.337567 -0.185862 1.924720 -0.153672 0.400041 1.450120)
      )

;;; 102 odd -------------------------------------------------------------------------------- ; 10.0995
(vector 102 13.159336831147 (fv 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0)

      10.045766 (fv 0.000000 -0.279070 0.173878 0.081403 1.768938 1.607495 0.603256 0.555897 0.375867 1.098499 0.557935 1.658062 0.679353 0.435605 1.704584 0.882188 0.675710 1.226519 -0.017413 0.221732 -0.211376 1.307302 0.689909 0.655783 0.993058 0.615004 1.764502 1.131327 0.119482 0.185094 1.035751 1.439320 1.373211 1.418236 0.503946 0.310742 0.195150 1.345393 1.645648 0.392993 0.050135 0.685592 0.243679 0.754096 0.965418 1.162001 1.767714 0.912263 1.540226 0.989163 0.153496 1.180193 0.495181 0.826820 -0.194339 1.268780 1.482827 -0.154668 1.003093 0.057371 1.563631 1.606126 0.908893 1.017810 0.439667 -0.174146 0.280275 0.399111 1.342959 -0.098826 1.087834 1.050762 0.557805 0.752893 -0.400427 0.095731 0.689016 0.552247 0.778927 0.058727 0.428406 0.269116 0.480708 0.192361 0.563638 0.686642 0.128600 1.864221 -0.045520 1.018032 1.780635 -0.005046 0.881801 1.021244 0.513775 1.482476 0.956890 0.518235 1.186738 -0.018819 1.609204 0.515712)
      )

;;; 103 odd -------------------------------------------------------------------------------- ; 10.1489
(vector 103 13.142812158651 (fv 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1)

      10.102476 (fv 0.000000 1.369258 0.406430 1.487363 1.300312 1.174178 0.725871 1.118946 0.567934 1.507074 1.421940 0.060397 1.553534 0.366960 0.264364 -0.027869 1.681923 0.350717 1.364154 0.204515 -0.180262 0.842363 0.287472 1.198426 1.756374 1.259211 0.898266 0.187309 0.401610 0.535873 0.048012 0.851696 1.323060 0.925186 0.678890 0.097118 1.570744 0.545725 0.858166 1.853728 0.291531 1.096726 1.166849 -0.045402 1.179837 -0.111020 0.643454 0.486562 1.084325 0.673411 1.808268 0.331853 0.761303 0.506929 0.948787 0.125433 1.093138 1.172704 1.300823 -0.087765 1.061422 -0.231489 1.345595 1.007175 0.463207 0.567128 0.417701 0.867458 1.827132 1.618306 -0.235698 1.268358 1.413906 0.291274 -0.510359 1.287040 0.555326 0.694591 1.555786 1.225983 1.844314 0.908000 0.867329 0.232081 1.454227 0.972019 1.069240 0.133107 0.915878 0.821231 0.471133 1.434428 0.215881 0.667043 0.772841 0.944850 1.153588 0.551253 0.882554 1.134378 0.032596 -0.042233 1.758816)
      )

;;; 104 odd -------------------------------------------------------------------------------- ; 10.1980
(vector 104 13.176067352295 (fv 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 1 0)

      10.168550 (fv 0.000000 0.863337 -0.113966 0.952335 1.179324 1.344589 0.086001 1.784568 0.040939 -0.278342 0.492392 1.373041 1.589416 0.305140 1.040154 0.306852 0.639739 1.605433 -0.082316 1.171614 0.018705 0.877480 0.742834 1.013469 -0.394587 0.679538 1.685340 1.015860 0.451982 1.273683 0.656961 1.380347 0.930414 0.629931 0.875751 1.106458 0.854029 1.097615 0.942886 1.634232 -0.087153 1.214976 0.912099 1.026106 0.377766 0.938615 0.980356 0.179306 0.223817 1.145177 1.622990 0.100820 0.989970 1.826246 0.934306 0.310115 -0.012658 0.179983 -0.026220 0.755024 0.027968 0.662514 0.819461 1.633236 1.403644 1.156857 1.356308 1.542286 1.253871 1.012715 0.852908 0.924116 0.022097 0.368327 -0.090612 1.052696 -0.034185 0.655336 -0.097080 -0.157717 1.261805 0.337757 0.457703 1.158886 1.296591 0.128958 1.630443 0.809473 0.920747 1.393423 0.696288 0.328360 1.336354 1.510499 1.486152 1.947494 0.779240 0.349685 0.612445 1.433252 1.461547 0.826387 0.679858 -0.337976)
      )

;;; 105 odd -------------------------------------------------------------------------------- ; 10.2470
(vector 105 13.491228801467 (fv 0 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0)

      10.115828 (fv 0.000000 0.049019 1.344835 1.091641 0.665700 0.968893 0.648602 0.707898 1.514354 1.538919 0.526334 1.493761 1.624995 0.707437 0.593803 0.874212 1.543010 1.853745 0.426397 0.026573 1.615940 1.506593 0.465693 1.159200 -0.404908 1.664358 0.782410 1.352302 -0.234654 1.360029 1.390064 0.562127 0.900595 -0.305834 1.198378 1.369945 1.005775 0.397773 0.628843 1.626964 0.837449 1.061154 1.446306 1.380391 1.599960 0.270806 1.328543 -0.187842 -0.215850 0.275407 1.674813 1.481684 0.685411 -0.076514 1.172112 0.021028 -0.282040 0.805083 0.169438 0.519532 1.238467 0.912197 -0.108203 0.770912 1.223603 1.260598 0.243317 1.416653 -0.085803 1.793597 1.018898 0.209596 0.637018 0.680644 1.218601 -0.251927 1.342315 0.794662 0.530948 1.151958 0.965018 0.768542 0.003792 0.487969 1.528116 0.185132 1.582165 0.376426 0.269883 0.979543 1.678175 1.757906 1.492507 0.386900 1.219606 0.328787 1.292795 -0.100060 0.401454 0.164930 0.339091 0.226350 0.418706 -0.115549 1.296351)
      )

;;; 106 odd -------------------------------------------------------------------------------- ; 10.2956
(vector 106 13.091135978699 (fv 0 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 1 0)

      10.198335 (fv 0.000000 0.831679 1.059524 0.595983 0.203261 1.202829 1.655547 1.163399 0.731912 1.050991 -0.085268 1.049064 0.669107 0.707558 1.587356 0.103456 0.095032 1.177165 1.677580 0.458849 0.488238 1.294418 -0.328225 1.742764 0.960376 0.232688 1.221102 1.139466 1.165521 0.274312 -0.217213 1.769983 -0.106435 0.980799 0.424668 1.120797 1.738923 1.408831 0.326124 1.349134 0.307375 0.275240 0.392410 1.221176 0.352509 0.866366 0.344959 0.656333 0.909394 0.940268 0.976614 0.141881 0.684412 0.786921 -0.062121 -0.010568 1.690036 -0.088688 1.427313 -0.052874 1.785355 0.109989 0.958795 1.179624 0.324837 1.229886 1.616903 1.768092 1.318950 1.675999 1.563712 0.225381 0.575251 0.774252 -0.022742 1.783220 1.405786 0.332796 1.613495 1.352845 1.308309 0.373980 1.918112 1.162561 0.910064 1.737277 1.152808 -0.033675 0.058425 1.406045 -0.253836 0.991335 1.479963 0.005130 1.832773 0.614974 0.073456 1.352269 1.161897 0.192184 0.857686 0.091488 0.263380 1.392944 0.202339 1.603064)
      )

;;; 107 odd -------------------------------------------------------------------------------- ; 10.3441
(vector 107 13.537808159641 (fv 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 0 1)

      10.295953 (fv 0.000000 1.453513 1.655211 0.102988 0.785431 1.249929 -0.025066 1.750838 0.347673 1.604380 1.551092 0.115495 1.639861 1.667898 0.228709 1.701673 0.201321 1.045139 -0.312647 0.175688 0.855996 0.160415 1.472612 0.763114 0.800624 0.361142 1.295288 0.490786 -0.039842 -0.032740 0.339591 1.592008 0.669279 0.117545 -0.109117 1.018536 0.901071 0.716433 0.346971 1.020475 -0.173945 0.889314 0.077058 1.765220 1.318363 1.591641 1.626283 0.012132 1.508938 0.471426 0.670071 1.171727 0.339306 0.138717 0.336161 0.439088 1.260263 -0.187548 0.396198 0.258209 0.100455 1.039650 0.818140 1.958400 1.117502 0.697124 1.567939 -0.332396 0.783424 1.205431 0.709006 -0.344647 0.483889 0.499549 -0.063258 0.695169 0.972581 0.387305 1.779513 -0.022586 1.856190 0.369348 0.297097 0.538965 0.115827 0.894957 1.816307 1.006210 1.611567 -0.212466 -0.136556 0.733243 0.881259 0.131239 1.843996 -0.064517 1.632049 0.217595 1.203085 0.867259 0.064249 0.691138 1.782204 1.811114 1.580857 1.070340 1.558270)
      )

;;; 108 odd -------------------------------------------------------------------------------- ; 10.3923
(vector 108 13.472808406168 (fv 0 1 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 0 1 0)

      10.325467 (fv 0.000000 1.823999 0.121670 1.358801 0.589768 1.029967 -0.433790 1.041582 -1.274122 0.780646 -0.169734 1.604597 1.010159 1.810789 0.632723 -0.206688 0.463178 1.073646 1.521165 -0.178712 1.523791 0.423100 0.144424 0.899019 -0.452142 0.547962 0.895764 1.662227 0.346193 1.471302 -0.164671 -1.901696 0.406602 0.262326 0.474119 -0.030228 1.801622 1.325384 1.588387 0.343116 0.445611 0.273212 0.831258 1.871029 -0.312461 1.896993 1.025139 0.721577 0.726171 0.338346 0.861017 1.378901 0.847116 0.469202 -0.383235 0.452023 -0.496006 1.102062 1.102044 1.646809 0.311243 -0.456688 0.949926 0.520943 0.921326 0.643117 0.781598 1.182150 0.966506 0.456713 0.498859 1.075971 1.927079 0.160322 0.159648 0.419881 0.925743 0.446322 0.326978 1.459788 0.903977 -0.021458 1.063237 1.175806 1.223175 0.258595 0.623246 1.572004 0.621332 1.978290 1.546402 1.672410 0.423727 1.205710 1.436589 0.182917 0.251425 0.718333 -1.375705 0.497395 0.186440 0.550196 0.272118 1.380692 1.012574 0.305814 1.433937 0.098087)
      )

;;; 109 odd -------------------------------------------------------------------------------- ; 10.4403
(vector 109 13.798 (fv 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 0 1 1 0 0)

      10.413972 (fv 0.000000 -0.329332 1.852441 0.301192 0.479205 1.938689 1.086891 1.271023 0.729396 1.367900 1.483662 1.203078 1.940935 0.158023 0.999249 1.513297 0.973974 0.871966 0.600005 0.917499 0.064963 1.625056 1.204390 0.450307 0.459827 1.379619 0.277893 0.390957 1.292297 1.095127 0.941246 0.509853 0.476400 1.479425 1.214972 0.999425 1.144172 0.402758 1.277806 -1.541834 1.224224 0.408937 -0.140267 1.012505 1.167342 0.593542 1.500901 0.801861 0.428256 0.363108 1.278773 0.897271 1.754344 0.238279 0.787476 1.405582 1.439989 1.293816 1.237720 0.491493 1.514000 1.092355 0.055457 1.477338 0.699004 0.040279 0.957508 1.786210 0.481649 0.726028 0.215740 0.216870 1.343437 -0.395385 1.669265 -0.047054 1.724398 0.984510 0.441756 -0.012720 0.257871 1.485641 -0.121426 0.687863 0.835502 1.004805 1.663485 0.780698 1.042433 1.097029 1.089236 1.689246 1.096756 0.293532 0.899560 -0.005695 0.471699 1.241990 1.396400 -0.542444 0.294633 1.091314 0.356171 0.908370 0.648337 1.936350 -0.128643 0.053871 0.188853)
      )

;;; 110 odd -------------------------------------------------------------------------------- ; 10.4881
(vector 110 13.576010454591 (fv 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0)

      10.408073 (fv 0.000000 1.583299 1.129147 0.924363 0.405386 0.106463 0.654471 1.235816 1.676675 1.424024 -0.320821 -0.106137 1.651584 1.223458 1.376470 0.070578 0.035561 0.618393 1.591071 1.247092 1.420738 1.407145 1.068993 1.180774 1.368120 -0.309458 -0.227815 -0.257077 0.341569 0.189699 1.898096 1.209271 -0.362341 0.480813 1.176223 1.497789 1.567432 0.970389 -0.047452 0.764481 1.364232 1.546603 0.838685 0.519999 0.785088 1.840526 0.201375 0.694162 0.995107 0.138310 0.417265 -0.004223 1.430441 0.548174 0.456155 0.879102 0.021026 0.612402 1.448544 1.143273 1.475463 0.804075 0.821149 0.175404 1.164546 0.079156 1.149637 1.448505 1.656091 1.757415 0.521205 0.257194 1.707629 0.482292 1.377093 0.507438 0.991226 -0.612661 0.868064 0.306724 0.414844 0.138628 0.061298 1.129023 1.487975 0.706799 -0.099480 1.383589 0.290834 1.123787 -0.072238 0.982011 0.038233 1.760058 0.405531 0.016972 -0.604791 1.005236 1.670267 -0.215358 1.779967 0.879139 0.413047 1.290874 0.860692 0.804540 1.190191 0.135277 0.110128 0.732322)
      )

;;; 111 odd -------------------------------------------------------------------------------- ; 10.5357
(vector 111 13.709900383304 (fv 0 0 0 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 0)

      10.588903 (fv 0.000000 0.083293 0.444830 -0.213766 0.524915 -0.005956 1.175907 0.783294 -0.343790 -0.015069 1.676924 0.021997 -0.012805 1.023472 0.864450 1.922773 1.431731 1.374839 1.561767 1.633583 0.198147 0.245727 1.910466 0.995751 0.091514 1.666123 0.750477 1.953152 1.512135 0.025831 0.969938 0.804619 0.507564 0.688555 -0.027332 1.433090 0.812479 0.893934 1.245019 0.835304 0.404414 0.839838 0.338429 -0.112731 0.636982 0.099621 1.080987 1.292673 0.177317 1.292327 1.284755 0.253860 0.748555 1.591323 1.605479 0.445460 1.332537 -0.181589 1.668331 0.627699 0.074537 0.208177 0.135644 0.846946 0.614940 0.479986 0.443281 0.299879 1.767930 1.411021 -0.391645 0.057816 1.376551 1.471560 -0.203049 0.453124 0.061036 0.704839 1.379390 1.848624 0.771131 -0.036797 0.007834 1.611881 1.733830 0.412751 1.415257 0.544650 1.539165 0.414455 1.242586 0.195280 0.522916 0.859907 1.238816 -0.090313 -0.027707 -0.025034 0.375248 1.748950 1.440534 1.222909 0.018270 -0.118073 0.275708 1.112569 0.089742 1.167857 1.617530 0.755934 0.450427)

      ;; pp:
      10.417134 (fv 0.000000 0.334233 1.073081 1.649039 0.219597 0.888802 1.379829 0.088335 0.555458 1.328032 1.801862 0.615319 1.429043 0.326004 0.993452 1.804613 0.545160 1.317910 1.885616 0.678140 1.509274 0.323491 1.236504 0.282786 1.199970 0.195704 1.232493 0.160017 0.897560 -0.082586 1.086392 0.182366 1.277299 0.339072 1.485948 0.630905 1.802953 0.832621 -0.132126 1.110982 0.486291 1.681037 0.774846 -0.032051 1.638442 0.870514 -0.093334 1.333411 0.747525 0.167590 1.347374 0.845491 0.233833 1.720211 1.112373 0.655737 0.273424 1.815808 1.225426 0.609827 0.164644 -0.241753 1.556306 1.087036 0.843899 0.560878 -0.058558 1.838311 1.465620 1.239758 1.091378 0.528065 0.791149 0.332440 0.584210 0.055836 0.449981 1.753070 0.093654 1.657239 1.503059 1.399887 1.433488 1.544146 1.513188 1.637379 1.822882 1.796041 1.687813 1.720729 1.754274 -0.098151 -0.072877 0.197474 0.504171 0.827563 1.033490 1.323144 1.356797 1.748728 -0.150347 0.352269 0.632744 0.932570 1.684081 0.187586 0.495859 1.035344 1.327590 1.648341 0.358056)
      )

;;; 112 odd -------------------------------------------------------------------------------- ; 10.5830
(vector 112 13.92684841156 (fv 0 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1)

      ;; 10.58293147
	10.582025 (fv 0.000000 0.311823 0.137469 0.765085 0.247252 0.880370 1.452735 0.240993 1.506478 0.780197 1.183194 1.086565 0.032933 1.780577 0.281098 0.764676 0.712557 1.579682 1.277796 1.238223 1.014207 -0.140323 1.716730 1.644672 1.253593 0.578221 0.527661 0.367318 1.131386 1.012757 0.285059 0.010509 0.097401 1.699590 0.802620 1.600737 0.550167 1.026747 0.562219 0.378187 0.150437 0.522055 0.022316 1.717789 0.186746 1.186644 0.914782 0.563095 1.653911 0.869696 0.117700 1.053735 0.935756 -0.055221 0.653101 1.059195 -0.397205 1.469022 0.238158 0.393902 0.410251 0.955768 1.001018 1.337003 0.602349 0.798689 0.307413 -0.479763 0.463243 1.296128 0.608105 0.417995 0.073111 0.291455 0.483686 0.231728 0.630836 1.131231 -0.228753 0.669521 1.185569 -0.089761 1.130815 0.778132 1.502582 1.555252 1.149912 0.577946 0.284522 1.467470 0.172271 0.275044 1.633737 1.228854 0.152388 0.342365 1.574177 0.099351 0.042391 1.025180 1.146998 1.437785 0.647927 1.566576 1.091754 1.532311 1.602420 0.887895 1.387294 0.660060 1.356768 -0.056782)
      )

;;; 113 odd -------------------------------------------------------------------------------- ; 10.6301
(vector 113 13.825498858186 (fv 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0)

      10.586426 (fv 0.000000 0.880973 0.176609 1.175777 0.325354 1.332354 0.320489 -0.071032 0.810398 1.764286 1.047524 1.891121 1.274870 -0.462450 -0.016593 1.802245 -0.046896 0.623724 0.697636 1.104725 0.928560 1.531658 1.767776 1.410783 1.560300 0.841358 1.754992 0.695860 1.109332 0.811865 0.787805 0.897767 0.126996 1.290009 1.439543 1.231735 0.428818 0.217484 1.274411 0.676699 0.491905 0.907831 0.251383 0.502017 0.436195 1.271188 0.390987 0.252204 1.423164 1.333446 1.284283 0.685749 0.387192 1.752967 0.379905 1.873082 0.147356 1.600693 0.620101 0.533661 0.873916 1.687058 0.856213 0.905702 0.279125 1.651302 0.425155 1.158445 0.384556 1.685623 1.738609 0.620191 0.166765 0.760816 0.887704 1.876641 1.612703 0.207434 0.310898 1.383166 0.834523 0.489910 -0.069256 0.030910 0.047326 1.374933 1.678060 0.495762 1.058376 0.337747 0.859288 0.994496 0.384200 0.735993 0.843904 0.381801 0.488130 0.839325 0.731059 1.159772 1.973051 0.569688 1.423018 1.561321 1.485614 0.834971 1.215611 1.015531 -0.080496 -0.203441 0.704520 0.652007 1.385821)
      )

;;; 114 odd -------------------------------------------------------------------------------- ; 10.6771
(vector 114 13.920305720092 (fv 0 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 0 0)

      10.620769 (fv 0.000000 -0.265733 0.572658 0.316585 0.923883 1.614948 0.728669 0.692865 0.985653 1.596503 0.291068 0.153708 1.761462 0.140269 1.183433 -0.379854 1.503387 1.143776 0.747711 1.619251 0.404594 1.157009 0.378840 0.537946 0.751007 0.739900 0.914353 1.624008 0.450778 0.962869 0.588872 1.869278 0.721483 1.557011 0.902276 0.776013 1.285044 0.345048 1.685952 1.091106 0.263288 1.107778 -0.009439 0.420734 1.806464 1.410193 1.769595 1.251788 0.691963 1.604897 1.666646 1.531003 0.963757 -0.680527 1.705352 1.126307 -0.203837 0.277321 0.178995 1.809866 0.763029 0.031476 0.539819 0.755127 0.685061 1.837935 0.717076 1.848829 1.364997 0.950055 -0.061791 1.853324 0.123916 -0.136693 1.146568 0.362176 0.781284 1.598429 1.120688 1.139170 0.560329 -0.015310 0.331374 1.472918 0.199430 0.303861 1.321918 1.569172 1.548780 -0.090459 1.912266 0.810039 -0.152547 1.372081 1.425080 0.264711 1.614349 0.175290 0.789472 1.260114 1.370945 1.918464 1.489942 1.397616 0.963993 0.516634 0.516943 1.244942 0.283787 1.709141 1.616073 0.810759 1.316742 1.696489)
      )

;;; 115 odd -------------------------------------------------------------------------------- ; 10.7238
(vector 115 14.20306968689 (fv 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1)

      10.674304 (fv 0.000000 0.789887 -0.303859 -0.033056 0.759195 0.636525 0.248364 0.847489 1.259597 0.571635 0.950311 0.503307 0.311625 1.283873 0.845368 0.051963 1.567172 1.288876 0.243542 0.283164 1.566596 0.754789 1.490536 0.039434 0.168217 0.197813 0.961175 1.000724 0.173724 1.453836 -0.299975 0.087165 1.672267 1.098120 1.146505 0.379755 1.328375 0.651767 1.173825 0.650295 0.441141 0.865349 1.257754 -0.111945 0.068441 1.538745 0.068967 1.734610 1.208209 0.079563 -0.236732 0.216584 0.140036 0.340430 0.008574 0.036605 0.315028 0.890542 0.307266 0.065201 -0.267238 -0.016662 1.283003 0.528002 -0.402562 1.186323 0.829551 0.025932 0.882753 0.264357 1.091661 1.076730 -0.001406 0.040934 0.042083 1.567774 0.906679 0.687134 0.720339 0.063372 0.406664 1.457338 1.400253 1.359707 1.217492 0.090043 -0.918052 0.816288 1.443080 -0.046946 0.555663 0.622694 1.800570 0.513267 0.655836 0.746318 1.849833 1.129389 1.637640 0.403829 -0.005965 0.883415 0.100025 0.540813 0.541888 0.996530 1.501665 1.855318 1.257420 0.578586 0.925447 0.264080 0.596871 0.828008 0.353618)
      )

;;; 116 odd -------------------------------------------------------------------------------- ; 10.7703
(vector 116 13.887789451571 (fv 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0)

      10.733274 (fv 0.000000 0.476000 1.878001 1.180059 0.831300 1.453614 0.786219 1.052031 1.218138 0.179523 0.743868 1.265853 0.031570 1.636184 -0.152324 0.778296 0.271634 1.469546 0.565495 1.807809 0.217280 0.159382 1.049221 0.170285 0.221763 0.774648 0.398259 0.637279 -0.107284 0.312805 1.776901 0.160502 1.717634 1.119938 1.391025 0.105351 1.023277 1.530674 1.548380 -0.251006 0.488559 1.544222 0.177807 0.661206 0.257716 1.053732 0.893027 1.445098 1.722088 0.002770 1.151812 1.061439 0.110999 0.865286 0.781438 1.277991 0.502793 0.943734 0.798521 1.333645 1.654972 1.679619 0.259243 0.886975 0.069664 1.517348 1.237826 1.551946 0.514540 1.258563 1.258071 1.027685 1.355844 1.909459 1.281504 1.171068 0.250655 1.622642 0.211675 1.522349 -0.092396 0.705855 1.861520 0.183629 0.746566 0.759808 0.250024 -0.159043 1.664858 0.237853 -0.217693 1.217376 1.459590 1.517349 1.206266 0.478670 -0.380779 0.210779 0.338305 1.433407 1.043804 0.854323 0.392836 1.702198 1.439694 -0.141576 1.283279 0.715495 0.734335 1.585749 1.775978 1.654290 -0.315773 0.174327 1.442380 0.993240)
      )

;;; 117 odd -------------------------------------------------------------------------------- ; 10.8167
(vector 117 14.427604264985 (fv 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 1 1)

      10.783290 (fv 0.000000 0.108967 0.680440 -0.039849 1.073915 0.982905 0.909467 1.470260 1.730853 0.840580 1.309090 0.612716 1.548112 -0.231227 1.489945 0.841297 1.245447 0.244987 0.849971 -0.022279 0.452974 0.810744 1.489407 1.567278 1.188237 0.772892 0.113419 0.906478 1.169175 -0.156676 0.507744 1.684543 1.686412 1.219650 1.843836 0.541605 0.346082 0.043904 -0.079283 1.469849 1.567795 0.179241 -0.068928 0.912255 0.602511 1.574715 0.695060 1.133392 -0.425958 0.610886 1.496396 0.865636 0.895412 1.362633 1.653811 1.404165 0.041681 1.692317 1.094403 0.739550 1.239428 0.479228 1.439160 0.986149 0.801910 1.514113 0.963332 0.281851 0.106127 1.599308 -0.004925 1.893302 1.411671 1.244923 0.383170 0.517813 0.421067 1.058052 0.153400 0.778671 0.754438 1.880309 0.023746 1.476647 0.081600 1.798573 0.432245 0.735923 0.440628 -0.064421 1.249491 0.136405 1.735439 1.868665 1.565831 0.435031 0.537457 0.904590 1.634892 1.124196 0.408216 0.769901 0.281419 1.398400 0.260352 0.021213 0.275268 0.681889 -0.074136 0.502025 0.237163 1.241676 1.638668 0.242962 0.026823 1.133262 1.452416)
      )

;;; 118 odd -------------------------------------------------------------------------------- ; 10.8628
(vector 118 14.399567650824 (fv 0 1 0 0 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 0 1)

      10.812235 (fv 0.000000 1.507972 1.809575 1.323971 0.671235 0.977919 0.397118 0.294709 0.400614 1.800046 0.492728 1.565979 -0.363038 1.100463 1.075231 0.502016 0.457037 0.406728 0.228418 0.756367 1.513939 0.347068 1.450936 0.868009 1.501709 0.352220 -0.413052 -0.148923 0.240400 1.115439 0.653043 -0.505473 -0.021974 1.853042 0.586305 0.428092 0.050201 0.752546 1.451411 1.228490 1.754283 1.881544 0.485306 1.754300 0.007006 0.163634 0.582385 0.998129 -0.090614 0.952205 1.425714 1.513296 1.570494 -0.259048 0.529336 1.498547 1.326491 -0.594238 1.538496 0.728657 0.444244 1.055319 1.385207 0.874327 0.074427 1.100816 1.734905 0.605814 1.533043 1.017063 0.482871 0.438583 1.108829 1.808956 0.029357 0.297016 -0.063569 0.780909 1.283400 0.359665 -0.032425 1.363808 0.687851 1.190450 1.438414 1.141910 1.126025 1.239471 0.136191 1.489911 1.026641 0.526687 0.890040 -0.022700 0.140687 -0.353757 1.164330 1.005641 0.099661 1.220163 1.081145 1.773078 1.376716 1.458019 0.703593 0.987305 1.493840 1.628605 0.957392 -0.054994 1.652856 0.431213 1.736293 -0.162073 0.279632 -0.110283 1.166212 1.877544)
      )

;;; 119 odd -------------------------------------------------------------------------------- ; 10.9087
(vector 119 14.464 (fv 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 1)

	10.915923 (fv 0.000000 1.468971 -0.070109 0.743471 0.865207 0.740713 1.375563 1.856253 1.493876 0.001446 1.555119 1.873527 0.486379 1.616655 0.160602 1.367247 0.912321 0.764636 0.328487 -0.313335 0.385982 0.645370 0.408989 -0.210208 1.638205 0.329206 1.585495 1.658528 -0.015737 0.563000 0.062305 -0.007952 1.615694 0.120849 0.556636 1.351804 1.028805 0.044823 -0.249641 0.450875 -0.188130 1.054822 1.658005 0.732611 1.051144 0.181032 -0.061461 0.014104 0.174656 1.497989 1.287601 1.362445 0.209461 0.902894 1.389971 0.577406 1.285084 1.677882 0.836076 1.093131 -0.061912 0.754157 0.925122 0.984483 0.745399 1.783690 0.907228 0.093044 0.001514 0.775385 1.257954 1.480444 1.312457 1.195686 1.427916 1.726017 1.291212 1.845006 1.072451 0.380596 -0.077482 -0.030557 0.660125 1.346002 0.823989 0.235481 1.377946 1.450150 0.552324 0.398627 1.336527 0.073526 0.466630 0.590308 0.928946 0.828743 -0.154986 1.149963 0.492935 1.772069 0.204388 1.490853 -0.315475 0.097407 1.157089 0.698006 1.513716 1.488764 0.923673 0.108745 1.168110 0.729608 1.392132 1.740139 1.454066 0.757828 1.227068 0.584339 1.581610)

      ;; pp:
	11.037707 (fv 0.000000 0.330663 0.977506 1.486310 0.146671 0.619852 1.212563 1.835260 0.429131 1.137767 1.722966 0.554725 1.336956 0.080712 0.852554 1.473118 0.165981 0.811544 1.502696 0.343077 1.371306 0.205531 0.905257 1.934366 1.020467 1.933150 0.730878 1.550089 0.565733 1.543669 0.452622 1.507940 0.734165 1.641237 0.799367 0.020448 1.044223 0.039537 1.305538 0.570880 1.458969 0.622353 1.797356 0.986890 0.251789 1.442933 0.753665 0.270337 1.533653 0.647011 -0.011278 1.435253 0.493723 -0.176024 1.395851 0.880365 0.222324 1.709439 1.376910 0.824516 0.330942 1.733291 1.350769 0.852276 0.247847 -0.101792 1.361637 1.450559 0.694333 0.792939 0.273393 1.916534 1.612649 1.136729 1.027650 0.745376 0.479123 0.468161 -0.088607 0.141257 1.721063 1.745485 1.474071 1.547129 1.195469 1.231545 0.976850 0.989136 1.181833 0.899203 1.200899 1.168317 1.143250 1.360858 1.307442 1.171633 1.402153 1.656644 1.531180 1.874515 0.028657 0.416186 0.465448 0.590264 1.056005 1.152867 1.387578 1.553815 0.076236 0.350372 0.561320 1.007917 1.385094 1.972832 0.449173 0.459147 1.193699 1.594244 0.056947)

	;; 118+1
	10.815476 (fv 0.000000 1.511627 1.860509 1.251771 0.680390 0.954029 0.497464 0.422082 0.549359 1.789096 0.627036 1.559684 -0.285316 1.102920 1.110972 0.497639 0.358913 0.339963 0.170351 0.820368 1.613321 0.311453 1.667587 0.845824 1.477518 0.323382 -0.462336 -0.121701 0.278431 1.251253 0.730313 -0.512813 0.050332 1.905719 0.581701 0.491221 0.037053 0.850077 1.454447 1.218666 1.827857 1.931466 0.444700 1.716033 0.031317 0.208955 0.719947 1.025308 -0.162952 0.941579 1.416409 1.490055 1.661028 -0.177347 0.601149 1.427738 1.318738 -0.598055 1.513344 0.818145 0.331744 0.938565 1.416971 0.755203 0.134509 1.154206 1.729909 0.622158 1.596632 1.050190 0.348364 0.402844 1.083937 1.814009 0.098380 0.333506 -0.078532 0.814360 1.186888 0.456002 0.118529 1.475204 0.706833 1.153688 1.398936 1.202344 1.140027 1.452557 0.124581 1.538313 1.096684 0.449897 0.816791 -0.073645 0.157032 -0.377184 1.176926 0.948380 0.061745 1.231800 0.991632 1.829471 1.268286 1.394920 0.669763 0.966107 1.360959 1.524586 1.033990 0.094975 1.707832 0.468762 1.695289 -0.249729 0.213611 -0.109788 1.260368 1.791243 -0.325923)
      )

;;; 120 odd -------------------------------------------------------------------------------- ; 10.9545
(vector 120 14.530112637252 (fv 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0)

      10.908578 (fv 0.000000 1.631022 1.381443 1.212465 0.280876 1.393291 0.111686 0.270527 0.978937 1.227425 0.890939 1.651369 1.764648 0.695615 1.236913 0.727116 0.698874 1.130809 0.997193 1.306023 0.313921 0.604505 1.499034 1.434773 -0.031959 0.721966 0.805711 1.401787 1.847562 -0.006201 0.484669 -0.092885 0.221199 -0.183123 0.140129 0.993753 0.357992 0.281932 0.966898 0.230227 1.509169 0.180321 0.405315 1.445457 0.491155 0.993111 -0.061813 1.514617 0.638001 0.451798 1.136956 1.109239 0.762301 -0.132886 1.231861 1.405253 0.200172 0.005626 1.367415 0.727395 0.860721 1.277905 0.564602 1.311600 0.590071 0.237783 1.173320 1.731939 0.366179 -0.147635 0.520386 1.741652 0.218116 1.635795 0.602629 0.928717 0.628620 0.437182 1.782199 0.939080 1.479011 0.992710 1.705346 0.225711 0.000961 0.770434 1.683323 1.555459 0.976408 0.318440 0.438208 0.262452 1.689840 0.975712 0.209291 0.727490 0.382719 1.065032 0.672130 0.702874 0.107185 1.755713 1.841965 0.283698 0.562788 -0.058140 0.525625 0.471391 -0.086606 1.741760 0.455380 1.248256 1.359448 0.404279 1.132787 1.054875 0.443335 0.808907 0.713857 0.102341)
      )

;;; 121 odd -------------------------------------------------------------------------------- ; 11
(vector 121 14.355115628334 (fv 0 0 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0)

	10.999150 (fv 0.000000 0.719860 0.938641 0.400955 1.830792 0.217487 1.930089 0.909842 0.382707 1.104036 1.362552 1.609877 0.538869 1.202159 1.228082 0.918074 0.761902 0.900279 1.079854 0.387994 0.099489 0.100875 1.443224 0.976872 1.189188 0.334621 0.186401 1.007773 1.759908 1.802561 0.304789 0.800487 0.421388 1.531470 0.342409 1.763739 0.609609 0.238091 0.387711 0.077698 1.394770 1.550045 1.073770 -0.012632 0.461456 0.365441 0.558370 -0.144510 0.377065 -0.136065 0.495723 0.024372 0.599268 0.707454 1.784582 0.849322 0.801737 -0.000698 0.370684 -0.319990 0.047344 1.411089 -0.180064 1.795978 1.184028 0.211991 0.750419 1.558447 0.936061 0.770891 0.210380 0.477885 0.773230 1.314821 1.776398 0.360518 0.353595 1.763194 0.626584 0.453820 1.817369 0.757593 0.448588 0.747723 1.349523 0.084314 0.839331 0.432101 1.175829 -0.480593 1.521898 1.472118 0.461937 -0.352155 0.231781 1.128258 1.179502 -0.264358 1.594681 1.130852 1.819287 1.407276 0.357399 0.261689 0.296975 1.241018 0.528908 0.936623 1.018062 1.507272 1.409703 0.904346 -0.089508 0.657699 0.797276 1.771059 0.906319 0.794023 0.195827 -0.015182 1.382236)

      ;; pp:
	10.964853 (fv 0.000000 0.398403 0.789366 1.639224 0.095384 0.603386 1.413253 -0.024715 0.418890 1.292082 1.611148 0.340631 1.108765 1.695063 0.580930 1.343797 0.280670 0.901558 1.616611 0.471137 1.087682 0.133909 0.906863 1.859279 0.568482 1.631317 0.654611 1.507476 0.361682 1.510922 0.499281 1.470975 0.300411 1.347262 0.617157 1.704177 0.828780 1.880799 1.043180 0.289911 1.416774 0.542005 1.546439 0.900363 0.167177 1.249035 0.407571 1.759267 1.085148 0.584948 1.716513 0.882082 0.508912 1.827501 0.986992 0.387974 1.888925 1.337010 0.836823 0.307293 1.641585 1.441301 0.767423 0.352201 1.694822 1.489433 0.858014 0.699679 0.213088 1.881335 1.746103 0.996170 1.013175 0.481879 0.378821 0.145113 1.583267 1.647206 1.099338 0.993610 1.018212 0.718965 0.851336 0.334482 0.624100 0.047757 0.264635 -0.323610 -0.302771 0.007865 1.748671 1.715799 0.102814 0.097582 0.089500 0.089824 -0.047495 0.097783 0.230671 0.371131 0.395035 0.485871 1.031900 1.248794 1.442726 1.594017 1.850116 0.167236 0.339312 0.429488 0.766566 1.120859 1.686086 0.133797 0.674257 1.033037 1.205258 1.718874 0.166520 0.534447 1.081831)
      )

;;; 122 odd -------------------------------------------------------------------------------- ; 11.0454
(vector 122 14.266534958875 (fv 0 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 0 1)

	11.010771 (fv 0.000000 1.285362 1.109765 1.769522 1.118511 0.025809 1.380894 -0.023810 -0.040154 0.477589 1.538986 0.261754 1.175104 0.132069 1.284014 1.937597 1.377797 1.405930 1.758393 1.282889 1.486625 -0.056321 1.528467 0.214498 1.235960 0.342086 0.501436 1.266150 1.154766 0.072612 1.295064 1.657622 1.389498 0.272462 0.259989 -0.421623 0.539671 -0.109400 1.457518 0.782406 0.238503 1.568707 0.742855 0.582523 1.544996 0.568221 1.469856 -0.013151 1.702120 1.738232 0.495569 1.623452 0.280213 1.398587 0.655444 -0.357815 -0.175614 -0.641353 0.853648 0.913786 0.039735 0.805399 0.987536 1.353101 0.200447 1.531233 0.925738 1.853509 -0.339223 0.575217 0.991404 0.868567 0.980697 0.661437 0.825668 0.642114 1.923343 0.222086 1.058889 0.329972 0.424129 1.343097 -0.325621 0.616372 0.777895 1.290746 0.563995 1.114886 -0.032692 0.303925 0.022515 1.568213 1.005956 0.993523 0.945016 1.316628 1.600265 0.004312 0.404044 0.508968 1.509703 1.266589 -0.292614 0.449335 0.327309 -0.027947 0.095691 -0.305771 -0.038174 1.851423 0.567671 0.373102 0.032065 1.664572 1.263320 0.558380 0.899406 0.824927 1.437277 1.639347 0.806318 0.739271)
      )

;;; 123 odd -------------------------------------------------------------------------------- ; 11.0905
(vector 123 14.795100232697 (fv 0 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0)

	11.117974 (fv 0.000000 1.262698 1.743243 1.074484 0.862475 0.785191 0.510312 0.582728 0.572628 -0.088059 1.664778 1.092330 -0.084164 1.734977 0.143912 0.402913 0.514775 1.115307 1.630947 0.922571 1.361065 0.426472 0.818315 0.052105 0.105138 1.201879 0.422607 1.251988 1.202423 -0.257950 0.069201 -0.064548 0.721964 0.891435 1.163338 0.489652 0.800922 1.113478 0.729679 1.592733 0.127179 0.300890 1.709393 0.172666 1.452078 -0.215073 0.642218 0.228379 0.403691 1.149702 0.347815 1.145024 0.203450 1.473310 1.349864 0.832166 1.109084 1.584188 0.087952 0.610084 0.356770 0.605944 1.021694 0.463739 1.799512 1.527466 0.330450 0.923701 1.275830 1.440075 0.070553 0.931440 1.867718 1.401219 0.527205 0.524478 1.943022 1.358574 1.765573 0.269987 0.599212 0.397347 0.099304 -0.004043 0.750837 0.311340 0.977644 0.259270 0.829971 0.677623 1.491913 0.411691 1.356052 1.394632 0.542733 1.451416 1.005068 0.285973 0.960285 1.132877 -0.136129 0.201370 1.788028 -0.448022 -0.229434 1.007668 -0.665334 0.552776 -0.103552 1.183857 -0.521659 1.255730 0.912247 1.532970 1.479294 1.441480 1.200164 0.598200 1.369457 1.661067 0.851812 0.484837 1.318223)

      ;; pp:
	11.220425 (fv 0.000000 0.365848 1.054393 1.548722 0.083290 0.846622 1.243796 1.975082 0.530118 1.107798 1.698368 0.394906 1.261238 1.932773 0.709817 1.516065 0.289612 0.915816 1.713378 0.516514 1.369027 0.084750 0.935528 1.825369 0.700695 1.570817 0.581567 1.522187 0.450938 1.444224 0.424228 1.427039 0.366241 1.246498 0.294330 1.489859 0.444710 1.600045 0.769131 1.818819 0.882796 0.180405 1.318163 0.438713 1.518577 0.911091 0.311354 1.423178 0.560415 -0.093959 1.444287 0.598087 1.777270 1.408474 0.711081 0.112383 1.490437 0.904666 0.286560 1.771712 1.145544 0.724678 0.267468 1.796311 1.311228 0.841811 0.365537 1.880834 1.503328 1.287234 0.819314 0.526370 -0.077772 1.787440 1.491417 1.044589 1.141961 0.479419 0.379101 0.330996 -0.143470 1.807816 1.736856 1.461325 1.278241 1.506158 1.106149 1.221780 0.919096 1.122923 0.682195 0.948573 0.684101 0.822257 0.900682 0.969747 0.998896 1.031330 0.981000 1.116626 1.207464 1.514496 1.484110 1.685927 -0.131788 0.102608 0.256377 0.543811 0.846258 1.358549 1.270751 1.590115 -0.239901 0.243476 0.677754 0.899634 1.476294 1.901976 0.254194 0.661350 1.294177 1.496684 0.048409)

	;; 122 + 1
	11.250448 (fv 0.000000 1.302757 1.104016 1.882979 1.077650 0.053765 1.380440 0.003809 -0.046007 0.495357 1.519889 0.149797 1.197260 0.142817 1.219075 1.962202 1.461975 1.397810 1.755477 1.312034 1.459888 0.010987 1.489492 0.259453 1.259472 0.317472 0.521518 1.299213 1.226523 0.026938 1.296841 1.668722 1.337105 0.314301 0.330300 -0.438601 0.526089 -0.123698 1.469579 0.756219 0.172470 1.621261 0.778923 0.588722 1.542018 0.631414 1.527628 -0.038678 1.791364 1.687889 0.422304 1.584058 0.300597 1.413330 0.639674 -0.328087 -0.133739 -0.644241 0.881718 0.903075 -0.003259 0.764074 1.053115 1.364090 0.158374 1.544589 0.996921 1.813142 -0.279028 0.566236 1.039397 0.862143 0.979166 0.609771 0.860576 0.627137 1.959235 0.243884 1.018838 0.390319 0.475059 1.332423 -0.275526 0.611933 0.766476 1.331409 0.615945 1.094395 -0.004564 0.363420 -0.045135 1.527572 1.077299 0.997558 1.035936 1.286389 1.540261 0.059435 0.352601 0.552519 1.479640 1.199179 -0.317815 0.440438 0.336153 -0.013127 0.157566 -0.304297 -0.069647 1.901289 0.528335 0.359084 -0.007292 1.702466 1.215578 0.562997 0.913601 0.801948 1.409876 1.632172 0.750795 0.670695 -0.003034)

	;; 124 - 1
	11.087851 (fv 0.000000 0.624121 0.261315 1.181018 0.329816 0.723473 -0.058557 1.121126 0.418750 -0.560184 0.201221 -0.009188 0.964547 0.675383 0.540517 1.692402 0.238659 0.271713 0.649234 1.358679 -0.523949 0.096515 1.070752 0.415974 1.194076 0.398537 0.119705 1.390687 1.865110 0.657711 0.628353 0.094042 -0.039698 0.818092 0.264925 1.627819 0.564214 1.707948 1.323380 0.532853 1.528599 0.040464 0.169356 1.020624 1.633435 0.566927 0.135046 0.139973 1.154314 0.011466 -0.490861 0.640253 0.477507 1.036610 0.601286 0.864853 1.673244 0.103614 0.490773 0.239735 1.004984 0.751604 0.598287 0.049449 -0.383209 0.952738 0.587827 1.358167 1.134886 0.996730 1.062079 1.715631 0.870675 -0.669782 1.719322 1.286177 0.181430 1.375280 1.727572 0.723568 0.180864 0.793875 1.229108 1.479462 0.352987 0.476172 0.647844 0.506675 0.826807 0.037970 0.147029 -0.376170 -0.079080 -0.448861 -0.361893 0.784673 0.253239 1.081508 0.018537 1.194702 1.598635 -0.278698 1.403864 0.071060 0.431595 1.221066 1.608714 0.689332 0.715718 0.497216 1.832187 1.548074 1.325487 -0.697479 1.412701 -0.064789 1.545460 1.865863 0.574246 1.018052 0.826593 0.850894 0.538141)
      )

;;; 124 odd -------------------------------------------------------------------------------- ; 11.1355
(vector 124 14.82254124518 (fv 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 0 0 0 0)

	11.133385 (fv 0.000000 0.737767 0.242894 1.222279 0.471270 0.719745 -0.111581 1.125372 0.519029 -0.602995 0.207831 -0.019375 0.977253 0.730038 0.549277 1.736357 0.178856 0.378067 0.703036 1.285405 -0.440424 0.022976 1.081105 0.394590 1.176445 0.423028 0.024758 1.348044 1.875622 0.693243 0.631295 0.154785 -0.072026 0.840426 0.310333 1.680668 0.596016 1.796624 1.329261 0.552169 1.550621 -0.029191 0.120286 1.042346 1.643782 0.557105 0.100245 0.192082 1.115887 -0.044021 -0.568040 0.660295 0.446779 0.996296 0.543383 0.887166 1.696504 0.164237 0.565638 0.240616 0.980219 0.676086 0.528834 0.128308 -0.348116 0.973101 0.673237 1.259063 1.135685 0.928208 1.088345 1.731248 0.837036 -0.669991 1.701824 1.338691 0.198045 1.382482 1.748178 0.598583 0.174133 0.840707 1.239171 1.490991 0.324491 0.560298 0.680939 0.488255 0.866976 0.067351 0.114746 -0.374109 -0.011129 -0.482864 -0.335823 0.770685 0.238886 1.104919 -0.086380 1.175827 1.697828 -0.309033 1.420456 0.050528 0.410791 1.224188 1.576124 0.696620 0.749167 0.492507 1.752832 1.565235 1.317346 -0.708509 1.533585 -0.144615 1.567818 1.921771 0.617703 1.048643 0.900156 0.810098 0.470909 -0.287077)

      ;; pp:
      11.348159 (fv 0.000000 0.420291 0.994113 1.605062 0.142556 0.741991 1.232518 1.818784 0.570117 1.112532 1.715041 0.498288 1.242193 1.903819 0.738569 1.440312 0.052035 0.859274 1.700608 0.416370 1.222707 0.007385 0.792200 1.771446 0.548685 1.661284 0.559436 1.442669 0.358986 1.258045 0.260744 1.254293 0.320180 1.305252 0.361287 1.403913 0.572629 1.603076 0.693636 1.846854 1.012682 0.188863 1.352443 0.397048 1.645973 0.881785 0.066704 1.295103 0.504646 1.870898 1.303297 0.570018 1.829957 1.080888 0.545590 1.923840 1.269013 0.679145 0.161303 1.594647 0.985227 0.464326 0.012233 1.568478 1.180634 0.730528 0.110665 1.618518 1.175834 0.879996 0.432189 0.136812 1.777876 1.490107 1.188949 0.907621 0.550479 0.242984 -0.059790 1.929821 1.371631 1.423168 1.146477 0.972409 0.858534 0.924887 0.595740 0.679411 0.488048 0.636418 0.072322 0.281040 0.204879 0.089915 0.287853 0.416670 0.453983 0.352329 0.503511 0.432486 0.571020 0.790600 0.687796 1.008010 1.155356 1.385540 1.648000 1.747132 0.045146 0.425981 0.717415 0.741128 1.002981 1.282324 1.660931 0.156386 0.411627 0.950904 1.417985 1.747974 0.260323 0.677519 1.016797 1.669557)

      ;; 125-1
      11.120334 (fv 0.000000 0.836933 0.196277 0.584882 0.301240 1.853484 1.324094 0.689541 0.969365 0.207127 0.815576 1.493174 1.646002 1.091372 1.338767 0.007260 0.223249 1.375996 0.396818 0.809290 0.595471 0.291935 0.828280 1.079040 -0.045835 0.055676 0.687157 1.387372 0.387604 1.113048 0.635795 -0.184152 0.086995 0.683755 -0.523880 0.957683 0.004250 0.887892 -0.247566 0.473338 0.863028 1.537875 1.279363 1.883742 -0.079415 1.606587 1.410357 1.815201 1.258365 -0.140836 0.062288 -0.117723 0.136197 0.025366 0.240444 0.337975 0.245314 1.565210 1.190385 0.061707 1.059358 1.066927 -0.243845 -0.140470 0.080704 -0.220916 0.436644 1.755266 1.123977 1.300903 1.292668 0.127266 0.478120 0.197515 0.674823 1.740766 0.286316 1.346417 -0.000673 0.759878 1.360448 0.328373 -0.116210 1.391350 1.022226 1.179474 0.838754 0.041237 0.614743 0.475843 0.203018 1.724933 1.421322 0.133569 1.485945 -0.070709 -0.071535 1.023240 0.511154 0.013014 1.379753 0.972914 1.226974 1.882336 0.135006 1.035934 -0.225880 1.034246 0.410768 0.390305 1.143196 1.223233 0.144114 1.611032 0.509896 1.218446 0.494123 -0.071045 0.511805 0.489583 0.116710 1.542243 0.745207 0.200411)
      )

;;; 125 odd -------------------------------------------------------------------------------- ; 11.1803
(vector 125 14.82163143158 (fv 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 1 0 0 1 1 1 0 0)

      11.122080 (fv 0.000000 0.847003 0.165605 0.564848 0.227076 1.866949 1.345525 0.694388 0.959809 0.220564 0.772501 1.602410 1.604719 1.034958 1.311625 0.093909 0.283228 1.337145 0.377730 0.845137 0.466461 0.350583 0.723543 1.140286 -0.106738 0.112805 0.654453 1.405583 0.488341 1.115481 0.791692 -0.180702 0.024701 0.675117 -0.401907 0.966930 1.823188 0.970009 -0.163692 0.487827 0.774136 1.664048 1.147399 1.934923 -0.055579 1.590906 1.404741 1.937024 1.297324 -0.074406 0.012276 -0.101828 0.157087 0.049344 0.227099 0.402796 0.390545 1.452083 1.063131 0.134397 1.038993 1.058234 -0.172834 -0.157850 -0.051398 -0.166122 0.368524 1.765197 1.164117 1.233067 1.255917 0.100656 0.389203 0.162934 0.701475 1.871318 0.234658 1.379710 -0.022077 0.663615 1.352469 0.392445 -0.083922 1.307168 0.973714 1.219169 0.823481 0.152576 0.585169 0.393119 0.296805 1.754607 1.427512 0.110549 1.353534 -0.062637 0.005406 0.988733 0.551978 -0.032302 1.396422 1.051496 1.232496 1.873765 0.104448 1.090614 -0.186610 1.107217 0.405013 0.371843 1.166939 1.223105 0.199359 1.547104 0.541567 1.118832 0.462118 -0.111041 0.497800 0.551619 0.175381 1.513543 0.771791 0.282381 0.491699)
      )

;;; 126 odd -------------------------------------------------------------------------------- ; 11.2250
(vector 126 14.961482935205 (fv 0 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1)

	11.217157 (fv 0.000000 1.333463 1.865492 -0.356718 0.933752 -0.563391 0.868454 1.227379 1.262853 1.734302 0.789925 0.887286 1.032388 0.794621 1.230657 -0.133505 -0.396357 0.347068 1.645124 0.776662 -0.030992 0.148253 0.191160 1.597265 0.105283 0.900423 1.230893 1.571345 0.370052 -0.251197 0.174670 0.404122 -0.082381 0.889967 -0.215160 -0.008260 -0.099660 1.159763 0.889422 1.423884 0.871705 1.850409 0.087109 1.706676 0.622672 0.936165 1.688780 1.528677 0.346829 0.012071 -0.088550 -0.030577 -0.043782 -0.058951 0.933603 1.070465 1.475594 1.531127 0.991234 0.010808 0.356054 0.157103 0.451907 -0.030459 -0.024818 0.523063 -0.129422 0.815521 1.075724 0.055269 0.750932 1.244054 1.306512 0.899391 -0.257291 1.664054 0.588171 1.065503 1.219153 1.371075 1.522174 0.737588 1.228742 1.773501 0.629941 0.387629 0.029457 1.398967 0.393091 1.680074 1.275817 0.905734 0.977246 -0.221887 1.339886 1.268897 1.260526 0.645165 1.510347 1.465708 0.394415 0.283387 1.630537 1.623821 0.888008 0.433073 0.790823 0.410278 1.398034 -0.237262 0.505122 -0.149516 0.721213 -0.202493 0.454561 1.014466 0.552452 1.112325 -1.848818 1.758603 1.154778 1.507049 0.724439 0.691362 -0.014103 1.227764)
      )

;;; 127 odd -------------------------------------------------------------------------------- ; 11.2694
(vector 127 14.695912364919 (fv 0 0 1 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0)

	11.267676 (fv 0.000000 0.469645 0.796786 0.361018 -0.201613 1.310280 0.989111 0.525386 1.353693 0.378912 -0.241786 1.383164 1.533963 0.433890 0.325960 -0.352400 0.296358 0.481541 1.224829 0.787501 0.393768 1.211089 1.363561 0.247670 0.870376 1.154368 0.308126 1.041640 0.835212 1.804302 0.606799 0.022246 1.619342 1.154695 0.087857 0.758989 -0.028398 1.810844 1.763099 -0.171773 1.163226 0.592499 1.004685 0.695738 1.351120 0.977805 1.234286 1.609466 1.168845 1.598062 -0.321012 0.375057 0.817093 1.176853 0.878725 0.404937 0.672879 0.953648 1.504900 1.779440 0.534644 1.065489 -0.364994 1.703967 1.257601 -0.285618 0.908588 1.590737 1.087624 0.949190 1.204116 1.100315 0.879186 1.728483 1.796612 1.248626 1.298091 0.553842 1.379947 1.414383 0.591234 -0.228889 0.158060 -0.027394 0.157851 1.486700 0.372769 1.034786 0.707926 1.165159 0.328389 0.640197 0.421469 0.024384 1.129354 0.412245 0.531741 0.551732 0.008170 1.397227 1.653335 0.820170 0.216962 1.538735 0.975199 1.704359 0.157705 -0.426269 0.813101 0.999429 0.880927 1.743457 1.627725 0.094175 0.211869 0.002839 0.900464 1.204980 1.320644 1.281147 0.386967 0.783858 1.096686 0.213553 1.120859 -0.145308 0.996884)
      )

;;; 128 odd -------------------------------------------------------------------------------- ; 11.3137
(vector 128 14.876242756695 (fv 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1)

      11.261196 (fv 0.000000 0.166552 0.658187 0.892812 0.275075 0.681304 0.935134 0.976324 1.751013 1.223679 0.531374 0.670158 0.738172 0.131342 0.784571 -0.001918 0.261947 -0.271711 1.074675 0.180917 0.495904 1.378525 0.720362 0.537440 1.116473 -0.311806 0.462073 0.021129 0.764859 1.361657 1.645691 -0.164691 0.135735 1.576068 0.824450 0.335134 1.099359 0.719625 0.791638 0.999013 0.348593 0.103014 1.062792 0.739933 1.675943 0.488371 0.860700 0.759566 1.276788 -0.135237 0.780818 -0.165115 1.024663 -0.327864 0.608127 1.454969 0.958609 0.555060 1.331156 0.762777 0.625297 1.411237 1.470303 1.190821 0.207444 0.108639 1.023133 1.165243 1.464221 1.564262 0.616076 0.019451 0.729986 0.402652 0.078552 0.454134 0.152695 0.263463 0.361958 1.475980 0.276689 1.365673 0.254488 -0.143709 1.946127 0.309551 1.760348 1.294342 0.981564 0.863637 1.477654 -0.019128 0.751338 0.878849 0.050601 0.063334 1.353561 1.669390 1.451518 0.535767 0.012898 0.428045 -0.011136 0.975409 -0.201088 0.677802 0.866124 0.188482 0.625213 1.342113 1.315837 0.879874 0.445664 1.081775 0.978490 1.662778 0.529736 1.946523 1.542905 0.571344 1.054205 0.430980 0.402697 -0.095096 1.487261 1.198691 1.754313 1.700742)
      )

;;; 256 odd --------------------------------------------------------------------------------
(vector 256 22.546259712247 (fv 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1)
      
	16.932554 (fv 0.000000 0.299828 1.705033 -0.245282 1.517634 -0.512250 1.852696 -0.212031 1.625444 0.510314 1.972741 0.173230 1.725475 1.547901 0.804668 1.394746 0.173496 0.531764 0.731522 -0.060988 0.953386 0.234883 1.327931 1.710749 0.682372 1.593381 0.151697 0.696761 0.537335 1.969147 0.015426 0.808226 1.907797 1.558581 1.628528 1.165756 1.125630 1.795673 0.141122 0.016332 1.288127 0.941042 0.739123 0.972611 0.864761 0.875493 1.065737 0.205053 1.185762 0.863116 -0.053729 1.247127 1.771030 0.213109 0.203770 1.794944 0.080805 1.593027 0.197375 0.662307 -0.007433 1.307614 1.700096 0.641288 -0.016776 0.227057 0.210364 1.170957 1.587764 0.027010 1.239534 0.423010 0.803348 -0.009082 0.446764 0.636465 0.493264 -0.127025 0.112814 0.882192 1.818458 -0.107988 0.396084 1.293132 0.043609 1.657883 0.579794 0.180007 1.771600 1.131077 0.309105 0.137609 1.680511 0.060225 1.648041 -0.009446 0.270642 0.473937 1.608416 -0.014724 1.203911 1.240003 1.624613 1.562696 0.423323 0.330495 1.342929 0.063255 0.191341 0.910443 0.987286 0.949497 1.223867 1.261957 1.880192 0.302246 1.712139 1.779224 1.265963 1.777754 0.696982 1.379173 0.849932 1.580925 0.603387 1.028575 0.637130 0.740605 0.190997 1.448533 1.601710 1.704646 0.662313 0.835536 0.132357 0.868721 1.868738 1.555439 0.857103 1.813342 0.384273 0.308585 0.123611 1.182477 1.477561 1.678828 1.369057 1.213135 0.205042 0.425013 1.472803 1.396888 1.212323 1.858077 1.187399 0.010710 1.114100 1.840176 0.270787 0.093299 1.447701 0.449012 1.201616 1.113975 0.530506 1.655828 1.255713 -0.011414 0.956758 0.101851 1.223128 0.632983 0.423115 0.389217 1.423871 0.446874 1.820967 -0.029749 -0.443778 1.464394 0.868892 0.727400 0.578567 1.659072 1.017705 1.973528 -0.008925 0.757464 0.297947 -0.349297 0.883303 0.128256 1.200088 1.880227 0.584973 0.246525 0.618040 0.702249 1.255753 -0.329844 0.271022 0.297799 1.233191 1.390939 1.235027 0.303733 0.154150 0.491021 1.847433 1.056124 1.120988 1.805844 0.419548 1.016328 0.066448 0.893486 1.505832 0.702704 1.551981 1.267138 0.736198 0.947423 0.706820 -0.380019 0.873753 1.478444 0.561669 0.158253 0.016654 0.113131 1.644053 0.533397 0.826036 1.694860 0.852972 1.098260 0.229336 0.855766 1.051022 1.369585 0.520607 1.599761 1.473656 0.002020 0.572466 1.209260 1.275104 1.740654 1.738870 1.725547 1.490686 0.651000 0.118628 -0.196423 0.917329 0.845710)
      )

;;; 512 odd --------------------------------------------------------------------------------
(vector 512 35.541 (fv 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0)

      ;; from (try-all :odd 512 513 0.0057812032540294  1.0142361702487) = 28.7291 start for next
	23.716849 (fv 0.000000 1.386177 0.713008 0.003452 1.325461 0.665248 0.008142 1.314724 0.691474 0.066339 1.435981 0.804093 0.172765 1.522234 0.893751 0.277258 1.610102 1.005246 0.376177 1.775441 1.206877 0.615802 0.010188 1.376708 0.765127 0.173375 1.635776 1.029586 0.489561 1.940906 1.346730 0.810290 0.190213 1.646200 1.058365 0.502081 -0.085212 1.398947 0.892744 0.400807 1.903960 1.353268 0.833725 0.289010 1.806848 1.257743 0.707460 0.242200 1.750575 1.251783 0.742940 0.232633 1.756296 1.281177 0.783502 0.304115 1.846750 1.350399 0.916463 0.494039 0.029209 1.596080 1.095129 0.687317 0.229205 1.736704 1.290854 0.857342 0.417897 0.006810 1.604785 1.207241 0.745888 0.368498 1.939438 1.557313 1.176888 0.751323 0.345064 1.946256 1.587416 1.205053 0.847721 0.500526 0.105201 1.713914 1.348245 0.999166 0.643810 0.294307 -0.009291 1.648246 1.318017 0.946007 0.571567 0.250113 1.948602 1.641225 1.351970 1.040145 0.722431 0.402249 0.068667 1.761778 1.483321 1.168792 0.902292 0.622562 0.393716 0.071396 1.793757 1.520668 1.253207 0.968382 0.706598 0.478102 0.212208 1.966285 1.706429 1.495684 1.219831 0.986339 0.727326 0.553916 0.347750 0.133150 1.913130 1.701236 1.512062 1.283083 1.044773 0.859493 0.685612 0.480978 0.318075 0.155658 1.970256 1.731367 1.604854 1.456327 1.268574 1.110936 0.962304 0.806527 0.641956 0.496465 0.404452 0.274399 0.124501 -0.069746 1.814128 1.693756 1.567361 1.452982 1.402427 1.267889 1.106117 1.025358 0.944270 0.854118 0.753166 0.662874 0.577504 0.540814 0.454691 0.364705 0.334774 0.260515 0.174172 0.114008 0.059753 0.021108 1.967795 1.940561 1.926108 1.817829 1.816578 1.829230 1.763717 1.746146 1.768340 1.735638 1.694243 1.717300 1.700307 1.673492 1.703276 1.765354 1.728149 1.721871 1.792759 1.836518 1.790659 1.869572 1.931889 1.911416 -0.049508 0.040552 0.076661 0.124548 0.190446 0.213683 0.290047 0.374351 0.444676 0.515097 0.588488 0.695903 0.781037 0.806660 0.921756 1.050977 1.179273 1.276197 1.323471 1.440301 1.570781 1.698955 1.827110 1.973403 0.095016 0.228855 0.385876 0.488292 0.634453 0.804119 0.947283 1.092378 1.233063 1.412122 1.598977 1.789895 1.950360 0.140199 0.270111 0.484542 0.676076 0.875520 1.062416 1.258627 1.458192 1.707297 1.921954 0.119209 0.298949 0.581405 0.769515 1.026853 1.223167 1.513273 1.727029 -0.017306 0.209900 0.500939 0.701672 0.977279 1.216826 1.499384 1.779833 0.099435 0.337187 0.641811 0.927329 1.208595 1.453552 1.744657 0.045196 0.356852 0.724238 1.011858 1.349837 1.617935 1.987915 0.263154 0.637781 0.962300 1.293802 1.623598 1.910194 0.353508 0.625937 1.050232 1.343506 1.742985 0.092929 0.488000 0.864319 1.233651 1.609043 0.033469 0.414020 0.804580 1.109133 1.582193 1.963439 0.408246 0.805244 1.229890 1.616430 -0.005644 0.499002 0.871222 1.383619 1.742006 0.241871 0.636412 1.111292 1.523864 0.013426 0.430112 0.957489 1.390576 1.854792 0.298131 0.775965 1.336493 1.765508 0.284032 0.739560 1.225735 1.770015 0.245509 0.759950 1.283127 1.750994 0.271698 0.822357 1.329050 1.911458 0.424517 0.913054 1.452733 0.010207 0.507166 1.142838 1.653176 0.267116 0.766064 1.355041 1.954872 0.526119 1.075422 1.710371 0.220956 0.795713 1.455244 0.009017 0.572263 1.233742 1.805199 0.351214 1.029595 1.670810 0.244898 0.937764 1.599384 0.123281 0.827498 1.421956 0.071912 0.728628 1.352525 0.045071 0.629616 1.340343 -0.005599 0.656031 1.375774 0.006637 0.704005 1.346778 0.026276 0.793500 1.469628 0.149189 0.900114 1.563003 0.245092 0.942737 1.649937 0.383461 1.127594 1.833496 0.630173 1.303349 0.131274 0.795917 1.555017 0.354577 1.010369 1.836168 0.566636 1.392645 0.086446 0.905432 1.674552 0.357250 1.244274 1.933313 0.772802 1.613083 0.347109 1.198474 -0.009249 0.816204 1.581830 0.444697 1.252833 0.100839 0.820624 1.756368 0.556323 1.425952 0.202073 1.114604 1.862430 0.795077 1.577287 0.478129 1.375476 0.190400 1.049976 -0.001037 0.879181 1.750477 0.621432 1.466044 0.413933 1.258876 0.154463 1.083320 0.023406 0.861084 1.792442 0.739423 1.747839 0.555786 1.545715 0.467356 1.398174 0.305932 1.268574 0.245015 1.132661 0.145880 1.048422 0.017779 0.982729 1.923364 0.991511 1.957307 0.987170 1.902716 0.862590 1.910349 0.888567 1.920187 0.891111 1.886256 0.901663 1.918496 0.888352 1.914645 0.897685 -0.010739 0.984051 0.045577 1.089818 0.179909 1.199148 0.242854 1.360751 0.407503 1.407270 0.484554 1.541970 0.605558 1.705736 0.805033 1.904246 0.915747 0.018600 1.130323 0.275353 1.311301 0.394011 1.535459 0.601518 1.753472 0.894346 0.028620 1.161824 0.267287 1.447242 0.509507 1.658579 0.805465 0.032994 1.137888 0.321598 1.466044 0.648028 1.757642 1.015016 0.177874 1.323344 0.563863 1.750425 0.967203 0.229423 1.447094 0.698358)
      )

;;; 1024 odd --------------------------------------------------------------------------------
(vector 1024 52.508 (fv 0 1 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 1 0 1 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0)

       ;; pp:
	34.392721 (fv 0.000000 1.317015 0.674779 1.982962 1.240298 0.528350 1.833009 1.184236 0.493774 1.806145 1.182946 0.448825 1.821424 1.151757 0.480986 1.763416 1.095092 0.480961 1.791102 1.089742 0.425064 1.810482 1.139747 0.479199 1.851874 1.159831 0.593521 1.908566 1.257454 0.624639 1.923688 1.356173 0.730179 0.065917 1.453464 0.796504 0.143823 1.498311 0.930898 0.268139 1.670589 1.071439 0.437215 1.830479 1.211388 0.579275 1.944545 1.352798 0.782323 0.163213 1.546183 0.998593 0.372903 1.740779 1.173402 0.607928 1.957457 1.421061 0.794849 0.200913 1.627038 1.034849 0.443314 1.872228 1.278283 0.705912 0.120047 1.589838 1.008630 0.435503 1.873305 1.305243 0.750876 0.182690 1.613160 1.076228 0.522005 1.956954 1.342360 0.862346 0.285706 1.760264 1.217014 0.657381 0.105715 1.596004 1.072881 0.509956 1.989648 1.482549 0.909572 0.382452 1.811853 1.285963 0.790319 0.256573 1.787382 1.233231 0.764390 0.267593 1.710421 1.204241 0.717040 0.198483 1.666956 1.176156 0.629456 0.175734 1.712604 1.178350 0.682452 0.188929 1.683627 1.202732 0.719895 0.262572 1.790292 1.295239 0.795972 0.278798 1.833102 1.391719 0.903871 0.449916 1.974967 1.508707 1.037936 0.583107 0.141605 1.703044 1.238440 0.740044 0.299258 1.855225 1.429576 0.989596 0.514764 0.062488 1.647875 1.166263 0.761797 0.338506 1.886563 1.481742 1.044532 0.567257 0.147738 1.716688 1.294451 0.881968 0.450214 0.034958 1.623040 1.198786 0.793126 0.363888 1.989592 1.572534 1.171188 0.776534 0.389043 1.952235 1.569973 1.168583 0.777864 0.378289 -0.001325 1.586748 1.247726 0.850390 0.447022 0.074915 1.698680 1.326882 0.923704 0.565421 0.237083 1.853803 1.462394 1.056831 0.725010 0.363991 0.012216 1.652820 1.277504 0.885858 0.571701 0.222046 1.859385 1.459785 1.149298 0.900479 0.511390 0.159291 1.820323 1.458104 1.134095 0.799510 0.484897 0.157474 1.805324 1.476907 1.156786 0.816645 0.506771 0.217712 1.883199 1.597354 1.267437 0.968501 0.643403 0.348141 0.020835 1.704752 1.434890 1.117956 0.830415 0.530503 0.257242 1.947331 1.636892 1.333893 1.094111 0.807494 0.497231 0.208241 1.915803 1.637253 1.344506 1.123056 0.818815 0.558438 0.305779 0.033645 1.746424 1.518158 1.254602 0.968482 0.703273 0.446681 0.191633 1.923009 1.675267 1.476497 1.243700 0.963799 0.702657 0.470865 0.216712 1.947604 1.723443 1.524612 1.317633 1.059361 0.803260 0.606501 0.385543 0.151108 1.924868 1.695521 1.503299 1.281531 1.057219 0.859940 0.639048 0.449655 0.223761 0.026912 1.843647 1.609629 1.457584 1.243217 1.015301 0.856152 0.640867 0.449759 0.305372 0.109063 1.942683 1.700967 1.531585 1.369794 1.168417 1.002048 0.845104 0.663340 0.497202 0.326517 0.140599 1.976113 1.831407 1.680660 1.549301 1.318125 1.191866 1.065805 0.880646 0.703951 0.550638 0.452796 0.318542 0.141930 -0.012601 1.907136 1.768430 1.584977 1.494785 1.346262 1.172515 1.087240 0.966198 0.858840 0.703924 0.583577 0.474879 0.356476 0.197334 0.117696 0.015827 1.890727 1.784295 1.703630 1.595638 1.506189 1.428853 1.274571 1.233343 1.102367 1.018735 0.924053 0.785452 0.761105 0.689124 0.597680 0.499179 0.407270 0.343269 0.277076 0.175925 0.088491 0.032717 1.967765 1.919505 1.879027 1.804127 1.733139 1.641796 1.606538 1.554956 1.479897 1.436117 1.392760 1.340159 1.307310 1.256130 1.185964 1.154240 1.120113 1.056364 1.031418 1.011146 1.002760 0.949072 0.908672 0.908037 0.883988 0.852980 0.834564 0.819259 0.795425 0.760734 0.784982 0.783111 0.748706 0.732608 0.767981 0.770232 0.734127 0.724984 0.741588 0.719772 0.746177 0.752984 0.689077 0.730980 0.788291 0.778438 0.770103 0.834963 0.846761 0.844355 0.877284 0.886824 0.967748 0.943247 0.953145 0.998516 1.074936 1.134627 1.111633 1.183518 1.239447 1.257881 1.304163 1.349165 1.420127 1.460314 1.496520 1.556878 1.614974 1.710803 1.681591 1.773792 1.838949 1.957629 0.007509 0.060966 0.115693 0.179937 0.241468 0.370584 0.498441 0.512979 0.546150 0.672229 0.777236 0.837830 0.920719 1.012615 1.155268 1.230312 1.320616 1.421802 1.501826 1.610987 1.679360 1.836841 1.934427 0.048217 0.190841 0.256986 0.405599 0.477014 0.615469 0.744693 0.842741 1.035072 1.099483 1.194667 1.378972 1.515049 1.643373 1.758812 1.911300 0.069797 0.206668 0.341125 0.455780 0.613455 0.755668 0.907850 1.081007 1.195602 1.383308 1.535129 1.721055 1.878218 0.041536 0.189026 0.353901 0.557274 0.704028 0.848737 1.054909 1.205891 1.405592 1.560938 1.774026 1.957109 0.091600 0.275670 0.473243 0.686721 0.885668 1.094370 1.301170 1.471171 1.681947 1.843932 0.083106 0.309503 0.504329 0.657776 0.958045 1.134304 1.324317 1.567796 1.766909 -0.010677 0.204548 0.402525 0.672227 0.872133 1.100672 1.351290 1.618868 1.843408 0.075626 0.310891 0.533995 0.758681 1.049764 1.305644 1.509216 1.751579 -0.013073 0.274157 0.516916 0.787195 1.008768 1.270118 1.566936 1.844511 0.111113 0.352928 0.603624 0.891444 1.163881 1.458453 1.733841 0.023761 0.272991 0.561395 0.839977 1.118462 1.400784 1.742015 0.003935 0.343587 0.574049 0.863833 1.186411 1.499354 1.787869 0.097742 0.435769 0.722422 1.020105 1.302404 1.633505 1.971294 0.287332 0.601601 0.938262 1.263087 1.592727 1.925082 0.218290 0.545858 0.867906 1.215434 1.551258 1.932054 0.206490 0.558053 0.870542 1.249383 1.578868 1.965694 0.297948 0.669516 1.033694 1.365067 1.747836 0.132641 0.442218 0.763117 1.198426 1.557543 1.923389 0.271522 0.661990 1.014563 1.444192 1.797008 0.161991 0.524112 0.888782 1.298446 1.718909 0.076039 0.484430 0.839832 1.306121 1.668787 0.083313 0.435491 0.879913 1.257582 1.690719 0.080308 0.506436 0.891141 1.311805 1.764926 0.152722 0.559148 0.971038 1.448176 1.861615 0.252724 0.712441 1.076577 1.539614 1.971176 0.471842 0.835551 1.309070 1.717329 0.180700 0.636594 1.064174 1.544102 -0.007762 0.416278 0.869839 1.382020 1.815476 0.242696 0.711954 1.170869 1.650991 0.114702 0.570777 1.081829 1.495277 0.019284 0.487771 0.924782 1.480485 1.900085 0.404735 0.867120 1.327489 1.826631 0.358328 0.808934 1.333994 1.818046 0.333979 0.806858 1.380168 1.806454 0.359466 0.853343 1.382938 1.862803 0.340011 0.872790 1.396435 1.899417 0.442767 0.947972 1.493994 1.980445 0.529919 1.068138 1.589158 0.137689 0.663574 1.181143 1.752788 0.322938 0.820947 1.373072 1.889133 0.445963 0.992038 1.528221 0.095252 0.632298 1.198655 1.748035 0.297075 0.936319 1.444019 0.047595 0.589072 1.154608 1.695982 0.330959 0.852209 1.389811 0.077042 0.588685 1.198301 1.795185 0.391299 0.937105 1.523925 0.144908 0.714581 1.301387 1.939659 0.493164 1.107096 1.703099 0.316955 0.870409 1.501496 0.129186 0.711707 1.317045 1.978135 0.584637 1.224551 1.868953 0.442970 1.080315 1.707774 0.357018 0.974517 1.620426 0.235492 0.841352 1.521747 0.123410 0.790984 1.421592 0.064670 0.723003 1.351207 0.045603 0.693853 1.324941 1.912908 0.655177 1.230998 1.943702 0.623916 1.262813 1.966107 0.647728 1.291260 -0.014812 0.660846 1.298115 1.981874 0.677526 1.342226 0.031840 0.703622 1.442866 0.109986 0.793203 1.504134 0.206491 0.825844 1.597562 0.229750 0.978345 1.663467 0.352650 1.124308 1.766717 0.525984 1.219293 1.922574 0.634505 1.397287 0.124002 0.815463 1.541148 0.270810 0.971099 1.707596 0.437736 1.212172 1.890534 0.685239 1.396549 0.142117 0.918957 1.612171 0.353680 1.097854 1.856615 0.625689 1.360735 0.144106 0.868556 1.645077 0.371361 1.159444 1.934695 0.709026 1.444089 0.261765 0.979371 1.759253 0.586016 1.331408 0.040944 0.869861 1.656050 0.398966 1.230315 -0.011049 0.832509 1.590410 0.444043 1.224804 1.942115 0.805768 1.569036 0.391426 1.193271 0.004924 0.842160 1.602154 0.437188 1.258662 0.040043 0.863713 1.717625 0.507115 1.354811 0.156612 1.008626 1.821294 0.688919 1.479431 0.297482 1.146867 -1.810005 0.794603 1.643039 0.507902 1.394627 0.290315 1.060141 1.927240 0.768749 1.644777 0.486261 1.317365 0.218780 1.036302 1.922905 0.779349 1.630284 0.563756 1.406014 0.271501 1.141687 0.041164 0.874901 1.775827 0.668920 1.546772 0.364463 1.296432 0.170145 1.097114 1.973808 0.882000 1.792309 0.693487 1.612279 0.474678 1.407303 0.261600 1.229905 0.148970 1.031540 1.947561 0.833597 1.730941 0.706036 1.602109 0.526360 1.446317 0.373717 1.307908 0.239206 1.185883 0.110452 1.032954 1.964211 0.907562 1.815735 0.787542 1.710692 0.656401 1.632264 0.576380 1.564089 0.528884 1.469549 0.431489 1.360957 0.347473 1.293543 0.222180 1.220673 0.162142 1.148842 0.133424 1.094691 0.066720 1.019692 -0.006786 1.047790 0.011236 0.965321 -0.001627 0.937877 1.944261 0.948457 1.895707 0.938491 1.920374 0.874935 1.899449 0.872969 1.896569 0.903922 1.912216 0.936328 1.952448 0.974497 -0.020866 1.017959 0.034307 1.070969 0.074184 1.113113 0.135779 1.148879 0.214381 1.271662 0.291028 1.343329 0.357341 1.403370 0.477523 1.529396 0.455395 1.531182 0.601378 1.631083 0.711227 1.779155 0.803158 1.876551 0.904319 -0.035936 1.056817 0.081070 1.174378 0.241814 1.361054 0.443021 1.490091 0.588025 1.673301 0.764365 1.818515 0.913749 -1.572594 1.052243 0.145347 1.264925 0.396952 1.483333 0.517869 1.682100 0.797822 1.866022 0.903075 0.059188 1.174828 0.259185 1.333418 0.505568 1.549370 0.702792 1.812741 0.956324 0.074522 1.232362 0.362743 1.384904 0.593454 1.680361 0.825559 -0.014856 1.137655 0.232493 1.374902 0.524195 1.748587 0.847680 -0.019007 1.123158 0.242002 1.489181 0.571161 1.741577 0.879445 0.077203 1.250223 0.427139 1.517047 0.773877 1.934390 1.107301 0.293756 1.489154 0.668130 1.818952 0.975240 0.242147 1.451579)
       ) 

;;; 2048 odd --------------------------------------------------------------------------------
(vector 2048 83.108 (fv 0 1 1 0 1 0 1 0 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 1 0 1 1 1 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 0 0 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 0 1 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 0 0)

       ;; pp:
	49.287435 (fv 0.000000 1.163050 0.277646 1.373554 0.532725 1.655947 0.820565 1.927219 1.072745 0.213781 1.356870 0.485766 1.631061 0.742006 1.904473 1.072791 0.168162 1.327500 0.482508 1.618303 0.771705 1.904773 1.075185 0.215222 1.331659 0.505811 1.654486 0.806874 1.967453 1.148945 0.298519 1.468811 0.620677 1.776228 0.916764 0.084037 1.276979 0.394330 1.564305 0.749970 1.921810 1.121962 0.283495 1.432158 0.569765 1.736470 0.945747 0.080800 1.281360 0.443507 1.625343 0.807138 1.931288 1.158701 0.321739 1.530411 0.700718 1.890240 1.080826 0.244264 1.426463 0.600267 1.774421 0.956059 0.179462 1.370744 0.545050 1.731587 0.953856 0.145408 1.309295 0.511421 1.720420 0.940468 0.138677 1.323833 0.526937 1.717512 0.960485 0.118979 1.328593 0.512297 1.743197 0.943001 0.142257 1.379625 0.549098 1.794241 0.979771 0.180869 1.419130 0.639674 1.850039 1.057471 0.290050 1.461420 0.718417 1.916269 1.159248 0.376289 1.563835 0.838106 0.037452 1.264868 0.508203 1.717190 0.935903 0.151060 1.445292 0.635249 1.867259 1.091222 0.317894 1.534564 0.808426 0.018427 1.266394 0.501751 1.761251 0.969688 0.237229 1.447668 0.716233 1.967410 1.198658 0.437002 1.692103 0.935631 0.200934 1.451676 0.665324 1.935418 1.194689 0.438772 1.699157 0.941183 0.203098 1.450490 0.729357 1.974455 1.213355 0.514075 1.770795 1.016076 0.295868 1.541971 0.834628 0.084952 1.374773 0.619458 1.894143 1.155880 0.407649 1.664716 0.945886 0.261286 1.509195 0.790733 0.047158 1.339941 0.639173 1.891712 1.178155 0.440268 1.738740 1.006239 0.332871 1.560537 0.905839 0.183339 1.475973 0.742124 0.065572 1.351730 0.625747 1.922985 1.191379 0.495991 1.756410 1.042066 0.381601 1.688479 0.992449 0.276849 1.595880 0.892119 0.200958 1.480411 0.818652 0.063966 1.413208 0.715156 0.060494 1.306176 0.640302 1.933579 1.251340 0.581804 1.880299 1.222695 0.508151 1.829141 1.161265 0.457492 1.752607 1.117371 0.435825 1.739733 1.091313 0.385593 1.723501 1.053105 0.375468 1.675086 1.049746 0.382492 1.691106 1.002188 0.342988 1.668975 1.033939 0.350582 1.709840 1.039364 0.383857 1.699746 1.051825 0.373545 1.743567 1.077799 0.434091 1.756970 1.053381 0.443137 1.778145 1.141987 0.502378 1.868431 1.182592 0.530883 1.877105 1.221950 0.588162 -0.002020 1.300304 0.652550 0.036320 1.381929 0.759328 0.108443 1.476502 0.816837 0.213269 1.571344 0.932844 0.309569 1.662539 1.059667 0.419312 1.755499 1.147048 0.543079 1.922420 1.264945 0.657934 0.013132 1.401680 0.801987 0.158358 1.552678 0.920579 0.315474 1.699024 1.059115 0.446156 1.851458 1.209975 0.614230 1.975779 1.374097 0.796121 0.175298 1.591247 0.945333 0.354628 1.747078 1.154595 0.559485 1.967019 1.333396 0.720565 0.122103 1.526595 0.940456 0.327202 1.755683 1.117391 0.561694 1.958381 1.361193 0.803458 0.184110 1.616629 1.006925 0.442089 1.829688 1.261188 0.655027 0.090202 1.509923 0.945564 0.313543 1.753214 1.130948 0.568508 0.031964 1.450068 0.852461 0.283077 1.729985 1.127584 0.580935 -0.001861 1.435678 0.878175 0.293173 1.719785 1.184765 0.606034 0.040632 1.478744 0.942562 0.348499 1.801185 1.227587 0.696736 0.112509 1.564761 0.997649 0.448218 1.895579 1.324465 0.786873 0.273294 1.679282 1.152398 0.603084 0.027394 1.495848 0.964252 0.380193 1.852378 1.306385 0.788058 0.249156 1.687499 1.121997 0.611298 0.090174 1.559009 0.973272 0.464823 1.921940 1.378762 0.867253 0.345833 1.810423 1.301030 0.744928 0.252599 1.735986 1.205901 0.677471 0.145109 1.614381 1.080917 0.586366 0.083099 1.542748 1.001440 0.520731 0.003110 1.438773 0.930269 0.427623 1.972229 1.416238 0.940471 0.422555 1.905093 1.411628 0.878267 0.378282 1.870882 1.386240 0.872844 0.369185 1.888119 1.372843 0.868051 0.364903 1.849288 1.377695 0.870674 0.392638 1.894252 1.393508 0.953494 0.447692 1.964212 1.461256 0.958900 0.491909 0.001252 1.522315 1.032375 0.545182 0.047665 1.604571 1.102550 0.587351 0.146687 1.653910 1.193132 0.725831 0.238418 1.753114 1.296242 0.838033 0.349570 1.877468 1.384694 0.938419 0.481820 0.045217 1.557648 1.099375 0.609911 0.138825 1.670480 1.217161 0.761162 0.340569 1.849982 1.398484 0.929634 0.476983 0.033188 1.587225 1.150229 0.660516 0.218545 1.773455 1.321194 0.875537 0.412455 1.975569 1.556914 1.085507 0.655478 0.222974 1.781550 1.346518 0.898635 0.461489 0.030688 1.577108 1.128616 0.706201 0.284734 1.848941 1.423074 1.012127 0.550319 0.127044 1.684664 1.271718 0.847352 0.414193 1.990134 1.521095 1.136567 0.750291 0.337126 1.862249 1.460431 1.049297 0.669842 0.216907 1.819953 1.412426 0.984992 0.572590 0.137306 1.767447 1.330047 0.905950 0.512494 0.103808 1.706053 1.292143 0.937524 0.519078 0.097820 1.712597 1.292745 0.903437 0.500926 0.107737 1.719337 1.308083 0.905177 0.496968 0.133013 1.759477 1.355972 0.957870 0.560591 0.197890 1.801611 1.398075 1.020267 0.618113 0.240199 1.874548 1.486894 1.113092 0.726528 0.377432 1.957833 1.606621 1.229674 0.862702 0.506555 0.105441 1.735997 1.326469 0.994534 0.620808 0.244606 1.879074 1.511642 1.143326 0.775799 0.401368 0.075791 1.702891 1.377919 1.004500 0.619170 0.276148 1.905577 1.568310 1.206071 0.869241 0.512412 0.122276 1.822305 1.441374 1.069500 0.718082 0.389240 0.063602 1.687756 1.378724 0.999805 0.650714 0.332978 1.980285 1.636670 1.301261 0.946200 0.636798 0.314748 1.971775 1.637355 1.287360 0.964448 0.629994 0.298934 1.960682 1.641690 1.343792 1.003153 0.675512 0.317256 0.019972 1.693194 1.366188 1.021532 0.736417 0.404438 0.047067 1.755472 1.430810 1.127679 0.827156 0.504993 0.204999 1.869602 1.559982 1.266750 0.972466 0.612460 0.337579 0.023582 1.728936 1.434699 1.106015 0.784009 0.538390 0.203285 1.928266 1.597064 1.317846 1.015077 0.718614 0.443946 0.127570 1.807078 1.525053 1.247182 0.954079 0.675954 0.383769 0.077633 1.801620 1.532606 1.255462 0.983867 0.644793 0.353207 0.086592 1.828378 1.554513 1.293246 0.994370 0.712475 0.454107 0.144932 1.895728 1.591466 1.368095 1.085410 0.814684 0.542596 0.266934 0.005277 1.745816 1.477185 1.204917 0.948437 0.678999 0.410227 0.182102 1.882179 1.612229 1.401104 1.147230 0.888055 0.606492 0.343709 0.087358 1.853764 1.632545 1.312124 1.126022 0.888426 0.609422 0.346571 0.088432 1.864069 1.624618 1.413636 1.129791 0.907899 0.664305 0.453125 0.192741 1.939732 1.724665 1.446730 1.208735 1.009088 0.791036 0.553547 0.269865 0.050008 1.869993 1.607891 1.398702 1.178112 0.955620 0.721846 0.505763 0.260159 0.071405 1.830854 1.568352 1.366891 1.174316 0.942949 0.745228 0.526140 0.332456 0.118352 1.885916 1.701433 1.472261 1.239299 1.044248 0.831700 0.625882 0.454237 0.215857 0.017252 1.819254 1.615407 1.449492 1.196228 0.982253 0.820818 0.604584 0.442977 0.216483 0.024304 1.829511 1.646493 1.443177 1.275320 1.091080 0.881819 0.729119 0.498708 0.327643 0.166437 1.958363 1.799653 1.588527 1.414994 1.260561 1.019025 0.883661 0.702271 0.505868 0.333038 0.161804 1.992906 1.833629 1.635304 1.475105 1.312466 1.145459 0.986121 0.827858 0.611131 0.477466 0.312332 0.162403 1.993033 1.816815 1.647505 1.499793 1.348955 1.165690 1.035882 0.893667 0.723295 0.585232 0.422874 0.271934 0.113531 1.952972 1.802172 1.650708 1.483461 1.343486 1.218552 1.084842 0.927073 0.776245 0.635502 0.458305 0.373982 0.258566 0.082490 1.916515 1.785127 1.662029 1.542014 1.401296 1.288328 1.126154 1.007559 0.889400 0.744625 0.632843 0.508419 0.378037 0.200669 0.085018 0.008202 1.848031 1.734169 1.614621 1.493930 1.370837 1.302166 1.164868 1.024290 0.930883 0.834625 0.701624 0.606512 0.466962 0.388720 0.279406 0.140918 0.032687 1.927348 1.811775 1.710266 1.620460 1.492805 1.381998 1.317908 1.197423 1.122147 0.998133 0.894736 0.822100 0.734668 0.601331 0.525309 0.427892 0.326892 0.282159 0.156951 0.069505 1.983007 1.895744 1.832368 1.741307 1.671465 1.579508 1.479397 1.407456 1.341307 1.292493 1.172022 1.054844 1.025425 0.938514 0.866058 0.788578 0.719667 0.627909 0.568933 0.499665 0.417215 0.362650 0.295768 0.225056 0.146637 0.113130 0.045846 1.971304 1.915101 1.840250 1.815002 1.742119 1.655607 1.609235 1.549662 1.484722 1.419617 1.408714 1.318908 1.280672 1.236078 1.178979 1.119651 1.066519 1.044417 1.008080 0.950081 0.924323 0.862134 0.835117 0.809024 0.773528 0.699906 0.685111 0.616527 0.592797 0.532897 0.500140 0.456585 0.437938 0.409107 0.390095 0.358332 0.312446 0.308676 0.240543 0.209907 0.216831 0.210411 0.161769 0.125653 0.125949 0.116670 0.080163 0.075626 0.045297 0.004806 -0.000881 0.026299 1.965793 1.933605 1.942786 1.944348 1.952614 1.952589 1.927103 1.902751 1.909232 1.908039 1.900517 1.879669 1.891581 1.879298 1.891872 1.877416 1.870643 1.886309 1.944953 1.916353 1.939154 1.880988 1.904419 1.908941 1.910254 1.932089 1.969282 1.952058 1.945000 1.980171 0.011419 0.039090 0.041500 0.047816 0.085029 0.081559 0.110170 0.137541 0.124670 0.182784 0.191545 0.201628 0.268114 0.278620 0.284381 0.311542 0.326223 0.361901 0.375616 0.463339 0.474532 0.486778 0.532068 0.571238 0.610468 0.633708 0.681958 0.718256 0.773051 0.824140 0.873293 0.876610 0.910965 0.966901 1.003523 1.070562 1.122780 1.175620 1.208791 1.265780 1.302068 1.370182 1.451044 1.483311 1.520585 1.580432 1.644102 1.730843 1.770789 1.797830 1.879017 1.937891 0.019856 0.060042 0.124553 0.170564 0.216811 0.336571 0.366439 0.419283 0.547803 0.615076 0.686756 0.743054 0.808192 0.868812 0.967965 1.030425 1.105495 1.195851 1.276820 1.343432 1.439087 1.529664 1.600300 1.698173 1.760479 1.837558 1.924128 0.038094 0.120241 0.214007 0.317951 0.407855 0.504676 0.570855 0.654240 0.764928 0.855805 0.954502 1.051709 1.155105 1.262197 1.344793 1.435407 1.543123 1.670772 1.770468 1.865799 1.988288 0.099499 0.209570 0.297997 0.416558 0.512994 0.646099 0.763826 0.829292 0.972586 1.100975 1.192463 1.318284 1.435661 1.552010 1.667446 1.796953 1.895828 0.041405 0.168834 0.302036 0.399196 0.525607 0.643567 0.817912 0.935908 1.049011 1.178889 1.349363 1.470533 1.565826 1.734269 1.896736 0.005501 0.133187 0.267100 0.426661 0.580310 0.701157 0.855104 0.989792 1.134964 1.281741 1.433081 1.557022 1.743754 1.844434 0.034007 0.156833 0.323091 0.480395 0.650146 0.794963 0.940476 1.107393 1.252731 1.423226 1.591762 1.737804 1.887833 0.066146 0.199816 0.395900 0.573298 0.691305 0.879701 1.072741 1.236826 1.402627 1.563880 1.718916 1.915062 0.045140 0.237581 0.438738 0.580798 0.784617 0.966030 1.127512 1.284041 1.500016 1.652029 1.856424 0.063337 0.220388 0.388642 0.607545 0.805909 0.974538 1.152853 1.362173 1.532955 1.747946 1.927504 0.137055 0.324156 0.511474 0.727234 0.929245 1.096943 1.311277 1.529510 1.717204 1.929354 0.136096 0.316537 0.493748 0.725549 0.936978 1.151687 1.364715 1.550641 1.788754 1.967369 0.214151 0.411319 0.596806 0.843522 1.075423 1.273303 1.508848 1.709102 1.926626 0.164669 0.367063 0.581444 0.843645 1.064477 1.297447 1.488808 1.750805 1.965800 0.201438 0.416395 0.646546 0.890452 1.084015 1.348861 1.594443 1.818075 0.050802 0.296115 0.523258 0.792692 1.017642 1.273538 1.482331 1.728422 1.963843 0.219496 0.485923 0.690905 0.954474 1.220165 1.432291 1.730053 1.984033 0.222784 0.506499 0.721622 1.020753 1.264124 1.484071 1.737442 0.008877 0.293763 0.536176 0.800572 1.062039 1.344801 1.603165 1.888281 0.130074 0.414558 0.656092 0.938783 1.204182 1.472600 1.715585 0.025355 0.292603 0.583538 0.845516 1.127921 1.372150 1.695546 1.966468 0.221543 0.530377 0.793558 1.098411 1.356632 1.654543 1.955535 0.215710 0.523709 0.795967 1.100511 1.400246 1.690427 1.972022 0.266207 0.566998 0.873330 1.145759 1.473687 1.732502 0.041309 0.361298 0.681781 0.985976 1.233662 1.568222 1.842062 0.150190 0.511624 0.781348 1.087933 1.430677 1.711532 0.035866 0.350229 0.682226 0.921244 1.280371 1.577240 1.931037 0.233182 0.556380 0.877749 1.201053 1.529754 1.819573 0.176157 0.513656 0.816790 1.153452 1.451900 1.807514 0.113756 0.472986 0.806765 1.112493 1.445282 1.798965 0.093781 0.440000 0.772831 1.149981 1.498818 1.820883 0.161426 0.511652 0.813634 1.170367 1.539558 1.880179 0.197605 0.545597 0.908196 1.248869 1.624027 1.993151 0.291418 0.679658 1.035077 1.372909 1.711740 0.072351 0.454139 0.769060 1.133182 1.524037 1.903171 0.230092 0.617044 0.952001 1.338296 1.713107 0.075994 0.443935 0.779891 1.161968 1.532485 1.934216 0.232916 0.643695 1.033693 1.388978 1.763418 0.158282 0.531564 0.923030 1.280607 1.680049 0.033058 0.432091 0.830342 1.225022 1.574525 1.980673 0.372020 0.765894 1.154297 1.543700 1.929241 0.336874 0.704501 1.078420 1.502864 1.874394 0.278411 0.673779 1.082558 1.485362 1.892655 0.272103 0.679143 1.126508 1.483018 1.858194 0.311886 0.706336 1.119689 1.515117 1.930234 0.352607 0.728958 1.180615 1.582674 -0.011458 0.382422 0.817149 1.225669 1.663555 0.072122 0.522136 0.931979 1.334156 1.759365 0.194206 0.619361 1.047129 1.473102 1.908252 0.351516 0.772083 1.179926 1.644483 0.044574 0.475749 0.917446 1.334503 1.758597 0.228962 0.656066 1.131261 1.531736 1.952420 0.415411 0.858312 1.294649 1.758848 0.189426 0.612886 1.083380 1.497505 1.985693 0.443336 0.886511 1.331150 1.813863 0.233070 0.676790 1.130099 1.603581 0.055302 0.540261 0.998997 1.449019 1.920455 0.358725 0.844856 1.264985 1.778111 0.235398 0.686816 1.158649 1.610447 0.090461 0.550418 1.066038 1.507364 1.994625 0.420151 0.944881 1.409278 1.887639 0.359391 0.848416 1.314772 1.770668 0.248792 0.760921 1.244402 1.756852 0.252652 0.703484 1.163404 1.654408 0.164679 0.655036 1.142941 1.625021 0.133904 0.622543 1.126263 1.630291 0.123546 0.625620 1.093073 1.619368 0.102469 0.606535 1.087101 1.587765 0.099897 0.628994 1.136702 1.620371 0.161959 0.636159 1.142893 1.681191 0.151857 0.677434 1.211596 1.703772 0.227926 0.771686 1.266146 1.802804 0.317100 0.816843 1.330334 1.861595 0.386103 0.907612 1.408022 1.955543 0.472098 0.989797 1.544380 0.060134 0.607569 1.120958 1.622179 0.202636 0.754702 1.259644 1.800413 0.355305 0.852467 1.427250 1.936931 0.476054 1.030783 1.560498 0.106947 0.646657 1.237864 1.760957 0.297533 0.839061 1.392090 1.981467 0.509204 1.041723 1.622010 0.107363 0.685230 1.282738 1.821548 0.392932 0.943170 1.514801 0.035058 0.608491 1.175191 1.746330 0.299139 0.879938 1.445070 -0.001787 0.554868 1.132782 1.683410 0.273212 0.846311 1.408423 0.003830 0.577097 1.115510 1.694824 0.296676 0.868917 1.443750 0.022513 0.593863 1.183583 1.773899 0.348573 0.938190 1.535508 0.069825 0.715089 1.266797 1.883415 0.452363 1.042844 1.630007 0.194710 0.822770 1.421686 0.006472 0.621176 1.225177 1.804178 0.408934 1.002193 1.614950 0.209691 0.797600 1.413215 0.043022 0.605270 1.230426 1.842139 0.430016 1.071181 1.656314 0.292321 0.899593 1.524578 0.123367 0.722937 1.338216 1.965637 0.591781 1.216201 1.814694 0.429343 1.061910 1.690552 0.337918 0.935448 1.583594 0.173086 0.798338 1.428447 0.077432 0.684896 1.325474 1.963397 0.593516 1.253180 1.853700 0.531347 1.151683 1.746520 0.425377 1.027823 1.699093 0.333177 0.972850 1.609902 0.254362 0.906653 1.526954 0.225847 0.835769 1.466855 0.149601 0.794755 1.472543 0.118131 0.734656 1.404030 0.060242 0.727045 1.340500 0.029564 0.718625 1.343988 -0.004346 0.685714 1.342591 1.966238 0.667503 1.349852 -0.002971 0.703210 1.357155 0.009465 0.670856 1.356398 0.013330 0.698167 1.342918 0.045357 0.716155 1.383634 0.066321 0.749850 1.425646 0.130825 0.789828 1.468799 0.124200 0.833100 1.513466 0.184968 0.911501 1.594174 0.253162 0.976866 1.658160 0.318972 1.008058 1.691692 0.429447 1.114864 1.830218 0.507740 1.192600 1.907363 0.627089 1.308050 -0.023869 0.692513 1.415262 0.119283 0.836039 1.521751 0.244980 0.952758 1.642834 0.365258 1.090581 1.783116 0.502517 1.253315 1.907048 0.640444 1.381762 0.084253 0.818390 1.500682 0.258511 0.959052 1.666093 0.436675 1.168622 1.860895 0.574076 1.283511 0.009657 0.798719 1.538205 0.214051 0.952450 1.698753 0.447784 1.186388 1.858247 0.626974 1.347987 0.102119 0.855522 1.567443 0.343708 1.048347 1.808415 0.563378 1.317260 0.037027 0.798248 1.543255 0.284540 1.038822 1.782415 0.536310 1.274786 0.033989 0.801778 1.518276 0.287239 1.093224 1.832048 0.574059 1.361341 0.088951 0.857131 1.626231 0.399419 1.160410 1.908691 0.691937 1.400996 0.198198 1.010876 1.783108 0.552378 1.321187 0.069810 0.822885 1.649640 0.398546 1.161881 1.992740 0.718709 1.494106 0.274327 1.069239 1.874949 0.654740 1.412139 0.213263 1.030112 1.748596 0.568168 1.374868 0.155842 0.909714 1.739498 0.532008 1.295260 0.100142 0.892104 1.684374 0.494276 1.299126 0.082168 0.868839 1.674733 0.523178 1.308308 0.060301 0.901403 1.723633 0.527144 1.315281 0.095071 0.928769 1.769688 0.546110 1.365559 0.165197 0.991664 1.800022 0.649448 1.439023 0.280113 1.099551 1.892902 0.728472 1.558461 0.355122 1.155267 0.036651 0.803555 1.642245 0.486101 1.329471 0.153373 0.982109 1.814973 0.657477 1.472081 0.306013 1.138804 1.982639 0.806632 1.637032 0.492622 1.340692 0.166678 0.988021 1.860739 0.705110 1.541783 0.378007 1.213916 0.031456 0.923334 1.732364 0.624150 1.479737 0.314949 1.150499 0.017070 0.859860 1.709562 0.576208 1.451144 0.288172 1.156845 0.018462 0.888828 1.738856 0.600882 1.451392 0.305358 1.162471 0.071454 0.893471 1.790525 0.655173 1.527197 0.387534 1.299810 0.149548 1.016876 1.901076 0.773925 1.669962 0.533885 1.422131 0.264889 1.162826 0.053904 0.925273 1.783822 0.699297 1.593338 0.446127 1.329094 0.254005 1.148241 0.039106 0.936392 1.775754 0.686922 1.585294 0.459409 1.358560 0.246673 1.169932 0.062721 0.983726 1.860184 0.765327 1.652246 0.576169 1.499099 0.384989 1.260554 0.200648 1.126723 -0.014215 0.905397 1.801886 0.753345 1.641865 0.558767 1.467752 0.368838 1.294027 0.198410 1.090981 0.052952 0.991699 1.874409 0.806543 1.749760 0.655559 1.568484 0.520862 1.412201 0.366118 1.291778 0.238178 1.186893 0.061166 0.989290 1.973099 0.910404 1.832384 0.729437 1.723776 0.611997 1.559408 0.503451 1.415081 0.384261 1.301727 0.266130 1.222404 0.110539 1.064083 0.035684 0.943491 1.931964 0.862767 1.795698 0.762421 1.744397 0.666272 1.629091 0.597084 1.552001 0.500765 1.485981 0.446479 1.384691 0.357775 1.317093 0.302197 1.238922 0.194762 1.180556 0.151639 1.104156 0.074275 1.063876 0.008701 0.973523 1.931938 0.929619 1.899785 0.841696 1.876181 0.845013 1.791292 0.775116 1.753572 0.692830 1.726733 0.701663 1.665288 0.631802 1.649201 0.617241 1.594365 0.594942 1.588591 0.590950 1.543461 0.545092 1.544258 0.510400 1.542625 0.487864 1.489414 0.513606 1.491923 0.493471 1.497027 0.496715 1.533646 0.485406 1.488094 0.496820 1.543844 0.524720 1.515833 0.565220 1.558524 0.600489 1.612307 0.598486 1.630142 0.583528 1.626331 0.601297 1.642574 0.701670 1.674391 0.711291 1.729818 0.761143 1.763746 0.824000 1.826874 0.860664 1.866172 0.942874 1.940443 0.980274 -0.790948 1.041163 0.048939 1.113624 0.095128 1.190982 0.189672 1.265115 0.274570 1.325492 0.374151 1.447798)
       )
))


;; :odd 65536 (311.51645615075 1.5666759234657 2.0944106499714) 0.51769778542275 (100)



;;; ---------------------------------------- prime-numbered harmonics (and 1st) ----------------------------------------

(define primoid-min-peak-phases (vector

(vector 1  1.0   (fv 0)
     )

(vector 2  1.76  (fv 0 1)
     )

;;; 3 prime --------------------------------------------------------------------------------
(vector 3  2.1949384212494 (fv 0 0 1)
     1.980 (fv 0 62/39 13/41) ; 1 2 3 -- same as :all in this case
     1.9798574987316 (fv 0.0 1.5896952797511 0.31654707828801)
     1.9798030853271 (fv 0.0 1.5897271633148 0.31667485833168)
     )

;;; 4 prime --------------------------------------------------------------------------------
(vector 4  2.5978584289551 (fv 0 0 1 1)
     
     ;2.2039985204158 (fv 0 0 12 4) / 20
     2.1930510997772 (fv 0.000 0.996 0.596 0.217)
     2.1930510997772 (fv 0.000 1.996 0.596 0.217)
     2.1930510997772 (fv 0.000 0.004 1.404 1.783)

     2.1927945613861 (fv 0.0 1.0065363103693 1.4072853370949 1.7873527125308)
     2.1921416218407 (fv 0.0 1.0052774357064 1.4058145325161 1.7854903085184)
     2.1921210289001 (fv 0.0 1.0052587985992 1.4057868719101 1.7854607105255)
     )

;;; 5 prime --------------------------------------------------------------------------------
(vector 5  2.7172040939331 (fv 0 0 1 0 0)

     2.476848 (fv 0.000000 1.577434 0.385232 1.294742 1.022952)
     2.476837 (fv 0.000000 0.422530 1.614642 0.705077 0.976763)
     )

;;; 6 prime --------------------------------------------------------------------------------
(vector 6  3.1241359710693 (fv 0 0 0 1 0 0)

     2.805574 (fv 0.000000 1.568945 0.034019 1.082417 0.900415 0.797509)
     2.805492 (fv 0.000000 0.431060 -0.033992 0.917551 1.099550 1.202470)
     2.805413 (fv 0.000000 0.431110 -0.033974 0.917615 1.099635 1.202594)
     )

;;; 7 prime --------------------------------------------------------------------------------
(vector 7  3.4886319637299 (fv 0 1 1 0 0 0 0)

     3.061861 (fv 0.000000 0.715739 0.261422 0.169339 0.062479 1.180650 0.330190)
     3.061763 (fv 0.000000 0.715523 0.261251 0.168577 0.061828 1.179155 0.328665)
     )

;;; 8 prime --------------------------------------------------------------------------------
(vector 8  3.7088720798492 (fv 0 0 0 0 0 0 1 0)

     3.263115 (fv 0.000000 0.207652 0.035023 1.752163 0.064249 0.346105 1.403170 0.065734)
     3.262977 (fv 0.000000 0.792550 1.965637 0.248661 1.936840 1.655647 0.598935 1.936915)
     3.262789 (fv 0.000000 0.792261 1.965087 0.247823 1.935907 1.654053 0.597010 1.934463)
     )

;;; 9 prime --------------------------------------------------------------------------------
(vector 9  3.9154822826385 (fv 0 0 0 1 1 1 0 0 0)

     3.382645 (fv 0.000000 0.562589 0.520940 1.521127 1.682374 0.721497 0.805534 1.254209 0.726847)
     3.382399 (fv 0.000000 1.437745 1.479554 0.480268 0.319088 1.280870 1.197460 0.749784 1.277141)
     3.382150 (fv 0.000000 1.437471 1.479039 0.479171 0.317977 1.279012 1.195104 0.746644 1.274032)
     )

;;; 10 prime --------------------------------------------------------------------------------
(vector 10 4.1209712028503 (fv 0 0 1 0 0 0 1 0 0 0)

     3.602602 (fv 0.000000 1.405079 0.694565 0.388252 0.756491 1.849937 0.076683 1.023761 0.374165 1.226329)
     3.602329 (fv 0.000000 0.594431 1.305346 1.611464 1.243212 0.149889 1.922392 0.975619 1.625276 0.772405)
     3.601897 (fv 0.000000 0.594605 1.305309 1.611462 1.242927 0.149405 1.922318 0.974872 1.624292 0.771826)
     )

;;; 11 prime --------------------------------------------------------------------------------
(vector 11 4.4176635742188 (fv 0 0 1 0 0 0 0 0 0 1 0)

     3.779046 (fv 0.000000 0.211414 1.453486 1.827574 1.811694 1.949216 1.313595 0.823256 1.334141 0.127849 0.824659)
     3.778444 (fv 0.000000 0.211392 1.453207 1.827566 1.811268 1.948666 1.312975 0.822389 1.333108 0.126706 0.823083)
     )

;;; 12 prime --------------------------------------------------------------------------------
(vector 12 4.3595271110535 (fv 0 0 0 0 0 0 1 0 1 1 0 1)

     3.936657 (fv 0.000000 0.367346 0.997085 1.763425 1.295636 0.140826 0.757652 1.565853 1.284651 0.304758 0.331248 0.325474)
     3.936584 (fv 0.000000 0.366730 0.995852 1.762390 1.293763 0.137304 0.753397 1.560313 1.278944 0.297723 0.322472 0.315856)
     3.935928 (fv 0.000000 0.367095 0.996695 1.763345 1.295131 0.139476 0.755820 1.563961 1.282494 0.302360 0.327995 0.321982)
     )

;;; 13 prime --------------------------------------------------------------------------------
(vector 13 4.8980793952942 (fv 0 0 0 1 0 0 1 1 1 1 1 1 0)

     4.155503 (fv 0.000000 1.115751 0.463368 0.110540 0.613302 1.581997 1.394002 -0.005270 1.724217 0.023531 1.743892 0.616897 0.124222)
     4.155104 (fv 0.000000 0.888606 1.516761 -0.128988 1.376524 0.383262 0.572385 -0.041726 0.228441 1.918487 0.187862 1.304384 1.779710)
     4.154486 (fv 0.000000 0.888925 1.516611 -0.128449 1.377349 0.383874 0.573640 -0.040502 0.230047 1.920090 0.190320 1.307111 1.782269)
     )

;;; 14 prime --------------------------------------------------------------------------------
(vector 14 4.827317237854 (fv 0 0 0 0 1 0 0 0 0 1 1 0 0 0)

     4.325356 (fv 0.000000 0.359558 1.885647 0.244632 1.221244 1.839379 1.316045 0.525308 0.483244 1.183590 1.084986 0.271051 0.780356 0.855105)
     4.324364 (fv 0.000000 0.359123 1.885242 0.244967 1.221612 1.840358 1.317076 0.526663 0.485486 1.185929 1.087828 0.273652 0.783599 0.859686)
     )

;;; 15 prime --------------------------------------------------------------------------------
(vector 15 5.116711139679 (fv 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1)

     4.467959 (fv 0.000000 1.165302 0.822381 1.719844 1.177673 0.000074 -0.047034 0.249259 0.174863 0.272306 -0.034377 1.204925 0.800910 1.798882 0.085175)
     4.466924 (fv 0.000000 1.164687 0.821843 1.719833 1.177792 -0.001130 -0.048114 0.246943 0.173930 0.269647 -0.036792 1.203532 0.796937 1.795273 0.083498)
     )

;;; 16 prime --------------------------------------------------------------------------------
(vector 16 5.2015118598938 (fv 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1)

     4.602505 (fv 0.000000 0.065822 0.364277 0.133567 0.202441 1.541212 1.225002 0.832999 1.687176 1.503245 1.015565 1.715739 1.103351 1.602678 1.102870 1.723542)
     4.601495 (fv 0.000000 0.064663 0.363148 0.132261 0.201827 1.541434 1.224369 0.830652 1.686915 1.501871 1.012992 1.713503 1.102043 1.600360 1.101260 1.720212)
     )

;;; 17 prime --------------------------------------------------------------------------------
(vector 17 5.5318970680237 (fv 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1)

     4.719141 (fv 0.000000 0.742295 1.745265 1.857635 0.393094 0.085265 0.379253 1.692020 1.022244 0.008090 1.067230 1.241546 0.650781 0.027258 1.334059 1.354939 0.974983)
     )

;;; 18 prime --------------------------------------------------------------------------------
(vector 18 5.518 (fv 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 0)

     4.855354 (fv 0.000000 0.761212 1.399765 1.386893 -0.022155 1.259519 0.806762 0.461717 0.840663 0.867450 0.860949 1.743030 1.407070 0.651538 1.045391 1.279111 0.110257 1.307989)
     )

;;; 19 prime --------------------------------------------------------------------------------
(vector 19 5.7069295560724 (fv 0 1 1 0 1 1 0 1 0 1 1 1 0 1 0 0 0 1 1)

     5.015020 (fv 0.000000 1.616061 1.626145 1.313686 1.626275 1.187207 1.456980 0.377509 -0.071549 0.474989 0.997350 1.285450 0.372950 1.499943 0.593785 0.033723 1.161466 0.319734 1.064282)
     )

;;; 20 prime --------------------------------------------------------------------------------
(vector 20 5.8879864574703 (fv 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1)

     5.188618 (fv 0.000000 1.304708 0.831211 0.731788 0.021326 1.272273 1.777479 0.002778 1.612017 0.397413 0.057603 1.250739 0.234023 0.556087 0.011742 0.753589 1.624826 0.625035 1.017719 0.079500)
     )

;;; 21 prime --------------------------------------------------------------------------------
(vector 21 6.1138607493652 (fv 0 0 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0)

     5.324980 (fv 0.000000 0.284388 0.190620 0.601870 1.760108 0.865412 0.509624 0.391482 -0.117180 0.413220 1.669494 1.501699 0.066514 0.632948 0.866546 1.073191 0.975355 1.318609 0.054208 1.081180 1.759607)
     )

;;; 22 prime --------------------------------------------------------------------------------
(vector 22 6.3374844973589 (fv 0 0 1 1 1 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0)

     5.444390 (fv 0.000000 1.499825 1.282805 1.145752 0.718322 0.527629 0.660515 1.924701 0.466877 0.510672 0.652853 0.187109 1.099971 0.084112 0.857217 -0.068874 1.056229 1.751779 1.460546 0.258516 0.957206 1.594508)
     )

;;; 23 prime --------------------------------------------------------------------------------
(vector 23 6.5309901747782 (fv 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1)

     5.563562 (fv 0.000000 0.281094 0.583074 0.221311 1.169287 1.340406 0.217839 0.992042 0.637288 1.632696 0.471670 0.404966 0.171954 0.469626 0.291125 0.731904 1.276906 1.527897 0.612764 0.143351 1.082353 1.486999 1.452340)
     )

;;; 24 prime --------------------------------------------------------------------------------
(vector 24 6.5623834870329 (fv 0 0 1 1 0 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 0 0 0)

     5.645656 (fv 0.000000 0.825211 1.870903 1.169702 1.224751 0.476917 -0.084281 -0.215343 1.779853 1.403261 0.289331 1.689966 -0.267939 1.131483 1.839470 1.455399 1.365050 0.422908 0.906355 0.161003 0.266551 0.763039 1.248766 1.436520)
     )

;;; 25 prime --------------------------------------------------------------------------------
(vector 25 6.635721206665 (fv 0 0 1 0 0 1 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 0 1 1)

     5.810785 (fv 0.000000 0.563705 1.200194 1.330185 1.448503 0.304746 -0.097873 1.178970 1.307797 0.187993 1.570595 0.364607 -0.021932 1.552639 -0.223928 1.041142 1.388107 1.015775 1.883861 0.551891 1.621094 0.871585 1.482986 0.450455 0.538066)
     )

;;; 26 prime --------------------------------------------------------------------------------
(vector 26 6.8401503562927 (fv 0 1 0 0 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 0 1)

     6.060342 (fv 0.000000 -0.041165 -0.003731 0.423811 0.999953 0.846414 -0.006772 1.678875 0.280560 0.164498 1.427575 0.432370 0.295956 0.293617 -0.083444 1.838911 -0.050243 0.444002 1.425675 0.812741 0.728420 0.505166 0.737245 1.256666 1.911599 0.384822)

     ;; 25+1
     6.122073 (fv 0.000000 0.460498 1.557923 1.378525 1.718931 0.447198 0.063372 0.871474 1.497987 0.124645 1.393742 0.468348 -0.079259 1.274284 -0.437034 1.081613 1.726707 1.093435 1.712067 0.466467 1.547007 0.967081 1.258363 0.304978 0.430183 0.007813)

     ;; 27-1
     6.163135 (fv 0.000000 0.728435 -0.162948 -0.044439 -0.171766 1.094395 0.029113 0.072422 1.082217 0.879605 -0.111434 1.156162 1.018106 0.872058 0.997367 0.178509 -0.068227 -0.141285 1.119460 -0.213041 0.834585 -0.226205 0.775314 -0.211931 0.098174 0.839934)

     ;; 24+2
     6.157978 (fv 0.000000 0.747592 -0.138036 -0.096812 -0.252632 1.140904 0.038566 0.088301 1.237633 1.010838 0.001393 0.982309 1.045743 0.842207 0.970725 0.281016 0.130720 0.128208 1.180011 0.026054 0.957275 -0.052702 1.071527 -0.026637 0.338920 1.156596)
     )

;;; 27 prime --------------------------------------------------------------------------------
(vector 27 6.9491486549377 (fv 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 1 0 1)

     6.133994 (fv 0.000000 1.619323 0.268498 0.605329 0.261788 1.741906 1.690385 1.044397 0.095253 1.526766 0.682732 1.844188 1.227922 -0.046848 0.854154 -0.053734 1.525611 0.460071 0.230079 1.191101 1.252287 1.704028 -0.029667 1.798141 1.802482 1.571525 0.379519)
     )

;;; 28 prime --------------------------------------------------------------------------------
(vector 28 7.1576952934265 (fv 0 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 0 0)

     6.190947 (fv 0.000000 0.460822 1.000235 0.802902 1.169351 0.023696 1.059034 0.557253 0.339303 -0.037893 0.757652 1.745281 0.808299 1.572816 1.228654 0.154747 0.925847 0.957314 0.565556 0.484885 0.864794 1.110639 0.659146 1.596331 1.587743 0.524304 1.470688 0.086831)
     )

;;; 29 prime --------------------------------------------------------------------------------
(vector 29 7.2415904369233 (fv 0 0 1 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 0 1 1 1 1 0)

     6.364996 (fv 0.000000 0.899299 0.027883 1.660781 0.583908 0.594226 1.394105 1.009420 -0.076432 0.063436 1.779221 1.537249 1.002516 1.590894 -0.057219 1.023692 1.515341 1.279493 0.140022 -0.035094 0.723643 0.484040 0.612756 1.373872 1.209603 1.304864 0.985337 0.845953 0.581252)
     )

;;; 30 prime --------------------------------------------------------------------------------
(vector 30 7.1189651489258 (fv 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 0)

     6.451812 (fv 0.000000 1.683608 0.803658 0.933316 0.850814 1.701341 1.277986 1.473972 1.214431 1.898492 0.954836 1.784293 1.951482 1.381903 0.107238 0.105553 1.260609 1.566570 0.409971 0.385253 1.590967 0.968660 0.054889 0.914665 1.664915 1.656054 1.094096 1.343614 0.650979 0.864222)
     )

;;; 31 prime --------------------------------------------------------------------------------
(vector 31 7.4906754493713 (fv 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 1)

     6.701515 (fv 0.000000 0.707031 0.658082 0.778665 1.395076 0.565253 0.395956 1.065744 1.710897 0.801620 1.512714 1.121124 1.688469 1.338401 0.622466 1.725968 1.295045 0.892738 0.244280 0.958065 0.828867 0.800413 0.064995 1.349330 1.878947 0.861664 0.695097 1.073201 0.907698 1.910585 0.416756)

     ;; 30+1
     6.615976 (fv 0.000000 1.619082 0.923169 1.083084 0.781957 1.611725 1.231796 1.488577 1.226090 0.083999 1.020558 1.699217 -0.014673 1.346295 -0.063182 -0.022308 1.145334 1.655017 0.305814 0.373230 1.594198 0.992544 0.008700 0.844473 1.661053 1.801356 0.850925 1.501091 0.639723 0.929876 0.176165)
     )

;;; 32 prime --------------------------------------------------------------------------------
(vector 32 7.6309351921082 (fv 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0)

     6.829554 (fv 0.000000 0.353769 0.512450 0.072420 0.585526 0.147200 0.899992 1.177093 0.978539 1.319655 0.744178 0.765351 0.245581 0.971119 0.793076 1.664663 0.073560 1.968693 0.219541 -0.142255 1.387234 0.796908 0.143099 1.544481 1.359170 -0.183896 0.300411 0.910906 1.770472 1.091214 0.308566 1.575721)

     ;; 31+1
     6.864557 (fv 0.000000 1.684531 0.907871 0.937049 0.576460 1.576459 1.338803 1.563265 1.353157 -0.035626 1.089066 1.735003 -0.147935 1.441252 -0.039130 -0.134227 1.098931 1.555167 0.496142 0.453987 1.332697 1.055734 0.066385 0.757972 1.840407 1.616574 0.776929 1.400044 0.751413 0.894663 0.088525 0.248633)

     ;; 33-1
     6.772281 (fv 0.000000 -0.104424 1.369006 0.833384 0.832316 0.684545 1.080484 0.996539 1.125140 0.264781 0.104162 1.034076 1.132845 0.966270 -0.147521 -0.070104 -0.108305 0.137329 0.336575 0.120508 -0.030229 1.160998 -0.149314 0.018366 1.122475 -0.088339 0.190809 0.749038 -0.017283 -0.181633 0.895249 0.011511)
     )

;;; 33 prime --------------------------------------------------------------------------------
(vector 33 7.7389698028564 (fv 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 0 1 0 0 1 1 0)

     6.846444 (fv 0.000000 1.540730 1.269040 0.749184 0.961715 0.756150 0.876752 0.416027 1.022774 0.964239 1.083376 0.550495 1.494046 0.196678 0.925862 0.362000 0.602774 1.401166 0.181115 1.142230 0.264880 0.003237 0.994773 0.034504 0.433160 0.985315 1.781928 0.301442 1.605371 1.626266 0.719713 0.024414 0.683173)
     )

;;; 34 prime --------------------------------------------------------------------------------
(vector 34 7.9624452590942 (fv 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 1 1 0 0 0)

     6.991192 (fv 0.000000 1.753519 0.200582 1.709673 0.364080 0.826783 0.339745 0.629017 1.916751 1.209744 1.171294 -1.878381 1.379347 0.682133 1.526150 -0.403398 1.590798 1.225400 1.046260 0.612397 0.683970 1.216405 0.626313 0.038228 1.289324 1.063867 0.495350 0.036835 0.806562 1.424403 1.251942 0.446062 1.562643 0.395827)
     )

;;; 35 prime --------------------------------------------------------------------------------
(vector 35 8.0019035339355 (fv 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 1 1 1 0 0 0 0)

     7.163607 (fv 0.000000 1.266503 0.439150 0.502027 -0.033212 1.025554 1.236433 1.852606 1.521580 0.894650 0.982935 1.338812 0.175216 1.929333 1.483026 0.812681 0.144350 1.543173 0.347773 0.191753 0.996456 1.584603 0.595312 0.526825 0.409349 0.179419 0.765371 0.331481 0.734526 0.534073 1.395010 0.148584 0.213643 0.199292 1.071967)

     ;; 34+1
     7.250722 (fv 0.000000 1.833406 0.276500 1.676183 0.284824 0.952861 0.274961 0.549393 1.855724 1.259088 1.170735 -1.972280 1.233657 0.707290 1.353858 -0.502547 1.522469 1.324648 0.749540 0.580274 0.753018 1.178005 0.466257 0.194427 1.292227 0.949230 0.518969 0.114495 0.772899 1.429905 1.258425 0.333692 1.615077 0.323568 0.024260)

     ;; 36-1
     7.226635 (fv 0.000000 0.015639 1.313898 1.067017 0.012678 0.205933 -0.220601 0.741706 1.132622 1.273222 0.064153 -0.061062 0.016379 -0.109368 1.266070 0.708642 0.100132 0.506303 0.326245 0.009869 0.128374 0.656500 0.103915 0.211137 -0.048847 0.134642 0.911060 -0.081204 1.078761 0.959214 1.298439 0.058469 -0.265528 -0.047843 0.487719)

     ;; 37-2
     7.337307 (fv 0.000000 1.255715 1.209445 1.285464 0.609971 1.084010 0.746511 0.131735 0.992588 -0.165317 1.349080 0.347697 1.563547 0.269558 1.052909 1.187133 0.630960 0.126283 1.974444 0.920793 0.149276 0.235777 0.684763 0.805570 1.167945 0.309490 0.732548 0.639985 1.194191 -0.082787 0.442732 0.130132 1.297597 1.522523 -0.004298)

     ;; 36-1 again
     7.270607 (fv 0.000000 1.224685 0.688298 0.933888 0.799409 1.040304 0.882804 1.691450 1.134732 0.118453 1.557180 0.586802 1.344681 0.201498 1.086994 1.546739 0.883322 0.653756 0.179650 1.296869 -0.225456 -0.099064 0.999391 0.575486 1.210161 0.192596 0.624682 0.585705 1.229555 0.174654 0.165564 0.036132 1.525777 1.424254 0.061875)
     )

;;; 36 prime --------------------------------------------------------------------------------
(vector 36 8.3031883239746 (fv 0 0 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0)

     7.274340 (fv 0.000000 0.295214 1.648256 0.584870 0.666257 0.185867 0.791897 0.205307 0.094941 1.078003 0.393529 1.106172 0.869922 0.874970 0.914168 -0.075429 0.352173 -0.206951 1.433194 0.016874 1.804925 1.769354 0.780563 1.415336 1.733698 0.569376 0.514365 1.527457 0.738716 1.585860 0.004452 0.303849 0.468887 1.200500 1.687045 -0.272506)

     ;; 34+2
     7.326328 (fv 0.000000 0.224320 -0.145696 0.800619 0.068109 0.664686 1.202282 -0.026091 0.124729 1.390134 0.094406 0.787084 -0.284049 0.196932 0.011705 -0.061258 1.288162 0.209106 0.650222 0.837106 1.144479 -0.004444 -0.079317 -0.252873 1.282751 1.105461 -0.151235 -0.220044 0.048391 0.784914 0.800542 0.208916 -0.135577 0.180326 -0.083829 0.058422)

     ;; 37-1
     7.188203 (fv 0.000000 1.311785 0.710177 0.919863 0.806114 1.220385 0.913244 1.649138 1.158903 -0.117650 1.420543 0.532433 1.420824 0.031354 1.130470 1.529113 0.851075 0.566610 -0.022612 1.109803 -0.179865 -0.219467 1.014788 0.671450 1.268941 0.095596 0.593655 0.518696 1.410763 0.018554 0.158212 0.022548 1.368086 1.347905 1.919434 1.204584)
     )

;;; 37 prime --------------------------------------------------------------------------------
(vector 37 8.4775905609131 (fv 0 0 1 0 0 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 1 0 0 1 1)

     7.291595 (fv 0.000000 1.385574 1.094219 1.256844 0.579410 1.074351 0.652085 1.737017 1.132509 0.023783 1.497034 0.201580 1.618763 0.156207 1.295800 1.067404 0.684624 0.145230 1.829069 1.057901 0.013674 0.026959 0.892842 0.719241 1.431201 0.175608 0.784924 0.608541 1.031616 0.099402 0.526982 -0.079447 1.301608 1.399791 1.919478 1.303159 1.654914)
     )

;;; 38 prime --------------------------------------------------------------------------------
(vector 38 8.5527725219727 (fv 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0)

	7.395907 (fv 0.000000 0.229361 1.165787 -0.110257 0.360118 0.958030 0.069946 0.724227 0.169462 0.629891 1.545997 1.736970 0.340776 1.117984 1.362890 -0.333746 0.304546 0.284267 1.101870 -0.220411 1.748591 0.492644 0.009938 0.667006 1.844837 0.974373 0.297199 0.452149 0.892727 0.659717 0.488303 1.523287 0.213584 0.164389 -0.141331 1.392379 0.641595 0.183921)
     )

;;; 39 prime --------------------------------------------------------------------------------
(vector 39 8.8173857964668 (fv 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0)

     7.452083 (fv 0.000000 -0.003327 0.916189 -0.059920 1.642633 1.388547 0.951086 0.403885 -0.174730 0.969870 0.918579 1.463076 0.392796 0.310790 1.322505 1.568519 -0.013721 1.080957 1.546749 1.334291 1.196748 1.241477 0.666226 0.658367 0.483066 0.709740 0.970447 1.021587 1.015221 1.154977 1.464323 0.177481 1.236124 1.797764 1.373028 0.022625 0.381731 1.433474 1.548372)
     )

;;; 40 prime --------------------------------------------------------------------------------
(vector 40 8.9134502410889 (fv 0 0 1 0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1)

     7.703588 (fv 0.000000 1.735488 1.656851 1.224286 0.044381 0.581732 0.870499 0.678243 0.396963 1.559949 1.753552 0.343685 1.182244 0.436049 0.704051 1.315848 0.612950 0.283482 1.616300 0.417655 1.870367 0.045128 0.404846 0.027986 1.838093 1.350622 0.788217 0.264993 1.270928 0.453126 0.746731 1.438328 0.714772 1.669939 -0.004462 0.932368 1.451203 0.182154 1.479009 1.559243)

     ;; 39+1
     7.542973 (fv 0.000000 -0.041200 1.048990 -0.088096 1.469596 1.426659 0.704430 0.532863 -0.271666 1.021284 0.854349 1.691302 0.165173 0.234052 1.293759 1.553143 -0.290199 1.111317 1.388897 1.428535 1.198923 1.295686 0.607124 0.554003 0.553080 0.829915 1.372981 1.113790 0.892248 1.036179 1.715559 0.155629 1.485519 1.734906 1.416427 0.111242 0.390867 1.435517 1.580034 0.394829)
     )

;;; 41 prime --------------------------------------------------------------------------------
(vector 41 9.1567583084106 (fv 0 1 0 0 0 1 0 1 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

	7.865855 (fv 0.000000 0.608338 -0.060098 1.260166 0.343974 0.016950 -0.247861 -0.127427 0.108013 -0.084777 1.510985 0.480995 1.445979 -0.013184 1.345726 0.790782 0.040458 1.554753 1.065658 0.404394 0.487625 0.747477 1.296516 0.562390 1.713973 0.682704 0.619563 0.946390 0.938148 0.771516 1.743852 1.318578 0.561202 0.223419 0.656108 1.580261 0.293473 0.865769 0.313306 1.414219 0.732206)

	;; 40 + 1
	7.720320 (fv 0.000000 -0.115191 1.182807 0.023805 1.562688 1.390669 0.693038 0.384401 -0.432021 0.902901 0.808566 1.764939 0.071559 0.180956 1.306988 1.386263 -0.325917 1.184850 1.379486 1.267820 1.088531 1.531591 0.443244 0.383528 0.465953 0.767254 1.394223 1.223657 0.755343 1.085342 1.737843 0.118005 1.556067 1.593289 1.235706 0.152645 0.264917 1.446707 1.588810 0.262147 0.136941)
     )

;;; 42 prime --------------------------------------------------------------------------------
(vector 42 9.2193641662598 (fv 0 0 0 1 1 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0)

	7.967849 (fv 0.000000 -0.295563 -0.099748 1.645998 0.994997 1.211069 1.302259 1.702033 0.311003 1.380194 1.021127 1.240710 0.343052 -0.024723 0.792276 0.383501 1.598556 0.301882 1.243030 0.805694 1.869672 1.515585 0.818223 0.277882 0.151155 1.792151 0.439910 1.043803 1.106182 0.814125 1.169477 0.353168 0.087800 0.390591 1.058086 1.167577 0.254783 0.202834 1.385207 0.802821 0.860337 0.585161)

	;; 41+1
	7.869767 (fv 0.000000 -0.061943 1.138293 -0.062352 1.677941 1.387789 0.696129 0.354209 -0.606277 0.820682 0.889412 1.749845 0.156626 0.153950 1.241240 1.226387 -0.243954 1.180563 1.446765 1.133383 1.088516 1.534516 0.379614 0.441871 0.531294 0.625705 1.211996 1.249505 0.811274 1.137271 1.690807 0.091208 1.719416 1.589298 1.288167 0.231299 0.255350 1.544776 1.691946 0.324682 0.145604 -0.146627)
     )

;;; 43 prime --------------------------------------------------------------------------------
(vector 43 9.4329051971436 (fv 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1)

     8.045098 (fv 0.000000 1.817726 0.258426 -0.110242 1.213496 0.116841 0.189488 1.576716 0.807175 0.814618 0.974723 1.682997 0.507481 0.400625 1.207987 1.609632 0.042496 -0.018345 0.188609 1.537320 1.421611 1.487985 0.125474 1.195313 1.777900 0.097292 1.089983 0.284602 -0.035452 0.114851 -0.014176 0.684966 0.713816 1.698239 1.505014 0.277355 1.721721 1.307506 0.790560 -0.024590 1.696281 0.234403 1.469880)

     ;; 44-1
     7.936372 (fv 0.000000 0.547620 0.739031 1.442428 0.549512 0.577585 0.459986 1.527195 1.215306 0.359566 1.254454 1.014209 0.650822 0.596119 0.113760 0.896295 1.336762 1.511746 1.057661 0.208519 1.475881 1.168554 0.473943 0.693948 1.550424 1.853884 0.945372 1.595949 0.778275 1.634785 0.682180 0.046625 1.212650 1.360060 1.301003 1.439535 -0.124409 0.942540 0.731761 1.333209 0.714942 0.471897 0.650290)
     )

;;; 44 prime --------------------------------------------------------------------------------
(vector 44 9.6263332366943 (fv 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1)

	8.176709 (fv 0.000000 1.257550 0.185092 0.796030 0.965692 0.874957 0.509986 0.767942 0.341523 0.782136 0.038164 0.864386 1.769646 0.079272 0.204040 1.740714 1.803726 0.921433 1.521099 0.318212 0.489644 0.199834 1.292293 1.253087 0.592822 0.223282 1.099161 1.260064 0.604685 -0.025938 0.319010 0.021098 0.567021 1.052022 1.286473 1.481285 1.059939 -0.262037 0.222072 1.063305 0.811574 1.525604 0.928719 1.796860)

	;; 45-1
	8.096356 (fv 0.000000 0.562197 0.780059 1.445061 0.297993 0.361779 0.450977 1.579753 1.251177 0.406295 1.140037 1.270462 0.688429 0.742666 0.310753 0.814792 1.242058 1.590925 1.239292 0.244955 1.563091 1.453652 0.466187 0.926031 1.420624 1.869915 0.975705 1.750035 0.662252 1.713066 0.628893 0.005473 1.403763 1.231668 1.313745 1.548647 0.181657 1.165934 0.757198 1.479137 0.584746 0.478571 0.777834 -0.217890)
     )

;;; 45 prime --------------------------------------------------------------------------------
(vector 45 9.7923860549927 (fv 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1)

     8.156599 (fv 0.000000 0.504922 0.822887 1.454973 0.213937 0.312131 0.458345 1.480849 1.269108 0.365243 1.136961 1.370780 0.828694 0.744612 0.260671 0.781252 1.246491 1.660559 1.261864 0.159271 1.560422 1.570906 0.366422 0.845904 1.468563 1.922211 0.928352 1.793476 0.526909 1.787205 0.580505 0.086715 1.290991 1.241712 1.319383 1.542592 0.148589 1.164537 0.833531 1.339389 0.578898 0.484755 0.736594 -0.242427 0.801799)
     )

;;; 46 prime --------------------------------------------------------------------------------
(vector 46 9.7220277786255 (fv 0 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0)

     8.261457 (fv 0.000000 0.441366 0.083292 1.447582 1.080353 0.774431 1.031820 0.396571 -0.029186 1.855247 0.017145 1.352007 1.097546 -0.117433 1.240120 0.492762 0.418188 1.012485 1.839598 0.629307 1.143304 0.248686 0.786166 1.148481 0.944111 0.160389 0.887598 1.383912 1.951363 0.089194 -0.493379 0.490615 1.318218 0.811054 1.210433 0.709880 -0.035076 1.496491 0.871523 0.967276 1.296575 1.252407 1.309942 0.517653 0.515382 1.088417)
     )

;;; 47 prime --------------------------------------------------------------------------------
(vector 47 10.0            (fv 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0)

     8.421570 (fv 0.000000 1.199171 0.222010 0.019659 0.963763 0.124932 1.211729 1.737991 1.094580 1.129734 1.190285 0.683207 -0.164112 0.760349 0.581192 1.729176 1.903941 0.164043 1.172610 0.400191 0.298724 1.638863 1.039149 1.877811 1.604178 1.896976 0.373311 1.442981 1.057507 1.304308 1.366346 0.989245 1.435551 1.273331 -0.037405 1.342363 0.026228 1.277440 1.325955 1.225688 -0.091448 1.243683 1.490056 0.134719 0.038689 0.617889 0.397223)

     ;; 46+1
     8.268289 (fv 0.000000 0.357443 0.232912 1.380147 1.115226 0.794363 1.003118 0.354162 -0.098010 1.882974 0.011731 1.431470 1.060533 -0.173886 1.243389 0.433576 0.427301 0.932883 1.964789 0.661151 1.135623 0.224910 0.703565 1.198466 0.988252 0.007869 0.877345 1.478313 1.822166 0.223930 -0.274799 0.527743 1.328214 0.957522 1.199220 0.836897 0.009700 1.499725 0.828964 0.836474 1.158394 1.390117 1.252214 0.607531 0.602372 1.108309 -0.308979)
     )

;;; 48 prime --------------------------------------------------------------------------------
(vector 48 10.073040962219 (fv 0 0 0 1 1 1 1 1 0 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1)

     8.468727 (fv 0.000000 0.332125 1.567930 1.667264 0.442332 0.427404 0.736248 1.688653 -0.012194 0.001963 0.946717 0.783117 0.528363 1.021452 0.764794 0.424311 0.975629 0.318718 -0.017782 0.452256 -0.011646 0.634442 1.620045 1.251183 1.855810 -0.212250 0.823868 1.371356 1.272442 0.687371 1.532020 1.114788 -0.144494 0.601199 1.707870 0.646890 1.378450 0.845449 0.429827 0.928104 1.365712 1.152987 1.849756 1.181620 0.737310 0.960075 0.285625 -0.264250)
     )

;;; 49 prime --------------------------------------------------------------------------------
(vector 49 10.209 (fv 0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 0 0 0)

     8.635701 (fv 0.000000 1.497567 0.290121 0.986848 0.952275 0.318809 -0.087393 0.815566 0.755417 1.644345 1.093196 1.596845 1.195048 1.825278 0.352544 1.500396 0.111683 1.721871 0.368622 0.016610 1.166008 0.992742 0.548001 1.794858 -0.049088 0.145023 0.031735 0.501144 1.167443 1.072488 1.771198 1.965444 1.813832 0.055643 1.178365 0.731304 -0.108216 1.823862 1.684500 1.505474 0.962838 1.663276 0.896417 -0.047513 0.341741 0.867962 0.622940 1.858325 1.225407)

     ;; 48+1
     8.663039 (fv 0.000000 0.233282 1.589447 1.671036 0.438087 0.414167 0.679012 1.728850 0.023692 0.137515 1.015881 0.702030 0.655508 0.905046 0.682763 0.579979 1.082390 0.228729 -0.103033 0.415057 0.029242 0.738968 1.600166 1.205869 1.975508 -0.109422 0.921796 1.220834 1.561720 0.608646 1.497185 1.060920 -0.116318 0.565733 1.743370 0.776166 1.333349 0.886037 0.536440 0.806648 1.332765 1.166311 1.868868 1.215596 0.738421 0.985296 0.279827 -0.366830 0.092455)

     ;; 51-2
     8.582839 (fv 0.000000 1.015072 1.263701 0.053109 -0.198567 -0.119876 -0.074305 0.688310 -0.022609 -0.056918 -0.335561 1.264545 0.175435 0.115160 0.045329 0.044221 0.357377 1.286502 1.011774 0.136492 0.790313 1.216480 1.412877 1.287840 -0.457032 1.185491 0.632250 1.022556 0.092623 0.762340 0.282587 1.173246 0.884457 -0.232556 1.275664 0.026771 1.001804 1.127230 -0.112893 0.390785 1.060560 -0.011579 0.935318 0.798092 1.155912 -0.045270 0.311662 -0.007451 -0.291556)
     )

;;; 50 prime --------------------------------------------------------------------------------
(vector 50 10.402973175049 (fv 0 0 1 0 0 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1)

     8.676090 (fv 0.000000 1.487746 1.059441 1.025372 1.327289 1.088034 0.562677 1.658212 1.275003 1.216651 1.253782 1.464671 0.843363 1.799547 0.053937 0.685289 -0.108899 0.042484 1.103905 1.939714 1.165290 1.002239 0.949057 0.182130 0.764686 0.473808 0.974801 0.114296 0.831687 0.096978 1.328258 1.232106 1.944542 0.907302 0.451517 -0.196659 0.834303 1.063413 0.149435 1.600622 0.877347 1.358710 0.921698 1.475066 0.048402 1.601242 0.635073 1.286124 0.058142 1.221762)
     )

;;; 51 prime --------------------------------------------------------------------------------
(vector 51 10.5841327092253 (fv 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1)

     8.652946 (fv 0.000000 0.552138 1.581370 0.856634 0.465868 0.045489 1.205822 1.403218 0.756158 -0.011738 -0.321071 1.578958 0.777145 -0.086815 1.971735 0.371739 1.194751 0.827647 1.040995 0.971514 -0.103101 0.019110 0.372121 0.808088 0.569420 0.781614 0.253334 1.524564 0.516258 0.490039 0.356392 1.792991 0.344408 0.177045 1.267803 0.433404 0.355268 0.458783 0.927023 0.366207 1.155001 1.183690 0.095395 1.563819 1.892864 1.168287 1.234142 0.740278 0.190550 0.004346 0.616333)
     )

;;; 52 prime --------------------------------------------------------------------------------
(vector 52 10.64324760437 (fv 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0)

     8.817479 (fv 0.000000 0.192798 -0.100823 0.105700 1.730433 1.638226 1.781516 0.446103 1.408775 0.715209 0.415865 -0.245030 1.066219 1.674348 0.092550 0.243790 1.271420 0.492458 1.433072 -0.090924 1.409056 0.418163 -0.043783 1.528262 0.043370 1.470310 -0.026080 0.499433 0.961527 0.302716 0.768317 0.686930 1.132134 1.628592 0.701543 1.788137 -0.034028 1.911798 1.160323 1.534119 1.837005 0.994515 0.926867 1.263245 0.147467 1.441753 0.596623 1.430563 0.749640 0.874777 1.097276 0.882051)
     )

;;; 53 prime --------------------------------------------------------------------------------
(vector 53 10.678050692694 (fv 0 1 0 0 1 0 0 0 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0)

     8.953081 (fv 0.000000 0.788009 1.225451 0.347894 0.336100 0.208645 0.898104 1.918038 1.003547 1.827170 1.665391 0.306753 1.689654 -0.198226 0.387896 0.060438 0.532055 0.677523 0.983575 1.778621 1.222864 0.337168 0.648048 -0.059018 1.548622 0.344050 1.142170 1.624821 1.518580 1.046929 0.925606 0.370284 1.876402 0.554168 0.470781 0.776401 0.841340 0.579159 -0.039732 0.259208 1.047217 1.262845 0.826737 1.840523 0.361249 1.360958 0.974324 0.708988 1.467968 0.681409 0.951917 1.111614 0.104759)
     )

;;; 54 prime --------------------------------------------------------------------------------
(vector 54 10.582709312439 (fv 0 0 1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 0 1 0 1 1)

     9.112388 (fv 0.000000 1.372093 1.646727 1.761844 1.071783 1.166972 0.499625 1.353759 1.094968 1.557358 1.723230 0.305306 1.364143 0.672762 0.599554 1.674554 1.196343 0.689593 0.333493 0.212755 0.120333 -0.065165 1.426986 0.808156 0.885002 1.618233 0.075135 0.412240 1.106276 -0.040331 -0.211790 1.351271 1.357179 1.301081 0.221358 0.762445 1.564667 0.202710 0.573995 1.689552 -0.051477 0.301020 1.046697 1.701827 0.907077 1.277114 0.971869 1.525859 1.752503 0.167031 0.961443 1.737745 0.154432 0.302453)

     ;; 53+1:
     8.998093 (fv 0.000000 0.833931 1.255875 0.472195 0.500550 0.340958 0.889757 0.121823 0.999320 0.070168 1.822021 0.295115 1.599399 -0.278061 0.379867 0.053981 0.523149 0.552145 1.083746 1.542483 1.125023 0.280437 0.929583 0.145648 1.540352 0.570681 1.206535 1.391546 1.500834 1.280825 0.880416 0.297287 1.694488 0.607699 0.578077 0.733733 1.017737 0.538903 -0.079031 0.194742 1.159273 1.400820 0.893900 1.836755 0.359898 1.011475 0.991536 0.601097 1.637805 0.711833 1.160027 0.904915 0.240256 -0.100113)
     )

;;; 55 prime --------------------------------------------------------------------------------
(vector 55 10.806410031758 (fv 0 0 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 0 0 0)

     9.146479 (fv 0.000000 0.967563 0.927691 -0.360864 0.609958 0.765470 0.915027 1.392793 0.614248 0.953214 1.344500 -0.018857 0.737576 1.736931 1.631618 1.349440 1.307993 0.206073 1.281714 1.103145 0.628925 0.887703 0.370354 -0.354414 1.471798 1.220261 -1.840190 0.459998 0.319058 1.569823 -0.402409 1.289240 1.207248 1.401276 1.334659 0.647076 0.124770 0.659947 1.220235 0.570854 1.506684 0.326123 0.300730 0.226766 1.668245 0.069090 1.091084 1.792555 0.448614 1.706735 1.552724 -0.117313 1.845004 0.249242 0.002966)
     )

;;; 56 prime --------------------------------------------------------------------------------
(vector 56 10.976176261902 (fv 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1)

	9.398396 (fv 0.000000 0.094656 0.695846 1.603834 1.096947 0.190376 1.605668 0.402610 1.589743 -0.046719 0.479899 1.053090 1.455624 1.475630 1.560612 1.146935 -0.097134 1.379647 0.063965 0.026372 0.001091 0.417420 0.372665 0.295880 0.375803 1.735862 -0.241158 0.226369 0.344276 0.614802 1.609054 1.733862 -0.048343 1.607193 0.295369 0.796984 0.953479 0.777849 -0.315058 -0.215768 1.445593 0.800481 -0.018312 0.085983 1.492275 1.800390 0.955850 0.344132 0.748720 -0.182377 -0.021909 0.550436 1.590599 1.124545 1.577258 1.243187)

	; 55+1
	9.213442 (fv 0.000000 0.950801 0.904714 -0.508703 0.661009 0.831586 0.884308 1.497773 0.634206 0.800998 1.332469 0.044201 0.725326 1.681333 1.804312 1.427989 1.278065 0.225748 1.222051 1.044010 0.570030 1.029930 0.330187 -0.354523 1.385937 1.248658 -1.994529 0.420806 0.301325 1.707662 -0.449043 1.164884 1.219283 1.466837 1.371490 0.636485 0.172055 0.643834 1.272809 0.563267 1.543526 0.353044 0.368529 0.213972 1.758208 0.147525 1.155503 1.739729 0.512727 1.742754 1.612106 -0.186498 1.717200 0.213592 0.028127 -0.105694)
     )

;;; 57 prime --------------------------------------------------------------------------------
(vector 57 11.247724533081 (fv 0 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 0 0 0 0 1 1)

	9.567937 (fv 0.000000 -0.074489 1.764667 1.562855 -0.045942 1.688785 0.424094 0.788093 1.318249 1.699500 1.597710 0.759778 0.347915 -0.095100 0.967999 1.558373 1.224410 -0.005793 1.163013 1.817831 1.260212 1.123377 0.674940 0.664211 1.043062 -0.159530 1.686511 0.775041 1.335210 0.664604 0.251332 0.046341 0.133324 0.094858 -0.073202 1.314310 1.874591 1.317512 0.082927 1.516375 0.524906 0.812252 0.819331 0.420977 1.188424 0.646402 1.644694 0.551897 0.757891 1.055306 1.295231 1.095924 0.627116 1.401110 0.235317 1.483585 0.936274)

	;; old 56+1
	9.529594 (fv 0.000000 0.147122 0.761626 1.581775 0.991521 0.303398 1.538303 0.250231 1.516156 -0.033991 0.496296 1.098128 1.450885 1.473689 1.672255 1.122803 -0.210233 1.300861 0.064078 0.004743 0.013527 0.414701 0.325782 0.261492 0.363241 1.708852 -0.205248 0.171322 0.269253 0.615657 1.654144 1.808189 -0.053761 1.665701 0.276750 0.872232 1.105105 0.764170 -0.448707 -0.286149 1.484838 0.786694 -0.015133 0.173812 1.436796 1.864880 0.980591 0.327079 0.799812 -0.230067 -0.066056 0.534676 1.508154 1.155564 1.645708 1.183535 0.088307)

	;; 56+1
	9.246042 (fv 0.000000 1.068254 0.912344 -0.579409 0.699964 0.833848 0.899690 1.280880 0.729555 0.772814 1.165620 0.113563 0.958418 1.776654 1.746943 1.402708 1.254651 0.244552 1.303164 0.938450 0.572896 0.902407 0.419733 -0.424031 1.525432 1.318732 -1.856680 0.294120 0.271355 1.825185 -0.454382 1.066744 1.206377 1.513453 1.348624 0.487546 0.090590 0.574392 1.204512 0.396962 1.588976 0.339722 0.399778 0.196224 1.725471 0.086935 1.086444 1.835851 0.439978 1.611137 1.567240 -0.063335 1.719558 0.447194 0.045334 -0.250234 0.164616)
     )

;;; 58 prime --------------------------------------------------------------------------------
(vector 58 11.261419321863 (fv 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 1 1 0 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1)

	9.496347 (fv 0.000000 0.059743 0.548997 0.530263 0.226709 0.929160 -0.003047 0.125973 0.533773 1.548469 1.087643 1.570490 0.714949 0.863084 1.167817 1.094596 0.710052 1.511445 0.483704 1.291778 1.179203 1.180959 0.109073 0.094424 -0.384843 0.103787 0.722897 0.948977 1.484212 0.671726 0.961877 1.358209 1.232685 1.456297 0.651862 0.171910 0.370224 1.284842 1.052862 0.918644 1.853795 0.756435 1.065168 1.308648 0.977275 0.827028 1.655929 0.742384 0.217339 0.808896 0.296638 1.208667 1.265590 0.019271 0.389600 0.183945 0.533565 1.638734)

     ;; 57+1
	9.428825 (fv 0.000000 1.018908 0.901444 -0.615819 0.860485 0.681403 0.932140 1.367257 0.748226 0.856986 1.087905 -0.048047 0.777707 1.778584 1.735112 1.472731 1.253932 0.300987 1.373471 0.844264 0.566375 0.847406 0.280264 -0.528105 1.424599 1.371262 -0.084608 0.304532 0.358385 1.652997 -0.476953 1.150522 1.226908 1.441019 1.199333 0.513348 0.039957 0.545771 1.150857 0.473094 1.508935 0.466022 0.322870 0.315957 1.725788 0.047786 1.078150 1.717254 0.429354 1.592876 1.500586 -0.142982 1.851065 0.442979 -0.034671 -0.282154 0.042441 0.094078)
     )

;;; 59 prime --------------------------------------------------------------------------------
(vector 59 11.34253692627 (fv 0 0 0 1 0 1 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 1 1)

     9.424456 (fv 0.000000 0.987831 1.263819 0.296674 0.942023 0.441708 0.159032 1.836629 0.018568 -0.056141 1.409550 -0.045051 1.184001 1.106575 0.859402 0.865929 1.344330 -0.022715 1.852739 1.494636 -0.146236 1.538496 0.317717 1.985293 0.734507 0.982797 0.398619 1.595615 1.945403 0.701589 1.197367 1.012887 0.543978 1.174908 1.430788 -0.128888 0.147545 0.984537 1.324816 1.549298 0.656696 -0.006636 1.201874 1.148588 0.795564 1.108773 1.687645 0.571018 0.266043 1.954157 1.006840 0.084613 0.524554 1.761460 0.208641 0.094850 0.141845 0.437731 0.909728)
     )

;;; 60 prime --------------------------------------------------------------------------------
(vector 60 11.512454032898 (fv 0 0 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0)

     9.657740 (fv 0.000000 1.547780 1.677673 1.073672 -0.181562 1.466665 0.178185 1.296168 1.180984 0.799114 0.182696 1.568868 1.363180 0.494840 -0.056028 1.003607 1.541063 0.417763 1.700695 0.183440 0.905951 0.331420 0.794062 0.890276 1.122192 1.798420 0.731798 0.770804 1.703299 0.813575 0.660992 1.187791 1.645314 1.481351 1.240486 1.798220 0.254797 0.358769 1.758554 0.791594 0.131877 0.642084 0.956267 -0.226021 -0.095209 1.368914 1.922174 1.414955 -0.029158 0.411776 1.206976 1.720135 0.221233 0.679698 1.694654 0.956928 0.036757 1.792835 0.004408 0.786308)

     ;; 59+1
     9.567932 (fv 0.000000 0.987181 1.155730 0.332214 0.959672 0.422609 0.139164 1.858170 1.971933 -0.085625 1.367690 0.092445 1.162248 1.070252 0.880093 0.923540 1.286688 -0.075166 1.802993 1.583654 -0.058064 1.544851 0.459865 -0.017801 0.622918 1.081434 0.420245 1.717169 1.954432 0.771937 1.209324 0.923890 0.475411 1.176878 1.472899 -0.165713 0.114758 1.012016 1.333064 1.459949 0.672973 0.014198 1.279333 1.152000 0.797283 1.103957 1.630723 0.491103 0.146670 1.964833 1.081703 0.052456 0.483259 1.761154 0.245675 0.138222 0.019396 0.460673 0.907223 -0.053470)
     )

;;; 61 prime --------------------------------------------------------------------------------
(vector 61 11.850807189941 (fv 0 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1)

     9.848207 (fv 0.000000 0.465768 1.502052 1.208112 1.687111 1.098823 0.136558 1.242624 0.803898 1.305434 0.569022 0.707134 0.107360 0.681230 1.626786 1.180372 0.428544 0.064966 0.220601 0.606687 1.112200 0.761343 0.147814 1.074432 0.974575 0.150330 0.295078 1.965080 0.596171 1.395202 1.511902 0.719123 0.058806 0.162986 1.356055 1.017221 1.069746 0.022458 1.119273 0.473964 1.602481 0.117785 0.745272 0.467208 1.699348 0.892580 0.864605 0.883970 -0.281719 1.309124 0.657105 1.259919 1.224601 1.818239 1.863265 0.645463 0.762464 -0.184384 0.778659 1.743798 0.403645)

     ;; 60+1
     9.674304 (fv 0.000000 0.942988 1.185184 0.401228 0.922656 0.384439 0.124613 1.797598 1.871679 -0.085568 1.287716 0.127521 1.211990 1.110404 1.018269 0.906936 1.241998 -0.006224 1.802916 1.625042 -0.136580 1.655334 0.507522 0.019978 0.578715 1.045428 0.440588 1.674467 1.983824 0.788229 1.261730 0.967897 0.387538 1.232060 1.526658 -0.187478 0.170755 1.104323 1.383734 1.532583 0.668063 0.082609 1.255511 1.174792 0.795177 1.135630 1.640793 0.324749 0.311806 1.930005 1.005470 -0.027359 0.440238 1.824355 0.182093 -0.005304 0.026835 0.470199 0.945827 0.102044 -0.110982)
     )

;;; 62 prime --------------------------------------------------------------------------------
(vector 62 11.709966659546 (fv 0 0 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 0 0 1 1 0 1 0)

	9.787654 (fv 0.000000 0.164735 0.495571 0.194524 1.700130 -0.039330 1.112293 0.631854 1.622240 0.234398 0.057253 0.622061 1.299807 1.150659 1.089362 1.262936 0.326220 0.146372 0.440190 0.705699 0.320098 1.480138 -0.723459 0.298112 1.483411 -0.413300 0.234477 1.688059 0.592934 1.563752 1.095288 0.196837 0.912297 -0.114061 -0.100816 0.101717 1.569678 0.725974 1.210511 1.268915 0.220895 1.789986 0.880755 0.550271 0.862882 1.562267 1.201540 0.696671 0.139442 0.617496 0.156201 0.378889 1.874933 0.550733 0.693398 0.120666 0.641553 1.379939 0.633855 1.283976 1.797799 0.211762)

     ;; 63-1
	9.733736 (fv 0.000000 -0.139952 0.119957 0.369616 1.566294 0.358962 1.150575 0.658899 1.145823 0.565498 0.818035 -0.078756 0.339361 0.036853 -0.081445 1.284492 0.104736 1.510521 0.937147 0.788271 1.526814 1.396514 1.280490 1.469510 1.789649 0.285213 0.650226 0.881585 0.728974 1.810762 -0.044930 1.659215 0.713447 0.623929 1.496774 0.951425 0.357075 1.369241 1.674041 0.637986 0.902200 0.722908 0.299878 -0.044061 0.733643 0.407073 1.473577 0.408899 -0.199740 0.425185 0.345580 1.674452 0.584665 1.350356 0.031128 1.247150 0.256688 0.635884 0.503839 0.135030 0.263417 1.006656)
     )

;;; 63 prime --------------------------------------------------------------------------------
(vector 63 11.975765228271 (fv 0 0 0 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0)

     9.712956 (fv 0.000000 -0.211512 0.128156 0.205336 1.631792 0.223993 1.120077 0.677974 1.189520 0.635587 0.786994 -0.140042 0.270508 0.031528 -0.026718 1.271754 0.161836 1.519308 0.919403 0.725190 1.656604 1.430895 1.216006 1.507263 1.740613 0.380045 0.740422 0.860394 0.644699 1.785241 -0.063336 1.757196 0.670969 0.631113 1.432730 0.929994 0.449373 1.355893 1.665671 0.697673 0.900343 0.706516 0.261640 0.022846 0.779166 0.410962 1.451999 0.372853 -0.213671 0.428231 0.418722 1.770544 0.502738 1.423557 0.029160 1.322724 0.247556 0.608992 0.392989 0.101597 0.240746 1.015503 0.321046)
     )

;;; 64 prime --------------------------------------------------------------------------------
(vector 64 11.932915769505 (fv 0 0 1 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1)

     9.911897 (fv 0.000000 -0.176519 0.277243 1.457679 0.409823 0.492128 1.258703 0.953828 0.451970 -0.035755 1.413815 0.576790 1.007663 1.557197 0.406393 0.901721 0.935399 0.344434 0.058666 -0.004874 0.033568 0.266354 0.964058 1.260921 0.110946 0.586184 1.551133 0.560107 1.655832 1.431146 0.094791 0.726936 0.404173 1.258539 0.363860 0.287498 0.704556 1.358694 0.848351 1.352219 1.358382 1.634548 0.646434 0.536511 1.151363 1.507902 0.370229 -0.111562 0.018845 1.351430 0.613337 0.524145 0.030867 1.602701 0.958191 0.774983 0.900142 1.319974 1.665985 0.954409 0.571244 0.683517 0.257283 0.560359)
     )

;;; 65 prime --------------------------------------------------------------------------------
(vector 65 12.264873504639 (fv 0 0 0 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0)

	10.245810 (fv 0.000000 1.314885 -0.128565 -0.061767 0.245423 0.308150 0.666161 1.799635 0.121779 1.318087 1.095106 1.813764 1.363803 0.687883 0.082989 1.252556 0.674431 0.081538 1.120705 -0.053380 0.222404 0.418326 1.266348 1.095265 1.090145 0.914385 0.672015 0.091667 0.221386 0.230885 1.047444 0.950558 0.582123 1.829143 1.939330 0.054401 0.665085 0.669868 1.410783 0.893429 1.398299 1.087907 0.120341 1.456277 0.134554 1.548051 0.155644 0.252207 0.317819 0.803060 0.255268 0.011364 1.407071 1.292331 1.862089 -0.144291 1.528219 0.241256 -0.215537 1.071975 0.180828 1.509027 1.608200 1.880646 0.432459)

	;; 64+1
	10.041913 (fv 0.000000 -0.231597 0.347996 1.329229 0.210946 0.358775 1.318136 0.940959 0.423445 -0.059602 1.487652 0.528102 0.959962 1.627507 0.242008 0.890416 1.013953 0.381481 0.048421 0.000955 0.073351 0.222260 0.956448 1.250606 0.032874 0.581396 1.552144 0.533024 1.803356 1.588620 0.155988 0.709145 0.416103 1.098822 0.371144 0.488313 0.641224 1.409761 0.769076 1.378012 1.338517 1.672969 0.693576 0.622573 1.111879 1.498797 0.384021 -0.285902 0.098531 1.294593 0.540682 0.514444 0.031708 1.544980 0.882941 0.833995 0.886145 1.471130 1.590019 0.959450 0.407950 0.787696 0.104075 0.545846 0.096608)
     )

;;; 66 prime --------------------------------------------------------------------------------
(vector 66 12.090668678284 (fv 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0)

     10.065843 (fv 0.000000 -0.332278 0.420111 1.296912 0.003400 0.570050 1.383101 1.228319 0.329402 0.002928 0.332461 0.786693 1.331535 0.237292 1.020996 0.126259 1.613105 1.241426 -0.367526 0.057745 0.063068 1.144890 0.058649 0.546763 0.792290 0.527577 1.597907 0.336733 0.558202 0.349266 0.412838 -0.066236 0.132007 1.032081 0.645360 0.084627 0.218015 0.961024 1.464682 1.216442 1.186753 0.039444 1.139907 1.145545 1.026317 1.617341 0.492061 1.804706 -0.218027 0.872723 0.567401 1.745335 1.259266 0.682677 1.100993 1.200392 1.089304 0.237539 0.552581 0.047166 0.743492 0.228597 1.363708 0.915715 -0.032741 0.312099)
     )

;;; 67 prime --------------------------------------------------------------------------------
(vector 67 12.20425496356 (fv 0 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1)

	10.320633 (fv 0.000000 -0.066702 1.242059 1.936441 0.363520 0.137300 1.303419 1.038801 0.086937 0.040742 0.388452 0.616008 0.087295 0.258798 0.692201 0.072909 1.551804 1.636838 1.398740 0.687317 1.022745 0.988646 1.580618 0.947110 0.593084 0.854099 0.599585 1.071060 0.286673 0.719337 0.932505 1.632806 1.461969 0.862483 1.295247 0.807609 -0.156076 1.297879 1.679745 0.135687 1.421850 1.188268 0.748752 1.493420 1.296035 0.019305 0.979542 0.607739 1.082240 1.014220 1.355630 1.025509 1.427015 0.501576 0.029659 1.501116 0.667518 0.375063 0.738972 1.634670 1.190958 0.695412 0.198543 0.008987 0.953545 0.492193 0.512363)

	;; 66+1
	10.270103 (fv 0.000000 -0.339086 0.529826 1.196633 0.017211 0.503338 1.254976 1.117868 0.397424 -0.207937 0.422035 0.795324 1.396533 0.167749 1.073809 0.015795 1.618310 1.175144 -0.342555 0.080333 0.003741 1.084430 -0.010093 0.560025 0.867130 0.369945 1.456200 0.444129 0.652644 0.167650 0.320656 -0.145242 0.307342 1.062944 0.883767 0.299612 0.277397 1.030332 1.417097 1.462867 1.323580 0.189769 1.089141 0.993348 0.915509 1.413244 0.654039 1.674522 -0.169566 0.974872 0.769627 1.866694 1.124536 0.783559 1.039716 1.307670 1.055658 0.169272 0.711344 0.060085 0.731555 0.347823 1.529167 0.605251 0.021941 0.493045 -0.306702)

	;; 63+4
	10.427697 (fv 0.000000 0.966407 0.007580 1.117030 0.884875 -0.175736 1.107926 1.097831 1.037576 0.927078 0.966085 0.319675 1.083926 1.106087 -0.189435 0.791093 0.993213 0.299434 1.143696 -0.196739 -0.029109 0.887111 0.277418 0.908738 0.949002 0.901486 1.105128 -0.045569 -0.301510 0.181857 -0.008960 0.833755 0.782101 0.955244 1.472884 0.046447 1.032739 0.722326 0.974274 -0.002839 -0.169106 0.164428 1.138848 0.015499 -0.200081 0.988166 0.843017 1.122563 0.966722 1.090406 0.167301 -0.055129 1.042886 1.189957 0.335648 0.995142 0.029028 1.138068 1.075538 0.633942 0.180537 0.051411 0.928317 0.861628 0.910920 0.920218 1.020151)
     )

;;; 68 prime --------------------------------------------------------------------------------
(vector 68 12.466281890869 (fv 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 0 1 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 0 1 0 1)

	10.396366 (fv 0.000000 0.186038 1.693540 -0.027216 1.013938 1.733700 0.097268 1.072327 -0.058595 1.297512 -0.223714 1.812708 1.571967 1.911449 0.105375 0.724913 0.167937 1.379937 1.003328 0.296337 -0.012219 0.740941 0.185685 1.450530 0.967328 0.422187 -0.221136 1.128630 1.299506 1.950429 -0.063323 -0.049468 0.618925 -0.250368 1.155850 1.363266 1.946601 1.896273 0.663379 0.530614 -0.343257 1.261470 -0.040006 0.308974 1.407553 1.782235 1.820125 1.703055 0.892390 0.956493 1.267334 1.223362 0.886365 0.857699 0.303604 1.740946 1.505785 1.372752 0.598965 0.555179 0.138411 0.702673 0.141261 1.356921 1.480871 1.810731 0.336170 1.491601)

     ;; 69-1:
	10.294332 (fv 0.000000 1.774482 1.200978 1.227268 1.382220 0.282793 1.553903 1.732456 0.753211 0.760153 1.851640 1.366776 1.204200 0.843725 0.253043 0.277483 0.103836 -0.065448 1.410455 0.651921 1.994318 0.062621 0.954681 0.275021 0.597686 1.119852 0.016268 -0.163905 1.984242 1.567894 0.922417 -0.007109 1.063508 1.828059 0.334844 1.052665 1.253633 1.262611 1.579598 0.998618 1.505098 1.876188 0.866523 -0.096826 0.810066 0.678537 0.661302 -0.487197 0.199269 0.661440 1.362169 1.024823 0.238200 0.872311 1.253153 1.455210 0.266625 1.222868 1.015892 1.101616 1.115849 0.596998 1.881890 -0.207678 1.082090 0.165311 1.300155 1.153433)
     )

;;; 69 prime --------------------------------------------------------------------------------
(vector 69 12.29846572876 (fv 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 0 0 0)

     10.373386 (fv 0.000000 1.755739 1.344798 1.270777 1.245975 0.212147 1.637341 1.674637 0.780881 0.678256 0.020823 1.453992 1.251154 0.906274 0.263210 0.219658 0.201277 -0.006107 1.482279 0.690309 1.943780 0.107940 0.891912 0.210217 0.501788 1.062586 1.748465 -0.256216 1.793890 1.653062 0.760504 1.930618 1.125386 1.733012 0.392253 1.017032 1.329369 1.438951 1.614342 0.946373 1.511397 1.735151 0.924137 -0.243047 0.908372 0.619579 0.722525 -0.263766 0.070586 0.505534 1.390127 1.112173 0.360123 0.888486 1.115007 1.574719 0.192671 1.168644 1.072297 1.024494 1.027776 0.495929 1.728234 0.030466 1.010825 0.303774 1.356890 1.301979 0.677665)
     )

;;; 70 prime --------------------------------------------------------------------------------
(vector 70 12.665026664734 (fv 0 1 0 0 1 0 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 1 0 0)

     10.403198 (fv 0.000000 0.659269 0.149246 -0.229331 0.464031 1.037303 0.297808 1.605092 1.041553 1.638786 0.968456 1.081487 0.986031 0.766531 0.645236 0.176746 0.062926 0.650627 0.887571 0.432390 0.968052 1.660369 1.053082 0.034606 1.910731 1.746043 1.683430 0.821251 1.040772 1.932221 1.382437 0.501614 -0.111054 0.532350 0.190557 0.045053 1.319570 -0.066664 0.486188 1.777508 1.395223 0.491473 0.176001 0.623855 1.347864 1.207736 1.451417 1.558733 1.414717 1.920228 0.418857 1.530616 0.099510 0.214659 0.967449 -0.145006 1.519241 0.691963 1.366826 0.718889 0.337519 0.685633 1.635424 0.816319 0.060380 1.097292 0.149441 0.900329 0.876399 0.145344)
     )

;;; 71 prime --------------------------------------------------------------------------------
(vector 71 12.609085083008 (fv 0 1 0 1 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 0)

     10.523064 (fv 0.000000 0.688011 0.968837 0.940634 1.605222 0.888784 0.799658 0.986589 0.551066 0.615309 0.653186 0.893971 1.635005 0.515944 0.737309 0.499869 0.965484 1.166543 1.233403 1.277963 0.357632 0.184373 0.829321 0.533549 0.654127 1.345320 0.132782 0.366320 0.049851 1.315507 0.714178 1.332359 1.090257 0.069099 0.561445 1.760121 1.667327 0.986854 0.112329 0.614048 1.104774 0.212197 1.392955 0.553988 0.863015 1.668891 1.231650 0.232935 1.786061 0.865166 0.966113 0.257005 0.993747 -0.000704 1.235807 0.060112 1.258818 1.073792 0.276968 0.278092 1.838200 0.920318 1.799026 1.603861 0.357301 0.246709 0.264914 0.955910 0.731514 1.325161 1.347000)
     )

;;; 72 prime --------------------------------------------------------------------------------
(vector 72 12.708446502686 (fv 0 0 1 0 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 1)

     10.579571 (fv 0.000000 1.526666 1.114036 -0.188699 1.569783 1.061483 1.461941 0.746029 1.509803 1.264040 0.039120 0.005480 1.670375 0.087176 1.602839 1.411297 1.630968 0.248800 0.070549 1.021733 -0.228089 1.869979 1.152734 0.098898 0.604652 0.265485 1.435929 0.170559 0.737250 0.104974 0.731428 1.774793 1.550528 -0.147974 1.870001 1.248377 1.256893 0.177185 1.205217 1.218210 1.654506 -0.048160 1.262662 0.659765 1.099483 0.193101 1.327235 0.693549 1.139270 0.170053 0.767850 1.284172 -0.044820 1.663616 1.015434 0.890883 1.694823 0.554893 0.622406 0.662793 0.328828 0.995738 1.236624 0.150517 1.587539 1.302619 0.103369 0.398303 0.131685 0.921928 1.168883 0.112924)
     )

;;; 73 prime --------------------------------------------------------------------------------
(vector 73 12.877750118249 (fv 0 1 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0)

     10.737656 (fv 0.000000 0.602102 0.352641 0.632006 1.552371 0.296077 1.082110 0.013914 1.761810 0.456416 0.737747 0.295270 1.253093 0.753406 0.547256 0.051955 1.746228 0.377469 0.418110 0.901371 0.231886 1.499847 1.247926 1.681473 1.281726 0.414399 -0.025093 0.354821 1.545561 1.180195 1.073840 1.640054 1.311359 1.388818 1.571352 1.435069 -0.082478 0.162069 0.705649 -0.084633 0.587089 0.167800 -0.063043 0.159333 0.913473 1.004072 1.669680 0.741708 1.378872 1.360081 0.270841 1.349751 1.013148 0.450718 0.226120 0.098676 0.779207 1.870363 0.442457 1.048600 1.409639 0.334422 1.713108 0.607567 1.451973 0.551597 1.404406 0.821452 1.414792 0.265647 0.470100 0.101296 1.610504)

     ;; 72+1
     10.689130 (fv 0.000000 1.525750 1.157802 -0.130495 1.566135 1.068083 1.436324 0.699061 1.496431 1.345845 -0.045471 -0.032146 1.656974 0.163846 1.519166 1.394757 1.503557 0.183007 0.248242 1.068642 -0.134987 1.855031 1.116717 -0.022218 0.511499 0.347386 1.347662 0.149072 0.778251 0.082394 0.706357 1.835299 1.598933 -0.137332 1.800937 1.334976 1.258225 0.107942 1.165982 1.097698 1.720927 -0.060245 1.266550 0.522159 1.151393 0.179388 1.306382 0.759803 1.190783 0.160999 0.709993 1.280967 -0.169862 1.562918 1.019413 0.839429 1.731380 0.566096 0.647229 0.704371 0.329975 1.072857 1.320759 0.275029 1.479112 1.297543 0.103782 0.366305 0.194503 1.011614 1.086013 0.243622 -0.036669)
     )

;;; 74 prime --------------------------------------------------------------------------------
(vector 74 13.115156173706 (fv 0 1 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 1)

     10.649887 (fv 0.000000 0.311188 1.290942 0.614169 0.538966 0.384100 0.109850 0.021551 0.798332 1.375278 0.593955 1.270048 0.158912 1.156782 1.030374 0.821590 0.254106 0.736652 -0.160646 1.527962 0.008622 1.070061 1.131441 1.654723 1.927687 1.286729 -0.139272 1.540344 0.234722 1.262327 0.958913 0.415825 0.099669 0.142462 -0.047631 -0.219606 0.497897 0.164613 1.298918 -0.030959 0.077929 0.023069 -0.048674 1.490524 1.421741 1.027040 1.916604 1.756080 0.253777 0.507377 0.665062 0.691819 1.450238 1.738862 1.010067 1.810972 1.515691 0.044783 0.082536 1.267984 0.419709 0.481882 1.832483 1.839130 0.674123 0.733681 1.236692 0.099256 1.206529 1.152388 -0.150515 0.755739 -0.177039 0.279539)
     )

;;; 75 prime --------------------------------------------------------------------------------
(vector 75 13.254356384277 (fv 0 0 0 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 1 0 1 1)

     11.022299 (fv 0.000000 0.351470 1.008124 1.291533 1.352523 1.219130 1.555492 -0.093523 0.793123 1.710126 0.845582 1.377487 0.007190 1.144398 0.030789 1.388046 0.801302 1.006307 1.228947 1.174967 0.712656 1.235684 0.437185 1.685920 1.628311 0.432535 1.406407 0.211487 1.631733 1.309990 0.088839 1.823347 0.645147 0.984102 0.938592 0.791055 1.200055 1.653923 1.369127 1.660169 1.684809 1.277014 1.423374 1.618705 1.761213 0.185242 0.737016 0.819843 1.700256 1.790111 1.582839 0.397943 0.430644 0.413691 1.861593 0.597392 0.781277 0.169222 1.035252 0.907321 0.225899 -0.109171 1.673244 0.994007 0.840763 0.321135 1.684359 1.522767 0.808080 0.918598 -0.016940 0.115899 0.890010 0.043957 1.335248)

     ;; 74+1
     10.845278 (fv 0.000000 0.303549 1.218741 0.552551 0.569127 0.472240 0.245073 0.036162 0.777257 1.317108 0.637687 1.223165 0.113140 1.175025 0.935816 0.812633 0.204261 0.775370 -0.063348 1.606612 -0.062866 1.039670 1.212702 1.714844 1.899468 1.335566 -0.020119 1.590425 0.290190 1.193213 1.001576 0.516379 0.026311 0.170930 -0.096650 -0.315084 0.554428 0.144183 1.271300 0.005031 0.147859 0.041442 -0.048782 1.533805 1.480719 1.134329 1.851707 1.704199 0.286268 0.581546 0.690124 0.731502 1.497188 1.734408 1.013517 -0.010349 1.506433 0.024492 0.040181 1.200857 0.486442 0.422051 1.858040 1.837071 0.586958 0.629092 1.226159 0.139529 1.240473 1.272372 -0.245955 0.719958 -0.223615 0.281302 0.252047)
     )

;;; 76 prime --------------------------------------------------------------------------------
(vector 76 13.288178191792 (fv 0 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1)

     11.052689 (fv 0.000000 1.173531 0.914653 0.927606 1.833325 0.572990 1.228121 1.340974 0.777818 0.101179 0.922381 0.727758 0.848668 1.622591 0.600587 1.207357 0.483679 -0.135739 0.789693 0.557916 0.529588 0.315324 1.810649 0.126643 0.909249 1.640326 1.342327 -0.052236 0.755820 1.799623 0.462177 -0.288032 0.651075 1.169254 1.824988 0.704237 0.880995 1.859829 0.036089 0.149448 0.542052 0.160045 1.646079 0.860838 1.752249 1.025660 0.604221 0.046575 0.711402 1.553525 1.214111 0.036075 0.479955 0.029596 1.070090 1.208893 1.207610 0.470868 0.758081 1.507527 0.678107 0.675805 1.580182 1.324295 0.061587 0.955350 1.218409 1.880195 0.596793 0.165057 0.646006 0.454851 -0.080576 1.833376 0.764382 0.602862)

     ;; 75+1
     10.919127 (fv 0.000000 0.249051 1.283752 0.578538 0.465889 0.328282 0.397520 0.048700 0.732044 1.506763 0.870470 1.024466 0.125905 1.199969 1.200490 0.828996 0.327349 0.743916 -0.083081 1.581866 -0.022026 1.010771 1.314126 1.641110 1.977207 1.418126 -0.002727 1.553515 0.292061 1.103162 1.068475 0.567360 0.089633 0.183619 -0.243814 -0.246117 0.459882 0.118225 1.182209 0.017390 0.042772 0.114593 -0.081235 1.493721 1.405420 1.147867 1.909741 1.653034 0.237976 0.515913 0.601555 0.768092 1.451311 1.697940 1.055226 -0.095470 1.438708 0.052821 -0.122724 1.275935 0.441115 0.338376 1.822506 1.852761 0.555244 0.752898 1.362553 0.167682 1.066534 1.298923 -0.414288 0.895495 -0.078589 0.121695 0.415788 -0.032714)
     )

;;; 77 prime --------------------------------------------------------------------------------
(vector 77 13.158900260925 (fv 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1 1)

     10.802937 (fv 0.000000 1.170348 0.872365 1.938370 0.176318 1.425001 1.816351 0.600885 0.838206 0.617008 0.862854 1.459906 1.685266 -0.294339 0.340282 0.188975 1.272363 0.222263 0.754500 0.303643 1.420294 0.520239 1.223316 1.153660 0.209190 1.335123 1.331714 0.719154 0.909245 -0.009852 0.827474 -0.139034 0.531790 0.623898 0.587466 0.935238 0.452213 -0.149439 0.923750 0.885640 -0.429219 0.037445 0.354080 0.150061 0.302072 1.423031 0.130250 -0.009435 0.571653 0.410660 0.194501 1.802956 0.455392 0.509514 1.619972 1.373513 1.082720 1.024058 0.798330 0.005055 0.529388 0.193199 0.652877 0.658529 1.505933 1.232728 0.171053 1.366924 1.004855 0.355582 1.506276 0.574068 1.502183 1.005869 -0.239104 1.730993 -0.006156)
     )

;;; 78 prime --------------------------------------------------------------------------------
(vector 78 13.498236182018 (fv 0 0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 0 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1)

     11.128810 (fv 0.000000 1.556151 1.350766 1.079560 1.627456 1.824396 0.970239 1.719188 0.076491 0.356551 0.956437 1.450393 1.649467 1.028644 0.913293 0.244507 0.114759 1.070289 1.644113 1.454817 0.980418 0.918084 0.619510 1.767585 1.807117 0.656270 1.762010 0.672983 0.042023 -0.071247 0.983492 -0.081135 0.135693 0.114828 1.357805 -0.252941 1.850579 1.671928 0.257832 0.920719 0.631282 0.706947 1.321680 1.346893 -0.182371 -0.272451 0.054087 1.657623 0.055118 0.350677 1.314600 0.063294 0.902678 0.105522 1.670846 0.405032 -0.075578 -0.012369 -0.068016 1.298918 0.818077 -0.266776 0.759067 0.508057 -0.040066 1.459059 0.532881 1.133191 1.019843 -0.486096 1.086169 0.894532 1.300427 1.601490 0.616399 1.768752 1.000095 1.636458)

     ;; 77+1
     11.104393 (fv 0.000000 1.124037 0.854979 1.945811 0.208140 1.468398 1.815990 0.611918 0.912844 0.730140 0.961369 1.376309 1.803559 -0.243021 0.398976 0.193476 1.338837 0.340346 0.793855 0.341671 1.410779 0.565778 1.176931 1.048390 0.277106 1.445162 1.185150 0.642492 0.933385 0.019030 0.859542 -0.113411 0.532157 0.598476 0.550518 0.931780 0.311264 -0.108835 0.867767 0.932278 -0.351004 0.021213 0.390636 0.076987 0.338139 1.457487 0.082705 1.889708 0.513158 0.413795 0.138548 1.809057 0.494899 0.552125 1.690745 1.358244 1.250637 0.989495 0.775385 1.847135 0.528873 0.242941 0.558866 0.669472 1.484739 1.334473 0.249966 1.409992 1.022049 0.346238 1.534652 0.641930 1.394789 0.932978 -0.210333 1.769933 -0.083609 -0.106856)
     )

;;; 79 prime --------------------------------------------------------------------------------
(vector 79 13.178678233398 (fv 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 1 0 1)

     11.177833 (fv 0.000000 1.310798 1.470398 1.323367 0.553981 1.135824 0.783258 1.090444 0.524280 1.788975 1.639185 0.764585 0.676397 1.561727 -0.046007 0.428923 1.763449 0.011640 0.636361 1.341212 0.004579 1.608860 0.575061 0.243266 0.907181 0.977184 1.726699 0.431482 0.140827 0.464141 1.057140 1.400168 0.289408 0.838151 1.631807 1.530460 1.501458 0.566438 1.487014 0.015110 1.680036 1.296993 1.364424 0.039821 1.528230 0.589464 0.715462 0.552663 -0.017058 1.149326 1.516482 -0.030051 0.582733 -0.149911 0.234725 0.517539 1.013720 0.964483 -0.295150 -0.068887 -0.069035 1.472439 0.368231 1.600803 0.316013 0.723864 0.014324 0.524613 1.419685 1.673198 -0.043005 -0.029455 1.487321 1.686189 1.173017 1.833259 1.763911 1.426155 0.892867)
     )

;;; 80 prime --------------------------------------------------------------------------------
(vector 80 13.547472953796 (fv 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 1 0 1 0 1)

     11.451369 (fv 0.000000 -0.011188 0.391305 0.222144 0.025668 0.977359 0.513223 0.531901 0.360643 0.616841 1.341911 0.888846 1.600347 1.373974 0.123418 0.279769 -0.016126 0.463887 1.222914 1.957299 0.569052 1.699668 0.580517 1.202146 1.407428 1.172831 0.507495 0.800333 0.267556 -0.108002 1.745992 0.435164 1.044228 1.843822 0.030677 1.871048 0.542929 1.649600 0.514183 1.864352 0.330625 0.131744 0.409433 0.986423 1.602974 0.780283 0.138004 1.178452 0.747173 1.116954 0.917346 0.796903 0.356061 1.164738 0.640385 1.216938 0.366648 0.258624 0.900284 0.041536 1.817962 1.403113 1.192348 0.700576 1.370480 0.286847 0.603480 0.172807 1.255252 0.148259 1.272121 0.592895 1.744785 0.951797 1.489669 1.384870 1.365248 1.727217 1.576364 1.630892)

     ;; 79+1
     11.248369 (fv 0.000000 1.320660 1.562587 1.230907 0.791500 1.111831 0.776332 1.212269 0.471199 1.929248 1.797736 0.814341 0.620835 1.395121 -0.166860 0.291055 1.737100 0.070444 0.531137 1.293083 0.075352 1.711864 0.539841 0.274514 0.922582 0.992421 1.608388 0.391268 0.216699 0.537576 0.886521 1.411196 0.301396 0.827503 1.619143 1.601542 1.558307 0.639158 1.445488 -0.167072 1.736837 1.279584 1.414784 0.077225 1.537483 0.689000 0.730293 0.519349 -0.104713 1.140696 1.722734 -0.057361 0.493518 -0.183111 0.352303 0.572659 0.917617 1.016232 -0.317574 -0.040058 -0.065357 1.491653 0.416263 1.654521 0.241001 0.536870 0.065165 0.568896 1.612372 1.840754 0.054958 0.057425 1.377368 1.668931 1.097005 1.763836 1.887359 1.244817 0.894926 -0.107373)
     )

;;; 81 prime --------------------------------------------------------------------------------
(vector 81 13.652944564819 (fv 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 1)

     11.500874 (fv 0.000000 0.060156 1.198187 0.010810 -0.059627 1.336892 0.174682 0.177182 0.303039 0.507728 0.174616 0.162104 0.767672 0.283268 0.740356 1.244073 0.411651 0.771082 0.597722 1.646364 0.130092 1.399674 1.196320 1.542256 1.814795 0.969378 1.368552 0.008802 1.647015 1.538679 0.957584 0.562757 0.185463 0.612441 1.264483 1.129777 -0.291833 0.231345 1.808426 -0.095607 1.827790 0.807634 0.929515 0.025793 1.640598 1.271614 1.470525 0.036943 0.657753 0.872430 1.519719 0.128077 0.109048 0.492656 -0.089269 0.591629 -0.109776 0.882829 0.675418 0.557752 1.879709 0.050861 1.363712 1.313213 0.120759 0.673965 0.894225 1.390640 -0.198915 1.435867 0.650146 0.682721 0.919339 1.509191 0.176654 0.428794 0.550059 1.279511 0.067206 1.270072 0.509792)

     ;; 80+1
     11.318789 (fv 0.000000 1.312875 1.595991 1.250300 0.860994 1.125394 0.798611 1.212371 0.450471 1.878426 1.854513 0.914795 0.516574 1.401974 -0.113348 0.191503 1.535380 0.090102 0.579969 1.358286 0.094046 1.749820 0.409421 0.342346 0.891748 1.034938 1.701846 0.411592 0.161183 0.550475 0.945261 1.433769 0.390250 0.782945 1.725670 1.526810 1.626189 0.651868 1.370885 -0.153655 1.876481 1.236862 1.409437 0.102929 1.494796 0.718278 0.752798 0.534726 -0.125235 1.053652 1.624242 -0.009527 0.513674 -0.193412 0.274147 0.590252 0.888478 1.001277 -0.294725 -0.017970 0.022617 1.502755 0.474472 1.669991 0.292823 0.423633 -0.068585 0.472411 1.717891 1.789153 0.120369 -0.013158 1.253256 1.671744 1.049132 1.799303 1.831390 1.289936 0.966946 -0.056458 0.096803)
     )

;;; 82 prime --------------------------------------------------------------------------------
(vector 82 14.126787045134 (fv 0 1 0 1 1 1 1 0 0 0 1 1 1 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0)

     11.462533 (fv 0.000000 1.174537 -0.036810 1.449073 0.002634 1.412064 0.527823 1.690777 0.901678 -0.091711 1.027422 0.397477 1.526657 0.088004 0.143741 1.426347 1.215238 1.051627 0.132305 0.242096 1.932884 0.204037 1.515523 0.068047 0.117753 1.158626 0.459284 1.081363 0.079849 0.326802 0.035989 0.012387 0.861938 0.605551 1.407324 0.411725 0.979703 0.090881 0.271335 0.152506 0.410872 1.149930 0.566324 1.611304 1.416641 0.010695 1.743925 0.323768 0.693725 0.691039 0.186118 0.191067 0.629603 -0.034867 0.109309 0.522152 1.478755 1.337464 1.245454 -0.020762 0.796712 1.449381 1.763960 0.000713 0.577015 1.247460 1.754051 1.376869 0.724941 0.407841 1.068454 1.226119 0.726352 1.657000 0.543820 1.177669 0.881363 0.120220 0.019239 0.418519 0.727327 0.208388)

     ;; 81+1
     11.476728 (fv 0.000000 1.354025 1.769404 1.190492 0.845403 1.129164 0.681502 1.298591 0.526568 1.843796 1.839481 0.929391 0.545970 1.407502 -0.189236 0.155330 1.457831 0.110325 0.689064 1.222186 0.140271 1.863572 0.397423 0.425505 0.924253 1.034491 1.746896 0.221413 0.062871 0.570198 0.961166 1.514028 0.333971 0.850400 1.784003 1.484569 1.642647 0.680600 1.387654 -0.169385 1.868168 1.192895 1.317483 0.057642 1.550333 0.713537 0.826588 0.568782 -0.116091 1.031193 1.647713 0.076692 0.476679 -0.258739 0.325137 0.519423 0.928625 1.015174 -0.230419 -0.032172 0.037533 1.492936 0.495027 1.663321 0.378454 0.435791 -0.107582 0.529403 1.716992 1.827784 0.057964 -0.044990 1.256674 1.627386 1.007381 1.757651 1.738780 1.265746 1.051412 0.004277 0.076991 0.034105)

     ;; 83-1
     11.480416 (fv 0.000000 0.454164 1.374754 0.722227 0.986349 1.377355 1.172894 0.123589 1.410636 1.726879 1.302862 1.602018 1.474058 1.472070 0.412168 1.770446 1.982011 1.625710 0.940561 0.534669 0.102735 0.053883 0.631657 1.350304 0.393669 0.521507 -0.049446 0.629634 1.041110 1.379158 -0.156331 1.690517 0.010013 1.800842 0.947691 1.681261 1.009361 1.763476 0.941228 1.218725 1.847726 0.614247 1.223796 0.150627 0.820237 0.298534 1.321472 0.537094 1.742045 0.701084 0.211813 0.587227 0.340134 0.598492 1.566318 1.525148 0.920822 1.421639 1.608617 0.590851 0.062396 0.476310 0.647458 0.340763 1.923701 0.385843 0.256835 1.446458 1.741785 0.470072 1.939455 0.907485 0.836540 0.652790 1.796743 1.327810 0.106788 1.646107 1.364400 0.210392 0.634295 1.443213)
     )

;;; 83 prime --------------------------------------------------------------------------------
(vector 83 14.019070339131 (fv 0 1 1 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1)

     11.495305 (fv 0.000000 0.489724 1.459665 0.744876 0.880930 1.487259 1.179525 0.143969 1.398705 1.711637 1.229644 1.599300 1.480153 1.405136 0.390934 1.640936 1.928348 1.588509 0.860260 0.449815 0.093357 1.993956 0.692831 1.455573 0.371844 0.551569 -0.014841 0.652289 1.000821 1.372208 -0.157122 1.697110 0.020676 1.736939 1.000046 1.712927 0.862704 1.740081 0.913067 1.344458 1.894797 0.629049 1.175321 0.159464 0.992773 0.367516 1.362985 0.576721 1.753109 0.776625 0.227603 0.452205 0.315264 0.636900 1.541376 1.554828 0.983967 1.431020 1.527430 0.561443 -0.018728 0.579720 0.634527 0.252657 1.931947 0.472631 0.403447 1.506115 1.700022 0.443875 1.857223 0.863365 0.830784 0.658374 1.791596 1.216322 0.200510 1.645886 1.544611 0.129139 0.651447 1.366065 0.329410)
     )

;;; 84 prime --------------------------------------------------------------------------------
(vector 84 14.024940956301 (fv 0 1 0 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 0 1 1 1 0)

     11.536851 (fv 0.000000 1.288171 1.222912 1.421316 0.994256 1.309106 0.862461 -0.365885 -0.460542 0.530989 0.804830 1.140139 0.788715 0.769440 0.941320 -0.061500 1.897753 1.285116 0.647118 0.948482 1.478812 1.645309 -0.360540 1.475165 0.480180 0.398442 1.131834 0.453887 0.828958 0.223971 1.033478 0.103677 1.715711 0.595485 0.422094 0.246530 1.081093 0.706350 0.534924 0.737096 0.520740 1.348231 0.027898 1.430351 0.071366 0.456025 1.024992 0.563780 1.148663 1.244878 0.023430 1.078768 -0.035007 1.108834 0.481954 -0.628990 0.715248 0.675907 1.709977 0.563135 1.037605 0.888801 0.556599 0.958729 0.571715 1.126122 -0.072129 1.378438 0.187340 0.783805 0.989989 0.112073 -0.183972 1.388719 1.544777 0.651714 0.568338 1.234814 0.056527 0.901152 1.674263 0.800528 0.192396 0.655541)
     )

;;; 85 prime --------------------------------------------------------------------------------
(vector 85 14.253310943921 (fv 0 0 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 0 0 0 1 0 1)

     11.588928 (fv 0.000000 0.051144 0.232251 1.722677 0.580164 1.682133 1.175152 1.551429 1.040385 1.746433 0.629958 1.774843 0.701195 0.931344 1.300787 -0.092863 1.300643 1.259885 1.530011 1.258206 1.393028 0.930782 0.485840 1.244517 -0.032618 0.062247 0.154622 1.065009 0.904299 1.262092 0.852812 0.408235 0.633914 1.770716 1.085864 1.265219 1.003699 1.255985 1.195701 1.382932 0.704891 0.246143 0.639193 1.457010 0.146909 1.982729 0.165366 1.294717 0.624758 1.669440 0.868773 0.953753 0.230896 0.915079 -0.212743 0.773612 0.218470 1.122339 1.601419 1.730078 1.474786 -0.488722 1.796889 1.514239 1.703114 -0.437786 0.743917 1.859124 1.287147 1.160254 0.159597 0.817545 1.148746 -0.204270 1.716652 0.382598 -0.057580 0.598631 0.343212 0.230053 1.103741 1.603024 0.720362 -0.247891 -0.077598)
     )

;;; 86 prime --------------------------------------------------------------------------------
(vector 86 14.017106967247 (fv 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1)

	11.517897 (fv 0.000000 1.259153 0.753054 1.764686 1.049517 1.125067 1.190973 0.991011 1.742456 0.708907 0.178161 0.559310 1.128716 0.240782 0.729992 0.303371 0.569838 1.273658 0.861674 0.290602 0.694623 0.362989 0.243116 1.696103 0.326714 1.481176 0.105867 1.763155 0.389638 1.096089 1.860461 0.384795 1.595111 0.327309 0.224303 1.457357 0.863276 1.221159 0.474861 0.148710 1.484645 1.778010 1.802629 1.714822 1.122256 0.709074 0.540633 -0.317254 0.997156 1.115917 0.123376 1.869025 1.339712 0.876345 1.682733 0.893530 0.998209 1.642978 1.224902 0.836368 1.948885 0.464451 1.058190 1.080864 1.538683 1.521142 0.009248 0.654339 -0.126350 0.282369 0.636445 1.771914 0.323435 1.302976 0.483884 1.466774 1.898584 0.571020 1.479654 0.824385 0.735539 0.638514 1.340179 1.302713 1.869702 1.497079)
     )

;;; 87 prime --------------------------------------------------------------------------------
(vector 87 13.98394199918 (fv 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 0)

	11.888688 (fv 0.000000 0.482398 1.227138 1.272721 0.078687 1.831113 1.162310 1.536977 1.689231 0.888900 -0.147273 1.167875 0.136674 0.075484 0.629027 1.034119 0.307327 0.024754 1.634526 1.779718 -0.119653 0.312698 0.930420 1.385321 1.107173 1.761414 0.822994 0.223996 0.948219 0.050573 1.181566 -0.076310 1.414999 0.950580 1.442020 0.563152 0.962072 1.833788 0.503591 1.266688 1.037104 0.455604 0.146748 1.270845 0.375842 1.270415 0.973599 0.773789 1.316233 0.694384 1.909797 0.637408 1.683609 1.640242 0.084358 0.069276 0.823261 1.794579 0.489470 1.507812 0.467715 1.270885 1.378929 1.892053 0.446100 1.349825 1.591977 0.875580 1.281794 0.089884 0.566164 1.762552 1.251149 0.938610 1.580460 1.542270 0.684665 0.182715 1.926062 0.347598 0.716836 1.752700 1.597850 1.520331 1.622999 0.031320 1.757914)

	;; 86 + 1
	11.612976 (fv 0.000000 1.296504 0.726706 1.718822 1.046681 1.126904 1.153426 0.940241 1.708793 0.818644 0.107576 0.530980 1.122499 0.334577 0.735679 0.325192 0.616360 1.132997 0.845995 0.287311 0.640223 0.397260 0.270000 1.691583 0.368381 1.503691 0.176791 1.719860 0.415279 1.070108 1.956631 0.329587 1.654694 0.271910 0.194847 1.468802 0.897532 1.267673 0.483007 0.130123 1.446495 1.802533 1.802082 1.708319 1.123221 0.822012 0.552025 -0.324423 0.903301 1.074684 0.198879 1.961955 1.280447 0.787297 1.695626 0.996555 1.020892 1.595011 1.302967 0.813723 1.889725 0.419999 1.093466 1.051442 1.549928 1.587010 -0.012516 0.597662 -0.094834 0.261495 0.632231 1.919100 0.281141 1.272306 0.493568 1.244869 1.877721 0.661378 1.459138 0.814695 0.650143 0.614249 1.318253 1.365141 1.852338 1.532615 -0.014292)
     )

;;; 88 prime --------------------------------------------------------------------------------
(vector 88 14.825139803345 (fv 0 0 0 0 1 0 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0)

     11.988941 (fv 0.000000 0.784577 0.582655 -0.034103 0.163974 0.329543 0.693568 0.791635 0.508446 0.396915 1.248395 0.826252 1.437835 1.346260 1.098554 0.836111 0.285181 0.833650 0.396981 0.462954 0.362450 1.183096 1.004262 0.908804 0.301743 1.532670 0.011752 -0.072123 0.996811 1.778401 0.688894 0.044599 0.465473 0.579840 0.996613 0.177680 1.437542 0.677747 1.616279 0.045690 0.566144 1.136899 0.636783 0.355278 1.821475 1.658271 1.588631 1.539506 1.624123 1.239000 1.605890 0.921379 1.791768 0.223451 1.057625 1.753981 0.669208 1.245749 0.682902 0.319986 0.831757 1.041603 0.551747 0.279645 1.731984 0.406762 1.759751 -0.021178 1.248606 0.309853 0.756421 0.658187 1.127576 -0.365423 1.909061 0.823437 1.017441 0.941761 1.686220 0.570407 1.741961 1.705746 1.303576 0.477079 0.894393 0.214957 1.446786 0.714971)

     ;; 87+1
     11.814735 (fv 0.000000 1.368148 0.691154 1.687498 1.039684 1.203556 1.189736 1.006697 1.714307 0.763256 0.064985 0.571039 1.207048 0.283865 0.790295 0.371929 0.626841 1.136922 0.897180 0.250579 0.703180 0.367153 0.285039 1.638464 0.403793 1.574680 0.178418 1.768394 0.361495 1.131365 1.971622 0.329290 1.677397 0.231014 0.189969 1.483487 0.936641 1.267305 0.514462 0.133317 1.438805 1.804423 1.766680 1.772823 1.080035 0.819063 0.520465 -0.385910 0.897901 1.088041 0.197160 0.026953 1.297496 0.779688 1.684839 1.075719 1.000862 1.653028 1.332924 0.886650 1.939949 0.418280 1.124021 1.085155 1.563576 1.537898 -0.095926 0.685710 -0.089908 0.297752 0.611005 1.863915 0.336806 1.344864 0.522590 1.267887 1.872098 0.632836 1.388439 0.783559 0.644197 0.609366 1.338438 1.322505 1.876261 1.537568 -0.063978 -0.021791)
     )

;;; 89 prime --------------------------------------------------------------------------------
(vector 89 14.69031483888 (fv 0 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 0 1 1 1)

	12.145572 (fv 0.000000 0.358269 1.288170 -0.001864 0.867779 1.364244 1.109375 1.164634 -0.016236 -0.166115 0.449176 1.706240 1.833933 -0.037127 1.772608 0.464339 0.514549 -0.440413 0.091904 1.161505 1.250171 0.825773 0.104691 1.330145 0.165858 0.782047 0.989298 1.471958 -1.844798 0.511831 1.629263 1.091421 0.075823 0.883705 0.737372 1.834115 1.253424 0.188184 -0.236434 0.698883 0.462924 1.137084 1.094253 1.071593 1.735305 1.138289 1.560372 0.992360 1.412813 1.873908 0.448635 -0.005058 0.329007 1.672360 0.604898 1.727995 0.648160 0.750281 0.125793 1.632855 1.581670 1.571564 1.278678 0.191912 0.145586 1.306040 0.445369 -0.231408 -0.001410 1.354497 1.551515 1.659096 -0.403896 0.821589 1.439452 1.005908 1.563170 1.260522 0.450255 1.234179 0.926658 0.279960 0.002426 1.200149 1.285451 0.986678 0.303114 1.568249 0.304851)

	;; 88+1
	11.787567 (fv 0.000000 1.314164 0.689513 1.628993 1.144940 1.224705 1.150205 1.016059 1.723195 0.713105 0.005841 0.484975 1.239550 0.341275 0.773786 0.398433 0.655094 1.170929 1.038464 0.301899 0.723090 0.410530 0.287119 1.633201 0.260609 1.623354 0.115980 1.879009 0.455545 1.070015 0.017172 0.270422 1.692490 0.233092 0.152980 1.556192 0.883089 1.261531 0.502559 0.146173 1.438907 1.785157 1.804773 1.715166 1.064977 0.807912 0.565628 -0.439659 0.842957 1.290534 0.179519 -0.023924 1.443203 0.792272 1.565433 1.032012 0.991867 1.644953 1.337404 0.854036 0.023578 0.413260 1.087165 1.065012 1.583652 1.496116 -0.065654 0.692422 -0.146363 0.297624 0.616209 1.798178 0.385485 1.334745 0.400370 1.168196 1.828136 0.707167 1.548668 0.793572 0.670466 0.690206 1.451727 1.295947 1.819151 1.442501 -0.262177 -0.013858 0.006952)
     )

;;; 90 prime --------------------------------------------------------------------------------
(vector 90 14.831111851861 (fv 0 1 1 0 1 0 0 0 0 0 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 1 1 1)

     12.022848 (fv 0.000000 0.304537 1.829033 1.070382 1.207038 0.596236 0.255424 0.517237 0.518037 0.555724 0.263998 -0.092809 0.086181 1.031798 1.764620 1.155127 1.629595 1.381762 0.374989 1.817825 0.178145 1.717460 -0.421617 0.620765 1.435692 1.136975 0.618586 -0.142602 0.257261 0.632270 1.492625 0.098530 0.089288 1.438957 0.096419 -0.388671 1.239417 1.591519 1.418382 0.224847 0.327382 1.847389 0.645292 1.057386 0.245292 0.974759 0.113802 0.520412 0.536708 1.166960 -0.123664 0.466667 1.597708 0.387840 1.876598 1.035063 1.402503 0.035393 0.945965 1.170137 1.338358 1.449697 1.072439 0.060883 1.296995 1.652836 0.462073 1.502645 1.166005 1.209720 0.739421 0.202107 1.382598 0.210680 0.451167 1.145693 0.222332 1.637533 0.245553 0.987799 0.980876 1.068255 -0.276826 -0.417000 1.573560 0.382232 0.604329 -0.155944 1.170763 0.979682)
     )

;;; 91 prime --------------------------------------------------------------------------------
(vector 91 14.702056847646 (fv 0 1 1 0 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0)

     12.084424 (fv 0.000000 1.661963 0.526933 0.737897 1.547408 1.147810 -0.075617 1.067829 0.852458 1.831985 1.111705 1.210703 0.536594 1.562730 1.564495 0.931257 1.183443 1.206159 1.917460 -0.142965 1.673803 1.211553 1.446589 0.613092 0.971147 0.710033 1.752892 1.683084 1.418254 1.337958 1.028503 0.530465 0.358051 0.607198 0.374767 1.422247 1.801820 -0.023693 0.571429 0.547868 -0.171993 -0.069230 0.452658 0.503964 0.822577 0.139237 1.564879 1.109027 0.054201 0.693725 1.047747 0.930670 0.524559 -1.746051 0.764531 1.459015 0.440040 0.505370 1.433135 1.753190 0.597210 0.403986 1.752023 0.224587 -0.006227 1.424459 1.006632 1.837329 0.717913 1.423544 0.374217 1.561701 0.508321 0.662754 0.466739 0.959175 1.632864 0.950048 1.612332 0.591280 -0.303047 1.088472 1.746777 0.350796 0.275475 0.538357 0.642430 0.726819 1.423969 -0.019252 0.614624)
     )

;;; 92 prime --------------------------------------------------------------------------------
(vector 92 14.556435035882 (fv 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 0 0 0 1 0 1 0 0 0)

     12.111629 (fv 0.000000 1.123677 1.203180 1.174948 1.560019 1.384341 0.367155 0.099459 1.212291 0.682305 1.716557 0.261123 0.730999 0.903465 1.369526 0.155486 0.590372 -0.569988 0.244209 0.083007 1.764474 0.389454 0.365639 1.245993 1.816418 0.730704 -0.475666 0.929928 1.528963 0.279291 0.611191 0.845099 1.029972 1.753120 1.126371 1.838017 0.163977 1.146545 0.659479 1.341785 0.566953 0.273863 0.527929 0.012905 1.508411 1.113794 0.790470 1.810888 0.619444 1.306005 1.764955 0.757522 1.532832 1.638004 1.292139 -0.220293 1.326791 0.207925 0.021426 0.636407 0.595067 0.920176 1.364542 1.317600 0.792553 1.523336 0.199497 1.310295 1.126679 1.660906 0.580494 1.441629 1.307014 -0.149187 1.422606 1.228427 0.874268 1.519111 1.056591 1.949465 -0.426058 1.208008 1.301151 1.521711 0.452094 0.671757 0.665097 0.498102 0.181724 0.953835 0.725167 1.124133)
     )

;;; 93 prime --------------------------------------------------------------------------------
(vector 93 14.994668960571 (fv 0 1 0 1 0 0 1 0 1 1 0 1 1 1 0 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1)

     12.323397 (fv 0.000000 0.199963 1.180724 -0.024343 1.226375 -0.402136 0.168523 1.313836 1.060714 1.370552 -0.471865 0.051393 1.826180 -0.226097 1.794079 0.176177 0.029279 1.765656 -0.022993 0.924413 1.319281 1.348871 0.657083 1.021102 0.556079 1.679658 0.119278 0.154784 0.786857 0.314106 1.909349 1.379970 0.486239 0.159940 1.547391 1.177792 0.671257 -0.176460 1.805002 1.892101 1.067471 1.153719 0.249337 0.426943 1.568658 0.284044 0.861446 -0.338286 0.531428 1.450755 0.605670 0.121121 1.131478 1.187561 1.041801 1.153378 1.486202 0.325760 0.201023 0.376157 0.907130 0.389618 0.779509 0.246617 0.355275 0.698575 1.371835 1.170196 1.188933 0.531048 0.008203 1.693556 0.426031 -0.330917 0.226068 0.478929 -0.022448 0.820583 0.181321 1.394112 0.214726 0.952096 1.780527 0.477402 0.370644 0.018381 1.506735 0.676340 -0.005190 1.098917 1.472044 0.136836 1.154585)

     ;; 92+1
     11.941773 (fv 0.000000 1.137688 1.089778 1.068356 1.532544 1.432457 0.360804 -0.026160 1.251592 0.723161 1.753475 0.321792 0.652597 0.831785 1.248203 0.098788 0.605754 -0.620144 0.303325 -0.047105 1.719165 0.369582 0.426774 1.169373 1.859324 0.741230 -0.571365 0.881904 1.545056 0.328084 0.606744 0.850606 0.996606 1.766597 1.046556 1.767688 0.237622 1.228793 0.632423 1.337245 0.542894 0.162245 0.534219 0.069759 1.516061 1.102446 0.948393 1.619738 0.549855 1.379503 1.785272 0.859611 1.503940 1.656139 1.246212 -0.223489 1.412206 0.325338 0.101699 0.705391 0.747074 0.979316 1.385520 1.241306 0.625921 1.535144 0.140376 1.223617 1.154594 1.635856 0.580110 1.431599 1.354268 -0.085341 1.513604 1.083083 0.960280 1.481804 1.049034 1.936911 -0.305123 1.144650 1.328494 1.401780 0.463677 0.612788 0.648525 0.589928 0.274669 0.913704 0.769534 1.048236 -0.031107)
     )

;;; 94 prime --------------------------------------------------------------------------------
(vector 94 14.811392756555 (fv 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0)

     12.372284 (fv 0.000000 0.443961 0.975468 0.665627 0.603420 0.053131 0.306985 1.398862 1.315822 1.027281 0.141353 0.068859 0.515109 1.551710 0.559483 1.154898 1.062171 1.088212 0.844250 0.492324 -0.085203 0.372997 1.377703 1.412362 1.590941 0.015253 -0.053671 1.084827 1.672259 1.823973 0.424632 1.792989 0.693404 1.273404 0.373397 1.282394 -0.222604 0.823730 1.821435 0.830056 0.905326 1.119027 0.338679 0.323132 1.572257 1.693368 1.617589 1.262068 1.377617 -0.071238 1.120960 0.924011 0.108375 0.409469 0.705856 1.358638 1.649735 1.159074 1.592832 0.679108 1.663652 1.223795 0.200633 -0.160917 1.201748 0.776569 0.821633 0.259058 0.902729 0.178012 1.711364 0.349704 0.758303 0.750335 0.936872 0.168192 0.485748 0.828259 1.367780 0.601135 0.970970 1.052074 1.846930 -0.031412 0.332694 1.027172 1.579686 0.520946 0.479472 0.979137 -0.124751 1.022187 0.809346 1.384445)

     ;; 93+1
     12.114932 (fv 0.000000 1.123175 1.150884 1.058343 1.465121 1.413282 0.350764 0.114071 1.226428 0.791079 1.790932 0.440109 0.565381 0.734544 1.327723 -0.001005 0.566798 -0.729477 0.316829 -0.017120 1.801895 0.389351 0.381914 1.198959 1.820572 0.721571 -0.570163 0.955754 1.536499 0.370558 0.593528 0.885066 1.037479 1.768525 1.105455 1.756351 0.226836 1.186245 0.651550 1.384674 0.494435 0.218370 0.473389 0.034709 1.487137 1.083964 0.911945 1.641974 0.559886 1.326260 1.842092 0.870886 1.399307 1.629693 1.284916 -0.226560 1.347506 0.289919 0.059989 0.740638 0.739763 0.950849 1.395859 1.190558 0.656884 1.519451 0.124394 1.191107 1.225318 1.686413 0.517977 1.395642 1.256343 -0.098747 1.532037 1.044403 0.978522 1.573287 0.994934 1.946711 -0.367453 1.259056 1.292220 1.531327 0.451283 0.592779 0.641359 0.711046 0.198007 0.990565 0.746192 1.039960 -0.062670 0.073205)
     )

;;; 95 prime --------------------------------------------------------------------------------
(vector 95 15.240 (fv 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 1 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1)
     
     12.459772 (fv 0.000000 0.308397 0.934622 0.587781 1.397996 1.615701 1.668964 1.492915 1.308563 0.159020 1.213403 -0.279408 1.096006 1.085558 0.623876 0.907176 0.667480 1.557434 1.743106 1.498468 1.233171 0.109361 0.947947 -0.262447 0.459131 0.819588 -0.021230 0.492364 0.906782 0.461816 0.056526 0.050587 0.383393 0.910532 0.762726 0.098762 0.955132 1.150421 0.604248 0.259751 1.309549 1.704622 1.855016 0.399458 0.217387 0.513436 1.433314 0.218651 0.133592 1.857292 0.423016 0.136928 0.083580 1.034506 1.391713 0.293770 0.897050 0.785540 0.765384 1.736279 0.958030 0.524446 0.709466 0.374572 1.361583 0.387916 0.039566 1.900932 -0.119192 0.460590 -0.150181 0.605728 1.448737 1.077599 1.714282 1.351134 0.667262 0.278426 0.183437 0.118876 0.258415 0.843668 0.748044 1.868376 0.252888 1.363041 0.638212 1.171836 0.388947 0.935784 0.020120 0.828215 -0.177354 1.862097 0.788220)

     ;; 94+1
     12.114676 (fv 0.000000 1.049345 1.220803 1.147373 1.381621 1.355515 0.454825 -0.009436 1.057569 0.663900 1.874811 0.433507 0.556807 0.623352 1.242792 0.067786 0.465225 -0.661340 0.331985 0.032227 1.933091 0.432343 0.547379 1.107124 1.846431 0.517946 -0.547570 0.897607 1.611921 0.403112 0.647511 0.899598 0.890804 1.716130 0.996200 1.713540 0.243854 1.180551 0.688999 1.559934 0.583466 0.197293 0.600073 0.000101 1.458490 0.994760 0.956495 1.648139 0.660393 1.228976 1.774516 0.893844 1.390831 1.720570 1.135089 -0.091470 1.277862 0.255881 0.036343 0.799886 0.761090 0.891306 1.295964 1.096543 0.475861 1.537136 0.091181 1.218377 1.140426 1.690539 0.527790 1.400945 1.266740 -0.072678 1.541904 1.035302 1.038433 1.493972 1.075712 0.036991 -0.268077 1.190854 1.324282 1.468048 0.376266 0.545926 0.611626 0.692246 0.190910 0.902204 0.677044 1.063647 0.021187 0.238133 0.189775)
     )

;;; 96 prime --------------------------------------------------------------------------------
(vector 96 15.135 (fv 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 0)

	12.492843 (fv 0.000000 0.873070 1.523025 1.689063 1.621286 0.209607 1.316613 0.108148 0.756280 0.640008 0.419483 0.710721 0.117557 0.928853 0.153806 1.300975 1.239985 1.289571 0.156284 0.662086 0.349173 1.208328 1.779199 0.633972 1.299682 1.009543 0.022986 0.835814 1.094725 0.331638 0.023179 0.982537 0.733828 1.430422 0.013874 0.572853 1.429326 1.360223 0.715744 1.266448 0.151948 -0.250137 0.209445 1.031335 1.611402 0.877878 0.362241 0.304460 0.144893 0.651630 1.742329 -0.323477 0.366805 -0.060410 1.858308 0.038329 0.825659 1.544770 1.420995 1.255395 1.068254 0.786905 1.057541 1.015027 0.909813 1.295370 1.205379 0.957770 1.601794 1.221780 -0.114116 0.749254 1.369402 1.509613 0.642078 1.929687 1.163562 0.908511 0.510199 1.519292 0.122002 1.225494 0.717297 1.501496 1.345341 1.759811 1.056238 0.842883 0.086174 -0.090366 1.445692 1.226504 0.003120 1.148302 0.440021 0.622101)

	;; 95+1:
	12.292710 (fv 0.000000 0.988646 1.162429 1.171314 1.353255 1.405759 0.327802 0.036207 1.152154 0.760541 1.790856 0.433527 0.499858 0.656756 1.296573 0.100791 0.476489 -0.653216 0.158372 -0.037710 1.892726 0.409386 0.436140 1.049351 1.766476 0.708019 -0.505881 0.843836 1.661627 0.229932 0.569810 0.855526 0.889991 1.754840 1.079009 1.690629 0.282542 1.176826 0.695771 1.456983 0.462708 0.168189 0.469857 -0.027597 1.521311 1.099282 0.982686 1.576751 0.669770 1.287335 1.818933 0.859497 1.442403 1.798895 1.290873 -0.254434 1.216440 0.266504 0.064071 0.816920 0.860902 0.922870 1.417663 1.159681 0.595958 1.424400 0.223626 1.172296 1.139585 1.606147 0.520047 1.392856 1.257846 -0.113917 1.518583 1.050121 0.979442 1.573289 0.984941 0.063610 -0.290095 1.277068 1.272139 1.596596 0.361931 0.600022 0.601776 0.740696 0.153344 0.997841 0.670149 1.019583 -0.020870 0.222109 0.072606 -0.120463)
     )

;;; 97 prime --------------------------------------------------------------------------------
(vector 97 15.404807595571 (fv 0 0 0 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1)     

	12.614880 (fv 0.000000 1.284279 0.149066 0.562607 0.268625 0.641221 0.361525 0.485960 -0.169882 0.664945 1.289316 0.500133 0.276653 0.768466 1.755836 1.046199 1.488691 0.489610 1.701223 1.395902 0.323258 1.026098 0.187307 0.308257 0.739745 0.789576 0.492878 1.589801 0.464866 1.368873 1.280528 0.783754 1.321490 0.013196 1.554947 1.672951 1.438390 1.698792 0.240337 1.015821 1.431743 -0.194791 0.030419 0.391715 0.797023 1.035054 1.666367 1.927621 0.564941 0.590092 0.408995 0.415222 1.147686 0.588418 0.024767 -0.204650 -0.157255 1.351342 1.609704 0.733349 1.898358 0.761937 1.674424 1.298247 0.616295 1.801868 0.366757 0.227606 0.881755 0.435048 0.566914 -0.068726 1.464351 0.867461 0.114711 1.507714 0.831540 0.049432 0.189086 0.282295 1.125245 -0.244779 0.442202 1.591355 -0.090711 1.248227 1.649885 0.616280 1.727109 0.815894 0.698498 -0.049477 0.179382 1.436511 0.773196 0.738555 0.962998)

	;; 96+1
	12.398175 (fv 0.000000 0.974270 1.133417 1.101751 1.279979 1.359434 0.467927 0.007144 1.127487 0.748820 1.781756 0.396487 0.493733 0.688975 1.203401 0.019970 0.359263 -0.697201 0.166440 -0.073865 1.841340 0.479438 0.471569 1.120468 1.818011 0.722611 -0.578854 0.797365 1.619794 0.192675 0.470320 0.880530 0.894647 1.773867 1.129911 1.684306 0.298114 1.192448 0.753562 1.463120 0.415850 0.230519 0.523840 -0.047429 1.497367 1.045637 0.968082 1.645436 0.623475 1.314407 1.792633 0.841218 1.383624 1.923347 1.362714 -0.210443 1.197651 0.311815 0.117464 0.802332 0.840490 0.962756 1.351153 1.154240 0.658169 1.483444 0.257624 1.139948 1.196778 1.594898 0.489729 1.391360 1.298495 -0.114146 1.474319 1.038981 0.962592 1.548377 0.947581 0.030073 -0.290725 1.335845 1.310097 1.567936 0.325931 0.520450 0.493969 0.704044 0.140441 0.974535 0.754580 0.981153 0.043144 0.213245 0.187923 -0.104791 0.154449)
     )

;;; 98 prime --------------------------------------------------------------------------------
(vector 98 15.435913738557 (fv 0 0 0 0 1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0)

	12.753270 (fv 0.000000 0.786132 0.095307 1.867898 0.883791 1.021595 1.308123 1.131908 0.540702 0.504302 1.434468 1.493630 0.417411 0.284692 1.504062 1.429716 1.676581 -0.039254 0.683934 0.973509 0.648393 1.434613 -0.061544 1.814076 0.647769 0.683085 1.793781 0.237679 0.776690 1.663998 0.170625 1.433546 1.041819 1.122171 1.897558 1.320541 0.723949 1.237497 0.689348 1.846291 1.246028 1.446201 0.606616 1.671663 1.464134 0.585342 0.644021 0.435796 0.213425 1.357738 1.586232 1.545703 0.819890 1.367545 0.012567 0.450279 0.655234 0.788890 0.591992 0.545966 1.254900 0.392933 1.583204 0.076358 1.856160 0.823271 1.021281 1.623051 1.585893 1.245898 0.683755 0.476818 1.035792 1.047834 -0.069790 -0.004312 -0.361114 1.398618 1.383822 0.421997 1.705664 0.029556 -0.066198 0.051203 1.722364 1.322079 1.292928 1.662147 -0.016256 1.310728 1.707597 1.375469 1.546348 1.943030 -0.036451 0.558144 -0.266574 0.833410)

	;; 99-1
	12.622612 (fv 0.000000 1.601197 0.675735 0.824937 1.585712 1.856247 0.097348 -0.128093 1.025651 0.480455 0.954279 0.347491 0.626587 0.694458 0.898162 1.272532 0.684634 1.137767 1.643934 1.521275 1.047103 0.680901 1.232138 0.886175 0.603433 0.065324 -0.003442 1.143022 1.262279 1.001078 1.502240 1.539684 0.387527 -0.240796 0.914257 1.021072 0.830135 0.895349 0.823768 1.454208 -0.127486 1.570891 0.443883 0.892431 1.170381 1.366309 0.941425 0.702939 0.571855 0.280140 1.656638 0.472320 0.260055 1.153301 0.949715 0.148316 1.066487 0.427830 0.818544 -0.167385 0.411934 0.330689 0.887299 0.734213 1.728731 0.063612 0.466751 0.013162 -0.447231 0.444351 1.131814 0.061263 1.074639 0.944421 1.055502 -0.026068 1.648026 1.034453 1.399998 0.887501 0.104617 0.511260 1.435502 0.677269 0.344898 0.942483 -0.009809 0.923335 0.650809 -0.003419 1.067454 1.910756 0.250458 1.576481 0.901923 1.611933 1.145031 0.515175)

	;; 97+1
	12.554819 (fv 0.000000 0.994754 1.201978 1.095875 1.228090 1.349063 0.520404 -0.005278 1.113744 0.684830 1.821835 0.418458 0.556811 0.671609 1.340860 -0.027127 0.490888 -0.669559 0.196112 -0.069433 1.791636 0.479800 0.480819 1.161113 1.931188 0.706820 -0.575437 0.825517 1.635684 0.154310 0.437054 0.834616 0.805687 1.760916 1.041481 1.654400 0.268843 1.252679 0.716018 1.507696 0.427453 0.212559 0.610822 -0.045110 1.474585 1.069280 0.938458 1.658424 0.606033 1.274272 1.871557 0.851412 1.378375 1.849718 1.305539 -0.196977 1.250436 0.271972 0.159635 0.861188 0.835566 1.009947 1.382413 1.136755 0.601730 1.508016 0.177040 1.096731 1.112114 1.556213 0.514409 1.424495 1.306796 -0.096547 1.551938 0.983953 0.982538 1.547826 0.947292 0.070780 -0.301979 1.274952 1.268078 1.506608 0.343339 0.539960 0.515360 0.716545 0.138903 1.075775 0.830359 1.045994 0.028008 0.165284 0.183640 -0.064893 0.128193 -0.025514)
     )

;;; 99 prime --------------------------------------------------------------------------------
(vector 99 15.391923904419 (fv 0 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 0 0 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0)

	;; started at 13.08
	12.671121 (fv 0.000000 1.578825 0.666211 0.726552 1.538384 1.791570 0.099320 -0.160491 0.989473 0.596822 1.035192 0.247178 0.628445 0.721303 0.845175 1.341449 0.627742 1.157974 1.573300 1.577559 1.146243 0.642518 1.253235 0.873141 0.677674 1.983841 -0.058813 1.145842 1.258749 1.002052 1.540728 1.596826 0.319265 -0.110992 0.873225 1.001714 0.958663 0.883044 0.804615 1.392171 -0.105346 1.566142 0.586138 0.950489 1.209868 1.332589 1.087730 0.608633 0.545623 0.189852 1.681493 0.487350 0.405093 1.121113 0.988264 0.089589 1.002114 0.406924 0.857351 -0.106561 0.434389 0.315978 0.874454 0.677274 1.738995 0.126523 0.418419 -0.034288 -0.514474 0.544729 1.186629 0.091214 1.023974 0.889868 1.105258 -0.014030 1.568529 1.019817 1.384214 0.868550 0.027819 0.525808 1.447056 0.636493 0.394992 1.091277 -0.079518 0.886075 0.569418 -0.004838 1.104104 1.810908 0.227707 1.565455 0.923044 1.560572 1.031354 0.513130 1.131259)
     )

;;; 100 prime --------------------------------------------------------------------------------
(vector 100 15.637986183167 (fv 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 0 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 1 0 0 1 1)

	12.957637 (fv 0.000000 1.386453 1.370643 1.628038 1.538390 0.424621 1.485227 0.897618 0.907971 0.449160 0.163275 1.571834 1.093156 0.838120 0.247905 1.436852 0.372882 -0.220773 1.118451 0.054878 1.267282 0.565411 0.289581 0.731340 0.458703 -0.367224 -0.030109 0.334428 1.397987 0.598724 0.901920 1.214518 -0.004754 1.438150 1.307411 0.016366 1.337284 1.304934 1.171963 0.021267 0.117441 0.560545 0.340812 1.151463 1.666509 1.019303 -0.015114 0.880146 1.373879 0.049199 1.503584 1.604549 0.862952 0.189305 0.529694 1.029077 0.778339 1.706291 1.914727 1.273598 1.699313 -0.031345 -0.253493 1.258299 1.649412 1.077808 1.672514 1.251013 0.462905 1.384023 0.091088 1.738772 0.445974 1.424109 1.582876 1.988433 0.984011 1.200230 -0.169021 0.062775 1.511082 0.660711 1.089055 0.545793 1.273058 1.509833 0.626971 0.715771 1.564417 1.945654 0.972744 0.969507 1.754542 1.683747 0.602245 0.329311 0.710216 0.150434 1.629408 1.227167)
	
	;; 99+1
	12.716986 (fv 0.000000 1.614268 0.794652 0.719356 1.522693 1.839206 0.053187 -0.216045 1.077547 0.626072 0.992447 0.258424 0.613665 0.666154 0.797791 1.297151 0.666442 1.138663 1.568655 1.598721 1.081507 0.701607 1.189990 0.875992 0.670799 0.120588 0.002798 1.147193 1.214233 0.961367 1.487074 1.498267 0.315736 -0.163747 0.892348 0.853335 0.781180 0.904959 0.815695 1.365580 -0.161311 1.770543 0.467808 0.858870 1.202500 1.263259 1.179260 0.605694 0.567979 0.170780 1.783259 0.557899 0.419137 1.246376 1.015382 0.060732 1.143789 0.421313 0.784488 -0.191174 0.582308 0.326318 0.868037 0.700245 1.775099 0.084259 0.487674 0.052341 -0.505041 0.601192 1.234546 0.060079 0.970347 0.831571 1.221404 0.028687 1.689191 1.030841 1.384017 0.852184 0.054733 0.492124 1.493372 0.743678 0.351949 0.983070 -0.060785 0.924421 0.622513 0.041911 1.106639 1.715696 0.158455 1.595681 0.922989 1.564481 1.036395 0.544443 1.152503 -0.027178)
      )

;;; 101 prime --------------------------------------------------------------------------------
(vector 101 15.735968313601 (fv 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 0 1)

	12.909758 (fv 0.000000 0.720714 -0.182655 1.565457 0.753622 0.130143 0.334294 1.650697 0.417832 0.048827 0.344422 1.486401 0.292931 1.799521 1.111655 1.558792 -0.221559 1.531040 0.348578 0.973695 0.761485 1.268033 0.273978 1.313895 1.704221 0.068165 0.481602 0.743938 -0.351235 -0.099468 0.085867 1.467502 0.670175 1.060411 0.557784 1.309992 0.991970 0.107757 0.556296 0.077508 1.974081 0.189947 1.303789 1.238050 0.718111 0.534076 0.252095 1.598289 1.547761 1.182866 0.464613 1.755609 0.089102 1.246032 0.080260 1.036577 0.473927 0.107892 0.368036 0.986840 0.765140 -0.036059 1.290823 0.227451 0.726294 -0.006595 0.616819 -0.359117 0.861664 1.267742 1.139832 0.077396 1.257827 0.004277 1.664182 0.904514 1.106007 1.213475 0.580481 1.709443 0.640563 0.036194 0.492519 1.274675 0.574901 0.832654 0.371185 0.344722 0.998543 0.576680 0.369414 0.177252 0.865880 0.137875 0.239059 0.486022 1.121460 0.939339 0.230403 0.470154 0.464729)

	;; 102-1
	12.654378 (fv 0.000000 0.039802 1.217841 -0.018794 -0.264350 1.648606 -0.106572 1.436093 1.744759 1.197340 1.116039 0.322269 -0.319802 1.429760 1.337731 1.367755 1.294986 0.934427 1.178285 0.242928 0.397639 0.030160 0.470705 0.489509 0.721431 0.877160 0.586365 1.300090 0.056753 0.396042 0.694396 -0.123538 0.601882 1.828235 1.061453 1.208202 1.515734 1.300848 0.385739 1.295236 0.466727 1.125610 1.584167 0.360500 0.430768 1.515128 1.002486 1.429469 1.701067 0.146032 1.922601 1.668726 1.734188 0.898236 1.467655 0.751985 1.587598 0.572766 0.063367 1.242347 -0.141898 0.518327 1.188113 1.385035 1.498198 -0.400261 -0.058961 1.288706 1.366806 0.035365 1.606021 -0.052356 0.617357 0.512726 0.520602 1.405519 1.969640 -0.459289 0.438819 1.509996 1.047832 0.536024 0.230428 0.540739 1.290987 1.664498 0.615778 1.436029 1.298481 1.467348 0.158627 0.119363 1.098827 0.065055 0.380410 0.835569 0.455358 0.512707 1.391092 0.922515 1.335905)
      )

;;; 102 prime --------------------------------------------------------------------------------
(vector 102 15.374809992584 (fv 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 0 1)

	13.125163 (fv 0.000000 0.284570 1.185932 0.254020 0.458026 1.777924 0.273972 0.352012 0.871247 1.673334 1.496604 0.270045 1.591827 -0.188397 0.589501 1.091682 1.741121 0.196787 0.525310 1.321393 1.205053 -0.057392 1.556520 -1.961535 1.179860 1.122770 0.814829 1.500056 -0.069946 0.070497 1.237530 1.280644 0.820936 1.402645 0.152660 1.210341 0.842206 0.369359 0.105608 0.811471 0.529059 0.041857 1.655756 0.893298 1.337926 1.496211 1.428234 0.556092 0.432069 0.925348 1.205854 1.544664 1.704644 1.229630 0.303212 1.758935 1.188278 1.467436 1.586279 1.260300 1.300112 1.011729 1.695629 1.060370 1.604385 0.957028 1.624378 0.311506 0.745336 0.578867 0.572336 1.655636 0.424967 1.250130 0.974803 1.251963 1.312562 0.463398 -0.038700 1.540879 0.156800 0.564982 0.689178 0.544052 1.778377 0.813450 0.561441 0.695184 0.270384 1.438063 0.744019 1.224468 0.148794 1.411742 1.416148 0.158444 1.282043 0.332184 1.434585 0.991269 -0.118131 -0.014118)

	;; 103-1
	12.631141 (fv 0.000000 0.074843 1.219158 -0.027199 -0.254073 1.624605 -0.135701 1.453877 1.755897 1.198675 1.090421 0.272002 -0.249474 1.447439 1.360955 1.341148 1.290153 0.969167 1.135329 0.243792 0.418984 1.946250 0.601544 0.456951 0.765282 0.872982 0.576621 1.365615 0.094262 0.399525 0.677984 -0.086420 0.567433 1.780255 1.046981 1.205389 1.534885 1.234066 0.439028 1.336514 0.490354 1.104410 1.622676 0.382214 0.417306 1.496561 0.975909 1.398390 1.624475 0.141661 1.921427 1.688187 1.741843 0.901238 1.419496 0.813192 1.607447 0.585967 -0.020824 1.251511 -0.203691 0.513177 1.192285 1.326136 1.473869 -0.455142 -0.016589 1.259703 1.293519 0.048863 1.685391 -0.099881 0.662916 0.500247 0.557103 1.438861 1.941547 -0.474933 0.373608 1.542760 1.006189 0.593009 0.247793 0.539650 1.340923 1.675659 0.620550 1.469642 1.328665 1.442498 0.149610 0.049207 1.111223 0.085126 0.353623 0.826677 0.461777 0.518667 1.404379 0.899861 1.337308 0.525132)
      )

;;; 103 prime --------------------------------------------------------------------------------
(vector 103 16.296298498866 (fv 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1)

	13.256855 (fv 0.000000 0.253687 0.364122 0.283681 0.599056 0.452778 1.412525 1.578158 0.723002 1.502688 0.469327 0.823618 0.138223 0.170924 -0.041881 1.730522 0.763213 0.124296 1.756004 0.298966 0.867744 1.163387 -0.026926 0.637630 1.135341 0.124472 0.638511 0.161082 1.417534 1.311969 1.355755 0.769867 -0.015620 1.263904 0.253925 1.195956 0.435477 0.207251 1.875570 0.589212 -0.141939 1.489218 1.811390 0.546189 -0.100127 1.137591 0.512565 0.982503 0.208205 0.661546 0.459680 0.647870 0.862493 1.703684 1.626808 1.293610 1.244032 1.833651 0.313984 0.098233 0.713078 -0.030639 0.471225 0.283054 1.436428 1.697146 0.363648 0.928407 1.232119 0.232840 0.986487 -0.076225 0.058237 1.691889 0.445904 1.400974 1.534686 0.353656 1.081845 0.844988 1.752497 1.490478 0.820514 0.624503 1.244095 0.481359 1.092852 1.038822 0.122193 0.306870 1.545599 1.882053 0.840143 1.618524 0.664876 1.172112 0.425428 1.063389 1.459465 1.132826 0.707914 0.476065 0.729618)

	;; 104-1
	12.891616 (fv 0.000000 0.020230 1.100455 -0.027655 -0.341498 1.573639 -0.166459 1.336909 1.614334 1.265242 1.070753 0.200336 -0.139945 1.315758 1.256048 1.330780 1.163466 0.897749 1.119686 0.362299 0.301310 1.883571 0.506864 0.431140 0.779158 0.861103 0.563763 1.317182 0.358448 0.581384 0.662511 -0.059228 0.585764 1.735705 1.134223 1.253804 1.488711 1.296145 0.401006 1.318547 0.409838 1.063168 1.784758 0.605346 0.454705 1.514331 1.036227 1.443746 1.590100 0.152638 1.937048 1.659118 1.596372 0.834928 1.202317 0.791629 1.638040 0.394481 0.036287 1.308852 -0.027851 0.483382 1.137070 1.471797 1.436021 -0.339247 1.959465 1.416371 1.274782 -0.056416 1.618621 0.073487 0.645516 0.465048 0.562814 1.499952 1.962975 -0.425202 0.177209 1.576794 1.092923 0.684292 0.216536 0.469811 1.278388 1.697283 0.494244 1.421192 1.305461 1.352595 0.145716 0.152674 1.146529 0.138563 0.239706 0.891463 0.397696 0.605319 1.317917 0.759776 1.395135 0.600443 1.308594)
      )

;;; 104 prime --------------------------------------------------------------------------------
(vector 104 15.919013023376 (fv 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 0 1)

	12.987392 (fv 0.000000 0.019656 1.020820 -0.122857 -0.383416 1.743762 -0.077551 1.285344 1.556500 1.347778 1.007108 0.271391 -0.017599 1.323289 1.224441 1.254961 1.192419 0.950226 1.083964 0.356128 0.296702 1.898956 0.423819 0.431784 0.740632 0.838009 0.555934 1.287966 0.437690 0.641910 0.602950 -0.082685 0.609730 1.650999 1.107220 1.287768 1.459073 1.340092 0.368618 1.276887 0.523746 1.035407 1.951274 0.598910 0.440828 1.523180 1.064599 1.442876 1.610632 0.084831 1.933213 1.678415 1.492367 0.869607 1.168981 0.759731 1.683066 0.461763 1.964877 1.344876 -0.085783 0.568560 1.208659 1.424190 1.445388 -0.303350 1.915514 1.421848 1.165687 -0.066096 1.641117 0.068094 0.584541 0.457188 0.559162 1.501643 1.956646 -0.560037 0.043217 1.538096 1.142301 0.678432 0.239030 0.380298 1.373491 1.617773 0.449327 1.348144 1.243227 1.328890 0.139617 0.253213 1.094223 0.214901 0.235818 0.939054 0.321415 0.563100 1.348449 0.703267 1.435425 0.687968 1.242454 -0.344280)
      )

;;; 105 prime --------------------------------------------------------------------------------
(vector 105 16.038356734428 (fv 0 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 0)

	13.058436 (fv 0.000000 0.018841 0.195855 0.206420 0.065633 1.458550 0.564954 0.584050 0.255393 0.821477 0.473289 1.497087 0.488701 0.595510 1.763919 1.795152 1.020709 0.148507 1.419452 -0.190874 1.252819 -0.115417 1.572364 1.086172 1.203320 0.123978 1.519196 1.337538 1.222474 1.661628 1.792441 1.530814 0.073522 0.146382 0.880812 1.383907 1.455106 1.313842 0.612949 1.097744 0.661951 0.056058 0.292577 0.309700 1.553938 1.839317 1.798626 0.412574 -0.220475 0.391331 1.230536 1.329793 -0.061036 0.863566 1.369439 -0.108592 1.446517 1.870258 0.562986 0.909666 0.015512 0.313473 0.325423 1.421234 1.107012 0.906081 -0.185513 0.052032 0.945263 0.140137 1.151954 1.558716 1.433167 -0.154754 1.358982 -0.108152 1.794830 0.776903 1.411273 0.506284 0.746113 0.870064 0.655404 0.430773 1.492137 1.947814 1.106281 1.476409 1.624757 1.670125 1.262143 0.090556 0.017948 1.208649 1.518613 0.097884 0.893396 1.883764 0.459504 1.072858 0.258050 0.025247 0.792929 1.431035 1.911968)
      )

;;; 106 prime --------------------------------------------------------------------------------
(vector 106 15.730461834714 (fv 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 1 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 0 0 1 1 1 1 0 1 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 1 0 0 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1)

	13.079950 (fv 0.000000 0.991683 1.667079 0.952198 -0.158134 0.908256 -0.128985 1.883696 0.540349 0.614398 0.596989 0.783975 1.428368 1.597136 0.736884 1.252068 1.305873 0.231319 1.020117 1.388373 0.377031 1.796792 1.091025 -0.916486 1.247592 1.449627 1.096507 0.594132 -0.088485 1.169711 1.329459 0.003695 0.368539 -0.180221 0.842521 1.314435 1.291992 1.272149 0.292625 1.025337 1.197144 0.687141 1.597409 1.201509 1.264866 0.210655 0.462014 0.072105 1.054043 0.490923 0.945944 1.071461 0.064888 0.965001 1.073253 1.205548 1.546442 0.256599 0.512902 -0.205146 0.188856 1.063444 0.616804 1.743279 0.914154 0.807038 1.016753 1.132350 0.990751 0.400337 1.345943 0.880688 0.534474 0.323663 1.462334 0.913980 0.240611 1.904272 0.651788 0.182999 -0.180558 -0.266742 1.405697 0.476547 1.309300 1.415664 1.075072 1.577006 1.108476 0.911007 -0.337178 0.168855 1.245061 1.768086 1.542431 1.828360 0.829179 1.275739 -0.086776 0.463079 -0.336090 0.362914 1.505253 0.753982 0.654367 1.043320)
      )

;;; 107 prime --------------------------------------------------------------------------------
(vector 107 16.2013 (fv 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 1 1 1)

	13.454325 (fv 0.000000 0.389504 0.200622 1.043121 0.761894 1.811391 1.013338 -0.029178 1.657156 0.071414 1.541808 1.697328 1.530731 0.828486 0.142611 0.827276 0.363623 0.731067 0.344946 0.056374 1.429426 0.761263 0.713573 1.043714 1.789986 0.913538 0.284688 1.632024 0.219315 1.596281 0.482719 0.716103 0.082813 0.889064 1.454911 -0.018694 1.031913 0.769500 1.225826 1.094301 0.011285 1.403439 1.540236 1.228421 1.198312 0.763787 1.489126 0.037842 1.393526 1.595697 1.484515 1.699381 0.910044 0.346999 1.483481 0.762896 0.323372 1.323234 0.494595 1.056252 0.710041 0.505300 0.227945 0.637730 1.459638 1.234710 0.493803 1.016315 0.230683 0.093113 0.713556 0.351744 1.777886 0.983943 0.185348 0.658457 0.665347 0.215532 0.767846 1.194595 0.781272 1.709017 0.088709 0.815194 0.381579 0.627948 1.674861 0.568794 1.433122 0.535438 1.473475 1.534920 1.207161 0.582128 0.284193 0.977855 0.959238 0.627080 0.292937 0.193644 0.627895 1.586822 1.256893 1.318535 0.663707 0.022219 1.167626)

	;; 106+1
	13.202367 (fv 0.000000 1.000613 1.684756 1.030591 -0.144674 0.930087 -0.073206 1.869216 0.492462 0.667691 0.532693 0.721976 1.419258 1.577138 0.740297 1.322068 1.346534 0.154223 1.065715 1.368889 0.410182 1.822841 1.125450 -0.885511 1.290555 1.433074 1.046721 0.707499 -0.124656 1.201693 1.347393 0.018662 0.502177 -0.078873 0.756433 1.230311 1.259142 1.367069 0.315216 1.023759 1.259356 0.661168 1.411343 1.215010 1.266771 0.189892 0.505302 -0.011494 1.187732 0.519532 0.949942 1.050962 -0.019894 1.078182 0.992807 1.143414 1.633065 0.324324 0.492441 -0.218768 0.188780 0.963413 0.578702 1.692089 1.002935 0.841457 1.096611 1.231089 0.982778 0.479408 1.297577 0.816566 0.491832 0.381540 1.447787 0.924630 0.221301 1.796849 0.662118 0.111778 -0.098285 -0.205921 1.443651 0.375879 1.302820 1.419045 1.157539 1.514324 1.141534 0.934891 -0.258550 0.136149 1.293417 1.740995 1.504775 1.852338 0.849037 1.301984 -0.143638 0.497510 -0.382560 0.320355 1.490322 0.666001 0.663075 0.925267 0.075096)
      )

;;; 108 prime --------------------------------------------------------------------------------
(vector 108 16.517358779907 (fv 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 1 0 1)

	13.566156 (fv 0.000000 0.728699 0.665336 1.259359 0.312955 1.409197 -0.227152 1.537467 1.153791 1.627076 -0.109225 0.091841 1.196044 0.651957 1.667279 0.297872 1.708304 1.600040 1.279774 0.976975 0.859888 1.094622 0.659631 0.928550 0.001741 -0.027962 0.214582 0.238151 1.673247 1.887884 0.736064 0.892280 0.140937 0.557264 1.253347 0.704162 0.470712 1.242786 0.158371 0.301659 0.524953 1.272263 1.156799 -0.239176 0.540826 0.229025 0.331628 1.768533 0.578592 1.809543 0.717505 1.699923 1.628036 -0.006910 1.357544 -0.139327 0.574888 1.440391 0.790214 1.511908 0.799982 0.339724 0.692982 0.670833 0.340679 0.340555 1.796897 1.303289 0.258157 0.027036 0.818761 0.552085 1.636862 0.719532 0.280874 1.446822 1.675335 0.170540 0.167079 0.487215 1.068313 1.129396 0.130584 -0.078228 1.601308 0.067975 0.896148 0.221651 0.232515 0.805049 1.470867 0.339643 0.563679 1.554585 0.968287 0.574484 1.097469 1.601363 0.583017 1.789341 1.359201 1.858560 0.117486 0.025512 1.678463 -0.072670 -0.213093 1.615471)
	
	;; 107+1
	13.161718 (fv 0.000000 0.987739 1.733133 1.054188 -0.119939 0.910849 0.010896 1.915591 0.510331 0.662472 0.507733 0.711187 1.421434 1.531951 0.698359 1.366502 1.433114 0.162830 1.031829 1.385260 0.380744 1.872146 1.120453 -0.900242 1.311562 1.361998 1.093182 0.717990 -0.097277 1.161510 1.367817 0.082904 0.485601 -0.064734 0.731587 1.181418 1.308157 1.250173 0.316423 1.011227 1.301355 0.644463 1.445963 1.205118 1.208647 0.244654 0.589262 -0.059634 1.176596 0.571146 1.043371 1.083159 0.006076 1.077933 0.991663 1.165270 1.605164 0.390047 0.441435 -0.106544 0.175661 1.010931 0.543321 1.751721 0.965777 0.870079 1.024670 1.181296 0.990067 0.440808 1.351390 0.806214 0.421993 0.407648 1.468845 0.828507 0.187943 1.771172 0.634836 0.107090 -0.067569 -0.177001 1.469562 0.463678 1.334677 1.387523 1.126011 1.572881 1.170585 1.010919 -0.335535 0.129689 1.331430 1.676924 1.536965 1.783188 0.838550 1.260495 -0.084649 0.463288 -0.384118 0.341860 1.494266 0.699617 0.647486 0.913118 0.121686 0.025406)
      )

;;; 109 prime --------------------------------------------------------------------------------
(vector 109 16.726722717285 (fv 0 0 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 1 1 1 0 1 1 0 1 1 1)

	13.649150 (fv 0.000000 1.372685 -0.023096 0.764121 0.652451 1.161206 0.008161 0.316013 0.797732 0.714473 0.487368 1.050633 1.595865 0.070630 1.790292 1.172057 1.415647 1.153468 1.827169 0.230707 0.215213 0.858764 0.278893 1.454000 0.649000 1.487731 -0.093971 1.467452 0.578832 1.089439 0.854711 1.680527 0.623468 0.213876 1.468708 0.944679 1.289165 0.802006 0.813501 1.223343 1.569276 1.613534 0.610297 0.672562 1.232493 0.103141 1.459267 0.251097 0.877797 0.013403 1.560238 0.500350 1.399744 0.774367 0.659639 0.252122 0.824594 0.812839 0.861276 1.156805 0.833828 1.345402 0.790424 1.718416 0.402535 0.733335 1.522110 0.842132 1.600144 1.051832 -0.203657 0.911191 0.314178 0.284195 1.331343 0.434428 0.490954 1.410099 0.311769 1.658687 1.103289 1.173009 0.197955 0.613754 0.369986 0.003017 -0.302157 0.765490 1.656484 0.479210 0.563523 0.438269 0.714490 -0.012143 1.495468 -0.063161 0.479473 0.509000 1.902431 1.448189 0.587148 0.187985 1.316513 1.133117 1.008029 0.693260 0.907818 1.116038 0.394946)

	;; 108+1
	13.143741 (fv 0.000000 0.981295 1.812666 1.117956 -0.185500 0.887133 -0.042123 1.869958 0.605292 0.660698 0.487240 0.624166 1.449694 1.534689 0.782613 1.451064 1.414295 0.227989 1.073340 1.379009 0.377980 1.849622 1.090582 -0.935851 1.300468 1.325519 1.018826 0.640677 -0.151618 1.157148 1.372788 0.030561 0.535214 0.003928 0.716545 1.230702 1.288510 1.214069 0.401399 1.044897 1.420969 0.699802 1.461844 1.182797 1.140031 0.222134 0.599399 -0.075721 1.205878 0.475321 1.079680 1.212881 -0.096955 1.107746 1.109769 1.169670 1.644352 0.462528 0.400247 -0.075889 0.244499 0.883273 0.555132 1.799341 1.047944 0.815280 0.989170 1.236643 1.002684 0.340197 1.339964 0.830022 0.342213 0.420385 1.313509 0.797027 0.138670 1.741420 0.612419 0.142853 -0.104009 -0.165428 1.519255 0.376528 1.265335 1.374075 1.080427 1.589793 1.292179 1.057071 -0.356737 0.109826 1.273643 1.715122 1.539078 1.804591 0.847821 1.225593 -0.104087 0.410682 -0.411370 0.366927 1.453570 0.665830 0.721383 0.960549 0.197868 0.027654 -0.001988)
      )

;;; 110 prime --------------------------------------------------------------------------------
(vector 110 16.455888332339 (fv 0 1 1 0 1 1 1 1 1 0 0 1 0 0 0 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 0 0 1 1 1 1)

      13.753511 (fv 0.000000 0.848399 0.494893 1.537753 0.056503 1.192968 1.014976 1.000380 0.176221 0.063643 0.945853 -0.068422 1.888547 0.530097 1.932585 0.363227 0.205713 0.801411 0.700920 0.687774 0.323313 0.855436 1.706412 1.023431 1.539017 1.189953 0.005598 1.402697 1.398321 0.097413 0.650843 0.983076 -0.039672 1.076216 1.303860 0.579074 0.077434 1.403649 0.444054 1.850591 1.616413 0.004099 1.016957 0.276287 0.460935 1.424558 0.455559 1.774494 1.736742 0.257321 1.711197 0.589769 0.080807 0.068711 1.794312 0.030231 1.983460 1.792079 0.697501 1.563642 0.912299 1.306605 0.631662 1.306070 -0.020912 0.369231 0.339819 1.307905 -0.099842 0.333029 0.056818 -0.061161 0.558252 1.627518 -0.126860 1.759233 1.646547 0.826803 -0.148545 1.670003 1.989516 1.496557 0.799184 0.829408 0.352552 1.567755 1.722037 1.366413 1.337959 0.542553 0.828268 -0.090626 1.570252 0.921528 0.763668 1.791188 0.313328 1.353716 0.012540 0.577255 1.197100 -0.067959 0.264526 0.484251 0.882328 0.325360 0.489410 0.497137 1.466498 0.363086)

      ;; 109+1
      13.385857 (fv 0.000000 1.005423 1.782283 1.037310 -0.213053 0.879928 -0.046517 1.873303 0.602952 0.747924 0.548631 0.551919 1.533520 1.564233 0.767686 1.439845 1.429058 0.210745 1.048360 1.272572 0.420497 1.907528 1.007798 -0.875985 1.280681 1.283565 1.002224 0.663448 -0.175829 1.191021 1.396519 0.008645 0.463633 -0.035145 0.773513 1.183723 1.280027 1.209216 0.370736 1.024088 1.346178 0.572424 1.493165 1.210957 1.190749 0.243885 0.627363 -0.093472 1.163170 0.538660 1.062757 1.203025 -0.076830 1.020755 1.065456 1.180141 1.616909 0.426164 0.442881 -0.033300 0.224949 0.880028 0.544694 1.835856 0.965989 0.842443 0.993190 1.292542 0.995849 0.354562 1.374934 0.864622 0.357717 0.414238 1.429257 0.844435 0.199497 1.704803 0.599091 0.164856 -0.041591 -0.188982 1.576927 0.379552 1.197978 1.412448 1.100509 1.573418 1.244031 1.006949 -0.394739 0.102675 1.270463 1.672535 1.525836 1.772058 0.832852 1.187053 -0.004100 0.474378 -0.431920 0.321063 1.410302 0.680526 0.673358 0.951529 0.162772 0.079611 0.022569 0.116743)
      )

;;; 111 prime --------------------------------------------------------------------------------
(vector 111 16.6662 (fv 0 1 0 1 0 0 0 1 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0)

	13.722535 (fv 0.000000 0.609754 0.477824 0.498205 -0.160828 1.311478 1.827872 1.163524 0.877088 0.528558 0.012460 0.425841 0.347225 1.111527 1.506620 1.410636 0.996952 -0.131493 1.544916 1.238729 0.920166 1.777555 1.246912 0.483008 1.025725 -0.124782 0.923160 0.448660 1.543112 1.342373 1.038202 0.935130 1.601650 0.963178 1.878258 0.588174 1.312098 0.758893 0.091784 1.903351 1.707234 0.845481 0.771218 1.534277 0.275800 0.904288 0.700394 1.584631 1.096911 0.048546 1.076681 -0.004790 1.712699 1.002701 0.028040 0.631055 0.000599 0.321247 1.728365 1.696152 0.050007 0.370978 0.617539 1.556864 1.281962 1.845086 1.923574 1.593500 1.577659 0.887043 0.956244 1.403764 1.038378 1.157002 1.529481 1.305687 0.017547 0.326930 0.654165 -0.007752 -0.267214 1.694215 0.852596 1.259529 0.832944 0.035647 0.361584 1.075053 1.075715 1.409307 1.062617 -0.201186 0.434486 -0.180399 1.188883 -0.221873 1.452975 -0.020938 0.072031 0.208492 1.474047 1.409906 0.615391 1.726165 0.685592 0.292682 1.428870 0.069915 -0.271563 0.353890 1.174756)

	;; 110+1
	13.484289 (fv 0.000000 0.995043 1.654854 0.951488 -0.186960 0.850693 -0.104052 1.791806 0.632389 0.741244 0.372539 0.536429 1.585222 1.564873 0.754743 1.533715 1.436886 0.265913 1.082971 1.345237 0.422609 1.896766 1.047262 -0.941259 1.315104 1.247825 1.012008 0.626763 -0.163895 1.147771 1.361070 0.089508 0.489357 -0.001980 0.747126 1.129161 1.312043 1.244841 0.335129 1.099634 1.435470 0.558588 1.594865 1.187385 1.215330 0.231616 0.653215 -0.079848 1.147198 0.522561 1.074244 1.189158 0.024016 1.002127 1.145705 1.183921 1.636771 0.398476 0.358443 -0.058263 0.246181 0.942683 0.482681 1.823368 1.038771 0.798364 0.979012 1.260203 1.008839 0.331481 1.329527 0.889282 0.388705 0.378727 1.394091 0.860317 0.191774 1.792101 0.682065 0.246000 -0.121897 -0.155296 1.603714 0.392748 1.177859 1.362462 1.085317 1.557823 1.337471 1.045764 -0.299177 0.095852 1.207771 1.749557 1.574722 1.798042 0.795838 1.277804 -0.046897 0.399079 -0.477065 0.322241 1.436449 0.774690 0.635047 0.952898 0.197693 0.020089 0.072586 0.105711 -0.061722)
      )

;;; 112 prime --------------------------------------------------------------------------------
(vector 112 16.697049415765 (fv 0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 1 0 0 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 1 1 1)

	13.804835 (fv 0.000000 0.660626 0.012013 1.067055 1.731382 0.878320 0.900685 1.333334 0.681047 1.863220 1.352916 0.703854 1.515374 0.461716 0.898953 1.919840 0.286167 0.735654 -0.086197 0.617448 0.511110 1.353376 1.062165 1.636012 0.515505 1.399695 1.421287 -0.379478 0.731516 0.180102 1.567557 1.923199 -0.007316 1.368320 1.294564 0.578724 1.657029 0.985867 0.321763 1.643211 0.183594 -0.095598 1.792723 0.880687 0.335377 0.402596 1.614065 0.786600 0.590837 0.174605 0.357314 0.363837 -0.136455 0.186803 1.076928 1.936757 0.633832 1.217976 0.067642 0.078632 0.866945 1.729624 0.916168 1.228002 1.090442 0.162856 0.012895 1.357444 0.829157 1.905883 0.224325 1.392049 1.223672 1.768609 0.413025 0.871017 1.661030 1.831359 0.223665 1.475164 0.272068 0.564210 0.622152 1.113002 0.676345 -0.006078 1.737306 1.187465 0.535707 1.077110 1.810506 1.386823 0.000557 1.452387 1.030585 0.842150 -0.158625 1.174437 0.579578 -0.079023 1.196883 0.846201 0.482764 0.945473 0.701184 0.898505 0.170202 0.481114 0.605193 0.955521 -0.054086 0.358715)

	;; 111+1
	13.560854 (fv 0.000000 0.996200 1.682628 0.999634 -0.183169 0.941340 -0.063380 1.872352 0.588785 0.718316 0.404204 0.564721 1.640073 1.488214 0.688322 1.540833 1.402097 0.325664 1.088557 1.271965 0.430614 -0.023931 1.082172 -0.819505 1.289052 1.272358 1.016703 0.615500 -0.063492 1.173776 1.419856 0.160057 0.471424 0.025687 0.794626 1.093604 1.347648 1.313640 0.365769 1.198433 1.539259 0.590650 1.625522 1.236869 1.255735 0.261849 0.614310 -0.133810 1.106507 0.525198 1.040282 1.242100 -0.009151 0.940124 1.120632 1.244098 1.583333 0.484225 0.270298 -0.091909 0.275038 0.915341 0.498191 1.846447 1.147765 0.805686 0.960525 1.293095 0.980148 0.249336 1.277364 0.859717 0.447170 0.347316 1.500244 0.749545 0.120155 1.639932 0.628998 0.242589 -0.052482 -0.149374 1.587211 0.461604 1.136482 1.323997 1.019660 1.587802 1.220439 1.097627 -0.381422 0.113408 1.209314 1.808025 1.585895 1.749582 0.823561 1.289475 0.074159 0.350519 -0.613785 0.308515 1.554187 0.783853 0.541355 0.955629 0.179584 0.128995 -0.001165 0.025208 -0.107472 -0.097625)
      )

;;; 113 prime --------------------------------------------------------------------------------
(vector 113 16.203890830538 (fv 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 0 1 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1)

	13.613456 (fv 0.000000 0.554013 -0.189590 1.040342 1.895741 0.972257 1.983763 0.925350 1.413107 1.187039 0.890581 -0.092527 0.648924 0.275297 1.034974 0.578278 1.412961 1.217860 0.290211 0.146756 1.277989 1.797973 1.243546 0.309623 0.588952 0.766281 1.732300 0.158146 0.970241 1.057713 0.155581 0.740347 -0.278224 0.813051 0.090610 1.633987 0.141253 1.362430 1.811341 0.106172 0.560908 0.975141 0.414465 1.325189 1.317848 1.670918 1.310037 0.138103 1.544695 0.427642 0.688876 1.115251 0.104011 1.249484 1.283379 -0.217415 1.248803 -0.055143 1.377781 1.794050 -0.051929 -0.190679 -0.001958 1.872135 1.015649 0.017838 -0.117121 0.829495 -0.198380 0.905735 0.272607 0.619166 1.647347 0.816228 0.007369 0.650952 0.045714 0.308454 0.434057 0.201848 1.245915 0.933121 1.619736 1.351637 0.362509 1.868147 1.070766 1.188359 0.400988 0.049686 0.087230 0.628970 0.077489 1.262876 0.220162 0.869503 1.130712 0.267514 1.396227 1.721653 1.550102 1.446927 1.155950 0.841581 0.384623 1.977430 1.631746 0.006140 0.715062 1.236385 1.051311 0.995413 0.371400)
      )

;;; 114 prime --------------------------------------------------------------------------------
(vector 114 16.442732865586 (fv 0 0 1 1 0 0 1 1 0 0 0 0 1 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1)

	14.166020 (fv 0.000000 1.038356 0.826275 1.128674 -0.125090 1.829063 1.262013 1.160559 1.519516 1.502014 1.857796 1.525394 0.946893 1.361851 0.493317 1.621550 0.040839 0.825455 1.881008 1.165270 1.273827 0.159303 1.756090 1.393155 1.413051 0.957215 0.252091 1.226129 -0.094317 0.742943 1.002043 1.336572 1.592258 -0.082802 1.594640 0.366562 0.390860 1.427038 1.739079 0.663205 0.933325 1.484965 0.194283 0.375410 0.493300 0.605961 1.748551 0.279636 1.804517 0.357640 0.998348 0.681772 0.367098 0.467866 1.810315 1.933552 1.894370 1.189828 1.415118 1.834729 1.938426 1.415450 0.009074 1.747634 1.249287 0.770928 -0.115261 1.409451 1.246513 0.675514 1.266338 1.477875 -0.114148 0.185420 0.629532 1.098645 0.874254 0.446592 0.243371 0.516051 1.248852 0.028651 -0.007127 1.709807 1.312205 0.257361 1.279674 0.901557 0.855388 1.469222 1.328726 1.208217 1.433035 1.922664 0.274941 0.148828 0.367238 -0.254062 1.751340 0.773665 1.053171 0.567664 1.773987 1.113690 1.183578 1.066952 0.102607 0.071815 1.625657 1.255723 1.028659 0.085305 0.356288 0.418655)

	;; 113+1
	13.529505 (fv 0.000000 0.609603 -0.150717 1.144620 1.885952 1.029695 -0.017328 1.023651 1.375935 1.049542 0.876959 -0.157071 0.712430 0.086142 1.092731 0.678537 1.443976 1.204147 0.360088 0.209607 1.268934 1.814390 1.230253 0.384833 0.625288 0.787682 1.706820 0.104070 0.975842 1.091508 0.162798 0.719194 -0.185681 0.851344 0.004406 1.551988 0.158850 1.400167 1.727125 0.074860 0.565161 0.958867 0.364724 1.349213 1.351889 1.679509 1.314199 0.132307 1.403589 0.369532 0.648564 1.160585 -0.009001 1.392847 1.218123 -0.146011 1.322032 -0.127699 1.286444 1.741589 -0.086769 -0.151954 0.062929 1.896116 1.063027 0.005563 -0.069693 0.819283 -0.185224 0.958608 0.217640 0.593867 1.814658 0.753485 -0.046094 0.586286 0.067659 0.127457 0.558174 0.155027 1.389478 0.905687 1.516935 1.472391 0.370204 1.903438 1.085058 1.201428 0.394426 0.093638 0.098055 0.586236 0.108735 1.290199 0.287019 0.975146 1.134274 0.275315 1.391551 1.689333 1.493530 1.402264 1.275785 0.772955 0.474442 0.009426 1.766587 0.112461 0.593436 1.228805 0.896377 1.061049 0.277890 -0.013199)
      )

;;; 115 prime --------------------------------------------------------------------------------
(vector 115 16.774665887963 (fv 0 1 0 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 0 1 0)

	14.106616 (fv 0.000000 1.570092 0.362453 1.337474 0.264875 0.921400 0.355874 1.476538 0.382397 0.690102 0.627233 1.283297 1.585161 0.461353 0.250428 0.070613 -0.478768 0.954888 0.726879 1.251951 0.417891 0.945598 0.563852 0.084589 0.533104 0.472131 1.084144 1.608792 0.044337 1.518184 0.783171 0.484129 1.900804 -0.149622 0.399475 1.517825 0.218983 1.531509 -0.230530 0.567148 1.520162 -0.082961 1.681948 0.292123 0.756368 0.448131 1.473802 1.014666 -0.012646 1.572834 1.242744 0.425093 -0.031699 0.769537 1.112143 1.298398 0.333581 1.945824 -0.101577 1.894990 1.397266 1.272345 1.210062 1.810802 0.715502 0.534600 1.359024 1.288083 -0.103335 0.078475 0.156596 1.496646 1.076856 0.312782 0.361663 1.568537 1.496774 0.979145 1.697729 0.843520 0.130906 1.341892 0.946201 1.950539 0.684184 1.344931 0.821452 1.479748 1.308019 0.296269 1.793184 0.500147 0.839533 0.057599 0.886809 0.752434 1.587024 1.203157 1.022448 0.212093 1.492893 0.209714 0.165780 1.402030 -0.307350 0.474032 1.513784 1.517441 1.459089 1.632203 1.421380 1.032369 0.154966 0.002531 0.304007)

	;; 114+1
	13.732359 (fv 0.000000 0.572178 -0.139025 0.983887 1.920434 1.123578 1.978353 0.968214 1.349051 1.117228 0.839675 -0.190533 0.694004 0.125250 1.107764 0.641260 1.405169 1.199788 0.276763 0.250348 1.204416 1.682914 1.257883 0.312057 0.695310 0.801198 1.682635 0.125698 0.950119 1.070718 0.245730 0.776193 -0.167540 0.949181 -0.042356 1.548062 0.106820 1.334788 1.742804 0.109905 0.567469 0.997715 0.375385 1.298162 1.314791 1.688434 1.235156 0.141282 1.427214 0.400188 0.631107 1.144708 -0.003109 1.362927 1.143332 -0.234998 1.276203 -0.143654 1.307422 1.689156 -0.014380 -0.262664 0.075462 1.880295 1.062640 0.101776 -0.026648 0.801460 -0.217311 0.971985 0.270988 0.672521 1.816202 0.778522 0.051104 0.549038 0.052885 0.201837 0.612616 0.180579 1.355932 0.900040 1.595492 1.482393 0.476525 1.886230 0.983641 1.114556 0.404677 0.048952 0.080076 0.569993 0.080539 1.262764 0.266797 0.946313 1.101489 0.203645 1.377876 1.725578 1.491484 1.434839 1.127583 0.826060 0.448266 0.008333 1.780636 0.098825 0.586600 1.122038 0.995066 1.017216 0.354291 0.057246 0.069092)
      )

;;; 116 prime --------------------------------------------------------------------------------
(vector 116 16.812931137234 (fv 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0)

	14.328742 (fv 0.000000 0.856207 0.986788 0.751460 1.884184 1.255896 0.144210 1.208511 0.255866 1.782286 0.019244 0.566742 0.407768 -0.089210 1.344767 1.018853 -0.034882 0.530119 1.597864 0.501326 -0.230774 -0.097023 -0.000389 0.665472 1.635375 1.228232 1.206358 0.850292 0.888987 0.993112 0.654339 0.818974 0.003413 1.565831 0.042608 0.878547 0.321526 0.088958 0.292372 -0.331777 0.700821 0.894714 0.005944 -0.346944 0.114845 1.049758 0.798720 0.790858 0.117448 1.021841 0.389934 0.399103 0.195343 1.878118 1.577823 0.477002 0.256545 1.229924 -0.002011 0.133077 0.537008 0.396216 0.701816 0.985840 1.738910 0.328555 0.541523 0.876819 0.876185 0.445666 0.685165 1.594949 0.620581 -0.127456 0.921400 0.311110 1.793307 0.275641 1.366815 0.824915 0.239454 0.832837 1.417323 1.769240 0.980992 1.239944 1.591029 -0.051475 1.486421 1.525417 -0.025657 0.653170 1.313243 1.650610 1.580897 1.618532 0.633267 0.393928 1.496919 -0.276408 0.878277 0.281939 0.351152 0.468289 1.618075 1.571369 0.984717 1.909405 0.851519 1.720488 0.929949 1.296555 1.289941 0.911398 0.225491 0.695200)

	;; 115+1
	13.782751 (fv 0.000000 1.670105 0.303378 1.514771 0.060477 0.906403 0.370378 1.628880 0.301098 0.717479 0.564448 1.198544 1.701046 0.489974 0.092684 0.106689 -0.600359 0.960290 0.727113 1.181333 0.468036 0.933578 0.612714 0.102105 0.439119 0.536613 0.989488 1.668598 -0.080124 1.683573 0.654250 0.599004 1.870044 -0.069895 0.298556 1.555710 0.285805 1.565873 -0.205135 0.563645 1.519179 -0.152285 1.687696 0.402404 0.955645 0.241673 1.401865 1.046960 -0.019116 1.640885 1.197901 0.505391 0.095168 0.718441 1.181463 1.406618 0.309258 1.952979 -0.107329 1.969648 1.502137 1.090118 1.043918 1.702710 0.780485 0.583772 1.473922 1.490931 -0.163373 0.133574 0.135840 1.533071 1.015158 0.398692 0.320450 1.364722 1.538313 0.970480 1.636937 0.963390 0.136800 1.340905 1.204598 0.054477 0.486418 1.417827 0.808183 1.530254 1.191144 0.320075 1.853919 0.467453 0.809752 0.120164 0.781600 0.697424 1.379599 1.216021 0.948183 0.099657 1.566373 0.116729 -0.093843 1.319423 -0.420543 0.691568 1.660724 1.496943 1.401099 1.619305 1.446415 0.867038 0.105822 0.158044 0.282349 -0.011943)
      )

;;; 117 prime --------------------------------------------------------------------------------
(vector 117 17.5997 (fv 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 1 1 1 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0 0 1)

	14.497812 (fv 0.000000 0.224426 0.992019 0.138711 1.176503 1.236445 0.315077 1.906428 0.448900 0.678218 -0.088951 0.205668 0.157937 1.760779 0.121986 1.314615 1.230068 1.510274 1.468208 1.579772 0.156575 1.223695 1.547174 0.976223 0.294979 0.682844 1.254567 0.255930 0.581609 0.421918 0.606116 0.691338 0.828316 1.627063 1.800785 0.001165 -0.086581 0.763116 0.639955 0.291470 1.735899 0.422553 0.362144 1.186351 1.590842 0.426463 0.245182 0.967296 0.891425 0.519158 0.866605 1.346855 0.815662 0.075921 1.039570 1.274467 1.634408 1.602113 1.536366 0.552713 0.810604 0.673899 0.744845 0.479678 1.304967 1.905715 1.460213 0.317282 1.748084 -0.013722 -1.881692 0.174856 -0.080552 1.785033 0.698053 0.094949 0.417990 0.698446 0.985481 1.584075 1.403772 0.388703 0.009472 1.646671 1.128281 1.234472 1.443078 1.392782 1.271405 0.499301 0.604344 -0.127230 1.264738 1.785688 0.416206 1.113044 0.215095 1.469439 0.236533 0.117496 0.271632 1.034059 1.537681 0.722701 1.631698 0.103905 0.435634 0.027785 0.196356 1.018099 1.623844 0.142536 1.403226 -0.013797 0.598011 1.913682 0.626571)

	;; 116 + 1
	13.889211 (fv 0.000000 1.679442 0.299199 1.367111 0.052770 0.927297 0.328215 1.615881 0.302404 0.707696 0.516039 1.151316 1.673258 0.534217 0.190986 0.074151 -0.598397 0.913919 0.765928 1.260413 0.423264 1.023745 0.609735 0.153506 0.453539 0.468256 1.018228 1.788765 -0.068307 1.692855 0.624116 0.609141 1.910624 -0.022395 0.256365 1.514074 0.233219 1.516754 -0.154609 0.590788 1.514050 -0.043651 1.742187 0.341087 0.951970 0.371363 1.447587 1.079612 0.057107 1.623815 1.214707 0.567773 0.057804 0.791128 1.221209 1.383201 0.340554 -0.013292 -0.005609 1.947264 1.370803 1.062963 1.024336 1.739421 0.767066 0.671699 1.426918 1.511148 -0.149781 0.104225 0.061945 1.535119 0.940075 0.392689 0.259023 1.411809 1.598917 0.941897 1.683270 0.884953 0.108874 1.319701 1.100749 -0.050961 0.639728 1.429813 0.861586 1.511163 1.232212 0.240917 1.860927 0.406637 0.844627 0.125914 0.873615 0.651653 1.385473 1.135755 0.994702 0.030143 1.590457 0.161005 0.055154 1.334956 -0.459106 0.663912 1.678280 1.514956 1.365867 1.519273 1.441132 0.891112 0.176832 0.115181 0.351957 -0.175561 0.176948)
      )

;;; 118 prime --------------------------------------------------------------------------------
(vector 118 17.181785583496 (fv 0 0 0 1 0 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 0 1 0 1 0)

	14.497443 (fv 0.000000 1.591354 0.741888 1.722967 -0.237709 0.685421 0.503550 1.254854 0.808656 0.911251 0.050157 0.861734 0.314280 1.341176 0.379991 0.875641 1.466708 0.300573 0.954767 1.385324 0.125132 0.348374 0.577011 1.655837 0.564307 0.582376 1.167510 0.907420 0.444532 0.218679 1.737312 0.252903 0.411946 1.083113 -0.185163 0.978023 -0.109963 1.511202 0.503851 1.662809 0.033875 0.523452 0.521481 0.883976 -0.357599 0.187161 0.880047 1.490736 0.844255 0.801313 0.683070 1.279258 1.624126 0.834042 1.570571 1.331665 0.812207 0.082063 -0.178779 0.727851 0.635760 0.472598 0.529740 1.710166 0.757477 0.262267 0.672628 0.403198 0.034164 -0.022037 0.130101 1.350219 1.105735 1.695932 0.323683 1.252068 0.744970 1.161905 1.322245 0.994864 0.697837 1.637816 0.396302 1.702348 -0.270747 -0.077800 0.225947 1.713037 1.228521 1.665048 1.679022 1.393803 0.704244 0.296414 -0.016270 0.947613 1.856633 1.384283 0.527416 0.984409 1.396798 0.351021 0.292270 0.549569 1.663499 0.778229 0.016680 1.156232 0.122381 0.159439 0.648535 0.193057 0.084166 -0.213455 0.477204 0.673154 0.992874 0.783540)

	;; 117+1
	13.955663 (fv 0.000000 1.656893 0.312860 1.406022 0.045609 0.940726 0.323204 1.558622 0.313593 0.699110 0.536076 1.119751 1.657613 0.469730 0.215020 0.137907 -0.614064 0.902352 0.821797 1.171991 0.441310 1.059221 0.661850 0.277594 0.394536 0.546400 0.968850 1.793240 -0.073575 1.622506 0.677941 0.641837 1.952355 -0.044282 0.215122 1.490798 0.302768 1.506837 -0.235108 0.508030 1.520891 -0.097109 1.755394 0.256002 1.007243 0.327520 1.464098 1.079175 0.017892 1.590910 1.290254 0.601225 -0.032662 0.654468 1.229419 1.312262 0.353655 -0.032649 0.034883 1.896617 1.433210 1.047605 1.126390 1.674282 0.764405 0.618210 1.508232 1.671380 -0.173491 0.106521 0.149565 1.507742 0.949278 0.443666 0.317362 1.314645 1.634673 0.873102 1.588608 0.915021 0.172843 1.351037 1.151673 -0.042685 0.619993 1.550214 0.823729 1.429222 1.211772 0.248747 1.864022 0.374155 0.849134 0.123908 0.792603 0.736151 1.435290 1.198233 1.078587 0.058874 1.626102 0.122469 0.017624 1.330950 -0.499655 0.706598 1.629594 1.438050 1.370171 1.549897 1.430173 0.915025 0.119087 0.070759 0.413439 -0.125417 0.236481 -0.031842)
      )

;;; 119 prime --------------------------------------------------------------------------------
(vector 119 17.167841346875 (fv 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1)

      14.390682 (fv 0.000000 1.375664 1.071878 1.242281 0.449872 0.997239 0.326902 1.844870 0.041292 1.299611 1.550408 0.729190 0.953350 0.209856 0.257680 0.853205 0.858641 1.807278 0.814295 0.490323 1.317949 0.220101 1.124178 0.689692 0.845713 1.610142 0.807190 0.053107 0.167263 1.261235 1.535767 1.158168 0.246566 1.099513 1.210170 1.481156 0.887639 1.096230 0.144442 0.446125 0.627726 -0.213400 0.869947 0.988021 1.647446 0.493250 1.672678 1.658411 -0.130924 1.196700 0.900590 0.905506 1.144054 1.144682 1.583644 1.532418 1.405419 1.861571 1.337158 1.938890 1.060547 0.949400 1.139259 1.324089 1.811791 1.700889 0.580433 -0.043873 0.685223 0.393731 1.345217 0.593893 0.307423 0.675865 1.845148 0.894101 0.377727 1.240396 0.150868 0.234381 0.772691 0.408668 1.155960 1.889975 0.784676 1.158424 1.614216 1.924591 0.178912 0.577105 0.980476 1.603643 0.495073 -0.104468 1.507041 0.927685 1.105445 1.078554 0.022413 0.000361 0.338859 1.519222 0.863311 0.615320 0.570559 1.762687 0.669024 0.026456 1.421100 1.955221 0.629611 -0.125129 1.900181 -0.021163 -0.020189 1.567842 0.924421 1.826999 0.630355)

      ;; 118+1
      14.018618 (fv 0.000000 1.667367 0.322872 1.356274 0.058995 0.960979 0.391067 1.596203 0.294396 0.668831 0.482386 1.201983 1.684789 0.511518 0.202150 0.119421 -0.566103 0.969879 0.710276 1.185777 0.439002 1.081943 0.730732 0.236637 0.526675 0.480731 1.028367 1.739731 -0.138846 1.593254 0.713861 0.553938 1.957692 0.049573 0.238503 1.491899 0.251089 1.428730 -0.126673 0.452175 1.482756 -0.053077 1.780248 0.323594 0.960159 0.318559 1.403830 1.045323 0.072970 1.671965 1.340192 0.627012 0.093313 0.726626 1.260031 1.369364 0.271099 0.039064 -0.011301 1.960494 1.463622 1.056374 1.121811 1.627859 0.817517 0.663209 1.409881 1.612732 -0.152806 0.038886 0.274896 1.521348 0.915556 0.404329 0.221685 1.199737 1.694611 0.915335 1.572323 0.961485 0.112089 1.311173 1.127868 -0.177640 0.609597 1.415894 0.807680 1.506084 1.239635 0.162405 1.866700 0.317949 0.857946 0.112683 0.879435 0.694750 1.339170 1.270491 1.111213 0.092592 1.497893 0.151420 0.069449 1.319832 -0.496262 0.680555 1.680836 1.536147 1.322680 1.555058 1.410956 0.888418 0.228998 0.018175 0.403145 -0.128572 0.219741 -0.075154 -0.155224)
      )

;;; 120 prime --------------------------------------------------------------------------------
(vector 120 17.067 (fv 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 1 1 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0)

	14.458666 (fv 0.000000 1.293108 0.698019 1.317447 0.029496 0.078825 1.245576 0.933427 0.917420 1.172126 0.357395 1.156156 0.879865 0.129592 1.181392 0.882110 0.690853 1.687107 0.025873 0.234607 1.243328 0.528035 0.272217 0.646247 0.920540 -0.212257 1.217024 1.877596 1.938817 0.737497 0.901785 1.059044 1.128268 0.954000 0.339889 0.097863 -0.055556 1.539115 0.342970 1.531145 0.894486 1.025619 0.519579 0.900743 0.956748 -0.133937 0.256714 0.139176 0.495069 1.185608 1.684763 0.822374 0.580038 0.873037 1.366028 1.356196 1.900731 0.458911 0.428437 1.433784 -0.025135 1.471236 0.210352 1.314750 0.475084 0.493167 0.205827 0.317580 1.227052 1.530659 1.302191 0.347571 0.409940 0.502737 1.688087 1.230409 1.337757 1.342952 1.903513 0.955786 -0.215055 0.487009 1.948923 1.411678 0.225274 0.421106 0.203875 0.568136 0.977570 1.560054 1.164692 1.211841 0.037236 1.165323 0.284280 0.274360 0.776762 0.207157 -0.008462 -0.022949 0.633618 1.519303 0.349119 1.348337 0.561608 1.136896 0.486384 1.690665 0.939858 1.037942 0.628883 1.115783 0.551269 0.261357 0.835768 0.754522 0.995311 0.736018 1.536035 -0.082119)
	
	;; 119+1
	14.042466 (fv 0.000000 1.695702 0.296711 1.338908 -0.078265 1.044647 0.445401 1.570773 0.356080 0.726875 0.562835 1.121698 1.696368 0.511401 0.207025 0.089500 -0.565140 0.942644 0.652808 1.167682 0.412919 0.987661 0.705879 0.198820 0.440865 0.512441 1.083421 1.751114 -0.069762 1.661970 0.763824 0.509555 1.981466 0.038582 0.269865 1.492095 0.267412 1.351405 -0.147933 0.429115 1.485596 -0.131353 1.737203 0.373649 0.934842 0.295981 1.401570 1.025505 0.159868 1.751013 1.267064 0.606930 0.033477 0.655345 1.307003 1.298431 0.292781 -0.055933 0.016301 1.947579 1.426247 1.012103 1.014686 1.610683 0.794183 0.636102 1.398468 1.630487 -0.106933 0.019245 0.234173 1.454561 0.871538 0.489427 0.182807 1.191314 1.653186 0.812730 1.596587 0.968349 0.144419 1.254337 1.168160 -0.201543 0.642098 1.430541 0.891933 1.544951 1.231299 0.070309 1.961946 0.325740 0.895972 0.097452 0.983847 0.726652 1.390398 1.237569 1.108864 0.162933 1.463000 0.108857 0.104118 1.340850 -0.457424 0.750886 1.757915 1.530952 1.370214 1.508778 1.434766 0.846018 0.114800 0.004043 0.307829 -0.143116 0.279204 -0.090078 -0.107619 0.067028)
      )

;;; 121 prime --------------------------------------------------------------------------------
(vector 121 17.782977183017 (fv 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 0 1 0 1 0 0)

      14.145310 (fv 0.000000 -0.025891 1.793636 0.033424 0.540007 1.698366 1.937124 -0.609559 0.386368 0.372251 1.167122 0.009884 1.449702 0.151646 0.129257 0.221923 0.286263 0.194141 1.256596 -0.022208 0.587239 1.364223 1.036771 0.840539 0.300738 0.487086 1.849878 -0.356013 -0.244608 -0.042719 1.244769 1.401449 0.301842 1.027056 1.091793 0.623370 1.184562 0.517907 0.649838 0.331082 0.619154 1.467356 0.525086 0.836576 0.132708 0.186394 1.646954 1.207107 -0.124102 1.434383 0.438192 1.403615 1.086842 1.456374 0.098749 0.654033 1.469902 -0.092397 0.999549 0.914715 1.334656 0.842194 0.762721 1.400578 1.518574 1.628966 0.557815 0.576931 -0.575198 0.632751 1.009717 1.185394 -0.060402 1.274789 1.032399 -0.216393 1.814193 1.597562 0.558478 0.044897 1.319287 0.285577 -0.020660 1.082584 0.821657 1.849151 0.241943 0.297525 1.569624 1.593287 0.604518 1.347238 0.159734 0.361474 0.136103 1.298636 0.140131 1.192829 1.398339 0.674275 0.995843 0.943454 0.693721 0.589259 1.642401 1.051611 -0.266130 0.115428 0.439245 0.514540 1.691776 1.063362 0.306592 0.883309 1.563638 -0.186910 0.971866 0.448146 0.177042 1.080065 0.466207)
      )

;;; 122 prime --------------------------------------------------------------------------------
(vector 122 17.876078447724 (fv 0 1 1 1 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 0 1 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 1)

	14.809716 (fv 0.000000 0.670494 1.886159 1.577487 1.777777 0.820522 0.567040 1.808673 1.691383 1.749354 0.999669 0.365962 -0.283305 1.315547 1.858625 0.083801 0.099076 1.593409 0.962399 0.938500 1.204685 1.174037 0.436114 0.616669 1.449802 0.424694 -0.043743 0.290754 0.536765 1.858591 1.302286 0.144562 1.898540 1.713336 0.304273 0.606056 -0.343580 1.320384 1.725243 1.070484 1.043894 1.041218 1.783423 1.623935 -0.119894 0.812509 0.330462 0.830339 1.651746 1.473863 0.826929 0.035844 0.962490 1.154392 0.108692 0.207697 -0.125372 0.785657 0.181654 0.507958 -0.099870 0.817795 0.576379 1.616959 1.203159 1.408060 0.803943 1.042280 0.347552 1.737313 1.151753 0.038129 1.376834 1.472899 0.308707 -0.055847 1.688664 1.527458 1.503192 0.428260 1.398802 0.697613 0.797253 1.257898 1.721624 0.405578 1.003490 0.227680 1.041522 0.134919 1.342074 1.464937 0.605066 -0.038087 1.389658 0.040933 0.121007 0.729584 0.212582 0.373515 1.668140 -0.235335 0.732650 0.289389 1.049347 -0.077662 0.429686 0.147005 1.585407 1.353860 1.815248 1.314972 0.285783 1.787337 1.040122 0.959573 1.461408 0.006176 1.591906 -0.004243 1.203878 1.856838)

	;; from 121+1
	14.077769 (fv 0.000000 -0.102882 1.749236 -0.004117 0.483853 1.765874 1.938255 -0.600392 0.405831 0.339694 1.084448 1.949979 1.449950 0.179825 0.196465 0.250508 0.230057 0.267538 1.186702 -0.013547 0.609348 1.275263 1.002412 0.929479 0.351264 0.550827 1.866085 -0.207369 -0.221459 -0.043981 1.181650 1.372732 0.322165 0.950666 1.016902 0.608561 1.206924 0.503654 0.566235 0.334378 0.545128 1.400875 0.599963 0.865496 0.228459 0.195440 1.563459 1.162224 -0.092823 1.463200 0.340144 1.432985 0.949791 1.498279 0.068471 0.623276 1.392543 -0.178909 0.913012 0.880422 1.353490 0.813253 0.747974 1.430440 1.480413 1.631261 0.640181 0.621156 -0.581884 0.645199 1.046241 1.177765 0.048757 1.254481 1.019786 -0.266200 1.761071 1.575419 0.546658 -0.000712 1.213661 0.352510 -0.036380 1.089333 0.735910 1.940744 0.321816 0.327061 1.683870 1.638125 0.601090 1.278317 0.270163 0.360522 0.023473 1.250704 0.243204 1.199993 1.329172 0.588810 0.966119 0.939463 0.761317 0.553614 1.599868 1.062777 -0.228048 0.241966 0.388550 0.647592 1.729999 1.118550 0.325131 0.887699 1.516026 -0.170170 1.006043 0.421332 0.259983 1.062250 0.497913 0.166635)
      )

;;; 123 prime --------------------------------------------------------------------------------
(vector 123 17.273 (fv 0 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 0 0 1 0 0)

      14.606318 (fv 0.000000 0.018375 0.589471 0.983384 0.991984 0.372395 -0.040275 0.299423 1.756771 0.367581 1.925315 0.431987 -0.091930 1.365768 0.790238 1.730935 1.453895 0.945086 0.541022 0.665855 -0.133333 1.898784 1.614955 0.125913 -0.075642 1.042483 1.409785 1.598074 0.355453 1.697472 1.704234 0.447761 0.702787 1.037349 1.268895 1.641450 0.389018 0.691038 0.964549 0.799007 -0.028923 0.682141 1.218121 0.346438 0.248506 0.187480 1.166792 0.799601 1.529262 1.053370 1.663430 1.815223 1.438810 1.297963 0.281072 0.228128 0.996820 1.126305 0.635366 1.152238 1.612305 0.687034 0.492102 0.223406 1.290673 0.404319 0.673144 1.585101 1.003033 0.671106 0.630415 0.262596 -0.092794 0.970586 -0.143151 1.120737 0.513895 1.346570 0.209142 0.468700 0.483816 0.465304 -0.188333 0.812984 1.400518 1.773921 1.423889 0.414054 -0.317948 0.988906 0.349734 -0.120165 0.609604 -0.196752 0.649574 0.752742 0.402866 1.001890 0.667657 -0.097642 -0.022329 0.780061 0.422052 0.637506 0.933615 0.491032 1.329969 0.891484 0.826863 0.432342 1.071482 1.483913 0.545228 0.886707 1.473772 1.459843 1.911936 0.601733 -0.070730 1.820410 1.529051 0.044995 0.589246)

      ;; 122+1
      14.218431 (fv 0.000000 -0.071277 1.809148 -0.020616 0.407111 1.755823 1.904945 -0.715971 0.341233 0.449964 1.085208 0.031030 1.532200 0.268807 0.148267 0.268084 0.272209 0.202242 1.223891 -0.064002 0.629461 1.331632 1.050525 0.887285 0.370000 0.565442 1.910419 -0.226719 -0.262129 -0.049320 1.111879 1.377442 0.321129 0.921437 0.982936 0.703155 1.229920 0.446816 0.492798 0.314076 0.541522 1.414758 0.522185 0.801174 0.218712 0.168371 1.631951 1.208384 -0.085808 1.408101 0.423643 1.324899 0.982011 1.466628 0.095538 0.635570 1.314596 -0.072617 1.020892 0.911989 1.330565 0.770391 0.725410 1.510974 1.479974 1.759621 0.639552 0.614948 -0.510015 0.641435 0.965296 1.113277 0.074254 1.206499 1.003706 -0.366482 1.772703 1.570225 0.592942 0.091270 1.226107 0.311704 0.007633 0.964361 0.718780 1.974845 0.242071 0.343141 1.709800 1.693786 0.483738 1.265900 0.338851 0.340533 0.047929 1.263159 0.240281 1.186223 1.427920 0.613439 0.969107 0.960914 0.712662 0.596951 1.686986 1.021249 -0.262802 0.214377 0.402786 0.561682 1.740484 1.058116 0.341115 0.933358 1.469760 -0.231395 1.023135 0.404403 0.200269 1.060708 0.484072 0.072981 0.045518)
      )

;;; 124 prime --------------------------------------------------------------------------------
(vector 124 17.868420183527 (fv 0 0 0 1 0 0 1 1 0 1 0 1 0 0 0 0 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 0 1 1 0 0 1)

	14.790618 (fv 0.000000 1.222162 0.999539 1.142487 1.505674 0.123191 1.078191 1.428308 0.398665 0.193203 0.342797 1.160548 0.272137 0.744922 1.397108 1.629980 0.516700 0.161533 1.540757 0.951466 1.306414 1.131481 0.340080 0.022600 1.902411 0.678905 -0.266096 0.618248 -0.195173 1.348860 1.656222 0.843246 1.086674 0.610041 0.732222 1.576567 -0.001222 1.325305 -0.206092 0.061466 0.937472 0.938375 0.951723 1.351728 0.822770 1.101763 0.749753 0.602996 1.016336 0.240295 1.282512 0.877283 1.675716 1.308583 0.020424 0.112525 1.125186 0.567562 1.325344 0.286941 1.392684 1.457107 1.070715 1.116929 0.019425 1.553921 0.611895 0.374394 1.517480 0.357614 0.351325 1.265831 1.671035 0.028656 0.694185 0.608779 0.968580 0.705917 0.557377 -0.050792 0.760543 1.517363 0.410154 1.478833 1.629314 1.203011 0.602580 1.412252 0.251943 1.776030 1.689098 1.335837 1.695826 1.914988 1.139727 1.661355 -0.008029 1.815582 0.952555 0.813836 0.589787 1.222025 1.184138 0.133013 1.235368 -0.243658 1.554911 0.580687 0.939871 0.323060 0.942785 1.574937 1.605974 1.858030 0.079942 -0.197497 0.010513 0.448075 -0.013192 0.950902 1.198378 1.685266 1.111201 1.137042)
	
	;; 123+1
	14.279834 (fv 0.000000 -0.081380 1.782165 -0.062634 0.363611 1.777729 1.870086 -0.748456 0.397000 0.457689 1.108119 0.004930 1.540452 0.247288 0.180358 0.333199 0.182296 0.178249 1.230554 -0.108533 0.646062 1.305622 0.825072 0.858877 0.381906 0.623442 1.836712 -0.249134 -0.191182 -0.125952 1.112553 1.374523 0.342721 0.833331 0.944734 0.720943 1.282090 0.390216 0.453997 0.358637 0.493600 1.372859 0.624272 0.735874 0.299299 0.184937 1.617155 1.281616 -0.070863 1.469387 0.307926 1.334541 0.930607 1.487203 0.131059 0.597353 1.290211 -0.242352 1.036453 0.942866 1.246650 0.636276 0.826032 1.531105 1.485955 1.813085 0.625741 0.627771 -0.579465 0.642188 0.969289 1.138476 0.074565 1.189823 0.939892 -0.416570 1.739435 1.565378 0.588268 0.099664 1.234765 0.379725 -0.063217 0.934469 0.845969 1.930710 0.181988 0.295750 1.696778 1.677311 0.505493 1.249700 0.433102 0.439581 0.020795 1.231023 0.285770 1.217649 1.421529 0.551828 0.924619 0.972048 0.789871 0.556108 1.717849 1.016229 -0.325643 0.376556 0.293594 0.487260 1.648794 1.072609 0.281420 0.961161 1.519437 -0.241812 1.031705 0.425825 0.197195 1.096632 0.361878 0.106170 -0.074233 0.005979)
      )

;;; 125 prime --------------------------------------------------------------------------------
(vector 125 17.637776156888 (fv 0 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 0 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 0 1 1 1)

      14.772411 (fv 0.000000 1.488367 0.539453 0.636319 1.701536 0.864646 0.653079 -0.015234 -0.146959 -0.016393 1.159310 0.253720 0.483376 0.791134 0.148523 1.139178 0.651015 0.419622 1.011424 1.343222 0.375202 1.487445 1.136349 1.264222 1.195821 1.118452 0.058438 0.180283 -0.364874 1.141390 0.108460 0.432578 1.082489 -0.344327 0.561149 -0.050777 0.153514 0.046289 0.013379 0.201861 0.723817 0.636257 0.099730 -0.252366 1.579710 1.247947 0.727318 0.604484 0.768675 1.814508 0.866882 0.945446 1.203952 0.553202 1.570818 0.438899 1.210503 0.074303 1.805294 1.142851 0.477720 0.743449 -0.030259 0.761798 0.442190 0.180723 0.743309 -0.143585 1.116545 1.404371 0.204979 0.238499 1.331119 1.234638 1.176686 1.242725 0.433339 0.737611 -0.052694 0.108421 1.540317 0.211091 1.637087 0.618282 0.999958 1.643481 0.805826 1.863967 0.824505 0.797379 0.836059 -0.009548 1.065334 1.608230 -0.042496 0.454917 0.581669 0.915626 0.146732 0.685151 0.520442 1.115897 0.367688 0.129909 1.145807 0.921815 0.252576 -0.010734 0.180757 1.854774 0.546533 1.532747 1.382619 0.143523 0.214257 0.954384 0.657013 1.826584 1.432640 0.172761 -0.181378 1.290872 1.519863 0.506886 0.104986)

      ;; 124+1
      14.335616 (fv 0.000000 -0.073704 1.756721 -0.027521 0.555274 1.787030 1.851198 -0.739687 0.444117 0.371512 1.030097 0.041170 1.545538 0.189519 0.163161 0.279241 0.173564 0.127795 1.239047 -0.127708 0.674274 1.329026 0.927305 0.921971 0.291034 0.575583 1.919448 -0.265928 -0.189299 -0.242314 1.071327 1.320148 0.401414 0.885029 1.046562 0.775451 1.215839 0.374013 0.421290 0.242139 0.417910 1.413086 0.643233 0.744664 0.179383 0.219870 1.572661 1.345306 -0.060756 1.371806 0.318705 1.344767 0.903717 1.446972 0.029587 0.642047 1.254548 -0.199918 1.025990 0.987502 1.268140 0.763438 0.716412 1.540475 1.448750 1.854247 0.619685 0.691226 -0.557884 0.607847 0.974173 1.151524 -0.000158 1.208581 0.923167 -0.344361 1.808080 1.613014 0.625897 0.097908 1.229154 0.352252 -0.000924 0.978476 0.892610 1.915124 0.237884 0.295218 1.727938 1.672743 0.433468 1.238004 0.487776 0.417610 0.023342 1.153124 0.251246 1.196960 1.459291 0.552975 0.974914 0.953186 0.742186 0.557329 1.742338 1.006012 -0.331621 0.294231 0.321006 0.465332 1.742325 1.134043 0.251983 0.900167 1.477710 -0.206427 1.075443 0.425293 0.211597 1.112385 0.321994 0.162492 -0.098661 0.047474 0.072546)
      )

;;; 126 prime --------------------------------------------------------------------------------
(vector 126 18.284595039843 (fv 0 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1)

      14.919977 (fv 0.000000 1.469803 0.590807 0.764079 1.791170 0.333377 0.787711 1.497688 1.425800 1.198769 -0.142602 1.315353 -0.073058 1.238142 -0.046252 1.358363 0.881227 0.034517 0.376307 0.332870 0.693500 1.217503 0.199404 -0.446423 0.007791 1.544042 1.693684 1.705920 0.539256 1.329303 -0.184478 1.516336 1.012314 1.494800 1.597619 0.336783 1.080235 0.583130 1.276101 1.725256 0.652789 1.276830 1.460138 1.593259 0.514539 1.170620 1.278633 0.619783 1.325249 1.591358 0.207365 1.060129 0.815013 0.040269 1.468914 0.227402 0.515366 0.731820 0.621073 0.837063 1.275146 0.259307 0.585385 0.909317 0.921047 0.261764 0.230595 1.268807 1.340737 0.628738 0.406147 1.678580 0.814730 0.487283 1.140440 0.869819 1.474812 0.775855 -0.116531 0.130586 0.641169 1.517310 1.370799 1.423659 0.321563 0.178649 1.411675 1.146911 0.966764 1.521079 1.121859 -0.427787 0.506332 1.644605 1.138614 1.523684 0.664505 0.648038 0.075277 0.416802 0.443365 1.235830 1.173282 1.107298 0.136026 -0.032457 1.449977 -0.023926 1.087880 -0.136228 1.342249 1.136201 1.846662 0.865407 0.833970 1.810099 1.018847 -0.107251 0.065627 1.367299 0.507024 0.142912 1.416639 0.609252 0.711456 0.417251)

      ;; 127 - 1
      14.478183 (fv 0.000000 0.930861 1.435103 1.015217 0.133148 0.287358 1.954448 0.877191 -0.313979 0.188033 1.404924 0.797822 1.641089 -0.072460 0.883498 1.253629 0.955039 1.649989 1.112182 0.909200 1.887346 0.566087 0.831325 1.595619 1.015259 1.132981 1.214225 1.758075 1.475152 1.620993 0.072446 -0.059078 -0.182289 -0.039338 0.155445 0.529297 0.046388 1.441668 0.535178 0.222607 0.659275 1.874433 0.311495 1.718719 0.434358 1.778879 1.619012 0.517997 0.354459 -0.261087 0.248995 1.922764 0.605114 1.052457 -0.265751 1.118974 0.375392 1.608325 1.902594 0.729575 1.283255 1.305350 0.868120 1.355763 1.680987 0.242830 0.477218 1.016250 0.628871 -0.030446 0.679211 1.826138 1.874720 1.129680 1.690954 1.195384 0.889438 1.205646 1.461460 -0.453690 0.712708 1.258870 1.879622 1.875344 1.343716 1.283838 0.647289 0.933542 0.025722 -0.304513 0.859639 0.850257 0.333502 1.942927 1.798084 1.335700 0.932797 0.281618 -0.061736 1.117606 1.074494 0.424155 0.429073 1.579564 1.707609 0.889204 0.016152 1.499631 0.327239 1.110073 0.816898 0.676932 0.517090 0.873228 0.943685 1.557236 1.328668 0.393069 1.595818 0.801812 0.427544 0.632088 1.930520 1.052145 0.001869 0.373834)
      )

;;; 127 prime --------------------------------------------------------------------------------
(vector 127 18.198689419357 (fv 0 0 0 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 0 1 1 0 1 0 1 0 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 0 1 1 1 1 1)

	14.912432 (fv 0.000000 -0.112564 0.330831 0.563931 0.720452 1.659462 1.770279 1.222445 1.859857 0.126001 0.651461 1.215294 -0.233033 0.427403 0.814844 0.606037 1.919973 0.930971 0.148326 0.698675 1.110446 0.338577 1.107127 0.863142 1.130521 0.352666 0.715295 1.098761 0.639947 1.470989 0.137887 1.186298 0.901174 1.895291 0.359770 0.973168 1.699946 0.771080 1.375904 -0.248826 1.181644 1.789978 0.712701 0.277767 1.875124 0.813518 1.712932 0.451921 0.276945 1.323596 1.302350 1.483287 1.090079 0.743389 1.264854 1.950370 0.782969 0.914279 0.320477 0.990740 0.622004 0.030993 0.934242 0.961767 0.268688 1.789126 0.206081 0.101936 -0.529878 1.903369 0.539774 1.823204 -0.147241 0.928082 0.776302 1.167127 1.638509 1.576221 0.666141 0.750484 0.892326 0.100670 1.158426 0.166814 1.186903 1.306719 1.235546 0.635532 0.425679 1.719459 0.863874 0.092801 1.266262 1.369621 1.347298 0.966081 0.206817 0.754899 1.254971 0.922627 0.087389 0.135770 0.821247 0.230310 1.412479 0.655130 0.149628 1.814319 1.923709 1.016259 0.975859 0.575686 1.520455 1.205512 0.978744 1.845650 0.833521 0.220528 0.380346 0.141961 -0.028883 0.515081 0.897680 0.876651 0.794347 1.289685 0.792317)

	;; 128-1
	14.536393 (fv 0.000000 0.910972 1.475131 1.009861 0.062727 0.222323 1.938743 0.836711 -0.379271 0.255108 1.367947 0.841274 1.648864 0.015930 0.884691 1.125991 0.989606 1.607929 1.107388 0.857011 1.831346 0.433218 0.833149 1.592445 1.050762 1.008151 1.363530 1.700977 1.491038 1.682961 0.086100 -0.103806 -0.179348 0.003896 0.165438 0.493687 0.089620 1.387284 0.581547 0.176309 0.705269 1.811651 0.301490 1.707605 0.333845 1.832817 1.652148 0.600871 0.309714 -0.231587 0.303261 1.879368 0.673797 1.138199 -0.287759 1.071255 0.390644 1.597999 1.895638 0.729896 1.280128 1.313792 0.920129 1.387655 1.675038 0.226144 0.498585 1.104083 0.607578 0.005976 0.644124 1.859066 1.816208 1.159654 1.721231 1.377183 0.892151 1.087634 1.544878 -0.427006 0.761009 1.308993 1.890672 1.804683 1.325584 1.333615 0.649826 0.878906 0.043600 -0.222822 0.983855 0.725901 0.429955 1.892651 1.820617 1.395993 0.939478 0.246907 -0.065788 1.167118 1.004041 0.432075 0.450312 1.618752 1.686873 0.868341 1.893872 1.401676 0.376204 1.113598 0.748962 0.732995 0.557016 0.919800 0.871855 1.529811 1.275389 0.387399 1.586418 0.758929 0.456983 0.576267 1.810711 1.106484 0.012213 0.311973 1.081248)
      )

;;; 128 prime --------------------------------------------------------------------------------
(vector 128 18.276384353638 (fv 0 0 1 0 1 0 0 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 1 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 0 1 1 0 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1)

      14.551285 (fv 0.000000 0.924459 1.485422 0.985256 0.056811 0.219930 1.908499 0.913743 -0.403193 0.259904 1.334649 0.827148 1.624714 -0.021872 0.937257 1.122813 0.961899 1.532146 1.148701 0.868319 1.827482 0.356035 0.897995 1.553711 0.943178 0.960525 1.352917 1.720117 1.523327 1.617955 0.013172 -0.149597 -0.137644 -0.034035 0.111097 0.498787 0.121406 1.399436 0.620595 0.082527 0.702328 1.824635 0.362315 1.752651 0.335052 1.794344 1.642190 0.610334 0.262361 -0.222978 0.248243 1.869656 0.644580 1.192948 -0.312319 1.070271 0.368940 1.593867 1.836900 0.676177 1.276819 1.276408 0.936758 1.361721 1.692175 0.215294 0.511916 1.079847 0.588820 0.055407 0.579633 1.891289 1.810098 1.133091 1.733591 1.452365 0.980479 1.078929 1.556717 -0.427469 0.779143 1.336023 1.912299 1.782248 1.339461 1.329616 0.616924 0.917615 0.006788 -0.195359 0.981816 0.758001 0.419952 1.868089 1.758394 1.479010 0.921655 0.244745 -0.038674 1.158515 0.987245 0.469852 0.442126 1.652528 1.699770 0.900506 1.793377 1.368738 0.405805 1.083967 0.706228 0.759055 0.550546 0.985536 0.835398 1.537041 1.252754 0.414912 1.587016 0.741668 0.441787 0.537126 1.829954 1.207186 -0.038603 0.324826 1.093300 0.845470)
      )

;;; 256 prime --------------------------------------------------------------------------------
(vector 256 27.740 (fv 0 1 0 1 0 1 0 1 0 0 0 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 0 0 0 1 0 0 1 0 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 0 0 1)

      23.954812 (fv 0.000000 1.204657 1.078759 1.682184 0.289433 1.857298 -0.103078 0.812130 1.708916 1.896961 1.156555 1.703874 1.227021 0.182267 1.041071 0.489158 1.008682 0.135723 0.046495 1.634992 0.566031 1.311776 1.337489 0.673226 1.836763 0.159154 0.202747 0.341271 0.471573 0.119586 1.124289 1.100574 1.091468 1.313210 0.642853 0.117292 -0.058379 0.647409 0.710309 0.207284 0.060417 0.146614 1.530493 1.426852 1.584556 0.403196 0.281684 1.359791 1.211733 1.335753 1.885602 1.477601 0.688497 0.894421 1.600991 1.328569 0.005997 0.453096 0.992624 0.185444 0.508566 0.835246 0.264281 0.242464 0.561992 0.572786 1.360366 0.402158 1.414686 0.275179 0.381572 -0.113917 0.093761 0.181937 1.876554 0.763184 0.742398 0.316668 0.919942 0.466632 1.953058 0.269310 1.678357 0.562522 0.033550 0.978955 0.884214 0.441468 1.069549 1.818992 0.418629 1.336178 1.464108 0.008854 1.818306 0.399905 1.080809 0.763485 0.787603 1.378379 0.936433 0.806686 0.536881 1.819028 1.671276 0.786432 1.275261 1.884577 0.933469 1.355576 1.479258 0.462174 0.332804 0.282457 0.550215 0.317652 0.454496 0.923565 0.787078 1.464952 0.107434 1.071904 1.315331 0.744343 0.731492 0.092424 1.422672 1.730219 1.887932 1.793030 0.347585 0.560825 1.039175 1.321464 0.820946 1.971856 1.662872 1.726858 0.163305 0.618347 1.843241 1.984311 0.060498 0.046747 0.257781 0.365656 1.677750 -0.207494 0.053362 0.938280 1.295484 0.245637 0.522272 1.268074 1.776463 1.391102 0.235187 1.356696 0.411477 0.726380 0.608354 1.031435 0.374485 1.212534 0.683978 1.636985 -0.020727 1.002990 0.490099 1.193211 1.072433 1.116935 0.177132 1.577198 1.488833 1.426992 0.196808 1.359200 0.812178 0.923445 1.498869 0.535636 1.325569 0.453085 0.957271 0.999087 0.721363 0.748530 0.296873 0.424017 1.951248 0.179282 0.622927 -0.057442 0.420195 1.292402 0.421561 0.376166 1.549061 0.996315 0.165646 0.418099 0.201640 0.421702 0.831456 0.106402 1.463327 0.005503 1.240637 0.776492 0.181978 0.800991 0.047810 1.685961 1.102672 1.488982 0.855213 0.435527 1.756187 1.183435 0.997613 0.162344 0.965285 0.203761 1.756880 0.117280 1.723671 0.647873 1.760056 1.248565 0.397491 1.167098 0.048428 0.194870 -0.145837 0.946144 1.336821 0.037491 0.496156 0.411789 1.814729 0.171113 0.774274 1.046076 0.369134 1.865905 1.353847 0.811560 1.792633 0.305766 0.578868 1.799589 0.584644 1.768023 1.140595 0.983334)
      )

;;; 512 prime --------------------------------------------------------------------------------
(vector 512 43.486 (fv 0 1 0 0 1 0 0 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 1 1 1 0 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 0 1 0 1 1 0 1 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 1 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 0 1 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 1)

      38.602884 (fv 0.000000 1.082143 1.690042 0.893575 0.756109 0.365343 0.807438 0.940757 0.585435 0.342350 0.594341 1.140652 1.817226 1.102492 0.331462 1.612595 0.512173 -1.909591 0.094152 0.360726 0.151765 0.706858 0.749498 1.906233 1.235313 0.796232 0.500830 0.064536 1.490244 0.959772 0.522500 0.779779 0.400580 1.439171 1.288511 1.693600 1.634346 1.612029 0.250323 0.286364 -0.273948 -0.057072 0.444920 0.673291 1.660718 0.950511 -0.044480 1.277714 0.922828 1.742498 0.067040 1.123761 0.731844 1.393404 1.039320 1.324896 1.831174 0.387406 1.709067 0.274769 1.267431 0.959919 0.715608 1.693570 0.000362 1.870214 0.699669 0.668933 0.997821 -0.008050 1.092934 0.993144 0.278118 0.973866 0.508203 1.715050 0.139916 0.132362 1.047327 -0.053979 0.185439 0.405403 1.344059 0.788131 1.083324 0.893261 1.764451 1.883814 1.299760 0.554300 0.979273 1.155257 1.533722 0.768283 0.256481 0.366299 0.921394 1.649597 0.976718 0.165847 0.006944 0.856772 0.899715 1.074092 0.112821 1.082075 0.258835 0.138175 -0.004825 0.001351 1.429175 0.630347 0.684026 0.531342 0.847633 0.762458 0.815632 0.219787 0.092949 0.202477 0.797900 -0.145417 -0.117708 1.761218 0.769741 1.161104 1.342323 0.523211 0.405201 0.497008 0.787122 1.231664 1.866867 0.811507 1.822296 0.236359 -0.004728 0.793757 0.887814 1.429788 1.804982 1.942786 0.923502 0.603222 0.794618 0.368216 1.088308 0.796327 0.542686 1.544013 1.716025 0.878200 1.782174 0.062214 0.364255 0.646601 0.833457 0.599270 0.751311 0.607033 1.116295 0.605117 1.252490 0.144452 0.065646 0.340371 1.042827 1.788314 1.880686 0.569623 0.189168 0.776287 1.195192 0.727742 0.491941 0.571446 0.260116 1.294844 -0.224851 1.513707 1.029946 1.744464 -0.045793 1.705297 0.170929 0.776558 1.159210 1.100586 0.974908 0.889723 0.131669 1.514065 0.483669 0.374957 1.765248 0.173880 1.574655 0.579673 1.075226 1.695626 0.618344 0.910042 1.785601 1.685191 1.340397 -0.031592 1.930247 1.607968 0.311691 1.234826 1.008031 0.136574 0.693831 1.350593 1.790691 1.248723 0.321392 0.332409 0.211515 0.677389 0.675342 0.748083 1.542146 0.537541 0.945052 0.644544 1.587504 -0.198604 0.497285 1.589685 1.631769 -0.102021 1.434262 0.504366 1.007294 -0.071908 0.889783 0.106723 1.597262 1.184125 1.385914 1.784083 1.814813 1.444514 0.168106 0.275712 -0.230240 1.482952 1.749244 0.624319 0.820132 0.038543 0.453451 1.192705 1.551536 0.933988 1.412615 0.290421 0.996887 0.879431 1.841715 0.672561 0.642185 1.873294 1.346219 1.516340 0.034439 -0.025203 0.114641 1.027748 0.436673 1.695049 0.946949 0.531849 0.288148 0.279537 1.094778 0.375490 0.307554 0.627782 0.418409 0.832934 0.666935 0.114950 -0.053285 1.218299 1.879745 0.386673 0.915368 -0.165173 1.124058 0.466149 1.878428 1.629128 1.512993 0.806896 0.046040 1.932554 1.129093 0.063911 0.559840 1.823056 0.947920 0.467855 1.479381 1.855655 0.408469 1.725599 1.305170 0.270211 0.911615 0.523954 1.318986 1.354400 1.104393 0.792536 0.687738 1.816953 0.079500 1.734615 0.148004 0.393542 1.491324 1.809997 0.036899 1.917219 0.036016 1.292915 1.439271 0.992174 0.734749 0.043086 0.632449 1.678465 1.214089 0.407041 1.157576 0.467194 1.849834 1.465874 1.299867 0.452820 0.577350 1.178402 0.504471 1.704246 1.529399 0.119449 1.587272 1.187154 1.736018 1.251019 0.054071 0.448967 1.151610 -0.041983 -0.058564 1.189234 1.429143 1.489017 0.205182 1.257753 0.994036 0.781546 0.390902 0.744400 1.772431 0.919261 0.499894 0.419934 0.281518 0.736860 0.910447 1.681100 1.722013 1.141474 0.827377 0.320102 0.007503 0.593080 1.581219 0.475353 0.227567 1.630156 0.895436 0.162740 0.389713 0.427078 0.505436 0.990570 0.227561 1.922194 1.293488 0.525156 0.798692 0.804781 1.222760 -0.002373 0.214414 1.011966 1.489753 0.749041 1.209362 1.542616 0.129806 1.948618 0.096126 0.340987 1.210097 1.746925 0.607998 0.771692 0.843752 0.870293 0.931325 1.216995 -0.219011 0.558727 0.605157 0.764943 0.813267 0.109796 0.025290 0.418750 0.976910 0.611063 1.425653 1.312703 1.416454 1.541723 0.279510 0.000239 1.660016 0.196937 1.482933 0.237398 1.048222 1.226372 0.074770 0.565242 0.782888 1.814840 1.669287 0.878760 1.658003 1.628831 0.063412 1.934276 0.152397 1.633067 1.697411 0.919379 1.358819 1.021028 1.568829 0.560019 1.191100 1.722100 0.879855 0.967865 1.958702 0.180163 1.190964 1.472899 0.387723 1.635329 -0.004167 1.194302 0.101361 0.922515 1.847355 1.174116 0.380497 0.721821 1.201075 1.612741 1.020268 -0.168817 0.406276 1.455790 1.666789 0.232089 1.791143 1.515844 0.427944 0.351285 1.732308 0.954418 0.569378 1.065546 1.527300 1.587063 1.317922 0.415597 0.001422 1.240139 0.099248 1.639437 1.663543 0.562245 1.762090 1.669121 1.738347 1.503729 0.665114 0.450457 0.358214 1.358391 1.040768 0.320330 -0.191120 1.844458)
      )

;;; 1024 prime --------------------------------------------------------------------------------
(vector 1024 70.140 (fv 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 1 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1)

       65.349256 (fv 0.000000 -0.129848 0.969209 0.836351 0.061754 1.032484 0.051397 -0.047672 0.218624 0.018916 -0.064346 -0.087720 0.896115 1.194836 0.077672 -0.093665 -0.097710 -0.086592 0.949666 1.122929 -0.067767 0.950039 1.122745 0.018018 0.930855 -0.245701 0.859196 -0.118393 -0.017421 0.154025 -0.211100 -0.109137 0.940842 -0.140564 0.967517 -0.167684 0.023269 0.025376 -0.045911 0.903419 -0.200515 -0.239733 0.820269 1.087952 1.103155 -0.067139 0.794572 -0.000447 0.796383 -0.050127 -0.097253 1.071546 0.028226 0.109239 0.999458 0.870447 0.946254 -0.081085 1.245293 0.861076 0.913395 -0.009593 0.921868 1.075746 0.111204 0.213778 0.007799 0.861516 0.879520 1.119282 1.112758 0.023180 0.087708 -0.039342 0.017034 -0.142251 -0.066926 0.123437 -0.087868 0.910913 0.108597 -0.196132 1.069560 1.014239 0.192506 0.075011 0.674937 -0.174632 1.062546 0.982886 -0.071153 -0.102231 1.008769 -0.021251 -0.043692 0.910660 1.203363 0.930076 1.192149 1.079643 1.139869 -0.102933 0.892075 1.081967 1.117296 1.069641 0.961155 0.889926 0.104236 -0.012679 1.018557 0.083425 0.102764 1.041332 1.049506 1.057530 0.927572 -0.192969 -0.132492 0.997314 1.171628 1.067315 1.038820 1.033745 1.322831 -0.007981 0.994085 0.965156 0.070645 1.143780 -0.097751 -0.035141 1.081372 0.841845 0.110341 -0.016561 1.124066 1.050833 0.937074 0.926741 -0.150226 0.056436 0.964946 1.014226 0.961483 0.200116 -0.027025 -0.042596 0.873435 1.128675 -0.074217 0.034750 0.002625 0.037174 1.052187 -0.007505 1.057468 -0.020629 0.954765 1.162873 0.836305 0.919671 0.176115 0.867824 0.159416 0.913293 0.972493 -0.057629 0.902111 0.973589 -0.086627 -0.008031 -0.139087 0.943821 1.137966 0.070214 -0.004563 0.871135 -0.028372 0.970905 -0.036782 0.845326 0.108872 0.880706 -0.063917 0.888627 0.925543 1.066596 0.853571 -0.093806 0.904332 -0.112339 0.945758 0.871634 -0.096140 1.001890 1.129246 0.963672 0.170539 1.085873 0.061910 1.045363 -0.043655 0.071480 -0.112838 1.140479 -0.203871 0.018032 0.967477 -0.109462 0.786798 0.159117 0.091987 1.000511 0.121439 0.998700 0.114766 0.043124 -0.051500 1.039391 -0.116269 0.884009 0.038584 0.870599 -0.009894 -0.177026 1.208055 1.281757 0.041090 1.074146 -0.185247 -0.160109 -0.084894 -0.013678 1.116236 0.043626 0.914436 1.186335 0.008002 -0.013450 -0.068550 0.867764 -0.069795 0.028624 1.053037 1.105179 1.148503 -0.078114 -0.107345 0.808140 0.888280 -0.101397 0.863680 -0.177989 0.805880 0.985054 0.997369 0.970739 0.045371 0.041317 -0.112380 1.007911 0.837435 0.969586 0.893134 1.011096 0.079245 0.911597 -0.043743 1.012740 1.031412 0.069924 0.910651 0.066980 0.855519 1.128309 1.046886 -0.009687 -0.147082 0.900969 1.137525 0.881305 1.084781 -0.031000 1.031283 0.123503 -0.135598 0.951868 0.887466 -0.122854 -0.039498 1.017664 -0.102471 1.018993 1.022945 0.093609 0.101814 1.044330 -0.102747 0.051954 0.001832 1.002061 1.025387 0.930853 0.958319 0.146189 0.932064 0.106399 1.032653 0.014707 0.032026 0.879101 -0.027770 0.031687 0.111934 0.802921 -0.076047 0.059286 0.065123 0.128711 0.974155 1.040636 -0.158251 -0.044445 -0.146345 1.152523 0.901758 -0.061750 0.921515 0.108254 -0.128639 1.088615 0.119335 1.107712 0.012965 0.831934 0.917791 0.827352 0.931376 0.029208 0.968659 1.110903 1.139422 0.103217 0.804597 0.104877 1.024813 1.110962 1.158506 1.074313 0.918885 1.091629 1.052239 1.155470 0.969547 0.176177 1.193274 1.000806 0.167489 -0.087811 1.272916 0.090580 0.837388 0.853777 0.021673 0.795498 0.153088 -0.039163 0.886259 0.953876 0.846456 0.902225 0.108103 -0.023242 1.091272 0.796242 1.011212 0.961046 1.021211 0.039001 -0.032781 1.042170 1.131254 1.092307 0.999148 0.071362 0.869992 0.079822 1.110594 1.044065 1.166722 0.955017 0.117000 0.059709 1.113545 0.131377 1.023012 -0.114272 0.975103 0.983023 -0.046717 0.032378 0.224959 -0.069345 0.040516 1.089631 0.899237 0.136151 0.832552 1.215356 0.881670 0.944211 0.848668 0.152316 -0.124640 0.919395 0.853571 0.038901 0.049308 1.049839 -0.129701 1.004425 -0.052754 0.002949 -0.037696 0.133904 -0.020847 0.967100 0.902003 0.019567 -0.130260 -0.157473 -0.071944 0.135523 0.944472 -0.199005 -0.011428 -0.057531 1.218722 0.021172 0.873547 0.871952 0.950595 -0.066828 0.911583 0.960085 0.059484 1.216384 -0.015251 0.921576 1.107399 1.190526 1.009427 1.067453 1.067973 0.105850 -0.001821 0.968722 0.047666 0.095350 1.060487 0.951973 0.082517 1.139249 1.053557 0.799986 0.981175 0.927100 1.108483 -0.113217 0.056334 0.923079 -0.168060 1.160952 1.109659 0.931859 0.005663 0.016298 0.221144 -0.021547 1.134376 1.041640 -0.085720 1.009292 1.001582 0.885811 0.011233 0.110421 0.907129 0.093259 0.973361 0.842954 0.055170 1.054987 1.014198 -0.048044 0.812989 -0.144503 0.010466 1.029196 0.774851 0.843001 0.004633 1.225056 0.948512 -0.001831 -0.091454 -0.110441 0.000770 0.042991 0.840050 0.957463 0.073186 1.131453 -0.127608 1.100834 0.028867 0.991329 -0.079297 0.226099 1.081074 1.094744 -0.196334 -0.315150 -0.099639 0.860961 1.022403 0.767717 0.956186 1.242205 -0.055123 0.982544 1.115183 0.186049 0.867447 -0.036624 0.161043 -0.021433 0.029621 0.825744 0.027361 -0.010122 1.051195 0.027158 0.125747 -0.012676 1.018144 0.217569 -0.139580 1.065948 0.653885 0.017558 0.122910 1.005607 -0.024503 1.016854 0.118126 0.117812 0.209380 0.129761 0.103368 0.851695 0.818381 -0.060532 0.047740 1.092005 0.126179 -0.128900 1.046458 1.172438 0.945933 0.969409 0.186286 0.067827 0.866733 1.045200 1.053391 0.154799 -0.076177 1.034977 -0.251459 0.843987 1.036970 0.109710 1.081980 -0.054976 -0.104881 0.977835 0.917720 1.151081 1.224827 0.036178 1.178894 0.852252 1.170082 1.170461 0.979772 0.962385 0.904510 0.000036 -0.069878 0.919872 0.173255 1.075581 -0.013411 1.144951 -0.113696 0.013363 1.098609 1.014644 -0.003549 -0.244091 0.859325 1.071514 0.043866 1.123524 0.973631 0.994259 0.294619 0.940489 0.920230 0.796504 -0.004450 1.029035 -0.000831 0.920995 1.002150 0.986683 1.009523 1.089643 0.007497 1.152282 0.045887 1.088386 0.885838 -0.027924 0.051985 -0.076538 -0.224663 0.028256 -0.124194 0.724391 1.154873 0.792085 0.945537 1.154353 0.115964 0.986499 0.966811 1.012457 1.019910 -0.144866 0.815479 0.985586 0.913383 -0.150963 0.023412 -0.040408 -0.003953 0.004799 0.998876 0.002820 -0.098213 1.057293 -0.129926 0.137392 1.102538 1.079292 1.089070 1.130675 1.020925 1.154058 1.123118 0.858700 0.978386 0.138491 0.154692 1.041549 1.046975 1.030488 -0.158543 0.870238 0.064134 0.875614 -0.094478 0.900905 0.880022 1.134267 0.779059 0.063545 1.070040 -0.086015 1.008573 0.109322 -0.247240 0.015151 1.151193 -0.102164 0.087261 0.007995 0.854703 1.140979 -0.090975 0.812937 1.001838 0.168940 0.981369 -0.006072 -0.134631 1.058021 1.081911 0.004162 1.014677 0.995130 1.055979 -0.015306 0.058775 1.111668 0.059318 1.008648 0.996646 0.848989 -0.109175 1.102945 0.116474 0.906494 -0.120660 0.877452 0.886871 0.085411 0.884701 1.181621 1.062561 0.189097 0.973371 1.214908 0.001252 1.030678 0.152018 -0.037592 1.176813 0.948804 0.061120 1.019977 1.028438 -0.000808 0.087217 0.826864 0.893273 -0.207696 -0.074786 -0.108728 0.152240 -0.121688 0.980366 -0.049309 0.988905 0.044844 1.037851 0.979360 0.997856 1.209193 0.179051 1.004545 0.962175 1.139200 1.064077 0.021192 0.871727 0.976645 -0.060807 -0.016180 1.233966 0.984256 -0.044995 0.845917 0.182605 0.998382 0.007096 -0.023173 -0.024155 0.146239 1.013539 0.995536 0.048524 1.174691 1.141919 1.101145 -0.104732 0.114083 1.102748 0.983142 1.123097 -0.131915 1.072939 -0.138725 0.845004 -0.163152 -0.079593 1.018944 1.012216 0.030165 1.054447 0.994960 0.152361 -0.060656 1.093567 0.946563 0.106698 0.153793 -0.034551 1.295949 0.943407 -0.163119 0.067866 1.194305 0.979105 1.022403 1.106721 0.934941 -0.016105 1.092573 -0.050474 0.132465 0.025768 0.046448 0.920971 0.032186 0.827060 -0.132549 0.143363 0.083704 0.912578 -0.030293 0.096970 -0.039315 -0.023765 1.016646 0.854818 -0.052889 1.056921 0.089890 1.018924 0.081699 -0.114805 0.930082 -0.021013 0.109704 0.995297 -0.078029 1.125314 0.178931 0.020308 -0.221485 1.187702 0.047629 0.040061 1.015073 0.069320 0.060090 -0.115159 1.088644 -0.081572 0.068986 0.955768 0.084087 0.114901 1.013399 0.080815 -0.114939 1.007244 -0.059946 1.062447 1.043256 0.100314 1.021597 1.004933 -0.021577 -0.187720 -0.061395 -0.075323 -0.009496 0.985795 0.872323 -0.046461 0.888848 -0.053261 -0.110021 1.099191 0.979002 1.060305 1.062463 1.171427 0.691334 1.098940 0.054888 -0.017909 -0.010409 -0.111589 0.082490 0.948398 1.144871 0.127743 0.031811 1.026180 1.046146 -0.030210 -0.103802 0.989801 -0.310437 1.153393 1.012685 0.952894 1.001378 0.015652 1.054587 1.328504 -0.151531 1.037238 1.151575 0.030623 1.108802 -0.028053 0.044671 0.901073 0.934031 0.058498 0.039050 1.065155 0.024139 -0.131291 -0.082086 0.854526 1.154246 -0.049980 -0.184925 1.049877 -0.115467 -0.018300 1.001119 0.057983 1.189518 -0.114544 1.258100 1.123841 0.961039 1.070424 -0.124628 0.209509 0.034004 0.948762 1.100182 0.083224 0.948264 1.081482 0.076927 -0.000455 0.950737 0.098354 1.005742 1.019785 0.974317 0.230726 -0.067827 1.165865 0.048218 -0.058027 0.937849 0.079916 -0.012394 0.069161 0.050349 0.906284 0.832283 0.101171 0.790746 0.156878 0.740395 1.017554 0.191391 0.080956 1.000597 0.844203 0.944456 -0.111179 0.982617 1.037761 0.099785 0.851180 0.116591 0.142708 -0.015906 0.096645 0.965791 0.020953 0.925519 1.197465 -0.055737 1.095928 -0.064679 0.010255 0.936661 1.178645 0.190866 1.141107 0.130145 0.023056 0.121484 0.185090 -0.056773 0.100045 0.069574 1.039529 0.996635 1.085726 0.949189 -0.165723 -0.039203 1.116369 -0.064244 0.940174 -0.154655 1.121041 0.902088)
       )

;;; 2048 prime --------------------------------------------------------------------------------
(vector 2048 102.619 (fv 0 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 0 1 1 0 0 0 0 1 0 1 0 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 1 0 0 0 1 1 1 0 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 1 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1 0 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 1 0 1 0 0 0 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 1 1 1 0 0 1 1 1 0 1 0 0 0 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 1 1 1 1 0 1 1 1 0 0 1 0 1 1 1 0 1 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 0 0 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 1 1 1 0 0 1 0 1 1 0 1 1 1 0 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1 1 1 1 0 0 1 0 1 1 0 1 1 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 1 0 1 0 1 1 0 0 0 0 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 0 0 1 1 0 1 0 0 0 0 0 1 1 0 1 1 0 1 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 1 1 0 1 0 0 1 1 1 1 1 1 1 1 0 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 1 1)

       95.904258 (fv 0.000000 -0.184827 -0.106502 -0.094974 0.803466 0.945074 0.963289 0.946874 -0.103266 0.049155 1.087214 0.886218 0.016107 0.059052 1.086003 0.896052 0.832875 0.168267 0.929954 0.104821 0.801629 0.032075 0.032796 0.227531 0.906532 1.124909 1.032850 0.878053 0.813900 -0.267885 0.885447 1.090714 0.853533 -0.000373 1.207049 0.922018 0.048308 0.893672 0.856221 0.975035 0.868154 0.098949 0.791588 1.196055 0.919249 -0.152557 0.991948 1.006717 1.133320 1.186246 0.920884 -0.060763 0.895777 0.020781 0.811521 0.941459 0.931533 0.044866 -0.116604 0.896466 0.029517 1.096540 0.918555 0.948344 0.929326 1.133930 0.012583 0.960301 1.199033 0.051836 1.012281 -0.182278 -0.104579 0.982487 0.083391 -0.235240 0.238134 0.851365 1.147123 -0.183897 0.931617 0.014719 0.969454 0.114930 -0.007528 0.927332 0.038357 0.920680 -0.081674 -0.182395 -0.011442 1.061361 0.921566 -0.084353 1.041705 0.161045 -0.067878 1.074036 0.941106 0.966219 0.919599 1.168159 1.032081 0.945189 0.044320 0.039817 -0.089720 1.130429 -0.069569 -0.278003 0.838588 0.754892 0.905296 0.076030 0.931578 0.143938 -0.063198 0.009752 0.994216 -0.018389 1.061023 0.998466 -0.064949 0.889855 -0.094736 -0.151667 1.224271 -0.191231 0.981083 0.017183 -0.228680 -0.064528 -0.051088 0.940309 1.101261 -0.034752 0.950794 -0.088223 1.190759 0.000979 1.058816 1.106846 0.070946 0.194156 1.093892 0.886993 1.017953 -0.051739 -0.284107 0.024602 0.969253 1.247816 0.935610 -0.089803 0.006657 0.841177 1.059923 1.023429 0.866137 0.046390 -0.124782 -0.252595 0.166144 1.083896 1.139053 0.949050 1.094868 1.174455 -0.189695 1.188365 1.031424 1.009889 1.067591 0.935164 0.237409 0.909064 0.009677 -0.177665 0.046406 1.016694 1.057379 -0.055836 0.052713 -0.065039 0.120813 0.836055 1.178838 0.902715 0.920359 0.806116 -0.117471 1.158887 0.994531 -0.009494 -0.163337 1.040739 1.131213 0.025531 -0.009616 0.139395 0.950856 -0.014744 0.115132 1.125894 -0.190579 0.101124 -0.125308 0.963704 0.026526 1.118700 0.022614 0.807945 0.913877 0.030742 0.927436 0.988232 -0.140750 0.124385 0.986885 0.991816 1.146772 -0.062919 0.074766 -0.034226 1.128490 0.957963 1.096308 1.046278 -0.048364 0.116505 1.136521 1.090002 -0.014238 -0.112155 1.033034 1.160610 -0.094599 0.068313 1.266010 1.098976 0.044651 0.131033 -0.116651 -0.075950 1.046348 0.030055 0.793219 -0.117150 1.124225 -0.160989 1.100541 1.045178 0.962828 -0.073358 -0.019227 1.173791 1.059709 0.937667 0.966884 0.928018 1.041334 -0.201315 0.174562 1.021851 -0.049449 0.907458 -0.107815 1.126703 0.073928 0.982065 0.825831 -0.033241 0.067472 0.917284 0.902681 1.015596 0.904075 -0.075353 -0.108265 0.963265 -0.090615 0.920339 0.977780 0.090733 0.904078 0.000883 1.347356 1.014221 0.985375 -0.100963 0.008783 0.942615 1.002685 1.149002 0.158462 0.917602 -0.099583 -0.025442 1.103430 0.071006 -0.151207 0.055689 -0.038941 0.098832 0.911418 1.062737 0.996744 0.760254 0.996130 0.014262 0.032851 0.956371 0.019061 0.996091 0.200667 1.164966 0.045741 0.060264 1.166834 -0.025387 0.966912 1.043716 0.969667 1.084931 -0.065039 0.974364 0.980017 0.844958 0.179207 0.723395 1.083973 -0.074447 0.912360 1.089065 1.005958 -0.119354 1.049441 0.937401 0.912303 0.937357 0.078173 0.927334 -0.094425 0.851189 0.132753 0.133028 1.043045 0.054936 -0.083812 0.903122 1.042637 1.178266 -0.107401 1.047050 -0.128737 0.160133 0.840861 0.896100 1.126802 0.903407 0.262267 0.053879 0.947798 -0.144016 -0.003985 0.146029 0.074915 0.771488 1.227288 0.890268 0.933106 1.075829 0.057968 0.066132 0.249704 -0.017827 0.090465 -0.047385 -0.060718 0.123360 0.988529 0.904277 -0.005465 -0.084169 -0.247831 0.999998 0.910292 1.144645 0.071091 0.088886 1.023713 -0.025414 0.984571 -0.240585 0.967555 -0.138539 0.196983 1.010405 -0.049670 -0.081707 0.064139 0.997860 0.836573 1.161272 -0.021657 0.041743 -0.127308 0.045553 0.018541 -0.044739 0.088082 0.142342 0.114457 1.055260 1.064567 -0.119380 -0.070251 -0.004341 0.963091 -0.120638 0.258819 1.053558 0.878500 1.069022 -0.123646 -0.014321 1.121295 1.085748 -0.044674 0.870738 0.685253 -0.051358 1.001113 -0.231350 0.033853 0.961438 0.037712 -0.113045 0.108555 1.037350 1.011749 1.028331 -0.080798 0.196328 0.059651 0.046311 0.977929 0.955683 -0.011917 0.990010 0.826271 0.043303 1.009806 1.189345 0.021063 0.072917 0.057585 0.061242 0.879010 0.849055 1.018528 0.955494 -0.055041 1.189587 -0.028346 -0.082984 0.099423 -0.024146 0.146930 -0.067314 0.849801 0.213148 0.924340 0.080454 0.905046 -0.129837 0.863551 -0.015056 1.161555 -0.111647 0.827215 0.819815 1.100249 1.048851 0.084224 1.096872 0.064524 1.027164 0.125925 0.828778 -0.032148 1.059894 1.017072 0.834004 -0.032573 -0.063582 1.159025 1.022326 0.063607 1.022556 1.099517 0.097842 0.150138 1.115534 0.951150 0.988949 0.155650 -0.134289 -0.115258 1.037176 1.021182 0.975772 1.072700 1.222345 0.924272 0.973662 0.930252 0.059705 0.077967 -0.109443 -0.103486 0.972696 -0.144205 0.802195 0.975677 0.802607 -0.042079 1.071307 1.022073 0.907916 1.035902 -0.048853 0.907965 0.883285 0.084385 -0.108649 0.944568 0.005988 0.933534 1.065312 -0.070265 -0.076879 -0.017044 -0.098932 1.208925 0.930986 -0.119229 -0.037509 1.090406 0.992176 -0.000651 0.937690 0.916741 -0.066544 1.095679 -0.058814 1.036581 -0.051849 -0.017058 -0.030283 0.051491 0.954183 0.950362 -0.021757 -0.062612 1.017252 0.855360 0.008584 0.998471 0.053177 -0.102277 -0.071410 -0.113602 0.020219 0.047660 0.112990 0.815120 1.152303 1.067537 1.052888 0.004076 0.157730 0.930208 0.885789 0.948613 1.018989 0.998994 -0.098675 0.134960 0.084711 0.092822 0.103312 -0.196457 1.024530 1.108457 0.891294 1.054699 1.016928 -0.022703 0.811591 1.004965 -0.017036 0.232325 0.973190 1.052258 1.071581 1.167101 -0.078778 1.126544 0.054092 0.108866 0.166665 1.087490 0.998143 -0.013409 0.871172 0.885040 1.019108 1.127064 1.196444 0.957927 0.852239 -0.008268 -0.145143 1.063054 -0.026011 1.007974 0.983277 -0.031336 1.126868 0.969557 0.015995 0.940510 0.206836 -0.166196 0.069999 0.106477 0.969534 0.962793 1.057184 0.039570 1.013939 0.966957 -0.186086 1.043328 0.103727 0.826020 0.082145 0.142187 0.193131 0.806568 -0.194497 0.073921 0.929470 0.014750 1.003891 1.130669 0.912871 -0.166896 -0.010434 0.224001 0.019969 0.882091 1.015999 0.050540 0.927299 -0.028913 0.088865 -0.038210 0.838785 0.179969 -0.063760 0.909551 0.970913 0.864195 -0.147216 1.017549 0.931612 1.076838 0.174334 -0.004854 1.146351 -0.071188 0.005023 0.983870 0.987921 -0.073293 1.144937 -0.008273 1.069178 0.160218 0.940671 -0.099513 -0.160986 -0.053460 -0.000349 -0.066930 0.258818 0.037651 0.899944 1.011860 -0.024019 0.049159 -0.114396 0.997122 0.988277 -0.086170 1.100402 0.827506 -0.071549 1.014472 0.830365 -0.029296 1.033932 -0.095907 -0.073030 0.967696 1.060165 0.920338 1.199129 -0.072200 0.053416 -0.126898 1.108390 0.903008 1.109424 0.964135 -0.083890 0.099047 -0.111937 1.079528 1.230021 1.124700 0.946124 1.081677 -0.089364 1.123287 0.082817 -0.048549 0.013111 -0.005217 1.016286 0.025359 -0.151572 1.137235 1.013948 1.006359 -0.020039 -0.117293 1.111762 0.892597 1.058754 0.795600 0.996014 0.931963 1.115786 -0.029889 0.877043 -0.234877 1.149674 1.027911 1.261517 0.048880 0.113954 -0.024127 0.075365 -0.048636 0.036252 0.831941 0.943628 0.982317 0.918776 1.086510 0.931126 -0.077364 0.039915 1.020953 -0.068839 0.962253 0.910823 0.025853 0.065365 0.021206 -0.021296 0.872652 0.026536 -0.052762 0.003250 0.029539 0.991921 1.021217 -0.042456 0.777756 0.980840 0.078981 -0.130613 0.133311 -0.065841 -0.085861 1.178451 0.115564 1.082062 1.015392 0.928586 0.967073 1.156891 -0.010223 0.936469 -0.154645 0.995277 1.073333 -0.010159 -0.073318 1.117785 0.123446 0.035440 0.914424 0.055982 1.255170 0.975126 0.021080 -0.037628 1.048938 0.871136 1.107293 0.955878 -0.056277 1.017033 0.090456 0.993267 0.757034 1.002409 0.941223 0.920711 1.181339 0.032023 -0.085516 0.974206 -0.026907 0.142086 -0.002800 0.952901 1.119119 1.039547 0.762175 1.056838 -0.114595 0.884738 0.718220 0.960728 -0.156479 1.189199 -0.165202 0.904637 -0.041429 -0.050488 -0.179745 1.054673 -0.082418 0.030881 1.160170 0.821960 -0.086297 0.010350 0.932553 0.035420 -0.009593 0.011040 0.051718 0.904123 0.028769 0.100605 1.033920 -0.169584 1.086360 1.131494 0.107596 -0.114123 0.021393 0.010364 -0.152848 0.035197 0.012279 -0.133590 -0.062321 1.204840 0.937029 -0.068386 1.145671 0.973614 1.135843 0.883055 0.070061 0.997608 1.003482 0.989245 1.204030 1.197676 0.838535 0.029369 -0.215349 1.060468 0.880276 0.931456 0.125650 1.132780 -0.117697 0.200533 0.075686 1.191015 1.016195 0.037000 1.110074 0.982317 0.982573 0.824837 -0.229925 1.006482 -0.062451 -0.057872 0.979641 -0.230341 -0.020939 1.006077 0.857917 1.098933 -0.267219 0.043265 0.935436 0.964162 -0.007168 0.164970 0.165342 1.068220 0.945315 0.948634 1.023862 -0.029831 0.992343 0.020292 0.067126 0.932456 0.808919 0.096733 0.000609 0.083113 1.019237 0.858419 1.013183 0.098990 0.930352 -0.062223 1.082324 -0.042610 1.104376 0.999943 -0.136202 0.964477 -0.092847 1.096219 1.036690 1.110447 0.987439 0.893158 0.111588 -0.094486 0.748732 0.981962 1.023640 1.021660 0.931300 1.325728 0.988586 0.832724 0.042650 -0.080219 -0.124412 0.083378 -0.047165 0.013229 0.179035 1.036229 0.106634 -0.154080 0.015828 -0.138512 0.228898 0.970943 1.152854 0.994299 1.087348 1.079495 -0.014073 0.985630 1.046303 0.921605 -0.148486 -0.082307 1.049524 0.140156 1.012720 0.976567 0.874688 -0.045198 1.031276 0.883380 0.011846 -0.003498 1.009216 0.885002 0.172619 0.843282 0.029227 -0.097679 -0.125796 0.933874 0.978897 0.725114 0.844720 1.075252 0.947844 0.926610 0.182857 0.841432 1.040159 0.998281 0.169201 0.136041 1.216461 0.161331 -0.074244 1.061895 0.862101 0.118827 1.150273 1.131402 0.028905 0.802992 -0.116645 0.004795 -0.035171 -0.225349 -0.011793 1.004637 1.052814 0.132105 0.965384 1.075721 0.233900 0.952135 0.901143 1.131006 0.032321 1.011176 0.873840 0.182329 -0.079077 0.896822 0.005166 0.903099 1.092780 -0.025076 -0.019178 0.015239 0.984311 1.216486 0.992874 0.054129 0.144836 0.099554 0.103521 0.100432 -0.026631 0.042079 0.163741 1.041917 0.792159 0.979852 0.977128 0.103524 1.113377 -0.157199 1.027202 0.929073 1.074076 -0.112317 0.199279 0.760239 0.001430 1.277148 0.009244 0.986963 0.109581 1.086070 -0.134094 0.327295 0.686709 -0.296672 0.932890 0.968488 0.216488 0.165531 0.285075 -0.094601 -0.165028 0.950486 0.963591 0.864035 -0.065266 1.013992 0.911092 -0.094152 -0.152792 1.070739 -0.039448 1.166353 -0.004048 0.032871 0.996625 1.100064 1.255396 0.839630 -0.081969 0.162263 0.140738 1.003998 0.779814 0.961648 1.146742 0.167212 0.925641 1.185256 0.824157 -0.033666 -0.007601 0.908697 0.230017 0.822888 0.740994 0.033372 1.160544 1.098836 -0.044005 1.021078 0.126042 0.049334 0.898357 1.032574 0.865757 0.947486 0.886121 0.055309 0.044278 -0.037421 1.134951 0.864539 -0.011595 -0.007199 0.067683 1.090102 1.092557 0.046997 0.027613 0.949146 0.875265 0.136983 -0.135656 0.985803 -0.132003 0.135341 0.013222 1.091309 1.098115 0.015599 0.119349 0.014805 1.069340 1.102334 1.032680 -0.031084 0.906554 -0.088863 0.069579 1.064396 0.128172 1.022790 1.107156 -0.057182 0.995012 1.054566 1.042520 -0.160709 1.125070 -0.094154 0.046403 -0.069345 0.119373 -0.184893 0.070830 1.044722 1.098693 1.111409 1.135049 0.985119 0.066473 0.058424 1.004842 -0.094015 1.117752 0.799547 1.268968 0.039520 0.996895 -0.102408 -0.030667 0.930842 1.078283 1.102597 0.055578 0.110127 0.923904 1.005813 0.918634 1.079133 -0.099263 0.905943 1.047321 0.848243 -0.009403 -0.068258 1.012623 -0.037975 1.142196 0.851851 0.109046 1.141382 0.890904 0.996832 -0.088058 1.288646 1.097971 -0.100491 0.918525 0.015332 1.145115 0.117738 1.014796 -0.205627 -0.177297 -0.006318 0.055035 1.183699 0.900390 1.055439 1.182836 0.107470 0.210820 -0.154634 1.100666 0.004257 0.125613 0.849489 1.120995 -0.046236 -0.066772 0.011079 -0.102932 0.932197 0.023264 0.246085 0.163405 0.869069 0.102531 1.077511 0.954854 0.038602 0.079792 0.927047 0.983181 1.030696 0.962590 -0.055603 -0.107934 1.126555 0.946728 1.063664 0.137033 -0.128875 0.885196 0.091522 0.893839 1.007955 0.978475 0.978266 0.067848 1.038168 1.090875 -0.061309 1.116028 1.016019 0.011872 -0.108054 0.108874 0.083760 0.113696 1.116111 0.014309 0.005128 1.099189 -0.004973 1.325065 1.221479 0.028469 1.235019 -0.212490 0.962518 1.027151 -0.044149 0.142639 0.155400 0.936540 -0.039180 0.937115 -0.085578 1.019973 1.270603 0.140594 0.061038 1.087655 0.063712 1.177018 -0.029958 0.758319 0.051019 -0.094233 0.962416 -0.006348 -0.003660 0.019678 1.112579 1.058837 -0.108754 0.005081 0.979604 0.909652 -0.162160 0.189741 1.115396 -0.046934 0.809487 0.174222 -0.004756 1.140939 0.812895 0.050537 0.171915 -0.128895 0.969610 0.953147 1.047572 0.122563 0.889198 -0.104048 0.001916 -0.008785 1.172703 -0.213570 -0.114233 -0.152007 -0.161789 -0.132968 1.055565 0.784424 0.202349 -0.012066 0.004158 -0.039121 1.114936 0.962613 0.954226 1.105200 0.985756 1.026320 -0.117780 0.866616 1.000189 -0.163224 0.999105 1.165142 0.001717 1.023313 -0.052468 -0.233246 -0.078417 -0.014831 0.008989 0.105092 1.100102 -0.114187 0.962275 0.827359 -0.135499 1.155899 0.983914 -0.197096 0.920622 0.925756 0.074101 1.105182 0.068112 0.889324 0.995794 -0.181975 1.079197 -0.174077 -0.086147 1.108775 0.836038 0.920177 0.069115 1.056833 1.065288 1.011220 0.037095 -0.051383 0.059023 0.966919 0.975420 0.992209 -0.050411 1.034776 0.060947 0.024827 0.189251 1.128565 -0.026102 0.882647 1.113292 0.059688 -0.055524 1.097931 -0.076831 0.148308 0.009684 0.993343 0.181407 0.980680 -0.253676 1.203786 0.837538 -0.111906 -0.046920 0.992998 1.138650 0.102810 0.732933 0.974495 1.134363 0.841220 -0.244832 0.191984 1.089926 -0.014286 1.033093 0.795315 0.027888 1.086315 0.921910 0.023081 1.023830 0.070684 1.183612 -0.197469 -0.072227 1.175515 1.132615 0.147372 1.165071 0.693358 0.086944 0.167356 1.154251 0.067038 1.011388 0.195281 0.162053 0.058855 0.118483 1.091391 1.199083 0.861074 0.152693 -0.184650 -0.275426 0.016699 1.041744 1.082925 0.896020 -0.212005 -0.028325 0.837564 1.192865 0.964038 1.140280 0.832699 0.060523 1.017736 0.007067 1.222558 0.776881 1.025602 0.136510 1.065558 0.031534 1.120667 -0.017440 -0.095844 0.986588 0.811881 1.008160 1.083596 -0.057608 1.030774 -0.185755 1.016553 -0.060277 0.044570 0.071469 1.026382 -0.218238 -0.134819 0.125155 1.052665 0.219534 1.053074 0.975626 0.942097 0.042773 0.914988 0.904458 1.068383 0.122945 -0.160737 0.195111 -0.112309 0.079404 0.873713 0.743694 -0.042029 0.017013 1.026689 -0.033216 0.846494 1.151063 -0.096712 0.933521 -0.150138 0.998351 0.097766 1.014397 1.003826 0.249110 -0.089820 -0.095115 -0.041617 1.005328 -0.026956 0.282608 -0.227117 0.900497 0.151081 1.074944 0.999410 0.070956 0.989252 1.046830 0.036838 0.060586 0.119680 1.033878 1.147593 1.072223 1.038019 -0.063806 -0.066418 -0.094579 0.121532 0.058665 0.065637 0.015630 1.033625 -0.167401 -0.044227 0.109799 1.069494 0.978455 0.951966 0.848373 1.183717 0.052564 -0.139052 0.109210 1.056692 1.084067 0.913136 0.026099 0.888367 1.004145 -0.006357 -0.186626 1.147417 0.008987 1.033956 0.198511 1.087879 0.153898 -0.007073 -0.053729 0.960733 -0.079153 -0.112602 0.118601 1.127696 0.124208 -0.118455 1.113389 -0.141400 0.095581 0.831887 0.079625 1.065606 1.064953 -0.043117 0.883460 -0.117838 0.984417 1.073930 -0.020071 -0.020565 -0.110661 -0.029427 0.000735 0.129840 -0.059144 0.853604 0.029159 1.153760 -0.035371 0.120975 0.829886 0.902305 0.004019 1.024841 -0.008315 -0.040841 0.081011 0.034157 0.925135 0.026143 -0.146226 0.818801 0.997553 -0.057337 0.039344 0.045043 -0.058730 0.061450 0.034397 0.032312 1.021479 0.069734 0.032385 -0.034352 1.143739 0.128130 0.837756 0.143447 1.191780 1.005715 -0.145746 0.060156 -0.089751 0.993522 1.117964 1.113924 -0.051214 0.989301 1.131346 0.978070 1.120586 -0.104089 0.755209 0.911168 0.043338 0.799533 -0.065789 1.035956 1.103884 1.108033 -0.011160 0.018199 1.076458 1.033226 1.049461 0.927281 0.875446 -0.132488 -0.016539 1.040494 -0.085837 0.845351 0.082137 0.957295 0.975488 -0.233161 1.046308 0.968283 1.119329 0.799388 0.835437 1.198178 1.006967 -0.080996 1.022071 0.222670 1.054955 1.028112 0.145964 0.775125 0.053077 -0.139928 0.982870 0.012204 1.181785 -0.055209 0.064440 0.028436 -0.055658 0.988257 0.885626 0.925751 1.041503 -0.102556 0.199169 0.817618 1.118232 -0.154162 1.103379 0.161217 0.043204 0.038827 0.297793 0.101115 1.084585 0.911258 -0.017387 1.093864 1.174369 -0.052884 1.010587 1.084918 1.042023 0.988052 1.008470 1.079842 0.911711 -0.105412 1.049916 0.966051 -0.030853 0.634323 0.027996 0.065373 0.165603 -0.198745 0.121133 0.904870 0.798116 0.109313 -0.023197 -0.012270 -0.099679 -0.007982 0.957938 0.064886 1.066324 0.891833 0.030809 0.008848 -0.058683 1.151904 -0.064909 0.005548 0.092447 0.994226 0.980543 0.036553 0.977629 0.908112 1.053035 1.015332 1.120582 1.029707 0.935519 0.767415 -0.107332 1.106993 0.051063 -0.090849 -0.152447 1.074408 0.930237 -0.134191 -0.041339 1.154220 0.912402 0.915882 -0.155688 0.004278 1.005960 -0.029173 0.929692 0.891253 0.904414 -0.022210 0.912185 0.032760 -0.175809 1.064184 0.004444 1.023131 0.014814 0.025559 0.065555 0.781532 -0.029379 -0.197955 0.897852 -0.013217 1.093294 0.004968 -0.102189 1.031592 0.748643 0.996666 0.053363 -0.174095 0.022123 1.073767 0.026629 0.817199 0.923850 0.016734 1.000997 0.181206 0.011231 0.956073 0.190711 0.864217 -0.176983 1.016978 1.028389 0.023092 0.841323 1.197465 -0.032185 -0.023935 -0.154948 0.938794 0.022079 0.018001 0.863273 0.095137 -0.103529 1.048691 1.044424 1.076913 -0.091685 1.016448 0.235867 -0.191122 1.021688 0.903834 1.103008 1.062811 0.974671 0.808982 0.919788 0.797299 0.003866 0.924240 1.138022 1.138392 -0.086041 -0.072381 1.089510 0.997304 -0.196238 -0.081117 0.998652 -0.136927 1.094476 1.025478 1.128812 -0.043799 -0.160622 1.202644 -0.097115 1.028359 1.128248 1.149200 0.046912 1.215106 0.095300 0.230991 -0.177631 1.060265 0.025009 -0.087069 -0.045585 0.107297 0.905981 1.067101 1.105134 0.200901 0.832244 -0.158358 0.063741 -0.002433 0.178939 1.150184 -0.013758 0.739082 0.970621 1.116445 -0.077580 0.874011 -0.000811 0.757786 1.027494 0.948749 0.128206 1.197540 -0.121973 -0.035650 0.227456 1.012591 0.093402 0.788900 0.046330 1.127347 0.937960 0.147998 0.295156 0.047168 -0.449697 1.185666 1.027567 1.056837 0.896828 0.093411 0.188188 1.051113 0.196550 0.986178 0.963111 1.064836 0.986799 0.068409 0.940694 0.044600 0.930849 0.776664 1.119660 0.877476 -0.187121 0.889222 0.896426 1.114193 0.109176 0.974296 0.017034 0.058848 0.003626 -0.056434 -0.053055 -0.327863 1.110462 1.191687 0.833810 -0.093180 1.062518 0.877602 0.130458 1.046517 0.945395 -0.042202 0.884421 0.076614 0.998365 0.963405 -0.042360 1.233324 1.032498 0.850640 0.878991 1.172081 -0.131938 0.138522 1.031223 -0.060356 1.045766 1.146384 1.014251 1.035122 1.033944 0.910994 0.140291 0.017496 0.074785 0.017803 1.051564 0.940908 1.102397 0.914000 -0.151381 -0.037398 0.841172 0.980431 0.926522 1.010521 0.906633 0.898542 -0.046207 1.056040 -0.119697 -0.388635 1.042092 1.062407 -0.114191 0.973897 0.038767 0.170771 0.104476 0.108748 0.973779 0.829369 0.903094)
       )
     )
  )


;;; ---------------------------------------- even-numbered harmonics (and fundamental) ----------------------------------------

(define neven-min-peak-phases (vector 

(vector 1 1.0 (fv 0)
    )

(vector 2 1.7601724863052 (fv 0 0)
    )

;;; 3 even --------------------------------------------------------------------------------
(vector 3 2.2325525283813 (fv 0 0 0)
    2.0235652605711 (fv 0 33/64 63/128)

    2.0214650630951 (fv 0.0 0.52414411306381 0.48787820339203)
    2.021465 (fv 0.000000 0.475854 0.512123)
    2.021465 (fv 0.000000 0.524145 0.487877)
    2.021465 (fv 0.000000 1.475854 1.512123) ; etc
    )

;;; 4 even --------------------------------------------------------------------------------
(vector 4 2.8359191417694 (fv 0 0 0 0)
    2.450505601523 (fv 0 3/16 21/32 15/32)

    ;2.434727537119 (fv 0 37 52 46) / 31

    2.4311048984528 (fv 0.000 0.191 0.672 0.479)
    2.4311048984528 (fv 0.000 0.809 0.328 0.521)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.8359191417694 (fv 0 0 0 0))
    2.4308773660653 (fv 0.0 -1.907463741733863571425899863243103027344E-1 -6.709215487223971763341978657990694046021E-1 -4.783757035623090736464746441924944519997E-1)

    ;; (optit :even 4 1/4 (expt 2 -100) 2.450505601523 (fv 0 3/16 21/32 15/32))
    2.430877366065 (fv 0.0 1.907463741737958073940717440564185380936E-1 6.709215487230322239042834553401917219162E-1 4.783757035631506226991405128501355648041E-1)
    2.4305741786957 (fv 0.0 0.19146482345276 0.67236139177392 0.47990912646831)
    )

;;; 5 even --------------------------------------------------------------------------------
(vector 5 2.816308259964 (fv 0 1 0 0 0)

    2.6048328876495 (fv 0.0 1.7889379262924 0.49464252591133 0.018512051552534 0.013387856073678)

    2.604848 (fv 0.000000 0.211049 1.505353 1.981536 -0.013355)
    )

;;; 6 even --------------------------------------------------------------------------------
(vector 6 2.9795869831363 (fv 0 0 1 0 0 0)

    2.8369779013614 (fv 0.0 0.17925976781335 1.4035822186281 0.79344665247706 0.91203230191116 1.0958477007498)

    2.836991 (fv 0.000000 0.178390 1.402472 0.792230 0.912414 1.093877)
    2.836980 (fv 0.000000 1.821818 0.597785 1.208038 1.087532 0.906567)
    2.836978 (fv 0.000000 1.178373 0.402442 1.792189 1.912334 0.093818)
    2.836972 (fv 0.000000 1.178483 0.402570 -0.207680 -0.087726 0.094035)
    2.836966 (fv 0.000000 0.821717 1.597697 0.207985 0.087685 -0.093549)
    2.836953 (fv 0.000000 0.821609 1.597559 0.207843 0.087745 -0.093780)
    )

;;; 7 even --------------------------------------------------------------------------------
(vector 7 3.3825581073761 (fv 0 0 0 0 0 1 0)

    3.0470769405365 (fv 0.0 0.503662109375 0.87483215332031 1.0009307861328 1.2656555175781 0.71012878417969 0.30850219726562)
    3.0469672679901 (fv 0.0 0.50373814372209 0.87540721456314 1.0012873875657 1.2663739438299 0.71078327011007 0.30959991380794)
    3.046965 (fv 0.000000 0.503616 0.874674 1.000689 1.265332 0.709676 0.308046)
    )

;;; 8 even --------------------------------------------------------------------------------
(vector 8 3.611234664917 (fv 0 0 0 0 0 1 0 0)

    3.197691 (fv 0.000000 1.463442 0.984712 1.413077 0.862890 0.889575 1.684691 1.613214)
    3.197689 (fv 0.000000 0.536983 1.016250 0.588185 1.138902 1.112562 0.318083 0.389844)
    3.197673 (fv 0.000000 0.463394 -0.015494 0.412641 1.862274 -0.111008 0.683799 0.612199)
    3.197643 (fv 0.000000 1.536907 0.016088 1.587997 0.138641 0.112256 1.317694 1.389405)
    3.197539 (fv 0.000000 1.536753 0.015811 1.587753 0.138248 0.111716 1.317048 1.388715)
    )

;;; 9 even --------------------------------------------------------------------------------
(vector 9 4.0601739883423 (fv 0 0 0 0 0 0 1 1 0)

    3.454235 (fv 0.000000 1.380130 1.542684 1.103203 1.094600 0.755189 1.642794 1.504783 0.092364)
    3.454343 (fv 0.000000 0.380149 0.542653 0.103243 0.094157 1.755278 0.642603 0.504207 1.092117)
    3.454167 (fv 0.000000 1.619814 1.457133 1.896576 1.905245 0.244460 1.356830 1.494866 0.907164)
    3.454104 (fv 0.000000 1.619789 1.457225 1.896592 1.905347 0.244468 1.356940 1.495046 0.907280)
    3.453978 (fv 0.000000 1.619848 1.457320 1.896841 1.905503 0.244896 1.357384 1.495389 0.907798)
    )

;;; 10 even --------------------------------------------------------------------------------
(vector 10 4.0054845809937 (fv 0 1 1 0 0 0 0 0 1 0)

     3.559069 (fv 0.000000 0.728493 1.283356 1.458356 0.068046 1.297046 -0.008724 1.763762 1.458102 1.082546)
     3.559031 (fv 0.000000 1.271816 0.716134 0.541742 -0.068143 0.702758 0.008941 0.237259 0.543599 0.918279)
     3.558934 (fv 0.000000 0.270311 1.713387 1.540231 0.930533 1.700561 1.006089 1.239216 1.544459 1.919820)
     3.558711 (fv 0.000000 0.271020 1.715408 1.541006 0.931409 1.702058 1.007613 1.237445 1.543048 1.918285)
     )

;;; 11 even --------------------------------------------------------------------------------
(vector 11 4.2368197441101 (fv 0 0 1 1 0 1 1 1 0 0 0)

     3.656997 (fv 0.000000 0.364553 0.246524 0.545081 1.820586 -0.010486 0.065265 0.895857 0.689390 0.398119 1.238723)
     3.656853 (fv 0.000000 0.636042 0.753996 0.455733 1.180490 1.011649 0.936897 0.106845 0.312362 0.605377 1.764604)
     3.656814 (fv 0.000000 1.363823 1.245209 1.543687 0.818338 0.986715 1.061848 1.892251 1.683956 1.393470 0.233084)
     3.656676 (fv 0.000000 1.635670 1.752596 1.453762 0.177717 0.008296 -0.065661 1.103599 1.306278 1.601279 0.759437)
     3.656141 (fv 0.000000 1.635206 1.752773 1.453484 0.177816 0.008586 -0.066147 1.102294 1.308244 1.599463 0.758738)
     )

;;; 12 even --------------------------------------------------------------------------------
(vector 12 4.4100483425078 (fv 0 0 0 1 1 0 1 0 0 0 0 0)

     3.787770 (fv 0.000000 1.448638 0.653979 0.460567 1.750296 1.187409 1.823828 0.621465 0.835166 0.896814 0.649295 0.954712)
     3.787607 (fv 0.000000 1.552098 0.349619 0.543969 1.255255 1.818801 1.184427 0.387699 0.175349 0.115468 0.364328 0.059990)
     3.787594 (fv 0.000000 0.551763 1.347551 1.541126 0.252553 0.815620 0.180247 1.383525 1.170726 1.109400 1.357991 1.052935)
     3.786929 (fv 0.000000 0.551301 1.345490 1.538545 0.249324 0.811835 0.175379 1.377915 1.164645 1.102028 1.349918 1.044104)
     )

;;; 13 even --------------------------------------------------------------------------------
(vector 13 4.4076361656189 (fv 0 0 1 0 1 1 0 0 1 1 1 1 1)

     3.973518 (fv 0.000000 1.227848 0.569459 0.032525 1.602849 0.995992 1.561449 0.851502 1.005100 0.700156 1.033637 1.225072 1.740227)
     3.973285 (fv 0.000000 0.221343 1.559694 1.013474 0.580564 -0.035047 0.522724 -0.190833 -0.044249 1.645456 -0.025041 0.160741 0.667019)
     3.973148 (fv 0.000000 0.225623 1.564256 1.022022 0.590378 -0.019884 0.539658 -0.171656 -0.022033 1.670109 0.001495 0.190555 0.699291)
     3.973041 (fv 0.000000 0.226214 1.565751 1.024299 0.592784 -0.015292 0.545848 -0.164098 -0.014254 1.677783 0.010954 0.201582 0.710821)
     3.972554 (fv 0.000000 0.227025 1.566229 1.025033 0.594027 -0.014872 0.545046 -0.165560 -0.014836 1.678196 0.010096 0.200561 0.709954)
     )

;;; 14 even --------------------------------------------------------------------------------
(vector 14 4.5770673751831 (fv 0 1 1 0 0 1 1 1 1 1 1 0 1 0)

     4.097747 (fv 0.000000 0.927497 0.986240 1.222647 1.417439 1.485272 1.245695 0.840056 0.775783 1.393795 0.027626 0.815063 1.945062 1.449403)
     4.096703 (fv 0.000000 0.927014 0.985352 1.221418 1.415761 1.483290 1.243140 0.836933 0.772657 1.390170 0.023348 0.810693 1.940171 1.444293)
     )

;;; 15 even --------------------------------------------------------------------------------
(vector 15 4.7838921546936 (fv 0 0 0 0 0 1 1 1 1 0 1 1 1 0 1)

     4.193545 (fv 0.000000 1.673990 1.704095 0.184742 0.312157 1.759699 0.661838 0.338558 1.336129 0.060082 0.592895 0.470075 0.323799 1.690560 1.851587)
     4.193539 (fv 0.000000 1.674972 1.705674 0.187574 0.315997 1.764079 0.667192 0.344813 1.343115 0.068186 0.601740 0.479341 0.334140 1.702389 1.863580)
     4.192089 (fv 0.000000 1.673474 1.702683 0.182852 0.310553 1.756894 0.658556 0.335052 1.332116 0.055950 0.587971 0.464438 0.317829 1.684035 1.844319)
     )

;;; 16 even --------------------------------------------------------------------------------
(vector 16 5.0737318992615 (fv 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 0)

     4.326467 (fv 0.000000 0.954646 0.857741 0.564427 0.380619 -0.030405 0.027220 0.443651 0.347240 0.290827 1.057423 1.274647 0.193509 1.337335 0.715554 1.355809)
     4.326323 (fv 0.000000 0.953094 0.856111 0.562335 0.378555 -0.035716 0.021343 0.437774 0.341052 0.283988 1.049334 1.266917 0.184364 1.326298 0.704383 1.343207)
     4.325044 (fv 0.000000 0.953571 0.856165 0.561119 0.376819 -0.035768 0.021241 0.436352 0.339200 0.281830 1.047126 1.263828 0.181703 1.324018 0.701028 1.340302)
     )

;;; 17 even --------------------------------------------------------------------------------
(vector 17 5.2332563400269 (fv 0 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 0)

     4.464096 (fv 0.000000 1.478399 1.021179 1.293532 1.222041 1.188322 1.479616 1.284032 0.091138 1.349289 0.401522 0.364537 -0.044880 1.268488 1.386805 0.039323 0.607489)
     4.463016 (fv 0.000000 1.478182 1.023133 1.293051 1.222719 1.187462 1.479990 1.285327 0.088371 1.348357 0.403976 0.365587 -0.044469 1.267681 1.387786 0.039745 0.610112)
     )

;;; 18 even --------------------------------------------------------------------------------
(vector 18 5.3310880661011 (fv 0 1 1 1 1 0 0 1 0 1 1 0 0 0 1 0 0 0)

     4.569421 (fv 0.000000 1.011793 0.580064 1.185332 1.624771 0.036509 -0.103084 0.721775 1.089226 0.493658 0.073953 1.074825 1.595710 1.108207 1.196849 1.497424 1.163445 0.995437)
     )

;;; 19 even --------------------------------------------------------------------------------
(vector 19 5.4619059562683 (fv 0 0 1 0 0 0 0 0 0 0 1 0 0 1 1 1 0 0 0)

     4.741489 (fv 0.000000 1.217162 0.660633 0.437661 1.320878 1.235636 0.094939 -0.184508 -0.090396 0.415156 1.119340 1.141612 0.652398 0.817014 0.525642 1.150459 0.295913 0.906911 0.831168)
     )

;;; 20 even --------------------------------------------------------------------------------
(vector 20 5.5266017913818 (fv 0 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 1 0)

     4.839482 (fv 0.000000 0.882739 0.097549 0.018330 1.302731 0.272028 1.407538 1.702479 0.580972 1.045015 0.992304 1.669564 0.673981 0.282219 0.289947 0.363499 1.033218 0.803741 0.771035 0.508087)
     )

;;; 21 even --------------------------------------------------------------------------------
(vector 21 5.6849967470046 (fv 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0)

     4.919735 (fv 0.000000 -0.021966 1.377831 1.499470 -0.139205 1.937761 0.320320 0.217546 0.069290 0.938854 1.308616 0.123782 0.469963 1.818882 1.581666 1.414927 0.056553 1.301602 0.788305 1.336052 0.607478)
     )

;;; 22 even --------------------------------------------------------------------------------
(vector 22 5.8572781078687 (fv 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 0 0)
     
     5.055233 (fv 0.000000 -1.550778 1.843415 0.900724 0.955590 0.677531 1.390686 0.133831 1.229871 1.016503 1.245622 1.546957 -1.869615 1.414871 -0.060378 -0.077148 1.210164 1.132173 0.909114 1.325478 1.285781 0.509617)
     )

;;; 23 even --------------------------------------------------------------------------------
(vector 23 5.9208135892745 (fv 0 0 1 0 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 0 0 0 0)

     5.147900 (fv 0.000000 0.493561 0.617878 0.386087 -0.215675 1.136922 0.632292 0.891205 1.398746 0.878537 0.676611 0.945565 0.610792 -0.182076 0.354229 1.383426 1.649635 0.414770 0.152656 0.561509 0.267633 1.102796 1.466348)
     )

;;; 24 even --------------------------------------------------------------------------------
(vector 24 6.0318420391191 (fv 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 1 1 1 1 1 0)

     5.253162 (fv 0.000000 0.045084 0.641921 -0.205904 0.266767 1.228115 0.912709 0.214922 1.487762 1.357882 0.864877 0.404420 0.601935 0.594931 0.069420 1.052347 1.659787 1.624121 0.035857 0.245103 1.406872 0.042697 -0.053953 0.167577)

     ;; nce:
     5.253153 (fv 0.000000 0.045202 0.642246 -0.205352 0.266926 1.228585 0.913398 0.215740 1.488650 1.358650 0.865965 0.405240 0.603061 0.596132 0.070695 1.053498 1.661316 1.625634 0.037488 0.246663 1.408918 0.044558 -0.052337 0.169870)
     )

;;; 25 even --------------------------------------------------------------------------------
(vector 25 6.1513186981755 (fv 0 0 1 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 1 1 1)

     5.403228 (fv 0.000000 0.045060 1.794212 1.406802 1.249045 0.257853 0.430644 -0.020674 0.209605 1.159346 1.742584 0.244624 1.006989 0.948352 0.613996 0.229169 0.745474 0.773295 0.271006 1.529917 0.384835 1.822065 0.327936 0.153008 0.689262)

     ;; nce:
     5.408253 (fv 0.000000 -0.043635 1.870808 1.373617 1.322838 0.337670 0.345509 0.039602 0.231587 1.174477 1.746219 0.272425 1.051956 0.894710 0.701095 0.201178 0.713607 0.745859 0.396015 1.495521 0.465720 1.748739 0.254514 0.207309 0.670746)
     )

;;; 26 even --------------------------------------------------------------------------------
(vector 26 6.2921685546205 (fv 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 0 0 1 0 0 1 1 0 0)

     5.452331 (fv 0.000000 0.051327 0.204117 1.807782 0.408597 -0.021081 0.115796 0.407761 0.824888 0.626144 0.637118 0.067354 0.844059 0.574978 -0.127497 -0.091341 1.702516 0.546084 0.986055 1.260143 0.631019 1.781357 1.305578 1.812413 0.666374 0.989339)
     )

;;; 27 even --------------------------------------------------------------------------------
(vector 27 6.2436904245852 (fv 0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1)

     5.620374 (fv 0.000000 -0.021456 0.516604 0.372410 0.864531 1.336703 -0.209149 1.689313 0.033950 1.772624 0.571345 1.616802 0.355488 1.092886 1.391271 1.240098 1.111612 0.854249 0.888716 0.157123 -0.311986 1.252460 1.082038 -0.272435 1.564985 0.964546 1.600742)
     )

;;; 28 even --------------------------------------------------------------------------------
(vector 28 6.5361909866333 (fv 0 0 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 1 1 1)

     5.731679 (fv 0.000000 1.447589 1.395977 0.797533 1.295906 1.462640 1.534875 1.774902 1.013697 0.705377 0.626264 1.242696 1.362454 0.181714 0.805604 1.271981 0.570662 1.779635 -0.124462 1.352040 -0.225912 1.764222 0.153642 1.298969 0.773437 0.201599 0.803480 0.102660)

     ;; nce:
     5.757769 (fv 0.000000 -0.064452 1.194800 0.947245 0.026529 0.920008 0.673833 0.051447 -0.007043 1.637680 1.814843 1.945096 0.720067 0.530198 0.753640 0.603773 1.296939 0.860024 0.197512 0.571117 0.903138 1.152266 0.326717 0.457781 -0.069831 0.864587 1.677694 0.471749)
     )

;;; 29 even --------------------------------------------------------------------------------
(vector 29 6.6767044067383 (fv 0 1 0 0 0 1 0 1 0 1 1 1 0 0 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1)

     5.766338 (fv 0.000000 1.750571 1.825931 1.106253 0.681108 0.654013 0.530242 0.078216 0.174544 1.354195 1.454712 1.045782 1.722411 1.607453 0.347380 0.849326 0.377709 1.136286 1.004911 0.970793 0.410809 0.919085 1.010160 0.193230 0.966878 0.662369 1.289507 1.533180 0.429508)
     )

;;; 30 even --------------------------------------------------------------------------------
(vector 30 6.6998701095581 (fv 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0)

     5.906955 (fv 0.000000 0.906624 1.374273 1.276597 -0.178673 0.094922 0.333601 0.129339 0.400307 0.946356 1.401096 0.557587 0.654474 1.274947 0.061009 -0.048005 1.903626 1.753056 1.439902 1.944968 1.607217 1.115332 0.419220 1.617499 1.734563 1.091117 0.095163 0.781775 -0.001559 1.852411)

     ;; nce:
     5.930402 (fv 0.000000 -0.023546 1.489564 1.475097 0.916826 0.864026 1.899229 1.607559 0.910332 0.924096 1.371927 0.795577 0.542873 0.396054 0.844978 1.658639 0.174074 0.939529 1.326938 1.039010 1.301858 1.417763 1.619561 1.723680 0.850267 0.018519 1.089727 0.405902 1.206335 1.833260)
     )

;;; 31 even --------------------------------------------------------------------------------
(vector 31 6.8660564422607 (fv 0 1 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 0)

     5.987789 (fv 0.000000 1.294084 1.380328 1.151198 1.131917 1.032100 1.467500 1.317593 1.561230 1.149337 1.426512 0.310391 0.093956 -0.092069 1.618651 0.385482 1.276093 0.768907 0.092705 1.372235 0.935730 0.030657 0.353616 1.817773 0.372502 0.700675 1.341184 1.537494 1.331726 0.302069 0.818207)
     )

;;; 32 even --------------------------------------------------------------------------------
(vector 32 6.9974670410156 (fv 0 0 0 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 0)

     6.061091 (fv 0.000000 0.284769 1.824838 0.360868 1.114185 0.962149 1.153553 1.836957 0.183317 1.504519 0.431670 1.106470 0.465083 1.359049 1.532974 1.672623 0.833072 1.851412 -0.259099 1.829526 0.240313 0.782734 0.067562 1.704922 0.670838 0.000337 1.835105 1.184487 1.464400 1.660678 0.971147 1.137597)
     )

;;; 33 even --------------------------------------------------------------------------------
(vector 33 6.978609085083  (fv 0 0 0 0 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 1 0 1 1 0)

     6.162617 (fv 0.000000 -0.095863 -0.402980 1.394421 -0.306134 0.366840 0.337119 0.377845 0.129322 0.155850 1.349812 0.235845 0.252319 0.242909 1.431344 1.664418 1.236043 1.670315 1.653641 0.461681 0.695631 0.916345 0.353418 1.885954 1.309177 0.582371 1.382992 1.788982 0.399357 0.760664 0.154447 0.882692 0.073082)
     )

;;; 34 even --------------------------------------------------------------------------------
(vector 34 7.2615523338318 (fv 0 1 0 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 1 1 1 1 1 0 0)

     6.222816 (fv 0.000000 -0.031974 0.094234 0.502100 0.850042 0.574691 0.752336 1.914959 -0.024174 0.146232 0.295078 1.383128 -0.007584 0.943763 1.235227 0.413741 0.587141 -0.053979 1.839683 0.252526 0.156123 0.682869 0.409598 -0.127649 0.823619 0.505563 1.228553 1.452425 1.154757 0.224780 1.122198 1.589227 1.075252 0.529430)
     )

;;; 35 even --------------------------------------------------------------------------------
(vector 35 7.2921919822693 (fv 0 0 0 0 0 1 0 1 1 1 0 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 0 0 0)

     6.362258 (fv 0.000000 -0.109595 1.553671 0.219728 0.238496 1.170971 0.131935 0.808676 1.471325 1.403853 0.916637 1.560710 -0.099827 1.196395 0.221158 1.202313 0.775632 0.876517 1.782554 1.124579 1.420710 0.952275 0.641256 1.819844 1.425015 -0.516862 1.352551 1.568353 1.482981 0.524776 0.577204 0.865347 -0.128894 -0.102429 0.426519)
     )

;;; 36 even --------------------------------------------------------------------------------
(vector 36 7.3326554298401 (fv 0 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0)

     6.432117 (fv 0.000000 0.004340 0.086403 1.388728 0.898065 1.458617 0.131985 1.657435 1.521273 1.472417 0.951218 1.324245 1.241442 1.395549 0.150266 1.064974 0.650640 1.427046 1.086279 0.098701 0.328772 1.795832 1.461165 0.857821 1.693245 1.032679 1.245848 0.174782 -0.135078 0.155045 -0.013817 0.388292 0.719587 1.603641 0.575715 0.836424)

     ;; nce:
     6.433446 (fv 0.000000 -0.039571 0.060618 1.408936 0.882042 1.447670 0.143068 1.639607 1.518329 1.469129 0.942793 1.305387 1.226395 1.375800 0.162353 1.047466 0.675921 1.406954 1.102981 0.111251 0.337382 1.829176 1.494772 0.804464 1.712328 1.039053 1.250692 0.166362 -0.143216 0.133112 -0.012403 0.370517 0.701621 1.606484 0.581751 0.854317)
     )

;;; 37 even --------------------------------------------------------------------------------
(vector 37 7.4919209480286 (fv 0 1 1 0 0 1 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 0 0 0 1 0 0 0 0 0 0)

     ;; ce:
	6.533287 (fv 0.000000 0.011564 0.880733 1.522736 0.250376 0.789024 1.673119 0.570623 1.276735 0.341425 -0.532081 0.348007 -0.836598 0.457646 -0.009210 1.409326 1.013302 0.369886 1.439731 1.104224 1.371479 0.882940 0.611993 0.167228 0.213651 -0.123007 -0.145430 -0.035562 0.326284 0.342544 0.027533 0.469211 0.589131 1.242729 -0.350729 -0.122043 0.359222)
     )

;;; 38 even --------------------------------------------------------------------------------
(vector 38 7.669114112854 (fv 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 0 0 0 0 0 0 0)

     6.536590 (fv 0.000000 -0.020563 1.377251 1.769036 0.243537 1.765876 1.779834 1.045673 1.286350 0.293614 0.321305 1.723518 1.560003 0.401205 0.333918 -0.059485 0.232219 0.960903 1.594163 1.401434 0.649608 0.412099 1.329747 0.099455 1.939824 0.267997 0.403580 1.515217 0.579512 0.002234 0.262847 1.800156 0.419089 1.615975 1.110793 1.305676 1.421012 1.714827)
     )

;;; 39 even --------------------------------------------------------------------------------
(vector 39 8.0062685830938 (fv 0 0 0 1 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 1 1 0 1 1 0 0 0 0)

     6.683157 (fv 0.000000 1.091390 0.284404 0.240879 1.660743 1.656550 0.223587 1.552502 0.232972 0.325977 1.767287 0.511127 0.573904 0.685387 0.354731 1.006014 0.648089 0.445081 1.696394 0.327980 -0.210151 0.338005 -0.052572 -0.119111 0.551717 1.087945 0.035621 1.385382 0.802270 1.342811 0.005749 0.410111 0.489512 1.361009 1.309724 1.490142 1.368577 0.636471 0.518214)
     )

;;; 40 even --------------------------------------------------------------------------------
(vector 40 8.0304555793911 (fv 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 0 0 0 1 0 1 1 0 0 0 1)

     6.748142 (fv 0.000000 0.029455 0.022065 0.136105 1.638522 1.203180 0.744941 -0.148784 0.506171 0.560051 -0.084723 -0.078289 0.149301 0.575133 1.046850 1.733499 1.932780 1.304846 -0.055855 1.484587 1.130478 0.869457 1.564935 1.665772 1.478237 0.851162 0.123617 0.568797 1.544770 0.060395 1.377474 0.739849 -0.238843 1.303906 1.521850 1.552033 0.224167 1.493979 0.103832 0.387098)
     )

;;; 41 even --------------------------------------------------------------------------------
(vector 41 8.2169809341431 (fv 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0)

     6.881035 (fv 0.000000 0.133290 0.436430 -0.019956 0.597994 -0.299445 0.298044 -0.291816 -0.125561 1.379945 1.227240 1.012471 0.995085 0.165521 0.059156 -0.315277 -0.410140 1.321719 -0.217071 0.006502 1.718169 0.636248 0.520158 0.977079 1.417462 -0.764436 1.377242 0.286309 1.475385 1.360726 0.551504 -0.329940 1.190956 0.377718 1.221012 1.703028 0.053941 0.664915 1.563928 1.320457 0.168607)
     )

;;; 42 even --------------------------------------------------------------------------------
(vector 42 8.3605623245239 (fv 0 1 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1)
     
     6.941481 (fv 0.000000 -0.007293 1.286795 1.752349 -0.276621 1.210682 0.997503 0.480778 0.607692 1.419140 -0.000887 0.317063 0.225619 -1.792990 -0.085405 1.621718 1.141369 0.612500 1.711137 0.371822 0.494518 1.158070 0.720118 -0.061260 0.895705 0.558493 0.565336 0.673764 0.965927 1.131140 0.011389 1.067604 1.758075 0.687249 0.164819 0.032158 0.192333 0.816334 0.404498 1.292703 0.160108 0.486834)
     )

;;; 43 even --------------------------------------------------------------------------------
(vector 43 8.3471550144283 (fv 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 1 0 0)

     7.055197 (fv 0.000000 0.047763 1.657931 1.619393 1.901312 1.535197 1.519084 0.139389 -0.012074 1.734976 0.124057 1.726677 0.967925 0.859090 0.315172 0.782383 0.749080 1.794616 -0.192964 1.214822 1.594002 0.299675 1.830679 1.396713 1.089896 0.461626 0.318824 0.888695 1.307168 1.600142 0.874003 1.625797 0.872538 1.803252 0.868969 0.618677 0.932144 0.968270 1.700058 0.258149 0.614848 0.031586 0.805044)
     )

;;; 44 even --------------------------------------------------------------------------------
(vector 44 8.4271850585938 (fv 0 0 1 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 1 1)

     7.048255 (fv 0.000000 -0.024272 1.042039 1.706381 0.915231 0.667566 0.791468 1.060500 0.486474 0.357952 1.448848 0.555099 0.559674 0.047957 0.101663 0.263196 0.561105 1.754886 1.445748 0.607834 0.094941 0.549126 0.219045 0.643754 0.108792 0.622710 0.657739 1.176141 0.892775 1.899443 0.047927 1.097541 1.395320 1.432930 0.524754 1.590031 -0.111160 0.804186 0.328664 0.621384 1.470620 1.417525 -0.298999 1.020701)
     )

;;; 45 even --------------------------------------------------------------------------------
(vector 45 8.6353975051189 (fv 0 0 1 0 0 1 1 0 1 1 0 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1)

     7.165216 (fv 0.000000 0.100769 0.427512 0.242955 0.443088 -0.380155 1.940929 -0.101098 -0.133968 -0.026473 1.678192 1.774836 0.508005 0.350465 0.553068 1.094302 0.286670 -1.617200 0.541014 0.212204 1.154970 1.344936 0.804485 1.614258 1.391670 0.188798 0.475817 0.610176 0.585642 -0.044233 1.516307 0.921356 1.091747 0.246161 0.592046 1.532410 0.320765 0.050475 1.141805 0.866052 0.300507 0.986581 -0.103223 1.338567 0.196051)
     )

;;; 46 even --------------------------------------------------------------------------------
(vector 46 8.7939519711145 (fv 0 1 0 1 1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0)

     7.276006 (fv 0.000000 -0.054506 1.032755 -0.130142 -0.261502 1.224902 0.252129 0.556107 0.758621 1.480820 -0.142360 1.184737 0.014000 1.776705 0.882036 1.883695 0.222183 0.298085 0.448405 1.172485 0.678362 1.341204 0.081280 -0.085381 0.763100 -0.029414 -0.367000 0.048240 1.040410 1.413704 0.227444 -0.058776 -0.204130 1.202166 1.632528 1.205475 1.219937 1.182203 -0.061521 1.269256 0.937830 0.491219 -0.180909 0.028085 1.489097 0.059386)
     )

;;; 47 even --------------------------------------------------------------------------------
(vector 47 8.7835607528687 (fv 0 0 0 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 1 1 1 1 1 1)

     7.292551 (fv 0.000000 -0.062265 1.442422 1.057676 1.927078 0.605872 0.092606 0.058532 0.177290 1.141099 0.824596 0.143569 1.542821 0.439342 0.943358 1.070588 0.909454 0.332472 1.825929 1.744493 0.079522 0.781524 1.378798 1.290207 0.477850 0.651309 0.041772 0.753335 1.194909 0.871931 1.816269 1.466251 1.199198 1.733301 1.531356 -0.102896 0.905701 1.309802 1.098908 1.238880 1.394185 0.875551 1.145434 -0.145313 0.593458 0.073230 0.938656)
     )

;;; 48 even --------------------------------------------------------------------------------
(vector 48 8.9965600967407 (fv 0 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1)

     ;; ce:
	7.406994 (fv 0.000000 0.047945 0.826536 0.973372 1.740017 0.529769 1.008330 1.827057 0.727986 1.449120 0.514522 1.295511 0.015768 1.206235 0.269772 1.336523 0.110706 1.398598 0.887898 1.776715 1.044804 0.419039 -0.057090 1.238424 0.514960 0.147966 1.655287 1.338551 0.870612 0.661410 0.361317 0.267510 -0.382725 -0.031215 1.567563 1.583622 1.671939 1.775367 1.875910 1.638385 1.546190 0.129055 0.397477 0.763475 0.970476 1.468225 1.622446 0.158949)
     )

;;; 49 even --------------------------------------------------------------------------------
(vector 49 9.1650037765503 (fv 0 1 0 1 0 0 1 1 0 1 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0)

     ;; ce:
	7.532053 (fv 0.000000 0.041305 0.532327 1.215473 1.024214 1.052795 0.585923 1.613470 1.301563 0.656356 1.815283 1.368492 -0.020005 0.356482 1.940348 0.124177 0.127083 1.593092 1.501593 0.678778 0.554128 0.952456 -0.422395 1.575963 0.870840 0.819687 0.743668 0.245617 0.895216 0.369895 0.471783 1.223006 0.679195 1.170671 0.931311 1.629049 0.745807 0.483912 0.397101 0.224181 0.816909 1.126241 1.477811 0.320980 1.574780 0.412692 0.741112 1.583749 0.654625)
     )

;;; 50 even --------------------------------------------------------------------------------
(vector 50 9.1582123370176 (fv 0 1 0 0 1 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 1 0 0 0 1 0 1 1 1 1 0 0 0 1)

     ;; ce:
	7.553949 (fv 0.000000 0.001153 1.444901 -0.126735 -0.207597 1.037485 0.982912 0.657278 1.609015 0.548946 0.388265 1.860455 1.146064 0.991559 1.714083 0.419464 0.114879 0.538313 1.517340 1.406138 0.768916 1.006070 1.575014 1.565071 1.458974 0.980173 1.203265 1.481696 -0.150280 1.613515 0.690225 0.227360 0.618441 0.290246 1.012000 0.302852 -0.136236 -0.046604 1.075996 0.025371 0.550031 1.195469 0.193455 0.810822 0.527380 1.640757 0.113795 0.191137 1.871211 0.281051)
     )

;;; 51 even --------------------------------------------------------------------------------
(vector 51 9.3615226745605 (fv 0 0 0 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0)

     ;; nce: 
	7.601889 (fv 0.000000 -0.097299 1.522524 0.604656 1.190459 -0.046061 1.637924 0.391838 1.914014 1.191379 0.937217 0.903859 1.190560 -0.310642 0.795112 0.607488 1.496318 -0.432640 -0.101925 0.993972 1.031274 1.167246 0.466609 0.643027 0.235799 0.569210 0.641350 0.632197 0.268712 1.299950 1.493958 0.876871 -0.115765 0.447597 1.299543 -0.601543 0.991250 1.221680 0.433618 1.269835 0.891674 -0.222937 1.508906 1.194487 1.696510 0.136336 0.547118 0.154250 -0.399784 0.814800 1.474647)
     )

;;; 52 even --------------------------------------------------------------------------------
(vector 52 9.449512348335 (fv 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 0 1 1 1 0 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 1 1 0 1 1)

     ;; ce:
	7.715514 (fv 0.000000 -0.034843 1.299671 1.297722 1.635310 -0.140716 1.100950 -0.118100 0.547763 0.498559 0.115301 1.387617 0.497862 0.517177 1.775867 1.036003 1.303001 0.627699 1.126538 0.667873 0.716185 0.672233 0.573373 1.713393 1.674703 1.675881 -0.219625 0.205462 0.688511 -0.167042 0.095308 -0.056923 0.925655 1.318413 1.379568 1.567357 0.318805 -0.064577 1.458169 1.228224 0.320505 1.504325 0.170852 1.908593 0.774335 0.156462 0.959528 -0.009590 -0.029886 1.318052 1.521653 0.208620)
     )

;;; 53 even --------------------------------------------------------------------------------
(vector 53 9.6159172058105 (fv 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 1 0)

     7.750487 (fv 0.000000 0.036779 0.620619 1.389030 1.448590 0.206060 1.401187 0.716369 0.552235 0.039103 0.347305 1.846613 0.552018 1.491421 1.339207 1.372862 1.129023 1.023345 1.671571 0.563034 0.162746 0.439370 1.163228 -0.070535 0.315773 0.561792 1.174490 1.839925 1.161557 1.788132 0.000155 0.215127 1.156326 0.635275 1.204301 0.236777 -0.137602 1.267159 0.914139 0.933059 0.732878 0.757869 1.209147 1.287260 1.087065 1.355017 0.578394 1.465757 0.725442 0.562270 1.513798 1.240390 0.721272)
     )

;;; 54 even --------------------------------------------------------------------------------
(vector 54 9.5190944671631 (fv 0 1 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 1 1)

     7.845083 (fv 0.000000 0.061451 0.633202 0.842273 1.609750 1.150617 1.710229 0.507090 -0.042557 0.310551 0.314728 0.987790 1.351858 1.063896 1.713078 1.603814 0.132592 0.924440 -0.380633 0.855851 1.637781 0.813597 1.013698 0.861640 0.327742 0.192164 0.896540 1.734094 0.874167 -0.001625 0.106463 0.214754 1.657275 0.272925 1.907315 1.437104 1.086576 0.701261 0.411048 1.402011 1.872416 0.559924 1.401281 1.776842 1.632661 1.672063 -0.088862 1.645896 0.861803 0.137030 1.828399 0.307366 0.083970 1.711361)
     )

;;; 55 even --------------------------------------------------------------------------------
(vector 55 9.6719217300415 (fv 0 1 0 0 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1)

     ;; ce:
	7.908224 (fv 0.000000 -0.006122 1.706850 -0.138031 1.409264 -0.179924 1.291393 0.095673 0.477101 1.213765 -0.191085 0.117017 0.016865 0.128090 1.052814 -0.223928 0.648751 1.402762 0.456990 0.553356 1.095940 1.027495 0.299767 0.447120 0.205834 1.452671 -0.085699 1.609363 1.101039 1.058600 -0.087300 1.595987 1.179897 0.004643 1.423903 0.778740 0.553053 1.139184 0.724189 1.453952 0.381783 0.586983 0.831862 1.181073 0.788144 1.024391 1.771531 1.598505 0.863121 0.198894 0.450345 0.085968 1.228457 0.544951 0.771388)
     )

;;; 56 even --------------------------------------------------------------------------------
(vector 56 9.6809562784664 (fv 0 0 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 0 0 0 1 1 0 0 0 1 0 0 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 1 0 1 1 0 1 0 1)

     ;; ce:
	8.011195 (fv 0.000000 0.008210 0.905992 0.396571 1.720897 1.158304 1.138541 -0.149073 1.014952 1.018591 1.745765 0.438732 0.854592 1.654860 1.011019 1.080405 0.999544 1.358343 1.494524 -0.322084 1.515909 1.690243 0.974840 0.937768 1.405811 0.436415 0.424543 1.360935 -0.014499 1.482939 0.090605 0.959441 1.032814 1.287153 0.868562 1.424617 0.689023 1.690605 0.303801 0.396076 -0.120753 1.039594 0.342297 0.231504 -0.042441 1.626406 0.755064 0.442808 1.366653 1.769637 -0.205340 -0.239797 0.934356 1.176593 0.655901 1.488666)
     )

;;; 57 even --------------------------------------------------------------------------------
(vector 57 9.8992366790771 (fv 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 1 0 1 0 0 1 0 1 1 1 1 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 0 1 0 1 0 0 1 1 0 0 1)

     ;; ce:
	7.998443 (fv 0.000000 -0.014666 1.566831 1.522473 -0.249684 1.548885 0.061859 1.226467 1.343794 0.283370 1.644204 -0.263860 0.040445 -0.006696 1.612019 1.549636 0.536480 0.507272 1.129223 0.096416 0.070654 1.146329 0.116347 1.310955 1.044576 1.855920 1.741244 0.737054 0.646099 0.980172 1.413425 1.269711 1.581860 1.800144 1.281998 -0.058342 0.653062 1.547228 1.144145 0.578917 0.690679 0.861263 0.345954 0.676296 0.259007 0.725329 -0.285685 1.547409 0.602010 1.240793 0.038406 1.789143 1.881017 1.026132 0.600098 1.097228 -1.919911)
     )

;;; 58 even --------------------------------------------------------------------------------
(vector 58 9.8761510848999 (fv 0 1 1 1 1 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 1 0 0 0 1)

     8.102746 (fv 0.000000 0.021804 0.347449 0.712574 0.904596 1.645925 0.230015 0.473992 0.104969 1.934740 1.209012 1.104800 1.062683 0.358409 0.785934 1.465266 1.235573 1.772411 0.072477 1.559281 1.754795 0.147077 0.219637 0.050078 1.441852 0.333339 0.672730 1.789640 1.230725 1.303568 1.622831 1.659814 0.995447 1.205094 1.295826 0.837873 0.521849 1.476121 0.531055 1.439237 1.534776 0.923559 1.866584 1.504388 0.402718 1.262304 0.589470 1.403389 1.379169 0.218840 1.535374 0.130494 0.618342 0.285582 1.711521 1.399310 1.463120 1.577451)

     ;; nce:
     8.160514 (fv 0.000000 0.018101 0.649039 1.105139 0.805799 1.552840 0.507143 0.455093 0.410985 1.820561 0.914505 0.984750 1.066413 0.191884 0.653627 1.510871 1.561405 1.875189 -0.078120 1.639973 1.489309 -0.122302 0.187579 -0.137707 1.247718 0.796984 0.621022 1.565078 1.132796 1.098952 1.427880 1.663078 0.762131 0.965307 1.352999 0.722067 0.412348 1.684775 0.457834 1.443318 1.385930 0.962906 1.869715 1.351690 0.195092 1.084773 0.690763 1.132481 1.402235 0.306205 1.443881 0.266933 0.858427 0.045513 1.705481 1.280871 1.423605 1.246177)
     )

;;; 59 even --------------------------------------------------------------------------------
(vector 59 10.094394683838 (fv 0 1 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1)

     8.194538 (fv 0.000000 0.192440 1.064997 1.405447 0.666893 0.441718 0.460123 -0.029893 0.102290 1.233991 1.287456 0.262828 0.891341 1.622477 -0.078945 0.794492 1.676056 0.757298 1.625170 1.288224 1.021602 1.270621 0.622162 1.173256 0.639594 0.085293 0.804874 1.211161 -0.067577 0.210901 0.178378 0.446246 -0.092053 1.813463 1.120832 1.269392 -0.271084 1.861664 0.195222 0.087459 0.045547 0.257753 0.386709 0.151559 1.002452 0.352762 0.090741 1.494023 0.840240 1.424148 0.778422 -0.109268 1.896909 0.853535 0.284500 1.503148 1.606229 1.606587 0.287318)
     )

;;; 60 even --------------------------------------------------------------------------------
(vector 60 10.333255371943 (fv 0 0 0 1 0 1 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 1 0 1 0 1 0 0 1 1 0 0 0 1 1 1 1 0 0 1 0 0 0 0 1 0 0 0 0 1 1 1 1 1 0 0)

     8.312421 (fv 0.000000 0.016764 0.099999 0.395290 1.344482 1.502674 0.248570 0.971438 0.736859 1.561216 0.263938 1.242184 -0.428796 -0.122031 1.528486 0.190921 1.269506 0.099840 0.618839 0.286668 0.310580 0.121766 0.645000 0.953645 1.140529 0.456214 0.631806 0.922426 0.396932 1.354468 1.176819 0.515695 0.171198 0.662750 1.320434 0.506395 1.565445 0.874857 0.531897 0.782628 0.471079 -1.819575 1.656923 0.206815 0.413621 0.205859 1.749126 1.236787 1.333671 0.085487 1.468799 1.666444 0.266215 0.649751 0.639546 0.431656 1.171882 1.863798 1.376382 0.482890)

     ;; ce:
     8.297419 (fv 0.000000 -0.050827 -0.093113 0.415337 1.376502 1.483467 0.139153 0.992518 0.529850 1.653904 0.191931 1.095275 -0.256090 -0.161285 1.405742 0.150354 1.336151 -0.049296 0.676639 0.179468 0.223738 -0.026447 0.633754 1.009834 1.247179 0.478290 0.662079 0.748655 0.357085 1.374703 1.160927 0.429236 0.231499 0.680606 1.275377 0.482417 1.486029 0.955636 0.656194 0.784771 0.415616 -1.691681 1.767041 0.147548 0.371057 0.291191 1.824186 1.135403 1.361375 0.394251 1.554796 1.735953 0.147583 0.633615 0.589877 0.598198 0.971637 1.904531 1.249959 0.504018)
     )

;;; 61 even --------------------------------------------------------------------------------
(vector 61 10.120587847566 (fv 0 0 0 0 0 1 0 0 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1)

     ;; ce:
	8.246633 (fv 0.000000 0.014137 0.312612 0.249295 0.935740 0.710600 -0.670222 0.029791 0.000981 1.147441 0.399682 0.888394 1.440126 0.108877 -0.294608 1.403751 1.053458 0.779516 0.066815 1.543587 0.107940 1.359190 1.494404 1.618478 0.815280 -0.244135 0.981345 0.739684 0.088784 1.710138 1.218977 0.672306 0.896304 0.148600 0.266242 0.612315 0.136648 0.136688 0.184375 -0.198309 0.518044 0.411032 1.286324 0.855547 0.828794 0.991646 1.167294 -0.167119 0.070397 0.487614 -0.198225 0.121902 0.696143 0.291992 0.984667 1.799531 0.623251 0.161592 0.779281 0.099176 0.369046)
     )

;;; 62 even --------------------------------------------------------------------------------
(vector 62 10.318392753601 (fv 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 0 1 1)

     8.390962 (fv 0.000000 0.864131 -0.039302 0.501838 0.179590 0.198870 0.408743 -0.099436 -0.035241 1.399095 1.555420 1.066003 1.126029 -0.412606 0.371657 1.690168 1.511157 0.827619 0.057876 1.184261 0.354886 0.869166 0.825315 1.069197 0.055544 0.926747 0.994446 -0.406535 1.243161 1.409918 0.623323 1.296612 0.600545 1.814707 1.913723 0.665613 1.150575 0.642943 -0.000728 0.108004 1.148509 1.338004 0.731747 0.682804 1.190657 0.379742 0.514953 0.586813 0.784946 1.269079 1.453729 1.496418 0.332671 -0.412333 0.644169 0.803815 1.053593 1.563066 0.967726 0.733563 -0.027726 1.710240)
     )

;;; 63 even --------------------------------------------------------------------------------
(vector 63 10.45694065094 (fv 0 0 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 1 0)

     8.413888 (fv 0.000000 0.010634 0.820887 1.791906 0.180821 1.699733 1.457775 1.781040 1.049055 0.063682 0.656198 -0.016519 1.426220 1.490473 0.018505 1.749295 0.166920 0.934178 0.018879 0.949939 1.163838 0.694420 0.665805 0.087679 1.619302 0.169784 1.099805 0.390614 0.230991 0.703447 0.620497 0.345622 1.520041 1.514348 1.626503 0.238228 1.445149 1.071455 0.772257 1.186699 1.488207 -0.090097 0.947955 1.288711 1.143854 0.328539 1.581009 1.516219 1.752145 1.825272 0.656629 1.607807 1.482688 0.741468 0.684282 0.938749 1.078766 0.076298 1.127102 0.768415 0.654765 1.253057 1.466721)
     )

;;; 64 even --------------------------------------------------------------------------------
(vector 64 10.487 (fv 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 1)

     8.500897 (fv 0.000000 -0.110230 0.253682 0.149208 0.517156 1.680690 0.261962 -0.311932 1.499119 0.134139 0.193946 1.528316 0.126448 1.680960 0.957330 -0.015272 0.163098 1.233151 0.955877 1.516677 1.271750 0.225924 1.801609 0.924065 0.996478 1.135973 0.892170 1.311436 1.257336 0.314351 0.968388 0.136861 1.841069 1.348391 1.398845 -0.195293 1.345125 1.529238 1.112945 1.363188 0.328366 0.804723 1.816185 1.478898 0.163962 1.500837 0.226838 0.805475 0.515967 0.095385 1.528024 1.274946 0.915048 0.129649 1.022985 1.362093 -0.189345 -0.123957 -0.176055 0.992212 1.710004 0.183155 0.509794 0.492211)
     )

;;; 65 even --------------------------------------------------------------------------------
(vector 65 10.593795776367 (fv 0 1 1 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 0 1 1 1 1 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 1 1 0 1 1 0 1 0)

     ;; ce:
	8.609777 (fv 0.000000 0.010286 0.073308 0.156025 1.953119 0.326605 1.156187 1.359503 0.615092 0.625095 1.209776 1.377583 -0.310622 1.815585 1.618945 0.328652 -0.127781 1.904210 1.297763 1.916187 0.801813 0.929154 1.581967 0.478151 0.556340 1.031862 1.480609 -1.661291 1.218834 0.549647 1.223081 1.263443 0.189207 -0.057436 1.688891 1.890453 1.705454 1.164550 1.023002 0.394890 -0.072758 -0.362543 1.102983 0.220165 0.570828 0.506586 1.236790 0.668284 1.330270 0.072079 0.187084 1.026028 0.423887 1.229321 0.594086 1.447463 0.979393 0.850808 0.463831 1.022159 0.562154 0.740405 1.709952 0.862548 0.909149)
     )

;;; 66 even --------------------------------------------------------------------------------
(vector 66 10.77367179842 (fv 0 0 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 1 1 0 0 1 1 0 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 0)

     ;; ce:
	8.678699 (fv 0.000000 0.454997 1.496948 0.519770 1.672039 0.567223 1.755017 0.736664 1.985212 1.381007 0.655920 0.131168 1.193358 0.617219 1.831999 1.143743 0.488405 0.001490 1.636224 1.056726 0.387222 0.101202 1.826852 1.187505 0.710721 0.377670 0.096617 1.812536 1.688958 1.476343 1.264972 1.142558 1.049579 0.690750 1.195534 0.929938 1.522099 1.266451 1.390797 1.538518 1.605610 1.574083 1.889598 0.006801 0.695550 0.832932 1.160944 1.293180 1.683176 0.244325 0.530816 1.180483 1.812767 0.268820 0.993683 1.695534 1.919653 0.449948 1.560150 0.338318 1.266700 1.853107 0.910590 1.381060 0.420174 1.311948)
     )

;;; 67 even --------------------------------------------------------------------------------
(vector 67 10.668939590454 (fv 0 1 1 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 0 1 0 0 1 0 1 0 0 1 0 0 0)

     ;; ce:
	8.715278 (fv 0.000000 -0.048714 1.201233 1.932201 0.432152 1.784378 1.706119 1.715110 0.918127 0.634326 -0.280426 0.736091 0.881233 0.715749 1.255373 0.306961 0.430124 1.043814 0.355900 1.887422 0.161687 0.974683 1.590380 -0.300251 0.580494 -0.035950 1.388432 1.396578 1.262995 0.125471 0.427569 0.132635 1.747845 1.090690 1.059664 0.781885 0.922127 1.269399 0.290961 0.283370 1.543322 0.245179 1.267332 1.559397 1.540498 0.278811 0.442330 0.979302 0.305622 1.057402 0.123531 1.659773 0.687811 0.574242 1.988850 0.928855 0.118304 0.916897 0.064414 0.547707 0.733829 0.168859 0.108897 0.552498 0.271579 0.641458 0.722670)
     )

;;; 68 even --------------------------------------------------------------------------------
(vector 68 10.834321813096 (fv 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 1 0)

     ;; ce:
	8.754943 (fv 0.000000 0.006701 0.662467 1.132456 -0.029127 0.614111 1.150467 1.706479 0.619454 1.199242 1.758840 0.562498 1.597544 0.407921 1.558651 0.097672 0.926756 -0.032275 0.853950 0.002762 0.680777 1.599641 0.725147 0.147702 1.201496 0.263849 1.380478 0.615269 0.086221 1.573333 1.233822 0.463104 -0.134996 1.463347 0.467790 -0.201328 1.692933 1.307865 0.941345 0.423601 0.364303 1.897445 -0.044200 1.168331 0.738828 0.662829 0.834882 0.503840 0.773952 0.485349 0.168198 0.227087 0.122039 0.075266 0.590053 0.402757 0.920519 0.805378 1.169878 1.002493 1.566599 1.933905 0.435730 0.760806 1.023096 1.785992 1.801946 0.257114)
     )

;;; 69 even --------------------------------------------------------------------------------
(vector 69 11.164121627808 (fv 0 0 0 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 0 0 1 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0)

     8.870351 (fv 0.000000 -0.002928 0.090043 1.728264 1.193144 0.838010 0.865027 0.720973 0.639322 0.246096 0.057627 0.302959 -0.048089 1.638389 0.900762 0.946630 1.090094 0.801115 1.083281 1.325801 0.953024 0.800047 1.660883 0.042716 1.927302 1.582152 0.107129 0.057190 -0.097633 0.434745 0.530943 1.556013 -0.117080 1.617479 1.566580 -0.082197 0.137002 1.745306 1.025473 1.476477 1.524388 0.192617 1.281951 0.528156 0.227376 1.631586 1.077576 0.616842 1.479500 0.199402 1.336867 0.525138 1.593133 1.323175 0.217188 0.498012 1.287694 0.007842 1.310482 0.013236 0.970642 -0.011247 0.684481 1.560396 -0.131105 0.613388 0.586300 0.981366 1.715362)

     ;; ce:
     8.871460 (fv 0.000000 0.024677 0.348753 1.853212 1.026433 0.764498 0.988619 0.726212 0.717099 0.354110 0.211391 0.453497 0.101716 1.483433 0.914508 0.822283 0.913048 0.815074 1.083064 1.158865 1.024685 0.695931 1.752852 0.025183 1.742985 1.441890 0.242171 0.072208 0.012411 0.538299 0.676243 1.315025 0.155925 1.560315 1.592984 0.078875 0.242794 1.804492 0.950070 1.285093 1.411716 0.049957 1.246246 0.728985 0.030862 1.434432 1.085297 0.759494 1.436818 0.422412 1.268623 0.590795 1.364269 1.235546 0.170900 0.477972 1.127120 -0.054549 1.479098 0.172668 1.199653 -0.107230 0.674735 1.486658 -0.230242 0.542693 0.703829 0.966900 1.458811)
     )

;;; 70 even --------------------------------------------------------------------------------
(vector 70 11.188811302185 (fv 0 1 1 1 0 0 1 0 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 0 0 1 0 1 1 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 0 0 1 0 1 1)

     ;; ce:
	8.848811 (fv 0.000000 0.246703 1.002261 0.886061 0.801873 1.809738 1.108544 0.562043 1.825392 1.804522 1.262385 0.421389 0.361557 1.923401 1.951742 1.062427 0.438003 0.228289 1.097160 1.013865 0.764041 0.470243 0.831289 0.101425 1.763202 0.709481 0.498799 0.216191 0.861166 0.122620 0.547738 1.235046 0.857238 0.383439 0.822746 0.754977 0.703208 0.715041 0.359010 1.832044 0.247507 1.317151 1.405217 0.206638 0.707472 1.340219 1.707159 1.823029 1.938700 1.479437 0.258261 1.667534 0.316971 1.157956 1.277369 0.826722 1.196822 0.248386 0.546752 1.821030 1.066474 1.952221 1.238401 0.305398 0.369743 0.877722 1.232005 1.532682 1.629962 0.062770)
     )

;;; 71 even --------------------------------------------------------------------------------
(vector 71 11.146488189697 (fv 0 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 0 0 0 1 1 0)

     ;; ce:
	8.877033 (fv 0.000000 0.494925 1.537244 0.892084 0.150008 1.375283 0.111396 0.180070 1.039621 1.603551 0.974071 0.067462 1.566530 0.645476 1.559374 0.286202 1.250076 1.040362 0.597158 0.170031 1.495084 0.538551 1.605790 0.911462 0.561795 0.131327 0.669920 1.494711 1.488338 0.162432 0.349959 1.071758 0.876821 1.835299 1.877472 1.338427 1.055237 0.961547 0.343936 0.685277 1.268629 0.932565 0.412531 1.233930 1.960684 0.356135 1.869394 1.068031 1.470058 1.669216 1.450884 1.495861 1.103585 1.290131 0.589390 1.675751 1.864756 1.328404 1.588855 1.689588 1.394915 1.481997 1.790524 0.376533 0.659979 0.194369 0.714680 1.009374 1.293563 1.133522 0.906132)
     )

;;; 72 even --------------------------------------------------------------------------------
(vector 72 11.323646371629 (fv 0 0 1 0 1 0 1 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0)

     8.985526 (fv 0.000000 -0.132001 0.251840 -0.152367 1.238134 0.223104 0.102612 0.998567 1.283059 0.195894 1.573363 0.407537 1.033361 -0.202081 0.593147 0.635495 1.000647 1.220151 0.876169 0.891935 0.590452 0.848621 0.474219 0.520369 1.077034 0.562333 1.205154 1.187120 1.031050 1.268084 0.666333 -0.432529 0.483326 0.764356 0.428610 0.084679 1.685196 -0.154809 0.749260 1.099715 -0.153921 1.175926 0.117589 0.701530 0.528397 1.669792 1.315998 0.695987 0.047259 0.736352 1.073555 1.525504 1.860608 -0.168018 1.587814 -0.029717 0.367471 1.076978 0.934753 0.510954 0.369425 1.530708 0.338598 0.869566 1.012951 0.841118 0.372289 1.598627 0.202786 1.450618 0.578685 0.231358)

     ;; nce:
     8.996610 (fv 0.000000 0.020435 0.148826 -0.173981 1.377729 0.211130 0.166992 1.053622 1.458337 0.005572 1.576161 0.391690 1.074146 -0.213327 0.588223 0.422230 0.994634 1.149413 0.858889 0.855458 0.451324 0.722371 0.451607 0.485779 1.099748 0.481778 1.183724 1.119200 0.986503 1.262651 0.778215 -0.493824 0.577630 0.838272 0.526378 0.254738 1.698601 -0.156321 0.698602 1.048110 -0.140804 0.991469 0.138073 0.652727 0.457506 1.770023 1.311357 0.782250 0.170414 0.740584 1.195615 1.519642 1.761376 -0.154135 1.542454 -0.027224 0.389381 1.045008 1.107881 0.609081 0.244277 1.495852 0.294775 0.922470 1.153689 1.027914 0.296649 1.621186 0.277016 1.409256 0.557607 0.152023)
     )

;;; 73 even --------------------------------------------------------------------------------
(vector 73 11.416394233704 (fv 0 0 0 0 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 1 0 0 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 1 0 1 0 1 1 0 0 0 0)

     ;; ce:
	9.061347 (fv 0.000000 -0.013492 0.700057 0.971458 1.656489 0.226217 1.266397 1.217251 0.034107 1.132703 0.209805 0.859555 1.676063 0.359664 0.948491 1.631395 0.566735 1.564253 0.503600 1.614448 0.423074 1.551405 0.311534 1.292368 0.836304 0.277624 0.872873 0.108697 1.546043 0.974228 -0.054286 1.516659 0.873622 0.075543 -0.025545 1.027508 0.575666 -0.130582 1.023997 1.136740 0.704834 -0.015132 -0.346526 1.509690 1.112218 0.655940 0.431045 0.092523 0.384582 -0.406961 0.058570 -0.216957 1.536312 1.587308 1.645182 1.277358 1.546578 1.141387 -0.381783 1.707248 -0.163708 -0.313272 -0.263055 0.347717 0.363093 0.778459 1.216671 1.669453 -0.038813 0.148398 0.866038 0.847643 1.513063)
     )

;;; 74 even --------------------------------------------------------------------------------
(vector 74 11.47264289856 (fv 0 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 0 1 0 1 0 1 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 1 0 1 1 0 1 1)

     ;; ce:
	9.134480 (fv 0.000000 0.102279 0.371397 0.523001 1.843248 1.152941 1.651341 1.411384 0.791794 0.097952 1.057024 0.161099 0.857363 0.427397 0.372120 0.661194 1.523876 0.922082 -0.041073 -0.033604 0.996743 1.697191 1.295880 0.242720 0.296660 0.925120 0.229105 1.701968 1.808512 0.155026 0.755549 1.603330 1.534401 1.305218 1.056671 1.959110 0.012243 0.095634 0.866653 0.499791 0.642664 1.366362 0.320578 0.556112 0.471836 0.546071 0.453257 0.620145 0.487633 1.413108 0.647644 1.248023 1.294495 1.814325 0.514274 1.440895 0.132821 0.969503 0.559010 0.339598 1.732485 1.513938 0.682886 0.936970 1.342790 0.397470 0.364797 1.929409 1.198862 0.270546 1.048858 1.252852 0.860205 0.013479)
     )

;;; 75 even --------------------------------------------------------------------------------
(vector 75 11.479255355845 (fv 0 0 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0 1)

     ;; ce:
	9.136718 (fv 0.000000 0.002886 1.335455 0.159358 1.480181 0.946385 -0.044639 1.084031 0.633473 0.070872 0.846110 0.073920 0.712875 1.849807 0.002049 1.333644 0.084510 1.217578 1.455838 0.351015 0.583697 1.521673 -0.105875 -0.161704 1.008277 1.067855 -0.227255 1.066234 0.968179 0.069816 1.652420 0.515209 -0.583628 1.701274 1.644474 0.045597 -0.072256 1.396842 -0.036343 1.242335 0.205214 -0.046339 1.655176 1.585631 1.056865 0.812824 1.251896 1.501857 -0.501015 0.327372 1.079894 1.360106 0.639144 -0.102077 0.025865 0.258537 0.650404 0.029251 0.316419 1.073801 1.065871 0.953311 0.976263 -0.016818 0.369518 -0.028524 0.754304 0.267168 0.876021 1.386930 1.128217 -0.044803 -0.305853 1.417010 1.210349)
     )

;;; 76 even --------------------------------------------------------------------------------
(vector 76 11.477294510597 (fv 0 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1)

     ;; ce:
	9.274323 (fv 0.000000 -0.012165 1.750183 1.230595 1.387108 0.131448 0.902665 1.325819 0.139220 0.132421 1.315838 0.916320 1.247629 1.543004 0.326242 0.479315 1.525889 1.714627 0.992625 1.849378 1.028201 1.309429 1.365818 1.322280 1.222257 1.381076 1.644593 0.773733 0.614835 0.306624 1.009114 1.162734 0.610055 0.099066 1.125761 1.356329 0.324777 0.800340 1.850117 0.710340 0.610191 0.810114 1.107918 1.417728 -0.023776 1.259738 0.196765 1.355631 1.575090 1.576385 1.741085 1.748236 0.050375 1.081011 0.178534 1.097122 0.438057 -0.170346 1.371443 0.019537 1.307599 0.833238 0.430491 0.202986 1.382655 1.791419 0.002565 0.061873 0.176928 1.554826 0.852820 1.065814 0.297645 0.742549 0.387652 1.429885)
     )

;;; 77 even --------------------------------------------------------------------------------
(vector 77 11.594018936157 (fv 0 1 0 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1)

     ;; ce:
	9.277681 (fv 0.000000 -0.007935 0.356695 -0.167840 1.436050 1.267495 0.166108 0.719740 1.788089 0.701383 1.502062 0.971109 -0.201146 1.261312 1.596232 0.380082 0.436900 1.530759 0.673592 1.168750 0.815135 1.757429 0.573966 1.406748 1.792933 1.256151 0.643583 0.884960 0.868508 0.759790 1.464002 -0.196244 0.635729 1.419530 -0.026848 0.857441 0.646295 0.815860 0.331225 0.324537 0.379771 0.793029 -0.189194 0.533286 0.175986 1.162021 0.894997 1.330799 0.028604 0.329088 -0.042751 1.722552 1.010170 0.365295 -0.089972 0.186813 0.250172 1.045796 0.805669 1.150679 1.074682 0.666765 1.119179 0.223717 0.745979 0.727191 0.250299 1.103832 0.833082 -0.215344 1.645081 0.897326 0.690160 1.501085 1.581868 1.570534 1.086810)
     )

;;; 78 even --------------------------------------------------------------------------------
(vector 78 11.940728787203 (fv 0 1 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 0)

     9.335941 (fv 0.000000 1.404748 1.136727 0.627680 0.129528 0.271686 0.002711 1.737837 1.295987 1.387168 0.097658 1.822832 0.846464 1.039100 1.481322 0.895294 0.827592 0.841157 0.429643 0.718521 1.651578 0.732848 0.670593 1.833752 0.966314 1.266799 1.852734 1.169793 1.403542 0.722295 1.054728 1.444480 1.323054 1.351419 0.414445 0.928183 1.497407 0.895056 0.003473 1.202042 1.804296 0.448756 1.139768 0.075452 1.121542 0.477216 1.723231 0.402648 0.668323 0.045598 1.846940 0.961710 0.765295 1.814929 0.327072 0.120487 1.324670 1.238079 1.405578 -0.005216 1.466365 1.535268 1.050547 0.249219 1.956711 0.420435 0.291291 0.855796 1.032224 0.874733 1.340034 0.852331 1.473861 1.078790 -0.021411 0.624891 0.620475 1.381664)
     )

;;; 79 even --------------------------------------------------------------------------------
(vector 79 11.878196632448 (fv 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 1 0 0 0 0 1 1 1)

     ;; ce:
	9.380733 (fv 0.000000 0.510780 0.252633 0.712748 0.045825 0.533290 0.570911 1.782693 1.778269 1.965545 0.949265 0.812889 1.687090 1.664308 1.581407 1.710616 0.952117 1.113251 0.535130 1.949191 0.392710 1.113892 0.673455 0.088774 1.234594 1.234700 1.363303 0.874218 0.053582 1.508928 0.207664 0.009853 1.481504 1.794166 0.192648 0.693227 0.386323 1.341036 0.276027 0.630139 0.405686 0.785949 0.090167 1.080676 0.339556 0.634603 1.972094 0.909674 0.642872 1.742555 1.044458 1.900464 0.893867 1.044986 0.466092 0.081355 1.748407 0.417739 0.609777 0.867444 0.996078 1.921822 0.146017 1.547350 1.786775 0.079134 0.379049 1.145195 0.491146 0.827840 1.444544 0.381774 1.018247 0.133450 0.186735 0.732527 1.660451 1.720421 1.438682)
     )

;;; 80 even --------------------------------------------------------------------------------
(vector 80 11.989325523376 (fv 0 1 0 0 1 0 0 1 1 0 1 0 0 1 1 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0)

     ;; ce:
	9.493437 (fv 0.000000 -0.003056 0.871305 1.349319 1.858308 0.466908 1.244422 1.764043 0.291426 1.076281 1.682758 0.386304 1.182056 -0.041504 1.018049 1.794160 0.591085 1.410404 0.075268 1.154361 0.262047 1.215494 0.086813 1.119384 0.112085 1.492482 0.546321 1.626715 0.687674 1.840924 1.113879 0.412411 1.693842 1.217772 0.566191 1.613902 0.702693 0.386708 1.626693 1.362021 0.738932 0.368846 1.672871 1.299617 0.788427 0.551598 0.187991 1.803477 1.774821 1.164009 1.487614 0.770019 0.742630 0.390398 -0.088422 1.923288 -0.109062 1.842146 1.690251 0.008381 1.550824 1.531659 1.497616 1.396079 1.603050 1.793260 0.154336 0.252178 0.425516 0.421130 0.697112 0.901699 1.252555 0.016759 0.375241 0.855613 1.211546 1.433945 1.792863 0.351953)
     )

;;; 81 even --------------------------------------------------------------------------------
(vector 81 11.979215621948 (fv 0 0 1 0 1 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 1 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 0 1 1 1 1 1 0)

     ;; ce:
	9.529325 (fv 0.000000 -0.003984 0.725186 0.743737 0.729531 1.119765 1.541925 1.678935 1.738481 1.721543 1.393185 0.731045 0.019478 0.771584 0.581855 0.216656 0.563399 1.242114 0.560651 1.738359 1.170491 0.159270 0.566126 0.483569 1.182790 0.181604 1.706151 1.854339 -0.002194 0.437844 -0.070207 1.440872 0.286463 1.398996 1.367061 0.708028 -0.290957 0.883528 0.399205 0.712176 0.881360 0.586332 1.691690 -0.045439 0.598789 -0.244443 0.663603 1.393152 0.011936 0.502973 1.160110 0.596199 0.257846 0.544341 0.629333 1.752684 0.177491 0.528429 1.038556 0.728481 0.384225 0.529890 0.711236 1.400194 1.498453 1.156244 0.653763 0.305758 -0.155269 1.073363 1.458379 0.702870 0.141716 1.302726 -0.329814 0.298639 1.892688 1.900138 1.655169 0.812034 -0.182220)
     )

;;; 82 even --------------------------------------------------------------------------------
(vector 82 11.74796962738 (fv 0 0 0 0 0 0 1 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 1 0 0 0 1 0 0 0 0 0 1 1 0 1 1 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 1 1 1 0 1 1 1 1 0 1 0 0 1 1 1 0 0 0 1 1 0 1 0 1 0)

     ;; ce:
	9.530985 (fv 0.000000 0.002581 0.665465 1.069477 1.708629 0.244744 0.815275 1.389506 0.072967 0.518149 1.258636 0.104869 0.672550 1.578904 0.486254 1.275378 -0.016236 0.797153 -0.276393 0.747043 -0.159462 0.727529 0.109229 1.313965 0.107559 1.101244 0.135391 1.229652 0.386704 1.699152 0.875100 0.220480 1.674529 0.566929 1.803565 1.281089 0.420527 -0.095373 1.451514 0.833105 0.334393 1.926106 1.521915 0.797742 0.037620 1.890450 1.238469 1.288596 0.773237 0.606049 0.213821 0.049140 1.607755 1.437666 0.833194 0.946550 0.684670 0.626164 0.630512 0.902897 0.480081 0.471365 0.308602 0.413372 0.258949 0.442607 0.453613 0.854111 1.173261 1.257079 1.135118 1.379336 1.476222 -0.234240 0.311478 0.480664 1.015136 1.521091 1.852304 0.056526 0.425563 0.785949)
     )

;;; 83 even --------------------------------------------------------------------------------
(vector 83 11.931811297539 (fv 0 0 1 1 0 1 1 0 0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 1 0 1 0 1 1 0 0 1)

     ;; ce:
	9.549360 (fv 0.000000 0.032288 0.834116 1.401416 0.035368 0.406563 1.177626 1.509613 0.291626 0.972552 1.726763 0.692721 1.687201 0.129594 1.085873 0.204017 1.139515 0.273445 1.482102 0.192295 1.080179 1.979882 1.285941 0.340403 0.985304 0.533609 1.865099 0.628799 1.889210 1.180384 0.539244 1.842377 1.350512 0.512399 1.815213 1.164340 0.726996 -0.012813 1.099275 1.226281 0.551613 0.011231 1.538277 1.191883 0.928674 0.507861 1.826344 1.417654 1.468918 1.265287 0.819366 0.969679 0.428274 0.455249 1.949916 0.041645 1.591382 1.883937 1.784338 1.762163 1.899526 1.307740 1.800619 1.929764 0.063585 1.701620 1.807254 0.159705 0.531560 0.710036 1.009902 1.081386 1.423742 1.377653 1.714397 0.170534 0.667428 1.526663 1.444085 1.827303 0.046079 0.991518 1.278845)
     )

;;; 84 even --------------------------------------------------------------------------------
(vector 84 12.426499838032 (fv 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 0 0 1 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 0 1 1 0 0)

     ;; ce:
	9.633962 (fv 0.000000 0.374922 1.183581 1.290870 0.705975 0.037122 1.139367 1.048350 0.334310 1.326801 1.647856 1.857607 1.812109 0.301068 1.658406 1.344389 0.416349 0.219667 1.233884 1.040486 1.625160 1.657982 1.232289 1.436356 0.879314 1.500837 0.083989 0.524445 1.496583 0.195492 0.415250 0.867702 1.173743 1.828747 1.840334 -0.001715 0.114874 1.289221 0.907468 1.568406 0.412257 0.461669 1.993995 0.175480 1.741500 1.629849 1.860704 1.739722 1.644034 1.223183 0.177672 0.444348 1.320675 1.200379 1.245918 0.030713 1.304971 1.969297 1.489901 0.864880 0.577011 0.034043 1.934323 1.447131 0.730445 1.571480 0.003554 0.387041 0.486597 1.351900 0.594794 1.157107 0.726867 1.857734 0.748709 1.799335 1.043537 0.919611 0.874828 0.732255 1.153375 1.608544 0.740331 1.571952)
     )

;;; 85 even --------------------------------------------------------------------------------
(vector 85 12.270205061432 (fv 0 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 0 0 0 0 1 0 0 1 0 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1)

     9.693668 (fv 0.000000 0.195989 0.490949 0.331600 0.887562 0.028445 1.546017 1.385311 0.812190 1.115113 1.801497 0.487288 0.525794 0.074082 1.723182 1.944316 1.781964 0.421600 0.177518 1.829367 0.571078 1.783004 0.344177 0.329133 1.891108 0.440324 0.259558 0.143603 0.779362 1.104207 1.976902 0.561742 0.767039 1.340228 0.253563 1.774888 1.741378 1.554241 1.474673 0.298807 0.272176 1.211675 1.002346 0.130871 1.176937 0.697418 0.199450 0.178715 1.330092 0.855241 1.512332 1.331159 0.219055 1.811575 1.934102 1.939888 1.043996 0.748687 0.643521 0.780509 1.267694 0.441215 0.667193 0.454905 1.688291 1.972173 0.503377 0.756581 0.239100 0.784029 1.470486 0.189182 1.795940 0.379978 1.569889 1.093199 1.711138 0.905143 0.045022 0.285289 1.219061 0.953496 1.196694 1.742789 0.902060)

     ;; nce:
     9.690941 (fv 0.000000 -0.005460 0.145938 -0.187800 0.177698 1.176520 0.517469 0.210175 1.436686 1.607383 0.066090 0.593136 0.482635 1.868920 1.291310 1.386910 1.029893 1.540100 1.084274 0.614905 1.153312 0.206651 0.588776 0.424148 1.780700 0.201677 -0.148794 1.539105 1.959298 0.153524 0.855868 1.263643 1.287920 -0.293735 0.438019 -0.206018 -0.356273 1.231052 1.001435 1.635849 1.476715 0.216231 -0.158631 0.753539 1.686606 0.980832 0.355756 0.168014 1.126044 0.500388 0.943877 0.638970 1.307633 0.790226 0.733504 0.595806 1.464991 1.037472 0.754676 0.719213 1.040414 0.002877 0.074104 1.737856 0.729741 0.862345 1.242108 1.321487 0.621750 1.011073 1.510125 0.085724 1.514690 -0.060524 0.938871 0.309540 0.743320 -0.211769 0.753436 0.803987 1.556267 1.083936 1.193072 1.598509 0.578392)
     )

;;; 86 even --------------------------------------------------------------------------------
(vector 86 12.791990425787 (fv 0 0 1 1 0 0 1 0 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 0 1 0 0 1 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 0 0 1 1 1 0 0)

     9.804520 (fv 0.000000 0.137494 0.326172 0.010382 1.487613 0.505001 1.228062 0.954717 -0.127893 -0.290666 0.636565 1.325872 1.732483 0.567284 1.353499 0.704440 1.806655 1.469223 0.382393 0.706107 0.545460 0.307640 1.039546 0.875080 1.787391 0.105900 0.639604 0.989302 -0.045857 1.717167 1.835064 1.163334 0.033557 1.525348 0.510815 0.463389 0.777198 0.612036 1.665125 1.493136 0.475659 1.095674 1.296538 1.117478 0.603294 1.233039 0.344624 0.414746 0.337889 1.713708 0.141791 0.820548 1.699043 0.899800 0.803706 0.771637 1.413475 1.319088 1.268258 0.265658 0.770528 0.659195 0.900807 0.683986 1.290180 0.800356 1.418815 1.036184 1.201710 0.337696 1.582663 1.435772 0.606855 1.068190 0.540979 1.320205 -0.195129 0.714820 0.387530 0.040243 0.270436 -0.038662 1.702501 0.563408 0.676006 0.165316)

     ;; nce:
     9.779022 (fv 0.000000 0.012842 0.387371 0.019737 1.439011 0.434664 1.128389 0.730743 -0.150815 -0.440514 0.639771 1.390058 1.794981 0.621810 1.311431 0.767684 1.625416 1.570273 0.387894 0.736564 0.474233 0.261823 1.118332 0.820501 1.669010 0.015560 0.675733 0.978312 -0.064261 1.739844 1.817488 1.131007 0.062688 1.453390 0.448140 0.394070 0.831458 0.606366 1.363181 1.537589 0.426586 0.909340 1.240040 0.972834 0.683746 1.305881 0.259400 0.331948 0.295699 1.578329 0.042939 0.918607 1.689154 0.940724 1.007722 0.753380 1.536736 1.334795 1.258278 0.206096 0.883227 0.623082 0.840214 0.596829 1.277982 0.836896 1.407813 0.924493 1.193604 0.465208 1.513477 1.273116 0.679902 0.975579 0.664944 1.360910 -0.287799 0.710949 0.308010 -0.006577 0.020520 -0.156639 1.682660 0.621205 0.561199 0.080346)
     )

;;; 87 even --------------------------------------------------------------------------------
(vector 87 12.625063286678 (fv 0 0 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0)

     9.874660 (fv 0.000000 0.366900 0.585885 0.360276 1.741378 1.383744 0.806085 0.218985 1.748601 1.513484 1.913086 1.499231 1.804617 1.560415 0.976184 0.564077 0.614555 0.706893 1.155782 1.743949 0.256106 1.587276 1.479629 0.499900 0.621596 1.318438 0.505053 -0.000351 1.493931 0.351932 1.677582 1.117619 1.631442 0.001969 0.286212 0.372264 0.187053 0.296894 0.961309 0.849648 1.557109 1.714474 -0.039206 1.347988 1.896634 1.217858 1.504538 0.380552 0.871895 1.911392 0.768943 1.752782 0.535064 0.764217 0.468880 0.181130 0.490835 1.212121 1.451975 1.107304 0.551132 0.225217 0.930971 0.652946 1.821236 0.839189 1.745456 0.283826 1.910401 1.397382 1.626785 0.236815 0.165723 1.103589 1.501862 1.903299 0.205800 0.189795 0.285228 0.129502 1.654212 0.651262 -0.043737 0.438462 1.813853 0.852642 1.712123)

     ;; nce:
     9.877641 (fv 0.000000 -0.021457 -0.332767 0.963844 -0.139669 1.122611 0.073163 0.865822 -0.025982 1.478876 1.300682 0.423658 0.322274 1.661211 0.500543 1.705512 1.176402 0.809437 0.981075 0.972708 1.087640 1.788381 1.486099 1.855937 1.496729 1.909818 0.429000 1.696291 0.561926 0.965567 -0.162109 0.839848 1.033495 0.899864 0.728978 0.135257 1.630992 1.197929 1.514698 0.814714 1.165293 0.851600 0.892043 1.519176 1.529996 0.381556 0.396698 0.783215 0.824621 1.214567 1.738938 0.263930 0.560204 0.335777 1.558427 0.771167 0.709316 1.002333 0.687389 -0.031156 0.967435 0.220860 0.392729 1.627417 0.223702 0.908693 1.299159 1.409401 0.619154 1.469733 -0.654637 1.678656 0.999708 1.410546 1.423816 1.288829 1.153651 0.643357 0.343990 1.755018 0.782145 1.521746 0.184384 0.116670 1.179413 -0.365261 0.035182)
     )

;;; 88 even --------------------------------------------------------------------------------
(vector 88 12.661032846106 (fv 0 0 0 1 1 1 1 1 0 0 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1)

     ;; ce:
	9.812216 (fv 0.000000 0.055268 0.583779 1.234211 1.628798 0.277023 0.822779 1.625146 0.035507 0.649602 1.426919 0.034524 0.760555 1.584090 0.426236 1.297108 -0.064648 1.003285 1.954848 1.040940 1.931089 0.684474 1.457006 0.442932 1.400956 0.522371 1.821243 1.045778 -0.071524 1.059165 0.175444 1.376515 0.683418 0.093932 0.976929 0.065328 1.602577 1.185163 0.398809 1.873751 1.266959 0.334189 1.528861 1.254369 0.874420 0.121432 1.565807 1.331351 0.966676 0.377764 -0.254628 1.470234 1.160191 1.088192 0.680440 0.787715 0.046065 0.265716 -0.241611 1.809516 1.268665 1.177712 1.068293 0.934673 1.317512 0.907560 0.977837 0.781524 0.997530 0.958638 1.010309 1.152240 1.559668 1.510870 1.793541 0.022384 -0.034413 0.066685 0.419014 0.865510 1.381137 1.729658 1.950350 0.466719 0.747652 1.418392 1.765101 -0.161755)
     )

;;; 89 even --------------------------------------------------------------------------------
(vector 89 12.335865540187 (fv 0 0 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 1 1 0 1 0 1 1 0 1 0 0 0 0 1 1 1 0 1 0 1 0 1 0 0 1 0 0 1 1 0 0 1 1 1 1 1 1)

     ;; ce:
	9.997916 (fv 0.000000 0.020244 0.870163 0.459782 1.610176 0.844000 1.631839 0.198513 0.309236 0.389591 1.266554 0.907717 1.601376 1.371297 1.457522 1.745042 1.476212 0.073975 0.814060 0.353740 0.627872 0.101452 1.077167 0.352892 0.063779 0.448255 0.216020 0.534427 1.535778 -0.255643 1.360537 0.276814 0.262932 1.399548 0.980210 0.702925 0.453704 0.501694 1.341730 0.007203 0.345436 0.837214 0.770776 -0.073243 0.532634 1.583256 0.698601 0.593928 1.599304 0.808070 1.440125 1.148274 0.114072 0.434799 -0.164129 1.193330 -0.269745 0.418138 1.192504 1.289901 0.986576 0.905136 0.005956 1.233570 1.751871 1.723660 1.197839 1.205999 1.118756 1.106261 1.003380 0.216161 0.037880 0.928786 0.755785 -0.278629 0.531970 0.188018 0.465858 1.197436 0.572455 1.090538 1.091674 0.532343 0.511453 1.688563 1.590718 0.571898 1.255870)
     )

;;; 90 even --------------------------------------------------------------------------------
(vector 90 12.716424196959 (fv 0 1 1 0 1 1 0 0 0 1 1 1 1 0 1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 1 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 1 1 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 1 0)

     ;; ce:
	10.013305 (fv 0.000000 0.276249 0.662327 1.808806 0.247081 1.503786 1.940324 0.419803 0.731998 1.474410 1.308170 1.676869 1.811609 1.215798 0.664610 0.066241 0.912393 1.461826 0.512334 1.631743 1.956766 1.975237 0.185753 0.741305 0.480828 1.966454 1.916940 1.119423 0.845500 1.620533 0.975449 0.450183 0.934883 1.109333 0.667354 1.305384 1.605133 1.189882 1.538095 1.240075 1.975310 0.162522 1.100171 1.036777 1.043788 0.744032 1.593875 0.517982 0.225081 0.407155 1.741456 1.796412 1.700950 0.367751 0.443832 0.733427 0.886793 0.217138 0.457578 1.931221 1.821137 1.223426 0.206884 1.785700 -0.026139 0.112791 0.288549 1.184345 0.406919 0.005051 0.510070 1.732554 1.458011 0.524459 1.130913 0.434368 0.819466 0.015795 0.021375 1.211968 0.985111 0.213416 0.003383 0.752814 1.988526 0.349626 0.383655 1.548554 0.699363 -0.001079)
     )

;;; 91 even --------------------------------------------------------------------------------
(vector 91 12.853587071592 (fv 0 0 0 1 1 0 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 1 0 1 0 1 1 1 0 0)

     ;; ce:
	10.062777 (fv 0.000000 -0.044026 0.916183 1.049904 0.191738 0.191234 1.416236 1.067714 0.063138 1.147303 0.129837 0.429350 1.643604 1.587481 1.357034 0.252125 0.130779 1.268840 1.505767 0.040246 0.758000 0.845409 1.205711 0.041467 0.397400 0.371419 1.129085 1.761538 0.418123 -0.386013 -0.020991 1.418674 -0.227521 0.262381 1.257327 0.247702 0.200474 1.000030 0.059835 0.524653 0.278663 0.930707 1.291316 0.903105 1.153153 1.399218 1.175091 1.040190 0.853009 0.848960 0.050279 1.156146 0.310675 1.870226 0.711775 0.475029 1.761660 0.754317 0.936989 -0.122427 1.219572 0.099878 0.730317 0.306957 0.685890 1.871434 1.660611 0.509309 0.546923 0.432379 0.751420 0.579102 -0.249566 -0.007122 1.880100 1.723260 0.707224 -0.253994 0.741449 0.308553 0.722662 0.266964 1.454100 1.331867 1.250657 0.301803 0.242062 0.553976 0.852613 0.695715 0.487374)
     )

;;; 92 even --------------------------------------------------------------------------------
(vector 92 12.754180011349 (fv 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 0 1 0 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 1 1 0)

     ;; ce:
	10.123598 (fv 0.000000 0.031164 0.420530 1.499100 1.680395 0.704037 1.385766 1.730884 1.246618 0.630183 0.903224 0.818406 1.762884 0.926615 1.036829 0.514947 1.139487 1.191198 0.306323 0.126221 1.698783 1.815556 0.082954 0.421957 1.558085 -0.046639 0.629395 0.492462 0.620351 1.539766 0.337850 1.829874 -0.029044 1.650869 1.891900 -0.107840 0.000042 1.651572 0.308113 0.328220 0.164791 0.503391 1.668351 1.327181 0.552781 1.134137 0.130061 0.912409 -0.106533 1.117087 0.419486 1.645903 0.619628 0.903437 1.717082 0.277879 0.300313 -0.111169 1.701263 -0.282651 0.916960 1.725278 0.299760 0.206730 0.258427 0.976768 1.006419 1.405478 1.458477 0.511219 1.976132 0.649673 1.067569 1.036236 0.561892 1.032699 1.113462 1.760313 -0.031912 0.151642 1.253446 0.366329 -0.207662 1.411375 0.168281 1.402361 1.015831 0.966440 0.109303 1.719898 -0.033652 0.850348)
     )

;;; 93 even --------------------------------------------------------------------------------
(vector 93 12.876626968384 (fv 0 0 0 1 1 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 1 0 1 1 1 0 0 0 1 1 1 0 0 1 1 0 0 1 0 0 1 1 0 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 1 0 1 0 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 0 0 0 1 1 1 0 0 0)

     10.120779 (fv 0.000000 -0.035376 0.073991 0.427701 -0.282243 -0.018747 0.215658 -0.153445 1.426646 1.066559 1.939228 0.906624 0.410081 0.611941 0.984019 1.022397 0.624511 1.012954 0.533644 1.662254 0.644321 0.184706 0.621632 0.642800 -0.008009 1.949179 1.710653 -0.084032 0.277398 1.824022 0.699251 0.129968 1.020811 0.661971 1.702058 0.534563 1.888605 -0.287827 0.144583 1.379920 1.385073 1.054451 1.007433 0.338841 0.857467 1.489234 0.309837 0.300057 1.146999 0.772495 0.275152 0.667315 1.064213 0.727453 1.142263 1.118538 0.931092 1.595399 1.937578 1.220927 0.920538 0.541725 0.173459 0.580373 1.100745 1.191038 -0.340664 1.515332 1.223959 0.649170 0.846642 -0.414943 0.030223 1.461947 0.288064 0.141033 0.634411 1.011893 0.138288 1.584616 0.333385 0.901662 0.043826 0.951055 1.409243 0.569338 0.143517 0.644810 -0.103707 1.742249 0.748991 1.014192 0.003204)
     )

;;; 94 even --------------------------------------------------------------------------------
(vector 94 12.991560374803 (fv 0 0 1 0 0 0 0 1 0 1 0 1 1 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 1 0 0 1 1 0 0 1 0 1 1 0 1 1 1 0 1 0 1 0 1 1 1 1 0 0 0 1 0 0 1 1 0 0 0 0 1 1 1 0 0 0 1 0 0 0 1 0 0 1 0 0 1 1 0 1 1 1 1 1 1)

     ;; ce:
     10.168153 (fv 0.000000 0.158749 0.428472 1.119399 1.397485 1.337099 1.326309 0.765212 0.646549 0.366853 0.358406 0.186940 -0.004160 1.693556 1.760221 1.908281 -0.019516 0.044061 0.077064 0.115948 0.108699 0.200075 0.580690 0.574214 0.728439 1.050221 1.095053 1.499686 1.600782 1.705303 0.371346 0.785397 1.061620 1.118378 1.565155 0.180785 0.671073 0.956955 1.179900 0.062702 0.732776 1.104782 1.678100 1.936449 1.211526 1.440956 1.926880 0.701684 1.206989 0.357893 0.937759 1.642399 0.674496 1.095199 1.838835 0.811161 1.664081 0.728543 1.536793 0.935285 1.167394 0.592984 1.298896 0.711769 1.719531 0.207782 1.415604 0.678365 1.539785 1.187347 0.265338 1.410498 0.621725 1.553961 0.975230 0.124475 1.147511 0.723691 1.974302 1.764820 1.095390 0.083191 1.554760 0.873910 0.746004 0.060230 1.781492 1.338588 0.986007 0.875321 0.329252 1.786619 1.490792 0.801318)
     )

;;; 95 even --------------------------------------------------------------------------------
(vector 95 12.939489078295 (fv 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 0 0 0 1 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 0 0 0 1 0 0 1 1 0 0 1 1 0 1 1 0 0 1 0)

     ;; ce:
	10.274816 (fv 0.000000 0.191955 0.747873 1.620627 1.444931 1.117449 0.280309 0.480520 1.626406 1.210786 1.123735 0.279148 1.110058 1.602457 1.869386 0.773421 1.408758 0.850581 0.528012 0.913946 0.482409 1.573182 0.994233 1.305292 1.545980 0.033608 1.905037 0.750852 0.522232 1.918658 0.047508 1.217238 0.972743 0.083444 0.371581 0.796063 1.083361 0.261908 1.433959 0.521900 0.192999 1.966737 0.129605 0.500888 0.331274 0.913857 0.815429 1.023459 0.478085 1.566987 1.222813 1.708572 1.719376 0.723585 1.103104 1.428438 0.152348 0.040494 1.696898 0.190236 1.378447 1.550950 1.870103 1.503205 0.324210 0.355888 1.476257 1.524550 1.168199 1.485278 1.191081 0.963527 1.662530 1.621072 0.604273 0.737525 1.817225 0.670588 1.938761 1.575766 0.221849 1.885601 1.971423 1.331586 0.219292 1.195712 0.125970 0.883030 0.146163 0.807704 1.769915 -0.019375 1.792299 1.733519 1.458753)
     )

;;; 96 even --------------------------------------------------------------------------------
(vector 96 13.077001047978 (fv 0 0 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 1 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 1 0 0 0 1 1)

     ;; ce:
	10.249441 (fv 0.000000 0.009923 1.397522 1.166061 1.129381 0.862136 0.621841 0.072414 1.181071 0.867293 0.079004 1.693135 -0.014893 0.108345 1.780717 1.327197 1.625536 0.881623 1.921096 0.933503 1.182023 0.476766 1.614305 1.196403 0.811564 0.443720 1.497667 1.275176 0.722032 1.799828 1.704575 1.646983 1.348940 1.072546 0.729932 1.823713 0.260241 0.680766 1.080411 1.441731 1.246268 1.050406 0.336794 0.747049 0.875357 0.924454 1.579785 0.440504 0.667236 1.229671 0.158392 0.708858 1.967741 0.138461 0.274346 0.799091 1.692696 0.840214 1.597165 1.145148 1.181538 0.078566 1.784249 0.079340 0.404851 1.249515 0.162426 0.631488 1.171930 0.883287 1.256995 0.882531 0.425580 1.043774 0.166379 1.858551 0.915286 1.404785 1.287221 1.948447 1.096165 0.270960 1.267765 0.984855 1.705672 1.206954 1.635747 1.831700 1.675862 0.020775 1.394335 0.961664 1.111073 1.653261 0.221394 1.853173)
     )

;;; 97 even --------------------------------------------------------------------------------
(vector 97 12.969611395004 (fv 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 1 0)

     ;; ce:
	10.353915 (fv 0.000000 0.014320 1.699930 0.475338 0.327588 0.038537 1.537175 1.151125 1.532968 0.067981 0.615972 0.753995 1.850077 0.031584 -0.245176 0.175732 0.019153 0.133227 1.047045 1.449249 1.470511 1.537141 1.108379 0.638023 0.512045 -0.123137 1.442397 -0.285045 0.550401 0.725732 1.137347 0.384697 0.518421 0.107675 0.832943 1.779119 1.053524 1.101550 0.692043 0.797241 -0.542271 0.567053 0.702166 1.746525 1.756713 0.337727 1.446061 0.906449 1.109794 0.007168 1.480499 1.290329 0.754314 1.222669 -0.462191 1.087068 -0.251963 0.941593 1.663909 1.425711 -0.319978 0.693993 1.098604 -0.057825 0.103974 0.674596 -0.040855 0.861405 0.891647 0.007811 0.988956 -0.007355 1.453777 1.088127 0.560798 1.836913 1.159295 1.225761 1.137877 0.994253 -0.314791 0.194425 0.944400 0.940972 1.573317 1.084581 0.080135 1.392169 0.150957 -0.334184 0.271188 0.375796 0.741022 -0.072930 1.298672 1.087468 1.547582)
     )

;;; 98 even --------------------------------------------------------------------------------
(vector 98 13.468658765207 (fv 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 1 0 0 0 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 1 0 0 1 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1)

     ;; ce:
	10.480580 (fv 0.000000 0.029942 1.595740 0.929637 0.140250 1.273956 1.370085 1.486506 0.768736 0.810999 0.987699 0.622931 1.874848 1.232431 0.796670 -0.004456 1.530075 1.744503 -0.182347 -0.272539 -0.039867 0.251416 0.711006 1.684207 0.083442 1.563617 0.619745 1.154797 1.221621 1.412817 0.843588 0.857496 0.194384 1.348416 0.436247 0.378473 1.472625 0.199665 1.452604 1.135822 1.388047 0.919731 1.753351 0.083481 1.454770 1.242435 0.826611 -0.194897 -0.034005 0.041385 0.915233 0.468973 -0.449881 -0.034037 1.686105 0.937405 1.775189 1.272187 0.656772 0.051128 1.735808 1.941754 -0.153834 1.560953 0.798180 1.420628 1.100906 1.382273 0.014181 1.975964 0.450586 0.615591 0.885414 1.287826 0.533661 0.896633 1.605571 0.202012 1.330045 1.186911 0.653866 0.460432 0.799268 1.432588 0.419263 1.021867 0.188412 0.775135 0.208746 0.411264 0.553114 1.806129 0.584153 1.223473 0.816232 -0.069138 0.707217 1.215423)
     )

;;; 99 even --------------------------------------------------------------------------------
(vector 99 13.341398779709 (fv 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 1 1 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 0 1)

	10.395229 (fv 0.000000 0.706072 1.286640 0.926913 0.137440 1.547226 0.117224 1.604362 0.484929 0.893678 0.211396 1.934935 1.381569 0.741431 1.002510 1.548591 1.501995 1.642732 0.386486 0.063170 0.535977 1.363015 0.485356 1.002502 1.149707 1.971779 0.610054 0.176963 1.296429 0.848185 0.077879 0.989380 0.162448 1.939484 1.081728 1.291006 1.781243 0.747318 1.861605 -0.003717 0.355879 1.413789 0.958311 0.004291 0.617108 1.378378 1.118347 1.632856 0.492813 0.823307 1.406872 1.588630 0.799940 0.218833 0.397527 1.627895 0.349077 0.557886 0.566534 1.362311 0.876480 1.822463 0.047284 1.726490 0.281473 1.360892 1.302327 0.630439 0.026319 0.398853 1.499306 1.696667 1.409746 0.843535 1.156093 0.782651 0.844572 0.996729 0.505075 0.454056 0.125470 0.633842 0.812248 1.139044 1.201855 0.936107 1.075661 1.055341 1.239337 1.081381 1.450660 0.544145 0.960193 1.261524 0.471575 0.159670 1.647942 0.617964 0.426032)
     )

;;; 100 even --------------------------------------------------------------------------------
(vector 100 13.512077331543 (fv 0 1 0 1 1 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1 1 0 0 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 1 1 0 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 1 1 0 0 0 1 1 0 0 0 0 0 0)

      10.472141 (fv 0.000000 -0.079327 0.575962 1.216890 -0.014744 1.794579 0.223351 1.035736 1.450027 1.621511 1.146130 0.664482 0.663607 -0.266960 0.246822 0.754872 1.746592 -0.423496 -0.112090 1.668859 1.661047 0.950742 0.085504 0.302466 1.790192 0.512158 1.549763 -0.087872 1.606339 1.457814 0.979132 1.246348 1.572286 1.270907 0.557192 1.282392 0.773062 0.627296 0.449140 1.192929 0.105994 0.224683 -0.182519 0.743965 0.463017 1.607410 -0.217575 1.706348 1.917272 0.364576 0.425823 0.089107 1.477241 0.882347 1.143269 0.061661 0.026397 0.093540 1.833116 0.100956 -0.001875 0.084325 0.282798 1.183349 0.971365 0.306714 1.553029 0.062053 0.155585 0.754942 -0.336663 0.692895 0.554870 1.705080 0.442045 1.319460 0.995119 1.023180 1.734006 0.775241 1.099502 1.819778 -0.446034 1.513278 1.247469 0.530165 0.247921 1.473754 1.799924 0.292965 1.840516 0.908343 1.781887 1.143210 0.571911 1.546526 0.744154 1.261450 1.702101 1.407355)
      )

;;; 101 even --------------------------------------------------------------------------------
(vector 101 13.916260357992 (fv 0 1 1 1 1 0 0 0 1 1 0 1 1 0 1 1 1 1 1 0 0 0 1 1 0 1 1 1 1 1 0 1 0 0 0 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 0 1 0 1 0 0 1 1 1 1 1 1 0 1 1 0 1 0 1 1 0 0 0 0 1 1 0 1 1 1 1 0 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 0 1 0 1)

      ;; ce:
	10.577830 (fv 0.000000 0.230088 0.489949 1.896308 0.933068 0.593501 0.422308 0.060228 1.624707 0.198599 1.858938 1.074760 1.176893 0.981397 1.101455 0.671865 0.424692 0.090154 1.204682 1.678470 1.838266 0.024568 0.595975 1.448081 0.084971 1.587793 0.520717 0.874796 1.272960 1.935410 1.267081 1.651444 1.443667 0.106075 1.743028 0.700933 0.469120 0.378892 0.399951 0.519935 1.685545 1.698426 0.785883 0.473603 0.884326 1.731208 1.464294 1.924822 0.636901 0.305356 0.801079 1.744433 1.003951 0.836001 0.264502 0.624042 1.251558 0.465073 1.095465 1.359393 1.201558 0.893610 0.464655 0.265401 1.373759 1.898225 1.761890 -0.002084 1.345698 1.606225 0.081343 1.615987 1.843685 0.952555 0.240683 1.457724 0.753500 1.550264 1.132929 0.635603 1.553592 1.597112 0.562720 1.442901 1.005554 1.242061 1.201605 1.261095 1.477713 0.348336 0.005918 1.590197 0.313622 0.668027 1.281558 1.857136 1.788055 0.849243 1.615883 0.119440 1.251097)
      )

;;; 102 even --------------------------------------------------------------------------------
(vector 102 13.554303556646 (fv 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 1 0 1 1 1 0 0 0 1 0 0 1 0 1 1 1 0 1 0 0 1 0 0 1 0 1 0 0 1 1 1 0 0 1 1 1 1 0 0 0 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0)

      ;; ce:
	10.573986 (fv 0.000000 0.455448 1.592339 0.516746 1.755302 0.430730 1.719525 0.951344 -0.011584 1.094962 0.249269 1.210204 0.681046 1.814999 1.100181 0.342805 1.598301 0.973279 1.813912 1.543187 1.213360 0.476019 1.876128 1.338406 0.323141 0.086213 1.782029 1.276211 0.922086 0.263981 1.923412 1.289879 0.951410 0.707896 0.012549 1.851646 1.630674 1.384243 1.051926 0.762336 0.305766 0.298705 1.874016 1.899771 1.620966 1.734952 1.429925 1.177184 1.271518 1.112585 1.351310 1.169594 1.017169 1.072042 1.161752 0.892462 1.662674 1.237843 1.407508 1.778309 1.632181 -0.005924 0.137286 0.529299 0.602002 0.855550 1.115330 1.528193 1.708150 1.986964 0.217781 0.770088 1.353099 1.819055 0.042966 0.583719 0.854932 1.780394 1.890656 0.692898 1.277125 1.902467 0.022802 0.892858 1.554169 0.132068 0.918216 1.832708 0.149377 0.742587 1.856221 0.273349 1.013342 0.114623 0.855957 1.713909 0.875532 1.432041 0.715192 1.022773 0.307135 1.424286)
      )

;;; 103 even --------------------------------------------------------------------------------
(vector 103 13.923377530893 (fv 0 1 0 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 1 0 1 1 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0)

      ;; ce:
	10.655070 (fv 0.000000 0.098203 0.840876 1.375107 0.153742 0.905827 1.598049 0.226902 1.106387 1.951313 0.409173 1.416206 0.300008 0.991894 1.877024 0.769923 1.633937 0.581083 1.464525 0.440302 1.508923 0.447643 1.643543 0.650572 1.662974 0.812624 0.114340 1.320550 0.512587 1.607339 0.712150 1.624256 0.673697 0.132515 1.684625 1.034157 0.294350 1.413417 0.670789 0.070085 1.514860 0.928557 0.150294 1.635889 1.040664 0.560013 0.195302 1.710399 1.367615 1.043173 0.402177 1.662716 1.456941 1.147051 0.985707 0.632104 0.408799 0.275068 1.862616 1.424547 1.082981 1.090416 0.822477 0.915783 0.592819 0.610365 0.257982 0.450718 0.126885 0.491389 0.133294 0.376246 0.118720 0.195423 1.887844 0.645109 0.531798 0.762689 0.732490 0.998025 0.912568 1.060467 1.162384 1.198622 1.637406 0.207879 0.126974 0.580167 0.848976 1.222343 1.532632 1.780660 0.095903 0.581413 1.052384 1.441822 1.990917 0.734482 1.101269 1.710370 0.157742 0.650375 1.262955)
      )

;;; 104 even --------------------------------------------------------------------------------
(vector 104 14.080453047533 (fv 0 0 0 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 0 1 1 1 0 0 1 1 1 1 0 1 0 0 1 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1)

      ;; ce:
	10.681525 (fv 0.000000 -0.024256 0.783678 0.790357 0.543059 0.305361 -0.134503 0.818664 1.525254 0.494738 0.824462 0.413278 0.768548 0.076204 0.116598 0.283930 0.002578 1.585676 1.025319 1.696095 0.040592 0.097252 1.464874 0.943760 1.446445 1.337085 -0.054264 0.475515 1.125978 1.147471 1.094995 0.186610 0.588805 0.970144 0.882957 0.245963 0.284357 -0.394290 1.437271 0.927960 1.125343 0.492129 -0.680606 0.536491 0.927855 1.405256 0.384789 0.057902 1.208331 0.288662 1.508156 1.581082 1.167052 1.243667 1.226450 0.112600 1.111908 1.348016 0.638821 1.169461 0.306222 1.466381 0.659007 1.306085 1.700156 1.339421 0.711646 0.085484 0.909896 -0.178331 1.447928 0.767489 1.399367 -0.197416 1.574394 0.605814 -0.011981 -0.082006 0.824364 0.264841 1.418643 0.988277 -0.314078 0.146715 0.221811 0.630751 0.576546 0.496630 0.654974 1.143866 1.326186 1.202136 1.173988 0.681397 1.563605 0.912110 1.479070 0.009348 0.151736 0.948455 0.251873 0.215256 0.959463 1.013975)
      )

;;; 105 even --------------------------------------------------------------------------------
(vector 105 14.023490699521 (fv 0 1 1 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 1 1 1 0 0)

      ;; ce:
	10.762178 (fv 0.000000 0.397875 0.415370 0.882172 0.546824 1.353988 1.428323 0.899356 0.371635 0.978504 0.763060 1.852147 0.544169 0.212342 0.787152 0.707632 0.540670 1.634630 1.456913 1.887455 0.659515 1.903305 1.487136 0.606049 0.181640 0.198532 0.870626 0.299967 1.007267 0.225649 1.806738 0.672311 0.647212 0.706876 1.445160 0.654294 0.635429 0.365790 0.507155 0.852393 0.362305 0.862000 0.544259 1.758526 1.506465 1.313083 0.892464 0.407338 1.550831 0.757533 1.555137 -0.026848 1.155141 1.305207 1.788542 1.889285 0.358766 1.027604 0.314507 0.587817 0.916345 0.200487 1.411080 1.048840 1.178903 0.194143 1.901728 1.960301 1.945844 1.173118 1.765984 0.206171 1.625946 0.040059 1.626954 0.263952 1.564387 1.266244 1.622196 0.755369 0.949828 0.255858 0.753659 1.729344 1.050369 1.743664 1.440420 0.145640 0.301718 1.174665 0.822890 1.317300 1.570892 0.407998 0.956005 1.432600 0.239369 0.699233 1.040355 0.955730 0.525379 0.245609 0.402988 1.983561 1.494957)
      )

;;; 106 even --------------------------------------------------------------------------------
(vector 106 14.077123010357 (fv 0 0 1 1 0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 1 0 1 0 0 1 1 0 1 0 0 0 0 1 0 1 0 1 0 0 1 1 0 0 0 0 1 1 1 0 1 1)

      ;; ce:
	10.830737 (fv 0.000000 -0.005846 0.570672 0.234799 1.335287 1.359588 -0.419716 0.539638 0.608529 0.339921 1.061903 -0.158242 -0.044398 1.229716 1.763841 1.099423 1.509512 0.089726 1.005316 -0.075124 -0.066461 1.466196 0.771111 0.468552 1.415804 0.138963 -0.245805 0.138836 0.477088 1.188902 1.132158 1.069838 1.264025 0.968611 1.914288 1.097597 1.541915 0.300326 1.372837 1.925102 1.312271 -0.023238 1.373743 1.323233 1.094484 0.489712 0.482163 1.087861 0.500643 0.570320 1.558451 0.587192 1.367163 1.157295 0.201827 0.338548 0.589886 0.627255 0.836138 0.810466 -0.203530 1.496837 1.317835 0.258851 0.104005 1.762383 1.590637 1.892947 1.673713 0.391886 0.132951 1.390857 1.679677 1.113406 0.925816 1.243522 0.395898 -0.235350 0.125786 0.071751 0.796497 -0.006564 0.517719 0.324240 -0.029479 1.648460 0.422894 0.173347 0.366226 -0.269652 0.667311 0.224137 1.099578 1.062306 -0.039311 0.586541 0.652636 1.087861 0.037847 0.544588 -0.167470 1.665629 0.356235 0.598705 1.690854 1.284152)
      )

;;; 107 even --------------------------------------------------------------------------------
(vector 107 13.979104817741 (fv 0 0 0 1 0 1 0 0 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 0 0 1 0 1 1 1 0 1 0 1 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 0 0 1 0 1 0 1 1 1 0 0 1 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 0 1 1 0 1 1 0 0 0 0 0 1 0 1)

      ;; ce:
	10.937211 (fv 0.000000 -0.004224 0.060024 -0.045111 1.214471 1.071129 0.959468 -0.117229 0.526421 0.777989 1.101830 1.594870 1.129631 1.240597 0.114410 -0.015477 -0.160025 1.227190 0.975588 0.257050 0.062807 0.334972 0.704097 1.491576 0.263834 0.840227 0.134041 0.515784 0.095610 1.204429 1.214110 -0.209995 0.542934 1.280779 0.060334 1.305652 0.399609 0.055093 1.015156 -0.124325 0.060155 1.228735 0.771913 1.621598 0.808853 1.471209 -0.169978 1.121641 0.399914 1.719441 0.379423 1.503274 1.042517 0.685780 0.947470 0.570388 0.750717 1.227614 1.713741 0.574606 1.613832 0.259018 1.237457 1.030851 1.608948 1.331324 0.222275 1.365789 1.141241 0.137043 0.400610 0.136266 1.777801 -0.008027 -0.188345 0.319469 0.129091 -0.503698 1.075061 0.022495 -0.104170 1.746336 1.362807 0.487726 1.046216 1.025881 -0.113705 0.257262 0.139668 0.033537 0.410121 0.067540 0.536883 1.096402 0.595602 1.418336 1.800057 0.344577 0.240890 1.498996 -0.357281 0.342654 1.655013 1.372406 1.308709 -0.240755 1.334030)
      )

;;; 108 even --------------------------------------------------------------------------------
(vector 108 14.201394892821 (fv 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1)

      ;; ce:
	10.928835 (fv 0.000000 0.001349 1.292491 0.733848 1.693309 1.799399 0.481169 -0.003953 0.631395 1.556718 0.747743 0.394608 -0.163614 0.178289 1.389719 1.500511 0.566775 1.069628 0.140033 0.292869 1.057556 -0.232775 1.757479 1.152928 0.313785 -0.002063 1.713110 1.409517 1.701701 0.540017 -0.081333 0.363976 1.907649 1.714406 0.366131 1.312522 1.061649 -0.016307 1.204902 0.111229 1.131127 1.599963 0.195405 0.048689 0.148454 1.536192 1.518659 0.029237 0.220432 0.060747 0.889494 0.493752 0.976299 1.363602 1.809211 1.216107 0.616567 0.927578 1.398521 0.961300 1.194676 0.366929 1.180567 1.477072 0.270916 0.119650 1.287137 1.475762 1.163703 1.481070 1.371759 0.541244 1.311014 1.044588 1.313660 0.533979 1.490951 0.356285 -0.069909 0.767914 0.271739 0.014710 1.682385 0.162634 1.095329 0.775810 0.661086 0.068467 1.450209 1.785189 0.063589 1.966358 1.523081 1.437414 0.274911 0.580082 1.089239 -0.463689 1.664646 1.305111 1.466902 1.475663 0.556905 0.115271 0.981770 0.504641 0.709948 1.631495)
      )

;;; 109 even --------------------------------------------------------------------------------
(vector 109 14.476561866583 (fv 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 0 1 0 0 0 1 0 1 1 0 0 1 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 1 1 1 0 1 1 1)

      ;; ce:
	10.962218 (fv 0.000000 -0.020139 1.296818 0.759398 1.805908 1.100728 0.800122 1.439412 1.622620 0.514993 1.795449 1.209391 0.020235 0.358160 0.092111 0.419753 0.215041 0.890857 0.739133 0.655070 -0.097603 1.149145 1.795049 0.529356 0.278854 0.849651 1.115508 -0.203443 -0.316571 0.636461 0.169404 0.863285 1.244658 0.826671 1.217995 1.641136 1.077104 1.940135 -0.019991 0.361800 0.684590 0.618864 1.574258 0.100541 0.539464 1.815288 0.854878 0.087950 0.096927 0.551713 0.357857 0.524099 0.322958 1.655523 1.025258 0.447127 1.801347 0.241837 1.863980 1.144261 1.218309 0.839437 0.457453 0.658738 1.245153 1.083988 0.663284 0.430502 0.960078 0.132118 0.667264 0.423888 1.801298 1.342075 0.136707 0.381362 0.568108 1.442671 0.522741 -0.163023 0.297994 0.902549 1.034272 0.408426 0.838530 1.491663 1.889043 0.510513 1.243885 -0.037162 0.829406 0.263055 1.957688 1.777764 1.532407 1.532356 -0.098135 1.343701 -0.090007 1.030266 0.540482 0.697946 0.058406 0.051557 1.224797 1.605931 1.084281 1.340523 0.856409)
      )

;;; 110 even --------------------------------------------------------------------------------
(vector 110 14.141825477743 (fv 0 0 0 0 1 0 1 0 1 1 0 1 0 0 1 0 0 1 1 1 1 1 0 1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 1 0 0 1 0 0 0 1 0 1 1 1 0 1 1 1 0 0 1 1 1 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 1 1 1 1 0 0 0 0)

      ;; ce:
	11.083621 (fv 0.000000 0.102224 0.391557 0.595597 0.594876 1.372717 0.692712 1.820557 0.592991 0.744933 0.284097 0.094534 1.236489 0.656692 0.836105 1.286301 1.045083 0.906213 0.452242 1.303365 1.815972 0.742162 1.260200 1.034689 1.519277 1.714910 0.030360 1.701396 0.878133 1.252260 1.563515 1.824493 1.440884 0.550691 0.625323 0.322441 0.255155 1.747348 1.715563 1.206982 0.695445 1.179481 0.756077 1.528329 0.919865 1.229029 1.159425 1.320573 0.445003 1.914934 0.957065 0.751755 0.916124 0.636546 1.677594 1.368208 1.478534 0.887675 1.827907 0.505854 0.598384 0.760342 0.616916 0.235984 0.997501 1.394766 0.145444 0.892122 1.825648 1.436307 0.231097 0.844561 0.320584 0.655075 0.450233 0.147790 1.886750 0.073198 0.684099 0.980548 1.422263 1.230129 0.607855 1.708107 1.670067 1.087055 1.809960 1.108445 0.779703 1.445375 0.004959 0.570411 1.025881 0.429647 0.658700 0.663819 0.227169 1.057047 0.056802 0.087954 1.060399 1.762629 1.235596 0.276822 0.266842 1.518690 1.130656 0.442538 0.924181 1.667970)
      )

;;; 111 even --------------------------------------------------------------------------------
(vector 111 14.043108609984 (fv 0 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0 0 0 0 0 0 0 1 0 1 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 1 0 0 0 0 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 1 1 0 1)

      ;; ce:
	11.044285 (fv 0.000000 0.158015 0.933037 1.614942 0.438728 1.109662 1.925788 0.472812 1.243741 0.106020 0.791740 1.640176 0.492268 1.485008 0.348988 1.215620 0.210371 0.907594 1.877045 0.815828 1.746879 0.708997 1.883211 1.043991 0.199639 1.074067 0.180622 1.253869 0.348260 1.556554 0.806309 0.044157 1.125294 0.382590 1.810361 1.146217 0.335649 1.611965 0.680338 1.937389 1.233789 0.766403 0.308709 1.641326 0.874950 0.294876 0.039653 1.398544 0.690400 0.241248 1.690671 1.329862 0.933824 0.621841 0.215994 1.901023 1.430062 1.233607 0.739730 0.472666 0.123106 0.067252 1.738994 1.459373 1.478846 1.201845 1.291598 0.805256 0.526423 0.555011 0.429805 0.468900 0.550665 0.287845 0.418385 0.091842 0.561234 0.306326 0.551107 0.349285 0.443927 0.497444 0.741730 0.889477 1.210808 1.343091 1.439025 1.479999 1.836181 0.047632 0.373687 0.550415 0.777036 1.388872 1.698564 0.091159 0.463192 0.987707 1.050209 1.564941 1.953806 0.531885 1.227608 1.522869 0.053791 0.776531 1.501133 1.889970 0.686171 0.911252 1.640718)
      )

;;; 112 even --------------------------------------------------------------------------------
(vector 112 14.53456401825 (fv 0 0 0 1 0 0 0 1 1 0 0 0 1 0 1 0 1 0 1 0 0 0 0 1 1 1 0 0 0 0 1 0 1 1 1 1 1 1 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 0 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 1 1 0 0 1 1 0 0 1)

      ;; ce:
	11.132899 (fv 0.000000 -0.004199 1.283910 0.989370 -0.208623 1.916334 0.074521 1.835438 1.334006 0.305929 1.500009 -0.074494 1.168847 0.049877 1.276892 1.333761 -0.092116 1.454810 0.477624 0.576171 0.178508 0.764025 0.524952 1.017918 1.503303 0.222438 0.024354 0.989207 -0.051649 0.790422 1.303684 -0.215343 0.911639 1.672316 0.816315 1.393173 1.438934 1.325167 0.960271 0.472591 1.161764 -0.301446 0.550621 1.114416 1.344136 1.489640 1.336572 0.050968 0.500820 -0.057732 1.192684 1.166393 1.318354 1.292569 1.273498 0.099165 0.438587 1.952651 -0.094274 1.629010 1.153422 1.621198 0.812392 0.958180 1.035359 0.874583 0.398809 1.397735 0.813120 1.083168 1.586479 1.738041 -0.184237 0.887045 0.555348 1.573618 0.841883 0.094362 0.127164 -0.091421 0.370018 0.132149 0.004963 0.522483 0.330656 0.374322 1.610332 1.059431 0.769509 1.653723 0.151945 1.881470 1.251612 1.570585 0.545409 0.439130 1.754244 0.242385 1.453705 1.649898 0.928413 0.488588 1.234024 -0.316648 1.499904 0.614604 0.329349 1.231718 0.063978 0.324984 0.806167 0.116728)
      )

;;; 113 even --------------------------------------------------------------------------------
(vector 113 14.699631659332 (fv 0 0 1 1 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 0 1 1 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0)

      ;; ce:
	11.086230 (fv 0.000000 -0.000389 -0.085077 1.561730 0.939636 0.783800 0.822356 0.753902 1.063386 1.064106 0.248945 -0.331235 0.891273 0.384236 1.666476 1.209055 0.747827 1.261264 0.977109 0.473018 1.869842 1.640635 0.426272 0.493282 0.533612 0.678013 0.886344 1.278452 0.240683 0.355081 0.485535 1.773399 1.825457 0.749792 0.520365 0.198490 0.250957 0.893317 0.038147 1.767495 1.585752 1.382949 0.153130 0.345263 1.470526 1.544311 -0.012268 0.353892 0.265833 0.472828 0.199271 0.570776 0.068734 -0.052674 -0.058660 0.544786 0.747249 1.268098 -0.214510 0.394163 0.864637 0.802715 -0.354031 0.495687 0.772508 0.500088 0.648134 0.893273 0.437351 0.101751 1.505344 1.430317 1.237725 -0.133160 1.737117 0.276904 0.819294 -0.436692 0.255417 1.171282 -0.127128 0.741289 1.135948 0.224854 1.189320 1.263745 1.436981 1.094323 0.315920 0.551659 -0.076936 0.988425 0.147044 1.117725 1.898145 1.201889 0.000719 0.311682 0.796660 0.441683 0.674490 1.525693 0.432480 -0.261252 0.793197 1.692433 1.264116 1.229766 1.345051 1.012949 0.026436 1.326999 0.385241)
      )

;;; 114 even --------------------------------------------------------------------------------
(vector 114 14.492 (fv 0 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 1 1 0 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 1 0 0 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 1 0 0 0 0 0 1)

      ;; ce:
	11.157135 (fv 0.000000 -0.039464 0.696620 1.049808 1.784392 0.325544 0.858380 1.305402 0.025713 0.621307 1.231983 1.810377 0.686152 1.384942 0.194646 1.038532 1.591698 0.399402 1.138014 1.856685 0.607032 1.487902 0.438056 1.390980 0.254957 1.178058 0.067020 0.938265 1.875276 0.851076 0.004242 1.047055 0.045055 1.007007 0.277254 1.473760 0.430329 1.411705 0.732780 1.815871 0.875020 0.057294 1.303464 0.776395 0.029104 1.052938 0.330119 1.901182 1.233681 0.357134 1.566517 1.090726 0.497634 1.859625 1.337968 0.810851 0.475823 1.810735 1.275081 0.613201 0.249187 1.680606 1.475238 0.917317 0.615081 0.035115 1.985536 1.555790 1.295493 0.711316 0.674571 0.194958 0.031526 1.689053 1.752486 1.376552 1.332463 1.199628 1.038471 0.887824 0.776195 0.244582 0.396901 0.380408 0.272363 0.437965 0.462200 0.460243 0.479976 0.174041 0.442325 0.587458 0.662414 0.624435 0.793505 1.270764 1.312001 1.527872 1.906728 0.154209 0.367925 0.274540 0.568448 0.741643 1.347518 1.802398 -0.015484 0.528377 1.078486 1.236948 1.800583 0.083771 0.530926 0.938750)
      )

;;; 115 even --------------------------------------------------------------------------------
(vector 115 14.568 (fv 0 1 0 1 0 0 1 1 0 1 0 1 0 1 0 1 0 0 0 1 0 0 1 1 1 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 1 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 0 0 0 1 0 0 1 0 1 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 0 1 0 1 0 0 1 1 1)

      ;; ce:	
	11.164043 (fv 0.000000 -0.007735 0.519521 0.853408 0.869518 0.698179 0.507264 1.931615 0.907177 -0.081980 1.081445 -0.614824 0.113202 -0.200689 1.235563 -0.410618 -0.044424 1.664294 0.004420 -0.047758 -0.084756 0.183149 0.916469 0.869368 0.512976 0.672797 1.215314 0.375058 0.915864 1.704866 0.936574 0.218869 0.698296 0.045271 1.628914 0.078964 0.149407 0.338531 0.117882 -0.320994 1.491596 1.006019 -0.240429 1.202447 1.241878 1.751514 1.720285 0.676992 -0.221839 1.582392 1.209034 1.838537 0.581983 1.407446 0.568243 0.270174 1.675976 1.382944 1.186838 0.261842 1.726931 1.658063 1.186047 0.622126 0.744214 1.106115 1.040724 0.077608 1.153074 1.203757 -0.097198 0.746254 0.828552 0.000738 0.431630 0.964545 1.375943 1.286789 1.299809 0.427471 1.340955 0.754972 1.408156 0.094923 0.222079 1.183606 -0.446708 1.549043 0.356824 0.090057 -0.448761 1.856851 1.141144 -0.262172 1.428502 1.426364 0.962275 0.289782 0.928089 1.983331 -0.130528 1.708026 0.141800 0.998440 0.458314 -0.400945 1.256766 -0.158747 1.393865 0.122714 0.409705 1.066166 0.512662 1.368814 -0.157203)
      )

;;; 116 even --------------------------------------------------------------------------------
(vector 116 15.016979484255 (fv 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 0 1 0 1 0 0 1 0 0 0 1 0 1 0 0 1 1 0 1 1 1 0 1 1 1 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 0 0 1 0 0 1 1 0 1 1 0 0 1 1 1)

      ;; ce:
	11.308873 (fv 0.000000 0.106229 0.367548 0.759703 1.450113 0.465588 0.341776 1.222993 1.113540 1.977777 0.446611 1.479153 0.955230 1.992164 0.113898 1.375014 0.059260 1.796441 0.549529 1.451646 0.822821 0.184153 0.830995 0.917449 1.204323 1.332702 0.993172 0.476637 0.152682 0.285363 1.211807 1.922965 1.934074 0.639385 1.616893 0.230624 1.048187 1.300335 1.518811 0.179696 1.385435 1.756315 0.391503 1.071522 1.058267 0.918446 1.149703 1.296773 1.452377 0.657106 1.424678 0.536336 1.485981 1.611780 0.685035 0.081570 0.627797 1.372075 1.222404 1.169964 1.598122 0.868152 1.372826 0.969303 1.586861 1.193094 0.604224 0.998617 0.464449 0.148345 1.841878 1.782198 1.348866 0.090916 1.094752 0.710300 0.820593 1.392694 1.514436 0.049760 1.558012 1.165815 1.487314 0.076812 1.896177 1.104849 0.595775 1.855654 1.593410 0.247419 1.353710 0.594589 0.610661 1.819899 0.938600 0.733465 1.567730 0.600698 0.773170 0.184194 0.659368 0.319562 0.537696 0.610429 1.447619 1.265473 0.841708 1.485819 0.127545 1.328769 1.079928 0.763531 0.772097 1.829006 1.877480 1.871926)
      )

;;; 117 even --------------------------------------------------------------------------------
(vector 117 14.875072951405 (fv 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 0 1 1 1 1 1 0 1 0 1 1 0 1 0 0 1 0 1 1 0 0 1 1 0 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 1 1 1 1 0 1 1 0)

      ;; ce: 
	11.316924 (fv 0.000000 0.002007 0.781183 0.142859 1.136983 0.564897 1.668822 1.434278 0.786253 -0.066154 0.611443 0.995393 0.251112 1.435273 1.364551 0.525535 1.314966 0.129127 0.479417 1.253995 -0.066213 1.791978 1.010496 1.762957 1.001915 0.214345 0.247689 0.903489 0.260750 0.253476 1.207167 1.205379 1.535712 0.678624 0.281388 0.707771 0.067718 0.139190 1.072777 -0.486251 1.036395 0.468802 1.185352 1.038535 0.280173 0.909530 -0.484113 1.287468 1.260568 1.711487 0.150804 1.583879 0.090810 1.204628 1.205628 1.363904 1.302202 -0.374153 1.893817 1.633143 0.456452 1.096868 0.228741 1.451713 1.797254 1.457252 0.043295 1.213733 1.209057 1.602790 0.068325 1.156775 0.622551 0.595184 1.038306 1.138842 -0.234118 1.017885 1.021316 0.185827 1.543882 1.771287 1.232077 0.638733 0.782279 1.727494 1.416897 0.927851 0.310771 0.940398 0.359593 0.479087 0.049395 0.127472 0.206640 1.096147 1.150359 1.659289 0.531691 1.180395 -0.391853 1.508862 1.232699 -0.058238 1.293947 -0.476640 -0.441677 -0.000097 0.976133 1.008107 0.426436 0.349033 0.468049 0.890361 0.742074 -0.282223 0.097574)
      )

;;; 118 even --------------------------------------------------------------------------------
(vector 118 14.774983755641 (fv 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 1 0 0 1 0 0 1 1 0 1 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 0 1 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 0 1 1 1)

      ;; ce:
	11.484440 (fv 0.000000 0.001991 1.371443 1.203612 1.612576 0.004093 1.549674 1.288096 -0.387029 0.195003 0.810853 0.270601 -0.577973 0.504742 1.563436 0.486759 1.262262 1.570710 0.506761 0.593681 0.979316 0.335707 1.012168 1.408672 1.854537 -0.158648 0.922395 1.542523 0.986042 0.834203 1.587297 -0.259646 0.182780 1.551059 1.155567 -0.257572 1.455112 0.260440 0.601953 0.584384 0.049890 0.147201 0.144045 0.167346 1.932438 -0.017361 0.127366 1.610439 0.342924 0.013626 1.817380 1.463720 1.349166 1.704788 0.073700 0.915288 0.862503 0.591911 -0.314143 1.485517 0.827715 -0.237036 1.912130 0.274385 1.072007 0.283372 1.321692 0.776602 1.550269 0.993130 0.787661 0.571393 0.826289 1.556852 0.493665 1.623055 1.585319 1.166393 1.153368 1.675993 0.390711 -0.188185 1.283768 1.613360 0.827291 0.287448 0.106800 0.359659 1.804631 1.116403 1.085383 0.798175 1.148482 1.482094 1.397430 -0.132223 0.799212 -0.083458 -0.185498 0.780581 -0.264041 0.816859 1.276724 0.301164 1.464050 0.647926 1.027415 1.036757 -0.070219 0.009504 1.202438 0.566235 0.360100 -0.509218 0.735525 1.198215 0.064044 0.933335)
      )

;;; 119 even --------------------------------------------------------------------------------
(vector 119 14.971 (fv 0 1 0 0 1 0 1 0 0 1 1 1 0 1 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 1 1 1 0 0 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 1)

      ;; ce:
	11.482774 (fv 0.000000 0.022508 -0.154621 -0.133560 0.019055 0.044006 0.744199 -0.189660 1.646970 0.323873 1.389900 0.872285 1.714451 0.465026 0.101347 1.045318 0.619662 0.299667 0.695492 1.761299 -0.465991 1.247091 0.360217 0.709249 0.270723 1.861018 1.538710 1.394055 1.300550 0.683046 1.420419 1.591103 0.068117 0.694826 0.315654 0.206747 0.551524 0.669546 0.407597 0.609362 1.957764 1.313475 1.269191 1.535059 -0.453483 1.127112 -0.438414 1.098010 0.925063 1.295295 0.349547 1.800021 1.265884 1.210725 1.261945 1.409059 0.031987 1.064471 1.087820 0.131065 1.230087 1.008698 0.646880 1.108562 0.465537 -0.286867 1.491020 1.274669 0.240579 1.517428 0.852795 0.970665 0.563004 0.179967 1.049271 1.080429 0.558118 -0.026181 0.946833 1.033681 0.158731 0.889882 0.983418 -0.020663 1.724961 1.892566 0.743055 1.647217 1.582049 1.007387 1.541602 0.779919 1.494250 -0.227797 0.081916 -0.223533 0.250776 1.270562 1.106978 1.124428 0.217158 1.341937 0.121564 0.628868 -0.092377 1.005391 0.266805 1.036087 -0.286050 1.835950 0.190028 0.634731 1.031073 0.250385 1.062823 1.900473 0.065255 0.789889 1.186094)
      )

;;; 120 even --------------------------------------------------------------------------------
(vector 120 15.153992567168 (fv 0 0 1 1 0 0 1 0 1 0 0 1 0 0 1 0 1 1 0 0 1 0 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 0 0 0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 1 0 0 0 0 0 1 1 1 0)

      ;; ce:
	11.467293 (fv 0.000000 0.182387 0.991318 1.555550 0.388952 1.165472 1.861486 0.514097 1.467680 0.222754 0.972121 1.805786 0.710465 1.475951 0.467146 1.464916 0.222083 1.170792 0.137691 0.926627 1.940353 0.964985 0.072695 1.174272 0.187090 1.145640 0.255557 1.524936 0.697660 1.793860 0.870660 1.991349 1.164698 0.214289 1.427601 0.920631 0.315825 1.506380 0.771158 0.081551 1.397459 0.660219 0.101946 1.376912 0.742252 1.975042 1.384246 0.994395 0.741688 0.116508 1.476904 0.995545 0.574556 -0.050092 1.395747 1.037641 0.654167 0.178367 0.000799 1.661003 1.401198 1.027447 0.549822 0.319024 -0.009775 1.643655 1.451741 1.190761 1.247596 1.019397 0.814792 0.637301 0.619820 0.528955 0.206546 0.210086 1.907606 0.080551 1.852358 0.220977 0.039775 0.240556 0.118697 0.201230 0.183490 0.410415 0.195004 0.346621 0.384871 0.552316 0.919228 0.966578 1.294194 1.669482 1.481782 1.816544 0.045277 0.459121 0.610971 0.884884 1.313099 1.767978 0.251484 0.557317 0.967847 1.457578 1.608185 1.982656 0.491182 1.030233 1.763557 0.343009 0.756305 1.429088 0.071947 0.646318 1.100378 0.016785 0.234469 0.966926)
      )

;;; 121 even --------------------------------------------------------------------------------
(vector 121 14.652157793709 (fv 0 0 1 1 0 0 1 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0 1 1 0 0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 1 1 0 0 0 1)

      ;; ce:
	11.519858 (fv 0.000000 0.011378 1.753896 1.437136 0.631135 0.114781 0.660482 1.334498 0.581894 0.089402 1.905979 0.990187 0.248688 0.037998 1.898481 0.142274 0.776484 1.706556 0.191753 0.338054 1.318431 0.126497 0.601712 -0.255350 -0.163162 0.402669 1.476694 -0.235785 0.342102 -0.362582 1.698550 0.968284 0.940716 1.711626 1.326298 1.313163 0.329811 1.359487 0.105165 0.702440 0.022566 -0.069577 1.342187 0.008210 1.716840 0.240520 -0.171785 1.502743 1.676402 1.248370 0.723049 1.865376 0.001307 0.034537 0.684465 1.516715 0.492834 1.116078 0.672438 1.182471 0.641149 0.373795 0.379475 0.145636 0.762178 0.433641 0.347370 0.948832 -0.132296 -0.133379 1.190338 1.266604 1.009701 0.238209 0.752479 1.596905 -0.296398 -0.192578 0.605136 0.075081 1.420344 0.466284 -0.288768 1.297330 1.689017 1.567153 1.185252 0.260951 0.236638 1.431783 0.599599 1.509650 0.653104 0.899471 1.457027 1.068607 0.961380 1.256645 0.033616 -0.139517 0.092125 1.417841 1.213189 1.821992 1.761054 0.238734 0.417918 0.642844 -0.104823 0.081427 0.065359 0.670607 1.054994 1.082441 -0.176585 1.119180 -0.224101 0.108660 -0.203752 0.470242 1.351870)
      )

;;; 122 even --------------------------------------------------------------------------------
(vector 122 15.057187309653 (fv 0 0 1 0 1 0 1 1 0 0 0 0 1 1 1 1 0 0 1 1 1 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 1 0 1 0 1 1 0 1 1 0 1 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 1 1 1 1 1)

      ;; ce:
	11.608575 (fv 0.000000 0.491043 0.007498 0.791398 0.660542 0.960014 1.233279 1.608131 1.227878 1.325414 0.833262 0.826707 1.074054 0.805872 0.453534 0.680408 0.163876 1.857437 1.971814 1.942244 1.528127 1.170281 1.451447 1.612886 0.379280 0.469353 0.748640 0.861019 0.289879 1.554726 0.245277 0.578277 0.944303 0.525039 0.312641 0.462849 0.710444 0.524042 0.736659 1.743905 0.289146 1.405383 1.146345 1.959424 1.266837 0.105168 0.264372 0.716079 0.180416 0.676462 1.349909 0.242201 1.112324 1.903652 0.096097 0.298665 1.938506 0.907637 0.445138 0.676772 1.018566 1.538692 1.890411 1.037889 1.754475 0.454828 0.375080 1.028535 1.584256 0.107387 0.732227 1.941438 0.410085 0.465514 0.392267 1.461968 0.104792 1.428078 0.866762 0.928264 0.963879 0.060101 0.001979 1.538408 1.110694 0.832374 1.363340 1.030944 1.856655 0.680542 1.663245 1.268139 0.925891 1.913766 1.292282 1.484272 0.663172 0.251878 0.695143 1.443461 0.967688 0.177908 1.246199 1.066133 0.923551 1.951433 0.308206 1.532986 1.662559 1.880618 0.612432 0.084712 1.836918 1.410469 0.509104 0.078690 0.955183 1.487132 0.007102 1.473132 0.898543 1.722166)
      )

;;; 123 even --------------------------------------------------------------------------------
(vector 123 15.156582832336 (fv 0 0 0 1 1 0 1 0 0 0 0 0 1 1 0 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 0 1 1 1 0 1 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 0 0 0 1 1 0 1 1 1 0)

      ;; ce:
	11.636238 (fv 0.000000 -0.006745 1.718129 0.124324 0.694087 1.248162 1.264742 -0.205335 0.401180 1.175941 1.275199 0.664232 1.306473 1.775017 0.032088 1.172990 1.182530 1.684652 1.496052 1.018965 1.419875 1.724105 0.881080 0.365436 1.623371 0.118184 1.144470 1.090686 0.455215 1.110091 1.537843 1.409976 0.722528 0.766713 0.291253 1.154526 0.688621 0.079128 0.455767 1.072502 0.449509 1.072583 0.529271 0.933123 1.665962 0.456257 0.965966 0.378656 1.446789 1.599052 -0.405591 0.510787 1.741784 0.047873 1.179439 0.534603 0.738060 1.583394 -0.036662 0.033912 0.990276 0.359185 -0.041714 1.309428 0.206155 0.615264 1.013822 0.916642 1.092385 1.276567 0.943657 1.397941 1.325784 1.841099 0.255550 0.983848 0.698027 0.630229 0.444618 1.485280 0.538087 1.172707 0.510703 0.139282 1.060931 1.974722 0.748366 1.241445 1.282543 1.643915 -0.055670 1.226488 1.259535 1.054944 0.867004 1.180445 0.871590 -0.304557 0.449098 0.105044 0.415180 1.325658 1.915647 1.593801 1.274805 -0.206650 -0.888906 0.385364 0.203928 0.267603 1.679470 1.529346 0.775016 1.650475 0.752800 0.231942 -0.128889 1.695246 -0.352686 0.872132 -0.113288 1.107634 0.969190)
      )

;;; 124 even --------------------------------------------------------------------------------
(vector 124 15.192802705519 (fv 0 1 0 1 0 0 0 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 1 1 1 1 0 0 1 0 0 1 1 1 1 1 0 0 0 1 0 0 0 0 1 1 1 0 0 1 0 1 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 0 0 1 0)

      ;; ce:
	11.657070 (fv 0.000000 -0.014444 0.618588 1.072923 1.770483 0.269156 0.799491 1.415133 0.042486 0.667402 1.107625 1.860582 0.629761 1.228415 0.069647 0.757140 1.477152 0.235584 0.874179 1.620964 0.498598 1.283127 0.032336 0.931298 1.753048 0.690202 1.655180 0.637473 1.388106 0.380043 1.352876 0.417570 1.513619 0.398780 1.331736 0.297986 1.356056 0.723808 1.880303 1.075552 0.270324 1.454538 0.409485 1.419750 0.727467 0.088163 1.085380 0.180158 1.411841 0.476674 0.009315 1.487690 0.712294 -0.024891 1.362496 0.659010 -0.191074 1.370827 0.842745 0.281346 1.600375 1.056928 0.756127 0.303601 1.748097 1.271638 0.793604 0.293922 -0.112046 1.276835 1.265355 0.825565 0.530280 0.127474 1.794406 1.661127 1.499821 1.002415 0.662420 0.351459 0.106647 -0.108853 1.731304 1.778120 1.591760 1.488839 1.111393 1.249609 0.941574 1.119732 0.633391 0.859266 0.602796 0.706230 0.723444 0.862387 0.960018 1.160855 0.914474 1.092081 1.010153 1.292261 1.124565 1.486704 1.752791 1.765950 0.121592 0.301316 0.732598 0.775797 0.931505 1.227451 1.354358 1.806530 0.301686 0.668653 0.912777 1.521847 -0.005389 0.243631 0.695894 1.356048 1.421601 -0.009388)
      )

;;; 125 even --------------------------------------------------------------------------------
(vector 125 15.340427254326 (fv 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 1 0 1 0 1 1 0 1 0 0 0 1 1 1 1 1 0 1 0 1 0 0 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 1 1 1 0 0 0 1 1 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0)

      ;; ce:
	11.726117 (fv 0.000000 -0.030799 0.144449 1.728737 0.676919 0.980768 0.920869 0.523856 0.255848 1.651421 0.139364 0.110259 -0.007857 -0.065476 0.898902 0.948218 0.041888 0.431499 0.955394 1.279597 0.899810 0.236632 1.338434 0.051979 0.022413 1.076247 0.455727 1.395710 0.537276 1.454562 -0.640673 1.646766 0.563227 0.468669 0.349014 0.207631 1.436456 -0.313434 1.039871 1.394849 1.334026 0.410015 0.714625 0.314535 0.295044 0.730112 0.878789 0.469330 0.349941 1.427732 0.501996 1.482747 1.311352 1.023386 -0.133711 0.934640 1.777275 0.139714 0.307620 0.411617 0.680605 1.805628 0.987833 -0.006267 1.325295 0.129226 0.029571 -0.131946 1.571497 0.134896 1.855074 0.957063 1.276873 0.033353 0.738862 1.196621 0.702473 1.212401 0.334974 0.594964 -0.391144 1.491428 1.659733 1.324319 0.593336 1.121378 1.836235 -0.494188 -0.410122 0.669230 1.852484 1.550441 0.612411 1.088978 0.233243 0.429977 0.213254 1.111633 0.529727 1.280152 1.687453 0.208804 0.661537 0.543046 1.373269 -0.302027 0.236049 0.167939 1.751438 0.754446 0.306753 -0.393681 0.981979 0.613716 0.543141 0.783701 1.211717 0.696576 0.743400 0.902651 1.308022 0.648265 1.051117 0.596115 0.465417)
      )

;;; 126 even --------------------------------------------------------------------------------
(vector 126 15.28212621738 (fv 0 1 0 1 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 1 0 0 1 1 1 1 0 1 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 0 0 0 1 1 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 0 0 0 0 0 1 0 1 0 1 1 1 1 0 0 1 1 1 0 1 1 0 1 0 0 1 0 0 1 1 1 0 1 0 0 0 0 0 1 1)

      ;; ce:
	11.728732 (fv 0.000000 0.080423 0.859652 1.251285 0.001006 0.708480 1.329479 1.910986 0.575680 1.212005 1.941153 0.634379 1.324750 0.149467 1.036506 1.708281 0.612012 1.577838 0.338405 1.197595 0.029554 0.897812 1.895059 0.811840 1.778431 0.660286 1.607791 0.800800 1.947497 0.840295 1.874911 0.873100 1.809637 0.999296 0.039834 1.184996 0.352552 1.522062 0.693733 0.018959 1.247028 0.457540 1.699479 1.003229 -0.011631 1.387625 0.675778 1.873479 1.137263 0.739657 0.006673 1.350424 0.946270 0.348539 1.590673 1.018988 0.508851 1.844396 1.236918 0.897127 0.426111 1.973108 1.634669 1.217265 0.734120 0.464551 1.899258 1.421045 1.113676 0.840738 0.386615 0.153879 1.864697 1.811230 1.560296 1.258544 1.008246 0.775514 0.569961 0.379626 0.120794 0.073632 1.824999 1.979635 1.804273 1.934045 1.809824 1.823348 1.667350 1.525160 1.703620 1.223510 1.668539 1.353060 1.680931 1.768624 1.959157 0.014225 0.272244 0.168722 0.385113 0.365860 0.784448 0.739738 0.967615 1.309874 1.705334 0.092760 0.302680 0.844130 0.978941 1.342601 1.583162 1.784704 0.228093 0.608194 1.171628 1.840667 0.207453 0.811900 1.464070 1.557525 0.111382 0.715963 1.219826 1.691486)
      )

;;; 127 even --------------------------------------------------------------------------------
(vector 127 15.237931718393 (fv 0 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 1 0 1 1 0 1 0 1 1 0 1 0 1 0 1 0 0 0 1 1 0 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1 1 1 0 0 0 1 1 1 0 0 0 0 0 1 1 1 0 1 0 1 1 0 0 1 0 0 1 0 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0)

      ;; ce:
	11.791982 (fv 0.000000 -0.006501 0.895946 0.390502 1.267039 0.777220 0.845244 1.619366 1.738905 1.963883 0.834239 -0.095420 1.729892 0.328487 0.839467 -0.107042 0.077371 1.006289 0.934388 1.316468 0.399445 1.446071 0.867321 0.749721 0.310809 0.608045 0.928981 0.860186 0.132975 0.107680 0.035103 0.310673 1.698683 1.209244 1.219344 1.008158 0.868768 0.774429 0.524607 1.259150 0.968654 0.225551 0.670254 0.584349 1.206486 0.849939 0.881353 1.316256 1.223028 -0.051550 1.266841 0.533270 0.307133 0.871408 0.135067 0.350791 1.392175 1.398704 1.054665 1.094835 0.720758 1.235433 1.111126 1.315441 0.540735 1.759697 1.421149 1.220945 1.416174 0.271820 0.476065 0.346906 0.599580 1.865670 -0.010232 0.873428 0.191144 -0.138143 0.473276 0.793750 0.140345 0.466125 0.753788 0.166751 0.509961 1.311817 1.848999 0.485052 0.151803 1.266182 1.022497 -0.055512 1.662000 1.747291 0.161074 0.983665 1.511467 0.958919 1.602506 1.536897 -0.682895 0.108054 0.153831 0.495344 -0.168193 1.039701 1.035352 0.840794 0.198694 1.029171 0.222780 1.379441 0.220019 1.296462 0.080553 0.616328 1.212980 -0.006268 1.810129 0.820776 0.816381 1.107475 0.666818 -0.087937 0.128508 1.246653 0.713705)
      )

;;; 128 even --------------------------------------------------------------------------------
(vector 128 15.651492555885 (fv 0 0 0 1 0 0 1 0 0 1 1 1 0 1 1 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 1 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 1 1 1 0 1 1 0 1 1 0 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 0 1 1 0 0 1 1 0 0 1 0 0 0 0 1 0 1 0 1 1 0)

      ;; ce:
	11.856765 (fv 0.000000 0.002702 1.085974 1.244165 0.302147 1.259231 0.307623 1.789071 0.248647 1.161010 1.314907 0.079451 1.835817 1.698549 1.371220 1.062438 -0.405684 -0.007858 1.415666 0.290877 1.615872 1.200022 1.723864 1.253269 0.379007 0.343005 0.128516 0.302246 -0.164454 0.039402 1.245595 0.229693 0.371762 0.212878 1.130208 0.211997 1.630376 0.731113 -0.271994 0.633039 1.003806 0.078215 0.728092 1.810709 1.419272 0.630789 0.702176 0.258274 1.627944 0.906125 1.142708 1.149739 0.327453 0.775766 1.891018 0.949407 1.868463 0.197100 0.436054 0.455859 1.396494 1.235603 1.184602 0.213251 0.192580 1.964426 0.843243 1.673738 -0.209417 -0.268734 0.946608 0.413048 1.382483 0.177431 0.571412 0.488003 0.422161 0.038021 -0.036166 0.871695 -0.124327 0.115262 1.774007 1.705740 -0.048183 0.114070 0.284773 0.198720 1.083200 1.095261 1.210900 1.153612 1.411655 -0.216841 0.226895 0.871232 1.590562 1.732972 1.482631 1.243964 0.261758 -0.017247 1.413734 0.786022 0.083529 1.333636 0.641441 1.707810 0.335402 0.567273 1.111144 1.682879 0.513761 1.029576 1.342257 1.314503 1.650528 0.559848 0.478412 -0.031753 0.050313 0.117019 1.542665 0.315940 1.287375 1.423028 0.248383 1.516714)
      )

;;; 256 even --------------------------------------------------------------------------------
(vector 256 24.434719362486 (fv 0 1 1 0 0 0 0 0 0 1 1 0 1 0 0 0 1 1 1 0 1 1 0 1 0 1 1 1 1 0 1 0 0 1 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1 0 0 0 0 1 1 1 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 1 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 0 0 0 1 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 1 0 0 1 0 0 1 1 1 0 0 0 0 1 1 0 0 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 1 0 1 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 0 0 1 1 1 0 0 1 0 1 0 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1)

      ;; ce:
	16.895858 (fv 0.000000 -0.009189 0.902358 0.365887 -0.111323 -0.780998 -0.023618 -0.522343 0.279380 0.055265 -0.008058 0.474170 0.130008 0.951121 -0.734333 0.844285 0.824339 -0.107239 0.507621 0.164958 -0.496056 -0.789687 0.259333 -0.449818 0.843661 -0.030179 -0.474099 0.774618 -0.182868 0.024412 0.577418 -0.074812 -0.020675 0.192634 -0.599606 -0.070169 -0.948055 -0.992660 0.778395 -0.043578 -0.432579 -0.186685 -0.510874 -0.014069 -0.480270 0.346549 0.508024 0.846868 -0.259984 -0.239547 -0.834355 0.758428 0.757435 0.373609 -0.602450 0.574091 0.372351 0.871018 -1.004894 0.279914 0.796533 0.315579 -0.170724 -0.162430 -0.867211 -0.645076 0.714848 -0.271719 0.114112 0.067143 0.832100 -0.116990 -0.262191 -0.281235 -0.535795 0.830911 -0.182047 0.489779 0.867411 0.246384 -0.008329 -0.604672 0.770953 -0.982833 0.931441 -0.618590 -0.552932 0.209497 -0.183212 0.365740 0.769646 0.703588 -0.289040 -0.817528 -0.369365 0.293481 0.472048 0.790519 -0.426911 0.891352 -0.538143 -0.944128 -0.920976 0.221321 -0.509927 -0.348596 -0.644560 -0.213342 -0.745624 -0.706666 0.930922 -0.848273 -0.242448 -0.036301 0.898791 -0.590640 0.780449 -0.061417 0.458673 -0.691004 -0.831524 0.551686 0.225320 0.474068 0.953196 -0.781398 0.825342 0.760168 0.391595 0.124100 0.860713 -0.055973 0.585971 -0.869796 1.059960 -0.289476 -0.119142 0.020537 -0.912617 0.156202 0.608148 0.008605 -0.492103 -0.103742 0.428971 0.411193 -0.565692 0.935156 -0.112585 0.617223 -0.155032 0.327195 0.230999 -0.493871 -0.157653 0.741876 0.652071 0.725265 -0.509926 -0.435321 0.803678 0.422316 0.647203 -0.330251 -0.717114 -0.003821 -0.171433 0.905326 -0.870296 -0.075782 -0.123811 -0.827857 0.305695 -0.297883 0.361037 0.368875 0.307670 -0.861180 0.111296 0.743619 -0.505788 0.890369 -0.751559 0.768455 0.001867 -0.755119 0.593706 0.249715 0.003021 0.017365 -0.006817 0.077961 0.209405 -0.908703 -0.016914 0.016411 -0.745949 -0.862316 0.805206 -0.373876 -0.644818 0.552974 -0.723400 0.564147 0.221354 0.241461 -0.891285 0.457125 0.981689 -0.591672 -0.034527 -0.765054 -0.120687 0.438528 0.848881 -0.507062 0.069395 0.639313 -0.825275 0.641684 -0.188946 0.565634 -0.791635 -0.287596 -0.132874 -0.202513 0.559214 0.080018 0.796540 0.338441 0.210736 0.641999 0.009248 0.322360 -0.028925 0.697480 0.479428 0.122723 0.885702 -0.174527 0.157389 0.019802 0.207762 -0.007817 -0.188184 0.284891 0.769384 -0.699713 -0.860470 0.816560 0.661637 0.821235 0.090760 0.680062 0.906877 -0.017234)
      )

;;; 512 even --------------------------------------------------------------------------------
(vector 512 35.776 (fv 0 0 1 1 0 1 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 0 1 1 1 1 1 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 1 0 0 1 1 1 1 1 0 1 0 1 0 1 0 1 0 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1 0 1 0 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 1 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 1 1 1 1 0 1 1 1 0 1 0 1 1 0 1 1 0 0 0 1 1 0 1 1 1 0 1 1 1 1 0 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 1 0 1 1 0 1 0 1 1 0 1 1 1 0 0 1 0 1 1 0 0 1 1 1 0 1 1 0 0 1 0 0 0 1 1 0 1 1 0 0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 1 0 1 1 0 1 0 1 0 1 1 0 1 0 1 1 1 0 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 1 0 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 1 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 0 0 1 1 0 1 1 1 0 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 1)

      ;; from (try-all :even 512 513 0.0057725498034576  0.26769012113045) = 29.0733
      ;; ce:
	24.510365 (fv 0.000000 -0.019547 0.424156 1.640830 1.364680 1.818776 1.105842 0.737080 1.188869 0.460419 0.154877 0.614397 1.827954 1.526781 0.018169 1.203682 0.956144 1.444331 0.584264 0.344508 0.856804 -0.002275 1.790988 0.291010 1.439116 1.211881 1.741084 0.845603 0.707294 1.180635 0.339890 0.164786 0.645301 1.820612 1.656940 0.157290 1.307936 1.130965 1.686613 0.833679 0.620052 1.209627 0.322209 0.138398 0.734419 1.838268 1.653494 0.235420 1.341020 1.194471 1.729004 0.905361 0.771623 1.262727 0.487832 0.366383 0.843119 0.069579 1.963835 0.460118 1.649699 1.520680 0.055018 1.185740 1.101098 1.643899 0.752530 0.667948 1.169078 0.382792 0.269771 0.820501 0.061364 1.929744 0.493658 1.740499 1.549752 0.138458 1.334798 1.217842 1.724754 0.932476 0.823652 1.326258 0.605394 0.510375 1.024728 0.340933 0.185795 0.774497 0.036705 1.862931 0.456043 1.668642 1.590302 0.139925 1.318436 1.326961 1.864132 1.011509 1.051965 1.624689 0.808072 0.775618 1.339118 0.606082 0.484361 1.076072 0.379297 0.250899 0.852275 0.110682 0.007792 0.595200 1.830378 1.789905 0.359788 1.659536 1.611286 0.154864 1.497402 1.399711 1.998779 1.270070 1.199870 1.801564 1.085483 1.010139 1.613933 0.921049 0.862702 1.434888 0.750644 0.728545 1.284532 0.570978 0.570652 1.118882 0.422457 0.414420 0.977086 0.320768 0.330042 0.881914 0.218609 0.199085 0.805391 0.088964 0.043485 0.695205 -0.000491 1.966513 0.612316 1.930538 1.950727 0.563038 1.854742 1.879285 0.451929 1.795108 1.794421 0.370361 1.783471 1.745602 0.399279 1.738776 1.661161 0.350902 1.625174 1.614568 0.302843 1.577093 1.678861 0.313770 1.663823 1.660571 0.328157 1.709209 1.610846 0.310206 1.720381 1.669108 0.335355 1.656296 1.693491 0.346281 1.654195 1.699773 0.373651 1.773772 1.752470 0.473140 1.826907 1.822715 0.581620 1.832675 1.919552 0.622630 1.929526 0.005176 0.677897 0.085092 0.090877 0.761048 0.206124 0.205634 0.890197 0.304835 0.339949 1.002646 0.395940 0.448746 1.152273 0.561345 0.581101 1.310704 0.737714 0.744961 1.486545 0.848210 0.931544 1.627529 1.007712 1.110684 1.778206 1.199087 1.278685 -0.040639 1.383705 1.405450 0.148513 1.511196 1.633778 0.391073 1.740722 1.849679 0.658438 0.031218 0.137149 0.870371 0.331222 0.296051 1.070588 0.528400 0.591834 1.345092 0.751955 0.829846 1.642139 1.030239 1.201544 1.943718 1.298486 1.407002 0.143893 1.607481 1.695116 0.415675 1.905744 -0.027620 0.742513 0.206291 0.320377 1.123679 0.506496 0.647078 1.425059 0.880594 0.962991 1.736110 1.225483 1.369479 0.064842 1.600531 1.706861 0.517054 1.973656 0.069623 0.837048 0.295925 0.404900 1.263222 0.684812 0.775618 1.577141 1.057937 1.264522 0.064638 1.531997 1.682245 0.471443 1.922985 0.104388 0.897292 0.423113 0.526550 1.412335 0.758158 0.917306 1.736464 1.285171 1.451805 0.278569 1.745150 1.879876 0.677038 0.183709 0.366812 1.118883 0.736257 0.864386 1.688806 1.159516 1.253423 0.100375 1.645658 1.871576 0.762011 0.249411 0.395560 1.273133 0.699592 0.948774 1.805372 1.338330 1.530595 0.294092 1.900787 0.034538 0.923012 0.390364 0.586314 1.386265 1.030145 1.202559 0.071001 1.609371 1.743831 0.671235 0.194183 0.391537 1.251984 0.751826 1.009573 1.860932 1.448367 1.525073 0.422286 -0.073409 0.262981 1.099563 0.626545 0.818453 1.723102 1.361444 1.531582 0.390953 1.909101 0.215438 1.139977 0.737652 0.881882 1.821234 1.380301 1.618894 0.473317 0.045322 0.250969 1.146414 0.800355 0.959156 1.857842 1.429019 1.673847 0.622261 0.184525 0.502145 1.323715 0.914639 1.172552 0.096636 1.761155 1.977345 0.871966 0.396190 0.668483 1.677724 1.221155 1.466337 0.368967 0.009966 0.302335 1.180746 0.786475 1.025502 -0.022711 1.584463 1.830638 0.746555 0.413840 0.650268 1.656745 1.224810 1.557055 0.513491 0.173029 0.435007 1.290629 0.926051 1.263115 0.272344 1.896521 0.084566 1.048863 0.725520 0.987362 -0.027617 1.571108 1.900984 0.869809 0.386916 0.758635 1.730437 1.409025 1.672233 0.588812 0.243929 0.511763 1.494695 1.169935 1.437757 0.431437 0.111507 0.458811 1.437247 1.136523 1.434884 0.401589 0.040030 0.372128 1.370962 0.999488 1.378913 0.377301 -0.009324 0.355264 1.331258 1.008855 1.339035 0.373593 0.044480 0.312196 1.329497 1.000220 1.342701 0.417261 0.083063 0.411303 1.346062 1.090657 1.409862 0.373501 0.211768 0.447452 1.458597 1.131955 1.458774 0.553807 0.205989 0.569249 1.645656 1.188483 1.668112 0.674809 0.371651 0.732131 1.751447 1.522458 1.904784 0.884407 0.617430 0.990830 0.073047 1.730004 0.133217 1.189522 0.869836 1.203019 0.328634 0.051596 0.424552 1.471161 1.210755 1.549745 0.605989 0.343260 0.768857 1.816839 1.581320 1.934635 1.014299 0.737558 1.116115 0.236955 0.018173 0.380416 1.539634 1.251595 1.652099 0.829587 0.536746 0.936033)
      )

;;; 1024 even --------------------------------------------------------------------------------
(vector 1024 51.895 (fv 0 1 0 0 0 1 1 0 0 0 0 1 0 1 0 1 1 1 1 0 1 0 0 1 0 1 0 1 1 1 1 0 1 1 1 1 1 0 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 0 0 1 1 1 0 1 1 0 0 1 0 1 1 1 0 0 1 0 0 0 0 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 1 0 1 1 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 1 1 0 1 1 1 1 0 1 0 1 1 1 0 1 0 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 1 1 0 1 0 0 0 0 0 0 1 1 1 0 1 0 0 1 1 1 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 0 1 1 1 0 1 0 1 0 1 0 0 0 0 1 1 1 1 0 1 0 1 1 1 1 1 0 0 1 0 1 0 1 0 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 1 0 1 1 1 0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 1 0 1 1 1 0 1 1 0 1 1 1 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 0 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 0 0 1 1 0 0 1 0 1 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 1 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 0 0 0 0 0 1 0 1 0 0 0 1 0 0 0 1 0 1 1 1 0 0 1 1 0 1 1 0 1 1 1 1 0 0 1 0 0 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 0 1 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 0 0 0 0 1 0 1 0 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 1 1 0 0 1 0 0 1 1 0 0 0 1 0 0 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 1 0 0 0 1 1 0 1 0 0 1 0 1 1 1 0 0 0 1 1 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1 0 0 0 1 0 1 1 0 1 1 1 1 0 1 0 0 0 0 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 0 0 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 1 1 0 0 1 0 0 0 1 0 0 1 1 0 0 1 1 0 1 0 0 0 0 0 1 0 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 1 0 1 0 0 0 1 0 0 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 1 0 0 1 1 1 1 1 1 1 0 1 0 1 0 0 0 0 1 0 0 1 0 0 0 1 0 1 0 0 1 0 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 1 0 0 0 1 0 1 1 1 1 1 0 0 0 0 1 0 1 0 1 0 0 1 0 0 1 1 1 0 0 1 1 0 0 1 1 1 1 0 1 0 1 0 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 0 0 1 1 0 0 0 1 0 0 1 0 1 1 0 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 0 1 0 1 0 0 1 0 0 0 0 1 1 0 1 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 0 1 1 0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 1 0 1 0 1 0 1 1 1 0 1 0 1 1 0 0 1 1 1 1 1 1 1 1 1 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 1 0 0 1 0 0 0 1 1 1 0 0 1 1 1 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 0 1 1 1 0 0 1 1 1 1 0 0)

       ;; ce:
	34.486667 (fv 0.000000 0.010065 0.257552 0.593803 0.986349 1.354691 1.689002 0.065945 0.448419 0.795563 1.178916 1.585370 1.936149 0.310262 0.750710 1.056729 1.463725 1.825064 0.240816 0.539819 0.934214 1.340840 1.748800 0.092213 0.555713 0.915825 1.311840 1.650847 0.107697 0.477455 0.875194 1.288435 1.748432 0.197793 0.591516 1.015839 1.387092 1.854496 0.260210 0.614591 1.088807 1.497165 1.960609 0.347241 0.837150 1.265241 1.711792 0.103196 0.588662 1.043276 1.427385 1.898809 0.315073 0.790510 1.283232 1.726769 0.124226 0.582532 1.048754 1.444755 1.928781 0.425680 0.899080 1.335881 1.855991 0.327701 0.850115 1.267294 1.746464 0.254433 0.681023 1.221402 1.713475 0.176608 0.633457 1.170011 1.638469 0.136940 0.628672 1.079274 1.611588 0.107068 0.579047 1.125534 1.649825 0.159484 0.714499 1.195717 1.694762 0.283005 0.777095 1.317639 1.818676 0.294685 0.848021 1.366508 1.912960 0.442114 0.974399 1.491097 0.046085 0.607725 1.172318 1.701676 0.262890 0.804042 1.333049 1.847711 0.428372 0.986686 1.556422 0.120990 0.632701 1.249707 1.826221 0.398395 0.969062 1.507301 0.132868 0.725711 1.273823 1.851630 0.403540 1.046615 1.591703 0.182065 0.801530 1.386897 0.003430 0.562296 1.182148 1.798000 0.384640 0.992083 1.618128 0.211791 0.774713 1.389562 -0.001657 0.608366 1.236020 1.865011 0.529780 1.135532 1.738754 0.419570 1.019563 1.624992 0.265061 0.904049 1.533452 0.168181 0.865137 1.479101 0.127557 0.777817 1.390745 0.031342 0.661481 1.347873 -0.028252 0.673301 1.341813 0.012139 0.723533 1.359095 0.015081 0.667348 1.354810 -0.010820 0.651242 1.361901 0.014799 0.676361 1.414902 0.077676 0.777314 1.483046 0.156058 0.835487 1.534362 0.214249 0.944327 1.656367 0.337182 1.061518 1.736952 0.487837 1.221677 1.941805 0.641987 1.334519 0.012624 0.761615 1.493616 0.235055 0.987696 1.681644 0.449481 1.152512 1.880553 0.557489 1.300096 0.093548 0.829304 1.606739 0.333558 1.038662 1.817653 0.564596 1.346595 0.088231 0.789038 1.556219 0.364445 1.109277 1.894547 0.648472 1.394876 0.167696 0.927734 1.744135 0.473122 1.327580 0.053170 0.846408 1.630482 0.424396 1.252576 0.026366 0.794678 1.571738 0.353780 1.148629 -0.009061 0.802059 1.560730 0.388025 1.189760 -0.020908 0.838019 1.634252 0.450483 1.274303 0.061988 0.909080 1.739029 0.567344 1.395698 0.191004 1.056594 1.900321 0.701479 1.570664 0.420443 1.216101 0.035038 0.906051 1.794894 0.619739 1.485033 0.319328 1.177367 0.049998 0.912455 1.796694 0.663275 1.464877 0.322458 1.201076 0.079874 0.975135 1.812753 0.671629 1.550884 0.438265 1.308416 0.227568 1.107771 0.008272 0.852340 1.757258 0.665419 1.573359 0.450697 1.364674 0.288498 1.149330 0.046861 0.927672 1.818815 0.731499 1.703383 0.640630 1.515945 0.404842 1.338883 0.309581 1.223075 0.140786 1.078108 -0.017158 0.933921 1.856585 0.819946 1.718757 0.674573 1.629213 0.552624 1.480565 0.473092 1.440553 0.370780 1.316286 0.261652 1.233065 0.181284 1.136614 0.128844 1.063581 0.043473 0.988622 -0.007730 0.942926 1.896166 0.930670 1.890388 0.822783 1.839642 0.888701 1.829032 0.748117 1.787911 0.785711 1.793168 0.753464 1.768597 0.785917 1.789379 0.746424 1.769933 0.789526 1.789893 0.806228 1.806824 0.845014 1.858918 0.876599 1.887462 0.916183 -0.011424 0.947836 0.026544 1.052806 0.074297 1.092552 0.117837 1.145621 0.172062 1.271069 0.265950 1.343262 0.368273 1.426940 0.471985 1.600258 0.591440 1.643063 0.779963 1.778002 0.823172 1.887460 0.980164 0.056312 1.104881 0.194563 1.270671 0.317598 1.432357 0.527173 1.586831 0.679001 1.710986 0.856576 1.952932 1.034214 0.168860 1.247239 0.332452 1.455153 0.496571 1.598578 0.746454 1.841506 0.980194 0.065850 1.191729 0.313463 1.362280 0.540259 1.674133 0.807281 1.901298 1.046989 0.152754 1.296905 0.437367 1.599457 0.712142 1.832022 1.021052 0.159471 1.255226 0.399699 1.567354 0.776219 1.903366 1.055241 0.221691 1.359842 0.508090 1.682588 0.830923 0.010406 1.164777 0.321654 1.495630 0.648746 1.854778 1.028798 0.224012 1.437178 0.587301 1.746745 0.969426 0.124185 1.311647 0.558251 1.730677 0.926291 0.114111 1.341596 0.557527 1.745728 0.936491 0.127337 1.383134 0.617625 1.786691 1.023246 0.229459 1.472437 0.676585 1.907197 1.123237 0.355057 1.633938 0.880784 0.058692 1.279872 0.552335 1.779394 1.011586 0.276736 1.508029 0.759625 0.024536 1.276380 0.493761 1.728419 1.013811 0.266997 1.523472 0.795713 0.046243 1.307283 0.623236 1.877970 1.148383 0.427672 1.683629 1.001954 0.298274 1.554589 0.835462 0.173731 1.457407 0.693880 -0.034472 1.275602 0.593467 1.866633 1.210093 0.521728 1.772084 1.113712 0.385701 1.695457 1.069859 0.333163 1.607126 0.969652 0.282736 1.586932 0.934788 0.272131 1.571926 0.921386 0.293345 1.575513 0.936770 0.269737 1.574193 0.968165 0.284669 1.613899 0.986360 0.310459 1.654676 0.993511 0.432366 1.747611 1.058842 0.426357 1.800267 1.182611 0.576028 1.923944 1.270340 0.656610 0.044384 1.408707 0.752047 0.170780 1.558617 0.971026 0.315606 1.679451 1.091283 0.469917 1.819954 1.288114 0.668750 0.054741 1.461129 0.888977 0.275646 1.712213 1.100500 0.539170 1.932708 1.357198 0.750588 0.169930 1.599158 1.015737 0.433884 1.847466 1.290316 0.699471 0.106715 1.618980 1.039270 0.483584 1.877301 1.355281 0.739383 0.283415 1.680260 1.142458 0.582946 0.025158 1.503785 0.917235 0.402386 1.888910 1.374775 0.801742 0.267251 1.729725 1.190453 0.690588 0.170200 1.607615 1.116870 0.626944 0.099949 1.558114 1.042989 0.565792 0.001984 1.534796 0.981050 0.506989 0.024697 1.512493 1.045167 0.509838 0.035449 1.540981 1.040413 0.579777 0.067009 1.583544 1.092800 0.643044 0.165297 1.660919 1.190925 0.750261 0.244662 1.789497 1.303951 0.852702 0.402882 1.925637 1.511267 0.983904 0.525287 0.093612 1.625678 1.236625 0.751894 0.317275 1.862598 1.434730 1.003450 0.590395 0.130259 1.632064 1.251831 0.793529 0.395744 1.982905 1.518992 1.185899 0.724078 0.280841 1.851085 1.414649 1.036031 0.628024 0.190307 1.817967 1.407380 0.997638 0.626750 0.187117 1.827944 1.364014 1.005368 0.643575 0.271950 1.870132 1.455625 1.102716 0.663688 0.366474 1.947786 1.531948 1.165389 0.820292 0.417060 0.106203 1.736409 1.349795 1.017056 0.602019 0.247808 1.904232 1.522798 1.168173 0.822339 0.502122 0.190982 1.830461 1.503095 1.146005 0.824132 0.425448 0.163732 1.809535 1.439358 1.134762 0.787451 0.444950 0.125696 1.859821 1.507864 1.225427 0.898766 0.552383 0.249459 1.921771 1.641843 1.335828 1.036153 0.712405 0.407286 0.113814 1.810275 1.573082 1.216807 0.937380 0.622140 0.413886 0.065441 1.811766 1.479615 1.239853 0.962208 0.676221 0.428567 0.149787 1.861526 1.595913 1.378366 1.072254 0.858051 0.546952 0.352387 0.048977 1.781409 1.500802 1.320643 1.034780 0.814060 0.561026 0.270289 0.105077 1.781981 1.587128 1.356228 1.096895 0.899561 0.695426 0.422635 0.191053 0.015040 1.742763 1.540766 1.372440 1.135422 0.929280 0.712972 0.501615 0.300048 0.059338 1.847659 1.743466 1.446302 1.288333 1.097146 0.896394 0.693469 0.504749 0.273709 0.134422 -0.008122 1.752436 1.590209 1.416861 1.263443 1.015309 0.919786 0.724562 0.550733 0.413427 0.220154 0.085059 1.972253 1.758570 1.618664 1.418349 1.309492 1.092633 0.962125 0.822521 0.683138 0.548516 0.433745 0.271343 0.157018 -0.024488 1.878961 1.706051 1.633364 1.472286 1.423267 1.197350 1.130839 0.991815 0.864748 0.717411 0.656940 0.500335 0.378398 0.306249 0.174522 0.042370 1.957239 1.876551 1.787343 1.657177 1.630866 1.501218 1.454476 1.399481 1.281728 1.174679 1.094880 1.013897 0.872646 0.836534 0.733703 0.745572 0.645048 0.520901 0.517442 0.446338 0.403105 0.220915 0.272964 0.177893 0.121891 0.010365 -0.003026 -0.000541 1.946558 1.858421 1.798242 1.770282 1.765566 1.731024 1.646864 1.612063 1.606047 1.594080 1.512626 1.534901 1.459982 1.452555 1.426312 1.441887 1.450640 1.394928 1.401770 1.413824 1.398282 1.361199 1.386696 1.351788 1.315050 1.337782 1.369731 1.375462 1.382434 1.387327 1.390480 1.425063 1.472649 1.428947 1.444989 1.479959 1.454545 1.459856 1.514843 1.537769 1.564144 1.568551 1.669900 1.683717 1.723822 1.813102 1.823001 1.907890 1.890197 1.964939 -1.797036 0.049327 0.116611 0.169727 0.229816 0.312230 0.322585 0.436099 0.459978 0.494355 0.617621 0.657990 0.713966 0.784856 0.873687 0.939607 1.031179 1.056185 1.173421 1.311953 1.410978 1.454966 1.612093 1.676857 1.761378 1.862190 1.974384 0.042558 0.158632 0.245595 0.350975 0.483237 0.594289 0.729058 0.805700 0.959748 1.072984 1.213228 1.313277 1.445492 1.585944 1.673320 1.810642 1.960761 0.110169 0.205253 0.318753 0.449203 0.638254 0.764806 0.903920 1.064434 1.168013 1.366785 1.485581 1.644159 1.803584 -0.028237 0.153100 0.380114 0.509401 0.641451 0.849001 1.016399 1.215481 1.423241 1.573069 1.764733 1.942264 0.047242 0.295850 0.470228 0.640443 0.830347 1.055180 1.227983 1.357851 1.599606 1.739714 -0.029549 0.205220 0.379610 0.585030 0.816103 1.019847 1.251050 1.461935 1.647821 1.868576 0.147180 0.369132 0.579279 0.840715 1.094368 1.320093 1.565710 1.787983 -1.714361 0.195527 0.507750 0.710357 0.949912 1.153061 1.372724 1.700420 1.865502 0.178913 0.436041 0.694461 0.986729 1.187621 1.476665 1.752454 0.027539 0.321199 0.550142 0.802831 1.077337 1.362471 1.620159 1.900867 0.213014 0.446588 0.803703 1.113716 1.403572 1.697697 0.018021 0.315688 0.615559 0.932639 1.205074 1.541734 1.854009 0.125499 0.502519 0.744264 1.071360 1.395926 1.658298 -0.006671 0.333250 0.704886 1.026706 1.348527 1.693526)
       )

;;; 2048 even --------------------------------------------------------------------------------
(vector 2048 87.471149563312 (fv 0 0 1 0 1 1 0 0 0 0 1 0 1 1 1 1 0 1 0 1 1 1 1 0 1 0 0 0 0 0 1 0 1 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 0 1 0 0 1 1 0 1 1 0 0 1 0 1 1 0 0 0 0 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 0 1 1 1 0 0 1 1 1 1 0 1 0 1 0 1 0 0 1 1 1 0 0 1 0 0 1 1 1 0 0 1 1 0 1 1 0 0 0 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 0 0 1 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 1 1 0 0 1 0 1 1 1 0 1 1 1 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 0 0 0 0 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 0 0 0 1 1 0 0 1 1 1 0 1 0 0 0 1 1 1 1 0 1 0 0 0 1 1 1 0 0 0 1 1 1 1 0 0 1 0 1 0 1 1 0 1 1 1 1 1 1 0 1 1 1 0 0 0 1 0 1 1 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 1 1 0 1 1 1 1 0 0 0 1 1 1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 1 0 1 0 0 1 0 0 0 1 1 1 0 1 1 1 0 1 1 1 1 0 1 0 0 1 0 0 1 0 0 0 1 1 0 1 0 1 1 1 0 0 0 1 0 1 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 0 0 1 0 1 0 0 1 1 1 0 1 0 0 1 0 0 0 0 1 0 1 0 0 0 1 0 1 1 1 0 1 1 0 0 1 0 1 0 1 0 0 1 0 1 0 0 0 1 1 0 0 1 1 0 0 0 0 1 1 0 0 0 0 0 1 0 1 0 0 1 1 1 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 1 0 1 1 1 1 0 0 1 0 0 0 0 1 1 1 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 0 0 0 1 1 0 0 0 0 0 0 1 1 0 0 1 1 1 0 0 1 1 1 1 1 1 0 0 1 0 1 1 1 1 1 0 1 0 1 1 1 0 1 1 1 1 0 1 0 1 1 0 0 1 1 1 0 0 0 1 1 1 0 1 0 1 1 1 0 0 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 0 0 0 0 1 1 1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 0 0 1 1 1 0 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1 0 0 0 1 1 0 0 0 1 1 0 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 1 1 0 0 0 1 0 0 1 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 0 0 1 0 0 1 0 1 0 0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 1 1 1 0 1 0 0 0 1 1 0 1 0 1 0 0 0 1 0 1 0 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 0 0 0 0 1 1 1 0 0 1 0 0 1 1 1 1 0 0 0 1 0 0 1 0 0 1 0 0 0 1 0 1 0 1 1 0 1 0 1 0 1 0 1 0 0 1 0 0 1 0 1 1 0 1 1 0 0 0 1 0 1 0 1 0 0 0 1 0 1 1 1 0 0 1 1 1 0 0 1 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 0 1 1 0 1 1 0 1 0 0 1 0 1 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 1 0 1 0 1 0 0 1 1 0 1 0 0 0 1 1 1 1 1 1 0 1 1 0 1 0 0 0 0 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 0 0 1 0 1 1 0 0 1 0 0 0 0 0 1 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 1 1 1 0 0 0 0 1 0 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 1 0 1 0 1 0 0 1 1 1 0 1 0 0 1 1 0 0 0 1 0 0 0 0 1 0 1 1 0 1 1 0 0 0 1 1 1 0 1 0 0 0 0 0 1 0 0 0 0 1 1 1 1 0 0 1 1 1 0 0 0 1 0 1 1 1 1 1 0 0 1 0 1 1 0 0 0 0 1 1 1 0 1 1 1 0 1 1 0 0 0 1 0 1 1 1 0 1 0 0 0 0 0 1 1 0 0 0 1 1 1 1 1 0 0 1 1 0 1 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 1 1 0 0 1 1 0 0 1 0 0 1 1 1 1 0 1 0 0 1 0 0 1 1 1 0 0 1 0 0 1 1 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0 1 0 1 1 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 1 0 1 0 0 0 1 1 1 1 0 1 1 0 0 1 1 1 0 1 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 0 0 1 0 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 0 0 0 1 1 0 1 0 0 0 0 1 0 1 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 1 0 1 1 1 1 1 1 0 1 1 0 0 1 1 1 0 0 0 0 1 0 0 0 1 1 0 1 0 0 1 1 0 1 1 0 1 1 1 0 0 1 0 1 1 1 0 0 1 0 0 1 0 0 0 0 0 0 1 0 0 1 1 1 1 0 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 1 1 1 1 1 0 1 0 0 0 1 1 1 0 1 1 0 0 1 0 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 1 1 1 1 1 1 1 0 1 1 0 0 1 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 0 1 0 0 1 1 1 1 1 0 1 1 0 0 1 1 1 1 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 0 0 1 1 0 0 1 0 0 0 1 1 0 1 1 1 1 0 1 1 0 1 1 0 0 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 1 1 0 1 0 1 1 0 0 0 0 1 1 0 0 1 0 1 1 0 0 0 1 1 0 0 0 0 1 0 1 1 0 1 0 0 1 1 0 1 1 1 1 0 0 0 1 0 0 0 1 1 0 1 1 1 1 1 1 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1 1 0 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 0 1 1 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 1 0 1 1 1 0 1 0 1 0 1 1 0 1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 1 1 0 1 0 1 1 0 1 0 0 0 1 1 0 0 1 0 1 0 0 0 1 0 0 0 1 1 0 1 0 1 0 1 1 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 1 1 0 1 1 0 1 1 0 1 0 0 1 0 1 0 1 1 0 0 0 1 1 0 1 0 0 1 0 1 1 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 1 0 0 1 0 0 0 0 1 1 1 0 1 1 1 0 0 0 0 0 0 1 1 1 1 0 1 1 0 1 1 1 0 0 1 1 1 0 1 1 0 0 1 1 1 1 0 1 0 1 1 1 1 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 0 1 1 1 0 1 1 0 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 1 0 0 1 1 1 1 1 1 1 0 1 0 0 1 1)

       ;; (try-all :even 2048 2049  0.0014328746687631 0.51217918249646) = 56.93601 start for next
       ;; ce:
	50.887273 (fv 0.000000 -0.001703 0.433172 1.590778 1.336810 1.796101 0.945990 0.630649 1.068973 0.276030 0.019619 0.418921 1.642205 1.314880 1.815562 0.937954 0.690335 1.166456 0.260174 0.033467 0.534551 1.577952 1.359691 1.855935 0.978115 0.778145 1.214744 0.305514 0.073250 0.585950 1.700979 1.456846 1.891326 1.051448 0.870291 1.262779 0.419868 0.209104 0.667538 1.764244 1.534253 0.022691 1.157333 0.886455 1.397513 0.522770 0.305417 0.791572 1.882641 1.706581 0.124613 1.245754 1.016938 1.507704 0.621789 0.423116 0.882723 0.034318 1.775279 0.266045 1.420137 1.176158 1.620182 0.842558 0.553079 1.037944 0.182615 0.005162 0.432646 1.577593 1.375077 1.777427 0.999839 0.726166 1.218120 0.366911 0.123723 0.662290 1.808464 1.555557 0.050943 1.161441 0.961088 1.469391 0.581778 0.421014 0.869182 1.964711 1.782785 0.217679 1.412311 1.228590 1.681851 0.818320 0.617489 1.120821 0.226824 0.041870 0.539030 1.644423 1.496409 1.937912 1.088438 0.861771 1.374952 0.504902 0.301816 0.831900 1.946273 1.700988 0.237333 1.351841 1.174113 1.697709 0.766188 0.601502 1.097799 0.223664 0.073707 0.490731 1.705779 1.529713 0.004900 1.114151 0.927806 1.413217 0.593263 0.370397 0.876728 0.024219 1.840075 0.345172 1.498140 1.311278 1.774455 0.911735 0.779474 1.231046 0.351370 0.170176 0.732535 1.828332 1.647912 0.151754 1.304922 1.134715 1.583698 0.773654 0.612595 1.042987 0.199634 0.036653 0.549756 1.681847 1.475587 0.005194 1.173802 0.977842 1.470305 0.643755 0.476622 0.917721 0.111850 1.936419 0.450243 1.616355 1.416777 1.915014 1.098462 0.907664 1.447783 0.570918 0.405291 0.889269 0.066991 1.881365 0.373330 1.508358 1.402579 1.870612 1.085131 0.920739 1.348392 0.568783 0.336415 0.843225 0.063446 1.926774 0.418106 1.565445 1.379520 1.897103 1.050320 0.891564 1.380927 0.530987 0.385626 0.908446 0.068664 1.943935 0.430612 1.518729 1.398232 1.924184 1.103625 0.924587 1.417433 0.610522 0.456479 0.953409 0.112059 0.013043 0.495872 1.633744 1.493163 0.038519 1.187544 1.048687 1.588579 0.748576 0.532785 1.100237 0.281535 0.104911 0.635452 1.811612 1.634030 0.184177 1.345558 1.153862 1.750039 0.857060 0.732788 1.250092 0.418042 0.246015 0.725057 1.972355 1.807991 0.351695 1.540788 1.347415 1.848165 1.067747 0.908528 1.413312 0.618180 0.467879 0.991799 0.190738 0.053795 0.507730 1.744900 1.620134 0.124619 1.318661 1.152397 1.685590 0.894836 0.688791 1.239521 0.488835 0.282246 0.831794 -0.015794 1.883123 0.431031 1.583860 1.447618 1.964025 1.125655 1.064343 1.569856 0.748855 0.603708 1.107653 0.309052 0.196774 0.696407 1.871049 1.742283 0.240318 1.473905 1.321207 1.881514 1.047815 0.924156 1.493868 0.689863 0.543896 1.026203 0.246976 0.140944 0.678125 1.870899 1.706720 0.276250 1.408196 1.319078 1.889412 1.061123 0.937583 1.451370 0.684034 0.567548 1.075578 0.293854 0.180105 0.705838 1.911360 1.764817 0.292975 1.493988 1.411105 1.895989 1.081687 1.012629 1.575334 0.718344 0.628406 1.174951 0.386415 0.230260 0.768066 -0.015753 1.886981 0.454216 1.616098 1.441778 0.077596 1.316514 1.144927 1.696140 0.867400 0.757625 1.309429 0.563210 0.364175 0.954929 0.137349 0.057751 0.597415 1.789122 1.677288 0.252684 1.417924 1.313555 1.862237 1.126315 1.015807 1.510443 0.802206 0.652057 1.184565 0.404523 0.277585 0.843687 0.148971 1.933489 0.514414 1.743011 1.592866 0.129290 1.346399 1.259419 1.817805 1.029171 0.962338 1.475532 0.708188 0.633076 1.151811 0.395581 0.307725 0.834201 0.078405 1.959228 0.466843 1.769721 1.650538 0.159441 1.402559 1.321215 1.914285 1.128095 1.014297 1.571134 0.803693 0.677208 1.246457 0.469701 0.356795 0.908733 0.149102 0.035900 0.615966 1.826481 1.708851 0.339243 1.554134 1.413247 -0.028956 1.251019 1.106816 1.704569 0.926586 0.827768 1.430366 0.655894 0.524343 1.153832 0.363573 0.234391 0.825975 0.037037 1.955590 0.487803 1.776970 1.679179 0.270247 1.494959 1.379330 1.956206 1.186819 1.071982 1.644518 0.897716 0.759160 1.349574 0.601679 0.512657 1.067152 0.367997 0.259056 0.818805 0.070970 1.979460 0.551129 1.797928 1.685198 0.237267 1.508404 1.457352 0.047420 1.261021 1.192815 1.789893 0.995526 0.930294 1.496757 0.778086 0.636312 1.222185 0.505076 0.392642 1.016934 0.236492 0.140361 0.774022 0.001411 1.961469 0.498526 1.750119 1.648169 0.240766 1.450209 1.419896 0.004281 1.237513 1.195486 1.793570 1.030159 0.946491 1.529067 0.769460 0.726220 1.269159 0.564615 0.472841 1.084479 0.322182 0.217540 0.870218 0.092806 0.039652 0.580465 1.871900 1.768958 0.330755 1.643083 1.574291 0.148815 1.382016 1.330434 1.953984 1.191904 1.113085 1.729795 0.935173 0.941506 1.487573 0.777735 0.706146 1.300602 0.552074 0.471965 1.086702 0.368313 0.238388 0.870358 0.129144 0.034415 0.647185 1.956907 1.855191 0.450494 1.695322 1.674270 0.277115 1.525710 1.462245 0.090299 1.329096 1.259635 1.870782 1.128184 1.069973 1.694787 0.953585 0.907980 1.546930 0.802555 0.747675 1.322734 0.664094 0.527920 1.163169 0.460332 0.399285 0.970040 0.217204 0.171752 0.769371 0.047350 -0.025234 0.632915 1.894302 1.830249 0.455254 1.760595 1.701533 0.321139 1.541634 1.515918 0.102674 1.367783 1.346029 1.941486 1.223287 1.213347 1.782946 1.029999 1.005092 1.692642 0.911840 0.875191 1.494140 0.757479 0.727400 1.310293 0.611635 0.559689 1.154763 0.453641 0.402989 1.051223 0.342693 0.309148 0.919084 0.199108 0.132609 0.759042 0.053229 -0.033954 0.648811 1.906240 1.894740 0.483288 1.798246 1.730147 0.369025 1.616846 1.576788 0.217080 1.494201 1.461719 0.088483 1.386902 1.325078 1.982480 1.249756 1.217589 1.872681 1.143670 1.127132 1.742603 1.001258 0.969685 1.653400 0.948140 0.903244 1.474757 0.844045 0.804740 1.381313 0.669059 0.696990 1.287624 0.590259 0.542974 1.139086 0.529408 0.444238 1.060949 0.381119 0.387330 0.982887 0.274265 0.262799 0.892622 0.182183 0.155238 0.802580 0.125716 0.062385 0.697970 -0.029110 -0.005740 0.631814 1.935506 1.905147 0.526743 1.805035 1.822539 0.427610 1.754204 1.769095 0.334244 1.671094 1.648758 0.313430 1.604455 1.580989 0.249732 1.534106 1.501925 0.141332 1.456591 1.376333 0.087064 1.395898 1.349285 -0.007846 1.309141 1.324784 1.926752 1.235223 1.257013 1.870695 1.183965 1.196890 1.833185 1.161076 1.134259 1.737981 1.066217 1.029285 1.761061 1.046404 1.003567 1.669085 1.015282 0.945700 1.628153 0.957401 0.910198 1.578015 0.892702 0.920061 1.560411 0.892643 0.883270 1.499087 0.881141 0.786754 1.465346 0.814870 0.806704 1.420951 0.745568 0.748981 1.428779 0.724569 0.722331 1.414318 0.735199 0.680304 1.412191 0.642055 0.663317 1.362918 0.692620 0.652852 1.255275 0.655029 0.616540 1.306668 0.607368 0.596378 1.278318 0.605729 0.626127 1.248672 0.605969 0.598531 1.270199 0.590247 0.604018 1.248420 0.564539 0.573991 1.243120 0.541247 0.581568 1.247013 0.548311 0.583389 1.254363 0.570054 0.592870 1.314918 0.584147 0.601170 1.285128 0.585385 0.636800 1.268157 0.564860 0.618673 1.241680 0.593206 0.649499 1.294308 0.619335 0.690828 1.290074 0.662251 0.659564 1.319465 0.684267 0.676527 1.346573 0.684074 0.749941 1.376399 0.760563 0.735778 1.409735 0.781193 0.776861 1.424608 0.803012 0.794890 1.482330 0.849249 0.820388 1.516581 0.910615 0.864461 1.540065 0.895368 0.913334 1.630286 0.950361 0.962747 1.686669 0.985439 1.020247 1.674781 0.998529 1.106931 1.784420 1.109819 1.080550 1.792617 1.141848 1.167488 1.815820 1.225904 1.216862 1.932151 1.308230 1.267897 -0.026968 1.330184 1.385176 0.022707 1.458233 1.415333 0.128552 1.487923 1.523242 0.191001 1.550003 1.584242 0.283355 1.596921 1.662782 0.308217 1.689429 1.701664 0.432683 1.765615 1.799785 0.477706 1.814969 1.847473 0.536692 1.956606 -0.125001 0.671687 0.021081 0.062099 0.778322 0.143122 0.195164 0.870404 0.217515 0.248340 0.992771 0.296311 0.393796 1.036703 0.444136 0.428455 1.144392 0.545916 0.532816 1.274635 0.638559 0.682382 1.366079 0.738438 0.791235 1.469530 0.832133 0.861591 1.597033 0.965134 0.975949 1.660906 1.074595 1.121780 1.850802 1.205711 1.200292 1.955639 1.297951 1.320764 0.075418 1.456186 1.481933 0.158684 1.566840 1.641287 0.359580 1.677476 1.730799 0.448508 1.815321 1.873655 0.540161 1.931330 1.974330 0.742536 0.063433 0.156314 0.825290 0.223991 0.306298 0.962765 0.360970 0.418863 1.127740 0.516243 0.542975 1.312005 0.652439 0.710545 1.452213 0.776568 0.871797 1.548353 0.973587 1.004549 1.725321 1.089618 1.233086 1.882229 1.280829 1.345266 0.036253 1.417172 1.451706 0.202998 1.622238 1.674924 0.340016 1.728728 1.833591 0.567298 1.946042 0.023405 0.702356 0.135275 0.153799 0.884198 0.265400 0.340889 1.099730 0.493458 0.526956 1.267239 0.676407 0.690082 1.422573 0.812500 0.926029 1.644040 1.074851 1.097114 1.811626 1.221109 1.268846 0.019885 1.418865 1.465834 0.226550 1.602283 1.642652 0.409600 1.782663 1.847764 0.612518 -0.014414 0.080272 0.793644 0.189642 0.287941 1.015956 0.430798 0.498270 1.212055 0.606553 0.678263 1.458990 0.847157 0.901708 1.629236 1.030896 1.120792 1.854770 1.260369 1.292084 0.058109 1.472251 1.530032 0.298666 1.686445 1.750885 0.465407 1.926615 -0.015762 0.736186 0.179728 0.219514 0.995121 0.367989 0.459496 1.186779 0.640597 0.690551 1.458450 0.858324 0.911511 1.699195 1.068188 1.186092 1.897316 1.337175 1.402416 0.144009 1.638297 1.673138 0.373403 1.812913 1.888979 0.630635 0.080370 0.169331 0.914815 0.273060 0.393754 1.122091 0.596144 0.640794 1.390765 0.839105 0.918214 1.680880 1.131151 1.205710 1.974811 1.393861 1.452322 0.156477 1.645144 1.718367 0.451059 1.878144 0.022469 0.716191 0.203622 0.204052 1.000934 0.419218 0.531168 1.297295 0.702318 0.799989 1.534195 0.962961 1.059623 1.864764 1.322381 1.390676 0.140300 1.535535 1.653796 0.423232 1.846167 1.958815 0.705134 0.115159 0.251430 1.006465 0.470237 0.504026 1.267250 0.734232 0.836445 1.549915 1.039694 1.136664 1.905550 1.321296 1.400727 0.208474 1.633666 1.709003 0.486386 1.940896 0.025205 0.789590 0.229116 0.395199 1.113150 0.560152 0.653681 1.459139 0.830910 0.975236 1.738577 1.210343 1.308624 0.093706 1.493739 1.620053 0.424641 1.828846 1.940485 0.729339 0.163547 0.294790 1.029106 0.522695 0.623772 1.363366 0.795679 0.991955 1.735746 1.166232 1.233433 0.033448 1.517164 1.590656 0.407889 1.837549 1.928075 0.698672 0.187906 0.288583 1.089091 0.525365 0.646727 1.419503 0.847075 1.003035 1.770682 1.222701 1.368528 0.132834 1.552702 1.702988 0.486356 1.942867 0.028321 0.834453 0.305865 0.427874 1.193367 0.646670 0.777994 1.535326 0.959127 1.141152 1.974723 1.386313 1.482039 0.241727 1.733430 1.907279 0.652190 0.113225 0.233654 1.053634 0.521015 0.606360 1.407458 0.868195 0.979596 1.802838 1.252544 1.387190 0.144685 1.620697 1.765258 0.551267 0.016634 0.102630 0.966227 0.379774 0.557760 1.339080 0.772792 0.943942 1.714448 1.227165 1.340588 0.135412 1.553794 1.733262 0.505137 0.052411 0.115242 0.903954 0.369383 0.566147 1.338694 0.822997 0.955372 1.767911 1.219397 1.351801 0.123533 1.574789 1.767438 0.582707 0.059344 0.173569 0.987297 0.434401 0.616641 1.368611 0.898977 1.018679 1.815949 1.269299 1.423987 0.244273 1.756592 1.844278 0.628834 0.156429 0.267440 1.098495 0.557657 0.757430 1.527200 1.032316 1.157667 1.941839 1.435329 1.592128 0.417339 1.857219 0.027921 0.825078 0.326257 0.472209 1.266409 0.776877 0.907550 1.713542 1.197483 1.352897 0.148954 1.643699 1.805895 0.598148 0.109639 0.271416 1.099053 0.556356 0.664165 1.505314 0.973330 1.224262 1.958351 1.490436 1.656174 0.418476 1.960327 0.146807 0.899660 0.444751 0.550436 1.400125 0.831060 1.011690 1.850969 1.328814 1.486005 0.311620 1.812294 -0.006342 0.797723 0.305173 0.491901 1.322423 0.745375 0.923548 1.782732 1.275234 1.378532 0.222379 1.713386 1.920722 0.741433 0.280929 0.401426 1.209280 0.698837 0.886341 1.726784 1.225163 1.413939 0.172159 1.726536 1.893106 0.754636 0.203236 0.351446 1.190416 0.680791 0.829406 1.684757 1.210208 1.371232 0.224484 1.699825 1.891292 0.738873 0.258642 0.425836 1.243225 0.713196 0.891190 1.771850 1.235681 1.368819 0.270358 1.784768 1.928168 0.781510 0.284144 0.430703 1.331232 0.807861 0.993486 1.852203 1.325750 1.549374 0.376307 1.889520 0.034521 0.884377 0.427788 0.583618 1.373059 0.934920 1.074386 1.964373 1.419552 1.645249 0.489767 0.008746 0.185928 1.061283 0.556624 0.715745 1.608195 1.103831 1.267216 0.164802 1.613900 1.850921 0.624698 0.161160 0.408839 1.261772 0.735470 0.975590 1.782335 1.311907 1.475716 0.390097 1.869546 0.060780 0.873934 0.410643 0.589799 1.451558 0.998661 1.152970 0.054633 1.557268 1.731872 0.575393 0.117821 0.307307 1.198887 0.683313 0.897819 1.753607 1.284857 1.473685 0.314273 1.836871 0.060820 0.932547 0.420398 0.613590 1.461860 1.038061 1.203207 0.095116 1.584547 1.810340 0.624226 0.177690 0.397754 1.253072 0.802314 0.987311 1.879162 1.342549 1.566135 0.442620 1.908917 0.137619 1.011650 0.599336 0.755517 1.642027 1.174961 1.369054 0.211942 1.782659 -0.010486 0.840251 0.357521 0.581790 1.461271 1.014049 1.200403 0.044641 1.613689 1.808581 0.690100 0.250270 0.388899 1.294231 0.842257 1.021201 1.901029 1.462877 1.641210 0.546531 0.075531 0.291167 1.142643 0.703128 0.915213 1.799433 1.361706 1.526251 0.463549 1.971569 0.185024 1.029933 0.578985 0.824751 1.713096 1.250117 1.463497 0.301505 1.881822 0.143407 0.962817 0.507734 0.729352 1.590586 1.169240 1.393909 0.249757 1.802780 0.053110 0.895331 0.464179 0.669201 1.582612 1.097231 1.355127 0.231353 1.735403 0.021720 0.880348 0.431395 0.697354 1.573165 1.060767 1.347507 0.185124 1.772265 1.983494 0.879718 0.443530 0.687541 1.535902 1.151743 1.322419 0.212153 1.745041 -0.024853 0.929578 0.461659 0.706048 1.575808 1.122374 1.345663 0.241665 1.798693 0.038133 0.893828 0.497759 0.738405 1.619233 1.230529 1.391018 0.311367 1.875986 0.111417 0.982712 0.552692 0.779545 1.673926 1.277817 1.495634 0.424964 1.933807 0.193663 1.085748 0.635034 0.877002 1.797408 1.324014 1.603040 0.515913 0.114700 0.279027 1.230954 0.738758 0.971164 1.923699 1.522824 1.758904 0.629325 0.199968 0.431971 1.357304 0.920686 1.144660 0.047634 1.638457 1.887367 0.770386 0.339803 0.608798 1.474763 1.082399 1.336813 0.240373 1.815488 0.071521 0.978055 0.575127 0.812951 1.691650 1.236419 1.523987 0.428018 -0.014053 0.227398 1.211471 0.739843 1.033454 1.889876 1.490608 1.764875 0.650358 0.197774 0.479040 1.394298 0.990877 1.266721 0.153708 1.743738 1.993903 0.889105 0.452779 0.717556 1.641719 1.258531 1.472505 0.400527 0.003181 0.277816 1.190582 0.720088 1.018145 1.947482 1.529759 1.763205 0.679772 0.305019 0.551595 1.459782 1.056328 1.376741 0.254961 1.837237 0.083779 1.033490 0.597121 0.863372 1.752800 1.369817 1.661724 0.554009 0.132249 0.412929 1.366488 0.929237 1.205521 0.153686 1.780997 0.028187 0.910073 0.518459 0.747299 1.736440 1.285832 1.584544 0.515963 0.139650 0.379555 1.267964 0.869992 1.153100 0.094361 1.717865 1.955775 0.900339 0.490824 0.754072 1.676728 1.277159 1.570274 0.491155 0.127499 0.354589 1.327580 0.971916 1.203157 0.189781 1.749254 -0.000141 0.971242 0.569275 0.834995 1.792334 1.386324 1.620367 0.641313 0.177512 0.493821 1.395372 1.027112 1.276574 0.195767 1.840052 0.118782 1.057366 0.655353 0.981627 1.889857 1.497516 1.809949 0.727076 0.311895 0.619859 1.589373 1.177776 1.446089 0.402884 -0.013138 0.323859 1.242590 0.872932 1.139811 0.103389 1.705727 0.012476 0.932654 0.580713 0.844428 1.776557 1.375650 1.683357 0.653489 0.286018 0.530346 1.477873 1.102629 1.446550 0.391220 0.013493 0.315912 1.191737 0.889652 1.135899 0.064317 1.726753 0.008311 0.973187 0.561368 0.881325 1.835182 1.452878 1.728216 0.640203 0.296506 0.611465 1.537761 1.163681 1.521594 0.455106 0.113603 0.376193 1.335690 0.990813 1.252928 0.217355 1.798201 0.130538 1.099312 0.694187 1.042508 1.990873 1.625313 1.908796 0.833102 0.534393 0.775983 1.784275 1.381831 1.684754 0.630094 0.272616 0.575688 1.559911 1.184625 1.453679 0.491431 0.104067 0.400708 1.342106 0.977889 1.261797 0.248038 1.904884 0.237792 1.209205 0.805676 1.119936 0.155727 1.752922 0.098394 1.023110 0.709066 0.956558 1.945167 1.621782 1.885544 0.851378 0.511350 0.815303 1.752479 1.417551 1.712996 0.651328 0.341725 0.648800 1.652874 1.229749 1.564655 0.595314 0.162557 0.496357 1.536686 1.115189 1.443475 0.423294 0.108662 0.395018 1.332526 0.999816 1.352353 0.328398 1.960089 0.256657 1.276205 0.950110 1.251154 0.223763 1.856947 0.198310 1.202811 0.823347 1.139257 0.137493 1.791954 0.126818 1.077613 0.742716 1.034617 0.042667 1.702855 0.035869 0.942965 0.683955 0.962192 1.957952 1.636826 1.953521 0.904062 0.576569 0.908521 1.946168 1.527121 1.835900 0.915076 0.530360 0.860954 1.848124 1.476416 1.825816 0.801278 0.498232 0.791951 1.825898 1.460369 1.801238 0.807022 0.470147 0.775520 1.782957 1.421022 1.758922 0.747391 0.412834 0.729983 1.748458 1.430447 1.754281 0.725069 0.444203 0.754125 1.805117 1.457795 1.776284 0.724624 0.428724 0.744488 1.781494 1.483810 1.771396 0.825589 0.485350 0.772930 1.812210 1.489700 1.842892 0.808972 0.497919 0.826699 1.849758 1.501581 1.863781 0.830698 0.510646 0.856199 1.880392 1.487637 1.841337 0.883565 0.587660 0.933592 1.879899 1.575694 1.912690 0.882053 0.596355 0.876449 1.942318 1.604954 1.957913 0.991402 0.632658 0.965194 -0.031486 1.680264 0.039739 1.057207 0.660079 1.072774 0.084190 1.760660 0.122642 1.146243 0.783356 1.166710 0.158916 1.820281 0.220718 1.231907 0.956518 1.285669 0.300669 1.936753 0.315132 1.335110 1.060246 1.374454 0.394758 0.082667 0.417144 1.497357 1.121455 1.497524 0.558460 0.253594 0.585079 1.609798 1.353184 1.698378 0.628590 0.358364 0.702657 1.718959 1.448521 1.778728 0.811121 0.552978 0.858398 1.901305 1.551915 1.964990 1.006942 0.659821 0.990952 0.063543 1.773494 0.063737 1.160916 0.874963 1.254235 0.227903 1.909287 0.327897 1.310953 0.994777 1.331010 0.411728 0.136015 0.418712 1.516878 1.254075 1.541807 0.597800 0.341732 0.654709 1.684819 1.408026 1.806837 0.819367 0.523512 0.857369 1.895100 1.607979 1.949425 0.987941 0.703347 1.084034 0.136539 1.830122 0.250645 1.285193 0.947170 1.289548 0.328696 0.029933 0.461597 1.469311 1.207559 1.503925 0.619432 0.268080 0.678945 1.716381 1.398922 1.858266 0.884402 0.579547 0.942855 -0.007780 1.697643 0.060832 1.147089 0.859119 1.243156 0.279683 1.948552 0.303518 1.436858 1.120717 1.478393 0.523558 0.237367 0.599745 1.706188 1.421576 1.811698 0.850440 0.556037 0.945518 -0.871745 1.728994 0.072385 1.111766 0.835570 1.223297 0.269709 0.056622 0.355706 1.422876 1.147014 1.551471 0.600627 0.344660 0.724082 1.763987 1.516159 1.882823 0.942715 0.661410 1.033320 0.094097 1.855748 0.231455 1.280646 1.044202 1.442450 0.460350 0.194810 0.625856 1.678168 1.370560 1.773190 0.847696 0.600688 1.001562 0.035016 1.824811 0.145896 1.197674 0.963152 1.364275 0.436987 0.180547 0.564604 1.641854 1.399407 1.733896 0.850418 0.609483 0.927674)
       )

))


;;; triangle waves in place of sinusoids have different mimima at different places, so
;;;   we can't simplify in that direction

;;; the waveforms for a given number of peaks are surprisingly similar -- :odd and :even in particular
;;;   this includes cases involving all sines (0 and 1), as compared to all cosines (1/2 and 3/2)


(define (tstodd phs)
  (let ((len (length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstoddderiv x phs) 
  (let ((sum 0.0)
	(len (length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 2)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define* (tstall phs phs1)
  (if (real? phs) (set! phs phs1))
  (let ((len (length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallf mult phs)
  (let ((len (length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (if (= k (- len 1))
	      (set! val (+ val (* mult (sin (+ (* j x) (* pi (phs k)))))))
	      (set! val (+ val (sin (+ (* j x) (* pi (phs k))))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tsteven phs)
  (let ((len (length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (max (* 2 k) 1) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstprime phs)
  (let ((len (length phs))
	(incr 0.0001)
	(mx 0.0)
	(loc 0.0))
    (do ((x 0.0 (+ x incr)))
	((> x (* 2 pi)) (list mx loc))
      (let ((val 0.0))
	(do ((k 0 (+ k 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* (primes k) x) (* pi (phs k)))))))
	(if (> (abs val) mx)
	    (begin
	      (set! mx (abs val))
	      (set! loc x)))))))

(define (tstallderiv x phs) 
  (let ((sum 0.0)
	(len (length phs)))
    (do ((i 0 (+ i 1))
	 (j 1 (+ j 1)))
	((= i len) sum)
      (set! sum (+ sum (* j (cos (+ (* j x) (* pi (phs i))))))))))


(define (get-best choice n)

  (define (vector-find-if func vect)
    (let ((len (length vect))
	  (result #f))
      (do ((i 0 (+ i 1)))
	  ((or (= i len)
	       result)
	   result)
	(set! result (func (vect i))))))

  (vector-find-if (lambda (val)
		    (and val
			 (vector? val)
			 (= (val 0) n)
			 (let ((a-val (val 1))
			       (a-len (length val))
			       (a-data (val 2)))
			   (do ((k 3 (+ 1 k)))
			       ((= k a-len))
			     (if (and (number? (val k))
				      (< (val k) a-val))
				 (begin
				   (set! a-val (val k))
				   (set! a-data (val (+ k 1))))))
			   (list a-val a-data))))
		  (if (eq? choice :all)
		      noid-min-peak-phases
		      (if (eq? choice :odd)
			  nodd-min-peak-phases
			  (if (eq? choice :even)
			      neven-min-peak-phases
			      primoid-min-peak-phases)))))

(define (showall len)
  (let* ((phs-data (get-best :all len))
	 (phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* 2 pi 1000) 2))))
	 (incr 0.001))
    (do ((x 0.0 (+ x incr))
	 (i 0 (+ i 1)))
	((> x (* 2 pi)))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(set! (v i) val)))
    (new-sound)
    (float-vector->channel v)
    (set! (y-bounds) (list (- mx) mx))))

(define (showphases mx phs)
  (let ((v (make-float-vector (ceiling (+ (* 2 pi 1000) 2))))
	(incr 0.001)
	(len (length phs)))
    (do ((x 0.0 (+ x incr))
	 (i 0 (+ i 1)))
	((> x (* 2 pi)))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 1)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(set! (v i) val)))
    (new-sound)
    (float-vector->channel v)
    (set! (y-bounds) (list (- mx) mx))))



(define (showodd len)
  (let* ((phs-data (get-best :odd len))
	 (phs (cadr phs-data))
	 (mx (car phs-data))
	 (v (make-float-vector (ceiling (+ (* 2 pi 1000) 2))))
	 (incr 0.001))
    (do ((x 0.0 (+ x incr))
	 (i 0 (+ i 1)))
	((> x (* 2 pi)))
      (let ((val 0.0))
	(do ((k 0 (+ k 1))
	     (j 1 (+ j 2)))
	    ((= k len))
	  (set! val (+ val (sin (+ (* j x) (* pi (phs k)))))))
	(set! (v i) val)))
    (new-sound)
    (float-vector->channel v)
    (set! (y-bounds) (list (- mx) mx))))

(define (showdiff n1 n2)
  (let* ((len (length n1))
	 (data (make-float-vector len)))
    (do ((i 0 (+ i 1)))
	((= i len))
      (set! (data i) (modulo (- (n1 i) (n2 i)) 2.0))
      (if (> (data i) 1.0)
	  (set! (data i) (- (data i) 2.0))
	  (if (< (data i) -1)
	      (set! (data i) (+ (data i) 2.0)))))
    (new-sound)
    (float-vector->channel data)
    ))

(define (differ snd) 
  (let ((x 0.0))
    (map-channel 
     (lambda (y) 
       (let ((res (- y x)))
	 (set! x y) 
	 res))
     0 #f snd 0)))    


(define (find-other-mins peak-amp peak-phases)

  ;; given a point, find the 3 other matching points (this assumes all harmonics, but the other cases are similar;
  ;;   in the even case, we'd flip all above 0, not just every other one, because they're all even, but we end
  ;;   up with 4 equivalent points as before -- step by 1 not 2 in the 1st and 3rd loops below.  In the odd and 
  ;;   prime cases, I can only think of 2 such points, the symmetry being around 0 (2-val)).

  (let ((temp-phases (copy peak-phases))
	(n (length peak-phases))
	(results ()))

    ;; flip evens
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; get case symmetric around 0
    (set! temp-phases (copy peak-phases))
    (do ((i 1 (+ i 1)))
	((= i n))
      (set! (temp-phases i) (modulo (- 2.0 (temp-phases i)) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

    ;; flip evens on the previous case
    (set! temp-phases (copy temp-phases))
    (do ((i 1 (+ i 2)))
	((>= i n))
      (set! (temp-phases i) (modulo (+ (temp-phases i) 1.0) 2.0)))
    (let ((val (car (tstall temp-phases))))
      (if (> (abs (- val peak-amp)) .001)
	  (format #t ";~A -> ~A?~%" peak-amp val))
      (set! results (cons (list val temp-phases) results)))

;   (format #f "~{~{~,8F ~A~%~}~}" (reverse results))
    results
    ))

;;; :(find-other-mins (car (tstall (fv 0.0 0.1 0.2 0.3))) (fv 0.0 0.1 0.2 0.3))
;;; 3.49630991 (fv 0.0 1.1 0.2 1.3)
;;; 3.49630680 (fv 0.0 1.9 1.8 1.7)
;;; 3.49630979 (fv 0.0 0.9 1.8 0.7)



(define (canonicalize-one i p)
  (let ((data (get-best :all i)))
    (let ((old-peak (car data))
	  (old-phases (cadr data)))
      (let ((phases (copy old-phases)))
	(if (< (phases 2) -1.0)
	    (set! (phases 2) (+ (phases 2) 2.0))
	    (if (> (phases 2) 1.0)
		(set! (phases 2) (- (phases 2) 2.0))))
	(if (< (phases 2) 0.0)
	    (do ((j 1 (+ j 1)))
		((>= j i))
	      (set! (phases j) (modulo (- 2.0 (phases j)) 2.0))))
	(if (< (phases 1) -1.0)
	    (set! (phases 1) (+ (phases 1) 2.0))
	    (if (> (phases 1) 1.0)
		(set! (phases 1) (- (phases 1) 2.0))))
	(if (< (phases 1) 0.0) ; this is an "even" harmonic
	    (do ((j 1 (+ j 2)))
		((>= j i))
	      (set! (phases j) (modulo (+ 1.0 (phases j)) 2.0))))
	(do ((j 1 (+ j 1)))
	    ((= j i))
	  (if (< (phases j) -1.0)
	      (set! (phases j) (+ (phases j) 2.0))
	      (if (> (phases j) 1.0)
		  (set! (phases j) (- (phases j) 2.0)))))
	(let ((new-peak (car (tstall phases))))
	  (if (> (abs (- new-peak old-peak)) .001)
	      (format *stderr* "oops: ~D: ~A ~A~%" i old-peak new-peak))
	  (format p "(vector ~D ~,6F (fv " i new-peak)
	  (do ((k 1 (+ k 1)))
	      ((= k i))
	    (format p "~,6F " (phases (- k 1))))
	  (format p "~,6F))~%~%" (phases (- i 1))))))))

(define (canonicalize)
  ;; this is slow because we call tstall on each one 
  (call-with-output-file "pp4.scm" 
    (lambda (p)
      (format p "(define noid-min-peak-phases (vector~%~%(vector 1  1.0    (fv 0))~%(vector 2  1.76   (fv 0 0))~%~%")
      (do ((i 3 (+ i 1)))
	  ((> i 128))
	(format *stderr* "~D " i)
	(canonicalize-one i p))
      (format p "))~%"))))

(if (provided? 'snd) (set! (print-length) 123123) (set! (*s7* 'print-length) 123123))

(define (show-mins i)
  (let ((data (get-best :all i)))
    (let ((other-mins (apply find-other-mins data)))
      (let ((pk1 (cadr data))
	    (pk2 (cadr (car other-mins)))
	    (pk3 (cadr (cadr other-mins)))
	    (pk4 (cadr (caddr other-mins))))

	(if (or (> (abs (- (car (car other-mins)) (car data))) .001)
		(> (abs (- (car (cadr other-mins)) (car data))) .001)
		(> (abs (- (car (caddr other-mins)) (car data))) .001))
	    (format #t "trouble in ~D: ~A ~A~%" i data other-mins))

	(let ((phases (sort! (list pk1 pk2 pk3 pk4)
			     (lambda (a b)
			       (< (a 1) (b 1))))))
	  (format #t "~,8F~%    ~A~%    ~A~%    ~A~%    ~A~%"
		  (data 0)
		  (phases 0)
		  (phases 1)
		  (phases 2)
		  (phases 3)
		  ))))))

;; (09)
;; 1 Mar 5446.42
;; 1 Apr 5405.890
;; 1 May 5138.261
;; 1 Jun 5061.829
;; 1 Jul 4669.101
;; 1 Aug 4633.454
;; 1 Sep 4616.517
;; 1 Oct 4592.994
;; 1 Nov 4560.903
;; 1 Dec 4541.710
;; (10)
;; 1 Jan 4360.644
;; 1 Feb 4292.451
;; 1 Mar 4280.782
;; 1 Apr 4272.964
;; 1 May 4267.719
;; 1 Jun 4261.356
;; 1 Jul 4244.312, sqrts: 82 74 0 0
;; 1 Aug 4218.456, sqrts: 82 74 0 0
;; 1 Sep 4209.464, sqrts: 85 74 0 0   (9.5330)
;; 1 Oct 4202.347, sqrts: 89 75 0 0   (6.9438)
;; 1 Nov 4198.764, sqrts: 94 78 0 0   (5.5196)
;; 1 Dec 4196.395, sqrts: 98 84 0 0   (4.1226)
;; (11)
;; 1 Jan 4194.669, sqrts: 101 91 0 0  (2.9465)
;; 1 Feb 4194.106, sqrts: 105 91 0 0  (2.5054)
;; 1 Mar 4193.048, sqrts: 110 95 0 0  (1.6862)
;; 1 Apr 4188.373, sqrts: 114 104 0 0 (0.8505)
;; 1 May 4186.610, sqrts: 114 105 0 0 (0.6439)
;; 1 Jun 4186.498, sqrts: 115 105 0 0 (0.5422)
;; 1 Nov 4186.465, sqrts: 116 105 0 0 (0.5095)
;; 1 Dec 4186.315, sqrts: 117 108 0 0 (0.4198) 
;; (12)
;; 1 Jan 4185.693, sqrts: 118 112 0 0 (0.3225)
;; 1 Feb 4185.458, sqrts: 119 113 0 0 (0.2534)
;; 1 Mar 4185.289, sqrts: 119 115 0 0 (0.1710)
;; 1 Apr 4185.029, sqrts: 120 115 0 0 (0.1464)
;; 1 Nov 4184.742, sqrts: 120 115 0 0 (0.1429)
;; 1 Dec 4184.727, sqrts: 121 115 0 0 (0.1349)
;; (13)
;; 1 Feb 4184.520, sqrts: 122 115 0 0 (0.1159)
;; 1 Jun 4184.160, sqrts: 122 118 0 0 (0.0926)
;; 1 Aug 4183.948, sqrts: 122 118 0 0 (0.0440)
;; 1 Sep 4183.825, sqrts: 122 119 0 0 (0.0382)
;; 1 Oct 4183.673, sqrts: 122 119 0 0 (0.0382)
;; 1 Nov 4183.616, sqrts: 122 119 0 0 (0.0382)
;; 1 Dec 4183.180, sqrts: 122 120 0 0 (0.0361)
;; (14)
;; 1 Jan 4183.004, sqrts: 122 120 0 0 (0.0346)
;; 1 Mar 4182.956, sqrts: 122 120 0 0 (0.0346)
;; 1 Apr 4182.919, sqrts: 122 120 0 0 (0.0346)
;; 1 May 4182.759, sqrts: 122 120 0 0 (0.0346)
;; 1 Jun 4177.414, sqrts: 122 120 0 0 (0.0346)
;; 1 Jul 4174.620, sqrts: 122 120 0 0 (0.0346)
;; 1 Aug 4171.810, sqrts: 122 120 0 0 (0.0346)
;; 1 Sep 4169.400, sqrts: 122 120 0 0 (0.0346)
;; 1 Oct 4166.886, sqrts: 122 121 0 0 (0.0242)
;; 1 Nov 4163.522, sqrts: 122 122 0 0 (0.0000)
;; 1 Dec 4161.032, sqrts: 122 122 0 0 (0.0000)
;; (15)
;; 1 Jan 4158.938
;; 1 Feb 4156.526
;; 1 Mar 4154.769
;; 1 Apr 4154.180
;; 1 May 4153.716

;    all 0.4860 (20) to 0.4998 (109), dist: 0.0000, 11.9935
;    odd 0.4820 (11) to 0.5000 (112), dist: 0.0000, 8.5211
;    even 0.5085 (115) to 0.5242 (22), dist: 57.6719, 0.0000
;    prime 0.5446 (24) to 0.5540 (67), dist: 232.6379, 0.0000

;(test-all-phases #f) in test-phases.scm

#|
:(test-all-phases #f)
;all peaks... Sat 04-Apr-2015 16:17
(0.001495737399423547 101)
;odd peaks... Sat 04-Apr-2015 16:24
(0.001687315629258279 125)
;even peaks... Sat 04-Apr-2015 16:28
(0.001467169674692848 4)
;prime peaks... Sat 04-Apr-2015 16:31
;all done! Sat 04-Apr-2015 16:37
|#

;;; gad161: clean-up-evens
;;; t139.scm: show-circle (Motif-based)
;;; t283.scm: poly stuff
;;; tmp26.scm sqrt graph
;;; t404.scm for averages, graphed via graph-averages.scm
;;; t405.scm for function searcher
