/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.GeoPointTermQuery;
import org.apache.lucene.search.GeoPointTermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.GeoUtils;
import org.apache.lucene.util.ToStringUtils;

class GeoPointInBBoxQueryImpl
extends GeoPointTermQuery {
    GeoPointInBBoxQueryImpl(String field, double minLon, double minLat, double maxLon, double maxLat) {
        super(field, minLon, minLat, maxLon, maxLat);
    }

    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new GeoPointInBBoxTermsEnum(terms.iterator(), this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInBBoxQueryImpl that = (GeoPointInBBoxQueryImpl)((Object)o);
        if (Double.compare(that.maxLat, this.maxLat) != 0) {
            return false;
        }
        if (Double.compare(that.maxLon, this.maxLon) != 0) {
            return false;
        }
        if (Double.compare(that.minLat, this.minLat) != 0) {
            return false;
        }
        return Double.compare(that.minLon, this.minLon) == 0;
    }

    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").append(ToStringUtils.boost((float)this.getBoost())).toString();
    }

    protected class GeoPointInBBoxTermsEnum
    extends GeoPointTermsEnum {
        protected GeoPointInBBoxTermsEnum(TermsEnum tenum, double minLon, double minLat, double maxLon, double maxLat) {
            super(tenum, minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectCrosses(minLon, minLat, maxLon, maxLat, this.minLon, this.minLat, this.maxLon, this.maxLat);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectWithin(minLon, minLat, maxLon, maxLat, this.minLon, this.minLat, this.maxLon, this.maxLat);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellIntersectsMBR(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return GeoUtils.bboxContains(lon, lat, this.minLon, this.minLat, this.maxLon, this.maxLat);
        }
    }
}

