/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class NestedParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalNested.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String path = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
        }
        if (path == null) {
            throw new SearchParseException(context, "Missing [path] field for nested aggregation [" + aggregationName + "]", parser.getTokenLocation());
        }
        return new NestedAggregator.Factory(aggregationName, path);
    }
}

