/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.FontInfo;

public class CharBox
extends Box {
    private final CharFont cf;
    private final float size;
    private final char[] arr = new char[1];

    public CharBox(Char char_) {
        this.cf = char_.getCharFont();
        this.size = char_.getMetrics().getSize();
        this.width = char_.getWidth();
        this.height = char_.getHeight();
        this.depth = char_.getDepth();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.drawDebug(graphics2D, f, f2);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f, f2);
        Font font = FontInfo.getFont(this.cf.fontId);
        if (this.size != 1.0f) {
            graphics2D.scale(this.size, this.size);
        }
        if (graphics2D.getFont() != font) {
            graphics2D.setFont(font);
        }
        this.arr[0] = this.cf.c;
        graphics2D.drawChars(this.arr, 0, 1, 0, 0);
        graphics2D.setTransform(affineTransform);
    }

    public int getLastFontId() {
        return this.cf.fontId;
    }

    public String toString() {
        return super.toString() + "=" + this.cf.c;
    }
}

