/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;

public class FontInfo {
    public static final int NUMBER_OF_CHAR_CODES = 256;
    private static Map<Integer, FontInfo> fonts = new HashMap<Integer, FontInfo>();
    private final int fontId;
    private Font font;
    private final Object base;
    private final String path;
    private final String fontName;
    private final Map<CharCouple, Character> lig = new HashMap<CharCouple, Character>();
    private final Map<CharCouple, Float> kern = new HashMap<CharCouple, Float>();
    private float[][] metrics;
    private CharFont[] nextLarger;
    private int[][] extensions;
    private HashMap<Character, Character> unicode = null;
    private char skewChar = (char)65535;
    private final float xHeight;
    private final float space;
    private final float quad;
    private int boldId;
    private int romanId;
    private int ssId;
    private int ttId;
    private int itId;
    protected final String boldVersion;
    protected final String romanVersion;
    protected final String ssVersion;
    protected final String ttVersion;
    protected final String itVersion;

    public FontInfo(int n, Object object, String string, String string2, int n2, float f, float f2, float f3, String string3, String string4, String string5, String string6, String string7) {
        this.fontId = n;
        this.base = object;
        this.path = string;
        this.fontName = string2;
        this.xHeight = f;
        this.space = f2;
        this.quad = f3;
        this.boldVersion = string3;
        this.romanVersion = string4;
        this.ssVersion = string5;
        this.ttVersion = string6;
        this.itVersion = string7;
        int n3 = 256;
        if (n2 != 0) {
            this.unicode = new HashMap(n2);
            n3 = n2;
        }
        this.metrics = new float[n3][];
        this.nextLarger = new CharFont[n3];
        this.extensions = new int[n3][];
        fonts.put(n, this);
    }

    public void addKern(char c, char c2, float f) {
        this.kern.put(new CharCouple(c, c2), new Float(f));
    }

    public void addLigature(char c, char c2, char c3) {
        this.lig.put(new CharCouple(c, c2), new Character(c3));
    }

    public int[] getExtension(char c) {
        if (this.unicode == null) {
            return this.extensions[c];
        }
        return this.extensions[this.unicode.get(Character.valueOf(c)).charValue()];
    }

    public float getKern(char c, char c2, float f) {
        Float f2 = this.kern.get(new CharCouple(c, c2));
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue() * f;
    }

    public CharFont getLigature(char c, char c2) {
        Character c3 = this.lig.get(new CharCouple(c, c2));
        if (c3 == null) {
            return null;
        }
        return new CharFont(c3.charValue(), this.fontId);
    }

    public float[] getMetrics(char c) {
        if (this.unicode == null) {
            return this.metrics[c];
        }
        return this.metrics[this.unicode.get(Character.valueOf(c)).charValue()];
    }

    public CharFont getNextLarger(char c) {
        if (this.unicode == null) {
            return this.nextLarger[c];
        }
        return this.nextLarger[this.unicode.get(Character.valueOf(c)).charValue()];
    }

    public float getQuad(float f) {
        return this.quad * f;
    }

    public char getSkewChar() {
        return this.skewChar;
    }

    public float getSpace(float f) {
        return this.space * f;
    }

    public float getXHeight(float f) {
        return this.xHeight * f;
    }

    public boolean hasSpace() {
        return this.space > 1.0E-7f;
    }

    public void setExtension(char c, int[] nArray) {
        if (this.unicode == null) {
            this.extensions[c] = nArray;
        } else if (!this.unicode.containsKey(Character.valueOf(c))) {
            char c2 = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(c), Character.valueOf(c2));
            this.extensions[c2] = nArray;
        } else {
            this.extensions[this.unicode.get((Object)Character.valueOf((char)c)).charValue()] = nArray;
        }
    }

    public void setMetrics(char c, float[] fArray) {
        if (this.unicode == null) {
            this.metrics[c] = fArray;
        } else if (!this.unicode.containsKey(Character.valueOf(c))) {
            char c2 = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(c), Character.valueOf(c2));
            this.metrics[c2] = fArray;
        } else {
            this.metrics[this.unicode.get((Object)Character.valueOf((char)c)).charValue()] = fArray;
        }
    }

    public void setNextLarger(char c, char c2, int n) {
        if (this.unicode == null) {
            this.nextLarger[c] = new CharFont(c2, n);
        } else if (!this.unicode.containsKey(Character.valueOf(c))) {
            char c3 = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(c), Character.valueOf(c3));
            this.nextLarger[c3] = new CharFont(c2, n);
        } else {
            this.nextLarger[this.unicode.get((Object)Character.valueOf((char)c)).charValue()] = new CharFont(c2, n);
        }
    }

    public void setSkewChar(char c) {
        this.skewChar = c;
    }

    public int getId() {
        return this.fontId;
    }

    public int getBoldId() {
        return this.boldId;
    }

    public int getRomanId() {
        return this.romanId;
    }

    public int getTtId() {
        return this.ttId;
    }

    public int getItId() {
        return this.itId;
    }

    public int getSsId() {
        return this.ssId;
    }

    public void setSsId(int n) {
        this.ssId = n == -1 ? this.fontId : n;
    }

    public void setTtId(int n) {
        this.ttId = n == -1 ? this.fontId : n;
    }

    public void setItId(int n) {
        this.itId = n == -1 ? this.fontId : n;
    }

    public void setRomanId(int n) {
        this.romanId = n == -1 ? this.fontId : n;
    }

    public void setBoldId(int n) {
        this.boldId = n == -1 ? this.fontId : n;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.base == null ? DefaultTeXFontParser.createFont(this.path) : DefaultTeXFontParser.createFont(this.base.getClass().getResourceAsStream(this.path), this.fontName);
        }
        return this.font;
    }

    public static Font getFont(int n) {
        return fonts.get(n).getFont();
    }

    private class CharCouple {
        private final char left;
        private final char right;

        CharCouple(char c, char c2) {
            this.left = c;
            this.right = c2;
        }

        public boolean equals(Object object) {
            CharCouple charCouple = (CharCouple)object;
            return this.left == charCouple.left && this.right == charCouple.right;
        }

        public int hashCode() {
            return (this.left + this.right) % 128;
        }
    }
}

