/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.jlatexmath.FramedBox;

public class ShadowBox
extends FramedBox {
    private float shadowRule;

    public ShadowBox(FramedBox framedBox, float f) {
        super(framedBox.box, framedBox.thickness, framedBox.space);
        this.shadowRule = f;
        this.depth += f;
        this.width += f;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = this.thickness / 2.0f;
        this.box.draw(graphics2D, f + this.space + this.thickness, f2);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(this.thickness, 0, 0));
        graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - this.height + f3, this.width - this.shadowRule - this.thickness, this.height + this.depth - this.shadowRule - this.thickness));
        float f4 = (float)Math.abs(1.0 / graphics2D.getTransform().getScaleX());
        graphics2D.setStroke(new BasicStroke(f4, 0, 0));
        graphics2D.fill(new Rectangle2D.Float(f + this.shadowRule - f4, f2 + this.depth - this.shadowRule - f4, this.width - this.shadowRule, this.shadowRule));
        graphics2D.fill(new Rectangle2D.Float(f + this.width - this.shadowRule - f4, f2 - this.height + f3 + this.shadowRule, this.shadowRule, this.depth + this.height - 2.0f * this.shadowRule - f3));
        graphics2D.setStroke(stroke);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

