/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Optional;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInitializerContext<T, P, O> {
    private final ModelType<T> modelType;
    private final Optional<PropertyContext<P, O>> propertyContextOptional;

    public NodeInitializerContext(ModelType<T> modelType, Optional<PropertyContext<P, O>> propertyContextOptional) {
        this.modelType = modelType;
        this.propertyContextOptional = propertyContextOptional;
    }

    public static <T, P, O> NodeInitializerContext<T, P, O> forType(ModelType<T> modelType) {
        return new NodeInitializerContext<T, P, O>(modelType, Optional.absent());
    }

    public static <T, P, O> NodeInitializerContext<T, P, O> forProperty(ModelType<T> modelType, ModelProperty<P> modelProperty, ModelType<O> containingType) {
        return new NodeInitializerContext<T, P, O>(modelType, Optional.of(new PropertyContext(modelProperty, containingType)));
    }

    public ModelType<T> getModelType() {
        return this.modelType;
    }

    public Optional<PropertyContext<P, O>> getPropertyContextOptional() {
        return this.propertyContextOptional;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyContext<P, O> {
        private final ModelProperty<P> modelProperty;
        private final ModelType<O> declaringType;

        private PropertyContext(ModelProperty<P> modelProperty, ModelType<O> declaringType) {
            this.modelProperty = modelProperty;
            this.declaringType = declaringType;
        }

        public ModelProperty<P> getModelProperty() {
            return this.modelProperty;
        }

        public ModelType<O> getDeclaringType() {
            return this.declaringType;
        }
    }
}

