/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collection;
import org.gradle.api.Named;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ReadonlyImmutableManagedPropertyException;
import org.gradle.model.internal.inspect.UnmanagedPropertyMissingSetterException;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.SpecializedMapSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedModelInitializer<T>
implements NodeInitializer {
    protected final StructSchema<T> schema;

    public AbstractManagedModelInitializer(StructSchema<T> schema) {
        this.schema = schema;
    }

    protected void addPropertyLinks(MutableModelNode modelNode, NodeInitializerRegistry nodeInitializerRegistry, ManagedProxyFactory proxyFactory, Collection<ModelProperty<?>> properties, TypeConverter typeConverter) {
        ModelProperty<?> nameProperty;
        for (ModelProperty<?> property : properties) {
            this.addPropertyLink(modelNode, property, nodeInitializerRegistry, proxyFactory, typeConverter);
        }
        if (this.isANamedType() && (nameProperty = this.schema.getProperty("name")) != null && nameProperty.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED) && properties.contains(nameProperty)) {
            MutableModelNode nameLink = modelNode.getLink("name");
            if (nameLink == null) {
                throw new IllegalStateException("expected name node for " + modelNode.getPath());
            }
            nameLink.setPrivateData(ModelType.of(String.class), modelNode.getPath().getName());
        }
    }

    private <P> void addPropertyLink(MutableModelNode modelNode, ModelProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        if (!property.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
            return;
        }
        ModelType<P> propertyType = property.getType();
        ModelSchema<P> propertySchema = property.getSchema();
        this.validateProperty(propertySchema, property, nodeInitializerRegistry);
        ModelRuleDescriptor descriptor = modelNode.getDescriptor();
        ModelPath childPath = modelNode.getPath().child(property.getName());
        if (propertySchema instanceof ManagedImplSchema) {
            if (!property.isWritable()) {
                ModelRegistration registration = ModelRegistrations.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertySchema.getType(), property, this.schema.getType()))).descriptor(descriptor).build();
                modelNode.addLink(registration);
            } else if (propertySchema instanceof ScalarCollectionSchema) {
                ModelRegistration registration = ModelRegistrations.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertySchema.getType(), property, this.schema.getType()))).descriptor(descriptor).build();
                modelNode.addLink(registration);
            } else {
                ManagedImplStructSchema structSchema = (ManagedImplStructSchema)propertySchema;
                ManagedModelProjection projection = new ManagedModelProjection(structSchema, null, proxyFactory, typeConverter);
                ModelRegistration registration = ModelRegistrations.of(childPath).withProjection(projection).descriptor(descriptor).build();
                modelNode.addReference(registration);
            }
        } else {
            UnmanagedModelProjection<P> projection = new UnmanagedModelProjection<P>(propertyType, true, true);
            ModelRegistrations.Builder registrationBuilder = this.shouldHaveANodeInitializer(property, propertySchema) ? ModelRegistrations.of(childPath, nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forProperty(propertyType, property, this.schema.getType()))) : ModelRegistrations.of(childPath);
            registrationBuilder.withProjection(projection).descriptor(descriptor);
            modelNode.addLink(registrationBuilder.build());
        }
    }

    private <P> void validateProperty(ModelSchema<P> propertySchema, ModelProperty<P> property, NodeInitializerRegistry nodeInitializerRegistry) {
        if (propertySchema instanceof ManagedImplSchema) {
            if (!property.isWritable()) {
                if (propertySchema instanceof CollectionSchema && !(propertySchema instanceof ScalarCollectionSchema) && !(propertySchema instanceof SpecializedMapSchema)) {
                    CollectionSchema propertyCollectionsSchema = (CollectionSchema)propertySchema;
                    ModelType elementType = propertyCollectionsSchema.getElementType();
                    nodeInitializerRegistry.ensureHasInitializer(NodeInitializerContext.forProperty(elementType, property, this.schema.getType()));
                }
                if (property.isDeclaredAsHavingUnmanagedType()) {
                    throw new UnmanagedPropertyMissingSetterException(property);
                }
            }
        } else if (!(this.shouldHaveANodeInitializer(property, propertySchema) || property.isWritable() || this.isNamePropertyOfANamedType(property))) {
            throw new ReadonlyImmutableManagedPropertyException(this.schema.getType(), property.getName(), property.getType());
        }
    }

    private <P> boolean isNamePropertyOfANamedType(ModelProperty<P> property) {
        return this.isANamedType() && "name".equals(property.getName());
    }

    public boolean isANamedType() {
        return Named.class.isAssignableFrom(this.schema.getType().getRawClass());
    }

    private <P> boolean shouldHaveANodeInitializer(ModelProperty<P> property, ModelSchema<P> propertySchema) {
        return !(propertySchema instanceof ScalarValueSchema) && !property.isDeclaredAsHavingUnmanagedType();
    }
}

