/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.CandidateMethods;
import org.gradle.model.internal.manage.schema.extract.MethodType;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructSchemaExtractionStrategySupport
implements ModelSchemaExtractionStrategy {
    private final ModelSchemaAspectExtractor aspectExtractor;

    protected StructSchemaExtractionStrategySupport(ModelSchemaAspectExtractor aspectExtractor) {
        this.aspectExtractor = aspectExtractor;
    }

    public <R> void extract(ModelSchemaExtractionContext<R> extractionContext) {
        ModelType<R> type = extractionContext.getType();
        if (!this.isTarget(type)) {
            return;
        }
        this.validateTypeHierarchy(extractionContext, type);
        CandidateMethods candidateMethods = ModelSchemaUtils.getCandidateMethods(type.getRawClass());
        this.validateMethodDeclarationHierarchy(extractionContext, candidateMethods);
        Iterable<ModelPropertyExtractionContext> candidateProperties = this.selectProperties(extractionContext, candidateMethods);
        this.validateProperties(extractionContext, candidateProperties);
        List<ModelPropertyExtractionResult<?>> extractedProperties = this.extractProperties(extractionContext, candidateProperties);
        List<ModelSchemaAspect> aspects = this.aspectExtractor.extract(extractionContext, extractedProperties);
        ModelSchema<R> schema = this.createSchema(extractionContext, extractedProperties, aspects);
        for (ModelPropertyExtractionResult<?> propertyResult : extractedProperties) {
            this.toPropertyExtractionContext(extractionContext, propertyResult);
        }
        extractionContext.found(schema);
    }

    protected abstract boolean isTarget(ModelType<?> var1);

    protected abstract <R> void validateTypeHierarchy(ModelSchemaExtractionContext<R> var1, ModelType<R> var2);

    protected abstract void validateMethodDeclarationHierarchy(ModelSchemaExtractionContext<?> var1, CandidateMethods var2);

    private Iterable<ModelPropertyExtractionContext> selectProperties(final ModelSchemaExtractionContext<?> context, CandidateMethods candidateMethods) {
        TreeMap propertiesMap = Maps.newTreeMap();
        for (Map.Entry<Equivalence.Wrapper<Method>, Collection<Method>> entry : candidateMethods.allMethods().entrySet()) {
            Method method = (Method)entry.getKey().get();
            MethodType methodType = MethodType.of(method);
            Collection<Method> methodsWithEqualSignature = entry.getValue();
            if (MethodType.NON_PROPERTY == methodType) {
                this.handleNonPropertyMethod(context, methodsWithEqualSignature);
                continue;
            }
            String propertyName = methodType.propertyNameFor(method);
            ModelPropertyExtractionContext propertyContext = (ModelPropertyExtractionContext)propertiesMap.get(propertyName);
            if (propertyContext == null) {
                propertyContext = new ModelPropertyExtractionContext(propertyName);
                propertiesMap.put(propertyName, propertyContext);
            }
            if (MethodType.GET_GETTER == methodType) {
                propertyContext.setGetGetter(new PropertyAccessorExtractionContext(methodsWithEqualSignature));
                continue;
            }
            if (MethodType.IS_GETTER == methodType) {
                propertyContext.setIsGetter(new PropertyAccessorExtractionContext(methodsWithEqualSignature));
                continue;
            }
            propertyContext.setSetter(new PropertyAccessorExtractionContext(methodsWithEqualSignature));
        }
        return Collections2.filter(propertiesMap.values(), (Predicate)new Predicate<ModelPropertyExtractionContext>(){

            public boolean apply(ModelPropertyExtractionContext property) {
                return StructSchemaExtractionStrategySupport.this.selectProperty(context, property);
            }
        });
    }

    protected abstract void handleNonPropertyMethod(ModelSchemaExtractionContext<?> var1, Collection<Method> var2);

    protected abstract boolean selectProperty(ModelSchemaExtractionContext<?> var1, ModelPropertyExtractionContext var2);

    private void validateProperties(ModelSchemaExtractionContext<?> context, Iterable<ModelPropertyExtractionContext> properties) {
        for (ModelPropertyExtractionContext property : properties) {
            Method isMethod;
            PropertyAccessorExtractionContext getGetter = property.getGetGetter();
            PropertyAccessorExtractionContext isGetter = property.getIsGetter();
            if (getGetter != null && isGetter != null) {
                Method getMethod = getGetter.getMostSpecificDeclaration();
                Method isMethod2 = isGetter.getMostSpecificDeclaration();
                if (getMethod.getReturnType() != Boolean.TYPE || isMethod2.getReturnType() != Boolean.TYPE) {
                    this.handleInvalidGetter(context, isMethod2, String.format("property '%s' has both '%s()' and '%s()' getters, but they don't both return a boolean", property.getPropertyName(), isMethod2.getName(), getMethod.getName()));
                }
            }
            if (isGetter != null && (isMethod = isGetter.getMostSpecificDeclaration()).getReturnType() != Boolean.TYPE) {
                this.handleInvalidGetter(context, isMethod, "getter method name must start with 'get'");
            }
            this.validateProperty(context, property);
        }
    }

    protected abstract void handleInvalidGetter(ModelSchemaExtractionContext<?> var1, Method var2, String var3);

    protected abstract void validateProperty(ModelSchemaExtractionContext<?> var1, ModelPropertyExtractionContext var2);

    private List<ModelPropertyExtractionResult<?>> extractProperties(ModelSchemaExtractionContext<?> context, Iterable<ModelPropertyExtractionContext> properties) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModelPropertyExtractionContext propertyContext : properties) {
            builder.add(this.extractProperty(context, propertyContext));
        }
        return builder.build();
    }

    private <R> ModelPropertyExtractionResult<R> extractProperty(ModelSchemaExtractionContext<?> context, ModelPropertyExtractionContext property) {
        WeaklyTypeReferencingMethod<?, Void> setterRef;
        PropertyAccessorExtractionContext gettersContext = property.mergeGetters();
        final ModelType returnType = ModelType.returnType(gettersContext.getMostSpecificDeclaration());
        PropertyAccessorExtractionContext setterContext = property.getSetter();
        if (setterContext != null) {
            Method mostSpecificDeclaration = setterContext.getMostSpecificDeclaration();
            setterRef = WeaklyTypeReferencingMethod.of(ModelType.of(mostSpecificDeclaration.getDeclaringClass()), ModelType.of(Void.TYPE), mostSpecificDeclaration);
        } else {
            setterRef = null;
        }
        ImmutableSet declaringClasses = ImmutableSet.copyOf((Iterable)Iterables.transform(gettersContext.getDeclaringMethods(), (Function)new Function<Method, ModelType<?>>(){

            public ModelType<?> apply(Method input) {
                return ModelType.of(input.getDeclaringClass());
            }
        }));
        ArrayList getterRefs = Lists.newArrayList((Iterable)Iterables.transform(gettersContext.getGetters(), (Function)new Function<Method, WeaklyTypeReferencingMethod<?, R>>(){

            public WeaklyTypeReferencingMethod<?, R> apply(Method getter) {
                return WeaklyTypeReferencingMethod.of(ModelType.of(getter.getDeclaringClass()), returnType, getter);
            }
        }));
        ModelProperty.StateManagementType stateManagementType = this.determineStateManagementType(context, gettersContext);
        boolean declaredAsHavingUnmanagedType = gettersContext.getAnnotation(Unmanaged.class) != null;
        return new ModelPropertyExtractionResult(new ModelProperty(returnType, property.getPropertyName(), stateManagementType, (Set<ModelType<?>>)declaringClasses, getterRefs, setterRef, declaredAsHavingUnmanagedType), gettersContext, setterContext);
    }

    protected abstract ModelProperty.StateManagementType determineStateManagementType(ModelSchemaExtractionContext<?> var1, PropertyAccessorExtractionContext var2);

    private <R, P> void toPropertyExtractionContext(ModelSchemaExtractionContext<R> parentContext, ModelPropertyExtractionResult<P> propertyResult) {
        ModelProperty<P> property = propertyResult.getProperty();
        String propertyDescription = this.propertyDescription(parentContext, property);
        Action<ModelSchema<P>> propertyValidator = this.createPropertyValidator(parentContext, propertyResult);
        parentContext.child(property.getType(), propertyDescription, this.attachSchema(property, propertyValidator));
    }

    private <P> Action<? super ModelSchema<P>> attachSchema(final ModelProperty<P> property, final Action<ModelSchema<P>> propertyValidator) {
        return new Action<ModelSchema<P>>(){

            public void execute(ModelSchema<P> propertySchema) {
                property.setSchema(propertySchema);
                propertyValidator.execute(propertySchema);
            }
        };
    }

    private String propertyDescription(ModelSchemaExtractionContext<?> parentContext, ModelProperty<?> property) {
        if (property.getDeclaredBy().size() == 1 && property.getDeclaredBy().contains(parentContext.getType())) {
            return String.format("property '%s'", property.getName());
        }
        ImmutableSortedSet declaredBy = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(property.getDeclaredBy(), (Function)Functions.toStringFunction()));
        return String.format("property '%s' declared by %s", property.getName(), Joiner.on((String)", ").join((Iterable)declaredBy));
    }

    protected abstract <P> Action<ModelSchema<P>> createPropertyValidator(ModelSchemaExtractionContext<?> var1, ModelPropertyExtractionResult<P> var2);

    protected abstract <R> ModelSchema<R> createSchema(ModelSchemaExtractionContext<R> var1, Iterable<ModelPropertyExtractionResult<?>> var2, Iterable<ModelSchemaAspect> var3);
}

