/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestClassScanner;
import org.gradle.api.internal.tasks.testing.detection.TestExecuter;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestClassProcessor;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.progress.OperationIdGenerator;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestExecuter
implements TestExecuter {
    private final Factory<WorkerProcessBuilder> workerFactory;
    private final ActorFactory actorFactor;

    public DefaultTestExecuter(Factory<WorkerProcessBuilder> workerFactory, ActorFactory actorFactor) {
        this.workerFactory = workerFactory;
        this.actorFactor = actorFactor;
    }

    @Override
    public void execute(final Test testTask, TestResultProcessor testResultProcessor) {
        DefaultTestClassScanner detector;
        final TestFramework testFramework = testTask.getTestFramework();
        final WorkerTestClassProcessorFactory testInstanceFactory = testFramework.getProcessorFactory();
        Factory<TestClassProcessor> forkingProcessorFactory = new Factory<TestClassProcessor>(){

            public TestClassProcessor create() {
                return new ForkingTestClassProcessor((Factory<WorkerProcessBuilder>)DefaultTestExecuter.this.workerFactory, testInstanceFactory, testTask, (Iterable<File>)testTask.getClasspath(), testFramework.getWorkerConfigurationAction());
            }
        };
        Factory<TestClassProcessor> reforkingProcessorFactory = new Factory<TestClassProcessor>((Factory)forkingProcessorFactory, testTask){
            final /* synthetic */ Factory val$forkingProcessorFactory;
            final /* synthetic */ Test val$testTask;
            {
                this.val$forkingProcessorFactory = factory;
                this.val$testTask = test;
            }

            public TestClassProcessor create() {
                return new RestartEveryNTestClassProcessor((Factory<TestClassProcessor>)this.val$forkingProcessorFactory, this.val$testTask.getForkEvery());
            }
        };
        MaxNParallelTestClassProcessor processor = new MaxNParallelTestClassProcessor(testTask.getMaxParallelForks(), reforkingProcessorFactory, this.actorFactor);
        FileTree testClassFiles = testTask.getCandidateClassFiles();
        if (testTask.isScanForTestClasses()) {
            TestFrameworkDetector testFrameworkDetector = testTask.getTestFramework().getDetector();
            testFrameworkDetector.setTestClassesDirectory(testTask.getTestClassesDir());
            testFrameworkDetector.setTestClasspath(testTask.getClasspath());
            detector = new DefaultTestClassScanner(testClassFiles, testFrameworkDetector, processor);
        } else {
            detector = new DefaultTestClassScanner(testClassFiles, null, processor);
        }
        Object testTaskOperationId = OperationIdGenerator.generateId((Task)testTask);
        new TestMainAction(detector, processor, testResultProcessor, (TimeProvider)new TrueTimeProvider(), testTaskOperationId, testTask.getPath(), String.format("Gradle Test Run %s", testTask.getPath())).run();
    }
}

