/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.AggregateMultiProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.DefaultGroupTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.SingleProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportRenderer;

public class TaskReportTask
extends AbstractReportTask {
    private TaskReportRenderer renderer = new TaskReportRenderer();
    private boolean detail;

    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TaskReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Option(option="all", description="Show additional tasks and detail.")
    public void setShowDetail(boolean detail) {
        this.detail = detail;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void generate(Project project) throws IOException {
        this.renderer.showDetail(this.isDetail());
        this.renderer.addDefaultTasks(project.getDefaultTasks());
        AggregateMultiProjectTaskReportModel aggregateModel = new AggregateMultiProjectTaskReportModel(!this.isDetail());
        TaskDetailsFactory taskDetailsFactory = new TaskDetailsFactory(project);
        SingleProjectTaskReportModel projectTaskModel = new SingleProjectTaskReportModel(taskDetailsFactory);
        projectTaskModel.build(this.getProjectTaskLister().listProjectTasks(project));
        aggregateModel.add(projectTaskModel);
        for (Project subproject : project.getSubprojects()) {
            SingleProjectTaskReportModel subprojectTaskModel = new SingleProjectTaskReportModel(taskDetailsFactory);
            subprojectTaskModel.build(this.getProjectTaskLister().listProjectTasks(subproject));
            aggregateModel.add(subprojectTaskModel);
        }
        aggregateModel.build();
        DefaultGroupTaskReportModel model = new DefaultGroupTaskReportModel();
        model.build(aggregateModel);
        for (String group : model.getGroups()) {
            this.renderer.startTaskGroup(group);
            for (TaskDetails task : model.getTasksForGroup(group)) {
                this.renderer.addTask(task);
                for (TaskDetails child : task.getChildren()) {
                    this.renderer.addChildTask(child);
                }
            }
        }
        this.renderer.completeTasks();
        for (Rule rule : project.getTasks().getRules()) {
            this.renderer.addRule(rule);
        }
    }

    @Inject
    protected ProjectTaskLister getProjectTaskLister() {
        throw new UnsupportedOperationException();
    }
}

